unit gossgui;

interface
{$ifdef gui4} {$define gui3} {$define gamecore}{$endif}
{$ifdef gui3} {$define gui2} {$define net} {$define ipsec} {$endif}
{$ifdef gui2} {$define gui}  {$define jpeg} {$endif}
{$ifdef gui} {$define snd} {$endif}
{$ifdef con3} {$define con2} {$define net} {$define ipsec} {$endif}
{$ifdef con2} {$define jpeg} {$endif}
{$ifdef fpc} {$mode delphi}{$define laz} {$define d3laz} {$undef d3} {$else} {$define d3} {$define d3laz} {$undef laz} {$endif}
uses gosswin2, gossroot, gossimg, gossio {$ifdef snd},gosssnd{$endif} ,gosswin {$ifdef gui},gossdat{$endif};
{$align on}{$iochecks on}{$O+}{$W-}{$U+}{$V+}{$B-}{$X+}{$T-}{$P+}{$H+}{$J-} { set critical compiler conditionals for proper compilation - 10aug2025 }
//## ==========================================================================================================================================================================================================================
//##
//## MIT License
//##
//## Copyright 2025 Blaiz Enterprises ( http://www.blaizenterprises.com )
//##
//## Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
//## files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
//## modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
//## is furnished to do so, subject to the following conditions:
//##
//## The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
//##
//## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
//## OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
//## LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OfF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//##
//## ==========================================================================================================================================================================================================================
//## Library.................. GUI (gossgui.pas)
//## Version.................. 4.00.37410 (+5057)
//## Items.................... 52
//## Last Updated ............ 09nov2025, 06nov2025, 24oct2025, 08oct2025, 05oct2025, 29sep2025, 26sep2025, 18sep2025, 15sep2025, 09sep2025, 07sep2025, 28aug2025, 23aug2025, 15aug2025, 10aug2025, 08aug2025, 26jul2025, 24jul2025, 17jul2025, 14jul2025, 04jul2025, 16jun2025, 12jun2025, 09jun2025, 07jun2025, 03jun2025, 29may2025, 29apr2025, 13apr2025, 31mar2025, 24mar2025, 18feb2025, 28dec2024, 11dec2024, 29nov2024, 22nov2024, 15nov2024, 10nov2024, 04oct2024, 28aug2024, 01ug2024, 25jul2024, 28jun2024, 22mar2024, 09feb2024, 13dec2023, 25nov2023, 19may2023, 25feb2023, 30dec2022, 15nov2022, 06nov2022, 11oct2022, 28sep2022, 05jul2022, 29jun2022, 14jun2022, 31may2022, 14may2022, 30apr2022, 30mar2022, 27feb2022, 08feb2022, 31jan2021, 30dec2021,
//##                                      19dec2021, 30sep2021, 29aug2021, 09aug2021, 27jul2021, 07jul2021, 20jun2021, 02jun2021, 30may2021, 12may2021, 10may2021, 30apr2021, 19apr2021, 14apr2021, 03apr2021, 31mar2021, 20mar2021, 08mar2021, 26feb2021, 01feb2021, 28jan2021, 11oct2020, 25sep2020, 07sep2020, 26aug2020, 22aug2020, 28jul2020, 23may2020, 10may2020
//## Lines of Code............ 64,800+
//##
//## main.pas ................ app code
//## gossroot.pas ............ console/gui app startup and control
//## gossio.pas .............. file io
//## gossimg.pas ............. image/graphics
//## gossnet.pas ............. network
//## gosswin.pas ............. static Win32 api calls
//## gosswin2.pas ............ dynamic Win32 api calls
//## gosssnd.pas ............. sound/audio/midi/chimes
//## gossgui.pas ............. gui management/controls
//## gossdat.pas ............. app icons (24px and 20px) and help documents (gui only) in txt, bwd or bwp format
//## gosszip.pas ............. zip support
//## gossjpg.pas ............. jpeg support
//## gossgame.pas ............ game support (optional)
//## gamefiles.pas ........... internal files for game (optional)
//##
//## ==========================================================================================================================================================================================================================
//## Important Image Format Note:
//##
//## To modify or replace any of the embedded "tep_*" images below, e.g. "tep_copy20", any new images must be in the TEA image
//## format and packed in a binary pascal array.  A free gui tool is available at http://www.blaizenterprises.com/blaiztools.html
//## which provides one button actions for pasting and converting images into the TEA format as well as packing them into pascal arrays.
//##
//## ==========================================================================================================================================================================================================================
//## | Name                   | Hierarchy         | Version   | Date        | Update history / brief description of function
//## |------------------------|-------------------|-----------|-------------|--------------------------------------------------------
//## | low level procs        | n/a               | 1.00.1875 | 14sep2025   | Collection of basic procedures and functions to support platform and it's controls etc - 09sep2025, 05sep2025, 28aug2025, 23aug2025, 13mar2025, 11jan2025: ecomode now kicks in at 10min, 18dec2024, 17dec2024: low__font(), 11dec2024, 01dec2024: fixed font leak on Win98 for proc low__toLGF(), 26nov2024, 13dec2023, 19may2023, 11oct2022, 27sep2022, 14may2022, 21may2020
//## | compact__*             | family of procs   | 1.00.010  | 05sep2025   | Standardised compact scaling for system state "viCompact=true"
//## | system__*              | family of procs   | 1.00.050  | 13may2025   | System management and Windows message handling
//## | sysback__*             | family of procs   | 1.00.122  | 19aug2025   | Background image management procs (integrates with tbackgroundmanager) - 11apr2025, 18mar2025
//## | clip__*                | family of procs   | 1.00.369  | 01sep2025   | Clipboard copy/paste for text, image and wordcore - 08aug2025: fixed "cf_png" bad value, 12jun2025, 01jun2025, 01jun2025, 29apr2025, 17mar2025, 17dec2024
//## | canvas__*              | family of procs   | 1.00.050  | 01dec2024   | TCanvas abstraction procs
//## | cols_*                 | color schemes     | 1.00.450  | 09mar2025   | Collection of built-in color schemes
//## | tbasicprg1             | tobjectex         | 1.00.023  | 10aug2024   | Root level program outline - 01jan2021, 05oct2020
//## | tbasicprg2             | tbasicprg2        | 1.00.020  | 10aug2024   | Semi-managed program outline -> manages "system:tbasicsystem" and "rootwin:tbasicscroll" on host "xhost:tform1"
//## | tspell                 | tobjectex         | 1.00.150  | 11feb2022   | System dictionary of 296,000+ full length, non-encoded / non-shortened words
//## | trnd8                  | tobject           | 1.00.020  | 29nov2023   | Random stream generator
//## | tbackgroundmanager     | tobject           | 1.00.200  | 03jun2025   | Handles static, animated and dynamic background imagery for "tbasicsystem"
//## | tbasicsystem           | tobject           | 1.00.5330 | 09nov2025   | GUI rendering and control system - 08oct2025, 17sep2025, 09sep2025, 31aug2025, 27aug2025, 17aug2025, 10aug2025, 26jul2025, 04jul2025, 28may2025, 15may2025, 21apr2025, 18feb2025, 04feb2025: auto switches between using buffer 1+2 or only buffer 1 for optimal rendering, 28jan2025, 28nov2024: supports background exclusion areas, 21nov2024: background pauses for window resize/reposition, 18nov2024, 26jul2024m 28jun2024: fixed part paint, 09dec2023, 19nov2023, 12feb2023, 20may2022, 27mar2022: updated onaccept proc for deep drag and drop support, 26feb2022, Fixed ibuffer.w/h mismatch with mustmask - 21sep2021, 29aug2021, 28jul2021, 07jul2021, 18jun2021, 29may2021, 14apr2021, 03apr2021, 08mar2021, 25feb2021, 11oct2020, 28jul2020, 20may2020
//## | tbasiccontrol          | tobject           | 1.00.1133 | 05sep2025   | Flicker free base control with built-in _onnotify/_ontimer and _onpaint procs for easy customisation - 19jul2025, 03jul2025, 24may2025, 19apr2025, 31mar2025, 06jan2025, 25dec2024, 28nov2024, 19aug2024, 28jun2024: fixed ldso4 leak, 02dec2023: ldso4 cliparea handling, 17nov2023, 12jan2022, 09sep2021, 27mar2021, 11oct2020, 20may2020, 12apr2020, 14mar2020
//## | tbasicimgview          | tbasiccontrol     | 1.00.735  | 18feb2025   | Animated image viewer - 30jan2025, 26dec2024
//## | tbasichelp             | tbasiccontrol     | 1.00.100  | 16may2025   | Realtime help scroller - 02aug2024, 12apr2020, 25mar2020
//## | tbasicnav              | tbasiccontrol     | 1.00.1258 | 18sep2025   | Multi-purpose favorites/files/folders/open/save navigation control - 04sep2025, 05jun2025, 24jan2025, 28dec2024, 01dec2024: removed " - " from preview label,22nov2024, 20aug2024, 11feb2023, 11oct2022, 27sep2022, 28jun2022, 22may2022, 23mar2022, 12jan2022, 09aug2021, 28jul2021, 18jun2021, 06apr2021, 25mar2021, 22sep2020
//## | tbasicbwp              | tbasiccontrol     | 1.00.682  | 27aug2025   | GUI front-end for low__wordcore text box -> supports txt, bwd and bwp text documents - 20apr2025, 31mar2025, 17dec2024, 09dec2024: keyboard shortcut removed for "copy as plain text", 28aug2024, 18feb2023, 04oct2022, 24sep2022, 18jun2022, 29may2021, 12mar2021
//## | tbwpbar                | tbasiccontrol     | 1.00.120  | 15nov2023   | Font name / size / color and style toolbar for tbasicbwp text box
//## | tbasiccolor            | tbasiccontrol     | 1.00.365  | 24oct2025   | Color picker with optional shade ranges - 03feb2025, 09dec2024: xshadecolor24 proc for when low__capcolor fails, 09dec2024: tweaked color capture, 01mar2021
//## | tbasiccolormatrix      | tbasiccontrol     | 1.00.098  | 02feb2025   | Realtime drawn color matrix - 02feb2025: direct color grab within color matrix, 09dec2024, 09dec2024: tweaked color capture, 2021
//## | tbasiccolormixer       | tbasiccontrol     | 1.00.020  | 05sep2025   | Automatic color mixer for color dialog -> generate shades and mixes of orginal and current colors
//## | tbasicinfo             | tbasiccontrol     | 1.00.130  | 13apr2020   | Simple information list - 16mar2020
//## | tbasicstatus           | tbasiccontrol     | 1.00.143  | 26aug2024   | Simple statusbar - 26aug2024: ofast, 29dec2021, 07jul2021, 02jun2021, 05oct2020, 12apr2020, 15mar2020
//## | tbasicgradient         | tbasiccontrol     | 1.00.022  | 20may2025   | Window transistion gradient for soft edges such as bottom of toolbars on GUI etc - 20aug2024
//## | tmenutitle             | tbasiccontrol     | 1.00.020  | 24may2025   | Modern title that mimics "tbasicmenu.title" in size, coloring and position
//## | tbasictitle            | tbasiccontrol     | 1.00.060  | 04sep2025   | Standard title -> supports both small and large modes -> exactly matches tbasictoolbar.maketitle() display output - 11may2025, 08apr2025, 12jan2025, 19nov2023, 24feb2021, 11oct2020
//## | tbasicbreak            | tbasiccontrol     | 1.00.012  | 09mar2025   | 2021
//## | tbasicint              | tbasiccontrol     | 1.00.457  | 05sep2025   | Fast and responsive slide bar -> compact and easy to use - 16may2025, 14feb2025: makemiditranspose, 09jan2025, 12nov2022, 27mar2022, 27feb2022, 28jul2021, 27mar2021, 26feb2021, 17aug2020
//## | tsimpleint             | tbasiccontrol     | 1.00.138  | 09sep2025   | Fast and responsive slide bar -> compact and easy to use, simpler version - 05sep2025, 15aug2025, 11jul2025, 06jun2025
//## | tbasicset              | tbasiccontrol     | 1.00.303  | 08oct2025   | Upto 32 "yes/no" slots with boolean in/out for each slot -> compact multiple option chooser control - 05sep2025, 03jun2025, 16may2025, 25dec2022, 27mar2022, 30mar2021, 18aug2020
//## | tbasicsel              | tbasiccontrol     | 1.00.190  | 13sep2025   | Upto 32 "choose" positions with a value range of 0..31 -> each choice has help/caption for selecting a value range for a specific setting e.g. Text Feather 0=off, 1=mild, 2=strong - 09sep2025, 05sep2025, 21aug2025, 03jun2025,16may2025, 25dec2022, 18sep2022, 27mar2022, 29aug2021, 27mar2021, 19aug2020
//## | tbasicimageexts        | tbasiccontrol     | 1.00.025  | 21dec2024   | An action list for specific image formats -> to work with dialog windows
//## | tbasictea              | tbasiccontrol     | 1.00.168  | 12jan2025   | Mini TEA image view and adjustment editor - 2021
//## | tbasiccolors           | tbasiccontrol     | 1.00.550  | 24may2025   | Multi-color picker with system and static colors support - 09mar2025, 15mar2022, 19mar2021
//## | tbasictoolbar          | tbasiccontrol     | 1.00.3365 | 04sep2025   | Toolbar with "title + links" support - 20jul2025, 09jun2025, 26may2025, 24mar2025, 28dec2024, 27dec2024: upgraded to support Window Head functions, 21jul2024, 09dec2023, 03nov2023, 26sep2022, 28jun2022, 25mar2022, 19dec2021, 21sep2021, 07jul2021, 30may2021, 27mar2021, 21feb2021, 11oct2020, 22sep2020, 23apr2020, 29mar2020
//## | tbasicmenu             | tbasiccontrol     | 1.00.2890 | 04sep2025   | Menu handler - 28aug2025, 18aug2025, 03jul2025, 16may2025, 21dec2024, 17nov2024, 04oct2024, 20jul2024: soft back shade for title items, 28sep2022, 20mar2022, 26feb2022, 08jun2021, 27mar2021, 11oct2020, 13apr2020
//## | tbasicscrollbar        | tbasiccontrol     | 1.00.480  | 13sep2025   | Streamlined scrollbar with full and partial keyboard/wheel handling -> can pass critical handling to parent control for consistent operation - 04oct2022, 03mar2022, 08feb2022, 25jul2021, 13apr2020
//## | tbasicscroll           | tbasiccontrol     | 1.00.592  | 19jul2025   | Vertical scrollbox - 05jun2025, 14may2025, 17mar2025, 12jan2024, 17dec2024, 04oct2022, 02jun2021, 29may2021, 08mar2021, 25feb2021, 14aug2020, 05apr2020
//## | tbasicsetcolor         | tbasicscroll      | 1.00.742  | 18sep2025   | Color picker and support for "popcolor" dlg - 05sep2025, 28may2025, 01feb2025, 28jul2024: head background style, 01mar2021: created
//## | tbasiccols             | tbasiccontrol     | 1.00.480  | 27aug2025   | Multi-column handler - supports upto 10 columns - 14jul2025, 12jul2025, 16may2025, 09mar2025, 03feb205: remainder "units" support like html5, 17nov2024, 07mar2022, 26feb2021
//## | tbasiccells            | tbasiccontrol     | 1.00.100  |      2022   | Horizontal cell viewer / editor
//## | tbasicsplash           | tbasicscroll      | 1.00.600  | 13sep2025   | System splash screen and about window - 14jul2025, 08apr2025, 23mar2025, 09dec2024, 04dec2024: reworked for one mode with background mask support, 15nov2025, 20jul2024: fallback to icon art if no splash image, style=2=IconArt, 24feb2022, 21sep2021, 18jun2021, 05oct2020
//## | tbasictick             | tbasiccontrol     | 1.00.170  | 11apr2020   | Simple tick - 06apr2020
//## | tbasicedit             | tbasiccontrol     | 1.00.1128 | 20may2025   | Edit box, supports makers for edit/password/drop/dropstatic/progress -> simulates 5 controls in one with many useful features and functions - 20apr2025, 09mar2025, 01aug2024, 03mar2022, 31mar2021, 07apr2020
//## | tbasicjump             | tbasiccontrol     | 1.00.207  | 24oct2025   | Realtime jumpto panel for millisecond precision position jumping for song/midi playback - 16sep2025, 07sep2025, 27aug2025, 25jan2025, 06mar2022, 21feb2022, 22mar2021, 10mar2021
//## | tmainhelp              | tbasicscroll      | 1.00.237  | 24apr2025   | Built-in help display panel with BWP file support - 25dec2024, 27apr2022, 30mar2022, 08jan2022, 22sep2021, 24jul2021, 29may2021, 26aug2020
//## | tplaylist              | tobjectex         | 1.00.370  | 19aug2025   | Integrated m3u playlist manager - syncs with list for seamless playlist handling - 20mar2022
//## | low__wordcore*         | family of procs   | 1.00.5600 | 03jul2025   | Low-level (non-GUI) text box subsystem for 1) plain text (txt), 2) enhanced text with styles (bwd) and 3) advanced text (bwp) with image support, text styles, fonts, colors and text alignment, 4) RichText (support not completed yet) - 25may2025, 17mar2025: ..charinfoULTRA() proc upgraded for 200% speed increase, 17mar2025, 20dec2024, 19jul2024, 24jun2024, 02may2023, 02may2023 (fixed redo list flush failure), 25feb2023, 25dec2022, 27sep2022, 05jul2022, 29jun2022, 02may2022, 22apr2022 09mar2022, 05feb2022, 11jan2022, 28dec2021, 28aug2021, 15may2021, 31mar2021, 12mar2021, 11oct2020, 26aug2020, 29feb2020
//## | plus_* support         | family of procs   | 1.00.050  | 27jun2022   | Collection of procs for swift multi-tab "PLUS" version support
//## ==========================================================================================================================================================================================================================
//## Performance Note:
//##
//## The runtime compiler options "Range Checking" and "Overflow Checking", when enabled under Delphi 3
//## (Project > Options > Complier > Runtime Errors) slow down graphics calculations by about 50%,
//## causing ~2x more CPU to be consumed.  For optimal performance, these options should be disabled
//## when compiling.
//## ==========================================================================================================================================================================================================================

const
   static_lineheight36  =36;
   static_lineheight30  =30;

   //system references
   WM_USER              =$0400;//anything below this is reserved
   WM_MULTIMEDIA_TIMER  =WM_USER + 127;

   //system cursors
   scNone         =0;
   scDefault      =1;
   scArrow        =2;

   //special code2 internally processed links
   scPage         ='page:';//show a page
   scDlg          ='dlg:';//set a dlg reply
   scOptions      ='sys:options';//14aug2020
   scHelp         ='sys:help';
   scSplash       ='sys:splash';//2aug2020
   scAbout        ='sys:about';
   scMixer        ='sys:mixer';//07mar2022
   scMax          ='sys:max';//15mar2022
   scOntop        ='sys:ontop';//15mar2022
   scFindpop      ='sys:find.pop';//18feb2023
   scFind         ='sys:find';//18feb2023
   scPlus         ='plus~';//used to signal a plus orientated page control
   scVisitPortal  ='visit.portal';
   scVisitProgram ='visit.program';
   //own list -> special mode
   omfree         =maxword;
   //window modes
   wmControl      =0;//control is not a window
   wmFullwin      =1;//control is a window that "must" occupy entire screen always (e.g. app root form like Clic) and sits at bottom of window stack
   wmWindow       =2;//control is a window -> e.g. normal window or a tool window that sits above wmFullwin but below wmOntop
   wmOntop        =3;//control is an ontop window -> e.g. window sits above wmWindow but below wmDialog
   wmDialog       =4;//control is a dialog window -> e.g. sits above all other window types
   wmMax          =4;

   //corner styles
   corNone        =0;//same as square - 29aug2020
   corRound       =1;
   corSlight      =2;
   corToSquare    =3;//finished with inner area as a perfect square
   corSlight2     =4;
   corMax         =4;
   //borderstyles
   bsInternal     =0;
   bsSystem100    =1;
   bsSystem50     =2;
   bsSystem20     =3;
   bsMax          =4;
   //-- WordCore Consts --------------------------------------------------------
   //.word wrap styles -> basicbwp and low__wordcore
   wwsNone        =0;
   wwsWindow      =1;
   wwsPage        =2;
   wwsPage2       =3;
   wwsMax         =3;
   //.multi-undo styles -> low__wordcore - 02jul2022
   musNone        =0;
   musDelL        =1;
   musDelR        =2;
   musIns         =3;
   musSel         =4;
   musSelKeep     =5;
   musRangeKeep   =6;//datastream size remains same, byte from1..xlen is replaced
   musRecovered   =7;
   musInsImg      =8;
   musMax         =8;
   //.musRecovered - actions
   muaRep         =0;
   muaAdd         =1;
   muaSub         =2;
   muaMax         =2;
   //.align styles
   wcaLeft        =0;
   wcaCenter      =1;
   wcaRight       =2;
   wcaMax         =2;

   //page sizes -> basicbwp and low__wordcore
   psA4           =0;
   psA3           =1;
   psA5           =2;
   psLetter       =3;
   psLegal        =4;
   psMax          =4;

   //OS Codes
   osMax          =6;
   osNone         =0;
   osW32          =1;//Windows 32bit
   osW64          =2;//Windows 64bit
   osA32          =1;//Android 32bit
   osA64          =2;//Android 64bit
   osL32          =3;//Linux 32bit
   osL64          =4;//Linux 64bit
   osM32          =5;//Apple Mac 32bit
   osM64          =6;//Apple Mac 64bit


   //tbasicccols -> styles
   bcLefttoright       =0;//was vertical
   bcRighttoleft       =1;//was vertical2
   bcToptobottom       =2;//was horizontal
   bcBottomtotop       =3;//was horizontal2
   bcMax               =3;

   //tbasicmenu -> menu styles
   lsmenu              =0;
   lslist              =1;
   lspanel             =2;//18aug2025
   lsmany              =3;
   lsmax               =3;

   //chime styles (storage)
   chmsTitle                    =0;
   chmsStandard                 =1;//Melody + Dong OR Dong only
   chmsBells                    =2;//Ships Bells OR Ships Bells - British Royal
   chmsSonnerie                 =3;//Grande Sonnerie OR Petite Sonnerie

   //wordcore -> char style codes
   wc_n                =0;//no style
   wc_t                =1;//text
   wc_i                =2;//image

   //tbasicimgview.fillstyle
   vfsDefault           =0;
   vfsScale             =0;
   vfsScreen            =1;
   vfsCrop              =2;
   vfsFit               =3;
   vfsEcho              =4;
   vfsEcho2             =5;
   vfsMax               =5;

   //background manager nameids
   bkmStrength          =0;
   bkmColorise          =1;
   bkmSpeed             =2;
   bkmHstep             =3;
   bkmVstep             =4;
   bkmFstep             =5;
   bkmHwobble           =6;
   bkmVwobble           =7;
   bkmFwobble           =8;
   bkmMax               =8;

   //tbasictoolbar -> special index items
   tsiStart             =0;
   tsiFinish            =6;
   tsiUser              =7;

   tsiAppicon           =0;
   tsiAppcap            =1;
   tsiMenu              =2;
   tsiFull              =3;
   tsiMin               =4;
   tsiMax               =5;
   tsiClose             =6;
   //.special text values
   tstSep               ='-';
   tstNewline           ='+';
   tstNewpartline       ='~';

   //special maker codes -> used by controls to detect what type of modified control they are running -> used when required - 23mar2022
   made_none           =0;
   made_wavevol        =1;
   made_midivol        =2;
   made_miditranspose  =3;
   
   //memory access and memory mapped file access -------------------------------
   PAGE_NOACCESS    = 1;
   PAGE_READONLY    = 2;
   PAGE_READWRITE   = 4;
   PAGE_WRITECOPY   = 8;

   FILE_MAP_COPY     = 1;
   FILE_MAP_WRITE    = 2;
   FILE_MAP_READ     = 4;
   FILE_MAP_READWRITE=FILE_MAP_COPY or FILE_MAP_WRITE or FILE_MAP_READ;


//managed states
   msFree      =0;
   msHold      =1;
   msQueued    =2;
   msWorking   =3;
   msFinished  =4;
//playback modes
   mmOnce              =0;
   mmRepeatOne         =1;
   mmRepeatAll         =2;
   mmAllOnce           =3;
   mmRandom            =4;
   mmMax               =4;


//system cursors - 27may2025, 29aug2021 ----------------------------------------
//.128x128 high-res cursor with feathering
cur_template_arrow128
:array[0..1932] of byte=(
120,1,236,221,47,86,100,71,20,6,240,206,46,178,132,89,193,44,32,62,50,11,153,29,100,3,217,2,2,129,64,32,16,8,68,206,28,4,2,17,129,64,32,16,8,68,4,2,129,64,48,249,120,23,238,191,170,87,239,117,247,163,167,243,222,87,135,97,170,154,166,105,126,245,245,173,251,96,114,242,219,239,95,191,175,186,241,21,239,191,224,207,159,239,127,126,89,253,138,25,198,247,238,125,122,247,99,181,226,27,5,40,64,1,10,80,128,2,20,160,0,5,40,64,1,10,80,128,2,20,160,0,5,40,64,1,10,80,128,2,20,160,0,5,40,64,1,10,80,128,2,20,160,0,5,40,64,1,10,80,128,2,20,160,0,5,40,64,1,10,80,128,2,20,160,0,5,40,64,1,10,44,65,224,126,181,146,183,37,124,179,123,248,61,94,118,255,129,223,95,171,21,38,216,136,61,124,134,51,126,74,0,135,188,14,238,194,142,247,90,194,175,254,50,225,46,52,118,97,194,42,145,194,207,93,104,176,235,135,160,116,60,81,161,174,134,159,187,160,212,213,137,248,108,191,5,237,240,115,23,170,248,184,81,199,150,91,144,195,127,127,143,29,105,15,158,11,222,31,86,27,111,65,37,252,15,15,15,255,118,163,189,7,93,
191,52,225,25,212,23,179,189,189,61,241,108,182,5,149,240,139,255,227,227,227,211,211,211,243,243,115,250,50,197,114,179,175,187,183,170,227,159,88,33,177,246,171,160,55,252,192,87,255,151,151,151,215,215,215,242,139,185,91,176,137,227,159,246,108,238,233,0,108,186,86,26,135,195,47,248,240,199,192,220,190,78,152,209,223,115,140,220,130,86,248,81,121,164,248,168,63,38,168,69,181,114,132,179,24,15,53,155,84,143,255,70,188,121,154,143,217,130,181,195,15,124,108,74,250,74,221,15,139,198,63,231,57,221,179,144,8,55,180,183,96,147,240,215,240,23,27,126,4,105,112,52,182,32,135,31,61,79,106,123,180,242,72,229,103,248,139,26,59,232,143,59,244,109,1,110,15,35,225,67,91,253,165,242,51,252,109,255,131,131,131,0,106,139,114,11,114,241,17,124,92,114,165,158,83,146,223,239,191,204,182,71,143,48,35,198,236,240,240,240,232,232,40,220,100,139,180,5,149,226,147,240,25,254,34,237,202,174,19,243,85,255,227,227,92,88,62,238,164,91,80,15,127,119,189,245,126,193,155,240,89,249,123,246,226,131,182,251,
27,225,7,62,198,201,201,73,248,128,45,100,11,134,195,255,118,173,213,13,173,60,216,29,123,152,183,217,146,219,158,122,254,197,31,248,167,167,167,103,103,103,145,75,87,112,251,166,11,76,252,177,91,189,224,194,141,24,254,83,186,249,194,43,191,108,65,80,145,228,171,255,249,249,121,248,112,207,194,251,251,158,7,241,103,248,123,202,78,61,255,226,47,225,7,254,223,221,232,81,127,191,217,227,35,228,222,95,241,25,254,254,93,8,186,72,190,15,63,248,47,46,46,46,47,115,181,247,159,227,253,61,62,195,223,111,174,225,199,36,140,132,175,254,87,87,87,225,126,31,139,132,239,253,53,252,197,177,139,79,102,229,215,45,248,160,236,254,70,229,241,197,71,194,15,252,127,186,17,238,218,45,228,55,92,237,11,174,194,159,109,143,226,231,252,39,124,239,127,125,125,125,115,115,227,183,32,133,31,129,199,24,234,57,241,0,12,127,175,63,122,78,12,57,121,19,190,248,223,222,222,234,22,200,213,110,53,252,40,68,24,56,118,139,240,255,209,181,253,184,136,216,254,13,251,56,131,95,25,40,231,219,36,225,227,228,149,226,163,
248,119,119,119,242,15,27,202,240,75,242,155,199,110,248,90,83,44,230,230,143,228,87,195,143,202,131,129,240,139,191,199,111,244,156,69,248,167,32,183,199,144,43,113,255,90,254,63,206,237,251,193,44,225,87,195,15,124,239,143,58,163,101,127,135,225,159,7,126,62,127,229,130,43,85,126,73,254,62,133,127,54,248,21,127,197,223,215,240,207,9,191,229,143,150,95,143,221,106,248,187,30,199,138,15,170,144,246,60,168,252,232,142,80,166,112,88,227,200,192,167,227,69,132,71,195,192,195,98,103,113,178,99,163,241,114,67,197,235,122,174,51,180,190,184,250,195,15,64,240,51,64,252,26,34,148,69,91,204,12,63,251,107,248,229,130,11,92,229,177,155,126,201,162,13,191,247,247,248,222,223,227,123,127,143,63,250,23,64,120,242,51,120,179,108,97,230,253,61,126,217,246,200,177,171,39,111,194,247,254,26,126,217,211,50,252,192,247,254,225,9,217,98,126,201,151,240,216,119,136,153,111,248,189,63,202,136,246,60,131,23,92,9,223,251,123,124,45,62,11,198,207,245,199,251,251,202,227,253,83,195,159,122,78,193,47,43,
191,84,30,239,47,149,95,240,165,242,135,40,216,98,174,201,175,228,31,62,128,146,228,123,127,13,63,240,147,191,86,30,220,94,61,118,229,228,245,149,95,146,239,253,113,236,154,119,152,205,27,63,231,223,251,251,158,199,251,55,46,184,180,242,164,182,103,48,252,129,220,22,179,199,207,254,26,126,224,123,127,192,106,217,247,254,147,132,223,188,195,108,9,248,45,127,237,121,38,9,63,78,22,140,178,231,12,228,182,88,8,126,246,215,158,103,173,240,227,165,129,161,197,199,55,252,120,192,178,242,235,5,151,121,135,217,114,240,123,253,53,252,80,197,0,111,121,236,106,241,73,248,222,223,227,167,240,7,114,91,44,10,63,251,107,207,227,253,61,62,204,245,130,87,127,218,32,123,84,237,57,189,191,111,248,205,59,204,150,134,223,235,239,27,126,239,239,241,189,191,199,71,237,170,246,156,234,31,200,109,177,64,252,236,175,101,223,251,167,202,179,229,5,151,121,135,217,50,241,123,253,125,207,147,252,181,236,111,112,193,21,200,109,177,88,252,236,175,101,223,251,251,134,191,26,126,188,88,48,170,199,174,239,57,205,
59,204,150,140,223,235,239,123,30,239,175,225,199,161,128,129,187,249,202,143,178,95,173,252,248,81,67,32,183,197,194,241,179,63,98,44,201,247,254,218,243,108,28,126,243,14,51,226,247,250,35,219,82,246,215,10,63,174,182,202,11,174,64,110,11,226,3,63,251,55,194,143,87,1,70,181,231,172,86,126,92,109,97,152,119,152,17,95,240,235,254,26,126,49,247,61,191,246,60,101,229,151,228,251,11,174,64,110,11,226,43,126,246,151,178,239,253,61,126,53,252,184,100,192,40,143,93,243,14,51,226,123,252,186,127,106,248,171,199,110,106,123,180,236,203,111,184,2,185,45,136,159,240,179,191,36,63,249,107,217,215,226,147,240,83,248,205,59,204,136,95,226,215,253,125,207,83,13,127,119,189,85,191,224,10,228,182,32,126,21,63,251,75,242,189,191,134,31,47,13,140,234,177,171,197,199,188,195,140,248,125,248,117,127,152,235,177,235,253,21,191,250,211,134,64,110,11,226,55,240,179,63,146,191,89,248,205,59,204,136,223,198,175,248,15,134,31,87,91,233,130,43,144,219,130,248,131,248,217,31,248,222,31,175,5,237,121,180,
248,16,127,210,127,119,106,121,197,44,225,123,127,223,115,234,5,87,248,100,91,48,249,99,146,47,247,49,53,204,228,216,173,246,156,222,95,26,254,240,153,182,32,254,120,252,92,127,180,237,145,228,107,241,73,248,240,55,239,48,35,254,90,248,3,254,190,225,247,61,103,32,183,5,241,215,197,175,248,227,8,208,178,239,253,245,216,53,239,48,35,254,6,248,217,255,173,251,113,254,190,231,17,255,64,110,11,226,111,134,95,241,111,132,223,188,195,140,248,27,227,183,252,83,248,3,185,45,136,191,13,126,246,215,240,3,223,251,155,119,152,17,127,75,252,150,191,246,156,129,220,22,196,223,30,63,251,251,134,95,252,205,59,204,136,63,9,126,203,31,13,127,32,183,5,241,167,194,207,254,190,225,55,239,48,35,254,132,248,189,254,129,220,22,196,159,22,63,251,75,207,99,222,97,70,252,201,241,43,254,129,220,22,196,255,12,252,236,111,222,97,70,252,79,194,31,227,79,252,207,195,31,244,39,254,167,226,183,253,137,255,217,248,13,127,226,239,0,191,207,159,248,187,193,175,250,19,127,103,248,165,63,241,119,137,159,252,137,191,
99,124,239,79,252,221,227,171,63,241,127,10,190,248,243,127,136,240,179,240,127,252,7,0,0,255,255,3,0,213,155,125,145);

//.32x32 low-res cursor without feathering for Windows 95/98
cur_template_arrow32
:array[0..509] of byte=(
120,1,236,148,57,139,34,81,20,133,111,231,211,208,161,131,73,119,54,48,121,199,210,73,69,77,255,5,67,127,132,6,134,130,153,96,166,32,26,8,130,224,146,104,162,129,168,184,131,251,142,226,134,251,190,195,204,121,46,48,216,193,160,93,149,52,22,175,30,245,168,170,239,158,119,238,189,239,237,253,245,7,29,174,87,204,191,112,63,159,238,7,18,225,9,215,233,253,113,113,158,255,16,221,199,221,129,187,3,223,201,1,52,183,112,219,33,137,68,194,223,233,241,243,147,84,10,135,195,153,76,70,165,82,241,17,5,140,127,67,144,92,46,31,12,6,187,221,174,221,110,139,68,191,63,69,191,214,55,146,201,100,143,143,207,103,14,69,163,209,229,114,9,190,94,175,63,232,191,22,120,241,61,105,181,90,141,70,243,244,244,2,154,66,161,24,141,70,251,253,30,91,224,184,143,115,208,139,95,174,90,146,78,167,243,120,60,38,147,73,44,22,199,98,177,213,106,181,221,110,109,54,27,31,226,161,132,64,14,4,2,233,116,58,24,12,78,38,19,136,239,247,251,28,199,29,248,23,211,85,202,143,31,147,197,98,137,199,227,229,114,185,215,235,173,215,
235,205,102,147,203,229,12,6,3,124,83,171,213,74,165,82,42,149,18,61,220,234,21,217,237,246,108,54,219,108,54,103,179,25,196,79,167,211,70,163,129,250,196,118,220,110,55,220,59,236,225,6,229,39,253,46,151,171,82,169,192,19,216,14,253,221,110,183,84,42,33,17,94,175,215,104,52,126,13,142,16,4,78,171,213,154,207,231,168,201,241,120,92,175,215,83,169,148,223,239,55,155,205,95,134,51,62,146,59,28,14,1,71,217,119,58,157,66,161,16,137,68,172,86,43,31,112,198,135,21,199,134,66,229,215,106,181,100,50,233,116,58,121,130,51,62,42,19,105,93,44,22,56,16,242,249,60,210,193,31,156,241,139,197,34,50,139,134,173,86,171,104,52,94,225,140,15,44,42,19,245,233,243,249,248,134,51,62,18,138,206,10,133,66,2,192,25,31,9,77,36,18,194,192,25,223,225,112,8,6,103,124,33,225,224,223,124,112,225,223,255,143,191,0,0,0,255,255,3,0,154,214,103,8);

type
   //.system support
   tbasicbwp       =class;
   tspell          =class;
   //.GUI support
   tbasicsystem    =class;
   tbasiccontrol   =class;
   tbasicdebug     =class;
   tbasicimageexts =class;
   tbasicimgview   =class;
   tbasicscroll    =class;
   tbasiccols      =class;
   tbasicsplash    =class;
   tbasichelp      =class;
   tbasiccolor     =class;
   tbasictick      =class;
   tmenutitle      =class;
   tbasictitle     =class;
   tbasicbreak     =class;
   tbasicedit      =class;
   tbasictoolbar   =class;
   tbasicinfo      =class;
   tbasicstatus    =class;
   tbasicmenu      =class;
   tbasicscrollbar =class;
   tbasicint       =class;
   tsimpleint      =class;
   tbasicset       =class;
   tbasicsel       =class;
   tbasiccolors    =class;
   tbasicnav       =class;
   tbasiccolormatrix=class;
   tbasicsetcolor  =class;
   tbasicjump      =class;
   tbasictea       =class;
   tmainhelp       =class;
   tbwpbar         =class;
   tbasicgradient  =class;
   tbasiccolormixer=class;//05sep2025

   //.events
   tsystemnotify                 =function(sender:tobject):boolean of object;
   tsystemkeyevent               =procedure(sender:tobject;xrawkey:longint;xdown:boolean) of object;
   tsystemmouseevent             =procedure(sender:tobject;xmode,xbuttonstyle,mx,my,mw,mh:longint) of object;
   tlongintevent                 =procedure(sender:tobject;xval:longint) of object;
   tlongintgetevent              =procedure(sender:tobject;var xval:longint) of object;
   tsimplestringevent            =procedure(sender:tobject;var xval:string) of object;//28feb2022
   tsimplestringeventb           =procedure(sender:tobject;xval:string) of object;//19jun2022
   tbasicmenu_getitem            =function(sender:tobject;xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean of object;//03oct2024, 24feb2021
   tbasicint_onreadwriteval      =procedure(sender:tobject;var xval:longint;xwrite:boolean) of object;
   ttoolbarevent2                =function(sender:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean of object;//15mar2021
   tstr8event                    =procedure(sender:tobject;xval:tstr8) of object;
   tmenufillevent                =procedure(sender:tobject;xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string) of object;//19mar2021, 15mar2021
   tonacceptfilesevent           =procedure(sender:tobject;var msg:twinmessage) of object;
   tonacceptevent                =function(sender:tobject;xfolder,xfilename:string;xindex,xcount:longint):boolean of object;
   tonfindheight                 =function(sender:tobject;xclientwidth:longint):longint of object;
   tnavmodifyitem                =procedure(sender:tobject;var xtab:string;var xindent,xstyle,xtepcolor,xtep:longint;var xcaption,xcaplabel:string;var xbold:boolean;xfav:boolean) of object;//03oct2024
   tgetobjectevent               =procedure(sender:tobject;xindex:longint;var xval:tobject) of object;//14jul2025

   //.fast access font info
   tfontinfo=record
      w1:longint;
      w2:longint;
      wlist:array[0..255] of longint;
      h:longint;
      h1:longint;
      end;

   //.system coloring record
   pvirtualinfo=^tvirtualinfo;
   tvirtualinfo=record
    //system information - read-only -------------------------------------------
    frame         :longint;//main form border - 18apr2020
    frame2        :longint;
    framefindcol  :longint;//works with winLdr - 23feb202
    framefindcol2 :longint;//works with winLdr - 23feb202
    border        :longint;
    background    :longint;
    highlight     :longint;
    hover         :longint;
    disable       :longint;//used for background
    disableborder :longint;//used for border
    disablefont   :longint;
    font          :longint;
    fonthighlight :longint;
    fontname      :string;//unicode in Delph 10
    fontsize      :longint;
    //.system font index (100%) - normal
    fn            :longint;
    fb            :longint;
    //.system font index (80%) - small
    fs            :longint;
    fsb           :longint;
    fs2           :longint;
    //.font heights (line height)
    fnH           :longint;
    fbH           :longint;
    fnbH          :longint;
    fsH           :longint;
    fsbH          :longint;
    fsH2          :longint;

    //.font sizes - 04sep2025
    fnFS          :longint;
    fbFS          :longint;
    fnbFS         :longint;
    fsFS          :longint;
    fsbFS         :longint;
    fsFS2         :longint;

    //.colors
    mfont             :longint;
    mback             :longint;
    mrow              :longint;
    mhint             :longint;
    mhover            :longint;
    mhover2           :longint;
    mcolhover         :longint;
    mcolhover2        :tpoint;//x=background, y=foreground
    mcolfont          :longint;
    mline             :longint;
    mline2            :longint;
    msep              :longint;
    mborder           :longint;
    mmustborder       :longint;
    end;

   pclientinfo=^tclientinfo;
   tclientinfo=record
    info              :pvirtualinfo;
    fn                :longint;
    fb                :longint;
    fs                :longint;
    fsb               :longint;
    fs2               :longint;

    fnH               :longint;
    fbH               :longint;
    fnbH              :longint;
    fsH               :longint;
    fsbH              :longint;
    fsH2              :longint;

    fnFS              :longint;
    fbFS              :longint;
    fnbFS             :longint;
    fsFS              :longint;
    fsbFS             :longint;
    fsFS2             :longint;

    cs                :twinrect;//client space (full area)
    ci                :twinrect;//client inner space (usable space of client, excludes frame)
    cw                :longint;//client width
    ch                :longint;//client height
    bs                :longint;//border size
    n                 :boolean;//normal
    r                 :boolean;//round
    roundframe        :boolean;
    roundstyle        :longint;
    f                 :longint;//feather
    e                 :boolean;//enabled
    sparkle           :longint;
    zoom              :longint;//zoom
    font              :longint;
    back              :longint;
    row               :longint;
    hint              :longint;
    hover             :longint;
    hover2            :longint;
    colhover          :longint;
    colhover2         :tpoint;
    colfont           :longint;
    line              :longint;
    line2             :longint;
    sep               :longint;
    border            :longint;
    mustborder        :longint;
    end;

   pvirtualmorecolors=^tvirtualmorecolors;
   tvirtualmorecolors=record
    frame         :longint;
    title         :longint;
    standard      :longint;
    allinone      :longint;
    dark_light    :longint;
    light_dark    :longint;
    end;

{twordcore}
   twordcharinfo=record
     c       :byte;
     cs      :byte;
     wid     :word;//primary array index (txtname/imgdata etc)
     txtid   :word;//secondary array index (lgfdata/lgfnref)
     width   :longint;
     height  :longint;
     height1 :longint;
     end;
   pwordcore=^twordcore;
   twordcore=record
     //init
     initstate     :string;//is set to "done" once this structure has be setup for the first time - 21aug2019
     dataonly      :boolean;//defaults=false=fonts load for GUI, true=fonts don't load and thus no GUI support (but faster for pure data conversion)
     hostsizing    :boolean;//default=false=host is NOT resizing so it's ok to perform WRAP request, true=host IS resizing so hold off performing WRAP calculations - 22apr2022
     //.onefontname/size - 05feb2022
     onefontname   :string;//default="<nil>", if set to a font name then ALL font names are overridden inclduing any pasted, io'ed, current etc even in dataonly mode -> now supports multiple dynamic fontnames of "$fontname=viFontname/$fontname2=viFontname2/default/default 2/<any valid fontname>" - 05feb2022
     onefontsize   :longint;//default=-1=off, 0=viFontsize, 1=viFontsize2 OR 2..N=set ALL font sizes to this value
     onefontREF    :string;//internal use only
     lastvisyncid  :longint;//13feb2022
     maxformatlevel:longint;//0=plaintext, 1=enhanced text, 2=advanced text (default) - 12jun2022
     //font list -> linear graphic font
     lgfdata       :array[0..999] of tstr8;//rapid access linear graphic font - 21aug2019
     lgfnref       :array[0..999] of string;//simple lookup name for style|size|fontname -> used to autocreate lgfDATA when required - 25sep2019
     //text list
     txtname       :array[0..999] of string;//font name
     txtsize       :array[0..999] of longint;//font size
     txtbold       :array[0..999] of boolean;//font style
     txtitalic     :array[0..999] of boolean;
     txtunderline  :array[0..999] of boolean;
     txtstrikeout  :array[0..999] of boolean;
     txtcolor      :array[0..999] of longint;
     txtbk         :array[0..999] of longint;
     txtborder     :array[0..999] of longint;
     txtalign      :array[0..999] of byte;//0=left, 1=centre, 2=right
     txtid         :array[0..999] of word;//pointer to "lgfdata"
     txtzoom       :array[0..999] of byte;//1..4 -> not stored in datastream -> internal reference only - 14mar2021
     //image list
     imgdata       :array[0..999] of tstr8;//original image data stream (JPG, TEH, TEM, BMP etc)
     img32         :array[0..999] of tbasicimage;//raw 32bit image data (no header, in-order, continous stream of BGRA pixels) - 25may2025
     imgtrans      :array[0..999] of boolean;//transparent (top-left) - 27aug2021
     imgw          :array[0..999] of longint;
     imgh          :array[0..999] of longint;
     imgsyscols    :array[0..999] of boolean;//25may2025
     //data streams
     data          :tstr8;//single byte text stream
     data2         :tstr8;//1st byte of 16bit dataid stream -> this id points to the text list/image list above
     data3         :tstr8;//2nd byte of 16bit dataid stream -> 2x single byte streams making mapping/undoing/redoing easier as all values identically match the first "data" text stream
     //alt datastreams - these are assumed to be POINTERS and thus are not destroyed - 26jun2022
     alt1          :tstr8;//pointer only
     alt2          :tstr8;//pointer only
     alt3          :tstr8;//pointer only
     //multi undo handler - 25jun2022
     menabled      :boolean;//default=false;
     mn            :array[-1..199] of string;//list of undo files
     mnUsed        :array[-1..199] of boolean;//default=false=undo file has not been used -> no need to clean or remove, true=undo file has been used at least once and must be deleted when closing/flushing - 20dec2024
     mlimit        :longint;//2..200
     //.support
     mlist         :tstr8;
     md1           :tstr8;
     md2           :tstr8;
     md3           :tstr8;
     mstyle        :longint;
     mfrom1        :longint;//required
     mact          :longint;//vital - 03jul2022
     mlen          :longint;//required
     //support streams -> list every line's x,y,w,h information (in 32bit blocks) and line information - 21aug2019 - individual characters can then be calculated from the start of the line onwards without the overhead of 1:1 character mapping, inline with WordPad's memory overhead
     linex         :pdlLONGINT;
     liney         :pdlLONGINT;
     lineh         :pdlLONGINT;
     lineh1        :pdlLONGINT;
     linep         :pdlLONGINT;//item pos at start of this line
     //.hard and fast limit of each core, exceeding these limits will cause memory corruption/system failure - 22aug2019
     linesize      :longint;
     listsize      :longint;
     //.stream cores -> these provide the actual memory in RAM for the array pointers "linex/liney/.../linep" above -> reading/writing to a pointer array is fast and straight forward
     corelinex     :tstr8;
     coreliney     :tstr8;
     corelineh     :tstr8;
     corelineh1    :tstr8;
     corelinep     :tstr8;
     //current "font/style" support -> this represent the text cursor's current formatting
     cfontname     :string;
     cfontsize     :longint;
     cbold         :boolean;
     citalic       :boolean;
     cunderline    :boolean;
     cstrikeout    :boolean;
     ccolor        :longint;
     cbk           :longint;
     cborder       :longint;
     calign        :byte;//0=left, 1=centre, 2=right
     //paint + management
     cursorpos     :longint;//text cursor position within the "data" stream and thus the "data2" and "data3" streams
     cursorpos2    :longint;//highlight to this position
     papersize     :longint;//0=psA4, 1=psA3 etc -> used when wrapstyle=wwsPage - visual handling/painting only at this stage - no print support
     paperwidth    :longint;//read only - width of paper for screen purposes
     paperheight   :longint;//read only - height of paper for screen purposes
     dpi           :longint;//default=95, widescreen=120
     widestline    :longint;//retains the widest line in pixels even when said lines have been removed -> inline with Notepad - 12mar2021
     usezoom       :boolean;//default=true=zoom fontsize and images to system zoom level (vizoom), false=do not apply zoom - 14mar2021
     lastzoom      :longint;//internal use only -> tracks change in zoom level - 14mar2021
     zoomnow       :longint;//internal use only -> current zoom level -> used for all zooming of text and images - 14mar2021
     pagewidth     :longint;//0=wrap to area
     pageheight    :longint;//max32=continuous
     pagecolor     :longint;//color of page background -> default=clnone=>white=rgb(255,255,255)
     pagecolor2    :longint;//override pagecolor
     pagefontcolor2:longint;//override text color (all fonts)
     pageoverride2 :boolean;//default=false=don't use "pagecolor2" or "pagefontcolor2"
     pageselcolor  :longint;//selection color -> uses built-in light blue by default
     pagefontselcolor:longint;
     viewwidth     :longint;//control view width
     viewheight    :longint;//control view height
     viewcolor     :longint;//color of unused area -> default=rgb(152,152,152)
     vpos          :longint;//control vertical scrollbar position
     vposPART      :longint;//fine adjustment of vpos -> part line in pixels - 21jun2022
     vhostsync     :boolean;//true=host must read "vpos/vmax" and sync with host scrollbar
     vcheck        :longint;//internal use only
     hpos          :longint;//control horizontal scrollbar position
     hhostsync     :boolean;//true=host must read "hpos/hmax" and sync with host scrollbar
     pagecount     :longint;//number of pages (always 1 or more) -> works when "wrapstyle=wwsPage"
     totalheight   :longint;//height of all lines of text within the confines of pagewidth & pageheight
     linecount     :longint;
     line          :longint;
     col           :longint;
     wrapcount     :longint;//indicates HOW FAR the wrap system has progressed (considered complete when wrapcount>=low__len(x.data))
     dataid        :longint;//track changes to document content AND visual parameters such as width and height -> resets between documents and calls to "clear"
     dataid2       :longint;//this dataid is NEVER reset and is persistent between documents, calls to "clear" etc, but is RESET only on a call to "init" - 14jun2022
     dataid3       :longint;//this dataid is NEVER reset and is persistent between documents, calls to "clear" etc, but is RESET only on a call to "init" AND relates ONLY to content change and NOT control resize/wordwrap status - 25dec2022
     mustpaint     :boolean;
     paintlock     :boolean;
     modified      :boolean;
     timer100      :currency;//used to internally throttle the "timer" event to a steady 100ms internval cycle MAX
     timerslow     :currency;
     timerfont500  :currency;//02feb2022
     idleref       :currency;
     k_idleref     :currency;//keyboard idle - 26sep2022
     timerbusy     :boolean;
     wrapstack     :tstr8;//stack of wordwrap ranges to process (from(4b)+to(4b)=64bit blocks)
     kstack        :tstr8;//stack of keyboard inputs
     mstack        :tstr8;//stack of mouse inputs
     briefstatus   :string;
     shortcuts     :boolean;//enable built-in keyboard shortcuts
     styleshortcuts:boolean;//enable more keyboard shortcuts for keyboard based text styling such as "bold" and "italic"
     flashcursor   :boolean;//internally managed
     drawcursor    :boolean;//internally managed
     cursoronscrn  :boolean;//*
     linecursorx   :longint;//internal use only -> used to remember cursor's original X coordinate when scrolling up/down using keyboard keys - 31aug2019
     havefocus     :boolean;//set by host
     showcursor    :boolean;//set by host
     readonly      :boolean;//set by host
     shift         :boolean;//set internally -> true=shift key is down
     wasdown       :boolean;//mouse support - internal
     wasright      :boolean;//mouse support - internal
     feather       :longint;//0=sharp edges to text, 1=light feather, 2=heavy feather
     sysfeather    :boolean;//default=true=uses system feather (fills ".feather" with "vifeather" value) - 26aug2020
     //was: activecursor  :tcursor;
     //.dic support
     dicref1       :longint;//used by "odic=true"
     dicref2       :longint;//used by "odic=true"
     dicid         :longint;//used by "odic=true"
     dicshow       :boolean;//used by "odic=true"
     dicfrom       :longint;//used by "odic=true"
     dicto         :longint;//used by "odic=true"
     dic_addword   :string;//used by "odic=true" - contains the currently misspelt word - use to add to supplementary dictionary - 11feb2023
     //.buffer support -> used for screen painting
     buffer24      :tbasicimage;//we can use 24bits here since it's our image handler - 21aug2020
     bufferref     :string;
     syncref       :string;
     //consts
     c_smallwrap   :longint;//set once by "init" - progressive wordwrap range
     c_bigwrap     :longint;//set once by "init"
     c_pagewrap    :longint;//use to wrap an entire screen of characters -> best guess -> not actual requirement, but a large number to cover even 8k displays
     c_idlepause   :longint;//time to take before cursor can flash again, default=500ms
     //special - delayed events/vars
     cursorstyle             :char;//"t" = text cursor, "l" = link cursor
     cursor_keyboard_moveto  :longint;
     timer_chklinecursorx    :boolean;
     sysfontDefault          :string;
     sysfontDefault2         :string;
     //other
     landscape     :boolean;//default=false
     wrapstyle     :longint;//0=wwsNone=no wrap, 1=wwsWindow=to window(viewwidth/height), 2=wwsPage=to page (pagewidth/pageheight), 3=wwsPage+Manuscript Left Margin
     wrapreadonly  :boolean;//default=false=wrapstyle adjust with "ioset()", true=wrap ONLY changes when specifically called via "low__wordcore(x,'wrap','<new wrapstyle value>') - 12mar2021
     lastfindalignpos:longint;//default=-1=not set
     //reference
     bwd_color     :longint;//support for "enhanced text" color support which uses three colors: font color, font color 2 (typically was red)  and highlight color (text background)
     bwd_color2    :longint;
     bwd_bk        :longint;
     //Claude support - optional color overrides for Claude - 14jul2020
     //Claude v1.00.* supported dynamically allocated document coloring for html encoding with variables below,
     //whereas Claude v2.00.* supports a more direct approach to it's document coloring and html encoding with more sophisticated handling
     useclaudecolors  :boolean;//default=false=off
     claude_text1     :longint;
     claude_text2     :longint;
     claude_text3     :longint;
     claude_text4     :longint;
     claude_text5     :longint;
     claude_header1   :longint;
     claude_header2   :longint;
     claude_header3   :longint;
     claude_header4   :longint;
     claude_header5   :longint;
     //special options
     defCopyformat    :string;//'txt';
     defFontname      :string;//"arial" - 05sep2020
     defFontsize      :longint;//"12"
     defFontcolor     :longint;//"0" = black
     //special actions - 19apr2021
     oviewurl         :boolean;//default=true=click on a url "http://" or "https://" or "ftp://" or "ftps://" or "mailto:" with no active selection and the link is executed via the default system handler (browser / email client) - 19apr2021
     olinespacing     :longint;//1=normal, 2=double - 04feb2023
     odic             :boolean;//default=false, true=indicate misspelt words and offer dictionary support
     obackup          :boolean;//default=false, true=write whole document backup copies to disk whenever document changes significantly - 05feb2023
     obackupname      :string;//default=nil, optional trailing name (extension is always automatically assigned) - 25feb2023
     ofindhandler     :longint;//default=assigned at init
     end;

//system objects ---------------------------------------------------------------
//tbasicapp
   tbasicapp=class(tobjectex)
   private
    igui:tbasicsystem;
    procedure xstarttimer;
   public
    //create
    constructor create(dwidth,dheight:longint;xscalewithzoom:boolean); virtual;
    procedure createfinish; virtual;//30jul2021
    destructor destroy; override;
    //values
    property gui:tbasicsystem read igui;
    function rootwin:tbasicscroll;
    //workers
    procedure xloadsettings; virtual;
    procedure xsavesettings; virtual;
    //events
    procedure __ontimer(sender:tobject); virtual;
    //support
    procedure debug_tests;//19jul2024
   end;


{tspell}
//xxxxxxxxxxxxxxxxxxxx//ssssssssssssssssssssss
    tspell=class(tobjectex)
    private
     iwordlist:tdynamicstring;
     iwordrefs:tdynamicinteger;
     icount,iid:longint;
     ifilename:string;
     icansave,imodified:boolean;
     procedure xclearwords;
     function xsettext(xtext:string):boolean;
     procedure settext(x:string);
     function gettext:string;
     function findempty(var xindex:longint):boolean;
    public
     //create
     constructor create(xstoragefilename:string);
     destructor destroy; override;
     //information
     property id:longint read iid;
     property filename:string read ifilename;
     property modified:boolean read imodified;
     property cansave:boolean read icansave;
     property count:longint read icount;
     //spelling
     function findword(x:string):boolean;
     function findword2(x:string;var xindex:longint):boolean;
     function addword(x:string):boolean;
     function delword(x:string):boolean;
     function clear:boolean;
     //io
     function load:boolean;
     function save:boolean;
     function mustsave:boolean;
     //data
     property text:string read gettext write settext;
    end;

{trnd8}
   trnd8=class(tobject)//29nov2023
   private
    icore:tstr8;
    imax,ipos,iposcount:longint;
   public
    //create
    constructor create(xsize:longint); virtual;
    destructor destroy; override;
    //workers
    function pull:byte;
    function pull2:byte;
   end;

{tbackgroundmanager}
//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx//bbbbbbbbbbbbbbbbbbbbb
   tbackgroundmanager=class(tobject)//handles static, animated and dynamic background imagery for "tbasicsystem"
   private
    igui:tbasicsystem;
    itimer:comp;
    iitemindex,ilimit:longint;
    imustpaint,imustupdate:boolean;
    icanchangevals :array[0..99] of boolean;

    //.animation support
    iuse_itemindex        :longint;//actual item being used
    iuse_tile32           :trawimage;
    iuse_tileref          :string;
    iuse_tilew            :longint;
    iuse_tileh            :longint;
    iuse_shadepower255    :longint;
    iuse_shadepower255_inc:boolean;
    iuse_scrollx          :longint;
    iuse_scrolly          :longint;
    iuse_wobblex          :longint;
    iuse_wobbley          :longint;
    iuse_wobblef          :longint;//fade
    iuse_cellcount        :longint;
    iuse_cellindex        :longint;
    iuse_tileok           :boolean;

    //.background exclusion mask
    iuse_mask:tmask8;//28nov2024
    iuse_maskref:string;
    iuse_usemask:boolean;
    tag :longint;

    function getname(xindex:longint):string;
    procedure setitemindex(xindex:longint);
    procedure xloadtile;
    function xmasksync(dw,dh:longint):boolean;
    procedure setbackgroundname(x:string);
    function getbackgroundname:string;
    //core support
    function getcount:longint;
    procedure setval(xnameid,xindex,xval:longint);
    function getval(xnameid,xindex:longint):longint;
    property val[xnameid,xindex:longint]:longint read getval write setval;
    function getstrength:longint;
    function getcolorise:longint;
    function getspeed:longint;
    function gethstep:longint;
    function gethwobble:longint;
    function getvstep:longint;
    function getvwobble:longint;
    function getfstep:longint;
    function getfwobble:longint;
    procedure setstrength(x:longint);
    procedure setcolorise(x:longint);
    procedure setspeed(x:longint);
    procedure sethstep(x:longint);
    procedure sethwobble(x:longint);
    procedure setvstep(x:longint);
    procedure setvwobble(x:longint);
    procedure setfstep(x:longint);
    procedure setfwobble(x:longint);
   public
    constructor create(xgui:tbasicsystem); virtual;
    destructor destroy; override;
    procedure paintinit;
    procedure nint__onvalue(sender:tobject;var xval:longint;xwrite:boolean);
    procedure nint__onvalueDEF(sender:tobject;var xval:longint;xwrite:boolean);

    //information
    property gui:tbasicsystem read igui;
    function canchangevals:boolean;
    property name[xindex:longint]:string read getname;
    function iscustom(xindex:longint):boolean;
    property limit:longint read ilimit;
    property count:longint read getcount;
    property backgroundname:string read getbackgroundname write setbackgroundname;
    property itemindex:longint read iitemindex write setitemindex;
    function mustupdate(xreset:boolean):boolean;
    function mustpaint(xreset:boolean):boolean;
    property tile32:trawimage read iuse_tile32;
    function tileok:boolean;
    function inuse:boolean;
    property tilew:longint read iuse_tilew;
    property tileh:longint read iuse_tileh;
    property cellindex:longint read iuse_cellindex;
    property cellcount:longint read iuse_cellcount;
    property scrollx:longint read iuse_scrollx;
    property scrolly:longint read iuse_scrolly;
    property wobblex:longint read iuse_wobblex;
    property wobbley:longint read iuse_wobbley;
    property wobblef:longint read iuse_wobblef;
    property shadepower255:longint read iuse_shadepower255;

    //adjustable values
    function canadjust:boolean;
    property strength:longint      read getstrength   write setstrength;
    property colorise:longint      read getcolorise   write setcolorise;
    property speed:longint         read getspeed      write setspeed;
    property hstep:longint         read gethstep      write sethstep;
    property hwobble:longint       read gethwobble    write sethwobble;
    property vstep:longint         read getvstep      write setvstep;
    property vwobble:longint       read getvwobble    write setvwobble;
    property fstep:longint         read getfstep      write setfstep;
    property fwobble:longint       read getfwobble    write setfwobble;

    //timer
    function xmusttimer:boolean;
    procedure xtimer;

    //background mask support
    procedure nomask;
    function initmask(dw,dh:longint):boolean;
    property usemask:boolean read iuse_usemask;
    property mask:tmask8 read iuse_mask;

    //custom user image support
    function canpasteimage:boolean;
    function pasteimage:boolean;
    function canselectimage:boolean;
    function selectimage:boolean;
    function canclearimage:boolean;
    function clearimage:boolean;

    //io
    procedure storevals;
    procedure pullval(snameid:string;var xcanchange:boolean;var xval:longint);
    procedure pushval(snameid:string;xnewval:longint);

    //support
    function findnameid(xnameid_asstr:string;var xnameid:longint):boolean;
    function findbyname(xname:string):longint;
    function mint(xhost:tbasiccontrol;xnameid:string):tsimpleint;
    function sync_panel(x:tbasicscroll):boolean;
   end;


//GUI Support ------------------------------------------------------------------
{tbasicsystem}
   townlist=record
      list:array[0..maxcore] of word;
      count:longint;
      end;
   twinlist=record
      list:array[0..254] of word;
      count:longint;
      end;

   tbasicsystem=class(tobject)
   private
    //general
    ishowmenu:tstr8;//pointer only
    isnapshot64,imousedownref,ihidecursorref,ipumptimer2,ibufferresize64,ilastsystem_slowref64,iecomode64,iopacitytimer,itimer5000,itimer1000,itimer100,itimer250,ishowonceref:comp;
    iform_sizecheckcount,isizing,ilastmousemovecheckx,ilastmousemovechecky,icursorloadid,ishowaitcount,icloselocked,ilastdataid,iwinmax,iwinlimit,ilastsystem_mustidSLOW,ilastsystem_mustid:longint;
    iform_sizing,if1_showhelp,if2_restoredefaults,iecopainting,ishowoptions_crosssync,iwinemaximised,imustcloseprompt,itimer_busy,idragging_fullwin,iclosed,iontimerbusy,itiming,icreating,idestroying,imustclose,ialigning,ipaintedwithtile,ipaintfirst:boolean;
    inormalarea:twinrect;//nor only
    ikeyboardlaststate:byte;
    fontimer,fontimer2:tevent;
    //game mode support - 29jan2025
    igamemode             :boolean;
    igamemode_cansize     :boolean;
    igamemode_canmove     :boolean;
    igamemode_onpaint     :tevent;
    igamemode_onshortcut  :tsystemnotify;
    igamemode_onnotify    :tsystemnotify;
    igamemode_onkey       :tsystemkeyevent;
    igamemode_onmouse     :tsystemmouseevent;
    fonkey                :tsystemkeyevent;//general purpose
    //fps painting stat
    ifps,ifpscount:longint;
    //automatic opacity
    ilastopacity100x:longint;
    ilastopacitystep:longint;
    ilastopacityref:string;
    //wound support
    iwounddirx,iwounddiry,iwoundlastx,iwoundlasty,iwoundratex,iwoundratey,iwoundratelimit:longint;
    iwoundref:comp;
    //hint support
    ihint:string;
    ihintlines:tdynamicstring;
    ihinttitle_linecount:longint;//number of lines title covers -> usually only one or zero, but may be 2 or more if it's wrapped - 03jan2025
    ihintarea:twinrect;
    ihintXY:tpoint;
    ihintTimeout:comp;
    ihintOnsecs:longint;
    //showoptions support
    ishowoptions_inuse:boolean;
    ishowoptions_backgroundpanel,ishowoptions_window,ishowoptions_settings,ishowoptions_font,ishowoptions_stats,ishowoptions_snoop:tbasicscroll;//28aug2025, 08mar2021
    ishowoptions_list,ishowoptions_frames,ishowoptions_backs,ishowoptions_statslist,ishowoptions_snooplist:tbasicmenu;
    ishowoptions_options:tbasicset;//26feb2022
    ishowoptions_cols,ishowoptions_backs_cols:tbasiccols;
    ishowoptions_colors:tbasiccolors;
    ishowoptions_framesize1,ishowoptions_framesize2,ishowoptions_sparkle1,ishowoptions_sparkle2,ishowoptions_brightness3,ishowoptions_focusedopacity1,ishowoptions_unfocusedopacity1,ishowoptions_opacityspeed1:tsimpleint;
    ishowoptions_maintoolbar,ishowoptions_toolbar_background:tbasictoolbar;
    ishowoptions_timer100,ishowoptions_timer500:comp;
    ishowoptions_font_vpos,ishowoptions_settings_vpos,ishowoptions_stats_vpos,ishowoptions_stats_vpos2,ishowoptions_snoop_vpos,ishowoptions_snoop_vpos2:longint;
    //background support - 02mar2025
    ibackgroundmanager:tbackgroundmanager;
    //core support
    icore:array[0..maxcore] of tbasiccontrol;
    icorecount:longint;
    //action support
    ias:array[0..maxcore] of char;
    iam:array[0..maxcore] of byte;
    iax:array[0..maxcore] of longint;
    iay:array[0..maxcore] of longint;
    iacount:longint;
    //pop support
    ipophost:tbasiccontrol;
    ipopshortcut:longint;//aknone=nothing
    //window support
    iwinhover,iwinhoverlayer:longint;
    iwinfocus,iwinfocuslayer:longint;
    idragindex,idragstart:longint;
    idragrect:twinrect;//note: used internally within "__onpaint()" only - 18may2020
    isizeindex,isizestart:longint;//25feb2021
    //keyboard + mouse support
    idownrect:twinrect;
    imousebuttonlock,iwheel,ikey,imousebutton:longint;
    ihoverindex,ifocusindex,ifocussizemodex,ifocussizemodey:longint;//min32=none, -1=resize, 0..N=coreindex
    ishiftok,ictrlok,ialtok,iscreendraggingout,iscreenmovingfine,iscreendragging,iscreendraggingv,iscreendraggingh,iscreendraggingfine,iscreendraggingfinev,iscreendraggingfineh,imousemoved,imousedown,imousewasdown,imousedbclick:boolean;
    iscreenmovingfinexy,imousedownxy,imousemovexy:tpoint;
    iscreendownxy,iscreenmovexy:tpoint;
    iscreenmovingfine64,imousedbclicktime:comp;
    fonshortcut:tsystemnotify;
    //paint support
    ipartpaint_arealist:array[0..99] of twinrect;
    ipartpaint_count:longint;
    ipartpaintareaok,ipaintingpart,imasking,ipaintbusy:boolean;
    imaskval,ipainting,imustpaint,imustalign,ialignid,ipaintid:longint;
    ipostpaint_fullid,ipostpaint_partid,ipostpaint_id:longint;
    //buffers
    ibuffer:twinbmp;//main buffer all controls are rendered onto
    ibuffer2:twinbmp;//bridge buffer that accepts pixels from "ibuffer" and renders them onto the form (ihost) via canvas
    ibufferID2:longint;
    idragbuffer:tbasicimage;//drag buffer -> used for dragging windows
    imask:tmask8;
    //.simple drag and drop - 21jul2024
    idragdrop_icon:tbasicimage;//used for drag and drop dragging
    idragdrop_startarea:twinrect;//mouse down
    idragdrop_stoparea:twinrect;//mouse up
    idragdrop_code2:string;
    idragdrop_ref:string;
    idragdrop_dragging:boolean;
    idragdrop_lastarea:twinrect;
    idragdrop_power255:longint;//06jun2025
    //splash
    isplash:tbasicsplash;
    //status support
    istatuswin:tbasicscroll;
    istatustime:comp;
    istatuspert:double;
    istatustab:string;
    istatusrowcount:longint;
    istatustext:array[0..9] of string;
    istatustep:array[0..9] of longint;
    istatustitle:string;
    istatusshow:boolean;
    istatusstopped:boolean;
    //xdrawtohost support
    idrawtohost_count:longint;
    idrawtohost_usetile:boolean;
    ilastbuffer2:boolean;//set by xdrawtohost__start
    idrawtohost_arealist:array[0..99] of twinrect;
    //form support
    iform_handle,iform_paintdc:tbasic_handle;
    iform_downrect:twinrect;
    iform_caption,iform_sizeref,iform_cornersREF:string;
    iform_fullscreen,iform_active:boolean;
    iform_width,iform_height:longint;
    ipaint_tryagain_count:longint;
    iform_lastshift,iform_lastalt,iform_lastctrl:boolean;
    ilaststate:char;
    
    //rootwin
    irootwin:tbasicscroll;

    function xcommonevent(a:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    function xcommongetitem(sender:tobject;xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean;
    procedure setfocusindex(x:longint);
    procedure sethoverindex(x:longint);
    function getfocuscontrol:tbasiccontrol;
    procedure setfocuscontrol(x:tbasiccontrol);
    function getcore(x:longint):tbasiccontrol;
    procedure xtimer;
    procedure setwinfocus(x:longint);
    function getmaskval:longint;
    //host form support
    procedure __onpaint_debug(sender:tobject);
    procedure __onpaint(sender:tobject);//updated: 28jun2024, 28jul2020
    procedure __ontimer(sender:tobject);
    procedure __ontimer2(sender:tobject);
    function __onappmenu(sender:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    //part paint support
    procedure xpartpaint__clear;
    function xpartpaint__addarea(x:twinrect):boolean;
    function xpartpaint__hasareaContained(x:twinrect):boolean;//for debugging
    //draw to host support
    procedure xdrawtohost__start(xusetile:boolean);
    procedure xdrawtohost__addarea(xarea:twinrect);
    procedure xdrawtohost(xarea:twinrect;xmode:string);//21apr2025, 09jan2025, 21nov2024: background animation pauses now during window resize/reposition events
    procedure xdrawtohost__finish;
    //debug support
    procedure xbasicdebug_proc;
    //other
    function xshowoptions_getitem_stats(sender:tobject;xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean;//17dec2024
    function xshowoptions_getitem_snoop(sender:tobject;xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean;//17dec2024
    procedure xshowoptions_crosssync;
    property xshowoptions_list:tbasicmenu read ishowoptions_list;//Warning: can be nil - 24jul2021
    procedure xshowoptions_reload;
    procedure xshowoptions_timer(sender:tobject);
    procedure xshowoptions_showmenu(sender:tobject);
    procedure xshowoptions_click(sender:tobject);
    procedure xshowoptions_sync(sender:tobject);
    procedure xshowoptions_sync2(sender:tobject;xname:string;xclicked:boolean);
    procedure xsafearea;//14mar2025
    procedure xsnapshot_make;
    //.hint support
    procedure hint__none;
    function hint__cantitle(x:string):boolean;//03jan2025
    procedure hint__format;//09may2025: single "*" on a line for blank line, 21apr2025, 09jan2025, 03jan2025
    //.status support
    procedure __xstatus(xpert:double;xtitle:string;xshow,xupdatenow:boolean);
    function getstatustext(xindex:longint):string;
    procedure setstatustext(xindex:longint;x:string);
    function getstatustep(xindex:longint):longint;
    procedure setstatustep(xindex:longint;x:longint);
    procedure setstatuspert(xpert:double);
    function getstatusstopped:boolean;//catches "escape" key hiding status window - 02aug2021
    //.wound support
    procedure xwoundcalc(x,y:longint);
    //.fullscreen is now strictly internal use only, instead use "maxed,nomax,max or max2()" properties and procs -> max here means "max screen usage and not Ms maximise" - 09jan2025
    procedure xsyncfullscreen;//02dec2024: updated to check exact area and enforce it -> internal use only
    //.form support - 18jan2025
    function form__create(xacceptfiles:boolean):tbasic_handle;//01jun2025, 28may2025
//    procedure form__center(xmonitorindex:longint);
    function form__monitorindex:longint;
    procedure form__setcaption(x:string);
    function form__bordersize:longint;
    function form__minwidth:longint;
    function form__minheight:longint;
    function getshowing:boolean;
    function form__getontop:boolean;
    procedure form__setontop(x:boolean);
    procedure setstate(x:char);
    function getstate:char;
    procedure form__paintnow;//05oct2025
    procedure form__setval32(n:char;dv:longint);
    function form__getval32(n:char):longint;
    property form__val32[n:char]:longint read form__getval32 write form__setval32;
    function form__getarea:twinrect;
    procedure form__setarea(x:twinrect);
    property form__area:twinrect read form__getarea write form__setarea;
    function form__paintarea:twinrect;
    function form__paintarea1:twinrect;
    procedure form__setleft(x:longint);
    procedure form__settop(x:longint);
    procedure form__setwidth(x:longint);
    procedure form__setheight(x:longint);
    function form__getleft:longint;
    function form__gettop:longint;
    procedure form__wmnchittest(var m:twinmessage);
    procedure form__wmpaint(dc:tbasic_handle;var ps:tpaintstruct);
    procedure form__wmmousewheel(var m:twinmessage);
    procedure form__wmactivateapp(var m:twinmessage);
    procedure form__wmacceptfiles(var m:twinmessage);//08oct2024, 14feb2024: updated, drag&drop files - 24APR2011, 07DEC2009
    procedure form__wmactive(var m:twinmessage);
    procedure form__wmsetcursor(var m:twinmessage);
    procedure form__wmentersizemove;
    procedure form__wmsize(var m:twinmessage);
    procedure form__wmsizing(var m:twinmessage);//09mar2025: implemented min width/height enforcement
    procedure form__wmexitsizemove;
    procedure form__mouse(s:byte;xbut:longint;var m:twinmessage);
    procedure form__wmmousedown(xbut:longint;var m:twinmessage);
    procedure form__wmmousemove(var m:twinmessage);
    procedure form__wmmouseup(xbut:longint;var m:twinmessage);
    procedure form__wmkeydown(var m:twinmessage);
    procedure form__wmkeyup(var m:twinmessage);
    procedure form__wmsyskeydown(var m:twinmessage);
    procedure form__wmsyskeyup(var m:twinmessage);
    procedure form__wmchar(var m:twinmessage);
    procedure form__wmsyschar(var m:twinmessage);
    procedure form__wmclose(var m:twinmessage);
    procedure form__setbounds2(dx,dy,dw,dh:longint;xforcerepaint:boolean);//05may2025
    procedure form__sizeSync;
    procedure form__fadeout(xreset:boolean);
    procedure form__fadein(xreset:boolean);//18feb2025: tweaked, 05feb2025
    function getcursor:longint;
    procedure setcursor(x:longint);
    procedure setgamemode(x:boolean);//29jan2025
    function getbackgroundname:string;
    procedure setbackgroundname(x:string);
   public
    //show modes
    smnone:byte;
    smmodal:byte;
    smwait:byte;
    //index styles
    xsnone:byte;
    xsoutside:byte;
    xscontrol:byte;
    xsunknown:byte;
    //paint support
    recs:array[0..19] of twinrect;
    //own support
    ownlist:townlist;
    ownid:longint;//for entire GUI -> increments each time *any* ownlist changes - 19mar2020
    //window support
    winlist:twinlist;
    //mask support -> detects when the system Window mask needs to be updated
    winmask_cnt:longint;
    winmask_id :array[0..254] of longint;
    winmask_aid:array[0..254] of longint;//Note: must be same size and range as "twinlist.list[0..254]" - 19may2020
    winmask_vis:array[0..254] of boolean;
    winmask_rnd:array[0..254] of boolean;
    //options
    otestmode:boolean;//default=false
    ocansize:boolean;//default=true
    ocanmove:boolean;//defalt=true
    oeraseingbackground:longint;//default=0, increments each time an erase background message is recieved - 24jul2025
    //create
    constructor create(dwidth,dheight:longint); virtual;
    destructor destroy; override;
    property creating:boolean read icreating;
    property destroying:boolean read idestroying;
    function clienttoscreen(x:tpoint):tpoint;
    property showaitcount:longint read ishowaitcount;
    procedure pumptimer2;//forceably drive the timer - 15jul2021
    function xmainwin(var xwin:tbasicscroll):boolean;
    function xpopnav(var xvalue:string;xcommonfolder,xstyle:string;var daction:string):boolean;
    function xpopnav2(var xvalue:string;var xfilterindex:longint;xfilterlist,xcommonfolder,xstyle,xhisname,xtitle:string;var daction:string):boolean;
    function xpopnav3(var xvalue:string;var xfilterindex:longint;xfilterlist,xcommonfolder,xstyle,xhisname,xtitle:string;var daction:string;xcanpreview:boolean):boolean;
    property winemaximised:boolean read iwinemaximised;
    procedure form__center(xmonitorindex:longint);
    //closelock
    property mustcloseprompt:boolean read imustcloseprompt write imustcloseprompt;//allow host program to set TRUE or FALSE to PROMPT before closing the program - 26aug2021
    property closelocked:longint read icloselocked;
    procedure closelock;
    procedure closeunlock;
    procedure xfireevent(sender:tobject;xevent:tnotifyevent);//lock close -> fireevent -> unlock close - 03apr2021
    //form
    property handle:tbasic_handle read iform_handle;
    property paintdc:tbasic_handle read iform_paintdc;
    property state:char read getstate write setstate;
    property laststate:char read ilaststate;
    property caption:string read iform_caption write form__setcaption;
    property showing:boolean read getshowing;
    property active:boolean read iform_active;
    function mainwindow:boolean;
    property area:twinrect read form__getarea write form__setarea;
    property paintarea:twinrect read form__paintarea;
    property paintarea1:twinrect read form__paintarea1;
    property cursor:longint read getcursor write setcursor;
    property paint_tryagain_count:longint read ipaint_tryagain_count write ipaint_tryagain_count;

    property left   :longint read form__getleft   write form__setleft;
    property top    :longint read form__gettop    write form__settop;
    property width  :longint read iform_width  write form__setwidth;
    property height :longint read iform_height write form__setheight;

    procedure setbounds(dx,dy,dw,dh:longint);
    procedure setbounds2(dx,dy,dw,dh:longint;xforcerepaint:boolean);

    //rootwin
    function haverootwin:boolean;
    function rootwin:tbasicscroll;

    //low level debug support -> normal window mode and game mode now supported - 04jul2025
    procedure debug(yrow:longint;xtext:string);//04jul2025: persists in Gamemode, 26nov2024, 01aug2024

    //drag and drop - simple version - 21jul2024
    function dragdrop_start(dx,dy,dw,dh:longint;const dcode2:string):boolean;
    function dragdrop_start2(dx,dy,dw,dh,diconw,diconh:longint;dicon:tobject;const dcode2:string):boolean;
    function dragdrop_start3(dx,dy,dw,dh,diconw,diconh,dpower255:longint;dicon:tobject;const dcode2:string):boolean;
    function dragdrop_stop(var dcode2:string):boolean;
    function dragdrop_mustpaint:boolean;
    property dragdrop_active:boolean read idragdrop_dragging;//06jun2025
    //information
    function monitorindex:longint;//used for app__monitor* procs
    function bits:longint;//buffer.bits=24bit
    property showingoptions:boolean read ishowoptions_inuse;//07mar2022
    function stable:boolean;
    property alignid:longint read ialignid;
    property postpaint_fullid:longint read ipostpaint_fullid;
    property postpaint_partid:longint read ipostpaint_partid;
    property postpaint_id:longint read ipostpaint_id;//06jan2025
    property paintfirst:boolean read ipaintfirst;//system has rendered the first FULL paint - 17mar2025
    property paintid:longint read ipaintid;
    property painting:boolean read ipaintbusy;
    property paintingpart:boolean read ipaintingpart;
    property partpaintareaok:boolean read ipartpaintareaok;
    property ecopainting:boolean read iecopainting;//true=system has switched to reduced painting (eco mode), false=normal painting - 16nov2023
    property fps:longint read ifps;
    //showmenu support -> separate from tbasicontrol
    function canshowmenu:boolean;
    procedure showmenu(xsender:tobject;x:tstr8;xstyle:string;xevent:ttoolbarevent2);
    procedure showmenu1(xsender:tobject;x:tstr8;xstyle:string;xevent:ttoolbarevent2;var xcode:longint;var xcode2:string);
    procedure showmenu2(xsender:tobject;x:tstr8;xstyle,xmenuname:string;xtepcolor,ximagexalign:longint;xevent:ttoolbarevent2;var xcode:longint;var xcode2:string);
    //.window mask support
    property masking:boolean read imasking;//paint via mask8 layer support -> for fast, multiple overlapping window support - 17may2020
    function mustmask:boolean;
    property maskval:longint read getmaskval;
    property mask:tmask8 read imask;
    procedure ldbRESTORE(xdyanmicCorners:boolean;darea:twinrect;xround:boolean);//28nov2024
    //.background support
    property backgroundname:string read getbackgroundname write setbackgroundname;
    function backgroundmask:tmask8;
    function backgroundinuse:boolean;
    function backgroundinitmask:boolean;//08mar2025
    property backgroundmanager:tbackgroundmanager read ibackgroundmanager;
    //.buffer2 draw procs - 25dec2024
    procedure ldsOUTSIDE(dx,dy,dw,dh,dcol:longint);//21jul2025
    procedure lds(darea:twinrect;dcol:longint;xround:boolean);//25dec2024
    procedure ldso(darea:twinrect;dborder,dback:longint;xround:boolean);
    procedure ldso2(darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround:boolean);
    procedure ldso3(xdyanmicCorners:boolean;darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround,xdarktolight:boolean);
    procedure ldso4(xdyanmicCorners:boolean;dcliparea,darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround,xdarktolight:boolean);//28jun2024: fixed leak, improved clip handling - 02dec2023
    procedure ldt(darea:twinrect;dx,dy,dcol:longint;xline:string;xfontindex,xfeather:longint;xround:boolean);
    procedure ldtTAB2(xbackref:longint;const xtab:string;darea:twinrect;dx,dy,dcol:longint;xline:string;xfontindex,xfeather:longint;xbold,xitalic,xunderline,xstrikeout,xround:boolean);
    procedure ldtTAB4(xbackref:longint;const xtab:string;darea:twinrect;dx,dy,dcol:longint;xline:tstr8;xfontindex,xfeather:longint;xbold,xitalic,xunderline,xstrikeout,xround:boolean);
    //new handlers
    function nfullwin:tbasicscroll;
    function nwindow(da:twinrect):tbasicscroll;
    function nontop(da:twinrect):tbasicscroll;
    function ndlg(da:twinrect;xshowhead:boolean):tbasicscroll;
    function ndlg2(da:twinrect;xshowhead,xstatic:boolean):tbasicscroll;
    function ndlg3(da:twinrect;xtep:longint;xtitle:string;xshowhead,xstatic:boolean):tbasicscroll;
    function nstatus(xtitle:string):tbasicscroll;
    function nscroll(da:twinrect):tbasicscroll;
    function nsetcolor(da:twinrect;xshowhead:boolean):tbasicsetcolor;//27feb2021
    function nsetcolor2(da:twinrect;xshowhead,xuse32:boolean):tbasicsetcolor;//17nov2023
    //position support (left/right/top/bottom) - 27feb2022
    function canposition:boolean;
    procedure position(xstyle:string);//18nov2024
    //pop handlers
    //.special
    function popint(var xval:longint;xmin,xmax,xdef:longint;xtep32:longint;xtitle,xcap,xhelp,xcancelcap,xokcap:string;xsize:longint):boolean;
    //.edit
    function poppass(var x:string;xcap,xhelp:string):boolean;
    function popedit(var x:string;xcap,xhelp:string):boolean;
    function popedit_small(var x:string;xcap,xhelp:string):boolean;
    function popedit2(var x:string;xtep32:longint;xtitle,xcap,xhelp,xcancelcap,xokcap:string;xsize:longint):boolean;
    function popedit3(var x:string;xtep32:longint;xtitle,xcap,xhelp,xcancelcap,xokcap:string;xsize:longint;xpassword:boolean):boolean;
    function popmanyedit2(xcount:longint;var x:array of string;xtep32:longint;xtitle:string;xcap:array of string;xhelp:array of string;xcancelcap,xokcap:string;xsize:longint):boolean;
    function popmanyedit3(xcount:longint;var x:array of string;xtep32:longint;xtitle:string;xcap:array of string;xhelp:array of string;xcolorise:array of tinputcolorise;xcancelcap,xokcap:string;xsize:longint):boolean;
    //.txt - poptext()
    procedure poptxt0(x:string);//for display purposes only
    procedure poptxt02(x,xcap:string);//for display purposes only
    function poptxt(var x:string;xwrap:longint;const xcap,xhelp:string):boolean;
    function poptxt2(var x:string;xwrap:longint;xreadonly:boolean;const xcap,xhelp:string):boolean;
    function poptxt3(var x:string;xwrap:longint;xrows,xreadonly:boolean;const xcap,xhelp,xcancelcap,xokcap:string):boolean;
    function poptxt4(var x:string;xwrap:longint;xrows,xreadonly:boolean;const xcap,xhelp,xcancelcap,xokcap,xstyle:string;xscaleW,xscaleH:single):boolean;
    function poptxt8(xtext:tstr8;xwrap:longint;xrows,xreadonly:boolean;const xcap,xhelp,xcancelcap,xokcap,xstyle:string):boolean;//12jan2025
    function poptxt82(xtext:tstr8;xwrap:longint;xrows,xreadonly:boolean;const xcap,xhelp,xcancelcap,xokcap,xstyle:string;xscaleW,xscaleH:single):boolean;//12jan2025
    function poptxt__event2(a:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    //.query
    function popquery(x:string):boolean;
    function popquery1(xtitle,x:string):boolean;
    function popquery2(x,xcancelcap,xokcap:string;xlarge:boolean):boolean;
    function popquery20(xtitle,x,xcancelcap,xokcap:string;xlarge:boolean):boolean;
    function popquery21(x,xcancelcap,xokcap:string;xlarge,xOKtime:boolean):boolean;
    function popquery22(xtitle,x,xcancelcap,xokcap:string;xlarge,xOKtime:boolean):boolean;
    function popqueryex(x,xcancelcap,xokcap:string;dw,dh,ccancel,cok:longint):boolean;
    function popqueryex2(xtitle,x,xcancelcap,xokcap:string;dw,dh,ccancel,cok:longint):boolean;
    function pop_replaceall_skipall(xtitle,xfilename:string):longint;
    //.error
    function poperror(xtitle,x:string):boolean;
    function poperror2(xtitle,x,xclosecap:string;xlarge:boolean):boolean;
    function poperrorex(xtitle,x,xclosecap:string;dw,dh,cclose:longint):boolean;
    //.status
    function popstatus(xmsg:string;xshowsec:longint):boolean;//19jul2024: oshadeback=true, 03jnov2023
    //.msg
    function popmsg(xtitle,x:string):boolean;//23jul2024
    //.info
    function popinfo(xtitle,x:string):boolean;
    function popinfo2(xtitle,x,xclosecap:string;xlarge:boolean):boolean;
    function popinfoex(xtitle,x,xclosecap:string;dw,dh,cclose:longint):boolean;
    function poperrorORinfo(xtitle,x,xclosecap:string;dw,dh,cclose:longint;xinfo:boolean):boolean;//03jun2021
    function poperrorORinfo2(xtitle,x,xclosecap:string;dw,dh,cclose:longint;xinfo,xshowicon:boolean):boolean;//23jul2024
    //.find
    function popfind(xhandler:longint;var xtext,xcmd:string):boolean;
    //.menu
    function popmenu(xpopstyle,ximagealign:longint;xmenudata:tstr8;var xcode:longint;var xcode2:string;var xtepcolor:longint):boolean;
    function popmenu2(xpopstyle,ximagealign:longint;xmenudata:tstr8;xmenuname:string;xstyle:longint;var xcode:longint;var xcode2:string;var xtepcolor:longint):boolean;
    function popmenu2b(xpopstyle,ximagealign:longint;xmenudata:tstr8;xcontrol:tbasiccontrol;xmenuname:string;xstyle:longint;var xcode:longint;var xcode2:string;var xtepcolor:longint):boolean;
    function popmenu3(xpopstyle,ximagealign:longint;xmenudata:tstr8;xcontrol:tbasiccontrol;xstyle,xpos,xhover,xselstart,xselcount:longint;var xoutpos,xouthover,xoutselstart,xoutselcount,xcode:longint;var xcode2:string;var xtepcolor:longint):boolean;
    function popmenu4(xpopstyle,ximagealign:longint;xmenudata:tstr8;xcontrol:tbasiccontrol;xshowhelp:boolean;xstyle,xdropcount,xpos,xhover,xselstart,xselcount:longint;var xoutpos,xouthover,xoutselstart,xoutselcount,xcode:longint;var xcode2:string;var xtepcolor:longint):boolean;
    function popmenu5(xpopstyle,ximagealign:longint;xmenudata:tstr8;xcontrol:tbasiccontrol;xshowhelp:boolean;xstyle,xdropcount,xpos,xhover,xselstart,xselcount:longint;var xoutpos,xouthover,xoutselstart,xoutselcount,xcode:longint;var xcode2:string;var xtepcolor:longint;xfindbycode2:string):boolean;//13apr2025, 18mar2025, 07jul2021
    //.droplist -> simulates a dropdown list -> must specify a control via "xcontrol" - 04oct2020
    function popdroplist(xmenudata:tstr8;xcontrol:tbasiccontrol;var xpos,xcode:longint;var xcode2:string;xfindbycode2:string):boolean;
    function popdroplist2(xmenudata:tstr8;xcontrol:tbasiccontrol;xdropcount:longint;var xpos,xcode:longint;var xcode2:string;xfindbycode2:string):boolean;
    //.io
    function popopenimg(var xfilename:string;var xfilterindex:longint;xcommonfolder:string):boolean;//12apr2021
    function popsaveimg(var xfilename:string;xcommonfolder:string;var daction:string):boolean;//12apr2021
    function popsaveimg2(var xfilename:string;xcommonfolder,xtitle2:string;var daction:string):boolean;//18jun2021, 12apr2021
    function popsaveimg3(var xfilename:string;xcommonfolder,xtitle2:string;xanimationformats,xlossless:boolean;var daction:string):boolean;//08nov2025, 18jun2021, 12apr2021
    function popopencur(var xfilename:string;var xfilterindex:longint;xcommonfolder:string;xmore:boolean):boolean;//29aug2021
    function popopen(var xfilename:string;var xfilterindex:longint;xfilterlist,xcommonfolder:string):boolean;
    function popopen2(var xfilename:string;var xfilterindex:longint;xfilterlist,xcommonfolder,xtitle2:string):boolean;
    function popopen3(var xfilename:string;var xfilterindex:longint;xfilterlist,xcommonfolder,xtitle2:string;xcanpreview:boolean):boolean;
    function popsave(var xfilename:string;xfilterlist,xcommonfolder:string;var daction:string):boolean;
    function popsave2(var xfilename:string;xfilterlist,xcommonfolder,xtitle2:string;var daction:string):boolean;
    function popsave3(var xfilename:string;xfilterlist,xcommonfolder,xtitle2:string;var daction:string;xcanpreview:boolean):boolean;
    function popfolder(var xfilename:string;const xcommonfolder:string):boolean;
    function popfolder1(var xfilename:string;const xmasklist,xcommonfolder:string):boolean;
    function popfolder2(var xfilename:string;const xmasklist,xcommonfolder:string;xshowfiles,xcanpreview:boolean):boolean;
    function popnewfolder(xfolder:string;var xoutfolder:string):boolean;//14apr2021
    function popfolderimg(xfolder:string):boolean;
    function popfav(var xfilename:string):boolean;
    function popnav(var xfilename:string;xcommonfolder:string):boolean;
    //.color
    function popcolorstatic(var xvalue:longint):boolean;
    function popcolorhistory(var xvalue:longint;xuse32:boolean):boolean;
    function popcolorhistory__add(xvalue:longint;xuse32:boolean):boolean;
    function popcolorhistory__edit:boolean;
    function popcolor(var xvalue:longint):boolean;
    function popcolor2(var xvalue:longint;xuse32:boolean):boolean;
    //..color support
    function xcolorhistory(var xvalue:longint;xaddonly,xeditonly,xuse32:boolean):boolean;//17nov2023, 19mar2021
    //.font - 26mar2022
    function popfont(var xfontname:string):boolean;//26mar2022
    function popfont2(var xfontname:string;xscreen,xprinter,xspecial,xaslist:boolean;xpopcontrol:tbasiccontrol):boolean;//05jun2025, 15nov2023

    //.pop dialogs
    procedure xsafepopXYWHex(var dx,dy,dw,dh:longint;dy2:longint);//15NOV2010
    function xshowwait(a:tbasicscroll;xpreviouscontrol:tbasiccontrol;xpreviousfocus:longint):boolean;
    function xshowwait2(a:tbasicscroll;xpreviouscontrol:tbasiccontrol;xpreviousfocus,xtimeout:longint):boolean;
    function xshowwait3(a:tbasicscroll;xpreviouscontrol:tbasiccontrol;xpreviousfocus,xtimeout:longint;xlimitsize:boolean):boolean;//09dec2024
    function xpopwait(a:tbasicscroll;xpreviousfocus,dw,dh:longint;xcenter:boolean):boolean;//21may2020
    function xpopwait2(a:tbasicscroll;xcontrol:tbasiccontrol;xpreviousfocus,dw,dh:longint;xcenter:boolean):boolean;//21may2020
    procedure xclose(a:tbasiccontrol);
    procedure xcloseok(a:tbasiccontrol);
    //.wait support - 03apr2021
    function xhavewaitfocusLOOSE:boolean;//06apr2021
    procedure xwaitfocus;
    //window handlers
    procedure showappmenu(xallwinbuttons:boolean);//07sep2025, 27dec2024
    property winhover:longint        read iwinhover;
    property winhoverlayer:longint   read iwinhoverlayer;
    property winfocus:longint        read iwinfocus write setwinfocus;
    property winfocuslayer:longint   read iwinfocuslayer;
    function xwinfindlayer(xcoreindex:longint;var xlayer:longint):boolean;
    function xwinfindbyxy(sx,sy:longint;var xcoreindex,xwinlayer:longint):boolean;
    procedure xwintop(x:tbasiccontrol);
    procedure xwinbot(x:tbasiccontrol);
    procedure xwinnil(x:tbasiccontrol);
    procedure xwinadd(x:tbasiccontrol;xstyle:char);
    function xdlg(var x:tbasiccontrol):boolean;//get active dialog window
    function xfindwinname(xwinname:string;var x:tbasicscroll):boolean;
    function wtop(var x:tbasiccontrol;var xindex:longint):boolean;//xxxxxxxxxxxxx//dodgy, needs upgrading........
    function xacceptfindbyxy(sx,sy:longint;var xout:tbasiccontrol):boolean;//updated - 20mar2022
    procedure xsync_opacity;//02dec2024: streamlined viopacityspeed
    //.drag support
    procedure dragstart(xcoreindex:longint);
    procedure dragstart_fullwin;//this relates to external OS only and NOT to our internal system - 15apr2021
    procedure dragstop;
    function dragging:boolean;//21nov2024
    function dragging_an_internal_window:boolean;//28nov2024
    //..drag support
    property dragging_fullwin:boolean read idragging_fullwin;
    property dragindex:longint read idragindex;//coreindex
    //.size support
    procedure sizestart(xcoreindex:longint);
    procedure sizestop;
    function resizing:boolean;//15mar2025
    property sizing:longint read isizing;//0=off, 1=resizing MAIN window (wm_fullwin), 2=resizing OTHER window types - 22apr2022
    //.status support
    procedure xstatuspaintnow;
    procedure xstatusstart(xrowcount:longint);
    procedure xstatusstart2(xrowcount:longint;const xtab:string);//15may2022
    procedure xstatusstart3(xrowcount:longint;const xtab:string;xresetcancel:boolean);//20may2022
    procedure xstatusstop;
    property xstatustopped:boolean read getstatusstopped;
    procedure xstatus(xpert:double;xtitle:string);//15may2022
    property xstatustext[xindex:longint]:string read getstatustext write setstatustext;
    property xstatustep[xindex:longint]:longint read getstatustep write setstatustep;
    procedure xstatustab(const xtab:string);//15may2022
    procedure xstatus_sysstatus_alloff;
    property xstatustitle:string read istatustitle;
    property xstatuspert:double read istatuspert write setstatuspert;
    //system handlers
    procedure xcenter(x:tbasiccontrol);
    procedure xshowsplash;
    procedure xshowabout;
    procedure xshowoptions;//06nov2025, 05may2025, 02dec2024: font+settings.vpos, 14nov2024
    procedure xshowhelp;
    procedure xdefaults;
    procedure xdefaultzoom;
    procedure xsnapshot;//03nov2023
    //black and white mode -> emergency paint mode that renders GUI on screen with black and white coloring regardless of user/system settings - 09dec2024
    procedure startbw(xpaint:boolean);
    procedure stopbw(xpaint:boolean);
    //core handlers
    property core[x:longint]:tbasiccontrol read getcore;
    property corecount:longint read icorecount;
    function xrootok(x:tbasiccontrol):boolean;
    function xinuse(xcoreindex:longint):boolean;
    function xvisible(xcoreindex:longint):boolean;
    procedure mustclose;
    function xsafeown(var xownlist:townlist):boolean;
    function xownhave(var xownlist:townlist;x:tbasiccontrol):boolean;
    function xownfind(var xownlist:townlist;x:tbasiccontrol;var xownslot:longint):boolean;
    function xownfindcount(var xownlist:townlist):longint;
    function xownadd(var xownlist:townlist;x:tbasiccontrol):boolean;
    procedure xowndel(var xownlist:townlist;x:tbasiccontrol);
    function xownget(var xownlist:townlist;xownslot:longint;var x:tbasiccontrol):boolean;
    function xowndel__fast(var xownlist:townlist;xownslot:longint):boolean;//04may2021
    procedure ownadd(xhost,xcontrol:tobject);
    procedure owndel(xhost,xcontrol:tobject);
    function xareaok(var x:twinrect):boolean;
    function xareaokb(x:twinrect):boolean;
    function xareaongui(x:twinrect):boolean;
    function xareaseen(sa:twinrect;xbeneathwindowlayer:longint):boolean;//can a square (non-rounded) area be seen in anyway beneath the window stack from window "xbeneathwindowlayer" and up -> if so, then return TRUE else return FALSE - 22may2020
    function xadd(x:tbasiccontrol;var xcoreindex:longint):boolean;
    function xdel(xcoreindex:longint;xfree:boolean):boolean;
    //pop support
    property pophost:tbasiccontrol read ipophost;//pointer only, may be nil at anytime - 01apr2020
    property popshortcut:longint read ipopshortcut write ipopshortcut;//this is the shortcut the user executed whilst the menu was up and active, default=aknone -> no shortcut was triggered - 02apr2020
    //mouse system
    procedure xfindany(sx,sy:longint;var xfocusindex,xhoverindex,xsizemode,ysizemode:longint);//17aug2025
    property hoverindex:longint read ihoverindex write sethoverindex;
    property focusindex:longint read ifocusindex write setfocusindex;
    property focuscontrol:tbasiccontrol read getfocuscontrol write setfocuscontrol;
    property focussizemodex:longint read ifocussizemodex;//resize by x-coor
    property focussizemodey:longint read ifocussizemodey;//resize by y-coor
    property downrect:twinrect read idownrect;//area of control that has focus when mouse is clicked down
    property form__downrect:twinrect read iform_downrect;//area of host form when mouse is clicked down
    function indexstyle(xindex:longint):longint;
    function styleindex(xstyle:longint):longint;
    //.local cursor support -> cursor position within system area
    function curpos:tpoint;//our internal cursor position (within the system area only) - 21may2020
    function downcurpos:tpoint;//our internal cursor position (within the system area only) - 21may2020
    procedure showcursor;//28feb2022
    procedure hidecursor;//28feb2022
    function showingcursor:boolean;//06dec2024
    //.localised coordinates
    property mousedbclick:boolean read imousedbclick;//double click
    property mousedown:boolean read imousedown;
    function mousedowntime:comp;//09mar2022
    property mousewasdown:boolean read imousewasdown;
    property mousedownxy:tpoint read imousedownxy;
    property mousemovexy:tpoint read imousemovexy;
    //.takes ~20px(xfine=false) or 1px(xfine=true) to start and MUST be outside to START of specified controls' area - 09mar2021, 25feb2021
    function mousedraggingout(x:tbasiccontrol;xkeepchecking,xfine:boolean):boolean;
    function mousedraggingout2(x:twinrect;xkeepchecking,xfine:boolean):boolean;
    function mousedraggingout3(xoffx,xoffy:longint;x:twinrect;xkeepchecking,xfine:boolean):boolean;
    property mousewasdraggingout:boolean read iscreendraggingout;
    //.takes ~20px to start
    property mousedragging:boolean read iscreendragging;
    property mousedraggingv:boolean read iscreendraggingv;
    property mousedraggingh:boolean read iscreendraggingh;
    //.takes ~1px to start
    property mousedraggingfine:boolean read iscreendraggingfine;
    property mousedraggingfinev:boolean read iscreendraggingfinev;
    property mousedraggingfineh:boolean read iscreendraggingfineh;
    //.other
    property mousemoved:boolean read imousemoved;//mouse moved
    property mousemovingfine:boolean read iscreenmovingfine;//takes ~2px - 27feb2022
    function mousedownstroke:boolean;//mouse has been clicked down
    function mouseupstroke:boolean;//mouse has released the click
    //.strictly ONCE up and down detectors - excludes MOVE events
    function mousedownonce:boolean;//strictly excludes ANY move events - triggers ONLY once - 19nov2023
    function mouseuponce:boolean;//strictly excludes ANY move events - triggers ONLY once - 19nov2023
    //.button modes
    property mousebutton:longint read imousebutton;//abnone, ableft, abcenter, abright
    function mousenone:boolean;
    function mouseleft:boolean;
    function mousecenter:boolean;
    function mouseright:boolean;
    //.special key
    property shiftok:boolean read ishiftok;
    property altok:boolean read ialtok;
    property ctrlok:boolean read ictrlok;
    property key:longint read ikey write ikey;//aknone=off
    property wheel:longint read iwheel;//0=off - wheel movement
    //.wound rates & direction - 30sep2022
    function woundratexpert1:extended;//0.0..1.0
    function woundrateypert1:extended;//0.0..1.0
    function woundratexpert100:longint;//0..100
    function woundrateypert100:longint;//0..100
    function woundratextime(xmaxtime:longint;xincludedir:boolean):longint;
    function woundrateytime(xmaxtime:longint;xincludedir:boolean):longint;
    property woundratex:longint read iwoundratex;//0..woundratelimit
    property woundratey:longint read iwoundratey;//0..woundratelimit
    property woundratelimit:longint read iwoundratelimit;
    property wounddirx:longint read iwounddirx;//-1=left, 1=right OR stopped
    property wounddiry:longint read iwounddiry;//-1=up,   1=down  OR stopped
    //.screen coordinates
    property screendragging:boolean read iscreendragging;
    property screendraggingfine:boolean read iscreendraggingfine;
    property screendraggingout:boolean read iscreendraggingout;//25feb2021
    property screendownxy:tpoint read iscreendownxy write iscreendownxy;
    property screenmovexy:tpoint read iscreenmovexy write iscreenmovexy;
    //action support
    function aadd(xs:char;xm:byte;xx,xy:longint):boolean;
    function apull(var xs:char;var xm:byte;var xx,xy:longint):boolean;
    procedure anext;//next action
    procedure amouseupfinalise;//14may2020
    //timer + paint support
    function  xtimerinterval:longint;
    property  xmustpaint:longint read imustpaint;
    //.paint support
    property buffer :twinbmp read ibuffer;
    property buffer2:twinbmp read ibuffer2;
    property paintedwithtile:boolean read ipaintedwithtile;
    function rows:tstr8;
    function rows2:tstr8;
    function lastbuffer:twinbmp;
    function lastrows:tstr8;
    //events
    procedure _onnotify(sender:tobject;xstyle:char);//06jan2025
    procedure _onnotifylast(sender:tobject;xhandled:boolean);
    function  _onshortcut(sender:tobject):boolean;
    function _onshortcutlast(sender:tobject):boolean;//09dec2024
    property onshortcut:tsystemnotify read fonshortcut write fonshortcut;//11feb2023
    property onkey:tsystemkeyevent read fonkey write fonkey;//22jul2025 - general purpose support
    //additional support
    procedure paintallnow;
    procedure paintnow;
    procedure alignallnow;
    procedure alignnow;
    procedure sizenow;
    procedure fullalignpaint;
    //special events
    property ontimer:tnotifyevent read fontimer write fontimer;//main timer -> itimer

    //game mode -> switching into gamemode=true disables all GUI related paint procs and hands control of the GUI screen over to the host for direct rendering with a 200-300% performance increase - 29jan2025
    property gamemode:boolean                    read igamemode            write setgamemode;//29jan2025
    property gamemode__cansize:boolean           read igamemode_cansize    write igamemode_cansize;
    property gamemode__canmove:boolean           read igamemode_canmove    write igamemode_canmove;
    property gamemode__onpaint:tnotifyevent      read igamemode_onpaint    write igamemode_onpaint;
    property gamemode__onkey:tsystemkeyevent     read igamemode_onkey      write igamemode_onkey;
    property gamemode__onmouse:tsystemmouseevent read igamemode_onmouse    write igamemode_onmouse;//26jul2025
    property gamemode__onnotify:tsystemnotify    read igamemode_onnotify   write igamemode_onnotify;
    property gamemode__onshortcut:tsystemnotify  read igamemode_onshortcut write igamemode_onshortcut;

    //.raw access to form's paint handle
    function xdrawfrom(shc:tbasic_handle;sa:twinrect):boolean;
    function xdrawfrom2(shc:tbasic_handle;dx,dy:longint;sa:twinrect):boolean;
    function xcopyfrom(shc:tbasic_handle;sa,da:twinrect):boolean;
   end;

{tbasiccontrol}
   tbasiccontrol=class(tobject)
   private
    igui:tbasicsystem;//pointer only -> never nil
    iparent:tbasiccontrol;
    ioffloading,imustalign,imustpaint,icreating,idestroying,ialigned,ipainted,ipainting,ialigning,itimer,itiming,ienabled,ivisible,inormal:boolean;
    iclientarea:twinrect;//area of control (visible bits or not)
    ipaintarea:twinrect;//area of control that is visible (invalid rect if nothing is visible at all)
    icaption,ihint,ihelp,ihelp2,isubhelp,isubhelp2:string;
    irichstart,iwoundtime,imakemode,iid,iaid,iwinstyle,iparentcoreindex,icoreindex,iheightref,ibordersize:longint;
    iidleREF64,iwoundtimer:comp;
    fontimer2,fonvalue,fonalign,fonpaint:tnotifyevent;
    fonnotify:tsystemnotify;
    fonaccept:tonacceptevent;//18jun2021
    fonfindheight:tonfindheight;//06jul2021
    fonwinLdrcolor:tlongintgetevent;
    //.show menu support
    ishowmenu:tstr8;//default=nil
    fshowmenuFill1,fshowmenuFillINT,fshowmenuFill2:tmenufillevent;
    fshowmenuClick1,fshowmenuClickINT,fshowmenuClick2:ttoolbarevent2;
    fonshowmenu:tnotifyevent;//optional override
    //.makeImageViewer support - 22may2022
    ifindinfo:array[0..5] of string;
    iimagebuffer:tbasicimage;//dedicated image buffer -> DOES own the image
    iimagebufferi:tbasicimage;//pointer only -> does NOT own the image
    iimagebufferinfo,iimagebuffermustfile,iimagebufferlastfile:string;
    iimagebuffertimer:comp;
    iimagebufferbackcolor:longint;//clnone=default background color
    iimagebufferinfocountcolors:boolean;//default=false
    iimagebufferid:longint;//changes each time a image is viewed
    iimagebufferworking:boolean;
    procedure setbordersize(x:longint);
    function gethelpline:string; virtual;
    function gethintline:string; virtual;
    procedure setparent(x:tbasiccontrol);
    procedure setvisible(x:boolean);
    procedure setenabled(x:boolean);
    procedure setclientarea(a:twinrect);
    function getleft:longint;
    function gettop:longint;
    function getclientwidth:longint;
    function getclientheight:longint;
    procedure setclientwidth(x:longint);
    procedure setclientheight(x:longint);
    procedure setwinstyle(x:longint);
    procedure setcaption(x:string);
    procedure __onimageviewertimer(sender:tobject);//22may2022
    procedure setimagebufferbackcolor(x:longint);//05dec2024
    procedure setnormal(x:boolean); virtual;//19jul2025
   public
    //options
    oflatback:boolean;
    oborderdiff:longint;//default=0
    obackmaskenabled:boolean;//default=false -> for window controls only
    oheadbase:longint;//0=default=off, 1=part of window head, 2=part of window base
    omade:longint;//default==0=made_none -> helps the control know what to do when it "makes" itself into special handler - 23mar2022
    ominimal:boolean;//default=false
    ocanshowmenu:boolean;//default=false
    obold:boolean;//default=false, true=use bold font for text if supported - 03mar2021
    oparentcorners:boolean;//default=true=draws control's corners with parent's background color when the control is ROUNDED - 07oct2020
    osafearea:boolean;//default=true=only for window controls
    oroundstyle:longint;//default=1=corRound
    osquareframe:boolean;//default=false=based on "oroundstyle", true=square frame even if control is round - 02dec2023
    oautotop:boolean;//default=true=when a window it is automatically brought to top of it's stack, false=retain stack order
    ominheight:longint;//default=0=off, use to specify another height other than "getalignheight"
    ominwidth:longint;//default=0=off, use to specify another width other than "getalignwidth"
    oautoheight:boolean;//default=false=no auto fit, true=fit to remaining vertical screen space - 01mar2021
    oautowidth:boolean;//default=false
    oautofocus:boolean;//default=false, true=set this control to be focused when form shows - 31mar2020
    osoftclose:boolean;//default=false=use system default, true=always softclose such as a popup menu - 03apr2021
    owinname:string;//default=<nil>, optional - set a window name -> e.g. "sys:options" or "sys:help" or "user1" etc - 14aug2020
    opagename:string;//default=<nil>, set to a name e.g. "user" to show/hide using the "form.page:=<page name here>" option - 04apr2020
    oseph:longint;//optional horizontal separation spacing, default=0 -> for use with tbasicscroll class of controls etc
    osepv:longint;//optional vertical separation spacing, default=0   -> for use with tbasicscroll class of controls etc
    oalignvert:boolean;//default=true=align control full width and vertically, else align by ominwidth/getalignwidth and horizontally - 22apr2020
    oframebrightness:longint;//default=100, 0..100
    oframebrightnessDARK:longint;//default=0=black -> color used to fade downto when brightness drops below 100%
    //.special colors
    ospbackcolor:longint;//default=clnone, override background color - 17aug2020
    ospbackname:string;//default=<nil>, override background color with a color name via "low__color()" - 19aug2020
    oinputcolorise:tinputcolorise;
    //.override colors
    obackcolor:longint;//default=clnone, override back color - 22mar2021
    otextcolor:longint;//default=clnone, override text color - 22mar2021
    owinLdrCOLOR:longint;//default=clnone, override system CORNER patch color - 07mar2022
    oframecolor:longint;//default=clnone, override system frame color - 17mar2021
    oframecolor2:longint;
    oborderstyle:longint;//default=0=internal, 1=system "vibordersize", 2=50% of system "vibordersize" - 17aug2020
    owinresizeable:boolean;//default=false
    oimagealign:longint;//default=iaNormal
    otab:string;//default=tbNone - 23feb2021
    //.tag support
    tag    :longint;
    tag2   :longint;
    tagstr :string;//05aug2020
    tagobj :tobject;//14aug2020
    //.optional  pointers - 15mar2021
    bc1:tbasiccontrol;
    bc2:tbasiccontrol;
    bc3:tbasiccontrol;
    bc4:tbasiccontrol;
    //own support
    ownlist:townlist;
    ownid:longint;//04apr2020
    //window support/menu/feedback support -> return codes for "clicked" menu item - 29aug2020
    ocode:longint;
    ocode2:string;
    otepcolor:longint;//02mar2021
    mkescape:boolean;
    mkreturn:boolean;
    //system info
    paintid:longint;//used internally to trigger a paint reguest
    postpaintid:longint;//increments after each repaint to screen -> handled internally by tbasicsystem - 05dec2024
    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure destroychildren; virtual;//1st
    procedure destroyothers; virtual;//2nd
    procedure start;//04jul2021
    function stable:boolean;
    function xsetclientarea(a:twinrect):boolean; virtual;
    function xlimitsize:boolean; virtual;
    function xfindheight(xclientwidth:longint;var xheight:longint):boolean;
    function getalignheight(xclientwidth:longint):longint; virtual;
    function getalignwidth(xclientheight:longint):longint; virtual;
    function client:tbasiccontrol; virtual;
    procedure xparentcorners;
    procedure xresizer; virtual;//25feb2021
    function canautoheight:boolean; virtual;//26feb2021
    function setbc14(v1,v2,v3,v4:tbasiccontrol):boolean;//15mar2021
    procedure xfaster;//boost system performance for upto 5sec - 25jul2021
    property _mustpaint:boolean read imustpaint write imustpaint;//17nov2023
    //system handlers
    //.timer
    property timer:boolean read itimer write itimer;//start or stop calling of "_ontimer()"
    procedure xtimer;//internal use only - 02sep2025
    //.align
    procedure alignpaintnow__heightcheck(xalign,xpaint:boolean;xclientwidth:longint);//06jan2025
    procedure alignallnow;
    procedure alignnow;
    procedure parentalignnow;
    procedure xalign;//internal use only
    property xmustalign:boolean read imustalign write imustalign;
    //.onvalue
    procedure xonvalue; virtual;
    //.winstyle
    property winstyle:longint read iwinstyle write setwinstyle;
    function iswin:boolean;//true=control is a window
    function xwinfocused:boolean;
    function xwindow(var x:tbasiccontrol):boolean;//return our containing window
    function xwindow2(var x:tbasicscroll):boolean;//return our containing window
    function xwindowhasbackmask:boolean;//04dec2024
    function xwindowhasbackmask2:tmask8;//04dec2024
    function xwindowindex:longint;
    //.paint
    procedure paintallnow;
    procedure paintnow; virtual;//17nov2023
    procedure parentpaintnow;
    procedure paintimmediate;//use sparingly - 09sep2021
    function xcanpaint:boolean;
    function xcanpaint_fast:boolean;//checks only the current layer -> assumes all previous layers have already been checked -> done for maximum speed - 05apr2020
    function xpaint:boolean;//internal use only
    property xmustpaint:boolean read imustpaint write imustpaint;
    function xmustpaintcount:longint;
    property painted:boolean read ipainted;
    property aligned:boolean read ialigned;
    function parentpainted:boolean;
    function parentaligned:boolean;
    function minimal:boolean; virtual;
    //.align+paint
    procedure alignpaintnow;//05oct2020
    procedure alignpaintallnow;//05oct2020
    //.focus
    function focused:boolean;
    procedure setfocus; virtual;
    procedure setfocusforce;//19jul2025
    //showmenu
    function canshowmenu:boolean; virtual;
    procedure showmenu; virtual;
    procedure showmenu2(xstyle:string); virtual;
    procedure autoshowmenu;//detects when menu should be displayed and displays it - 15mar2021
    procedure autoshowmenu2(xstyle:string);
    function mustshowmenu:boolean;//detects when menu should be displayed
    //.fill
    procedure showmenuFill(xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string); virtual;
    property showmenuFill1:tmenufillevent read fshowmenuFill1 write fshowmenuFill1;
    property showmenuFillINT:tmenufillevent read fshowmenuFillINT write fshowmenuFillINT;
    property showmenuFill2:tmenufillevent read fshowmenuFill2 write fshowmenuFill2;
    //.click
    function showmenuClick(sender:tobject;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean; virtual;
    property showmenuClick1:ttoolbarevent2 read fshowmenuClick1 write fshowmenuClick1;
    property showmenuClickINT:ttoolbarevent2 read fshowmenuClickINT write fshowmenuClickINT;
    property showmenuClick2:ttoolbarevent2 read fshowmenuClick2 write fshowmenuClick2;
    //.onshowmenu -> optional external event handler
    property onshowmenu:tnotifyevent read fonshowmenu write fonshowmenu;
    //sync control values from/to system handlers
    function xfromsys(xname:string):boolean;
    function xfromprg(xname:string):boolean;
    function xfromprg2(xname:string;dvars:tvars8):boolean;//prgsettings -> control -> dvars (allows for filtering of value) - 25mar2021
    function xtosys(xname:string):boolean;
    function xtoprg(xname:string):boolean;
    function xfrom(sender:tbasiccontrol;xvars:tvars8;xname:string):boolean; virtual;
    function xto(sender:tbasiccontrol;xvars:tvars8;xname:string):boolean; virtual;
    //core
    property gui:tbasicsystem read igui;//never nil
    property coreindex:longint read icoreindex;//0..N only -> position within "gui.core[n]"
    property parent:tbasiccontrol read iparent write setparent;
    property parentcoreindex:longint read iparentcoreindex;//0..N and "-1" if a root control - 19mar2020
    property xvisible:boolean read ivisible write ivisible;
    property visible:boolean read ivisible write setvisible;
    property enabled:boolean read ienabled write setenabled;
    function visibletohost:boolean;//true=control is visible and all controls directly beneath to "host form" (control.parent=nil) are visible too
    function enabledtohost:boolean;//true=control is visible and all controls directly beneath to "host form" (control.parent=nil) are enabled too
    function havecontrol(x:tbasiccontrol):boolean;//04oct2024
    function rootparent:tbasiccontrol;//01aug2021
    function areatohost(da:twinrect):twinrect;
    function setbounds(x,y,w,h:longint):boolean;
    property clientarea:twinrect read iclientarea write setclientarea;
    property left:longint read getleft;
    property top:longint read gettop;
    function headheight:longint; virtual;//25jan2021
    function clientspace:twinrect;//rect(0,0,clientwidth-1,clientheight-1) - 11apr2020
    function clientinner:twinrect;
    function clientinner2(x:tbasiccontrol):twinrect; virtual;
    property clientwidth:longint read getclientwidth write setclientwidth;
    property clientheight:longint read getclientheight write setclientheight;
    property paintarea:twinrect read ipaintarea;//visible area of control to paint
    function yshift:longint;
    function xshift:longint;
    procedure ownidInc;
    //.area handlers
    function xinside(x:tpoint):boolean;//local coordinates
    function xinside2(sx,sy:longint):boolean;//local coordinates
    function xinsideclientarea(x:tpoint):boolean;
    function xinsideclientarea2(sx,sy:longint):boolean;
    //.local mouse support
    function mousedownxy:tpoint;
    function mousemovexy:tpoint;
    function mouseinside:boolean;
    function mouseinsideclientarea:boolean;
    function translatexy(a:tpoint):tpoint;//09jan2025
    function cursorxy:tpoint;//05may2025
    //.local draw support -> special draw procs for non-ms and non-delphi graphic drawing - 09apr2020
    procedure ldv(dx,dy,dy2,dcol:longint;xround:boolean);
    procedure ldv2(dx,dy,dy2,dcol:longint;xdot,xround:boolean);
    procedure ldv3(dcliparea:twinrect;dx,dy,dy2,dcol:longint;xdot,xround:boolean);
    procedure ldh(dx,dx2,dy,dcol:longint;xround:boolean);
    procedure ldh2(dx,dx2,dy,dcol:longint;xdot,xround:boolean);
    procedure ldh3(dcliparea:twinrect;dx,dx2,dy,dcol:longint;xdot,xround:boolean);
    procedure ldsOUTSIDE(dx,dy,dw,dh,dcol:longint);//02jun2021
    procedure lds(darea:twinrect;dcol:longint;xround:boolean);//draw solid area
    procedure lds1(xdyanmicCorners:boolean;darea:twinrect;dcol:longint;xround:boolean);
    procedure lds2(darea:twinrect;dcol,dcol2,dcol3,drich:longint;xoptions:string;xround:boolean);
    procedure lds2ex(var xbackref:longint;darea:twinrect;dcol,dcol2,dcol3,drich:longint;xoptions:string;xround:boolean);
    procedure lds3(xdyanmicCorners:boolean;darea:twinrect;dcol,dcol2,dcol3,drich:longint;xoptions:string;xround,xdarktolight:boolean);
    procedure ldo(darea:twinrect;dcol:longint;xround:boolean);//draw hollow area
    procedure ldo2(darea:twinrect;dcol,dcol2,dcol3,drich:longint;xoptions:string;xround:boolean);
    procedure ldo3(xdyanmicCorners:boolean;darea:twinrect;dcol,dcol2,dcol3,drich:longint;xoptions:string;xround,xdarktolight:boolean);
    procedure ldsoSHADE(darea:twinrect;xshadebackcol,xshadepeakcol,xcornercol,drich:longint;xoptions:string;xsolid,xround:boolean);
    procedure ldso(darea:twinrect;dborder,dback:longint;xround:boolean);
    procedure ldsob(dcliparea,darea:twinrect;dborder,dback:longint;xround:boolean);
    procedure ldso2(darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround:boolean);
    procedure ldso2ex(var xbackref:longint;darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround:boolean);
    procedure ldso2b(dcliparea,darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround:boolean);
    procedure ldso3(xdyanmicCorners:boolean;darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround,xdarktolight:boolean);
    procedure ldso3b(xdyanmicCorners:boolean;dcliparea,darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround,xdarktolight:boolean);
    procedure ldso4(xdyanmicCorners:boolean;dcliparea,darea:twinrect;dborder,dborder2,dback,dback2,dback3,drich:longint;xoptions:string;xround,xdarktolight:boolean);//28jun2024: fixed leak, improved clip handling - 02dec2023
    procedure ldr(darea:twinrect;dcol:longint;xround:boolean);
    procedure ldr2(darea:twinrect;dcolTL,dcolTR,dcolBL,dcolBR,drich:longint;xoptions:string;xround:boolean);
    procedure ldr3(xdynamicCorners:boolean;darea:twinrect;dcolTL,dcolTR,dcolBL,dcolBR,drich:longint;xoptions:string;xround:boolean);
    property onwinLdrcolor:tlongintgetevent read fonwinLdrcolor write fonwinLdrcolor;
    function winLdrCOLOR:longint; virtual;//24feb2022
    procedure winLdr;
    procedure ldf(darea:twinrect;dcol,dcol2,dsize:longint;xframecode:tstr8;xround:boolean);//draw frame
    procedure ldf2(darea:twinrect;dcol,dcol2,dcol3,dsize,drich:longint;xoptions:string;xframecode:tstr8;xround:boolean);
    procedure ldf3(darea:twinrect;dcol,dcol2,dcol3,dsize,drich:longint;xoptions:string;xframecode:tstr8;xround:boolean);
    procedure ldf4(darea:twinrect;dcol,dcol2,dcol3,dsize,dbrightness,dbrightnessDARK,drich:longint;xoptions:string;xframecode:tstr8;xround:boolean);
    procedure ldm(darea:twinrect;xround:boolean);//draw color matrix
    procedure ldm2(darea:twinrect;dcol3:longint;xround:boolean);//draw color matrix
    procedure ldi(darea:twinrect;dx,dy,dcol,dtep:longint;xfocus,xgrey,xround:boolean);
    procedure ldi2(darea:twinrect;dx,dy,dcol,dcol2,dtep:longint;xfocus,xgrey,xround:boolean);
    procedure ldis(darea:twinrect;dx,dy,dcol,dtep:longint;xfocus,xgrey,xround:boolean);
    procedure ldis1(darea:twinrect;dx,dy,dcol,dtep:longint;xfocus,xgrey,xround,xexcludebackground:boolean);
    procedure ldis2(darea:twinrect;dx,dy,dcol,dcol2,dtep:longint;xfocus,xgrey,xround:boolean);//02mar2021
    procedure ldis21(darea:twinrect;dx,dy,dcol,dcol2,dtep:longint;xfocus,xgrey,xround,xexcludebackground:boolean);//02mar2021
    procedure ldis3(darea:twinrect;dx,dy,dcol,dcol2,dtep:longint;xfocus,xgrey,xround,xexcludebackground:boolean);
    procedure ldis_e(xbackref:longint;darea:twinrect;dx,dy,dcol,dtep:longint;xfocus,xgrey,xround:boolean);//system version
    procedure ltea(xdynamicCorners,xcolorise,xsyszoom:boolean;darea:twinrect;dx,dy,dcol:longint;xteadata:tstr8;xfocus,xgrey,xround:boolean);//07apr2021
    procedure lteas(darea:twinrect;dx,dy,dcol,dcol2:longint;xteadata:tstr8;xfocus,xgrey,xround:boolean);//07apr2021
    procedure ldc(darea:twinrect;ddx,ddy,ddw,ddh:currency;sa:twinrect;s:tobject;xpower255,xtrans,xtc:longint;xoptions:currency);
    procedure ldc2(darea:twinrect;ddx,ddy,ddw,ddh:currency;sa:twinrect;s:tobject;xpower255,xtrans,xtc,xwriteShadesofcolor:longint;xoptions:currency;xusealpha:boolean);
    procedure ldc3(darea:twinrect;ddx,ddy,ddw,ddh:currency;sa:twinrect;s:tobject;xpower255,xtrans,xtc,xwriteShadesofcolor:longint;xoptions:currency;xusealpha,xexcludebackground:boolean);
    procedure ldc32(darea:twinrect;ddx,ddy,ddw,ddh:currency;sa:twinrect;s:tobject;xpower255:longint;xexcludebackground:boolean);//05may2025
    procedure ldc32b(darea:twinrect;ddx,ddy,ddw,ddh:currency;sa:twinrect;s:tobject;xpower255:longint;xuse32,xexcludebackground:boolean);//05may2025
    procedure ldt(darea:twinrect;dx,dy,dcol:longint;xline:string;xfontindex,xfeather:longint;xround:boolean);
    procedure ldt1(xbackref:longint;darea:twinrect;dx,dy,dcol:longint;xline:string;xfontindex,xfeather:longint;xround:boolean);//emboss version - 18nov2023
    procedure ldt2(xbackref:longint;darea:twinrect;dx,dy,dcol:longint;xline:string;xfontindex,xfeather:longint;xbold,xitalic,xunderline,xstrikeout,xround:boolean);
    procedure ldt3(darea:twinrect;dx,dy,dcol:longint;xline:tstr8;xfontindex,xfeather:longint;xround:boolean);
    procedure ldt4(darea:twinrect;dx,dy,dcol:longint;xline:tstr8;xfontindex,xfeather:longint;xbold,xitalic,xunderline,xstrikeout,xround:boolean);
    procedure ldtTAB(xbackref:longint;const xtab:string;darea:twinrect;dx,dy,dcol:longint;xline:string;xfontindex,xfeather:longint;xround:boolean);
    procedure ldtTAB2(xbackref:longint;const xtab:string;darea:twinrect;dx,dy,dcol:longint;xline:string;xfontindex,xfeather:longint;xbold,xitalic,xunderline,xstrikeout,xround:boolean);
    procedure ldtTAB3(xbackref:longint;const xtab:string;darea:twinrect;dx,dy,dcol:longint;xline:tstr8;xfontindex,xfeather:longint;xround:boolean);
    procedure ldtTAB4(xbackref:longint;const xtab:string;darea:twinrect;dx,dy,dcol:longint;xline:tstr8;xfontindex,xfeather:longint;xbold,xitalic,xunderline,xstrikeout,xround:boolean);
    //.background mask support (use ldbEXCLUDE to exclude an area of a control from the background image/animation) - 04dec2024
    //important note: If using ldbEXCLUDE() make sure the parent window or at least parent control has "obackmaskenabled=true" so the paint system
    //                can reset the background mask buffer as required - 04dec2024
    procedure ldb(xdyanmicCorners:boolean;darea:twinrect;xincludeBackground,xround,xdragWindow,xforceupdate:boolean);//28nov2024
    procedure ldbINCLUDE(xdyanmicCorners:boolean;darea:twinrect;xround:boolean);//04dec2024
    procedure ldbEXCLUDE(xdyanmicCorners:boolean;darea:twinrect;xround:boolean);//04dec2024
    //system id
    property id:longint read iid;//unique for each and every control system wide
    //area id
    property aid:longint read iaid;//area id -> changed each time control changes position or size or both
    procedure ainc;
    //information
    property caption:string read icaption write setcaption;
    function info:pvirtualinfo;
    function info_round:boolean;
    function info_cs:twinrect;
    function info_bs:longint;
    function info_ci:twinrect;
    function findback:longint;//find background color - 25feb2021
    procedure findbackRound(var xback:longint;var xround:boolean);
    function findtext:longint;//find text color - 22mar2021
    function findframe:longint;//find frame color - 17mar2021
    function findframe2:longint;//find frame2 color - 17mar2021
    function infovars(var xinfo:tclientinfo):boolean;//17may2025
    function infovars2(var xinfo:tclientinfo;xnormal:boolean):boolean;//17may2025
    property normal:boolean read inormal write setnormal;
    function mousex:longint;
    function mousey:longint;
    function mousexy:tpoint;
    property bordersize:longint read ibordersize write setbordersize;
    function findbordersize:longint; virtual;
    function rounded:boolean;
    function roundframe:boolean;//used to signal to paint proc to draw a square frame even though the control itself and it's children maybe round - 02dec2023
    //.help support
    property help:string read ihelp write ihelp;
    property help2:string read ihelp2 write ihelp2;//optional - replaces "help"
    property subhelp:string read isubhelp write isubhelp;
    property subhelp2:string read isubhelp2 write isubhelp2;//optional - replaces "subhelp"
    property helpline:string read gethelpline;
    //.hint support
    property hint:string read ihint write ihint;//1) set to "*" (default) to use help as hint, 2) set to nil to disable hint, 3) set to custom hint
    property hintline:string read gethintline;
    procedure nohint;
    //new control makers
    function ntea(xmaxW,xmaxH:longint;xcap,xhelp:string):tbasictea;
    function nimageviewer(xdata:tstr8;xhelp:string):tbasiccontrol;//12jan2022
    function nimageviewer2(xfilename:string;xuseai:boolean;xhelp:string):tbasiccontrol;//22may2022
    function ndebug:tbasicdebug;//04feb2025
    //tbasicmenu.title/label mimics
    function mtitle(xcap,xhelp:string):tmenutitle;//24may2025
    function mtitleplain(xcap,xhelp:string):tmenutitle;//24may2025
    function mlabel(xcap,xhelp:string):tmenutitle;
    function mlabelplain(xcap,xhelp:string):tmenutitle;
    //.other
    function ntitle(xlarge:boolean;xcap,xhelp:string):tbasictitle;
    function ntitle2(xlarge,xlargeheight:boolean;xcap,xhelp:string):tbasictitle;
    function ntitlebar(xlarge:boolean;xcap,xhelp:string):tbasictoolbar;
    function ntitlebar2(xlarge,xright:boolean;xcap,xhelp:string):tbasictoolbar;
    function ninfo(xtitle,xhead,xtext,xhelp:string):tbasicinfo;
    function ncontrol:tbasiccontrol;
    function nimgview:tbasicimgview;//11dec2024
    function nlabel(xcap,xhelp:string):tbasictitle;
    function ngrad:tbasicgradient;//19aug2024
    function njump(xcap,xhelp:string;xpos,xlen:longint):tbasicjump;
    function nint(xcap,xhelp:string;xmin,xmax,xdef,xval:longint):tbasicint;
    function nint2(xcap,xhelp:string;xmin,xmax,xdef,xval:longint;xbackname:string):tbasicint;//26feb2021
    function nint3(xcap,xhelp:string;xmin,xmax,xdef,xval:longint;xbackname,xloadfromname:string):tbasicint;
    function mint(xcap,xhelp:string;xmin,xmax,xdef,xval:longint):tsimpleint;//03jun2025
    function mintb(xcap,xhelplabel,xhelpbar:string;xmin,xmax,xdef,xval:longint):tsimpleint;//03jun2025
    function mint2(xcap,xhelp:string;xmin,xmax,xdef,xval:longint;xbackname:string):tsimpleint;
    function mint2b(xcap,xhelplabel,xhelpbar:string;xmin,xmax,xdef,xval:longint;xbackname:string):tsimpleint;
    function mint3(xcap,xhelp:string;xmin,xmax,xdef,xval:longint;xbackname,xloadfromname:string):tsimpleint;
    function mint3b(xcap,xhelplabel,xhelpbar:string;xmin,xmax,xdef,xval:longint;xbackname,xloadfromname:string):tsimpleint;
    function mint4(xcap,xhelplabel,xhelpbar:string;xmin,xmax,xdef,xval:longint;xbackname,xloadfromname:string):tsimpleint;
    function nset(xcap,xhelp:string;xdef,xval:longint):tbasicset;
    function nsel(xcap,xhelp:string;xdef:longint):tbasicsel;
    function nmidivol(xcap,xhelp:string):tbasicint;//23mar2022, 29mar2021
    function nwavevol(xcap,xhelp:string):tbasicint;//23mar2022, 29mar2021
    function mmidivol(xcap,xhelp:string):tsimpleint;//02jul2025
    function mwavevol(xcap,xhelp:string):tsimpleint;//02jul2025
    function nmidi(xcap,xhelp:string):tbasicsel;//05mar2022
    function nwave(xcap,xhelp:string):tbasicsel;//05mar2022
    function nmiditranspose(xcap,xhelp:string):tbasicint;//14feb2025
    function mmiditranspose(xcap,xhelp:string):tsimpleint;//02jul2025
    function nsel3(xcap,xhelp:string;xdef:longint;xloadfromname:string):tbasicsel;
    function nimgexts(xcap,xhelp:string):tbasicimageexts;//21dec2024
    function ntick(xcap,xhelp:string):tbasictick;
    function ntick2(xcap,xhelp:string;xvert:boolean):tbasictick;
    function nedit(xcap,xhelp:string):tbasicedit;
    function nedit2(xcap,xhelp:string;xvert:boolean):tbasicedit;
    function ndropstatic(xhelp:string;xtep:longint):tbasicedit;
    function npass(xcap,xhelp:string):tbasicedit;
    function ncolor(xcap,xhelp:string):tbasiccolor;
    function ncolor1(xcap,xhelp:string;xuse32:boolean):tbasiccolor;
    function ncolor2(xcap,xhelp:string;xvert:boolean;hsp:longint):tbasiccolor;
    function ncolor3(xcap,xhelp:string;xvert:boolean;hsp:longint;xuse32:boolean):tbasiccolor;
    function nscrollbar(xhelp:string;xvert:boolean):tbasicscrollbar;
    function nscroll(xhelp:string):tbasicscroll;//06oct2020
    function ntoolbar(xhelp:string):tbasictoolbar;//29may2021
    function ntoolbar_buttons(xhelp:string):tbasictoolbar;//29may2021
    function ncols:tbasiccols;//columns - 06oct2020
    function ncolors:tbasiccolors;
    function nbwp(const xhelp:string;xdata:tstr8):tbasicbwp;//text box
    function nbwp2(const xhelp:string;xdata:tstr8;xwrap:longint;xrows,xautoheight:boolean):tbasicbwp;//17mar2021
    function nbwp3(const xhelp:string;xdata:tstr8;xwrap:longint;xrows,xautoheight,xretaindata:boolean):tbasicbwp;//17mar2021
    function nbwp4(const xhelp:string;xdata:tstr8;xwrap:longint;xrows,xautoheight,xretaindata,xtransform,xwebimages:boolean):tbasicbwp;//31mar2025, 15may2021
    function nbwp5(const xhelp:string;xdata:tstr8;xwrap:longint;xrows,xautoheight,xretaindata,xtransform,xwebimages,xviewurl,xusemake:boolean;xmake__formatlevel,xmake__useonefont:longint):tbasicbwp;//31mar2025, 15may2021
    function nbwpbar(xbox:tbasicbwp;xsysbox:boolean):tbwpbar;
    function nmenu(xcap,xhelp:string):tbasicmenu;
    function npoplist(xcap,xhelp:string;xlistdata:tstr8):tbasicmenu;
    function nlist(xcap,xhelp:string;xlistdata:tstr8;xrowcount:longint):tbasicmenu;
    function nlist3(xcap,xhelp:string;xlistdata:tstr8;xrowcount:longint;xloadfromname:string):tbasicmenu;
    function nlistx(xcap,xhelp:string;xcount,xrowcount:longint;xongetitem:tbasicmenu_getitem):tbasicmenu;
    function nlistx3(xcap,xhelp:string;xcount,xrowcount:longint;xongetitem:tbasicmenu_getitem;xloadfromname:string):tbasicmenu;
    function nnav:tbasicnav;//22sep2020
    function ncolormatrix:tbasiccolormatrix;//26feb2021
    function ncolormixer:tbasiccolormixer;//05sep2025
    function nsetcolor:tbasicsetcolor;//27feb2021
    function nsetcolor2(xuse32,xhead:boolean):tbasicsetcolor;//17nov2023
    function nbreak(xheight:longint):tbasicbreak;
    //events
    procedure _ontimer(sender:tobject); virtual;
    procedure _onpaint(sender:tobject); virtual;
    procedure _onalign(sender:tobject); virtual;
    function  _onshortcut(sender:tobject):boolean; virtual;
    function  _onnotify(sender:tobject):boolean; virtual;
    procedure _onfocus(sender:tobject); virtual;
    //special events
    property onalign:tnotifyevent read fonalign write fonalign;
    property onvalue:tnotifyevent read fonvalue write fonvalue;
    property onpaint:tnotifyevent read fonpaint write fonpaint;
    property onnotify:tsystemnotify read fonnotify write fonnotify;
    property ontimer2:tnotifyevent read fontimer2 write fontimer2;
    property onfindheight:tonfindheight read fonfindheight write fonfindheight;
    //offloader support - 07mar2021
    property xoffloading:boolean read ioffloading write ioffloading;//used to turn off some internal procs/functions that are not required during offloading -> purely optional - 07mar2021
    //.triggers
    function xoff_toolbaradd(x:tbasictoolbar):boolean;
    function xoff_toolbarsync(x:tbasictoolbar):boolean;
    function xoff_toolbarevent(x:tbasictoolbar):boolean;
    //.code handlers
    function _xoff_toolbaradd(x:tbasictoolbar):boolean; virtual;
    function _xoff_toolbarsync(x:tbasictoolbar):boolean; virtual;
    function _xoff_toolbarevent(x:tbasictoolbar):boolean; virtual;
    //.accept support -> drag and drop - 18jun2021
    property onaccept:tonacceptevent read fonaccept write fonaccept;
    function canaccept:boolean;
    function accept_passthru(sender:tobject;xfolder,xfilename:string;xindex,xcount:longint):boolean;
    //.makers
    function findinfo(xname,xdefval:string;var xvalue:string):boolean;
    function findinfob(xname,xdefval:string):string;
    //.basic image viewer suport
    property imageviewerworking:boolean read iimagebufferworking;
    property imageviewerid:longint read iimagebufferid;
    property imageviewerbackcolor:longint read iimagebufferbackcolor write setimagebufferbackcolor;
    property imageviewerinfo:string read iimagebufferinfo;
    property imageviewercountcolors:boolean read iimagebufferinfocountcolors write iimagebufferinfocountcolors;
    procedure makeimageviewerfromfile(x:string;xuseai:boolean);//best to use this version, it's multi-task OK - 22may2022
    procedure makeimageviewer(x:tstr8);//not multi-task safe
    procedure makeimageviewer2(x:tstr8;xuseai:boolean);//not multi-task safe
    procedure makeimagevieweri(x:tbasicimage);//uses the image -> must set to nil to stop using it - 07feb2022
    property ximageviewerbuffer:tbasicimage read iimagebuffer;
    property ximageviewerbufferi:tbasicimage read iimagebufferi write iimagebufferi;
    procedure xmakeimageviewer(x:tstr8;xstyle:longint;xreset,xpaintnow:boolean);
    //idle tracking support - 21feb2022
    procedure notidle;
    function idletime:comp; virtual;
    //automation support
    procedure xwound_mousevert(xmaxtime:longint;xforce:boolean);
    procedure xwound_mousevert2(xmaxtime:longint;xforce,xinvert:boolean);
    procedure xwound_mousevert3(xmaxtime:longint;xforce,xinvert,xvertical:boolean);
    function xwound_mustpaint(spos,xrowsperpaint:longint;var dpos,ddir:longint):boolean;
    function xwound_mustpaint2(spos,xrowsperpaint:longint):longint;
    function xwound_off:boolean;
    procedure xwound_autooff(spos,xdir,xmin,xmax:longint);
    function xwound_finddir(xtime:longint):longint;
    function xwound_dirmatch(xtime1,xtime2:longint):boolean;
    procedure xwound_wheel(xtimems:longint);
    //-- shared handlers - 03dec2023 -------------------------------------------
    procedure make__backgroundhead; virtual;
    procedure make__backgroundbase; virtual;
    procedure make__normal; virtual;

    procedure background__head2(da:twinrect;xback:longint;xround:boolean;var xsparkle:longint);//extend head background further down, usually toolbar
    procedure background__title(da:twinrect;xback:longint;xround:boolean);
    procedure background__title2(da:twinrect;xback:longint;xflatback,xround:boolean);
    procedure background__toolbar(da:twinrect;xback,xback2:longint;xround:boolean);
    procedure background__toolbar2(da:twinrect;xback,xback2:longint;xflatback,xround:boolean);//08mar2025: fixed corner color oversight
   end;

{tbasicimgview}
   tbasicimgview=class(tbasiccontrol)
   private
    ifadetimer,ianimatetimer1,ianimatetimer2,itimer100:comp;
    inew32,iimg32,ibuf32:trawimage;
    //inew32,iimg32:tbasicimage;
    inewfilenameREF,inewfilename:string;
    inewimagedata:tstr8;
    imustmode,ilastid,iid,iloadid,ibackcolor,ifillstyle,ifadespeed,ifadepower:longint;
    ishown,icanevent,ifillback,ianimate,icountcolors,iworking,iloading:boolean;
    fonevent:tnotifyevent;
    //image info
    iwidth:longint;
    iheight:longint;
    idelay:longint;
    ibpp:longint;
    icells:longint;
    icolors:longint;
    ibytes:comp;
    ifilename:string;
    iinfostr:string;
    procedure xincid;//settings id
    procedure xincloadid;//load id
    procedure setbackcolor(x:longint);
    procedure setfillstyle(x:longint);
    procedure setfadespeed(x:longint);
    procedure setcountcolors(x:boolean);
    procedure setanimate(x:boolean);
    procedure setfillback(x:boolean);
    function xcanload:boolean;
    procedure xload(xuseFilename,xuseData:boolean);
    procedure xkeeplast;
    function getimage32:trawimage;
    function ximgok(s:tobject):boolean;
    procedure xevent;//12dec2024
    procedure xrender__dual(sbits,sw,sh,sr,sg,sb,sa:longint;srows:pcolorrows24;a,b:tobject;fa,fb,da,db,da2,db2:twinrect;a255,b255,aa255,bb255,atrans,btrans,atc,btc:longint);
   public
    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;//28may2021, 26apr2021
    function _onnotify(sender:tobject):boolean; override;
    //information
    property loading:boolean read iloading;
    function working:boolean;
    property id:longint read iid;//settings id -> increments each time a setting is changed
    property loadid:longint read iloadid;//load id -> increments each time a new image is loaded/attemped to load
    property fillstyle:longint read ifillstyle write setfillstyle;//0..vfsMax
    property backcolor:longint read ibackcolor write setbackcolor;
    property fadespeed:longint read ifadespeed write setfadespeed;//range: 0-100, 0=instant (no delay), 1=slow, 5=moderate, 100=fastest
    property countcolors:boolean read icountcolors write setcountcolors;
    property animate:boolean read ianimate write setanimate;
    property mustmode:longint read imustmode write imustmode;//-1=user clicked left side of image, 1=user clicked right side of image, 0=no useful click info
    property fillback:boolean read ifillback write setfillback;
    property shown:boolean read ishown;//default=true=last image loaded via loadfromfile has been loaded and shown in full, false=image still being processed
    property image32:trawimage read getimage32;//read only
    property fadepower:longint read ifadepower;
    //.image information
    property width:longint read iwidth;
    property height:longint read iheight;
    property delay:longint read idelay;
    property bpp:longint read ibpp;
    property colors:longint read icolors;
    property cells:longint read icells;
    property bytes:comp read ibytes;//file size on disk
    property filename:string read ifilename;
    property infostr:string read iinfostr;
    function findinfob(xname,xdefval:string):string;
    function findinfo(xname,xdefval:string;var xvalue:string):boolean;
    //io
    procedure loadfromfile(x:string;xuseai:boolean);
    procedure loadfromdata(x:pobject;xuseai:boolean);
    //events
    property onevent:tnotifyevent read fonevent write fonevent;//triggered once image has been loaded and fully displayed on the screen - 12dec2024
    //other
    procedure xrenderto(dbits,dw,dh:longint;drows:pcolorrows24);
   end;

{tbasichelp}
   tbasichelp=class(tbasiccontrol)
   private
    ipostime,itimer250:currency;
    ishowhelp:boolean;
    ideftext,itext,itextref,iinforef:string;
    iimg,iimgw,iimgh,ipos,itextid:longint;
    procedure settext(x:string);//14may2025
    function paintscroll:boolean;
    procedure setshowhelp(x:boolean);
    procedure xsync;
   public
    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function getalignheight(xclientwidth:longint):longint; override;
    //information
    property showhelp:boolean read ishowhelp write setshowhelp;
    property text:string read itext write settext;
    property deftext:string read ideftext write ideftext;
    //makers
    procedure makenormal;
   end;

//xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx//nnnnnnnnnnnnnnnnnnn
{tbasicnav}
   tbasicnav=class(tbasiccontrol)
   private
    ivalueinlist_style,ireloadid,ifolderid,ifavlimit,iownerid,iownerid2,isortstyle,istyle,inavcount,ifoldercount,ifilecount,itotalcount:longint;
    itimer100,itimer250:currency;
    ifav,ilist:tbasicmenu;//in dynamic list mode - 28sep2020
    iname,ifilter:tbasicedit;
    iaction:tbasicimageexts;
    ipreviewbox:tbasicimgview;
    ipreviewlabel:tmenutitle;
    inamelabel,ifilterlabel:tbasiccontrol;
    ifavlabel,ibar,ibut:tbasictoolbar;
    ivalueinlist,ilastpreviewfile,iprevnextcode,ifavfolder,ireloadref,ilastmask,ilastemask,ilastemask_minmax,ifolderidREF,ilistfolder,imustfolder,imustname:string;
    ihisname:string;
    isyspreview,ipreview,icanpreview,ilastpreview,imustreload:boolean;
    ilistcore:tstr8;
    ifavcore:tdynamicstring;//10mar2021
    ifavteps:tdynamicinteger;//14apr2021
    fonmodifyitem:tnavmodifyitem;
    fonclick:tnotifyevent;
    //.filter support
    findex,fcount:longint;
    fcap:array[0..99] of string;//label e.g. "Bitmap (bmp)|Jpeg Image (jpg/jpeg)"
    fext:array[0..99] of string;//extension e.g. "BMP" or "JPG;JPEG"
    fmsk:array[0..99] of string;//mask e.g. "*.bmp;*.jpg;*.jpeg"
    ftep:array[0..99] of longint;//store tep for each ext or group of exts (e.g. support for teps for "bcs", pebcs and feAllDocs(a group of document types)) - 10mar2021
    procedure setstyle(x:longint);
    function __ongetitem(sender:tobject;xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean;
    function __ongetitem2(sender:tobject;xdisplayonly:boolean;xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean;
    procedure __onclick2(sender:tobject;xcmd:string);
    procedure __onclick(sender:tobject);
    procedure filter__onclick(sender:tobject);
    procedure setfilterlist(x:string);//18sep2025
    function getfilterlist:string;
    function getfilter:string;
    procedure setfilter(x:string);
    procedure setfilterfromfilename(x:string);
    function getfilterindex:longint;
    procedure setfilterindex(x:longint);
    procedure setvalue(x:string);
    function getvaluelist(xindex:longint):string;//28sep2022
    function getvaluelist2(xindex,xforcestyle:longint):string;//28sep2022
    function getvalue:string;//06apr2021
    function getvaluestyle:longint;
    function getvalueEXT:string;//12jan2022
    function getfolder:string;
    procedure setfolder(x:string);
    procedure setsortstyle(x:longint);
    function getdownindex:longint;
    procedure setdownindex(x:longint);
    function xfiltername(xnewname:string;xaddfilterext:boolean):string;
    procedure findex_tep;
    function xenhancednames(x:string):string;
    function getitemindex:longint;
    procedure setitemindex(x:longint);
    function getsettings:string;
    procedure setsettings(x:string);
    function xvalueinlist(var xvalue:string;var xstyle:longint):boolean;
    function getaction:string;
    //fav support
    procedure loadfav;
    function savefav(xdata:tstr8):boolean;
    procedure addfav(xfolder:string);
    function xfavfolder:string;
    //his support
    procedure sethisname(x:string);
    procedure xhisadd(xval:string;xpos,xitemindex:longint;xstorev12:boolean);//22mar2021
    //showmenu support
    procedure xshowmenuFill1(sender:tobject;xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string);
    procedure xshowmenuFill2(sender:tobject;xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string);
    procedure xshowmenuFill(sender:tobject;xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string);
    function xshowmenuClick1(sender:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    function xshowmenuClick2(sender:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    function xshowmenuClick(sender:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
   public
    //options
    ocommonfolder:string;//default=<nil>
    omasklist:string;
    oemasklist:string;
    oretainpos:boolean;//default=true=keeps vertical position during reloads
    ofindname:boolean;//default=false, true=selects name from list when value is a full filename - 19dec2021
    ocansort:boolean;//default=true=allow user to change sort style - 12jan2022
    onumber:boolean;//default=false, true=number only the files list section - 20mar2022
    //.minmax range enforcer - 27sep2022
    ominsize:comp;
    omaxsize:comp;
    ominmax_emasklist:string;//files to be excluded from the "ominsize..omaxsize" range check - 27sep2022
    ohead:boolean;//default=false, true=use window head as toolbar - 12jan2025
    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    procedure _onalign(sender:tobject); override;
    function xfrom(sender:tbasiccontrol;xvars:tvars8;xname:string):boolean; override;
    function xto(sender:tbasiccontrol;xvars:tvars8;xname:string):boolean; override;
    function xcmd(xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    procedure make__backgroundhead; override;//03dec2023
    //change ids - 27sep2022
    property folderID:longint read ifolderid;//increments each time a new folder is loaded - 27sep2022
    property reloadID:longint read ireloadid;//increments each time nav is reloaded - 20aug2024
    //information
    property settings:string read getsettings write setsettings;//direct read/write of settings as a single line of text - 20aug2024
    property sortstyle:longint read isortstyle write setsortstyle;
    property style:longint read istyle write setstyle;//bnNil .. bnMax
    property filterlist:string read getfilterlist write setfilterlist;
    property filter:string read getfilter write setfilter;
    property filterfromfilename:string read getfilter write setfilterfromfilename;//18jun2021
    property filterindex:longint read getfilterindex write setfilterindex;
    property folder:string read getfolder write setfolder;
    function folderpending:boolean;//detects if folder is waiting to be set/updated - 14jul2025
    function foldervalue:string;//returns the pending "folder" first, then the actual folder that is set - 14jul2025
    property valuelist[xindex:longint]:string read getvaluelist;//28sep2022
    property value:string read getvalue write setvalue;
    property valuestyle:longint read getvaluestyle;//e.g. nltFile, nltFolder, nltNav, nltTitle etc - 22mar2021
    property valueEXT:string read getvalueext;//works for "nltFile" only and returns the file extension in LOWERCASE - 12jan2022
    function selectedfolder:string;//current item's folder "filepath" - 07apr2021
    property navcount:longint read inavcount;
    property foldercount:longint read ifoldercount;
    property filecount:longint read ifilecount;
    property totalcount:longint read itotalcount;
    property downindex:longint read getdownindex write setdownindex;
    function findinfo(var xselstart,xselcount,xdownindex,xnavindex,xfolderindex,xfileindex,xnavcount,xfoldercount,xfilecount:longint;var xisnav,xisfolder,xisfile:boolean):boolean;
    function findinfo2(xindex:longint;var xselstart,xselcount,xdownindex,xnavindex,xfolderindex,xfileindex,xnavcount,xfoldercount,xfilecount:longint;var xisnav,xisfolder,xisfile:boolean;var xsize:comp;var xvalue:string;xfindvalue:boolean):boolean;
    procedure findinfoBrief(var xisnav,xisfolder,xisfile:boolean);
    property favfolder:string read ifavfolder write ifavfolder;//optional folder to allow user to add to fav upon clicking the link "Add" - 10mar2021
    property itemindex:longint read getitemindex write setitemindex;//23mar2022
    //.direct access to selected list item -> independent of display style
    property valueinlist:string read ivalueinlist;
    property valueinlistStyle:longint read ivalueinlist_style;
    //showmenu
    function canshowmenu:boolean; override;
    procedure showmenu; override;//20mar2022
    //history support
    property hisname:string read ihisname write sethisname;//used to store folder history via system history support - default=<nil>=off
    //.prev
    function canprev:boolean;
    function prev:boolean;
    //.next
    function cannext:boolean;
    function next:boolean;
    //.fav - show fav window
    function popfav:string;
    //.preview
    property preview:boolean read ipreview write ipreview;
    property canpreview:boolean read icanpreview write icanpreview;//default=true, controls whether preview link on toolbar and preview can in fact be shown even if set to preview this overrides - 22may2022
    property syspreview:boolean read isyspreview write isyspreview;//default=false, true=read/write "preview" state from internal system vars - 22may2022
    //workers
    procedure reload;
    //makers
    function makenil:tbasicnav;
    function makefav:tbasicnav;
    function makenav:tbasicnav;
    function makefolder:tbasicnav;
    function makefolder2:tbasicnav;//20jul2024: folder and show files
    function makeopen:tbasicnav;
    function makesave:tbasicnav;
    function makefavlist:tbasicnav;
    function makenavlist:tbasicnav;//use this for a standard filebox list - 27sep2022
    function makenavlist2:tbasicnav;
    function makenamelist:tbasicnav;
    function xautoclose(x:boolean):tbasicnav;
    //.support
    function xbar:tbasictoolbar;
    function xbut:tbasictoolbar;
    function xfav:tbasicmenu;
    function xfavlabel:tbasictoolbar;
    function xpreviewbox:tbasiccontrol;//22may2022
    function xpreviewlabel:tbasiccontrol;//24jan2025, 22may2022
    function xlist:tbasicmenu;
    function xname:tbasicedit;
    function xnamelabel:tbasiccontrol;
    function xfilter:tbasicedit;
    function xfilterlabel:tbasiccontrol;
    function xaction:tbasicimageexts;//21dec2024
    function xfocusname:boolean;//11feb2023
    procedure click__list;//25jan2025
    //.special value handlers
    function xvaluefile(xdef:string):string;
    //action
    property action:string read getaction;
    //home
    function canhome:boolean;
    procedure home;
    //offloaders
    function _xoff_toolbaradd(x:tbasictoolbar):boolean; override;
    function _xoff_toolbarsync(x:tbasictoolbar):boolean; override;
    function _xoff_toolbarevent(x:tbasictoolbar):boolean; override;
    //idletime - custom
    function idletime:comp; override;//21feb2022
    //events
    property onclick:tnotifyevent read fonclick write fonclick;
    property onmodifyitem:tnavmodifyitem read fonmodifyitem write fonmodifyitem;
   end;

{tbasicbwp}
   tbasicbwp=class(tbasiccontrol)
   private
    icore:twordcore;
    iv,ih:tbasicscrollbar;
    islowdownref,itimersync:comp;
    imustpos,imustpos2,imustscrollv_px,imustscrollv,imustscrollh,itimersync_fastcount,imleft,imright,imtop,imbottom:longint;
    iusepagecolor,ibuildingcontrol:boolean;
    iref:string;
    irevertdata:tstr8;
    fonact:tsimplestringeventb;
    //.wordcount support
    iwordcount,inewcount,inewpos,inewid:longint;
    inewword:boolean;
    procedure setpos(x:longint);
    function getpos:longint;
    procedure setposh(x:longint);
    function getposh:longint;
    function getposc:longint;
    procedure setposc(x:longint);
    function getposc2:longint;
    procedure setposc2(x:longint);
    procedure _onpos(sender:tobject);
    procedure setreadonly(x:boolean);
    function getreadonly:boolean;
    procedure setshowcursor(x:boolean);
    function getshowcursor:boolean;
    function getcore:pwordcore;
    procedure setusepagecolor(x:boolean);
    function getroundstyle:longint;
    procedure setroundstyle(x:longint);
    procedure setwrap(x:longint);//0=no wrap, 1=to window, 2=to page (default)
    function getwrap:longint;
    procedure setwrapreadonly(x:boolean);//true=prevents wrapstyle from changing during "ioset()" operations - 12mar2021
    function getwrapreadonly:boolean;
    procedure xsync;
    procedure setsyscols(x:boolean);
    function getsyscols:boolean;
    function getundoenabled:boolean;
    procedure setundoenabled(x:boolean);
    procedure _onarrow(sender:tobject;var xmoveval:longint);
    procedure setlinespacing(x:longint);
    function getlinespacing:longint;
    function getcanspell:boolean;
    procedure setcanspell(x:boolean);
    procedure setstyle(x:longint);
    function getstyle:longint;
   public

    //options
    orows:boolean;//default=false, true=draw text with alternating row color - 12mar2021
    omenustyles:boolean;//default=false, true=show style options in menu - 19dec2021
    ocopystyles:boolean;//default=false=hide, true=show copy enhanced etc - 18jun2022
    vsmooth:boolean;//default=true=smooth scroll by pixels, false=older style, scroll by lines - 21jun2022
    olivewordcount:boolean;//default=false, true=wordcounts in background in realtime - 05feb2023

    //create
    constructor create(xparent:tobject); override;
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    function _onnotify(sender:tobject):boolean; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    procedure _onalign(sender:tobject); override;
    function _onshortcut(sender:tobject):boolean; override;//09dec2024: fixed ctrl+c block when readonly, 28aug2024: fixed F3/F4 block when oreadonly=true
    property core:pwordcore read getcore;
    procedure syncdef;//06oct2020
    procedure showmenuFill(xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string); override;
    function showmenuClick(sender:tobject;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean; override;
    procedure xwordcoretimer(xsyncnow:boolean);
    //information
    property roundstyle:longint read getroundstyle write setroundstyle;
    property oreadonly:boolean read getreadonly write setreadonly;
    property oshowcursor:boolean read getshowcursor write setshowcursor;
    property ousepagecolor:boolean read iusepagecolor write setusepagecolor;
    property vpos:longint read getpos write setpos;
    property hpos:longint read getposh write setposh;
    property cpos:longint read getposc write setposc;
    property cpos2:longint read getposc2 write setposc2;
    property wrap:longint read getwrap write setwrap;
    function line:longint;//current line 1..N
    function column:longint;
    function line_column(var xline,xcolumn:longint):boolean;
    function pages:longint;
    function page:longint;
    function maxline:longint;
    property wrapreadonly:boolean read getwrapreadonly write setwrapreadonly;
    property syscols:boolean read getsyscols write setsyscols;
    property linespacing:longint read getlinespacing write setlinespacing;
    property style:longint read getstyle write setstyle;//wrap: 0=none, 1=window, 2=page, 3=page + 2x, 4=manuscript
    //scrollto
    procedure vscrolltopos(xpos:longint);
    procedure scrollto(_vpos_px,_vpos,_hpos,_pos,_pos2:longint;xforcewrapall:boolean);
    //margin
    procedure margin(xl,xt,xr,xb:longint);
    property mleft:longint read imleft;
    property mtop:longint read imtop;
    property mright:longint read imright;
    property mbottom:longint read imbottom;
    //revert support
    procedure revertinit(xdata:tstr8;xenable:boolean);
    //spell
    property canspell:boolean read getcanspell write setcanspell;
    procedure spell;
    //find
    function canfind:boolean;
    procedure findpop;
    procedure find;
    //live wordcount
    property wordcount:longint read iwordcount;//approxmately only
    //io
    function ioget(xdata:tstr8;xformat:string):boolean;
    function ioset(xdata:tstr8):boolean;
    function ioset2(xdata:tstr8;xvpos_px,xvpos:longint):boolean;
    function ioset3(xdata:tstr8;xvpos_px,xvpos,xhpos,xpos,xpos2:longint;xtransform,xwebimages:boolean):boolean;
    //.txt
    function iogettxt(xdata:tstr8):boolean;
    function iosettxt(xdata:tstr8):boolean;
    //.bwd
    function iogetbwd(xdata:tstr8):boolean;
    function iosetbwd(xdata:tstr8):boolean;
    //.bwp
    function iogetbwp(xdata:tstr8):boolean;
    function iosetbwp(xdata:tstr8):boolean;
    //.rtf - 22jun2022
    function iogetrtf(xdata:tstr8):boolean;
    function iosetrtf(xdata:tstr8):boolean;
    //edit support
    //.can
    function xcan(x:string):boolean;
    function canundo:boolean;
    function canredo:boolean;
    function cancut:boolean;
    function cancopy:boolean;
    function cancopyall:boolean;
    function canpaste:boolean;
    function canpastereplace:boolean;
    function candeleteall:boolean;//has undo
    function canclearall:boolean;//no undo
    property undoenabled:boolean read getundoenabled write setundoenabled;
    //.act
    function xact(x:string;var e:string):boolean;
    //.other
    procedure undoon;
    procedure undooff;
    procedure undoclear;
    //transformers
    function makereadonly:tbasicbwp;//17mar2025
    function makeviewonly:tbasicbwp;
    function claudesupport:tbasicbwp;
    procedure applystylebymask(xdata:tstr8);//09mar2025
    //makers - 12jun2022
    //.vifontsize + onefontname="$fontname" - 21jun2022
    procedure makeplaintext1;
    procedure maketxt1;
    procedure makebwd1;
    procedure makebwp1;
    //.vifontsize2 + onefontname="$fontname2" - 21jun2022
    procedure makeplaintext2;
    procedure maketxt2;
    procedure makebwd2;
    procedure makebwp2;
    procedure makepanel2;//27aug2025
    //.full version (all fonts, styles, images etc) -21jun2022
    procedure makebwpFull;
    procedure makebwpFull2;//14nov2023
    procedure makexxx(xformatlevel:longint;xuseonefont:longint;xviewurl:boolean);//31mar2025, 12jun2022
    //events
    property onact:tsimplestringeventb read fonact write fonact;//19jun2022
   end;

{tbwpbar}
   tbwpbar=class(tbasiccontrol)
   private
    itimer250:comp;
    iref:string;
    ibox:tbasicbwp;
    ihoverindex,idownindex,icount:longint;
    iarea:array[0..19] of twinrect;
    ipert:array[0..19] of longint;
    icap:array[0..19] of string;
    //index refs
    iname,isize,icolor,inormal,ibold,iitalic,istrikeout,iunderline,ihighlight,ileft,icenter,iright,iwrap:longint;
    procedure setbox(x:tbasicbwp);
    function xnew(xcap:string;xpert:longint):longint;
   public
    //options
    osysbox:boolean;//default=false=use specified box, true=use currently set box
    //create
    constructor create(xparent:tobject);
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    function getalignheight(xclientwidth:longint):longint; override;//07sep2020
    procedure showmenuFill(xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string); override;
    function showmenuClick(sender:tobject;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean; override;
    //box
    property box:tbasicbwp read ibox write setbox;
    function findbox:tbasicbwp;
    function findbox2:tbasicbwp;
    function findindex(x,y:longint):longint;
   end;

{tbasiccolor}
   tbasiccolor=class(tbasiccontrol)
   private
    icolor,ishadecolor:longint;
    foncolor:tlongintevent;
    ishadearea:twinrect;
    iuse32,ishadeused:boolean;
    ishadelist:tdynamicinteger;
    procedure setcolor(x:longint);
    procedure xdomenu(xcode2:string);
    procedure setcolor24(x:longint);
    function getcolor24:longint;
    function xshadecolor24:longint;//03feb2024
   public
    //options
    opopcolor:boolean;//default=true=click to show colordlg
    oshaderange:boolean;
    osleek:boolean;//default=false
    //create
    constructor create(xparent:tobject;xcaption:string);
    constructor create2(xparent:tobject;xstart:boolean;xcaption:string); virtual;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;
    function getalignwidth(xclientheight:longint):longint; override;
    //information
    property color:longint read icolor write setcolor;
    property color24:longint read getcolor24 write setcolor24;
    property use32:boolean read iuse32 write iuse32;
    //workers
    procedure showmenu; override;
    //events
    procedure _onpaint(sender:tobject); override;
    function  _onnotify(sender:tobject):boolean; override;
    function  _onshortcut(sender:tobject):boolean; override;
    property oncolor:tlongintevent read foncolor write foncolor;//26feb2021
   end;

{tbasiccolormatrix}
   tbasiccolormatrix=class(tbasiccontrol)
   private
    icolor:longint;
    foncolor:tlongintevent;
    procedure setcolor(x:longint);
   public
    //override
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    //events
    procedure _onpaint(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;//02feb2025
    property oncolor:tlongintevent read foncolor write foncolor;
    //information
    property color:longint read icolor write setcolor;
   end;

{tbasiccolormixer}
   tbasiccolormixerCell=record
      color :longint;
      area  :twinrect;
      end;
   tbasiccolormixer=class(tbasiccontrol)
   private

    icore:array[0..3] of array [0..19] of tbasiccolormixerCell;
    ifromcolor,itocolor,iselectedcolor:longint;
    foncolor:tlongintevent;

    procedure setfromcolor(x:longint);
    procedure settocolor(x:longint);
    function xrowheight:longint;
    function xrowcount:longint;
    procedure xmakecolors(scolor,dcolor:longint);

   public

    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;
    procedure _onpaint(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;//02feb2025

    //information
    property fromcolor     :longint     read ifromcolor     write setfromcolor;
    property tocolor       :longint     read itocolor       write settocolor;
    property selectedcolor :longint     read iselectedcolor;

    //workers
    procedure setparams(xfromcolor,xtocolor:longint);

    //events
    property oncolor:tlongintevent read foncolor write foncolor;

   end;

{tbasicinfo}
   tbasicinfo=class(tbasiccontrol)
   private
    itimer250:currency;
    ititle,ihead,itext,iinforef:string;
    irowpad,idataid:longint;
    procedure settitle(x:string);
    procedure sethead(x:string);
    procedure settext(x:string);
   public
    //options
    ocolwidth:longint;//first column
    orowlimit:longint;//default=5 rows -> 0=manual height, 1..N=restrict autoheight to specified number of rows - 13apr2020
    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    property dataid:longint read idataid;
    function getalignheight(xclientwidth:longint):longint; override;
    //information
    property title:string read ititle write settitle;//1 line
    property head:string read ihead write sethead;//1 line
    property text:string read itext write settext;//multiple lines
    procedure setdata(xtitle,xhead,xtext:string);
    //events
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
   end;

{tbasicstatus}
   tbasicstatus=class(tbasiccontrol)
   private
    //Note: Now supports auto-width if no cellwidths are set BUT "celltext[0]" has text - 05oct2020
    itimer250:currency;
    ilastflash,ipause:boolean;
    iclickindex,iflashcount:longint;
    iclickname,iinforef:string;
    icellmark:array[0..19] of boolean;
    icellflash:array[0..19] of boolean;
    icellwidth:array[0..19] of longint;
    icellalign:array[0..19] of longint;//0=left, 1=center, 2=right, 3=default=internal
    icellleft:array[0..19] of longint;//left pixel boundary that starts the cell - filled via _onpaint - 04feb2023
    icellright:array[0..19] of longint;//right pixel boundary that finished the cell - filled via _onpaint - 04feb2023
    icellpert:array[0..19] of double;
    icelltext:array[0..19] of string;
    icellname:array[0..19] of string;
    icellhelp:array[0..19] of string;//03dec2023
    icellref:array[0..19] of string;
    fclickcell:tnotifyevent;
    function xcellok(x:longint):boolean;
    procedure setcellname(x:longint;y:string);
    function getcellname(x:longint):string;
    procedure setcellhelp(x:longint;y:string);
    function getcellhelp(x:longint):string;
    procedure setcelltext(x:longint;y:string);
    function getcelltext(x:longint):string;
    procedure setcellwidth(x,y:longint);
    function getcellwidth(x:longint):longint;
    procedure setcellalign(x,y:longint);
    function getcellalign(x:longint):longint;
    procedure setcellpert(x:longint;y:double);
    function getcellpert(x:longint):double;
    procedure setcellflash(x:longint;y:boolean);
    function getcellflash(x:longint):boolean;
    procedure setcellmark(x:longint;y:boolean);
    function getcellmark(x:longint):boolean;
   public
    //options
    ocenter:boolean;//default=true=center text inside each cell, false=left align
    ofast:boolean;//default=false, true=faster change detection and repaint cycle - 26aug2024
    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    function getalignheight(xclientwidth:longint):longint; override;
    //information
    property pause:boolean read ipause write ipause;
    property cellname[x:longint]:string read getcellname write setcellname;
    property cellhelp[x:longint]:string read getcellhelp write setcellhelp;
    property celltext[x:longint]:string read getcelltext write setcelltext;
    property cellwidth[x:longint]:longint read getcellwidth write setcellwidth;
    property cellalign[x:longint]:longint read getcellalign write setcellalign;//0=left, 1=center, 2=right, 3=internal
    property cellpert[x:longint]:double read getcellpert write setcellpert;//07jul2021
    property cellflash[x:longint]:boolean read getcellflash write setcellflash;//29dec2021
    property cellmark[x:longint]:boolean read getcellmark write setcellmark;//02dec2023
    //.cell click
    property clickindex:longint read iclickindex;
    property clickname:string read iclickname;
    property clickcell:tnotifyevent read fclickcell write fclickcell;
   end;

{tbasicgradient}
   tbasicgradient=class(tbasiccontrol)
   public
    //create
    constructor create(xparent:tobject;xstyle:string); virtual;
    constructor create2(xparent:tobject;xstart:boolean;xstyle:string); virtual;
    destructor destroy; override;
    procedure _onpaint(sender:tobject); override;
    function getalignheight(xclientwidth:longint):longint; override;//15may2025
   end;

{tbasicdebug}
   tbasicdebug=class(tbasiccontrol)//used to help debug any paint related issues
   private
    ipartpaint_count,iongetalignheight_count,ionpaint_count,ipaintnow_count:longint;
    ipaintarea_L_count,ipaintarea_R_count,ipaintarea_T_count,ipaintarea_B_count:longint;
    ipartpaint_notfound_count:longint;
   public
    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function getalignheight(xclientwidth:longint):longint; override;
    procedure paintnow; override;

   end;

{tmenutitle}
   tmenutitle=class(tbasiccontrol)
   private
    irowheight,irowpad,imaxtepheight:longint;
    function xrowheight:longint;
   public
    //options
    oplain:boolean;//default=false=color matches menu, true=plain background
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;
    procedure _onpaint(sender:tobject); override;
   end;

{tbasictitle}
   tbasictitle=class(tbasiccontrol)
   private
    itimer250:currency;
    iinforef,itext:string;
    ilabel:boolean;
    procedure settext(x:string);
    function xtitleheight:longint;//text height
   public
    //options
    olarge:boolean;//default=false=small
    olargeheight:boolean;//default=olarge
    ocentertext:boolean;//default=false - 19nov2023
    oshadeback:boolean;//default=false - 19jul2024
    otweakv:longint;//adjust text's vertical position
    oindent:boolean;//default=true
    //create
    constructor create(xparent:tobject;xlarge,xlabel:boolean;xcaption:string);
    constructor create2(xparent:tobject;xstart,xlarge,xlabel:boolean;xcaption:string); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;//08apr2025: otab support
    function getalignheight(xclientwidth:longint):longint; override;//11may2025, 07sep2020
    //information
    property text:string read itext write settext;
    //makers
    procedure makesleek;
   end;

{tbasicbreak}
   tbasicbreak=class(tbasiccontrol)
   private
    iheight:longint;
   public
    opaint:boolean;//default=false
    //create
    constructor create(xparent:tobject;xheight:longint); virtual;
    constructor create2(xparent:tobject;xstart:boolean;xheight:longint); virtual;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;
    //events
    procedure _onpaint(sender:tobject); override;
   end;

{tbasicint}
   tbasicint=class(tbasiccontrol)
   private
    itimer500,itimer250:comp;
    ilastval,ireloadid,idownval,ipaintid,ivalid,ilastpaintid,ilastvalid,imin,imax,idef,ival:longint;
    ilastvalunit,idownstyle:string;
    fonreadwriteval,fonreadwritedef:tbasicint_onreadwriteval;
    fonvalue2:tlongintevent;
    fonvalcap:tsimplestringevent;
    iamore,ialess,iamore2,ialess2,iadef,iabar:twinrect;
    procedure setval(xval:longint);
    procedure writeval(xval:longint);
    function readval:longint;
    function readdef:longint;
    procedure xnorects;
    procedure __onvol(sender:tobject;var xval:longint;xwrite:boolean);
    procedure setdef(xdef:longint);
    function xrowheight:longint;
   public
    //options
    omore:longint;
    oless:longint;
    omore2:longint;
    oless2:longint;
    //.label overrides - 07jul2021
    omorecap:string;
    olesscap:string;
    omorecap2:string;
    olesscap2:string;
    odefcap:string;
    oshow2:boolean;//default=true=show large less/more - 07feb2022
    oshow1:boolean;//default=true=show small less/more - 02dec2024
    oshowdef:boolean;//03mar2022
    ovalshow:boolean;
    ovalmultiplier:extended;//default=1
    ovalunit:string;//default=<nil>, can use to show a unit of measure AND/OR include helpful hints etc
    ovalunit_defshow:boolean;//true=default=same unit for value display as default display, false=don't include on the default display such when used for hints etc on "frame size" => "options > frame > size" - 12feb2023
    ovalstyle:string;//default=<nil>, msfps=ms -> frames per second
    oloadfromname:string;//get value from a system value using a name
    oautoreload:boolean;
    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    function getalignheight(xclientwidth:longint):longint; override;
    function zname(n:string):string;
    //workers
    procedure setparams(xmin,xmax,xdef,xval:longint);
    procedure setparams3(xmin,xmax,xdef,xval:longint;xloadfromname:string);
    property min:longint read imin;
    property max:longint read imax;
    property def:longint read idef write setdef;
    property val:longint read readval write setval;
    procedure reload;//uses "oloadfromname" to gain value - 07sep2020
    //events
    procedure _onpaint(sender:tobject); override;//12may2025
    property onvalue2:tlongintevent read fonvalue2 write fonvalue2;//26feb2021
    property onreadwriteval:tbasicint_onreadwriteval read fonreadwriteval write fonreadwriteval;
    property onreadwritedef:tbasicint_onreadwriteval read fonreadwritedef write fonreadwritedef;
    property onvalcap:tsimplestringevent read fonvalcap write fonvalcap;
    //makers
    procedure makeshow1only;
    procedure makedefonly;
    procedure makesleek;
    procedure makeZoom10k;
    procedure makeFps10;
    procedure makemidivol;//23mar2022
    procedure makewavevol;
    procedure makevol(xmade:longint);//09jan2025, 12nov2022
    procedure makemiditranspose;//14feb2025
   end;

{tsimpleint}
   tsimpleint=class(tbasiccontrol)
   private

    icommitref,ihightimer,itimerAUTO,itimer250:comp;
    ilastval,ireloadid,idownval,ipaintid,ivalid,ilastpaintid,ilastvalid,imin,imax,idef,ival:longint;
    ffindlabel :tsimplestringevent;
    fclicklabel:tsystemnotify;
    fonreadwriteval,fonreadwritedef:tbasicint_onreadwriteval;
    fonvalue2:tlongintevent;
    foncommitvalue:tnotifyevent;
    idownball,iaball,ialabel,iabar:twinrect;
    vnone,vlabel,vbar,ihoverref,idownstyle,ihoverstyle:longint;
    icanmorelessonup:boolean;
    ilastlabel:string;

    procedure setval(xval:longint);
    procedure writeval(xval:longint);
    function readval:longint;
    function readdef:longint;
    procedure __onvol(sender:tobject;var xval:longint;xwrite:boolean);
    function xfindlabel:string;
    procedure xclicklabel;
    function vfind(x:tpoint):longint;
    procedure xmoreless;//06jun2025
    function xrowheight:longint;//05sel2025

   public
    oloadfromname:string;//get value from a system value using a name
    oautoreload:boolean;
    oalign:longint;//default=1=center, 0=left, 2=right
    ohelplabel:string;//label help
    ohelpbar  :string;//bar help
    ounit     :string;
    osep      :string;
    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    procedure _onpaint(sender:tobject); override;
    function getalignheight(xclientwidth:longint):longint; override;
    //workers
    procedure setparams(xmin,xmax,xdef,xval:longint);
    procedure setparams3(xmin,xmax,xdef,xval:longint;xloadfromname:string);
    property min:longint read imin;
    property max:longint read imax;
    property def:longint read idef;
    property val:longint read readval write setval;
    procedure reload;//uses "oloadfromname" to gain value - 07sep2020
    //events
    property onfindlabel   :tsimplestringevent       read ffindlabel      write ffindlabel;
    property onclicklabel  :tsystemnotify            read fclicklabel     write fclicklabel;
    property onvalue2      :tlongintevent            read fonvalue2       write fonvalue2;//26feb2021
    property onreadwriteval:tbasicint_onreadwriteval read fonreadwriteval write fonreadwriteval;
    property onreadwritedef:tbasicint_onreadwriteval read fonreadwritedef write fonreadwritedef;
    property oncommitvalue :tnotifyevent             read foncommitvalue  write foncommitvalue;
    //makers
    procedure makemidivol;//23mar2022
    procedure makewavevol;
    procedure makevol(xmade:longint);//15aug2025, 09jan2025, 12nov2022
    procedure makemiditranspose;//15aug2025, 14feb2025
   end;

{tbasicset}
   pbasicset_valarray=^tbasicset_valarray;//08nov2025
   tbasicset_valarray=array[0..31] of boolean;

   tbasicset_onreadwriteval=procedure(sender:tobject;var xval:tbasicset_valarray;xwrite:boolean) of object;
   tbasicset=class(tbasiccontrol)
   private

    itimer250:comp;
    icaps:array[0..31] of string;
    inams:array[0..31] of string;
    ihlps:array[0..31] of string;
    ivisb:array[0..31] of boolean;
    iloadfromnames:array[0..31] of string;
    irecs:array[0..31] of twinrect;
    ilastval,ireloadid,icount,ilastitemsperline,ilastcount,iitemsperline,idownindex,ihoverindex,ipaintid,ivalid,ilastpaintid,ilastvalid,idef,ival:longint;
    fonreadwriteval:tbasicset_onreadwriteval;

    procedure setval(xval:longint);
    procedure xnorects;
    function getcaps(xindex:longint):string;
    procedure setcaps(xindex:longint;xval:string);
    function getnams(xindex:longint):string;
    procedure setnams(xindex:longint;xval:string);
    function getvisb(xindex:longint):boolean;
    procedure setvisb(xindex:longint;xval:boolean);
    function getvals(xindex:longint):boolean;
    procedure setvals(xindex:longint;xval:boolean);
    procedure setitemsperline(x:longint);
    procedure xsynccount;
    procedure ysetval(xval:longint);
    function ygetval:longint;
    property yval:longint read ygetval write ysetval;
    function getvals2(xname:string):boolean;
    procedure setvals2(xname:string;xval:boolean);
    function xrowheight:longint;//05sel2025

   public

    //options
    oautoreload:boolean;
    ovpad:longint;//default=0, set to Nxbordersize to pad vertical height to match other stacked controls - 21may2022
    oshowtitle:boolean;//default=true - 25dec2022

    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    function getalignheight(xclientwidth:longint):longint; override;

    //workers
    function linecount:longint;
    property count:longint read icount;
    function viscount:longint;//visible count
    property itemsperline:longint read iitemsperline write setitemsperline;
    procedure xset(xindex:longint;xcap,xnam,xhlp:string;xval:boolean);
    procedure xset3(xindex:longint;xcap,xnam,xhlp:string;xval:boolean;xloadfromname:string);
    property caps[xindex:longint]:string read getcaps write setcaps;
    property nams[xindex:longint]:string read getnams write setnams;
    property visb[xindex:longint]:boolean read getvisb write setvisb;
    procedure setparams(xdef,xval:longint);
    procedure setparams2(xdef,xval,xitemsperline:longint);
    property def:longint read idef;
    property val:longint read ygetval write setval;
    property vals[xindex:longint]:boolean read getvals write setvals;
    property vals2[xname:string]:boolean read getvals2 write setvals2;//28feb2022
    function findname(xname:string;var xindex:longint):boolean;
    procedure reload;//uses "oloadfromname" to gain value - 07sep2020

    //events
    procedure _onpaint(sender:tobject); override;
    property onreadwriteval:tbasicset_onreadwriteval read fonreadwriteval write fonreadwriteval;

    //makers
    procedure makesleek;
    procedure makesleek2;

   end;

{tbasicsel}
   tbasicsel_onreadwriteval=procedure(sender:tobject;var xval:longint;xwrite:boolean) of object;
   tbasicsel=class(tbasiccontrol)
   private

    icaps:array[0..31] of string;
    inams:array[0..31] of string;
    ihlps:array[0..31] of string;
    istrs:array[0..31] of string;//host support only
    irecs:array[0..31] of twinrect;
    itep,ireloadid,icount,ilastitemsperline,ilastcount,iitemsperline,idownindex,ihoverindex,ipaintid,ivalid,ilastpaintid,ilastvalid,idef,ival,imax:longint;
    iwasselected:boolean;
    fonreadwriteval:tbasicsel_onreadwriteval;
    fonclick:tnotifyevent;
    itimer500:comp;

    function getval2(xmin:longint):longint;
    procedure setval2(xmin,xval:longint);
    procedure setval(xval:longint);
    procedure writeval(xval:longint);
    function readval:longint;
    procedure xnorects;
    function getcaps(xindex:longint):string;
    procedure setcaps(xindex:longint;xval:string);
    function getnams(xindex:longint):string;
    procedure setnams(xindex:longint;xval:string);
    function gethlps(xindex:longint):string;//13mar2022
    procedure sethlps(xindex:longint;xval:string);
    function getstrs(xindex:longint):string;
    procedure setstrs(xindex:longint;xval:string);
    procedure xsynccount;
    procedure setitemsperline(x:longint);
    procedure settep(x:longint);
    function xrowheight:longint;

   public

    //options
    oloadfromname:string;//get value from a system value using a name
    oautoreload:boolean;
    ovalueclick:boolean;//default=false, true=onvalue is fired EACH TIME an item is selected EVEN if it is already selected - 29aug2021
    omididevice:boolean;//running as a Midi Device selector - 05mar2022
    owavedevice:boolean;//running as a Wave Device selector - 05mar2022
    owinedevice:boolean;//maintains "wine" status label - 09sep2025
    oboldhead:boolean;//default=false - 12mar2022
    oshowtitle:boolean;//default=true

    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    function getalignheight(xclientwidth:longint):longint; override;
    procedure xsyncmididevice(xforce:boolean); virtual;
    procedure xsyncwavedevice(xforce:boolean); virtual;
    procedure xsyncwinestatus;

    //workers
    property tep:longint read itep write settep;
    function linecount:longint;
    property itemsperline:longint read iitemsperline write setitemsperline;
    procedure xclear;
    procedure xadd(xcap,xnam,xhlp:string);
    procedure xadd2(xcap,xnam,xhlp,xstr:string);
    property caps[xindex:longint]:string read getcaps write setcaps;
    property nams[xindex:longint]:string read getnams write setnams;
    property hlps[xindex:longint]:string read gethlps write sethlps;
    property strs[xindex:longint]:string read getstrs write setstrs;
    procedure setparams(xdef,xval:longint);
    procedure setparams2(xdef,xval,xitemsperline:longint);
    procedure setparams3(xdef,xval,xitemsperline:longint;xloadfromname:string);
    property def:longint read idef;
    property val:longint read ival write setval;
    property val2[xmin:longint]:longint read getval2 write setval2;
    property max:longint read imax;
    procedure reload;//uses "oloadfromname" to gain value - 07sep2020
    property wasselected:boolean read iwasselected;

    //find
    function findname(xnam:string;var xindex:longint):boolean;

    //events
    procedure _onpaint(sender:tobject); override;
    property onreadwriteval:tbasicsel_onreadwriteval read fonreadwriteval write fonreadwriteval;
    property onclick:tnotifyevent read fonclick write fonclick;//07mar2022

    //makers
    procedure makesleek;
    procedure makesleek2;
    function makemididevice:tbasicsel;//09sep2025, 21aug2025
    function makewavedevice:tbasicsel;//21aug2025

   end;

{tbasictea}
   tbasictea=class(tbasiccontrol)
   private
    itimer500:comp;
    iversion,iwidth,iheight,ibytes,ipadv1,ipadh1,iminw,iminh,imaxw,imaxh:longint;
    itransparent,isyscolors,imustpaint:boolean;
    idata:tstr8;
    imanage_toolbar1,imanage_toolbar2:tbasictoolbar;//optional integrated toolbar handlers
    function gettext:string;
    procedure settext(x:string);
    function xtitleborder:longint;
    function xtitleheight:longint;
    function xtitleheight2:longint;
    procedure xsync;
   public
    //options
    odefaultmsg:string;//default=nil="( Not in use )" -> set to override the default message - 12apr2021
    odefault:boolean;//default=true
    osyscolors:boolean;//default=false=converts "(0,0,0)" and "(1,0,0)" to "(1,1,1)" to avoid system black color handling - 13apr2021
    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    function getalignheight(xclientwidth:longint):longint; override;
    procedure xshowmenuFill(sender:tobject;xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string);
    function xshowmenuClick(sender:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    function xcmd(sender:tbasiccontrol;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean;
    //information
    property width:longint read iwidth;
    property height:longint read iheight;
    property bytes:longint read ibytes;
    property version:longint read iversion;
    property transparent:boolean read itransparent;
    property syscolors:boolean read isyscolors;
    //workers
    procedure setparams(xmaxW,xmaxH:longint);
    property maxW:longint read imaxw;
    property maxH:longint read imaxH;
    property text:string read gettext write settext;
    function setdata(xdata:tstr8):boolean;//13apr2021
    function getdata(xdata:tstr8):boolean;
    function settep(xindex:longint):boolean;
    function setimg(ximg:tobject;xtransparent,xsyscolors:boolean):boolean;
    function getimg(ximg:tobject):boolean;
    //manage
    procedure manage(xtoolbar1,xtoolbar2:tbasictoolbar);
    procedure unmanage;
    //events
    procedure _onpaint(sender:tobject); override;
   end;

{tbasiccolors}
   tbasiccolors=class(tbasiccontrol)
   private
    istys   :array[0..299] of longint;
    icaps   :array[0..299] of string;
    inams   :array[0..299] of string;
    iidxs   :array[0..299] of longint;//for system colors
    ihlps   :array[0..299] of string;
    icols   :array[0..299] of longint;
    idefcols:array[0..299] of longint;
    irecs   :array[0..299] of twinrect;
    icount,imax,idownindex,iitemsperline,ilastalignid,ialignid,ilastpaintid,ipaintid:longint;
    ilastsysname:string;
    imustwrite:boolean;
    foncolor:tlongintevent;
    foncolorchanged:tnotifyevent;
    procedure xnewid(xalign,xpaint:boolean);
    procedure setitemsperline(x:longint);
    function getcap(x:longint):string;
    procedure setcap(x:longint;xval:string);
    function getnam(x:longint):string;
    procedure setnam(x:longint;xval:string);
    function getcol(x:longint):longint;
    procedure setcol(x:longint;xval:longint);
    procedure setcol3(x:longint;xval:longint);
    function getidx(x:longint):longint;
    procedure xsynccount;
    function getcol1(xidx:longint):longint;
    procedure setcol1(xidx:longint;xval:longint);
    procedure xsetcol(x:longint;xval:longint;xspecialoverride:boolean);
    function getcol2(xname:string):longint;
    procedure setcol2(xname:string;xval:longint);
    function xpaintcalc(xmustpaint:boolean):longint;
    function getdata:string;
    procedure setdata(x:string);
    //special color handlers - 25may2021
    procedure xset(xindex,xval:longint);
    procedure xspecial(xname,xstyle:string;xval:longint);
   public
    //options
    osyscolor:boolean;//default=false, true=directly edits "custom" colors in "syssettings"
    oshowcaps:boolean;//default=true
    opopcolor:boolean;//default=true=click/drag to adjust color, false=color is locked (static)
    otightblocks:boolean;//default=false
    oclicktouse:boolean;//default=false
    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    function getalignheight(xclientwidth:longint):longint; override;
    //information
    property count:longint read icount;
    property itemsperline:longint read iitemsperline write setitemsperline;
    property nam[x:longint]:string read getnam;
    property idx[x:longint]:longint read getidx;
    property cap[x:longint]:string read getcap;
    property col[x:longint]:longint read getcol write setcol;
    property col1[xidx:longint]:longint read getcol1 write setcol1;//updates when color changes
    property col2[xname:string]:longint read getcol2 write setcol2;
    property col3[xidx:longint]:longint read getcol1 write setcol3;//updates when color changes AND always updates if it's a special color being set - 25may2021
    function linecount:longint;
    function lineheight:longint;//color palette - 05sep2025, 24may2025
    function lineheight2:longint;//title
    property data:string read getdata write setdata;
    //workers
    procedure clear;
    procedure addcol(xcap,xnam,xhlp:string);
    procedure addcol1(xcap:string;xidx:longint;xhlp:string);
    procedure addcol2(xcap,xnam,xhlp:string;xidx,xcol,xdefcol:longint);
    procedure addtitle(xcap,xhlp:string);
    procedure xadd(xstyle:longint;xcap,xnam,xhlp:string;xidx,xcol,xdefcol:longint);
    function findname(xname:string;var xindex:longint):boolean;
    function findidx(xidx:longint;var xindex:longint):boolean;
    //system color workers
    procedure xreadfrom(xnormal,xtitle:pvirtualinfo;xmorecolors:pvirtualmorecolors);
    procedure xwriteto(xnormal,xtitle:pvirtualinfo;xmorecolors:pvirtualmorecolors);
    procedure fromsys(xname:string);
    procedure tosys(xname:string;xautosync:boolean);
    //makers
    procedure makesystem;
    procedure makeadjustable;
    procedure makeadjustable2(xitemsperline:longint);
    //events
    property oncolor:tlongintevent read foncolor write foncolor;//tiggered when using "oclicktouse=true"
    property oncolorchanged:tnotifyevent read foncolorchanged write foncolorchanged;
   end;

{tbasictoolbar}
   tbasictoolbar=class(tbasiccontrol)
   private
    iformrect:twinrect;
    fonclick:tnotifyevent;
    fonclick2:ttoolbarevent2;
    icaption2,iinforef:string;
    ihalign,ilastfindbycode2,irowcount,istyle,idownindex,ifocusindex,ihoverindex,iaddcount,itepheight,irowpad,ibuttonpad,ibuttonvpad:longint;
    icountdown1000,itimer500,itimer250,itimer100:currency;
    imustlink,iflash,ilastflash,ipause:boolean;
    //.animation support
    ianitep:array[0..19] of longint;
    ianims :array[0..19] of longint;
    ianipos,ianicount:longint;
    ianiplay64,ianinext64:comp;
    //.image
    piw       :array[0..99] of longint;
    pih       :array[0..99] of longint;
    pit       :array[0..99] of longint;//tep
    //.text
    ptw       :array[0..99] of longint;
    pth       :array[0..99] of longint;
    ptf       :array[0..99] of longint;//font index
    //.position
    poa       :array[0..99] of twinrect;//out area
    pa        :array[0..99] of twinrect;//inner area
    puse      :array[0..99] of boolean;
    //.other
    icolor    :array[0..99] of longint;//custom tep color -> default is "clnone=Off"
    icolorb   :array[0..99] of longint;//custom tep color2  -> default is "clnone=Off"
    ititle    :array[0..99] of boolean;//17mar2025
    icap      :array[0..99] of string;
    isize     :array[0..99] of longint;//0=automatic (default), 1..N=static pixels, -1..-N=percentage
    ipert     :array[0..99] of double;//0..100 -> optional progress bar support - 07jul2021
    itep      :array[0..99] of longint;
    icode     :array[0..99] of longint;
    icode2    :array[0..99] of string;//inline with "tbasicmenu"
    ibuthelp  :array[0..99] of string;
    iref      :array[0..99] of string;
    ienableds :array[0..99] of boolean;
    ivisibles :array[0..99] of boolean;
    imarked   :array[0..99] of boolean;
    ihighlight:array[0..99] of boolean;//30may2021
    iflasher  :array[0..99] of boolean;//24feb2021
    icountdown:array[0..99] of longint;//in seconds -> "min32..0" = off, 1..max32 = seconds remaining - 05sep2020

    //window head support
    iishead,iwmin,iwmax,iwclo,iwmen,iwfull,iappicon,iappcap:boolean;
    iapptep:longint;
    procedure setstyle(x:longint);
    function xok(x:longint):boolean;
    function uok(x:longint):boolean;//user range
    procedure xsetcap(x:longint;y:string);
    function xgetcap(x:longint):string;
    procedure xsettep(x:longint;y:longint);
    function xgettep(x:longint):longint;
    procedure xsetsize(x:longint;y:longint);
    function xgetsize(x:longint):longint;
    procedure xsettitle(x:longint;y:boolean);
    function xgettitle(x:longint):boolean;
    procedure setpert(x:longint;y:double);
    function getpert(x:longint):double;
    procedure xsetcountdown(x,y:longint);//05sep2020
    function xgetcountdown(x:longint):longint;
    procedure xsetcode(x,y:longint);
    function xgetcode(x:longint):longint;
    procedure xsetcode2(x:longint;y:string);
    function xgetcode2(x:longint):string;
    procedure xsethelp(x:longint;y:string);
    function xgethelp(x:longint):string;
    procedure xsetvisibles(x:longint;y:boolean);
    function xgetvisibles(x:longint):boolean;
    procedure xsetenableds(x:longint;y:boolean);
    function xgetenableds(x:longint):boolean;
    procedure xsetmarked(x:longint;y:boolean);
    function xgetmarked(x:longint):boolean;
    procedure xsetcolor(x,y:longint);
    function xgetcolor(x:longint):longint;
    procedure xsetcolorb(x,y:longint);
    function xgetcolorb(x:longint):longint;
    procedure xsethighlight2(x:string;y:boolean);
    function xgethighlight2(x:string):boolean;
    procedure xsetcap2(x:string;y:string);
    function xgetcap2(x:string):string;
    procedure xsettep2(x:string;y:longint);
    function xgettep2(x:string):longint;
    procedure xsetflash(x:longint;y:boolean);
    function xgetflash(x:longint):boolean;
    procedure xsethighlight(x:longint;y:boolean);//15mar2022
    function xgethighlight(x:longint):boolean;
    procedure xsetvisible2(x:string;y:boolean);
    function xgetvisible2(x:string):boolean;
    procedure xsetflash2(x:string;y:boolean);
    function xgetflash2(x:string):boolean;
    procedure xsetmarked2(x:string;y:boolean);
    function xgetmarked2(x:string):boolean;
    procedure xsetenabled2(x:string;y:boolean);
    procedure xsetcolor2(x:string;y:longint);
    function xgetcolor2(x:string):longint;
    procedure xsetcolor2b(x:string;y:longint);
    function xgetcolor2b(x:string):longint;
    function xgetenabled2(x:string):boolean;
    procedure xsetsize2(x:string;y:longint);
    function xgetsize2(x:string):longint;
    procedure xsettitle2(x:string;y:boolean);
    function xgettitle2(x:string):boolean;
    procedure xsetpert2(x:string;y:double);
    function xgetpert2(x:string):double;
    procedure xsethelp2(x,y:string);//09jun2025
    function xgethelp2(x:string):string;//09jun2025
    function xcapok(xindex:longint):boolean;
    function xtepok(xindex:longint):boolean;
    function xcapok2(xindex:longint;xallowemptyCAP:boolean):boolean;
    function xtepok2(xindex:longint):boolean;//supports visible=false
    function getparentpage:string;
    procedure setparentpage(x:string);
    procedure xclickbutton(xindex:longint);
    function xflashcount:longint;
    //.find support
    function findhelp(xindex:longint):string;
    function xmapitems(xclientwidth,xbordersize,xminrowcount:longint;xautoheight:boolean):longint;//05jun2025: properly center small button contents, 20may2025, 04may2025, 21mar2025: fixed one item on 1st line wrap issue, 06jan2025
    procedure xcmd(x:longint);
    procedure sethalign(x:longint);
    procedure setapptep(x:longint);//app icon
    procedure setcaption2(x:string);//27dec2024
    function xcountcap(xindex:longint):string;
   public
    //options
    oclickthru:boolean;//default=false, true=transmit internally handled clicks to external host for analysis - 19jun2022
    owrap:boolean;//default=true
    odownsubtle:boolean;//default=false, true=draw background of "down" item with a subtle background shade - 11feb2023
    ocountdown:boolean;//default=true=allow countdowns
    ocountdown_dlgcheck:boolean;//default=true=countdown only if top dlg - 05sep2020
    ovpad:longint;//default=2, set in range 0..N
    ohpad:longint;//default=2, set in range 0..N
    ohbutpad:longint;//default=8
    ohbutpad1st:boolean;//default=true
    ojump:longint;//default=2 amount button shifts during down click
    //oflatback:boolean;//default=false, true=paints background using background color - overrides other effects
    ounderline:boolean;//default=true=underline text during hover/down, false=don't underline - 19jul2024
    omodified:boolean;//marks caption with an "*" to indicate changes have been made
    //.oequalwidths support
    oequalwidths:boolean;//default=false=each button assumes it's own width, true=each button has the same width as the longest/widest button - 02jun2021
    //.title support
    otitle:boolean;//default=false, true=toolbar with caption
    olarge:boolean;//default=false=small title caption, true=large title caption
    //.return values
    oindex:longint;
    ominrows:longint;//default=1
    oheadalign:boolean;//default=false, true=uses system "headalign" value for halign
    //.partline - 23mar2025
    opartline:single;//0=none, 1=full line height, 0.5=50% line height, 0.3=30% (default)
    oscaleh:single;
    oscalevpad:single;
    oscalesep:single;
    //.support
    otag2:longint;
    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;//20jul2025, 14jul2025
    procedure _onpaint(sender:tobject); override;//05jun2025, 15may2025
    function  _onnotify(sender:tobject):boolean; override;//17aug2025, 19jul2025
    function getalignheight(xclientwidth:longint):longint; override;
    //information
    property count:longint read iaddcount;//14jul2025
    property style:longint read istyle write setstyle;//0=tep+cap, 1=tep, 2=cap
    property pause:boolean read ipause write ipause;
    property halign:longint read ihalign write sethalign;
    function find__halign:longint;
    property caption;
    property caption2:string read icaption2 write setcaption2;
    property downindex:longint read idownindex;
    property hoverindex:longint read ihoverindex;
    //.by index
    property bcolor[xindex:longint]      :longint   read xgetcolor     write xsetcolor;
    property bcolorb[xindex:longint]     :longint   read xgetcolorb    write xsetcolorb;
    property btitle[xindex:longint]      :boolean   read xgettitle     write xsettitle;
    property bcap[xindex:longint]        :string    read xgetcap       write xsetcap;//Note: '-' = vertical sep (visible line), '+' = new line (invisible)
    property bsize[xindex:longint]       :longint   read xgetsize      write xsetsize;
    property btep[xindex:longint]        :longint   read xgettep       write xsettep;
    property bcode[xindex:longint]       :longint   read xgetcode      write xsetcode;
    property bcode2[xindex:longint]      :string    read xgetcode2     write xsetcode2;
    property bcountdown[xindex:longint]  :longint   read xgetcountdown write xsetcountdown;
    property bhelp[xindex:longint]       :string    read xgethelp      write xsethelp;
    property benabled[xindex:longint]    :boolean   read xgetenableds  write xsetenableds;
    property bvisible[xindex:longint]    :boolean   read xgetvisibles  write xsetvisibles;
    property bmarked[xindex:longint]     :boolean   read xgetmarked    write xsetmarked;
    property bhighlight[xindex:longint]  :boolean   read xgethighlight write xsethighlight;//15mar2022
    property bflash[xindex:longint]      :boolean   read xgetflash     write xsetflash;
    //.by code
    property bcolor2[xcode2:string]      :longint   read xgetcolor2    write xsetcolor2;
    property bcolor2b[xcode2:string]     :longint   read xgetcolor2b   write xsetcolor2b;
    property btitle2[xcode2:string]      :boolean   read xgettitle2    write xsettitle2;
    property bsize2[xcode2:string]       :longint   read xgetsize2     write xsetsize2;
    property bpert2[xcode2:string]       :double    read xgetpert2     write xsetpert2;
    property bhelp2[xcode2:string]       :string    read xgethelp2     write xsethelp2;//09jun2025
    property benabled2[xcode2:string]    :boolean   read xgetenabled2  write xsetenabled2;
    property bvisible2[xcode2:string]    :boolean   read xgetvisible2  write xsetvisible2;
    property bmarked2[xcode2:string]     :boolean   read xgetmarked2   write xsetmarked2;
    property bhighlight2[xcode2:string]  :boolean   read xgethighlight2 write xsethighlight2;
    property bflash2[xcode2:string]      :boolean   read xgetflash2    write xsetflash2;
    property bcap2[xcode2:string]        :string    read xgetcap2      write xsetcap2;
    property btep2[xcode2:string]        :longint   read xgettep2      write xsettep2;//19dec2021
    property parentpage:string read getparentpage write setparentpage;
    //.low level
    function xtextTOP(x:longint):longint;//11may2025
    //makers
    function maketitle(xcap:string):tbasictoolbar;
    function maketitle2(xcap:string;xlarge:boolean):tbasictoolbar;
    function maketitle3(xcap:string;xlarge,xright:boolean):tbasictoolbar;
    function makelinksSubtle:tbasictoolbar;//11feb2023
    function makeWinhead(xwinallbuttons:boolean):tbasictoolbar;//26dec2024
    function makeWinhead2(xclose,xall,xappicon,xlarge:boolean;xapptep:longint):tbasictoolbar;//26dec2024
    function makeWinhead__status_small:tbasictoolbar;//26dec2024
    //add
    procedure clear;//13jul2025, 22sep2020
    procedure clear1(p:longint);//13jul2025
    function add(xcap:string;xtep,xcode:longint;xcode2,xhelp:string):longint;
    function add2(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;ximgright:boolean):longint;
    function add3(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xenabled,xvisible,ximgright:boolean):longint;
    function sadd(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xsize,xalign:longint):longint;
    function hcsadd(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xsize:longint):longint;//highlighter with button padding - 05jun2021
    function csadd(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xsize:longint):longint;
    function rsadd(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xsize:longint):longint;
    function lsadd(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xsize:longint):longint;
    function cadd(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xcountdown:longint):longint;
    function cadd2(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;ximgright:boolean;xcountdown:longint):longint;
    function cadd3(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xenabled,xvisible,ximgright:boolean;xcountdown:longint):longint;
    function cadd4(xcap:string;xtep,xcode:longint;xcode2,xhelp:string;xenabled,xvisible,ximgright,xbutpad:boolean;xcountdown,xsize,xalign:longint):longint;
    function addsep:longint;
    function addsep2(xcode2:string):longint;
    function addhline:longint;//draw horizontal line under current line - 26sep2022
    function newline:longint;//05jun2021
    function newpartline:longint;//23mar2024
    //.optional system links - 14aug2020
    procedure xaddoptions;
    procedure xaddoptions2(xtep:longint;xcmd:string);//27jan2025, 07mar2022
    procedure xaddhelp;
    procedure xaddabout;
    procedure xaddsplash;
    procedure xaddmixer;//07mar2022
    procedure xaddmax;//15mar2022
    procedure xaddonTop;//15mar2022
    //find
    function xfind(sx,sy:longint;var xindex:longint):boolean;//27dec2024
    function xfindb(sx,sy:longint):longint;
    function xfindbycode(xcode:longint):longint;
    function xfindbycodeb(xcode:longint;var xindex:longint):boolean;
    function xfindbycode2(const xcode2:string):longint;
    function xfindbycode2b(const xcode2:string;var xindex:longint):boolean;
    function xfindbycodes(xcode:longint;xcode2:string):longint;
    //window head support
    function xishead:boolean;
    property wmin:boolean read iwmin;
    property wmax:boolean read iwmax;
    property wclo:boolean read iwclo;
    property wmen:boolean read iwmen;
    property wfull:boolean read iwfull;
    property wappicon:boolean read iappicon;
    property wappcap:boolean read iappcap;
    property tep:longint read iapptep write setapptep;//app tep
    //.animate the icon
    function aniAdd(xtep,xms:longint):boolean;//16sep2022
    procedure aniClear;
    procedure aniPlay;
    //.copy from
    procedure copyitemsfrom(x:tbasictoolbar);//14jul2025
    procedure copyitemsfrom2(x:tbasictoolbar;xallitems:boolean);//14jul2025
    procedure copyitemsfrom3(s:tbasictoolbar;dkeepcount,sfromindex:longint);//14jul2025
    //special
    procedure marktab(xname:string;xmark:boolean);//11sep2021
    function canmovewindow:boolean;//20jul2025, 14jul2025
    //reference
    function visref:string;//05jun2021
    //events
    property onclick:tnotifyevent read fonclick write fonclick;
    property onclick2:ttoolbarevent2 read fonclick2 write fonclick2;
   end;

{tbasicmenu}
   tbasicmenu=class(tbasiccontrol)
   private
    imanysel1,imanysel2:longint;//28sep2022
    icountx,ireloadid,itep,iselstart,iselcount,idownpos,ilastitemindex,idownindex,ipos,ipad,imaxindentwidth,imaxttitepwidth,imaxtepwidth,imaxtepheight,imaxcapwidth,imaxtitcapwidth,imaxcutwidth,irowpad,icount,ihoverindex:longint;
    ilastflash,iwasflashing,iflashing,icandrag:boolean;
    idata:tstr8;//menu items as a realtime readable data block
    iv:tbasicscrollbar;
    fonclick,fondbclick:tnotifyevent;
    fongetitem:tbasicmenu_getitem;
    //.list of items painted on screen with their itemindex+vertical areas -> format: [itemindex/4]+[y.start/4]+[y.finish/4] => list of items and their click areas -> a mouse click in one of these areas equates to a menu item being actioned - 28mar2020
    ilist:tstr8;//Note: list never shrinks for maximum stability
    ilistcount:longint;//number of active items
    procedure setdata(x:tstr8);//17nov2024, 08jun2021
    procedure setpos(x:longint);
    procedure sethoverindex(x:longint);
    function xrowheight:longint;
    function xrowcount:longint;
    procedure _onpos(sender:tobject);
    procedure setselstart(x:longint);
    procedure setselcount(x:longint);
    procedure setcountx(x:longint);
    procedure setdownindex(x:longint);
    function getitemindex:longint;
    procedure setitemindex(x:longint);
   public

    //options
    ofast:boolean;//default=false=maxwidths are calculated, true=maxwidths are omitted and "_onpaint()" proc must work on the fly for maximum speed - use for large lists etc - 29mar2020
    orows:boolean;//default=false, true=alternate the coloring of continous items, restarts after each title item - 07apr2020
    ostyle:byte;//0(lsmenu)=menu, l(lslist)=single item highlight list, 2(lspanel)=view panel, 3(lsmany)=multi-select list
    okeepopen:boolean;//default=false, true=menu stays open after a mouse click - 07apr2020
    orowcount:longint;//default=0=off, 1..N=make # rows in height - 14aug2020
    oautoclose:boolean;//default=true
    ohoverunderline:boolean;//default=true=underline hover item, false=do not underline a hover item
    onumberfrom:longint;//default=-1=off - 20mar2022
    onumberfrom2:longint;//default=-1=off - 20mar2022
    onumberfrom3:longint;//default=-1=off - 20mar2022

    //.list based options - 07sep2020
    oloadfromname:string;
    oautoreload:boolean;
    oretainpos:boolean;//default=false, true=retain vertical position during "setdata()" - 04oct2020
    oscaleh:single;//default=1.0

    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;
    function getalignwidth(xclientheight:longint):longint; override;
    function xsetclientarea(a:twinrect):boolean; override;
    function xgetitem(xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean;//03oct2024, 20mar2022
    function xgetval(xindex:longint;var xvalue:string):boolean;
    function xgetval2(xindex:longint):string;//03mar2022
    //information
    property pos:longint read ipos write setpos;//scroll position
    property hoverindex:longint read ihoverindex write sethoverindex;
    property downindex:longint read idownindex write setdownindex;//22mar2021, 24feb2021
    property countx:longint read icountx write setcountx;//-1=off (init only), 0..N=realtime dynamic list mode -> values sourced externally - 28spe2020
    property count:longint read icount;//number of menu items
    function vpos1:longint;//first visible item
    function vpos2:longint;//last visible item
    function vcount:longint;//visible count
    function scount:longint;//scroll count
    property data:tstr8 read idata write setdata;
    property tep:longint read itep write itep;//fallback tep used when no tep specified
    //.special list support
    property selstart:longint read iselstart write setselstart;
    property selcount:longint read iselcount write setselcount;
    function setsel(xselstart,xselcount:longint):boolean;
    function xsetsel(xselstart,xselcount:longint):boolean;
    property itemindex:longint read getitemindex write setitemindex;
    property rowheight:longint read xrowheight;//11oct2022
    //selectrange
    function canselectrange:boolean;//28sep2022
    procedure selectrange;
    procedure selectoff;
    //.support
    procedure xselectrange(x1,x2:longint);
    //find
    function xfindb(sx,sy:longint):longint;
    function xfind(sx,sy:longint;var xindex:longint):boolean;//07apr2020
    function xfindbycode2(xfindval:string;var xindex:longint):boolean;
    function xfindbycaption(xfindval:string;var xindex:longint):boolean;//28sep2020
    function xfindbycaption2(xfindval:string):longint;
    function xfindnext(xfindpart:string;var xindex:longint):boolean;//06oct2020
    function xok(x:longint):boolean;
    //makers
    procedure makemenu;
    procedure makelist;
    procedure makelistx(xcount:longint);//22sep2020
    procedure makepanel;//28aug2026, 18aug2025
    procedure makemany;
    procedure makepoplist;
    procedure makepopmany;
    //reload
    procedure reload;
    //events
    property onclick:tnotifyevent read fonclick write fonclick;
    property ondbclick:tnotifyevent read fondbclick write fondbclick;
    property ongetitem:tbasicmenu_getitem read fongetitem write fongetitem;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;//15may2025, 20jul2024: soft back shade for title items
    procedure _onalign(sender:tobject); override;
    function  _onnotify(sender:tobject):boolean; override;
    function  _onshortcut(sender:tobject):boolean; override;
   end;

{tbasicscrollbar}
   tbasicscrollbar=class(tbasiccontrol)
   private
    iposref64,idowntime64,itimer100,itimerscroll:currency;
    iinforef:string;
    idownbutindex,idownpos,ipos,imin,imax:longint;
    iscrollscope:extended;
    ilessbut,imorebut,idragzone,idragbut:twinrect;
    idragbutdown:boolean;
    fonpos:tnotifyevent;
    fonarrow:tlongintgetevent;//21jun2022
    procedure setpos(x:longint);
    function xmoveval(x:longint):longint;
   public
    //options
    overtical:boolean;//default=true=vertical, false=horizontal
    owheelchange:longint;//default=1
    osmallchange:longint;//default=1
    olargechange:longint;//default=10
    oassistedscroll:longint;//default=10 - 04oct2022
    ofullhandling:boolean;//default=true=all functions handled internally, false=some keyboard and wheel functions are passed down to parent control - 04apr2020
    //create
    constructor create2(xparent:tobject;xstart:boolean); override;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;
    function getalignwidth(xclientheight:longint):longint; override;
    //pos
    property pos:longint read ipos write setpos;
    property min:longint read imin;
    property max:longint read imax;
    procedure setparams(xpos,xmin,xmax:longint);
    procedure setparams2(xpos,xmin,xmax:longint;xevent:boolean);
    //events
    property onpos:tnotifyevent read fonpos write fonpos;
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function  _onnotify(sender:tobject):boolean; override;
    property onarrow:tlongintgetevent read fonarrow write fonarrow;
   end;

{tbasicscroll}
   tbasicscroll=class(tbasiccontrol)
   private
    itimer100,itimer250:currency;
    ipageindex,irightgap,irightminwidth,irightmaxwidth,idownpos:longint;
    ipage,iposref,iinforef:string;
    iv:tbasicscrollbar;
    irightvisible2,irightmax,istatic,iscroll:boolean;
    //.built-in root controlls
    ihead:tbasictoolbar;//27dec2024
    imainhelp:tmainhelp;//24jul2021
    itoolbar,itoolbar2,itoolbar3:tbasictoolbar;
    igrad,igrad2,igrad3,igrad4:tbasicgradient;//19aug2024
    ihigh,ihigh2:tbasicscroll;//automatic-height panels - 21feb2021
    istatus,istatus2:tbasicstatus;
    icols:tbasiccols;
    ihelp:tbasichelp;
    imenu:tbasicmenu;
    iright:tbasicscroll;//optional - 24jul2021
    function getpos:longint;
    procedure setpos(x:longint);
    procedure setscroll(x:boolean);
    procedure setstatic(x:boolean);
    procedure setpage(x:string);
    procedure setpageindex(x:longint);//09jan2025
    procedure xcalcalign(xalignok:boolean;xclientwidth:longint;var xoutclientheight,xoutheight:longint);
    procedure setrightmax(x:boolean);
    procedure setrightgap(x:longint);
    procedure setrightminwidth(x:longint);
    procedure setrightmaxwidth(x:longint);
    function getrightvisible:boolean;
    procedure setrightvisible(x:boolean);
    procedure setrightvisible2(x:boolean);//optionally HIDE the right column (used for help) EVEN when it's set to SHOW - 17dec2024
   public
    //options
    osmallchange:longint;//default=10%
    olargechange:longint;//default=50%
    ofirstpos:longint;//default=min32=off
    otopspace:longint;//default=0px
    ofullalignpaint:boolean;//default=false, true=realign entire GUI as the page being shown may adjust the GUI layout
    //create
    constructor create(xparent:tobject); override;
    constructor create2(xparent:tobject;xscroll,xstart:boolean); virtual;
    destructor destroy; override;
    procedure destroychildren; override;
    function headheight:longint; override;//25jan2021
    function clientinner2(x:tbasiccontrol):twinrect; override;
    function getalignheight(xclientwidth:longint):longint; override;
    function findbordersize:longint; override;
    procedure setnormal(x:boolean); override;//19jul2025
    //children
    function childcount:longint;//17mar2025
    function findchild(xindex:longint;var xchild:tbasiccontrol):boolean;//17mar2025
    //information
    property pos:longint read getpos write setpos;
    property scroll:boolean read iscroll write setscroll;
    property static:boolean read istatic write setstatic;
    property page:string read ipage write setpage;
    property pageindex:longint read ipageindex write setpageindex;
    function xbuiltinOK(x:tobject):boolean;
    //auto-create controls
    function xright:tbasicscroll;//right side - 24jul2021
    function xmainhelp:tmainhelp;//14may2025, 05dec2024, 24jul2021
    function xhead:tbasictoolbar;//top
    function xhelp:tbasichelp;//top
    function xtoolbar:tbasictoolbar;//top
    function xstatus:tbasicstatus;//top
    function xgrad:tbasicgradient;//below "xhead"
    function xgrad2:tbasicgradient;//below "xtoolbar2" and above "xtoolbar3"
    function xgrad3:tbasicgradient;//below "xhigh2" and above "xstatus2"
    function xgrad4:tbasicgradient;//above "xhigh2"
    function xnograd:boolean;//13jul2025
    function xhigh:tbasicscroll;//top - 21feb2021
    function xtoolbar2:tbasictoolbar;//bottom
    function xtoolbar3:tbasictoolbar;//05jun2025
    function xhigh2:tbasicscroll;//bottom - 21feb2021
    function xstatus2:tbasicstatus;//bottom
    function xcols:tbasiccols;//standard -> base takes up entire remaining clientarea
    function xcolsh:tbasiccols;//autoheight -> base takes up enough clientheight to display static children, scroll children adapt to height - 26feb2021
    function xpage(xpagename:string;xstatic:boolean):tbasicscroll;
    function xpage1(xpagename,xheadlink,xhelp:string;xtep:longint;xstatic:boolean):tbasicscroll;//12jan2025
    function xpage2(xpagename,xtoplink,xbotlink,xhelp:string;xtep:longint;xstatic:boolean):tbasicscroll;
    function xpage3(xpagename,xheadlink,xtoplink,xbotlink,xhelp:string;xtep,xtopspace:longint;xstatic:boolean):tbasicscroll;//12jan2025
    function xmenu:tbasicmenu;//bottom
    //detect controls
    function xhaveright:boolean;
    function xhavemainhelp:boolean;
    function xhavehead:boolean;
    function xhavehelp:boolean;
    function xhavemenu:boolean;
    function xhavetoolbar:boolean;
    function xhavegrad:boolean;
    function xhavegrad2:boolean;
    function xhavegrad3:boolean;
    function xhavegrad4:boolean;
    function xhavehigh:boolean;
    function xhavehigh2:boolean;
    function xhavecols:boolean;
    function xhavestatus2:boolean;
    function xhavetoolbar2:boolean;
    function xhavetoolbar3:boolean;//05jun2025
    function xhavestatus:boolean;
    //.right support
    property rightvisible:boolean read getrightvisible write setrightvisible;
    property rightvisible2:boolean read irightvisible2 write setrightvisible2;//17dec2024
    property rightmax:boolean read irightmax write setrightmax;
    property rightgap:longint read irightgap write setrightgap;
    property rightminwidth:longint read irightminwidth write setrightminwidth;
    property rightmaxwidth:longint read irightmaxwidth write setrightmaxwidth;
    procedure setrightparams(xminwidth,xmaxwidth,xgap:longint;xrightmax,xvisible:boolean);
    //makers
    function makedlg(da:twinrect;xshowhead:boolean):tbasicscroll;//27feb2021
    function makedlg2(da:twinrect;xshowhead,xstatic,xcancel,xok:boolean):tbasicscroll;
    function makedlg3(da:twinrect;xtep:longint;xtitle:string;xshowhead,xstatic:boolean;xcanceltime,xoktime:longint):tbasicscroll;
    function makeautohigh:boolean;
    //events
    procedure _ontimer(sender:tobject); override;
    procedure _onalign(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function  _onnotify(sender:tobject):boolean; override;
    //support
    function xsmall:longint;
    function xlarge:longint;
    procedure noscroll;//14jul2025
   end;

{tbasicimageexts}
   tbasicimageexts=class(tbasicscroll)
   private
    itimer250:comp;
    ilastref,iext,iactionlist:string;
    iitemsperline:longint;
    ilist:tbasicsel;
    procedure xsync;
    procedure setext(x:string);
    procedure setitemsperline(x:longint);
    procedure ____onclick(sender:tobject);
   public
    oautoshrink:boolean;//default=false, true=reduce height when no options for specified image format
    oboldhead:boolean;//default=false
    //create
    constructor create(xparent:tobject); override;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    //information
    property ext:string read iext write setext;//image format to display an action list for
    property actionlist:string read iactionlist;
    property itemsperline:longint read iitemsperline write setitemsperline;
   end;

{tbasicsetcolor}
   tbasicsetcolor=class(tbasicscroll)
   private
    icmbar:tbasictoolbar;
    ir,ig,ib,ia:tsimpleint;
    im:tbasiccolormatrix;
    icm:tbasiccolormixer;
    ic:tbasiccolor;
    icolor,iundocolor,irevertcolor:longint;
    iuse32,icanfillundo,ilocksync:boolean;
    foncolor:tlongintevent;
    procedure setcolor(x:longint);
    procedure __onclick(sender:tobject);//01feb2025
    procedure __oncolor(sender:tobject;xval:longint);
    function ext__onnotify(sender:tobject):boolean;
    procedure setcolor24(x:longint);
    function getcolor24:longint;
   public
    //create
    constructor create(xparent:tobject;xuse32,xhead:boolean); virtual;
    constructor create2(xparent:tobject;xscroll,xuse32,xhead,xstart:boolean); virtual;
    destructor destroy; override;
    //information
    property color:longint read icolor write setcolor;
    property color24:longint read getcolor24 write setcolor24;
    property revertcolor:longint read irevertcolor write irevertcolor;
    //workers
    procedure setparams(xcolor,xrevertcolor:longint;xpage:string);
    procedure getparams(var xcolor,xrevertcolor:longint;var xpage:string);
    //events
    property oncolor:tlongintevent read foncolor write foncolor;
   end;

{tbasiccols}
   tbasiccols=class(tbasiccontrol)
   private
    icols          :array[0..9] of tbasicscroll;
    isize          :array[0..9] of longint;
    iremcount      :array[0..9] of longint;//remainder in units
    imaxsizePX     :array[0..9] of longint;//in pixels
    iwratio        :array[0..9] of boolean;//default=true=adapts "fixed" sizes using vifontwidthratio
    ihsp,ivsp,istyle:longint;
    iinforef:string;
    itimer250:comp;
    procedure setremcount(x,xval:longint);
    function getremcount(x:longint):longint;
    function getcols(x:longint):tbasicscroll;
    function getcols2(x,xsize:longint;xscroll:boolean):tbasicscroll;
    function getcols3(x,xsize,xmaxsizePX:longint;xscroll:boolean):tbasicscroll;//17nov2024
    procedure setstyle(x:longint);
    procedure setsize(x,xval:longint);
    function getsize(x:longint):longint;
    procedure setmaxsizePX(x,xval:longint);
    function getmaxsizePX(x:longint):longint;
    procedure setwratio(x:longint;xval:boolean);
    function getwratio(x:longint):boolean;
    procedure sethsp(x:longint);
    procedure setvsp(x:longint);
    function xfindsize(x,cw:longint):longint;//17nov2024
    procedure setvis(x:longint;xval:boolean);
    function getvis(x:longint):boolean;
    procedure xsyncareas(xclientarea:twinrect;xcalconly:boolean);//27aug2025
   public
    //options
    ofullarea:boolean;//default=true=last column uses entire remaining space regardless of it's specified size - 07oct2020
    omakeautoheight:boolean;//default=false, true=make self and all "static" children "autoheight" where possible - 26feb2021
    ofillheight:boolean;//default=false, true=force columns to use remaining vertical height - 07mar2022 -> option was introduced because it was FAR TO DIFFICULT to work out which options were required in what order to get the same affect
    //create
    constructor create(xparent:tobject); override;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;//12jul2025: column width correctly used now
    function canautoheight:boolean; override;
    //information
    property style:longint                read istyle write setstyle;
    property cols[x:longint]:tbasicscroll read getcols;//auto-creates "static" columns as required -> range 0..9
    property cols2[x,xsize:longint;xscroll:boolean]:tbasicscroll read getcols2;//auto-creates as required -> range 0..9
    property cols3[x,xsize,xmaxsizePX:longint;xscroll:boolean]:tbasicscroll read getcols3;//auto-creates as required -> range 0..9
    property vis[x:longint]:boolean       read getvis write setvis;
    property size[x:longint]:longint      read getsize write setsize;
    property remcount[x:longint]:longint read getremcount write setremcount;
    property maxsizePX[x:longint]:longint read getmaxsizePX write setmaxsizePX;
    property wratio[x:longint]:boolean    read getwratio write setwratio;
    property vsp:longint read ivsp write setvsp;
    property hsp:longint read ihsp write sethsp;
    //makers
    procedure makeautoheight;//sets self and all STATIC children to oautoheight=true - 26feb2021
    function makecol(xindex,xremcount:longint;xscroll:boolean):tbasicscroll;//12may2025
    //events
    procedure _ontimer(sender:tobject); override;
    procedure _onalign(sender:tobject); override;
   end;

{tbasiccells}
   tbasiccellsimageevent=function(sender:tobject;xindex,xfocus,xcount:longint;var ximage:tbasicimage;var xtranscol:longint;var xcaption:string):boolean of object;
   tbasiccellsmoveevent=function(sender:tobject;sindex,dindex,xfocus,xcount:longint):boolean of object;
   tbasiccells=class(tbasiccontrol)
   private
    fonimage:tbasiccellsimageevent;
    fonmove:tbasiccellsmoveevent;
    ilastscrollpos,ilastfocus,iprevscrollpos,iprevfocus:longint;
    idropindex,istarty,istartx,istopx,ilastzoom,iseppad,itoppad,ibotpad,ithumbw,ithumbh,ifocus,icount,ipaintid,ilastpaintid:longint;
    idragarea:twinrect;
    idownxy:tpoint;
    iscroll:tbasicscrollbar;
    idragref,iref,iref2:string;
    itimer100:currency;
    procedure xincpaint;
    procedure _onalign(sender:tobject); override;
    procedure _onpos(sender:tobject);
    function getscrollpos:longint;
    procedure setscrollpos(x:longint);
    procedure xsetfocus(x:longint);
    procedure setcount(x:longint);
   public
    //options
    oalwaysallowmove:boolean;//default=false
    //create
    constructor create(xparent:tobject); virtual;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    procedure _ontimer(sender:tobject); override;
    function getalignheight(xclientwidth:longint):longint; override;
    procedure _onpaint(sender:tobject); override;
    function _onnotify(sender:tobject):boolean; override;
    //information
    property focus:longint read ifocus write xsetfocus;
    property count:longint read icount write setcount;
    property scrollpos:longint read getscrollpos write setscrollpos;
    function scrollmax:longint;
    property thumbw:longint read ithumbw;
    property thumbh:longint read ithumbh;
    procedure setthumbsize(w,h:longint);
    //keyboard support
    procedure xprev;
    procedure xnext;
    function xcanmove:boolean;
    function xmove(s,d:longint):boolean;
    //finders
    function findcell(mx:longint;var xindex:longint;xpastend:boolean):boolean;
    function findcell2(mx:longint;var xindex:longint;var xarea,xinnerarea:twinrect;xpastend:boolean):boolean;//09feb2022
    //workers
    function setparams(xscroll,xfocus,xcount:longint):boolean;
    function setparams2(xscroll,xfocus,xcount,xthumbW,xthumbH:longint):boolean;
    procedure xprevlocation;
    //external
    property onimage:tbasiccellsimageevent read fonimage write fonimage;
    property onmove:tbasiccellsmoveevent   read fonmove  write fonmove;
    //support

   end;

{tbasicsplash}
   tbasicsplash=class(tbasicscroll)
   private
    isize,igap:longint;
    ititle32:tbasicimage;
    iscreen:tbasiccontrol;
    ipreviousfocus:longint;
    itimeout:comp;
    ititleref:string;
    function onnotify__screen(sender:tobject):boolean;
    procedure onpaint__screen(sender:tobject);
    function xcontentarea:twinrect;
    procedure xmaketitle(dw,dh:longint);//13sep2025: lighter memory usage when "fontfeatherf>=1", 08apr2025: improved for short titles
   public
    constructor create(xparent:tobject); override;
    constructor create2(xparent:tobject;xstart:boolean); virtual;
    destructor destroy; override;
    //workers
    procedure xsplash;
    procedure xabout;
    function xmustclose:boolean;
   end;

{tbasictick}
   tbasictick=class(tbasiccontrol)
   private
    itimer250:currency;
    iref,icaption:string;
    ivalue:boolean;
    procedure setvalue(x:boolean);
    procedure xcheckref;
   public
    //create
    constructor create(xparent:tobject;xcaption:string); virtual;
    constructor create2(xparent:tobject;xstart:boolean;xcaption:string); virtual;
    destructor destroy; override;
    function getalignwidth(xclientheight:longint):longint; override;
    function getalignheight(xclientwidth:longint):longint; override;
    function xpaintcalc(xmustpaint:boolean):longint;
    //information
    property caption;
    property value:boolean read ivalue write setvalue;
    //events
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function  _onnotify(sender:tobject):boolean; override;
   end;

{tbasicedit}
   tbasicedit=class(tbasiccontrol)
   private
    iidleref,itimerslow,itimer250:currency;
    iundodata,ibuthelp,ibuthelp2,ivalue,iref,ititle:string;
    iundoref,itep,itep2,itep2b,iimgw,iimgh,iimgw2,iimgh2:longint;
    ibutarea1,ibutarea2:twinrect;
    iscale,iprogress:single;
    iundodataOK,idropstatic,ireveal,iflash:boolean;
    fonreturn,fonshowpass,fonchange,fonclick2,fonclick1:tnotifyevent;
    procedure settep(x:longint);
    procedure settep2(x:longint);
    procedure settep2b(x:longint);
    procedure setvalue(x:string);
    procedure setprogress(x:single);
    procedure xcheckref;
    function xshowcursor:boolean;
    procedure xnotidle;
    procedure settitle(x:string);
    function xundoautofill(xref:longint):boolean;//pass-thru proc
    procedure xundofill;
    procedure xfindsync;
    procedure setscale(x:single);
   public

    //options
    olimit:longint;//0=no limit, 1..max32=limit content to this length
    oreadonly:boolean;
    opassword:boolean;//default=false, true=PASSWORD mode and thus option to hide chars and display a mask char "#"
    oborder2:boolean;//default=false, true=draw border around tep2
    omoreoptions:boolean;//default=true=full right click menu of options, false=brief right click menu - 31mar2021
    osysfind_textsync:boolean;//default=false, true=mirror text to "sysfind_text" - 18feb2023
    ohardleft:boolean;//default=false, true=text stops at left margin and shoots off the right side -> for drop lists - 27jul2024
    odel_clearstext:boolean;//default=false, true=pressing the delete key will clear all text - 09mar2025
    orightbut_narrowfocus:boolean;//default=false=dropdown list right button animates when button OR text area is clicked, true=right button animates only when button itself is clicked - 09mar2025
    ocmd2:string;//default=nil, set to an internal command e.g. "edit.visit" and when 2nd button (right) is click this command will fire - 19apr2025
    oshowborder:boolean;//default=true, 24may2025

    //create
    constructor create(xparent:tobject;xcaption:string); virtual;
    constructor create2(xparent:tobject;xstart:boolean;xcaption:string); virtual;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;
    procedure showmenuFill(xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string); override;
    function showmenuClick(sender:tobject;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean; override;
    function xtitleheight:longint;
    //information
    property caption;
    property title:string read ititle write settitle;
    property value:string read ivalue write setvalue;
    property progress:single read iprogress write setprogress;
    property tep:longint read itep write settep;//left
    property tep2:longint read itep2 write settep2;//right
    property tep2b:longint read itep2b write settep2b;//right
    property buthelp:string read ibuthelp write ibuthelp;
    property buthelp2:string read ibuthelp2 write ibuthelp2;
    property reveal:boolean read ireveal write ireveal;//for password mode only - 13apr2020
    property showpass:boolean read ireveal write ireveal;//18jun2022
    property scale:single read iscale write setscale;//09mar2025
    //.undo - 19jun2022
    function canundo:boolean;
    function undo:boolean;
    function undoclear:boolean;
    //.password support
    function canclearpassword:boolean;
    function clearpassword:boolean;
    function canpastepassword:boolean;
    function pastepassword:boolean;
    //.visit
    function canvisit(var xurl:string):boolean;
    //makers
    procedure makefind;
    procedure makeedit;
    procedure makepass;
    procedure makedrop;
    procedure makedropstatic;
    procedure makeprogress;
    //events
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;
    function  _onshortcut(sender:tobject):boolean; override;//01mar2022
    function  _onnotify(sender:tobject):boolean; override;
    property  onclick2:tnotifyevent read fonclick2 write fonclick2;//tep #2 - right
    property  onclick1:tnotifyevent read fonclick1 write fonclick1;//tep #1 - left
    property onreturn:tnotifyevent read fonreturn write fonreturn;//09mar2025
    property onchange:tnotifyevent read fonchange write fonchange;
    property onshowpass:tnotifyevent read fonshowpass write fonshowpass;
    //support
    procedure xchanged;
    procedure xshowpass;
   end;


{tbasicjump}
   tbasicjump=class(tbasiccontrol)
   private
    ipainttimer,inewref,itimer250,ihoveref:comp;
    ispeed,ilastmousex,ilasthoverpos,ihoverpos,ipos,ilen,istatus:longint;
    iref:boolean;
    iflashval9,iflashval,ipower,ihoverpert,ipert:double;//06mar2022
    ipaintref:string;
    fonclick:tnotifyevent;
    procedure xsyncpos;//20feb2022
    procedure setstatus(x:longint);
    procedure setflashval(x:double);
    procedure setflashval9(x:double);
    procedure setpower(x:double);
   public

    olarge   :boolean;//default=false
    oms      :boolean;

    //create
    constructor create(xparent:tobject;xcaption:string); virtual;
    constructor create2(xparent:tobject;xstart:boolean;xcaption:string); virtual;
    destructor destroy; override;
    function getalignheight(xclientwidth:longint):longint; override;

    //information
    procedure setparams(xpos,xlen,xspeed:longint);//in milliseconds (xpos,xlen) and speed(10-1000%)
    property hoverpos:longint read ihoverpos;
    property hoverpert:double read ihoverpert;//0..100
    property pert:double read ipert;//0..100
    property pos:longint read ipos;
    property len:longint read ilen;
    property speed:longint read ispeed;
    property status:longint read istatus write setstatus;//0=off(default), 1=elapsed time, 2=remaining time
    procedure moveby(x:longint);
    procedure jumpto(x:longint);
    property flashval:double read iflashval write setflashval;//0..1
    property flashval9:double read iflashval9 write setflashval9;//0..1
    property power:double read ipower write setpower;//0..1

    //events
    procedure _ontimer(sender:tobject); override;
    procedure _onpaint(sender:tobject); override;//24oct2025: optimised coloring viewing for dark and light color schemes, 16sep2025: improved color variation for light backgrounds, 13sep2025, 05sep2025, 21aug2025
    function  _onnotify(sender:tobject):boolean; override;
    property  onclick:tnotifyevent read fonclick write fonclick;

   end;

{tmainhelp}
   tmainhelp=class(tbasicscroll)
   private
    ifasttimer:comp;
    ibwp:tbasicbwp;
    itopics:tdynamicstring;//list of help topics
    ibuildingcontrol:boolean;
    procedure __onclick(sender:tobject);
    procedure xhelptopics;//24apr2025
    procedure _ontimer(sender:tobject); override;
    procedure showmenuFill(xstyle:string;xmenudata:tstr8;var ximagealign:longint;var xmenuname:string); override;
    function showmenuClick(sender:tobject;xstyle:string;xcode:longint;xcode2:string;xtepcolor:longint):boolean; override;
   public
    //create
    constructor create2(xparent:tobject;xscroll,xstart:boolean); override;
    destructor destroy; override;
    //info
    procedure xsetroundstyle(x:longint);
   end;

{tplaylist}
   tplaylist=class(tobjectex)
   private
    ilistcoreUNDO,ilistcoreFULL,ilistcore:tstr8;
    ilistcoreCANUNDO:boolean;
    ifilenameOPEN,ifilenameSAVE,ipartmask,ifullmask:string;
    ilist:tbasicmenu;
    iopenfilter,ilistcoreUNDO_itemindex,ilistcoreid:longint;
    procedure setlist(x:tbasicmenu);
    function xcopy(xall,xcut:boolean;var e:string):boolean;
    function xpaste(xclear:boolean;var e:string):boolean;
    function xundo(var e:string):boolean;
    procedure setpartmask(x:string);
    procedure setfullmask(x:string);
   public
    //create
    constructor create; override;//20mar2022
    destructor destroy; override;//20mar2022
    //internal support
    function xguiOK:boolean;
    function xgui:tbasicsystem;
    function xlistitem(sender:tobject;xindex:longint;var xtab:string;var xtep,xtepcolor:longint;var xcaption,xcaplabel,xhelp,xcode2:string;var xcode,xshortcut,xindent:longint;var xflash,xenabled,xtitle,xsep,xbold:boolean):boolean;
    procedure xfillundo;
    procedure xmask(xforce:boolean);
    procedure xlistsync;
    //information
    property id:longint read ilistcoreid;
    function listok:boolean;
    property list:tbasicmenu read ilist write setlist;//pointer only -> use to automaticaly sync with a list control - 20mar2022
    property partmask:string read ipartmask write setpartmask;//used to filter from ilistcoreFULL to ilistcore (e.g. only "*.mid")
    property fullmask:string read ifullmask write setfullmask;//used to filter paste/open to ilistcoreFULL (e.g. *.rmi;*.mid;*.midi)
    //new -> prompt to clear
    function cannew:boolean;
    function new(var e:string):boolean;
    //clear
    function canclear:boolean;
    function clear(var e:string):boolean;
    //cut
    function cancut:boolean;
    function cut(var e:string):boolean;
    //copy
    function cancopy:boolean;
    function copy(var e:string):boolean;
    //copy all
    function cancopyall:boolean;
    function copyall(var e:string):boolean;
    //paste
    function canpaste:boolean;
    function paste(var e:string):boolean;
    //replace - 19apr2022
    function canreplace:boolean;
    function replace(var e:string):boolean;
    //open
    function canopen:boolean;
    function open(var e:string):boolean;
    //save
    function cansave:boolean;
    function save(var e:string):boolean;
    //undo
    function canundo:boolean;
    function undo(var e:string):boolean;
    //file
    function canaddfile:boolean;
    function addfile(const xfilename:string;var e:string):boolean;
    //command handler
    function xcmd(n:string;var e:string):boolean;
    //open support
    function xopen(var e:string):boolean;
    function xopen2(xfilename:string;xindex:longint;xprompt,afillundo:boolean;var e:string):boolean;
    //save support
    function xsave(var e:string):boolean;
    function xsave2(dfilename:string;xprompt:boolean;var e:string):boolean;
    //add support
    function xadd(xdata:tstr8;xindex:longint;xauthoritativeFilename:string;xclear:boolean):boolean;
    function xaddone(xsec:longint;xtitle,xfilename:string):boolean;
   end;


const
//system images (?w x ?h) ------------------------------------------------------
//Note: Each can be of varying width and height in the TEA image format
//Special Note: black pixels (0,0,0) are automatically replaced with system font color when rendered on the screen
tep_on          :array[0..288] of byte=(84,69,65,49,35,21,0,0,0,15,0,0,0,255,0,0,13,64,138,213,7,255,0,0,13,64,138,213,9,255,0,0,12,64,138,213,3,255,251,146,3,64,138,213,3,255,0,0,1,64,138,213,13,255,251,146,1,64,138,213,3,255,251,146,1,64,138,213,3,255,251,146,11,64,138,213,2,255,251,146,1,64,138,213,3,255,251,146,1,64,138,213,3,255,251,146,11,64,138,213,2,255,251,146,1,64,138,213,3,255,251,146,1,64,138,213,3,255,251,146,11,64,138,213,3,255,251,146,3,64,138,213,4,255,251,146,11,64,138,213,10,255,251,146,11,64,138,213,2,255,251,146,2,64,138,213,2,255,251,146,1,64,138,213,3,255,251,146,11,64,138,213,2,255,251,146,2,64,138,213,2,255,251,146,1,64,138,213,3,255,251,146,11,64,138,213,2,255,251,146,1,64,138,213,1,255,251,146,1,64,138,213,1,255,251,146,1,64,138,213,2,255,0,0,1,64,138,213,13,255,251,146,1,64,138,213,2,255,251,146,2,64,138,213,2,255,0,0,12,64,138,213,2,255,251,146,1,64,138,213,2,255,251,146,2,64,138,213,2,255,0,0,12,64,138,213,9,255,0,0,13,64,138,213,7,255,0,0,1);
tep_off         :array[0..96] of byte=(84,69,65,49,35,21,0,0,0,15,0,0,0,255,0,0,64,64,138,213,19,255,0,0,1,64,138,213,9,255,251,146,11,64,138,213,10,255,251,146,11,64,138,213,10,255,251,146,11,64,138,213,10,255,251,146,11,64,138,213,10,255,251,146,11,64,138,213,10,255,251,146,11,64,138,213,10,255,251,146,11,64,138,213,1,255,0,0,1,64,138,213,19,255,0,0,64);
tep_up          :array[0..48] of byte=(84,69,65,49,35,10,0,0,0,4,0,0,0,255,255,255,4,0,0,0,2,255,255,255,7,0,0,0,4,255,255,255,5,0,0,0,6,255,255,255,3,0,0,0,8,255,255,255,1);
tep_down        :array[0..48] of byte=(84,69,65,49,35,10,0,0,0,4,0,0,0,255,255,255,1,0,0,0,8,255,255,255,3,0,0,0,6,255,255,255,5,0,0,0,4,255,255,255,7,0,0,0,2,255,255,255,4);
tep_left        :array[0..64] of byte=(84,69,65,49,35,4,0,0,0,10,0,0,0,255,255,255,7,0,0,0,1,255,255,255,2,0,0,0,2,255,255,255,1,0,0,0,11,255,255,255,1,0,0,0,3,255,255,255,2,0,0,0,2,255,255,255,3,0,0,0,1,255,255,255,4);
tep_right       :array[0..64] of byte=(84,69,65,49,35,4,0,0,0,10,0,0,0,255,255,255,4,0,0,0,1,255,255,255,3,0,0,0,2,255,255,255,2,0,0,0,3,255,255,255,1,0,0,0,11,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,1,255,255,255,7);

tep_clo
:array[0..351] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,12,0,0,0,0,0,0,13,0,0,0,0,1,220,0,0,0,1,69,0,0,0,6,0,0,0,0,1,69,0,0,0,1,219,0,0,0,2,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,4,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,3,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,2,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,5,0,0,0,0,1,69,0,0,0,1,231,0,0,0,2,69,0,0,0,1,231,0,0,0,1,69,0,0,0,7,0,0,0,0,1,69,0,0,0,2,231,0,0,0,1,69,0,0,0,8,0,0,0,0,1,69,0,0,0,2,231,0,0,0,1,69,0,0,0,7,0,0,0,0,1,69,0,0,0,1,231,0,0,0,2,69,0,0,0,1,231,0,0,0,1,69,0,0,0,5,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,2,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,3,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,4,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,2,0,0,0,0,1,219,0,0,0,1,69,0,0,0,6,0,0,0,0,1,69,0,0,0,1,220,0,0,0,13,0);

tep_min
:array[0..41] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,12,0,0,0,0,0,0,73,0,0,0,0,10,255,0,0,0,61,0);

tep_nor
:array[0..371] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,12,0,0,0,0,0,0,15,0,0,0,0,1,154,0,0,0,4,255,0,0,0,1,247,0,0,0,1,159,0,0,0,1,16,0,0,0,4,0,0,0,0,1,21,0,0,0,4,22,0,0,0,1,45,0,0,0,1,193,0,0,0,1,159,0,0,0,2,0,0,0,0,1,150,0,0,0,1,253,0,0,0,4,255,0,0,0,1,253,0,0,0,1,150,0,0,0,1,45,0,0,0,1,247,0,0,0,2,0,0,0,0,1,253,0,0,0,1,48,0,0,0,4,22,0,0,0,1,41,0,0,0,1,253,0,0,0,1,22,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,22,0,0,0,5,0,0,0,0,1,255,0,0,0,1,22,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,22,0,0,0,5,0,0,0,0,1,255,0,0,0,1,22,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,22,0,0,0,5,0,0,0,0,1,255,0,0,0,1,22,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,22,0,0,0,5,0,0,0,0,1,255,0,0,0,1,21,0,0,0,1,152,0,0,0,2,0,0,0,0,1,253,0,0,0,1,41,0,0,0,4,0,0,0,0,1,32,0,0,0,1,253,0,0,0,4,0,0,0,0,1,150,0,0,0,1,253,0,0,0,4,255,0,0,0,1,253,0,0,0,1,150,0,0,0,15,0);

tep_max
:array[0..251] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,20,0,0,0,0,0,0,61,0,0,0,0,1,37,0,0,0,8,255,0,0,0,1,37,0,0,0,2,0,0,0,0,1,255,0,0,0,1,37,0,0,0,6,0,0,0,0,1,37,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,37,0,0,0,6,0,0,0,0,1,37,0,0,0,1,255,0,0,0,2,0,0,0,0,1,37,0,0,0,8,255,0,0,0,1,37,0,0,0,61,0);

tep_full
:array[0..251] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,20,0,0,0,0,0,0,66,0,0,0,0,5,255,0,0,0,9,0,0,0,0,1,37,0,0,0,2,255,0,0,0,8,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,255,0,0,0,7,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,6,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,7,0,0,0,0,1,255,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,8,0,0,0,0,2,255,0,0,0,1,37,0,0,0,9,0,0,0,0,5,255,0,0,0,66,0);

tep_fullexit
:array[0..241] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,64,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,37,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,9,0,0,0,0,1,255,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,10,0,0,0,0,2,255,0,0,0,1,37,0,0,0,11,0,0,0,0,5,255,0,0,0,30,0,0,0,0,5,255,0,0,0,11,0,0,0,0,1,37,0,0,0,2,255,0,0,0,10,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,255,0,0,0,9,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,1,37,0,0,0,2,0,0,0,0,1,255,0,0,0,64,0);


tep_inf         :array[0..64] of byte=(84,69,65,49,35,14,0,0,0,14,0,0,0,255,0,0,86,0,0,0,2,255,0,0,2,0,0,0,2,255,0,0,2,0,0,0,2,255,0,0,4,0,0,0,2,255,0,0,2,0,0,0,2,255,0,0,2,0,0,0,2,255,0,0,86);
tep_helphint    :array[0..312] of byte=(84,69,65,49,35,18,0,0,0,16,0,0,0,192,192,192,20,132,132,0,10,192,192,192,7,132,132,0,2,255,255,128,8,132,132,0,2,192,192,192,6,132,132,0,1,255,255,128,3,132,132,0,3,255,255,128,4,132,132,0,2,192,192,192,5,132,132,0,1,255,255,128,2,132,132,0,5,255,255,128,3,132,132,0,3,192,192,192,4,132,132,0,1,255,255,128,2,132,132,0,2,255,255,128,2,132,132,0,2,255,255,128,2,132,132,0,4,192,192,192,3,132,132,0,1,255,255,128,2,132,132,0,1,255,255,128,3,132,132,0,2,255,255,128,2,132,132,0,5,192,192,192,2,132,132,0,1,255,255,128,5,132,132,0,3,255,255,128,2,132,132,0,5,192,192,192,2,132,132,0,1,255,255,128,4,132,132,0,3,255,255,128,3,132,132,0,5,192,192,192,2,132,132,0,1,255,255,128,4,132,132,0,2,255,255,128,4,132,132,0,5,192,192,192,2,132,132,0,1,255,255,128,10,132,132,0,4,192,192,192,3,132,132,0,1,255,255,128,4,132,132,0,2,255,255,128,4,132,132,0,3,192,192,192,4,132,132,0,1,255,255,128,4,132,132,0,2,255,255,128,4,132,132,0,
                                        2,192,192,192,5,132,132,0,2,255,255,128,8,132,132,0,2,192,192,192,7,132,132,0,10,192,192,192,24);

tep_bullet      :array[0..96] of byte=(84,69,65,49,35,8,0,0,0,12,0,0,0,255,255,255,34,128,159,191,4,255,255,255,3,128,159,191,2,255,255,0,2,128,159,191,2,255,255,255,2,128,159,191,1,255,255,0,4,128,159,191,1,255,255,255,2,128,159,191,1,255,255,0,4,128,159,191,1,255,255,255,2,128,159,191,2,255,255,0,2,128,159,191,2,255,255,255,3,128,159,191,4,255,255,255,18);
tep_sep         :array[0..312] of byte=(
                84,69,65,49,35,196,0,0,0,16,0,0,0,255,255,255,96,200,0,200,2,255,255,255,194,200,0,200,2,255,255,255,192,200,0,200,2,255,255,255,2,200,0,200,2,255,255,255,190,200,0,200,2,255,255,255,2,200,0,200,2,255,255,255,96,154,154,220,2,209,209,209,92,255,255,255,2,154,154,220,2,255,255,255,2,209,209,209,94,154,154,220,4,209,209,209,92,255,255,255,2,154,154,220,2,255,255,255,2,209,209,209,94,154,154,220,2,255,255,255,92,209,209,209,2,255,255,255,2,154,154,220,2,255,255,255,2,209,209,209,2,255,255,255,186,209,209,209,2,255,255,255,2,154,154,220,2,255,255,255,2,209,209,209,2,255,255,255,136,154,154,220,2,209,209,209,48,255,255,255,2,200,0,200,2,255,255,255,2,200,0,200,2,255,255,255,2,209,209,209,48,154,154,220,2,255,255,255,86,154,154,220,2,209,209,209,48,255,255,255,2,200,0,200,2,255,255,255,2,200,0,200,2,255,255,255,2,209,209,209,48,154,154,220,2,255,255,255,140,209,209,209,2,255,255,255,194,209,209,209,2,255,255,255,170,154,154,220,2,209,209,209,46,154,154,220,2,255,255,255,146,154,154,220,2,
                209,209,209,46,154,154,220,2,255,255,255,170,209,209,209,2,255,255,255,194,209,209,209,2,255,255,255,98);


//standard images (?w x 20h) ---------------------------------------------------
//Note: Each image must be 20h (20 pixels high) and of varying width in the TEA image format
tep_unknown20   :array[0..208] of byte=(84,69,65,49,35,13,0,0,0,15,0,0,0,255,0,0,15,255,251,146,9,255,0,0,3,255,251,146,3,64,138,213,4,255,251,146,4,255,0,0,2,255,251,146,2,64,138,213,6,255,251,146,3,255,0,0,2,255,251,146,1,64,138,213,2,255,251,146,4,64,138,213,2,255,251,146,2,255,0,0,2,255,251,146,7,64,138,213,2,255,251,146,2,255,0,0,2,255,251,146,6,64,138,213,3,255,251,146,2,255,0,0,2,255,251,146,5,64,138,213,3,255,251,146,3,255,0,0,2,255,251,146,4,64,138,213,3,255,251,146,4,255,0,0,2,255,251,146,4,64,138,213,2,255,251,146,5,255,0,0,2,255,251,146,11,255,0,0,2,255,251,146,4,64,138,213,2,255,251,146,5,255,0,0,2,255,251,146,4,64,138,213,2,255,251,146,5,255,0,0,3,255,251,146,9,255,0,0,15);
tep_new20       :array[0..152] of byte=(84,69,65,49,35,11,0,0,0,20,0,0,0,255,0,0,45,64,138,213,7,255,0,0,3,64,138,213,1,217,235,255,6,64,138,213,2,255,0,0,2,64,138,213,1,217,235,255,6,64,138,213,1,217,235,255,1,64,138,213,1,255,0,0,1,64,138,213,1,217,235,255,6,64,138,213,5,217,235,255,9,64,138,213,2,217,235,255,9,64,138,213,2,217,235,255,9,64,138,213,2,217,235,255,9,64,138,213,2,217,235,255,9,64,138,213,2,217,235,255,9,64,138,213,2,217,235,255,9,64,138,213,2,217,235,255,9,64,138,213,1,255,0,0,1,64,138,213,9,255,0,0,34);
tep_fnew20      :array[0..152] of byte=(84,69,65,49,35,11,0,0,0,20,0,0,0,255,0,0,45,0,0,0,7,255,0,0,3,0,0,0,1,255,0,0,6,0,0,0,2,255,0,0,2,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,1,0,0,0,1,255,0,0,1,0,0,0,1,255,0,0,6,0,0,0,5,255,0,0,9,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,9,0,0,0,1,255,0,0,1,0,0,0,9,255,0,0,34);
tep_home20      :array[0..296] of byte=(84,69,65,49,35,16,0,0,0,20,0,0,0,0,255,0,39,224,112,0,2,0,255,0,2,224,112,0,2,0,255,0,9,224,112,0,1,255,229,204,2,224,112,0,1,0,255,0,1,224,112,0,2,0,255,0,8,224,112,0,1,255,229,204,4,224,112,0,3,0,255,0,7,224,112,0,1,255,229,204,6,224,112,0,2,0,255,0,6,224,112,0,1,255,229,204,8,224,112,0,1,0,255,0,5,224,112,0,1,255,229,204,10,224,112,0,1,0,255,0,3,224,112,0,1,255,229,204,12,224,112,0,1,0,255,0,1,224,112,0,1,255,229,204,14,224,112,0,17,0,255,0,1,224,112,0,1,255,229,204,11,224,112,0,1,0,255,0,3,224,112,0,1,255,229,204,4,224,112,0,3,255,229,204,4,224,112,0,1,0,255,0,3,224,112,0,1,255,229,204,4,224,112,0,3,255,229,204,4,224,112,0,1,0,255,0,3,224,112,0,1,255,229,204,4,224,112,0,3,255,229,204,4,224,112,0,1,0,255,0,3,224,112,0,1,255,229,204,4,224,112,0,3,255,229,204,4,224,112,0,1,0,255,0,3,224,112,0,1,255,229,204,4,224,112,0,3,255,229,204,4,224,112,0,1,0,255,0,3,224,112,0,13,0,255,0,34);
tep_yes20       :array[0..128] of byte=(84,69,65,49,35,13,0,0,0,20,0,0,0,255,0,0,64,0,0,0,1,255,0,0,10,0,0,0,2,255,0,0,10,0,0,0,2,255,0,0,10,0,0,0,2,255,0,0,10,0,0,0,2,255,0,0,10,0,0,0,2,255,0,0,6,0,0,0,2,255,0,0,2,0,0,0,2,255,0,0,6,0,0,0,3,255,0,0,2,0,0,0,2,255,0,0,7,0,0,0,5,255,0,0,9,0,0,0,3,255,0,0,10,0,0,0,3,255,0,0,11,0,0,0,1,255,0,0,61);
tep_yesBLANK20  :array[0..20] of byte=(84,69,65,49,35,13,0,0,0,20,0,0,0,255,0,0,250,255,0,0,10);
tep_open20:array[0..308] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,0,0,54,20,157,11,3,255,0,0,11,20,157,11,1,255,0,0,3,20,157,11,1,255,0,0,1,20,157,11,1,255,0,0,13,20,157,11,2,255,0,0,1,160,130,35,3,255,0,0,8,20,157,11,3,160,130,35,1,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,7,255,0,0,4,160,130,35,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,160,130,35,1,255,0,0,4,160,130,35,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,1,255,0,0,4,160,130,35,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,11,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,1,223,193,104,9,160,130,35,2,255,255,255,1,255,254,149,1,160,130,35,1,223,193,104,9,160,130,35,1,255,0,0,1,160,130,35,1,255,254,149,1,160,130,35,1,223,193,104,9,160,130,35,1,255,0,0,2,160,130,35,2,223,193,104,9,160,130,35,1,255,0,0,4,160,130,35,10,255,0,0,64);
tep_save20:array[0..248] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,255,0,0,43,107,107,207,12,255,0,0,1,107,107,207,1,172,172,255,12,107,107,207,2,172,172,255,2,255,255,255,8,172,172,255,2,107,107,207,2,172,172,255,2,255,255,255,1,172,172,255,6,255,255,255,1,172,172,255,2,107,107,207,2,172,172,255,2,255,255,255,8,172,172,255,2,107,107,207,2,172,172,255,2,255,255,255,1,172,172,255,6,255,255,255,1,172,172,255,2,107,107,207,2,172,172,255,2,255,255,255,8,172,172,255,2,107,107,207,2,172,172,255,12,107,107,207,2,172,172,255,12,107,107,207,2,172,172,255,2,107,107,207,9,172,172,255,1,107,107,207,2,172,172,255,2,107,107,207,6,255,255,255,2,107,107,207,1,172,172,255,1,107,107,207,2,172,172,255,2,107,107,207,6,255,255,255,2,107,107,207,1,172,172,255,1,107,107,207,2,172,172,255,2,107,107,207,6,255,255,255,2,107,107,207,1,172,172,255,1,107,107,207,1,255,0,0,1,107,107,207,12,255,0,0,43);
tep_close20:array[0..152] of byte=(
84,69,65,49,35,11,0,0,0,20,0,0,0,0,255,0,55,255,0,0,2,0,255,0,7,255,0,0,5,0,255,0,5,255,0,0,3,0,255,0,1,255,0,0,3,0,255,0,3,255,0,0,3,0,255,0,3,255,0,0,3,0,255,0,1,255,0,0,3,0,255,0,5,255,0,0,5,0,255,0,7,255,0,0,3,0,255,0,7,255,0,0,5,0,255,0,5,255,0,0,3,0,255,0,1,255,0,0,3,0,255,0,3,255,0,0,3,0,255,0,3,255,0,0,3,0,255,0,1,255,0,0,3,0,255,0,5,255,0,0,5,0,255,0,7,255,0,0,2,0,255,0,44);
tep_closed20:array[0..152] of byte=(
84,69,65,49,35,11,0,0,0,20,0,0,0,255,0,0,55,0,0,0,2,255,0,0,7,0,0,0,5,255,0,0,5,0,0,0,3,255,0,0,1,0,0,0,3,255,0,0,3,0,0,0,3,255,0,0,3,0,0,0,3,255,0,0,1,0,0,0,3,255,0,0,5,0,0,0,5,255,0,0,7,0,0,0,3,255,0,0,7,0,0,0,5,255,0,0,5,0,0,0,3,255,0,0,1,0,0,0,3,255,0,0,3,0,0,0,3,255,0,0,3,0,0,0,3,255,0,0,1,0,0,0,3,255,0,0,5,0,0,0,5,255,0,0,7,0,0,0,2,255,0,0,44);
tep_upward20:array[0..136] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,0,0,127,0,0,0,1,255,0,0,13,0,0,0,3,255,0,0,11,0,0,0,2,255,0,0,1,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,3,0,0,0,2,255,0,0,7,0,0,0,2,255,0,0,5,0,0,0,2,255,0,0,5,0,0,0,2,255,0,0,7,0,0,0,2,255,0,0,3,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,1,0,0,0,2,255,0,0,11,0,0,0,3,255,0,0,13,0,0,0,1,255,0,0,45);
tep_downward20:array[0..136] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,0,0,120,0,0,0,1,255,0,0,13,0,0,0,3,255,0,0,11,0,0,0,2,255,0,0,1,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,3,0,0,0,2,255,0,0,7,0,0,0,2,255,0,0,5,0,0,0,2,255,0,0,5,0,0,0,2,255,0,0,7,0,0,0,2,255,0,0,3,0,0,0,2,255,0,0,9,0,0,0,2,255,0,0,1,0,0,0,2,255,0,0,11,0,0,0,3,255,0,0,13,0,0,0,1,255,0,0,52);
tep_hide20:array[0..224] of byte=(
84,69,65,49,35,13,0,0,0,20,0,0,0,255,255,255,46,0,128,255,1,255,255,255,11,0,128,255,1,255,255,0,1,0,128,255,1,255,255,255,9,0,128,255,1,255,255,0,2,0,128,255,1,255,255,255,8,0,128,255,1,255,255,0,3,0,128,255,1,255,255,255,7,0,128,255,1,255,255,0,4,0,128,255,4,255,255,255,3,0,128,255,1,255,255,0,8,0,128,255,1,255,255,255,2,0,128,255,1,255,255,0,9,0,128,255,1,255,255,255,2,0,128,255,1,255,255,0,9,0,128,255,1,255,255,255,3,0,128,255,1,255,255,0,8,0,128,255,1,255,255,255,4,0,128,255,1,255,255,0,4,0,128,255,4,255,255,255,5,0,128,255,1,255,255,0,3,0,128,255,1,255,255,255,9,0,128,255,1,255,255,0,2,0,128,255,1,255,255,255,10,0,128,255,1,255,255,0,1,0,128,255,1,255,255,255,11,0,128,255,1,255,255,255,44);
tep_back20:array[0..224] of byte=(
84,69,65,49,35,13,0,0,0,20,0,0,0,255,255,255,46,211,173,9,1,255,255,255,11,211,173,9,1,255,209,11,1,211,173,9,1,255,255,255,9,211,173,9,1,255,209,11,2,211,173,9,1,255,255,255,8,211,173,9,1,255,209,11,3,211,173,9,1,255,255,255,7,211,173,9,1,255,209,11,4,211,173,9,4,255,255,255,3,211,173,9,1,255,209,11,8,211,173,9,1,255,255,255,2,211,173,9,1,255,209,11,9,211,173,9,1,255,255,255,2,211,173,9,1,255,209,11,9,211,173,9,1,255,255,255,3,211,173,9,1,255,209,11,8,211,173,9,1,255,255,255,4,211,173,9,1,255,209,11,4,211,173,9,4,255,255,255,5,211,173,9,1,255,209,11,3,211,173,9,1,255,255,255,9,211,173,9,1,255,209,11,2,211,173,9,1,255,255,255,10,211,173,9,1,255,209,11,1,211,173,9,1,255,255,255,11,211,173,9,1,255,255,255,44);
tep_forw20:array[0..224] of byte=(
84,69,65,49,35,13,0,0,0,20,0,0,0,255,255,255,44,211,173,9,1,255,255,255,11,211,173,9,1,255,209,11,1,211,173,9,1,255,255,255,10,211,173,9,1,255,209,11,2,211,173,9,1,255,255,255,9,211,173,9,1,255,209,11,3,211,173,9,1,255,255,255,5,211,173,9,4,255,209,11,4,211,173,9,1,255,255,255,4,211,173,9,1,255,209,11,8,211,173,9,1,255,255,255,3,211,173,9,1,255,209,11,9,211,173,9,1,255,255,255,2,211,173,9,1,255,209,11,9,211,173,9,1,255,255,255,2,211,173,9,1,255,209,11,8,211,173,9,1,255,255,255,3,211,173,9,4,255,209,11,4,211,173,9,1,255,255,255,7,211,173,9,1,255,209,11,3,211,173,9,1,255,255,255,8,211,173,9,1,255,209,11,2,211,173,9,1,255,255,255,9,211,173,9,1,255,209,11,1,211,173,9,1,255,255,255,11,211,173,9,1,255,255,255,46);
tep_power20:array[0..224] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,0,255,64,46,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,6,255,209,11,5,0,255,64,1,255,209,11,5,0,255,64,6,255,209,11,5,0,255,64,1,255,209,11,5,0,255,64,6,255,209,11,5,0,255,64,1,255,209,11,5,0,255,64,6,255,209,11,5,0,255,64,1,255,209,11,5,0,255,64,6,255,209,11,5,0,255,64,1,255,209,11,10,0,255,64,1,255,209,11,5,0,255,64,1,255,209,11,10,0,255,64,1,255,209,11,5,0,255,64,1,255,209,11,10,0,255,64,1,255,209,11,5,0,255,64,1,255,209,11,10,0,255,64,1,255,209,11,5,0,255,64,1,255,209,11,5,0,255,64,17);
tep_refresh20:array[0..256] of byte=(
84,69,65,49,35,13,0,0,0,20,0,0,0,192,192,192,31,163,72,255,3,192,192,192,9,163,72,255,1,192,192,192,3,163,72,255,1,192,192,192,7,163,72,255,1,192,192,192,5,163,72,255,1,192,192,192,6,163,72,255,1,192,192,192,5,163,72,255,1,192,192,192,6,163,72,255,1,192,192,192,5,163,72,255,1,192,192,192,3,255,0,255,7,192,192,192,2,163,72,255,1,192,192,192,4,255,0,255,5,192,192,192,3,163,72,255,1,192,192,192,5,255,0,255,3,192,192,192,4,255,0,255,1,192,192,192,6,255,0,255,1,192,192,192,4,255,0,255,3,192,192,192,5,163,72,255,1,192,192,192,3,255,0,255,5,192,192,192,4,163,72,255,1,192,192,192,2,255,0,255,7,192,192,192,3,163,72,255,1,192,192,192,5,163,72,255,1,192,192,192,6,163,72,255,1,192,192,192,5,163,72,255,1,192,192,192,6,163,72,255,1,192,192,192,5,163,72,255,1,192,192,192,7,163,72,255,1,192,192,192,3,163,72,255,1,192,192,192,9,163,72,255,3,192,192,192,31);
tep_folder20:array[0..264] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,0,0,91,160,130,35,3,255,0,0,11,160,130,35,1,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,7,255,0,0,4,160,130,35,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,160,130,35,1,255,0,0,4,160,130,35,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,1,255,0,0,4,160,130,35,1,255,255,255,1,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,11,255,254,149,1,255,255,255,1,255,254,149,1,160,130,35,1,223,193,104,9,160,130,35,2,255,255,255,1,255,254,149,1,160,130,35,1,223,193,104,9,160,130,35,1,255,0,0,1,160,130,35,1,255,254,149,1,160,130,35,1,223,193,104,9,160,130,35,1,255,0,0,2,160,130,35,2,223,193,104,9,160,130,35,1,255,0,0,4,160,130,35,10,255,0,0,64);
tep_folderimage20:array[0..212] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,252,252,252,69,160,130,35,4,252,252,252,10,160,130,35,1,255,0,255,4,160,130,35,1,252,252,252,2,160,130,35,3,252,252,252,3,160,130,35,1,255,0,255,6,160,130,35,2,255,255,128,3,160,130,35,4,255,0,255,5,0,255,255,1,160,130,35,2,255,255,128,6,160,130,35,1,255,0,255,3,0,255,255,3,160,130,35,2,255,255,128,6,160,130,35,1,255,0,255,1,0,255,255,5,160,130,35,2,255,255,128,7,160,130,35,1,0,255,255,4,160,130,35,1,252,252,252,1,160,130,35,1,255,255,128,8,160,130,35,4,252,252,252,2,160,130,35,1,255,255,128,11,160,130,35,1,252,252,252,2,160,130,35,1,255,255,128,11,160,130,35,1,252,252,252,2,160,130,35,2,255,255,128,10,160,130,35,1,252,252,252,3,160,130,35,12,252,252,252,62);
tep_desktop20:array[0..824] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,0,255,0,34,180,220,250,1,65,135,206,2,0,255,0,8,172,192,192,1,65,135,206,4,180,220,250,2,131,197,248,1,68,172,247,1,131,197,248,3,94,99,107,1,0,255,0,3,172,192,192,1,65,135,206,3,131,197,248,2,180,220,250,1,131,197,248,1,68,172,247,2,131,197,248,1,180,220,250,1,232,247,253,1,65,135,206,1,131,197,248,2,94,99,107,1,0,255,0,2,65,135,206,1,180,220,250,1,68,172,247,2,65,135,206,1,255,255,247,10,65,135,206,1,68,172,247,1,94,99,107,1,0,255,0,2,48,98,172,1,131,197,248,1,68,172,247,1,65,135,206,1,255,255,247,3,232,247,253,1,180,220,250,1,68,172,247,2,131,197,248,2,68,172,247,1,255,255,247,2,131,197,248,1,54,68,111,1,0,255,0,2,48,98,172,1,131,197,248,1,68,172,247,2,255,255,247,2,68,172,247,1,131,197,248,2,255,255,247,1,232,247,253,2,180,220,250,1,68,172,247,1,255,255,247,3,54,68,111,1,135,107,109,1,0,255,0,1,48,98,172,1,131,197,248,1,180,220,250,1,255,255,247,3,68,172,247,1,255,255,247,2,232,247,253,3,180,220,250,1,68,172,247,1,251,251,226,1,65,135,206,1,48,98,172,1,49,54,
68,1,135,107,109,2,48,98,172,1,131,197,248,1,251,251,226,4,68,172,247,1,255,255,247,2,232,247,253,3,180,220,250,1,68,172,247,1,65,135,206,1,180,220,250,1,172,192,192,1,135,107,109,1,49,54,68,1,94,99,107,1,48,98,172,1,131,197,248,1,251,251,226,4,68,172,247,1,232,247,253,4,65,135,206,1,180,220,250,2,131,197,248,1,48,98,172,1,131,197,248,1,54,68,111,1,135,107,109,1,0,255,0,1,65,135,206,2,251,251,226,4,68,172,247,1,232,247,253,3,49,54,68,1,135,107,109,1,65,135,206,2,251,251,226,3,3,69,169,1,172,192,192,1,0,255,0,1,65,135,206,2,255,247,206,4,68,172,247,1,232,247,253,3,68,172,247,1,172,192,192,1,131,197,248,1,68,172,247,1,255,247,206,3,3,69,169,1,135,107,109,1,0,255,0,1,172,192,192,1,65,135,206,1,255,247,206,4,68,172,247,1,232,247,253,2,180,220,250,1,131,197,248,1,68,172,247,1,131,197,248,1,68,172,247,1,255,247,206,2,172,192,192,1,3,69,169,1,135,107,109,1,0,255,0,1,172,192,192,1,65,135,206,1,255,247,206,4,68,172,247,1,232,247,253,1,180,220,250,3,131,197,248,2,68,172,247,1,255,247,206,2,48,98,172,1,3,69,
169,1,135,107,109,1,0,255,0,1,172,192,192,1,48,98,172,1,255,247,206,4,68,172,247,1,180,220,250,3,131,197,248,2,172,192,192,2,255,247,206,1,3,69,169,3,135,107,109,1,0,255,0,2,48,98,172,1,65,135,206,1,255,247,206,4,172,192,192,1,255,247,206,5,172,192,192,1,65,135,206,1,3,69,169,2,54,68,111,1,172,192,192,1,0,255,0,2,3,69,169,2,65,135,206,1,255,247,206,6,172,192,192,1,65,135,206,1,3,69,169,3,54,68,111,1,94,99,107,1,135,107,109,1,0,255,0,3,3,69,169,4,65,135,206,2,3,69,169,2,54,68,111,1,94,99,107,2,135,107,109,1,172,192,192,1,0,255,0,7,3,69,169,6,54,68,111,1,94,99,107,1,135,107,109,1,0,255,0,11,172,192,192,1,94,99,107,2,172,192,192,1,0,255,0,15);
tep_startmenu20:array[0..232] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,0,255,0,59,129,129,129,5,0,255,0,5,129,129,129,6,254,255,255,4,129,129,129,1,0,255,0,2,129,129,129,3,254,255,255,2,129,129,129,1,254,255,255,7,129,129,129,3,254,255,255,5,129,129,129,1,254,255,255,7,129,129,129,2,254,255,255,6,129,129,129,1,254,255,255,7,129,129,129,2,254,255,255,6,129,129,129,1,254,255,255,7,129,129,129,2,254,255,255,6,129,129,129,1,254,255,255,7,129,129,129,18,254,255,255,6,129,129,129,1,254,255,255,7,129,129,129,2,254,255,255,6,129,129,129,1,254,255,255,7,129,129,129,2,254,255,255,6,129,129,129,1,254,255,255,7,129,129,129,2,254,255,255,6,129,129,129,1,254,255,255,7,129,129,129,3,254,255,255,5,129,129,129,1,254,255,255,7,129,129,129,1,0,255,0,2,129,129,129,6,254,255,255,7,129,129,129,1,0,255,0,8,129,129,129,8,0,255,0,32);
tep_programs20:array[0..624] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,132,255,255,32,195,142,38,4,132,255,255,10,195,142,38,1,255,255,255,4,195,142,38,1,132,255,255,8,195,142,38,1,255,255,255,1,244,230,168,2,248,222,123,1,244,230,168,1,255,255,255,1,181,127,24,2,160,129,61,1,181,127,24,3,132,255,255,2,195,142,38,1,244,230,168,1,248,222,123,2,244,230,168,1,248,222,123,1,244,230,168,1,255,255,255,5,181,127,24,1,132,255,255,2,195,142,38,1,248,222,123,2,195,142,38,7,181,127,24,4,132,255,255,1,195,142,38,1,248,222,123,1,194,155,102,1,16,107,173,5,0,90,165,1,16,107,173,2,57,115,181,2,96,137,102,1,86,86,74,1,195,142,38,1,248,222,123,1,160,129,61,1,101,167,194,1,107,181,231,1,123,181,222,3,107,181,231,1,123,181,222,2,132,189,222,1,140,189,231,1,181,206,222,1,86,86,74,1,195,142,38,1,248,222,123,1,160,129,61,1,198,206,206,1,107,145,16,1,96,137,102,1,239,239,222,1,248,222,123,1,160,129,61,1,223,225,219,1,239,239,222,1,198,167,172,1,101,167,194,1,239,239,222,1,160,129,61,1,195,142,38,1,248,222,123,1,160,129,61,1,198,206,206,1,107,145,16,1,194,
155,102,1,239,239,222,1,198,167,172,1,194,155,102,1,198,167,172,1,239,239,222,1,194,155,102,1,198,167,172,1,223,225,219,1,160,129,61,1,195,142,38,1,248,222,123,1,160,129,61,1,198,206,206,2,223,225,219,1,239,239,222,1,198,206,206,2,223,225,219,1,239,239,222,1,198,167,172,1,202,214,218,1,239,239,222,1,96,137,102,1,181,127,24,1,248,222,123,1,160,129,61,1,198,167,172,1,248,222,123,1,244,230,168,1,223,225,219,1,239,239,222,1,123,181,222,1,223,225,219,1,239,239,222,1,194,155,102,1,198,167,172,1,239,239,222,1,160,129,61,1,132,255,255,1,181,127,24,1,86,86,74,1,198,206,206,1,96,137,102,1,198,167,172,1,239,239,222,1,198,206,206,1,96,137,102,1,202,214,218,1,239,239,222,1,57,115,181,1,194,155,102,1,239,239,222,1,78,94,119,1,132,255,255,2,86,86,74,1,198,206,206,1,248,222,123,2,239,239,222,1,181,206,222,1,107,181,231,1,223,225,219,1,239,239,222,1,194,155,102,1,198,167,172,1,239,239,222,1,78,94,119,1,132,255,255,3,198,206,206,1,223,225,219,2,239,239,222,3,223,225,219,1,239,239,222,1,244,230,168,1,239,239,222,2,
78,94,119,1,132,255,255,3,78,94,119,1,41,65,94,2,33,57,82,6,33,49,82,2,132,255,255,46);
tep_color20:array[0..188] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,192,192,192,37,125,125,255,3,255,255,0,3,192,192,192,8,125,125,255,5,255,255,0,5,192,192,192,5,125,125,255,6,255,255,0,6,192,192,192,3,125,125,255,7,255,255,0,7,192,192,192,2,125,125,255,7,255,255,0,7,192,192,192,1,125,125,255,8,255,255,0,8,125,125,255,8,255,255,0,8,125,125,255,8,255,255,0,8,0,255,0,8,255,0,255,8,0,255,0,8,255,0,255,8,0,255,0,8,255,0,255,8,192,192,192,1,0,255,0,7,255,0,255,7,192,192,192,2,0,255,0,7,255,0,255,7,192,192,192,3,0,255,0,6,255,0,255,6,192,192,192,5,0,255,0,5,255,0,255,5,192,192,192,8,0,255,0,3,255,0,255,3,192,192,192,37);
tep_colors20:array[0..248] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,255,255,56,255,198,255,14,255,255,255,3,255,198,255,1,255,144,199,3,255,198,255,4,255,144,199,4,255,198,255,4,255,255,255,1,255,198,255,1,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,6,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,6,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,10,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,6,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,6,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,6,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,2,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,6,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,6,255,144,199,4,255,198,255,4,255,144,199,4,255,198,255,5,255,255,255,1,255,198,255,1,255,144,199,3,255,198,255,4,255,144,199,4,255,198,255,4,255,255,255,3,255,198,255,14,255,255,255,56);
tep_colormatrix20:array[0..152] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,255,255,56,255,144,199,14,255,255,255,3,255,144,199,1,223,148,255,14,255,144,199,1,255,255,255,1,255,144,199,1,217,138,255,16,255,144,199,2,210,128,255,16,255,144,199,2,204,118,255,16,255,144,199,2,197,108,255,16,255,144,199,2,191,98,255,16,255,144,199,2,185,89,255,16,255,144,199,2,178,79,255,16,255,144,199,2,172,69,255,16,255,144,199,2,166,59,255,16,255,144,199,2,159,49,255,16,255,144,199,1,255,255,255,1,255,144,199,1,153,39,255,14,255,144,199,1,255,255,255,3,255,144,199,14,255,255,255,56);
tep_colorpal20:array[0..168] of byte=(
84,69,65,49,35,40,0,0,0,20,0,0,0,255,255,255,82,0,0,1,36,255,255,255,3,0,0,1,1,0,0,0,36,0,0,1,1,255,255,255,1,0,0,1,1,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,2,0,0,0,38,0,0,1,1,255,255,255,1,0,0,1,1,0,0,0,36,0,0,1,1,255,255,255,3,0,0,1,36,255,255,255,82);
tep_colorpal20n:array[0..168] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,255,255,255,42,0,0,1,16,255,255,255,3,0,0,1,1,0,0,0,16,0,0,1,1,255,255,255,1,0,0,1,1,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,2,0,0,0,18,0,0,1,1,255,255,255,1,0,0,1,1,0,0,0,16,0,0,1,1,255,255,255,3,0,0,1,16,255,255,255,42);
tep_colorhistory20:array[0..440] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,255,255,56,255,198,255,14,255,255,255,3,255,198,255,1,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,1,255,255,255,1,255,198,255,1,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,
3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,3,255,144,199,3,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,255,255,1,255,198,255,1,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,1,255,255,255,3,255,198,255,14,255,255,255,56);
tep_schemes20:array[0..412] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,0,255,0,67,74,156,115,2,0,255,0,2,210,45,197,2,0,255,0,2,132,132,8,2,0,255,0,6,74,156,115,2,0,255,0,2,210,45,197,2,0,255,0,2,132,132,8,2,0,255,0,5,74,156,115,3,0,255,0,1,210,45,197,3,0,255,0,1,132,132,8,4,0,255,0,4,74,156,115,1,190,250,234,2,74,156,115,1,210,45,197,1,255,196,196,2,210,45,197,1,132,132,8,1,237,240,32,2,132,132,8,2,0,255,0,2,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,4,132,132,8,1,0,255,0,2,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,4,132,132,8,1,0,255,0,1,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,6,132,132,8,1,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,6,132,132,8,1,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,6,132,132,8,1,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,6,132,132,8,1,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,
240,32,6,132,132,8,1,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,6,132,132,8,1,0,255,0,1,74,156,115,1,190,250,234,3,210,45,197,1,255,196,196,3,132,132,8,1,237,240,32,4,132,132,8,1,0,255,0,3,74,156,115,4,210,45,197,4,132,132,8,4,0,255,0,34);
tep_font20:array[0..328] of byte=(
84,69,65,49,35,22,0,0,0,20,0,0,0,252,252,252,93,255,115,185,3,252,252,252,5,255,115,185,2,252,252,252,12,255,115,185,3,252,252,252,5,255,115,185,2,252,252,252,11,255,115,185,2,252,252,252,1,255,115,185,2,252,252,252,4,255,115,185,2,252,252,252,11,255,115,185,2,252,252,252,1,255,115,185,2,252,252,252,4,255,115,185,2,252,252,252,1,255,115,185,3,252,252,252,7,255,115,185,2,252,252,252,1,255,115,185,2,252,252,252,4,255,115,185,7,252,252,252,5,0,128,255,2,252,252,252,3,0,128,255,2,252,252,252,3,255,115,185,3,252,252,252,2,255,115,185,3,252,252,252,4,0,128,255,2,252,252,252,3,0,128,255,2,252,252,252,3,255,115,185,2,252,252,252,4,255,115,185,2,252,252,252,4,0,128,255,7,252,252,252,3,255,115,185,2,252,252,252,4,0,128,255,2,252,252,252,3,0,128,255,9,252,252,252,2,0,128,255,2,252,252,252,4,0,128,255,2,252,252,252,3,0,128,255,2,252,252,252,5,0,128,255,2,252,252,252,2,0,128,255,3,252,252,252,2,0,128,255,3,252,252,252,3,0,128,255,2,252,252,252,5,0,128,255,2,252,252,252,2,0,128,255,7,252,252,252,3,0,128,255,2,
252,252,252,7,0,128,255,2,252,252,252,1,0,128,255,2,252,252,252,1,0,128,255,3,252,252,252,91);
tep_cut20:array[0..232] of byte=(
84,69,65,49,35,9,0,0,0,20,0,0,0,192,192,192,29,255,128,0,1,192,192,192,3,255,128,0,1,192,192,192,4,255,128,0,1,192,192,192,3,255,128,0,1,192,192,192,4,255,128,0,1,192,192,192,3,255,128,0,1,192,192,192,4,255,128,0,2,192,192,192,1,255,128,0,2,192,192,192,5,255,128,0,1,192,192,192,1,255,128,0,1,192,192,192,6,255,128,0,3,192,192,192,7,255,128,0,1,192,192,192,7,255,128,0,3,192,192,192,6,128,0,255,1,192,192,192,1,128,0,255,3,192,192,192,2,128,0,255,3,192,192,192,1,128,0,255,1,192,192,192,2,128,0,255,2,192,192,192,2,128,0,255,1,192,192,192,1,128,0,255,1,192,192,192,2,128,0,255,2,192,192,192,2,128,0,255,1,192,192,192,1,128,0,255,1,192,192,192,2,128,0,255,2,192,192,192,2,128,0,255,1,192,192,192,2,128,0,255,2,192,192,192,2,128,0,255,2,192,192,192,33);
tep_github20:array[0..436] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,42,122,125,128,2,2,2,2,2,122,125,128,2,255,0,0,10,122,125,128,1,2,2,2,8,122,125,128,1,255,0,0,7,122,125,128,1,2,2,2,10,122,125,128,1,255,0,0,5,122,125,128,1,2,2,2,1,122,125,128,1,247,247,247,1,122,125,128,1,2,2,2,1,122,125,128,2,2,2,2,1,122,125,128,1,247,247,247,1,122,125,128,1,2,2,2,1,122,125,128,1,255,0,0,4,2,2,2,2,122,125,128,1,247,247,247,8,122,125,128,1,2,2,2,2,255,0,0,3,122,125,128,1,2,2,2,2,122,125,128,1,247,247,247,8,122,125,128,1,2,2,2,2,122,125,128,1,255,0,0,2,122,125,128,1,2,2,2,2,122,125,128,1,247,247,247,8,122,125,128,1,2,2,2,2,74,78,83,1,255,0,0,2,2,2,2,3,247,247,247,10,2,2,2,3,255,0,0,2,2,2,2,3,247,247,247,10,2,2,2,3,255,0,0,2,60,65,70,1,2,2,2,2,122,125,128,1,247,247,247,8,122,125,128,1,2,2,2,2,122,125,128,1,255,0,0,2,122,125,128,1,2,2,2,2,74,78,83,1,122,125,128,1,247,247,247,6,122,125,128,2,2,2,2,2,122,125,128,1,255,0,0,3,2,2,2,1,122,125,128,2,2,2,2,1,122,125,128,2,247,247,247,2,122,125,128,2,2,2,2,4,255,0,0,4,122,125,128,1,2,2,2,1,247,247,
247,1,122,125,128,3,247,247,247,2,122,125,128,1,2,2,2,4,122,125,128,1,255,0,0,5,2,2,2,2,247,247,247,6,2,2,2,3,122,125,128,1,255,0,0,7,122,125,128,1,2,2,2,2,247,247,247,4,2,2,2,2,122,125,128,1,255,0,0,10,122,125,128,1,247,247,247,4,122,125,128,1,255,0,0,42);
tep_sourceforge20:array[0..472] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,44,245,143,64,2,255,0,0,15,249,157,84,1,255,138,35,1,249,249,251,1,245,143,64,1,255,0,0,13,248,149,71,1,255,138,35,1,249,249,251,2,255,138,35,1,245,143,64,1,255,0,0,11,248,150,72,1,255,138,35,1,249,249,251,3,255,138,35,1,251,134,40,1,245,143,64,1,255,0,0,9,249,150,72,1,255,138,35,1,249,249,251,5,255,138,35,1,250,133,39,1,245,143,64,1,255,0,0,7,248,148,69,1,255,138,35,1,249,249,251,3,255,138,35,1,249,249,251,3,255,138,35,1,250,133,40,1,245,143,64,1,255,0,0,5,247,149,72,1,255,138,35,1,249,249,251,2,249,248,250,1,245,143,64,1,255,138,35,2,249,249,251,3,255,138,35,1,251,132,37,1,245,143,64,1,255,0,0,3,245,143,64,1,255,138,35,1,249,249,251,2,249,247,248,1,245,143,64,1,255,138,35,3,249,249,251,4,255,138,35,1,249,134,43,1,245,143,64,1,255,0,0,2,245,143,64,1,255,138,35,1,252,140,50,1,249,249,251,2,245,143,64,1,255,138,35,3,249,249,251,2,249,247,248,1,249,249,251,2,255,138,35,2,255,0,0,3,245,143,64,1,255,138,35,1,251,133,37,1,249,249,251,2,255,138,35,4,249,249,251,
3,255,138,35,2,245,143,64,1,255,0,0,4,245,143,64,1,255,138,35,1,251,133,37,1,249,249,251,2,255,138,35,2,249,249,251,3,255,138,35,2,245,143,64,1,255,0,0,6,245,143,64,1,255,138,35,1,251,132,37,1,249,249,251,5,255,138,35,2,245,143,64,1,255,0,0,8,245,143,64,1,255,138,35,1,255,133,33,1,249,249,251,3,255,138,35,2,245,143,64,1,255,0,0,10,245,143,64,1,255,138,35,1,249,249,251,2,255,138,35,2,245,143,64,1,255,0,0,12,245,143,64,1,249,249,251,1,255,138,35,2,245,143,64,1,255,0,0,14,245,143,64,3,255,0,0,43);
tep_instagram20:array[0..644] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,0,255,64,39,137,62,255,5,160,1,224,5,214,4,216,2,0,255,64,5,137,62,255,3,214,4,216,10,240,2,193,1,0,255,64,3,137,62,255,3,199,85,250,1,254,244,252,8,248,66,213,1,246,4,188,1,250,0,183,1,244,41,180,1,0,255,64,2,199,85,250,3,254,244,252,1,244,80,221,8,254,244,252,1,255,65,197,1,251,1,161,1,248,6,153,1,0,255,64,2,236,26,228,2,254,244,252,1,244,80,221,2,253,0,171,6,244,80,221,2,254,244,252,1,254,0,144,1,251,1,136,1,0,255,64,2,236,26,228,2,254,244,252,1,245,90,209,1,253,0,171,1,254,31,167,1,253,0,171,1,254,244,252,2,253,0,171,3,244,80,221,1,254,244,252,1,254,0,131,1,253,1,120,1,0,255,64,2,236,26,228,2,254,244,252,1,253,62,29,1,253,0,171,2,254,244,252,1,253,53,156,1,253,47,162,1,254,244,252,1,253,0,171,1,254,0,130,1,244,80,221,1,254,244,252,1,254,1,117,1,253,0,105,1,0,255,64,2,253,32,127,1,251,44,121,1,254,244,252,1,253,62,29,2,254,244,252,1,253,64,133,1,252,19,117,1,252,11,126,1,253,59,156,1,254,244,252,1,254,0,130,1,244,80,221,1,254,244,252,1,255,2,106,1,252,0,98,1,0,
255,64,2,254,108,17,2,254,244,252,1,253,62,29,2,254,244,252,1,253,83,116,1,252,37,92,1,252,27,101,1,253,70,137,1,254,244,252,1,254,0,130,1,244,80,221,1,254,244,252,1,254,3,99,1,251,0,96,1,0,255,64,2,254,108,17,2,254,244,252,1,253,62,29,2,253,0,171,1,254,244,252,1,253,94,110,1,253,90,121,1,254,244,252,1,253,0,171,1,254,0,130,1,244,80,221,1,254,244,252,1,253,2,95,1,251,0,101,1,0,255,64,2,254,108,17,2,254,244,252,1,253,62,29,3,253,0,171,1,254,244,252,2,253,0,171,1,253,62,29,1,254,0,130,1,244,80,221,1,254,244,252,1,252,8,96,1,251,1,112,1,0,255,64,2,254,108,17,2,254,244,252,1,253,62,29,8,254,0,130,1,253,21,93,1,254,244,252,1,251,7,88,1,252,7,128,1,0,255,64,2,254,108,17,2,255,201,48,1,254,244,252,1,253,62,29,1,255,201,48,5,253,21,93,2,254,244,252,1,253,21,93,2,253,20,139,1,0,255,64,2,254,108,17,2,255,201,48,2,254,244,252,8,253,21,93,2,255,44,106,1,254,67,157,1,0,255,64,3,254,108,17,1,255,201,48,7,254,108,17,3,253,85,31,1,255,75,63,1,254,56,98,1,0,255,64,5,255,201,48,9,254,108,17,2,255,114,93,1,0,255,64,
39);
tep_facebook20:array[0..240] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,42,14,138,240,6,255,0,0,10,14,138,240,10,255,0,0,7,14,138,240,12,255,0,0,5,14,138,240,7,252,252,252,3,14,138,240,4,255,0,0,4,14,138,240,6,252,252,252,4,14,138,240,4,255,0,0,3,14,138,240,7,252,252,252,2,14,138,240,7,255,0,0,2,14,138,240,7,252,252,252,2,14,138,240,7,255,0,0,2,14,138,240,7,252,252,252,2,14,138,240,7,255,0,0,2,14,138,240,5,252,252,252,6,14,138,240,5,255,0,0,2,14,138,240,5,252,252,252,6,14,138,240,5,255,0,0,2,14,138,240,7,252,252,252,2,14,138,240,7,255,0,0,3,14,138,240,6,252,252,252,2,14,138,240,6,255,0,0,4,14,138,240,6,252,252,252,2,14,138,240,6,255,0,0,5,14,138,240,5,252,252,252,2,14,138,240,5,255,0,0,7,14,138,240,4,252,252,252,2,14,138,240,4,255,0,0,10,14,138,240,6,255,0,0,42);
tep_mastodon20:array[0..444] of byte=(
84,69,65,49,35,19,0,0,0,20,0,0,0,255,0,0,4,96,91,244,11,255,0,0,6,96,91,244,15,255,0,0,4,96,91,244,16,255,0,0,2,96,91,244,5,204,201,247,1,96,91,244,5,204,201,247,1,96,91,244,10,204,201,247,1,254,254,254,3,204,201,247,1,96,91,244,1,204,201,247,1,254,254,254,3,204,201,247,1,96,91,244,8,254,254,254,5,204,201,247,1,254,254,254,5,96,91,244,7,204,201,247,1,254,254,254,2,96,91,244,2,254,254,254,3,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,6,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,6,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,6,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,6,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,2,204,201,247,
3,96,91,244,2,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,6,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,7,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,6,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,7,204,201,247,1,254,254,254,1,204,201,247,1,96,91,244,21,255,0,0,1,96,91,244,17,255,0,0,3,96,91,244,14,255,0,0,5,96,91,244,5,255,0,0,14,96,91,244,6,255,0,0,14,96,91,244,11,255,0,0,10,96,91,244,9,255,0,0,6);
tep_twitter20:array[0..424] of byte=(
84,69,65,49,35,19,0,0,0,20,0,0,0,255,0,0,20,2,2,2,17,255,0,0,2,2,2,2,17,255,0,0,2,2,2,2,17,255,0,0,2,2,2,2,1,252,252,252,4,2,2,2,9,252,252,252,1,2,2,2,2,255,0,0,2,2,2,2,2,252,252,252,1,2,2,2,2,252,252,252,1,2,2,2,7,252,252,252,1,2,2,2,3,255,0,0,2,2,2,2,3,252,252,252,1,2,2,2,2,252,252,252,1,2,2,2,5,252,252,252,1,2,2,2,4,255,0,0,2,2,2,2,3,252,252,252,1,2,2,2,3,252,252,252,1,2,2,2,3,252,252,252,1,2,2,2,5,255,0,0,2,2,2,2,4,252,252,252,1,2,2,2,3,252,252,252,1,2,2,2,1,252,252,252,1,2,2,2,6,255,0,0,2,2,2,2,5,252,252,252,1,2,2,2,3,252,252,252,1,2,2,2,7,255,0,0,2,2,2,2,6,252,252,252,1,2,2,2,2,252,252,252,1,2,2,2,7,255,0,0,2,2,2,2,7,252,252,252,2,2,2,2,1,252,252,252,1,2,2,2,6,255,0,0,2,2,2,2,7,252,252,252,2,2,2,2,2,252,252,252,1,2,2,2,5,255,0,0,2,2,2,2,6,252,252,252,1,2,2,2,2,252,252,252,1,2,2,2,2,252,252,252,1,2,2,2,4,255,0,0,2,2,2,2,5,252,252,252,1,2,2,2,4,252,252,252,1,2,2,2,2,252,252,252,1,2,2,2,3,255,0,0,2,2,2,2,4,252,252,252,1,2,2,2,6,252,252,252,1,2,2,2,2,252,252,252,1,2,2,2,2,255,0,0,2,2,2,2,3,252,
252,252,1,2,2,2,8,252,252,252,4,2,2,2,1,255,0,0,2,2,2,2,17,255,0,0,2,2,2,2,17,255,0,0,20);
tep_capture20:array[0..222] of byte=(
84,69,65,50,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,255,0,0,67,0,128,255,6,255,0,0,13,0,128,255,8,255,0,0,12,0,128,255,8,255,0,0,8,0,128,255,16,255,0,0,3,0,128,255,18,255,0,0,2,0,128,255,7,112,183,255,4,0,128,255,7,255,0,0,2,0,128,255,6,112,183,255,1,255,0,0,4,112,183,255,1,0,128,255,6,255,0,0,2,112,183,255,6,255,0,0,6,112,183,255,6,255,0,0,2,112,183,255,6,255,0,0,6,112,183,255,6,255,0,0,2,112,183,255,6,255,0,0,6,112,183,255,6,255,0,0,2,0,128,255,6,112,183,255,1,255,0,0,4,112,183,255,1,0,128,255,6,255,0,0,2,0,128,255,7,112,183,255,4,0,128,255,7,255,0,0,2,0,128,255,18,255,0,0,2,0,128,255,18,255,0,0,3,0,128,255,16,255,0,0,42);
tep_mute20:array[0..304] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,255,255,62,0,0,0,2,255,255,255,15,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,14,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,13,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,9,0,0,0,4,255,255,255,4,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,4,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,3,0,0,0,2,255,255,255,4,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,3,0,0,0,2,255,255,255,4,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,3,0,0,0,4,255,255,255,4,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,4,0,0,0,1,255,255,255,6,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,14,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,15,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,16,0,0,0,2,255,255,255,62);
tep_unmute20:array[0..352] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,255,255,62,0,0,0,2,255,255,255,15,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,10,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,4,0,0,0,1,255,255,255,8,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,9,0,0,0,4,255,255,255,4,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,3,0,0,0,4,255,255,255,4,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,7,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,14,0,0,0,1,255,255,255,2,0,0,0,1,255,255,255,4,0,0,0,1,255,255,255,10,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,3,0,0,0,1,255,255,255,12,0,0,0,2,255,255,255,62);
tep_bulletsquare20:array[0..80] of byte=(
84,69,65,49,35,10,0,0,0,20,0,0,0,255,255,255,62,0,0,0,6,255,255,255,4,0,0,0,6,255,255,255,4,0,0,0,6,255,255,255,4,0,0,0,6,255,255,255,4,0,0,0,6,255,255,255,4,0,0,0,6,255,255,255,4,0,0,0,6,255,255,255,4,0,0,0,6,255,255,255,62);

mtep_rotate20//note: 7th byte (1base, 1..7) = syscolors = fontcolor for black pixels, set to 1 for on and 0 for off - 09may2025
:array[0..566] of byte=(
84,69,65,51,35,1,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,41,0,0,0,0,1,63,0,0,0,1,140,0,0,0,1,200,0,0,0,2,229,0,0,0,1,200,0,0,0,1,140,0,0,0,1,63,0,0,0,8,0,0,0,0,1,28,0,0,0,1,169,0,0,0,1,200,0,0,0,1,87,0,0,0,1,41,0,0,0,2,0,0,0,0,1,41,0,0,0,1,87,0,0,0,1,200,0,0,0,1,169,0,0,0,1,28,0,0,0,5,0,0,0,0,1,28,0,0,0,1,184,0,0,0,1,113,0,0,0,8,0,0,0,0,1,113,0,0,0,1,184,0,0,0,1,28,0,0,0,4,0,0,0,0,1,169,0,0,0,1,113,0,0,0,10,0,0,0,0,1,113,0,0,0,1,169,0,0,0,3,0,0,0,0,1,63,0,0,0,1,200,0,0,0,12,0,0,0,0,1,200,0,0,0,1,63,0,0,0,2,0,0,0,0,1,140,0,0,0,1,87,0,0,0,12,0,0,0,0,1,87,0,0,0,1,140,0,0,0,2,0,0,0,0,1,200,0,0,0,1,41,0,0,0,4,0,0,0,0,1,87,0,0,0,2,215,0,0,0,1,87,0,0,0,4,0,0,0,0,1,41,0,0,0,1,200,0,0,0,2,0,0,0,0,1,229,0,0,0,5,0,0,0,0,1,215,0,0,0,2,52,0,0,0,1,215,0,0,0,5,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,87,0,0,0,5,0,0,0,0,1,215,0,0,0,2,52,0,0,0,1,215,0,0,0,5,0,0,0,0,1,229,0,0,0,8,0,0,0,0,1,87,0,0,0,2,215,0,0,0,1,87,0,0,0,4,0,0,0,0,1,41,0,0,0,1,200,0,0,0,16,0,0,0,0,1,87,0,0,0,1,140,0,0,0,12,0,
0,0,0,1,200,0,0,0,3,0,0,0,0,1,200,0,0,0,1,63,0,0,0,12,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,125,0,0,0,1,169,0,0,0,13,0,0,0,0,1,229,0,0,0,1,28,0,0,0,1,140,0,0,0,1,184,0,0,0,1,28,0,0,0,13,0,0,0,0,1,229,0,0,0,1,215,0,0,0,1,140,0,0,0,1,28,0,0,0,14,0,0,0,0,1,215,0,0,0,3,229,0,0,0,1,200,0,0,0,38,0);

mtep_rotateleft20
:array[0..566] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,41,0,0,0,0,1,63,0,0,0,1,140,0,0,0,1,200,0,0,0,2,229,0,0,0,1,200,0,0,0,1,140,0,0,0,1,63,0,0,0,8,0,0,0,0,1,28,0,0,0,1,169,0,0,0,1,200,0,0,0,1,87,0,0,0,1,41,0,0,0,2,0,0,0,0,1,41,0,0,0,1,87,0,0,0,1,200,0,0,0,1,169,0,0,0,1,28,0,0,0,5,0,0,0,0,1,28,0,0,0,1,184,0,0,0,1,113,0,0,0,8,0,0,0,0,1,113,0,0,0,1,184,0,0,0,1,28,0,0,0,4,0,0,0,0,1,169,0,0,0,1,113,0,0,0,10,0,0,0,0,1,113,0,0,0,1,169,0,0,0,3,0,0,0,0,1,63,0,0,0,1,200,0,0,0,12,0,0,0,0,1,200,0,0,0,1,63,0,0,0,2,0,0,0,0,1,140,0,0,0,1,87,0,0,0,12,0,0,0,0,1,87,0,0,0,1,140,0,0,0,2,0,0,0,0,1,200,0,0,0,1,41,0,0,0,4,0,0,0,0,1,87,0,0,0,2,215,0,0,0,1,87,0,0,0,4,0,0,0,0,1,41,0,0,0,1,200,0,0,0,2,0,0,0,0,1,229,0,0,0,5,0,0,0,0,1,215,0,0,0,2,52,0,0,0,1,215,0,0,0,5,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,229,0,0,0,5,0,0,0,0,1,215,0,0,0,2,52,0,0,0,1,215,0,0,0,5,0,0,0,0,1,87,0,0,0,2,0,0,0,0,1,200,0,0,0,1,41,0,0,0,4,0,0,0,0,1,87,0,0,0,2,215,0,0,0,1,87,0,0,0,8,0,0,0,0,1,140,0,0,0,1,87,0,0,0,16,0,0,
0,0,1,63,0,0,0,1,200,0,0,0,3,0,0,0,0,1,200,0,0,0,13,0,0,0,0,1,169,0,0,0,1,125,0,0,0,2,0,0,0,0,1,229,0,0,0,13,0,0,0,0,1,28,0,0,0,1,184,0,0,0,1,140,0,0,0,1,28,0,0,0,1,229,0,0,0,14,0,0,0,0,1,28,0,0,0,1,140,0,0,0,1,215,0,0,0,1,229,0,0,0,13,0,0,0,0,1,200,0,0,0,3,229,0,0,0,1,215,0,0,0,47,0);

mtep_mirror20
:array[0..311] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,22,0,0,0,20,0,0,0,0,0,0,82,0,0,0,0,1,43,0,0,0,1,65,0,0,0,20,0,0,0,0,1,56,0,0,0,1,183,0,0,0,1,78,0,0,0,4,0,0,0,0,1,24,0,0,0,1,115,0,0,0,14,128,0,0,0,1,159,0,0,0,1,198,0,0,0,1,84,0,0,0,3,0,0,0,0,1,24,0,0,0,1,115,0,0,0,14,128,0,0,0,1,155,0,0,0,1,203,0,0,0,1,102,0,0,0,18,0,0,0,0,1,43,0,0,0,1,175,0,0,0,1,100,0,0,0,19,0,0,0,0,1,55,0,0,0,1,88,0,0,0,52,0,0,0,0,1,88,0,0,0,1,55,0,0,0,19,0,0,0,0,1,100,0,0,0,1,175,0,0,0,1,43,0,0,0,18,0,0,0,0,1,100,0,0,0,1,203,0,0,0,1,155,0,0,0,14,128,0,0,0,1,115,0,0,0,1,24,0,0,0,3,0,0,0,0,1,87,0,0,0,1,198,0,0,0,1,159,0,0,0,14,128,0,0,0,1,115,0,0,0,1,24,0,0,0,4,0,0,0,0,1,78,0,0,0,1,183,0,0,0,1,56,0,0,0,20,0,0,0,0,1,65,0,0,0,1,43,0,0,0,82,0);

mtep_flip20
:array[0..541] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,12,0,0,0,0,2,24,0,0,0,8,0,0,0,0,1,87,0,0,0,1,100,0,0,0,6,0,0,0,0,2,115,0,0,0,7,0,0,0,0,1,78,0,0,0,1,198,0,0,0,1,203,0,0,0,1,100,0,0,0,5,0,0,0,0,2,128,0,0,0,6,0,0,0,0,1,65,0,0,0,1,183,0,0,0,1,159,0,0,0,1,155,0,0,0,1,175,0,0,0,1,88,0,0,0,4,0,0,0,0,2,128,0,0,0,6,0,0,0,0,1,43,0,0,0,1,56,0,0,0,2,128,0,0,0,1,43,0,0,0,1,55,0,0,0,4,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,6,0,0,0,0,2,128,0,0,0,8,0,0,0,0,2,128,0,0,0,4,0,0,0,0,1,55,0,0,0,1,43,0,0,0,2,128,0,0,0,1,56,0,0,0,1,43,0,0,0,6,0,0,0,0,2,128,0,0,0,4,0,0,0,0,1,88,0,0,0,1,175,
0,0,0,1,155,0,0,0,1,159,0,0,0,1,183,0,0,0,1,65,0,0,0,6,0,0,0,0,2,128,0,0,0,5,0,0,0,0,1,100,0,0,0,1,203,0,0,0,1,198,0,0,0,1,78,0,0,0,7,0,0,0,0,2,115,0,0,0,6,0,0,0,0,1,102,0,0,0,1,84,0,0,0,8,0,0,0,0,2,24,0,0,0,12,0);

mtep_save20
:array[0..556] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,49,0,0,0,0,1,100,0,0,0,1,239,0,0,0,8,255,0,0,0,1,223,0,0,0,1,62,0,0,0,4,0,0,0,0,1,239,0,0,0,1,62,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,63,0,0,0,1,223,0,0,0,1,62,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,62,0,0,0,1,222,0,0,0,1,62,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,61,0,0,0,1,223,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,126,0,0,0,5,255,0,0,0,1,128,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,125,0,0,0,8,255,0,0,0,1,128,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,
2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,239,0,0,0,1,63,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,1,61,0,0,0,1,239,0,0,0,2,0,0,0,0,1,98,0,0,0,1,239,0,0,0,10,255,0,0,0,1,239,0,0,0,1,99,0,0,0,49,0);

mtep_saveas20
:array[0..671] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,35,0,0,0,0,1,99,0,0,0,1,216,0,0,0,6,255,0,0,0,1,254,0,0,0,1,255,0,0,0,1,243,0,0,0,1,163,0,0,0,5,0,0,0,0,1,216,0,0,0,1,81,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,181,0,0,0,1,187,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,254,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,192,0,0,0,1,147,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,248,0,0,0,5,0,0,0,0,1,248,0,0,0,3,0,0,0,0,1,241,0,0,0,3,0,0,0,0,1,254,0,0,0,2,0,0,0,0,1,147,0,0,0,3,255,0,0,0,2,254,0,0,0,1,140,0,0,0,3,0,0,0,0,1,254,0,0,0,3,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,73,0,0,0,1,200,0,0,0,1,216,0,0,0,1,60,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,146,0,0,0,1,254,0,0,0,1,255,0,0,0,1,254,0,0,0,3,255,0,0,0,1,124,0,0,0,1,71,0,0,0,1,244,0,0,0,2,254,0,0,0,1,200,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,251,0,0,0,6,0,0,0,0,1,67,0,0,0,1,242,0,0,0,3,255,0,0,0,1,205,0,0,0,2,0,0,0,0,1,254,0,0,0,1,0,0,0,0,1,254,0,0,0,5,0,0,0,0,1,62,0,0,0,1,238,0,0,
0,3,254,0,0,0,1,244,0,0,0,1,74,0,0,0,2,0,0,0,0,1,254,0,0,0,1,0,0,0,0,1,254,0,0,0,4,0,0,0,0,1,55,0,0,0,1,235,0,0,0,1,255,0,0,0,2,254,0,0,0,1,243,0,0,0,1,70,0,0,0,3,0,0,0,0,1,254,0,0,0,1,0,0,0,0,1,254,0,0,0,4,0,0,0,0,1,233,0,0,0,3,254,0,0,0,1,243,0,0,0,1,70,0,0,0,4,0,0,0,0,1,226,0,0,0,1,78,0,0,0,1,254,0,0,0,3,0,0,0,0,1,156,0,0,0,2,254,0,0,0,1,255,0,0,0,1,241,0,0,0,1,68,0,0,0,5,0,0,0,0,1,92,0,0,0,1,219,0,0,0,3,254,0,0,0,1,0,0,0,0,1,220,0,0,0,2,254,0,0,0,1,238,0,0,0,1,66,0,0,0,12,0,0,0,0,1,231,0,0,0,1,224,0,0,0,1,145,0,0,0,58,0);

mtep_favadd20
:array[0..731] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,20,0,0,0,0,0,0,27,0,0,0,0,1,124,0,0,0,1,121,0,0,0,16,0,0,0,0,1,62,0,0,0,2,222,0,0,0,1,63,0,0,0,15,0,0,0,0,1,180,0,0,0,1,113,0,0,0,1,114,0,0,0,1,178,0,0,0,14,0,0,0,0,1,64,0,0,0,1,232,0,0,0,2,0,0,0,0,1,233,0,0,0,1,63,0,0,0,12,0,0,0,0,1,57,0,0,0,1,191,0,0,0,1,120,0,0,0,2,0,0,0,0,1,123,0,0,0,1,190,0,0,0,8,0,0,0,0,1,93,0,0,0,1,166,0,0,0,1,204,0,0,0,1,246,0,0,0,1,231,0,0,0,1,168,0,0,0,4,0,0,0,0,1,168,0,0,0,1,231,0,0,0,1,246,0,0,0,1,203,0,0,0,1,166,0,0,0,1,91,0,0,0,3,0,0,0,0,1,241,0,0,0,1,149,0,0,0,1,77,0,0,0,10,0,0,0,0,1,78,0,0,0,1,157,0,0,0,1,237,0,0,0,3,0,0,0,0,1,119,0,0,0,1,230,0,0,0,1,57,0,0,0,11,0,0,0,0,1,106,0,0,0,1,116,0,0,0,4,0,0,0,0,1,113,0,0,0,1,233,0,0,0,1,63,0,0,0,6,0,0,0,0,1,151,0,0,0,1,222,0,0,0,1,247,0,0,0,1,222,0,0,0,1,148,0,0,0,6,0,0,0,0,1,107,0,0,0,1,236,0,0,0,5,0,0,0,0,1,211,0,0,0,5,255,0,0,0,1,206,0,0,0,6,0,0,0,0,1,173,0,0,0,1,106,0,0,0,3,0,0,0,0,1,140,0,0,0,3,255,0,0,0,1,65,0,0,0,2,255,0,0,0,1,254,0,0,0,1,135,
0,0,0,5,0,0,0,0,1,208,0,0,0,1,71,0,0,0,3,0,0,0,0,1,214,0,0,0,1,255,0,0,0,2,254,0,0,0,1,0,0,0,0,2,254,0,0,0,1,255,0,0,0,1,209,0,0,0,5,0,0,0,0,1,245,0,0,0,4,0,0,0,0,1,245,0,0,0,1,254,0,0,0,5,0,0,0,0,1,254,0,0,0,1,242,0,0,0,5,0,0,0,0,1,225,0,0,0,1,0,0,0,0,1,68,0,0,0,1,191,0,0,0,1,0,0,0,0,1,213,0,0,0,3,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,254,0,0,0,1,255,0,0,0,1,209,0,0,0,4,0,0,0,0,1,88,0,0,0,1,213,0,0,0,1,181,0,0,0,1,214,0,0,0,1,99,0,0,0,1,0,0,0,0,1,140,0,0,0,3,254,0,0,0,1,0,0,0,0,3,254,0,0,0,1,132,0,0,0,5,0,0,0,0,1,179,0,0,0,1,99,0,0,0,4,0,0,0,0,1,210,0,0,0,2,254,0,0,0,2,255,0,0,0,1,254,0,0,0,1,208,0,0,0,13,0,0,0,0,1,150,0,0,0,1,223,0,0,0,1,247,0,0,0,1,222,0,0,0,1,149,0,0,0,41,0);

mtep_favedit20
:array[0..651] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,20,0,0,0,0,0,0,27,0,0,0,0,2,128,0,0,0,16,0,0,0,0,1,64,0,0,0,2,230,0,0,0,1,64,0,0,0,15,0,0,0,0,1,186,0,0,0,2,117,0,0,0,1,186,0,0,0,14,0,0,0,0,1,66,0,0,0,1,240,0,0,0,2,0,0,0,0,1,240,0,0,0,1,66,0,0,0,12,0,0,0,0,1,59,0,0,0,1,198,0,0,0,1,125,0,0,0,2,0,0,0,0,1,125,0,0,0,1,198,0,0,0,1,59,0,0,0,7,0,0,0,0,1,96,0,0,0,1,172,0,0,0,1,212,0,0,0,1,255,0,0,0,1,239,0,0,0,1,174,0,0,0,4,0,0,0,0,1,174,0,0,0,1,239,0,0,0,1,255,0,0,0,1,212,0,0,0,1,172,0,0,0,1,96,0,0,0,3,0,0,0,0,1,249,0,0,0,1,154,0,0,0,1,80,0,0,0,10,0,0,0,0,1,80,0,0,0,1,154,0,0,0,1,249,0,0,0,3,0,0,0,0,1,123,0,0,0,1,238,0,0,0,1,59,0,0,0,10,0,0,0,0,1,59,0,0,0,1,238,0,0,0,1,123,0,0,0,4,0,0,0,0,1,117,0,0,0,1,241,0,0,0,1,65,0,0,0,4,0,0,0,0,1,59,0,0,0,7,238,0,0,0,1,59,0,0,0,4,0,0,0,0,1,111,0,0,0,1,245,0,0,0,4,0,0,0,0,1,238,0,0,0,7,0,0,0,0,1,238,0,0,0,5,0,0,0,0,1,180,0,0,0,1,110,0,0,0,3,0,0,0,0,1,238,0,0,0,1,0,0,0,0,5,238,0,0,0,1,0,0,0,0,1,238,0,0,0,5,0,0,0,0,1,215,0,0,0,1,73,0,0,0,3,0,0,
0,0,1,238,0,0,0,7,0,0,0,0,1,238,0,0,0,5,0,0,0,0,1,254,0,0,0,4,0,0,0,0,1,238,0,0,0,1,0,0,0,0,5,238,0,0,0,1,0,0,0,0,1,238,0,0,0,5,0,0,0,0,1,233,0,0,0,1,0,0,0,0,1,71,0,0,0,2,198,0,0,0,1,238,0,0,0,7,0,0,0,0,1,238,0,0,0,4,0,0,0,0,1,91,0,0,0,1,221,0,0,0,1,188,0,0,0,1,222,0,0,0,1,103,0,0,0,1,0,0,0,0,1,238,0,0,0,1,0,0,0,0,5,238,0,0,0,1,0,0,0,0,1,238,0,0,0,5,0,0,0,0,1,185,0,0,0,1,103,0,0,0,3,0,0,0,0,1,238,0,0,0,7,0,0,0,0,1,238,0,0,0,10,0,0,0,0,1,59,0,0,0,7,238,0,0,0,1,59,0,0,0,39,0);

mtep_capture20
:array[0..631] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,46,0,0,0,0,1,107,0,0,0,6,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,11,0,0,0,0,1,107,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,1,107,0,0,0,7,0,0,0,0,1,107,0,0,0,3,255,0,0,0,1,107,0,0,0,6,0,0,0,0,1,107,0,0,0,3,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,
0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,14,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,14,255,0,0,0,1,107,0,0,0,62,0);

mtep_vol20
:array[0..561] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,20,0,0,0,0,0,0,28,0,0,0,0,1,101,0,0,0,7,0,0,0,0,1,50,0,0,0,1,47,0,0,0,1,106,0,0,0,6,0,0,0,0,1,51,0,0,0,1,92,0,0,0,1,47,0,0,0,1,102,0,0,0,5,0,0,0,0,1,47,0,0,0,1,100,0,0,0,1,75,0,0,0,1,44,0,0,0,1,98,0,0,0,2,0,0,0,0,1,98,0,0,0,1,134,0,0,0,1,219,0,0,0,1,109,0,0,0,1,80,0,0,0,1,60,0,0,0,1,39,0,0,0,1,90,0,0,0,2,0,0,0,0,1,128,0,0,0,1,134,0,0,0,1,219,0,0,0,1,92,0,0,0,1,61,0,0,0,1,46,0,0,0,1,37,0,0,0,1,96,0,0,0,2,0,0,0,0,1,122,0,0,0,1,118,0,0,0,1,211,0,0,0,1,80,0,0,0,1,57,0,0,0,1,56,0,0,0,1,47,0,0,0,1,108,0,0,0,2,0,0,0,0,1,58,0,0,0,1,62,0,0,0,1,211,0,0,0,1,95,0,0,0,2,80,0,0,0,1,65,0,0,0,1,121,0,0,0,2,0,0,0,0,1,128,0,0,0,1,123,0,0,0,1,225,0,0,0,1,121,0,0,0,1,107,0,0,0,1,108,0,0,0,1,86,0,0,0,1,132,0,0,0,2,0,0,0,0,1,184,0,0,0,1,177,0,0,0,1,239,0,0,0,1,151,0,0,0,1,136,0,0,0,1,132,0,0,0,1,95,0,0,0,1,133,0,0,0,2,0,0,0,0,1,193,0,0,0,1,179,0,0,0,1,246,0,0,0,1,175,0,0,0,1,151,0,0,0,1,138,0,0,0,1,97,0,0,0,1,137,0,0,0,2,0,0,0,0,1,159,0,0,0,1,198,
0,0,0,1,255,0,0,0,1,182,0,0,0,1,158,0,0,0,1,142,0,0,0,1,98,0,0,0,1,136,0,0,0,5,0,0,0,0,1,109,0,0,0,1,165,0,0,0,1,147,0,0,0,1,98,0,0,0,1,138,0,0,0,6,0,0,0,0,1,103,0,0,0,1,154,0,0,0,1,100,0,0,0,1,137,0,0,0,7,0,0,0,0,1,100,0,0,0,1,103,0,0,0,1,137,0,0,0,8,0,0,0,0,1,70,0,0,0,1,133,0,0,0,21,0);

mtep_top20
:array[0..371] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,22,0,0,0,0,1,107,0,0,0,14,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,16,255,0,0,0,1,107,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,107,0,0,0,2,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,14,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,14,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,14,255,0,0,0,1,107,0,0,0,42,0);

mtep_right20
:array[0..451] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,23,0,0,0,0,1,107,0,0,0,13,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,5,0,0,0,0,1,107,0,0,0,7,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,255,0,0,0,1,107,0,0,0,7,0,0,0,0,1,107,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,7,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,107,0,0,0,7,0,0,0,0,1,107,0,0,0,7,255,0,0,0,3,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,5,0,0,0,0,1,107,0,0,0,7,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,13,255,
0,0,0,1,107,0,0,0,22,0);

mtep_bottom20
:array[0..371] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,42,0,0,0,0,1,107,0,0,0,14,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,14,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,16,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,14,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,107,0,0,0,2,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,18,255,0,0,0,2,0,0,0,0,1,107,0,0,0,16,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,14,255,0,0,0,1,107,0,0,0,22,0);

mtep_left20
:array[0..451] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,22,0,0,0,0,1,107,0,0,0,13,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,7,255,0,0,0,1,107,0,0,0,5,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,3,0,0,0,0,7,255,0,0,0,1,107,0,0,0,7,0,0,0,0,1,107,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,7,255,0,0,0,1,107,0,0,0,7,0,0,0,0,1,107,0,0,0,1,255,0,0,0,3,0,0,0,0,1,107,0,0,0,7,255,0,0,0,1,107,0,0,0,5,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,107,0,0,0,13,255,
0,0,0,1,107,0,0,0,23,0);

mtep_invert20
:array[0..391] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,20,0,0,0,0,0,0,36,0,0,0,0,1,80,0,0,0,6,211,0,0,0,1,80,0,0,0,7,0,0,0,0,1,211,0,0,0,6,255,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,255,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,255,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,255,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,255,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,255,0,0,0,1,211,0,0,0,6,0,0,0,0,1,80,0,0,0,1,211,0,0,0,2,255,0,0,0,4,211,0,0,0,1,80,0,0,0,2,0,0,0,0,1,80,0,0,0,4,211,0,0,0,1,80,0,0,0,1,94,0,0,0,1,211,0,0,0,1,80,0,0,0,6,0,0,0,0,1,211,0,0,0,1,80,0,0,0,5,94,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,94,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,94,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,94,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,6,94,0,0,0,1,211,0,0,0,7,0,0,0,0,1,211,0,0,0,1,80,0,0,0,4,94,0,0,0,1,80,0,0,0,1,211,0,0,0,7,0,0,0,0,1,80,0,0,0,6,211,0,0,0,1,80,0,0,0,36,0);

mtep_go20
:array[0..611] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,51,0,0,0,0,1,91,0,0,0,1,238,0,0,0,8,255,0,0,0,1,238,0,0,0,1,91,0,0,0,4,0,0,0,0,1,238,0,0,0,1,50,0,0,0,8,0,0,0,0,1,50,0,0,0,1,238,0,0,0,2,0,0,0,0,1,91,0,0,0,1,238,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,238,0,0,0,1,50,0,0,0,1,255,0,0,0,3,0,0,0,0,1,221,0,0,0,3,255,0,0,0,1,238,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,50,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,50,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,50,0,0,0,2,0,0,0,0,1,221,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,205,0,0,0,1,50,0,0,0,6,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,
255,0,0,0,1,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,238,0,0,0,1,50,0,0,0,8,0,0,0,0,1,50,0,0,0,1,238,0,0,0,2,0,0,0,0,1,238,0,0,0,1,0,0,0,0,1,91,0,0,0,1,238,0,0,0,8,255,0,0,0,1,238,0,0,0,1,91,0,0,0,2,0,0,0,0,1,135,0,0,0,1,152,0,0,0,8,0,0,0,0,1,50,0,0,0,1,238,0,0,0,5,0,0,0,0,1,135,0,0,0,1,238,0,0,0,7,255,0,0,0,1,238,0,0,0,1,91,0,0,0,51,0);

mtep_upper20
:array[0..426] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,20,0,0,0,0,0,0,63,0,0,0,0,1,139,0,0,0,4,255,0,0,0,1,205,0,0,0,1,23,0,0,0,10,0,0,0,0,1,38,0,0,0,1,218,0,0,0,1,99,0,0,0,1,218,0,0,0,1,68,0,0,0,10,0,0,0,0,1,96,0,0,0,1,205,0,0,0,1,23,0,0,0,1,179,0,0,0,1,139,0,0,0,10,0,0,0,0,1,179,0,0,0,1,139,0,0,0,1,0,0,0,0,1,96,0,0,0,1,205,0,0,0,1,23,0,0,0,8,0,0,0,0,1,38,0,0,0,1,218,0,0,0,1,68,0,0,0,1,0,0,0,0,1,38,0,0,0,1,218,0,0,0,1,68,0,0,0,8,0,0,0,0,1,96,0,0,0,1,205,0,0,0,1,23,0,0,0,2,0,0,0,0,1,179,0,0,0,1,139,0,0,0,7,0,0,0,0,1,23,0,0,0,1,205,0,0,0,1,96,0,0,0,3,0,0,0,0,1,96,0,0,0,1,205,0,0,0,1,23,0,0,0,6,0,0,0,0,1,68,0,0,0,1,243,0,0,0,5,255,0,0,0,1,243,0,0,0,1,68,0,0,0,6,0,0,0,0,1,139,0,0,0,1,179,0,0,0,5,0,0,0,0,1,179,0,0,0,1,139,0,0,0,5,0,0,0,0,1,23,0,0,0,1,205,0,0,0,1,96,0,0,0,5,0,0,0,0,1,96,0,0,0,1,205,0,0,0,1,23,0,0,0,3,0,0,0,0,1,68,0,0,0,1,243,0,0,0,2,255,0,0,0,1,243,0,0,0,1,68,0,0,0,1,0,0,0,0,1,38,0,0,0,1,230,0,0,0,2,255,0,0,0,1,243,0,0,0,1,68,0,0,0,76,0);

mtep_lower20
:array[0..271] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,20,0,0,0,0,0,0,62,0,0,0,0,1,139,0,0,0,3,255,0,0,0,1,243,0,0,0,1,68,0,0,0,10,0,0,0,0,1,38,0,0,0,1,230,0,0,0,1,96,0,0,0,10,0,0,0,0,1,96,0,0,0,1,179,0,0,0,10,0,0,0,0,1,96,0,0,0,1,179,0,0,0,5,0,0,0,0,1,68,0,0,0,1,243,0,0,0,4,255,0,0,0,1,179,0,0,0,4,0,0,0,0,1,96,0,0,0,1,243,0,0,0,1,68,0,0,0,3,0,0,0,0,1,96,0,0,0,1,179,0,0,0,4,0,0,0,0,1,179,0,0,0,1,96,0,0,0,4,0,0,0,0,1,96,0,0,0,1,179,0,0,0,4,0,0,0,0,1,139,0,0,0,1,179,0,0,0,3,0,0,0,0,1,179,0,0,0,1,255,0,0,0,1,179,0,0,0,5,0,0,0,0,1,179,0,0,0,3,255,0,0,0,1,139,0,0,0,1,96,0,0,0,1,255,0,0,0,1,230,0,0,0,1,38,0,0,0,73,0);

mtep_name20//name case
:array[0..591] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,0,20,0,0,0,0,0,0,118,0,0,0,0,1,72,0,0,0,4,168,0,0,0,1,84,0,0,0,19,0,0,0,0,1,48,0,0,0,1,228,0,0,0,1,144,0,0,0,1,156,0,0,0,1,24,0,0,0,18,0,0,0,0,1,120,0,0,0,1,180,0,0,0,1,48,0,0,0,1,180,0,0,0,1,48,0,0,0,4,0,0,0,0,1,168,0,0,0,2,240,0,0,0,1,252,0,0,0,1,120,0,0,0,9,0,0,0,0,1,204,0,0,0,1,108,0,0,0,1,0,0,0,0,1,132,0,0,0,1,108,0,0,0,8,0,0,0,0,2,144,0,0,0,7,0,0,0,0,1,48,0,0,0,1,240,0,0,0,1,48,0,0,0,1,0,0,0,0,1,72,0,0,0,1,156,0,0,0,1,24,0,0,0,7,0,0,0,0,1,72,0,0,0,1,192,0,0,0,7,0,0,0,0,1,132,0,0,0,1,156,0,0,0,2,0,0,0,0,1,36,0,0,0,1,168,0,0,0,1,48,0,0,0,3,0,0,0,0,1,36,0,0,0,3,84,0,0,0,1,132,0,0,0,1,204,0,0,0,6,0,0,0,0,1,36,0,0,0,1,228,0,0,0,1,192,0,0,0,2,120,0,0,0,1,144,0,0,0,1,228,0,0,0,1,108,0,0,0,2,0,0,0,0,1,60,0,0,0,1,168,0,0,0,1,96,0,0,0,2,48,0,0,0,1,108,0,0,0,1,192,0,0,0,6,0,0,0,0,1,84,0,0,0,1,216,0,0,0,4,0,0,0,0,1,96,0,0,0,1,168,0,0,0,2,0,0,0,0,1,180,0,0,0,1,96,0,0,0,3,0,0,0,0,1,72,0,0,0,1,180,0,0,0,6,0,0,0,0,1,144,0,0,0,1,132,0,0,
0,4,0,0,0,0,1,48,0,0,0,1,180,0,0,0,1,48,0,0,0,1,0,0,0,0,1,168,0,0,0,1,132,0,0,0,2,0,0,0,0,1,72,0,0,0,1,255,0,0,0,1,228,0,0,0,4,0,0,0,0,1,24,0,0,0,1,156,0,0,0,2,240,0,0,0,1,216,0,0,0,1,60,0,0,0,1,0,0,0,0,1,96,0,0,0,2,240,0,0,0,1,228,0,0,0,1,84,0,0,0,1,0,0,0,0,1,192,0,0,0,2,240,0,0,0,1,180,0,0,0,1,96,0,0,0,1,216,0,0,0,1,204,0,0,0,1,36,0,0,0,116,0);

tep_list20
:array[0..304] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,56,0,127,254,2,255,0,0,4,0,127,254,8,255,0,0,3,0,127,254,1,127,254,254,2,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,8,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,2,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,8,0,127,254,1,255,0,0,3,0,127,254,2,255,0,0,4,0,127,254,8,255,0,0,22,0,127,254,2,255,0,0,4,0,127,254,8,255,0,0,3,0,127,254,1,127,254,254,2,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,8,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,2,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,8,0,127,254,1,255,0,0,3,0,127,254,2,255,0,0,4,0,127,254,8,255,0,0,22,0,127,254,2,255,0,0,4,0,127,254,8,255,0,0,3,0,127,254,1,127,254,254,2,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,8,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,2,0,127,254,1,255,0,0,2,0,127,254,1,127,254,254,8,0,127,254,1,255,0,0,3,0,127,254,2,255,0,0,4,0,127,254,8,255,0,0,56);

mtep_list20
:array[0..111] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,91,0,0,0,0,1,212,0,0,0,14,255,0,0,0,1,183,0,0,0,38,0,0,0,0,1,212,0,0,0,14,255,0,0,0,1,183,0,0,0,38,0,0,0,0,1,212,0,0,0,14,255,0,0,0,1,183,0,0,0,38,0,0,0,0,1,212,0,0,0,14,255,0,0,0,1,183,0,0,0,91,0);

mtep_bw20
:array[0..326] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,41,0,0,0,0,1,48,0,0,0,6,255,0,0,0,1,48,0,0,0,8,0,0,0,0,1,48,0,0,0,9,255,0,0,0,1,48,0,0,0,6,0,0,0,0,1,48,0,0,0,11,255,0,0,0,1,86,0,0,0,5,0,0,0,0,11,255,0,0,0,2,86,0,0,0,1,48,0,0,0,3,0,0,0,0,1,48,0,0,0,10,255,0,0,0,4,86,0,0,0,1,48,0,0,0,2,0,0,0,0,10,255,0,0,0,6,86,0,0,0,2,0,0,0,0,9,255,0,0,0,7,86,0,0,0,2,0,0,0,0,8,255,0,0,0,8,86,0,0,0,2,0,0,0,0,7,255,0,0,0,9,86,0,0,0,2,0,0,0,0,6,255,0,0,0,10,86,0,0,0,2,0,0,0,0,5,255,0,0,0,11,86,0,0,0,2,0,0,0,0,1,48,0,0,0,3,255,0,0,0,11,86,0,0,0,1,48,0,0,0,3,0,0,0,0,1,48,0,0,0,1,255,0,0,0,11,86,0,0,0,1,48,0,0,0,5,0,0,0,0,12,86,0,0,0,7,0,0,0,0,1,48,0,0,0,8,86,0,0,0,1,48,0,0,0,9,0,0,0,0,1,48,0,0,0,6,86,0,0,0,1,48,0,0,0,41,0);

mtep_less20
:array[0..231] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,0,0,0,92,0,0,0,0,1,255,0,0,0,1,37,0,0,0,7,0,0,0,0,1,37,0,0,0,1,255,0,0,0,2,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,5,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,3,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,3,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,5,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,7,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,9,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,96,0);

mtep_more20
:array[0..231] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,0,0,0,96,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,9,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,7,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,1,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,5,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,3,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,3,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,5,0,0,0,0,1,37,0,0,0,1,255,0,0,0,1,37,0,0,0,2,0,0,0,0,1,255,0,0,0,1,37,0,0,0,7,0,0,0,0,1,37,0,0,0,1,255,0,0,0,92,0);

mtep_stop20//16jun2025
:array[0..251] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,0,0,0,54,0,0,0,0,9,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,9,255,0,0,0,54,0);

mtep_rewind20//03jul2025
:array[0..371] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,70,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,7,0,0,0,0,1,255,0,0,0,3,0,0,0,0,2,255,0,0,0,3,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,3,0,0,0,0,2,255,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,66,0);

mtep_fastforward20//03jul2025
:array[0..371] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,66,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,7,0,0,0,0,1,255,0,0,0,3,0,0,0,0,2,255,0,0,0,3,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,3,0,0,0,0,2,255,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,70,0);

mtep_play20
:array[0..251] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,20,0,0,0,0,0,0,46,0,0,0,0,3,255,0,0,0,7,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,3,255,0,0,0,50,0);

mtep_pause20
:array[0..231] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,20,0,0,0,0,0,0,41,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,41,0);

mtep_notes20
:array[0..451] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,24,0,0,0,0,9,255,0,0,0,8,0,0,0,0,9,255,0,0,0,8,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,4,0,0,0,0,5,255,0,0,0,7,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,3,0,0,0,0,5,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,3,0,0,0,0,2,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,3,0,0,0,0,3,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,13,0,0,0,0,2,255,0,
0,0,38,0);

tep_visual20
:array[0..392] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,128,255,255,50,211,95,153,12,128,255,255,3,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,5,211,95,153,2,255,255,255,5,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,5,211,95,153,2,255,255,255,5,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,5,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,5,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,2,255,
255,255,1,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,1,211,95,153,2,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,3,211,95,153,12,128,255,255,50);

mtep_visual20
:array[0..501] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,50,0,0,0,0,12,255,0,0,0,3,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,5,0,0,0,0,2,255,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,5,0,0,0,0,2,255,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,
0,0,1,0,0,0,0,2,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,3,0,0,0,0,12,255,0,0,0,50,0);

mtep_info20
:array[0..321] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,50,0,0,0,0,12,255,0,0,0,3,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,8,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,8,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,8,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,3,0,0,0,0,12,255,0,0,0,50,0);

tep_info20
:array[0..248] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,128,255,255,50,211,95,153,12,128,255,255,3,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,8,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,8,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,2,211,95,153,8,255,255,255,2,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,2,211,95,153,1,255,255,255,12,211,95,153,1,128,255,255,3,211,95,153,12,128,255,255,50);

mtep_compress20
:array[0..261] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,20,0,0,0,0,0,0,34,0,0,0,0,1,123,0,0,0,8,246,0,0,0,1,123,0,0,0,1,0,0,0,0,10,246,0,0,0,1,0,0,0,0,1,123,0,0,0,9,246,0,0,0,7,0,0,0,0,1,123,0,0,0,2,246,0,0,0,1,123,0,0,0,5,0,0,0,0,1,123,0,0,0,4,246,0,0,0,1,123,0,0,0,4,0,0,0,0,1,123,0,0,0,4,246,0,0,0,1,123,0,0,0,4,0,0,0,0,1,123,0,0,0,4,246,0,0,0,1,123,0,0,0,5,0,0,0,0,4,246,0,0,0,1,123,0,0,0,4,0,0,0,0,2,123,0,0,0,3,246,0,0,0,1,123,0,0,0,5,0,0,0,0,3,246,0,0,0,1,123,0,0,0,6,0,0,0,0,1,123,0,0,0,2,246,0,0,0,1,123,0,0,0,7,0,0,0,0,10,246,0,0,0,1,123,0,0,0,11,246,0,0,0,1,123,0,0,0,9,246,0,0,0,1,123,0,0,0,33,0);

mtep_code20//09nov2025
:array[0..516] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,49,0,0,0,0,1,146,0,0,0,1,255,0,0,0,1,146,0,0,0,10,255,0,0,0,1,146,0,0,0,2,0,0,0,0,1,255,0,0,0,1,146,0,0,0,10,0,0,0,0,1,146,0,0,0,1,255,0,0,0,2,0,0,0,0,1,146,0,0,0,12,255,0,0,0,1,146,0,0,0,2,0,0,0,0,1,255,0,0,0,1,146,0,0,0,10,0,0,0,0,1,146,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,3,255,0,0,0,5,0,0,0,0,2,255,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,146,0,0,0,1,0,0,0,0,1,146,0,0,0,5,255,0,0,0,1,146,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,146,0,0,0,1,255,0,0,0,2,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,4,255,0,0,0,1,146,0,0,0,3,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,146,0,0,0,1,255,0,0,0,
1,0,0,0,0,1,146,0,0,0,1,255,0,0,0,1,0,0,0,0,1,146,0,0,0,6,0,0,0,0,1,255,0,0,0,1,146,0,0,0,7,0,0,0,0,1,146,0,0,0,1,255,0,0,0,5,0,0,0,0,1,146,0,0,0,9,255,0,0,0,1,146,0,0,0,52,0);

mtep_unit20//09nov2025
:array[0..531] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,35,0,0,0,0,10,255,0,0,0,6,0,0,0,0,1,255,0,0,0,8,0,0,0,0,2,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,3,0,0,0,0,3,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,4,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,7,0,0,0,0,1,255,0,0,0,1,0,0,0,0,2,255,0,0,0,5,0,0,0,0,2,255,0,0,0,5,0,0,0,0,2,255,0,0,0,9,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,204,0,0,0,2,255,0,0,0,1,204,0,0,0,2,255,0,0,0,1,204,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,
255,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,2,255,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,2,255,0,0,0,9,0,0,0,0,17,255,0,0,0,37,0);


mtep_image20//09nov2025
:array[0..511] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,28,0,0,0,0,1,107,0,0,0,1,180,0,0,0,10,249,0,0,0,1,180,0,0,0,1,118,0,0,0,1,180,0,0,0,1,191,0,0,0,1,118,0,0,0,8,0,0,0,0,1,118,0,0,0,1,191,0,0,0,1,180,0,0,0,1,249,0,0,0,1,118,0,0,0,5,0,0,0,0,1,118,0,0,0,2,173,0,0,0,3,118,0,0,0,2,249,0,0,0,6,0,0,0,0,1,173,0,0,0,2,249,0,0,0,1,173,0,0,0,2,0,0,0,0,2,249,0,0,0,6,0,0,0,0,1,173,0,0,0,2,249,0,0,0,1,173,0,0,0,2,0,0,0,0,2,249,0,0,0,6,0,0,0,0,1,118,0,0,0,2,173,0,0,0,1,118,0,0,0,2,0,0,0,0,2,249,0,0,0,12,0,0,0,0,2,249,0,0,0,12,0,0,0,0,2,249,0,0,0,5,0,0,0,0,2,219,0,0,0,5,0,0,0,0,2,249,0,0,0,3,0,0,0,0,1,132,0,0,0,1,219,0,0,0,2,140,0,0,0,1,209,0,0,0,1,132,0,0,0,3,0,0,0,0,2,249,0,0,0,2,0,0,0,0,1,132,0,0,0,1,230,0,0,0,1,140,0,0,0,2,0,0,0,0,1,140,0,0,0,1,230,0,0,0,1,132,0,0,0,2,0,0,0,0,2,249,0,0,0,1,0,0,0,0,1,132,0,0,0,1,230,0,0,0,1,132,0,0,0,4,0,0,0,0,1,132,0,0,0,1,230,0,0,0,1,132,0,0,0,1,0,0,0,0,1,249,0,0,0,1,239,0,0,0,1,140,0,0,0,1,230,0,0,0,1,132,0,0,0,6,0,0,0,0,1,132,0,0,0,1,230,
0,0,0,1,140,0,0,0,1,249,0,0,0,1,180,0,0,0,1,249,0,0,0,1,140,0,0,0,8,0,0,0,0,1,140,0,0,0,1,249,0,0,0,1,180,0,0,0,1,107,0,0,0,1,180,0,0,0,1,239,0,0,0,9,249,0,0,0,1,180,0,0,0,1,107,0,0,0,42,0);

mtep_copy20
:array[0..526] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,31,0,0,0,0,1,55,0,0,0,1,141,0,0,0,6,255,0,0,0,1,141,0,0,0,1,60,0,0,0,4,0,0,0,0,1,141,0,0,0,1,58,0,0,0,6,0,0,0,0,1,61,0,0,0,1,142,0,0,0,2,0,0,0,0,1,67,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,179,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,200,0,0,0,1,0,0,0,0,1,141,0,0,0,1,58,0,0,0,6,0,0,0,0,1,61,0,0,0,1,142,0,0,0,2,0,0,0,0,1,166,0,0,0,1,101,0,0,0,1,60,0,
0,0,1,142,0,0,0,6,255,0,0,0,1,142,0,0,0,1,65,0,0,0,2,0,0,0,0,1,79,0,0,0,1,184,0,0,0,1,71,0,0,0,12,0,0,0,0,1,79,0,0,0,1,167,0,0,0,1,201,0,0,0,4,204,0,0,0,1,183,0,0,0,1,67,0,0,0,31,0);

mtep_notepad20//18sep2025
:array[0..321] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,20,0,0,0,0,0,0,17,0,0,0,0,2,120,0,0,0,1,0,0,0,0,2,120,0,0,0,1,0,0,0,0,2,120,0,0,0,1,0,0,0,0,2,120,0,0,0,3,0,0,0,0,2,180,0,0,0,1,120,0,0,0,2,180,0,0,0,1,120,0,0,0,2,180,0,0,0,1,120,0,0,0,2,180,0,0,0,1,120,0,0,0,1,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,2,180,0,0,0,9,120,0,0,0,2,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,2,180,0,0,0,9,120,0,0,0,2,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,2,180,0,0,0,9,120,0,0,0,2,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,13,180,0,0,0,2,0,0,0,0,1,210,0,0,0,11,180,0,0,0,1,210,0,0,0,2,0,0,0,0,1,120,0,0,0,11,255,0,0,0,1,120,0,0,0,3,0,0,0,0,11,120,0,0,0,32,0);

mtep_paint20//18sep2025
:array[0..796] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,20,0,0,0,0,0,0,7,0,0,0,0,2,60,0,0,0,5,90,0,0,0,1,60,0,0,0,9,0,0,0,0,1,60,0,0,0,6,90,0,0,0,3,120,0,0,0,1,60,0,0,0,8,0,0,0,0,4,90,0,0,0,7,120,0,0,0,1,90,0,0,0,6,0,0,0,0,4,90,0,0,0,1,120,0,0,0,2,255,0,0,0,6,120,0,0,0,4,0,0,0,0,1,60,0,0,0,1,90,0,0,0,1,120,0,0,0,2,210,0,0,0,1,150,0,0,0,1,120,0,0,0,2,255,0,0,0,1,150,0,0,0,5,120,0,0,0,1,90,0,0,0,2,0,0,0,0,1,60,0,0,0,2,90,0,0,0,1,150,0,0,0,2,210,0,0,0,1,180,0,0,0,1,120,0,0,0,2,150,0,0,0,2,120,0,0,0,4,150,0,0,0,1,120,0,0,0,2,0,0,0,0,3,90,0,0,0,1,150,0,0,0,2,240,0,0,0,1,150,0,0,0,4,120,0,0,0,1,150,0,0,0,1,60,0,0,0,2,90,0,0,0,1,120,0,0,0,1,150,0,0,0,2,0,0,0,0,3,90,0,0,0,1,120,0,0,0,1,180,0,0,0,1,150,0,0,0,5,120,0,0,0,1,150,0,0,0,3,90,0,0,0,1,120,0,0,0,1,150,0,0,0,2,0,0,0,0,1,120,0,0,0,3,180,0,0,0,7,120,0,0,0,1,150,0,0,0,2,90,0,0,0,1,120,0,0,0,2,150,0,0,0,2,0,0,0,0,1,150,0,0,0,3,180,0,0,0,4,120,0,0,0,1,60,0,0,0,1,120,0,0,0,2,150,0,0,0,3,210,0,0,0,2,150,0,0,0,2,0,0,0,0,1,150,0,0,0,1,180,
0,0,0,2,210,0,0,0,4,120,0,0,0,1,0,0,0,0,1,60,0,0,0,2,150,0,0,0,3,210,0,0,0,1,150,0,0,0,1,120,0,0,0,2,0,0,0,0,1,120,0,0,0,1,150,0,0,0,1,180,0,0,0,1,150,0,0,0,3,120,0,0,0,1,150,0,0,0,1,60,0,0,0,1,120,0,0,0,2,150,0,0,0,3,210,0,0,0,1,150,0,0,0,1,60,0,0,0,2,0,0,0,0,5,120,0,0,0,2,60,0,0,0,5,150,0,0,0,1,180,0,0,0,2,210,0,0,0,1,180,0,0,0,3,0,0,0,0,4,120,0,0,0,1,30,0,0,0,2,0,0,0,0,5,150,0,0,0,1,180,0,0,0,2,210,0,0,0,1,120,0,0,0,3,0,0,0,0,2,120,0,0,0,1,150,0,0,0,1,120,0,0,0,2,0,0,0,0,1,30,0,0,0,5,150,0,0,0,3,210,0,0,0,4,0,0,0,0,1,30,0,0,0,2,90,0,0,0,3,0,0,0,0,1,120,0,0,0,5,150,0,0,0,2,210,0,0,0,1,180,0,0,0,10,0,0,0,0,3,150,0,0,0,1,180,0,0,0,1,255,0,0,0,2,150,0,0,0,1,210,0,0,0,1,180,0,0,0,10,0,0,0,0,1,30,0,0,0,2,150,0,0,0,1,120,0,0,0,1,90,0,0,0,1,0,0,0,0,1,120,0,0,0,1,210,0,0,0,1,120,0,0,0,16,0,0,0,0,1,60,0,0,0,1,210,0,0,0,1,90,0,0,0,22,0);

mtep_dither20
:array[0..464] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,252,252,252,65,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,8,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,8,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,8,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,8,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,8,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,8,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,8,252,252,252,2,0,0,0,8,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,8,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,8,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,8,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,
252,2,0,0,0,8,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,8,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,8,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,33);

mtep_rect20
:array[0..240] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,239,239,239,52,0,0,0,15,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,1,239,239,239,13,0,0,0,1,239,239,239,2,0,0,0,15,239,239,239,35);

mtep_line20
:array[0..160] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,252,252,252,38,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,18,0,0,0,1,252,252,252,38);

mtep_pen20
:array[0..88] of byte=(
84,69,65,49,35,11,0,0,0,20,0,0,0,252,252,252,70,0,0,0,3,252,252,252,6,0,0,0,7,252,252,252,4,0,0,0,7,252,252,252,3,0,0,0,9,252,252,252,2,0,0,0,9,252,252,252,2,0,0,0,9,252,252,252,3,0,0,0,7,252,252,252,4,0,0,0,7,252,252,252,6,0,0,0,3,252,252,252,59);

mtep_drag20
:array[0..112] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,252,252,252,94,0,0,0,3,252,252,252,10,0,0,0,7,252,252,252,8,0,0,0,7,252,252,252,7,0,0,0,9,252,252,252,6,0,0,0,9,252,252,252,6,0,0,0,9,252,252,252,7,0,0,0,7,252,252,252,8,0,0,0,7,252,252,252,10,0,0,0,3,252,252,252,20,0,0,0,2,252,252,252,10,0,0,0,5,252,252,252,2,0,0,0,12,252,252,252,32);

mtep_pot20
:array[0..168] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,252,252,252,70,0,0,0,2,252,252,252,18,0,0,0,2,252,252,252,19,0,0,0,2,252,252,252,19,0,0,0,2,252,252,252,19,0,0,0,2,252,252,252,19,0,0,0,2,252,252,252,7,0,0,0,14,252,252,252,6,0,0,0,15,252,252,252,3,0,0,0,2,252,252,252,2,0,0,0,13,252,252,252,3,0,0,0,2,252,252,252,3,0,0,0,11,252,252,252,10,0,0,0,9,252,252,252,5,0,0,0,2,252,252,252,5,0,0,0,7,252,252,252,6,0,0,0,2,252,252,252,6,0,0,0,5,252,252,252,16,0,0,0,3,252,252,252,18,0,0,0,1,252,252,252,48);

mtep_gpot20
:array[0..192] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,255,0,0,70,0,0,0,2,255,0,0,18,0,0,0,2,255,0,0,19,0,0,0,2,255,0,0,19,0,0,0,2,255,0,0,19,0,0,0,2,255,0,0,19,0,0,0,2,255,0,0,7,0,0,0,14,255,0,0,6,0,0,0,15,255,0,0,3,0,0,0,2,255,0,0,2,0,0,0,13,255,0,0,3,0,0,0,2,255,0,0,3,0,0,0,11,255,0,0,10,0,0,0,9,255,0,0,5,0,0,0,2,255,0,0,5,0,0,0,7,255,0,0,6,0,0,0,2,255,0,0,6,0,0,0,5,255,0,0,16,0,0,0,3,255,0,0,8,0,0,0,7,255,0,0,3,0,0,0,1,255,0,0,2,0,0,0,5,255,0,0,22,0,0,0,18,255,0,0,1);

mtep_cls20
:array[0..376] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,252,252,252,65,0,0,0,14,252,252,252,2,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,1,252,252,252,4,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,6,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,6,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,2,0,0,0,1,
252,252,252,2,0,0,0,1,252,252,252,35);

mtep_move20
:array[0..144] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,252,252,252,70,0,0,0,1,252,252,252,18,0,0,0,3,252,252,252,16,0,0,0,5,252,252,252,52,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,8,0,0,0,2,252,252,252,9,0,0,0,2,252,252,252,6,0,0,0,3,252,252,252,9,0,0,0,3,252,252,252,6,0,0,0,2,252,252,252,9,0,0,0,2,252,252,252,8,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,52,0,0,0,5,252,252,252,16,0,0,0,3,252,252,252,18,0,0,0,1,252,252,252,49);

mtep_eyedropper20
:array[0..232] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,252,252,252,34,0,0,0,3,252,252,252,16,0,0,0,5,252,252,252,14,0,0,0,7,252,252,252,12,0,0,0,8,252,252,252,11,0,0,0,9,252,252,252,10,0,0,0,10,252,252,252,10,0,0,0,9,252,252,252,12,0,0,0,7,252,252,252,12,0,0,0,1,252,252,252,1,0,0,0,5,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,4,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,1,0,0,0,2,252,252,252,12,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,15,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,15,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,15,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,15,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,15,0,0,0,4,252,252,252,16,0,0,0,3,252,252,252,36);

mtep_wraphorz20
:array[0..184] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,252,252,252,83,0,0,0,1,252,252,252,16,0,0,0,2,252,252,252,15,0,0,0,3,252,252,252,9,0,0,0,2,252,252,252,3,0,0,0,7,252,252,252,5,0,0,0,1,252,252,252,6,0,0,0,3,252,252,252,3,0,0,0,1,252,252,252,3,0,0,0,1,252,252,252,8,0,0,0,2,252,252,252,4,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,4,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,14,0,0,0,1,252,252,252,2,0,0,0,1,252,252,252,14,0,0,0,1,252,252,252,3,0,0,0,1,252,252,252,12,0,0,0,1,252,252,252,5,0,0,0,12,252,252,252,93);

mtep_swap20:array[0..208] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,252,252,252,49,0,0,0,7,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,7,252,252,252,16,0,0,0,7,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,1,252,252,252,5,0,0,0,1,252,252,252,9,0,0,0,7,252,252,252,49);

mtep_back20
:array[0..291] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,0,0,0,46,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,4,0,0,0,0,4,255,0,0,0,3,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,4,255,0,0,0,5,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,44,0);

mtep_forward20
:array[0..291] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,0,0,0,44,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,5,0,0,0,0,4,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,3,0,0,0,0,4,255,0,0,0,4,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,46,0);

mtep_cut20
:array[0..706] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,35,0,0,0,0,1,227,0,0,0,1,72,0,0,0,6,0,0,0,0,1,76,0,0,0,1,195,0,0,0,6,0,0,0,0,1,159,0,0,0,1,203,0,0,0,6,0,0,0,0,1,219,0,0,0,1,143,0,0,0,6,0,0,0,0,1,52,0,0,0,1,239,0,0,0,1,124,0,0,0,4,0,0,0,0,1,139,0,0,0,1,227,0,0,0,1,52,0,0,0,7,0,0,0,0,1,96,0,0,0,1,255,0,0,0,1,64,0,0,0,2,0,0,0,0,1,72,0,0,0,1,255,0,0,0,1,84,0,0,0,9,0,0,0,0,1,179,0,0,0,1,195,0,0,0,2,0,0,0,0,1,207,0,0,0,1,159,0,0,0,10,0,0,0,0,1,60,0,0,0,1,247,0,0,0,1,96,0,0,0,1,124,0,0,0,1,231,0,0,0,1,52,0,0,0,11,0,0,0,0,1,96,0,0,0,1,68,0,0,0,1,255,0,0,0,1,96,0,0,0,13,0,0,0,0,1,219,0,0,0,1,235,0,0,0,13,0,0,0,0,1,116,0,0,0,1,243,0,0,0,1,251,0,0,0,1,104,0,0,0,11,0,0,0,0,1,60,0,0,0,1,251,0,0,0,1,104,0,0,0,1,120,0,0,0,1,239,0,0,0,1,56,0,0,0,7,0,0,0,0,1,143,0,0,0,2,211,0,0,0,1,207,0,0,0,1,179,0,0,0,2,0,0,0,0,2,199,0,0,0,1,215,0,0,0,1,207,0,0,0,1,139,0,0,0,3,0,0,0,0,1,143,0,0,0,1,195,0,0,0,1,92,0,0,0,1,76,0,0,0,1,211,0,0,0,1,147,0,0,0,2,0,0,0,0,1,155,0,0,0,1,207,0,0,0,1,
92,0,0,0,1,76,0,0,0,1,195,0,0,0,1,139,0,0,0,2,0,0,0,0,1,215,0,0,0,1,88,0,0,0,2,0,0,0,0,1,84,0,0,0,1,211,0,0,0,2,0,0,0,0,1,215,0,0,0,1,88,0,0,0,2,0,0,0,0,1,84,0,0,0,1,211,0,0,0,2,0,0,0,0,1,219,0,0,0,1,88,0,0,0,2,0,0,0,0,1,84,0,0,0,1,219,0,0,0,2,0,0,0,0,1,219,0,0,0,1,88,0,0,0,2,0,0,0,0,1,84,0,0,0,1,219,0,0,0,2,0,0,0,0,1,147,0,0,0,1,187,0,0,0,1,88,0,0,0,1,72,0,0,0,1,195,0,0,0,1,147,0,0,0,2,0,0,0,0,1,147,0,0,0,1,187,0,0,0,1,88,0,0,0,1,72,0,0,0,1,195,0,0,0,1,147,0,0,0,2,0,0,0,0,1,52,0,0,0,1,147,0,0,0,2,219,0,0,0,1,147,0,0,0,1,52,0,0,0,2,0,0,0,0,1,52,0,0,0,1,147,0,0,0,2,219,0,0,0,1,147,0,0,0,1,52,0,0,0,33,0);

mtep_paste20
:array[0..561] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,36,0,0,0,0,1,105,0,0,0,1,195,0,0,0,2,204,0,0,0,1,195,0,0,0,1,101,0,0,0,7,0,0,0,0,1,105,0,0,0,1,195,0,0,0,1,204,0,0,0,1,198,0,0,0,3,0,0,0,0,1,67,0,0,0,1,201,0,0,0,1,204,0,0,0,1,195,0,0,0,1,103,0,0,0,4,0,0,0,0,1,195,0,0,0,2,0,0,0,0,1,96,0,0,0,1,194,0,0,0,2,204,0,0,0,1,190,0,0,0,1,96,0,0,0,2,0,0,0,0,1,195,0,0,0,4,0,0,0,0,1,204,0,0,0,10,0,0,0,0,1,157,0,0,0,4,0,0,0,0,1,204,0,0,0,15,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,92,0,0,0,1,255,0,0,0,4,254,0,0,0,1,255,0,0,0,1,90,0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,254,0,0,0,6,0,0,0,0,1,254,0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,254,0,0,0,6,0,0,0,0,1,254,0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,254,0,0,0,6,0,0,0,0,1,254,0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,254,0,0,0,6,0,0,0,0,1,254,0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,254,0,0,0,6,0,0,0,0,1,254,0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,254,0,0,0,6,0,0,0,0,1,254,
0,0,0,2,0,0,0,0,1,204,0,0,0,5,0,0,0,0,1,254,0,0,0,6,0,0,0,0,1,254,0,0,0,2,0,0,0,0,1,195,0,0,0,5,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,105,0,0,0,1,195,0,0,0,2,204,0,0,0,1,145,0,0,0,1,0,0,0,0,1,92,0,0,0,1,255,0,0,0,4,254,0,0,0,1,255,0,0,0,1,90,0,0,0,33,0);

mtep_open20
:array[0..491] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,55,0,0,0,0,1,60,0,0,0,1,187,0,0,0,4,255,0,0,0,1,187,0,0,0,1,61,0,0,0,10,0,0,0,0,1,188,0,0,0,1,126,0,0,0,4,0,0,0,0,1,113,0,0,0,1,207,0,0,0,10,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,156,0,0,0,5,255,0,0,0,1,188,0,0,0,1,60,0,0,0,3,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,128,0,0,0,1,188,0,0,0,3,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,60,0,0,0,1,223,0,0,0,11,255,0,0,0,1,59,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,174,0,0,0,1,113,0,0,0,10,0,0,0,0,1,112,0,0,0,1,173,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,239,0,0,0,1,49,0,0,0,10,0,0,0,0,1,72,0,0,0,1,188,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,223,0,0,0,11,0,0,0,0,1,112,0,0,0,1,141,0,0,0,2,0,0,0,0,1,255,0,0,0,1,85,0,0,0,1,173,0,0,0,11,0,0,0,0,1,125,0,0,0,1,126,0,0,0,2,0,0,0,0,1,255,0,0,0,1,126,0,0,0,1,125,0,0,0,11,0,0,0,0,1,188,0,0,0,1,73,0,0,0,2,0,0,0,0,1,255,0,0,0,1,187,0,0,0,1,70,0,0,0,11,0,0,0,0,1,207,0,0,0,1,60,0,0,0,2,0,0,0,0,1,255,0,0,0,1,239,0,0,0,12,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,187,
0,0,0,1,239,0,0,0,11,0,0,0,0,1,126,0,0,0,1,188,0,0,0,3,0,0,0,0,1,60,0,0,0,1,187,0,0,0,11,255,0,0,0,1,187,0,0,0,1,62,0,0,0,56,0);

mtep_refresh20
:array[0..431] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,20,0,0,0,0,0,0,35,0,0,0,0,1,57,0,0,0,3,255,0,0,0,1,57,0,0,0,9,0,0,0,0,1,57,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,57,0,0,0,8,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,57,0,0,0,5,255,0,0,0,1,57,0,0,0,2,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,57,0,0,0,3,255,0,0,0,1,57,0,0,0,2,0,0,0,0,1,57,0,0,0,1,255,0,0,0,1,57,0,0,0,6,0,0,0,0,1,57,0,0,0,1,255,0,0,0,1,57,0,0,0,2,0,0,0,0,1,57,0,0,0,3,255,0,0,0,1,57,0,0,0,6,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,57,0,0,0,5,255,0,0,0,1,57,0,0,0,5,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,8,0,0,0,0,1,57,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,57,0,0,0,9,0,0,0,0,1,57,0,0,0,3,255,0,0,0,1,57,0,0,0,35,0);

mtep_prev20
:array[0..221] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,61,0,0,0,0,1,159,0,0,0,1,251,0,0,0,11,0,0,0,0,1,159,0,0,0,1,251,0,0,0,11,0,0,0,0,1,159,0,0,0,1,251,0,0,0,11,0,0,0,0,1,159,0,0,0,1,251,0,0,0,11,0,0,0,0,1,218,0,0,0,1,255,0,0,0,1,179,0,0,0,8,145,0,0,0,1,112,0,0,0,2,0,0,0,0,1,223,0,0,0,1,255,0,0,0,1,198,0,0,0,8,170,0,0,0,1,119,0,0,0,3,0,0,0,0,1,159,0,0,0,1,251,0,0,0,13,0,0,0,0,1,159,0,0,0,1,251,0,0,0,13,0,0,0,0,1,159,0,0,0,1,251,0,0,0,13,0,0,0,0,1,159,0,0,0,1,251,0,0,0,13,0,0,0,0,1,58,0,0,0,77,0);

mtep_next20
:array[0..221] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,63,0,0,0,0,1,251,0,0,0,1,159,0,0,0,13,0,0,0,0,1,251,0,0,0,1,159,0,0,0,13,0,0,0,0,1,251,0,0,0,1,159,0,0,0,13,0,0,0,0,1,251,0,0,0,1,159,0,0,0,3,0,0,0,0,1,112,0,0,0,8,145,0,0,0,1,179,0,0,0,1,255,0,0,0,1,218,0,0,0,2,0,0,0,0,1,119,0,0,0,8,170,0,0,0,1,198,0,0,0,1,255,0,0,0,1,223,0,0,0,11,0,0,0,0,1,251,0,0,0,1,159,0,0,0,11,0,0,0,0,1,251,0,0,0,1,159,0,0,0,11,0,0,0,0,1,251,0,0,0,1,159,0,0,0,11,0,0,0,0,1,251,0,0,0,1,159,0,0,0,12,0,0,0,0,1,58,0,0,0,76,0);

mtep_new20
:array[0..471] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,29,0,0,0,0,1,98,0,0,0,1,239,0,0,0,4,255,0,0,0,1,223,0,0,0,1,61,0,0,0,6,0,0,0,0,1,239,0,0,0,1,62,0,0,0,4,0,0,0,0,1,255,0,0,0,1,223,0,0,0,1,59,0,0,0,5,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,62,0,0,0,1,222,0,0,0,1,60,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,60,0,0,0,1,223,0,0,0,1,60,0,0,0,3,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,239,0,0,0,1,60,0,0,0,1,0,0,0,0,1,62,0,0,0,1,223,0,0,0,1,61,0,0,0,2,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,100,0,0,0,1,239,0,0,0,3,255,0,0,0,1,223,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,238,0,0,0,1,60,0,0,0,8,0,0,0,0,1,58,0,0,0,1,239,0,0,0,2,0,0,
0,0,1,98,0,0,0,1,239,0,0,0,8,255,0,0,0,1,239,0,0,0,1,100,0,0,0,29,0);

mtep_close20
:array[0..351] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,20,0,0,0,0,0,0,61,0,0,0,0,1,220,0,0,0,1,69,0,0,0,6,0,0,0,0,1,69,0,0,0,1,219,0,0,0,2,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,4,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,3,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,2,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,5,0,0,0,0,1,69,0,0,0,1,231,0,0,0,2,69,0,0,0,1,231,0,0,0,1,69,0,0,0,7,0,0,0,0,1,69,0,0,0,2,231,0,0,0,1,69,0,0,0,8,0,0,0,0,1,69,0,0,0,2,231,0,0,0,1,69,0,0,0,7,0,0,0,0,1,69,0,0,0,1,231,0,0,0,2,69,0,0,0,1,231,0,0,0,1,69,0,0,0,5,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,2,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,3,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,4,0,0,0,0,1,69,0,0,0,1,231,0,0,0,1,69,0,0,0,2,0,0,0,0,1,219,0,0,0,1,69,0,0,0,6,0,0,0,0,1,69,0,0,0,1,220,0,0,0,61,0);

mtep_settings20
:array[0..761] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,43,0,0,0,0,1,118,0,0,0,2,191,0,0,0,1,160,0,0,0,14,0,0,0,0,1,255,0,0,0,2,78,0,0,0,1,208,0,0,0,1,78,0,0,0,9,0,0,0,0,1,67,0,0,0,2,0,0,0,0,1,67,0,0,0,1,208,0,0,0,2,0,0,0,0,2,131,0,0,0,2,0,0,0,0,1,78,0,0,0,5,0,0,0,0,1,78,0,0,0,2,239,0,0,0,1,160,0,0,0,1,208,0,0,0,1,131,0,0,0,2,0,0,0,0,1,78,0,0,0,1,239,0,0,0,1,160,0,0,0,2,239,0,0,0,1,131,0,0,0,4,0,0,0,0,1,224,0,0,0,1,78,0,0,0,1,0,0,0,0,1,103,0,0,0,1,78,0,0,0,5,0,0,0,0,1,103,0,0,0,2,0,0,0,0,1,239,0,0,0,3,0,0,0,0,1,78,0,0,0,1,224,0,0,0,4,0,0,0,0,1,91,0,0,0,2,191,0,0,0,1,131,0,0,0,4,0,0,0,0,1,160,0,0,0,1,131,0,0,0,3,0,0,0,0,1,208,0,0,0,1,160,0,0,0,2,0,0,0,0,1,91,0,0,0,1,208,0,0,0,1,91,0,0,0,1,78,0,0,0,1,176,0,0,0,1,144,0,0,0,2,0,0,0,0,1,103,0,0,0,1,239,0,0,0,1,67,0,0,0,4,0,0,0,0,1,176,0,0,0,1,118,0,0,0,1,0,0,0,0,1,191,0,0,0,1,91,0,0,0,3,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,67,0,0,0,1,224,0,0,0,6,0,0,0,0,1,144,0,0,0,1,131,0,0,0,1,0,0,0,0,1,191,0,0,0,1,78,0,0,0,3,0,0,0,0,1,255,
0,0,0,1,0,0,0,0,1,78,0,0,0,1,208,0,0,0,5,0,0,0,0,1,144,0,0,0,1,208,0,0,0,2,0,0,0,0,1,131,0,0,0,1,176,0,0,0,2,0,0,0,0,1,131,0,0,0,1,191,0,0,0,2,0,0,0,0,1,160,0,0,0,1,208,0,0,0,3,0,0,0,0,1,78,0,0,0,1,224,0,0,0,4,0,0,0,0,1,144,0,0,0,2,255,0,0,0,1,191,0,0,0,4,0,0,0,0,1,176,0,0,0,1,131,0,0,0,3,0,0,0,0,1,239,0,0,0,12,0,0,0,0,1,224,0,0,0,1,78,0,0,0,3,0,0,0,0,1,118,0,0,0,2,208,0,0,0,1,224,0,0,0,1,239,0,0,0,1,91,0,0,0,3,0,0,0,0,1,224,0,0,0,1,208,0,0,0,1,224,0,0,0,1,191,0,0,0,1,176,0,0,0,5,0,0,0,0,1,118,0,0,0,1,91,0,0,0,1,0,0,0,0,1,91,0,0,0,1,191,0,0,0,2,0,0,0,0,1,131,0,0,0,1,144,0,0,0,1,0,0,0,0,1,67,0,0,0,1,131,0,0,0,10,0,0,0,0,1,239,0,0,0,2,0,0,0,0,1,191,0,0,0,1,91,0,0,0,13,0,0,0,0,1,176,0,0,0,2,255,0,0,0,1,224,0,0,0,43,0);

mtep_font20
:array[0..581] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,40,0,0,0,0,2,107,0,0,0,16,0,0,0,0,2,213,0,0,0,15,0,0,0,0,1,68,0,0,0,2,165,0,0,0,1,68,0,0,0,14,0,0,0,0,1,151,0,0,0,2,80,0,0,0,1,151,0,0,0,3,0,0,0,0,2,107,0,0,0,8,0,0,0,0,1,32,0,0,0,1,213,0,0,0,2,0,0,0,0,1,213,0,0,0,1,32,0,0,0,2,0,0,0,0,1,197,0,0,0,1,213,0,0,0,8,0,0,0,0,1,93,0,0,0,1,135,0,0,0,2,0,0,0,0,1,135,0,0,0,1,107,0,0,0,1,0,0,0,0,1,68,0,0,0,1,182,0,0,0,1,165,0,0,0,1,68,0,0,0,7,0,0,0,0,1,197,0,0,0,1,182,0,0,0,2,165,0,0,0,1,182,0,0,0,1,197,0,0,0,1,0,0,0,0,1,135,0,0,0,2,80,0,0,0,1,151,0,0,0,6,0,0,0,0,1,68,0,0,0,1,182,0,0,0,4,55,0,0,0,1,151,0,0,0,1,19,0,0,0,1,228,0,0,0,2,19,0,0,0,1,213,0,0,0,1,19,0,0,0,5,0,0,0,0,1,135,0,0,0,1,80,0,0,0,4,0,0,0,0,1,32,0,0,0,1,80,0,0,0,1,135,0,0,0,2,0,0,0,0,1,135,0,0,0,1,93,0,0,0,5,0,0,0,0,1,197,0,0,0,1,19,0,0,0,5,0,0,0,0,1,182,0,0,0,1,68,0,0,0,2,0,0,0,0,1,44,0,0,0,1,197,0,0,0,11,0,0,0,0,1,32,0,0,0,1,197,0,0,0,4,0,0,0,0,1,197,0,0,0,1,44,0,0,0,10,0,0,0,0,1,120,0,0,0,6,228,0,0,0,1,
135,0,0,0,10,0,0,0,0,1,197,0,0,0,1,32,0,0,0,4,0,0,0,0,1,32,0,0,0,1,213,0,0,0,1,19,0,0,0,8,0,0,0,0,1,68,0,0,0,1,182,0,0,0,6,0,0,0,0,1,151,0,0,0,1,80,0,0,0,8,0,0,0,0,1,135,0,0,0,1,80,0,0,0,6,0,0,0,0,1,68,0,0,0,1,165,0,0,0,7,0,0,0,0,1,197,0,0,0,1,228,0,0,0,1,197,0,0,0,6,0,0,0,0,1,197,0,0,0,1,228,0,0,0,1,197,0,0,0,37,0);

mtep_wrap20
:array[0..256] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,69,0,0,0,0,1,197,0,0,0,12,228,0,0,0,1,197,0,0,0,71,0,0,0,0,1,197,0,0,0,11,228,0,0,0,1,213,0,0,0,1,120,0,0,0,1,19,0,0,0,14,0,0,0,0,1,19,0,0,0,1,135,0,0,0,1,120,0,0,0,15,0,0,0,0,1,19,0,0,0,1,213,0,0,0,11,0,0,0,0,2,44,0,0,0,2,0,0,0,0,1,19,0,0,0,1,213,0,0,0,10,0,0,0,0,1,44,0,0,0,1,197,0,0,0,1,44,0,0,0,1,0,0,0,0,1,19,0,0,0,1,135,0,0,0,1,120,0,0,0,2,0,0,0,0,1,197,0,0,0,4,228,0,0,0,1,197,0,0,0,2,0,0,0,0,1,197,0,0,0,3,228,0,0,0,1,213,0,0,0,1,120,0,0,0,11,0,0,0,0,1,44,0,0,0,1,197,0,0,0,1,44,0,0,0,15,0,0,0,0,2,44,0,0,0,56,0);

mtep_print20
:array[0..511] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,58,0,0,0,0,1,107,0,0,0,2,228,0,0,0,1,229,0,0,0,5,228,0,0,0,1,107,0,0,0,8,0,0,0,0,1,228,0,0,0,1,23,0,0,0,6,0,0,0,0,1,21,0,0,0,1,228,0,0,0,5,0,0,0,0,1,46,0,0,0,1,166,0,0,0,1,228,0,0,0,1,229,0,0,0,7,228,0,0,0,1,229,0,0,0,2,228,0,0,0,1,166,0,0,0,1,46,0,0,0,2,0,0,0,0,1,166,0,0,0,1,108,0,0,0,12,0,0,0,0,1,108,0,0,0,1,167,0,0,0,2,0,0,0,0,1,228,0,0,0,14,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,229,0,0,0,14,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,229,0,0,0,14,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,109,0,0,0,1,229,0,0,0,2,228,0,0,0,2,229,0,0,0,3,228,0,0,0,1,108,0,0,0,2,0,0,0,0,1,228,0,0,0,2,0,0,0,0,1,228,0,0,0,2,0,0,0,0,1,228,0,0,0,1,22,0,0,0,6,0,0,0,0,1,21,0,0,0,1,229,0,0,0,2,0,0,0,0,1,229,0,0,0,2,0,0,0,0,1,228,0,0,0,1,23,0,0,0,1,0,0,0,0,1,229,0,0,0,8,0,0,0,0,1,229,0,0,0,1,0,0,0,0,1,21,0,0,0,1,229,0,0,0,2,0,0,0,0,1,109,0,0,0,2,229,0,0,0,1,228,0,0,0,8,0,0,0,0,2,229,0,0,0,1,228,0,0,0,1,108,0,0,0,5,0,0,0,0,1,228,0,0,0,8,0,0,
0,0,1,229,0,0,0,8,0,0,0,0,1,229,0,0,0,1,21,0,0,0,6,0,0,0,0,1,22,0,0,0,1,229,0,0,0,8,0,0,0,0,1,108,0,0,0,1,229,0,0,0,3,228,0,0,0,3,229,0,0,0,1,228,0,0,0,1,107,0,0,0,58,0);

mtep_zoom20
:array[0..506] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,51,0,0,0,0,1,35,0,0,0,1,136,0,0,0,1,213,0,0,0,1,228,0,0,0,1,213,0,0,0,1,136,0,0,0,1,34,0,0,0,8,0,0,0,0,1,81,0,0,0,1,197,0,0,0,1,107,0,0,0,1,33,0,0,0,1,0,0,0,0,1,33,0,0,0,1,108,0,0,0,1,198,0,0,0,1,81,0,0,0,6,0,0,0,0,1,34,0,0,0,1,198,0,0,0,1,45,0,0,0,5,0,0,0,0,1,45,0,0,0,1,197,0,0,0,1,34,0,0,0,5,0,0,0,0,1,136,0,0,0,1,107,0,0,0,7,0,0,0,0,1,108,0,0,0,1,136,0,0,0,5,0,0,0,0,1,214,0,0,0,1,33,0,0,0,7,0,0,0,0,1,33,0,0,0,1,213,0,0,0,5,0,0,0,0,1,228,0,0,0,9,0,0,0,0,1,228,0,0,0,5,0,0,0,0,1,213,0,0,0,1,32,0,0,0,7,0,0,0,0,1,33,0,0,0,1,213,0,0,0,5,0,0,0,0,1,135,0,0,0,1,108,0,0,0,7,0,0,0,0,1,107,0,0,0,1,136,0,0,0,5,0,0,0,0,1,33,0,0,0,1,197,0,0,0,1,45,0,0,0,5,0,0,0,0,1,43,0,0,0,1,198,0,0,0,1,33,0,0,0,6,0,0,0,0,1,81,0,0,0,1,198,0,0,0,1,107,0,0,0,1,35,0,0,0,1,0,0,0,0,1,33,0,0,0,1,107,0,0,0,1,197,0,0,0,1,198,0,0,0,1,45,0,0,0,7,0,0,0,0,1,33,0,0,0,1,136,0,0,0,1,213,0,0,0,1,228,0,0,0,1,213,0,0,0,1,135,0,0,0,1,33,0,0,0,1,45,0,0,0,1,198,
0,0,0,1,45,0,0,0,14,0,0,0,0,1,45,0,0,0,1,198,0,0,0,1,45,0,0,0,14,0,0,0,0,1,46,0,0,0,1,198,0,0,0,1,45,0,0,0,14,0,0,0,0,1,45,0,0,0,1,182,0,0,0,49,0);

mtep_yes20
:array[0..256] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,81,0,0,0,0,1,71,0,0,0,1,236,0,0,0,11,0,0,0,0,1,70,0,0,0,1,254,0,0,0,1,70,0,0,0,10,0,0,0,0,1,69,0,0,0,1,255,0,0,0,1,69,0,0,0,10,0,0,0,0,1,69,0,0,0,1,255,0,0,0,1,66,0,0,0,4,0,0,0,0,1,235,0,0,0,1,71,0,0,0,4,0,0,0,0,1,69,0,0,0,1,255,0,0,0,1,70,0,0,0,5,0,0,0,0,1,69,0,0,0,1,254,0,0,0,1,69,0,0,0,2,0,0,0,0,1,69,0,0,0,1,254,0,0,0,1,69,0,0,0,7,0,0,0,0,1,67,0,0,0,1,255,0,0,0,1,66,0,0,0,1,70,0,0,0,1,254,0,0,0,1,70,0,0,0,9,0,0,0,0,1,69,0,0,0,1,254,0,0,0,1,255,0,0,0,1,71,0,0,0,11,0,0,0,0,1,71,0,0,0,1,66,0,0,0,92,0);

mtep_yesBLANK20//09jun2025
:array[0..20] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,255,0,0,250,255,0,0,30);

mtep_newfolder20
:array[0..571] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,37,0,0,0,0,1,57,0,0,0,1,164,0,0,0,3,204,0,0,0,1,201,0,0,0,1,135,0,0,0,11,0,0,0,0,1,164,0,0,0,1,67,0,0,0,4,0,0,0,0,1,100,0,0,0,1,172,0,0,0,10,0,0,0,0,1,204,0,0,0,6,0,0,0,0,1,178,0,0,0,6,204,0,0,0,1,164,0,0,0,1,61,0,0,0,2,0,0,0,0,6,204,0,0,0,1,180,0,0,0,1,96,0,0,0,6,0,0,0,0,1,71,0,0,0,1,165,0,0,0,2,0,0,0,0,1,204,0,0,0,14,0,0,0,0,1,204,0,0,0,2,0,0,0,0,1,204,0,0,0,14,0,0,0,0,1,204,0,0,0,2,0,0,0,0,1,204,0,0,0,8,0,0,0,0,1,87,0,0,0,1,142,0,0,0,1,165,0,0,0,1,142,0,0,0,1,87,0,0,0,1,0,0,0,0,1,100,0,0,0,2,0,0,0,0,1,204,0,0,0,7,0,0,0,0,1,135,0,0,0,5,255,0,0,0,1,132,0,0,0,3,0,0,0,0,1,204,0,0,0,6,0,0,0,0,1,87,0,0,0,3,255,0,0,0,1,45,0,0,0,3,255,0,0,0,1,87,0,0,0,2,0,0,0,0,1,204,0,0,0,6,0,0,0,0,1,142,0,0,0,3,255,0,0,0,1,0,0,0,0,3,255,0,0,0,1,142,0,0,0,2,0,0,0,0,1,204,0,0,0,6,0,0,0,0,1,165,0,0,0,1,255,0,0,0,1,32,0,0,0,3,0,0,0,0,1,54,0,0,0,1,255,0,0,0,1,165,0,0,0,2,0,0,0,0,1,204,0,0,0,6,0,0,0,0,1,130,0,0,0,3,255,0,0,0,1,0,0,0,0,
3,255,0,0,0,1,135,0,0,0,2,0,0,0,0,1,164,0,0,0,1,67,0,0,0,5,0,0,0,0,1,87,0,0,0,3,255,0,0,0,1,45,0,0,0,3,255,0,0,0,1,95,0,0,0,2,0,0,0,0,1,61,0,0,0,1,165,0,0,0,4,204,0,0,0,1,144,0,0,0,1,0,0,0,0,1,123,0,0,0,5,255,0,0,0,1,123,0,0,0,12,0,0,0,0,1,95,0,0,0,1,140,0,0,0,1,255,0,0,0,1,140,0,0,0,1,95,0,0,0,57,0);

mtep_folderimage20
:array[0..546] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,37,0,0,0,0,1,117,0,0,0,1,217,0,0,0,3,255,0,0,0,1,251,0,0,0,1,189,0,0,0,11,0,0,0,0,1,217,0,0,0,1,134,0,0,0,4,0,0,0,0,1,163,0,0,0,1,223,0,0,0,10,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,231,0,0,0,6,255,0,0,0,1,217,0,0,0,1,121,0,0,0,2,0,0,0,0,6,255,0,0,0,1,233,0,0,0,1,159,0,0,0,6,0,0,0,0,1,137,0,0,0,1,218,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,217,0,0,0,3,0,0,0,0,1,213,0,0,0,2,0,0,0,0,1,255,0,0,0,9,0,0,0,0,1,184,0,0,0,1,217,0,0,0,1,189,0,0,0,5,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,117,0,0,0,7,217,0,0,0,1,127,0,0,0,2,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,206,0,0,0,1,217,0,0,0,1,209,0,0,0,1,166,0,0,0,1,212,0,0,0,1,217,0,0,0,1,212,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,166,0,0,0,1,217,0,0,0,1,167,0,0,0,1,0,0,0,0,1,166,0,0,0,1,217,0,0,0,1,175,0,0,0,3,0,0,0,0,1,255,0,0,0,7,0,0,0,0,1,205,0,0,0,1,217,0,0,0,1,213,0,0,0,1,166,0,0,0,1,213,0,0,0,1,217,0,
0,0,1,209,0,0,0,3,0,0,0,0,1,217,0,0,0,1,134,0,0,0,5,0,0,0,0,1,122,0,0,0,7,217,0,0,0,1,122,0,0,0,2,0,0,0,0,1,121,0,0,0,1,218,0,0,0,4,255,0,0,0,1,234,0,0,0,2,0,0,0,0,1,104,0,0,0,1,189,0,0,0,1,217,0,0,0,1,195,0,0,0,1,109,0,0,0,15,0,0,0,0,1,217,0,0,0,1,105,0,0,0,58,0);

mtep_undo20
:array[0..471] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,20,0,0,0,0,0,0,31,0,0,0,0,1,129,0,0,0,4,0,0,0,0,1,52,0,0,0,1,117,0,0,0,1,145,0,0,0,1,143,0,0,0,1,117,0,0,0,1,57,0,0,0,4,0,0,0,0,1,165,0,0,0,3,0,0,0,0,1,104,0,0,0,1,151,0,0,0,1,79,0,0,0,1,43,0,0,0,1,47,0,0,0,1,81,0,0,0,1,151,0,0,0,1,94,0,0,0,3,0,0,0,0,1,165,0,0,0,2,0,0,0,0,1,125,0,0,0,1,130,0,0,0,1,39,0,0,0,4,0,0,0,0,1,41,0,0,0,1,152,0,0,0,1,69,0,0,0,2,0,0,0,0,1,165,0,0,0,1,47,0,0,0,1,143,0,0,0,1,110,0,0,0,7,0,0,0,0,1,80,0,0,0,1,128,0,0,0,2,0,0,0,0,1,165,0,0,0,1,151,0,0,0,1,87,0,0,0,8,0,0,0,0,1,41,0,0,0,1,162,0,0,0,2,0,0,0,0,1,157,0,0,0,4,165,0,0,0,1,122,0,0,0,6,0,0,0,0,1,165,0,0,0,13,0,0,0,0,1,71,0,0,0,1,132,0,0,0,13,0,0,0,0,1,148,0,0,0,1,71,0,0,0,11,0,0,0,0,1,39,0,0,0,1,134,0,0,0,1,104,0,0,0,11,0,0,0,0,1,53,0,0,0,1,149,0,0,0,1,95,0,0,0,11,0,0,0,0,1,70,0,0,0,1,154,0,0,0,1,77,0,0,0,11,0,0,0,0,1,94,0,0,0,1,152,0,0,0,1,59,0,0,0,11,0,0,0,0,1,115,0,0,0,1,141,0,0,0,1,43,0,0,0,10,0,0,0,0,1,38,0,0,0,1,134,0,0,0,1,126,0,0,0,11,0,0,0,
0,1,51,0,0,0,1,150,0,0,0,1,103,0,0,0,12,0,0,0,0,1,136,0,0,0,1,83,0,0,0,40,0);

mtep_redo20
:array[0..471] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,20,0,0,0,0,0,0,33,0,0,0,0,1,57,0,0,0,1,117,0,0,0,1,143,0,0,0,1,145,0,0,0,1,117,0,0,0,1,52,0,0,0,4,0,0,0,0,1,129,0,0,0,3,0,0,0,0,1,94,0,0,0,1,151,0,0,0,1,81,0,0,0,1,47,0,0,0,1,43,0,0,0,1,79,0,0,0,1,151,0,0,0,1,104,0,0,0,3,0,0,0,0,1,165,0,0,0,2,0,0,0,0,1,69,0,0,0,1,152,0,0,0,1,41,0,0,0,4,0,0,0,0,1,39,0,0,0,1,130,0,0,0,1,125,0,0,0,2,0,0,0,0,1,165,0,0,0,2,0,0,0,0,1,128,0,0,0,1,80,0,0,0,7,0,0,0,0,1,110,0,0,0,1,143,0,0,0,1,47,0,0,0,1,165,0,0,0,2,0,0,0,0,1,162,0,0,0,1,41,0,0,0,8,0,0,0,0,1,87,0,0,0,1,151,0,0,0,1,165,0,0,0,2,0,0,0,0,1,165,0,0,0,6,0,0,0,0,1,122,0,0,0,4,165,0,0,0,1,157,0,0,0,2,0,0,0,0,1,132,0,0,0,1,71,0,0,0,13,0,0,0,0,1,71,0,0,0,1,148,0,0,0,14,0,0,0,0,1,104,0,0,0,1,134,0,0,0,1,39,0,0,0,13,0,0,0,0,1,95,0,0,0,1,149,0,0,0,1,53,0,0,0,13,0,0,0,0,1,77,0,0,0,1,154,0,0,0,1,70,0,0,0,13,0,0,0,0,1,59,0,0,0,1,152,0,0,0,1,94,0,0,0,13,0,0,0,0,1,43,0,0,0,1,141,0,0,0,1,115,0,0,0,14,0,0,0,0,1,126,0,0,0,1,134,0,0,0,1,38,0,0,0,13,0,0,0,0,
1,103,0,0,0,1,150,0,0,0,1,51,0,0,0,13,0,0,0,0,1,83,0,0,0,1,136,0,0,0,33,0);

mtep_exe20
:array[0..611] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,51,0,0,0,0,1,91,0,0,0,1,238,0,0,0,8,255,0,0,0,1,238,0,0,0,1,91,0,0,0,4,0,0,0,0,1,238,0,0,0,1,50,0,0,0,8,0,0,0,0,1,50,0,0,0,1,238,0,0,0,2,0,0,0,0,1,91,0,0,0,1,238,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,238,0,0,0,1,50,0,0,0,1,255,0,0,0,3,0,0,0,0,1,221,0,0,0,3,255,0,0,0,1,238,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,50,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,50,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,50,0,0,0,1,221,0,0,0,1,50,0,0,0,2,0,0,0,0,1,221,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,205,0,0,0,1,50,0,0,0,6,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,
255,0,0,0,1,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,238,0,0,0,1,50,0,0,0,8,0,0,0,0,1,50,0,0,0,1,238,0,0,0,2,0,0,0,0,1,238,0,0,0,1,0,0,0,0,1,91,0,0,0,1,238,0,0,0,8,255,0,0,0,1,238,0,0,0,1,91,0,0,0,2,0,0,0,0,1,135,0,0,0,1,152,0,0,0,8,0,0,0,0,1,50,0,0,0,1,238,0,0,0,5,0,0,0,0,1,135,0,0,0,1,238,0,0,0,7,255,0,0,0,1,238,0,0,0,1,91,0,0,0,51,0);

mtep_txt20
:array[0..536] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,20,0,0,0,0,0,0,29,0,0,0,0,1,141,0,0,0,1,142,0,0,0,1,144,0,0,0,1,145,0,0,0,1,146,0,0,0,1,148,0,0,0,1,149,0,0,0,1,151,0,0,0,1,152,0,0,0,1,153,0,0,0,1,98,0,0,0,3,0,0,0,0,1,142,0,0,0,7,0,0,0,0,1,140,0,0,0,1,92,0,0,0,1,155,0,0,0,1,99,0,0,0,2,0,0,0,0,1,144,0,0,0,7,0,0,0,0,1,140,0,0,0,1,72,0,0,0,1,93,0,0,0,1,157,0,0,0,2,0,0,0,0,1,145,0,0,0,1,0,0,0,0,5,133,0,0,0,1,0,0,0,0,1,140,0,0,0,2,166,0,0,0,1,160,0,0,0,2,0,0,0,0,1,146,0,0,0,10,0,0,0,0,1,161,0,0,0,2,0,0,0,0,1,148,0,0,0,1,0,0,0,0,8,133,0,0,0,1,0,0,0,0,1,163,0,0,0,2,0,0,0,0,1,149,0,0,0,10,0,0,0,0,1,164,0,0,0,2,0,0,0,0,1,151,0,0,0,1,0,0,0,0,8,133,0,0,0,1,0,0,0,0,1,165,0,0,0,2,0,0,0,0,1,152,0,0,0,10,0,0,0,0,1,167,0,0,0,2,0,0,0,0,1,153,0,0,0,1,0,0,0,0,8,133,0,0,0,1,0,0,0,0,1,168,0,0,0,2,0,0,0,0,1,155,0,0,0,10,0,0,0,0,1,170,0,0,0,2,0,0,0,0,1,156,0,0,0,1,0,0,0,0,8,133,0,0,0,1,0,0,0,0,1,171,0,0,0,2,0,0,0,0,1,157,0,0,0,10,0,0,0,0,1,172,0,0,0,2,0,0,0,0,1,159,0,0,0,1,0,0,0,0,8,133,0,0,0,1,
0,0,0,0,1,174,0,0,0,2,0,0,0,0,1,160,0,0,0,10,0,0,0,0,1,175,0,0,0,2,0,0,0,0,1,161,0,0,0,1,163,0,0,0,1,164,0,0,0,1,165,0,0,0,1,167,0,0,0,1,168,0,0,0,1,170,0,0,0,1,171,0,0,0,1,172,0,0,0,1,174,0,0,0,1,175,0,0,0,1,176,0,0,0,29,0);

mtep_selectall20
:array[0..871] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,37,0,0,0,0,1,89,0,0,0,1,185,0,0,0,1,170,0,0,0,1,0,0,0,0,1,107,0,0,0,2,221,0,0,0,1,88,0,0,0,1,0,0,0,0,1,190,0,0,0,1,221,0,0,0,1,170,0,0,0,1,0,0,0,0,1,190,0,0,0,1,185,0,0,0,1,96,0,0,0,2,0,0,0,0,1,185,0,0,0,1,107,0,0,0,12,0,0,0,0,1,111,0,0,0,1,187,0,0,0,2,0,0,0,0,1,180,0,0,0,1,0,0,0,0,1,119,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,117,0,0,0,2,0,0,0,0,1,120,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,117,0,0,0,1,0,0,0,0,1,179,0,0,0,4,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,2,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,4,0,0,0,0,1,179,0,0,0,1,0,0,0,0,5,186,0,0,0,2,0,0,0,0,5,186,0,0,0,1,0,0,0,0,1,180,0,0,0,2,0,0,0,0,1,221,0,0,0,1,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,2,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,1,0,0,0,0,1,221,0,0,0,2,0,0,0,0,1,179,0,0,0,1,0,0,0,0,1,120,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,117,0,0,0,2,0,0,0,0,1,120,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,118,0,0,0,1,0,0,0,0,
1,180,0,0,0,20,0,0,0,0,1,97,0,0,0,14,0,0,0,0,1,98,0,0,0,2,0,0,0,0,1,221,0,0,0,1,0,0,0,0,1,119,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,116,0,0,0,2,0,0,0,0,1,120,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,117,0,0,0,1,0,0,0,0,1,221,0,0,0,2,0,0,0,0,1,221,0,0,0,1,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,2,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,1,0,0,0,0,1,221,0,0,0,2,0,0,0,0,1,97,0,0,0,1,0,0,0,0,5,186,0,0,0,2,0,0,0,0,5,186,0,0,0,1,0,0,0,0,1,98,0,0,0,4,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,2,0,0,0,0,1,183,0,0,0,3,186,0,0,0,1,183,0,0,0,4,0,0,0,0,1,179,0,0,0,1,0,0,0,0,1,121,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,118,0,0,0,2,0,0,0,0,1,120,0,0,0,1,183,0,0,0,1,186,0,0,0,1,183,0,0,0,1,117,0,0,0,1,0,0,0,0,1,179,0,0,0,2,0,0,0,0,1,185,0,0,0,1,107,0,0,0,12,0,0,0,0,1,111,0,0,0,1,187,0,0,0,2,0,0,0,0,1,94,0,0,0,1,187,0,0,0,1,170,0,0,0,1,0,0,0,0,1,108,0,0,0,2,221,0,0,0,1,86,0,0,0,1,0,0,0,0,1,190,0,0,0,1,221,0,0,0,1,169,0,0,0,1,0,0,0,0,1,190,0,0,0,1,187,0,0,0,1,100,0,0,0,37,
0);

mtep_nav20
:array[0..421] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,74,0,0,0,0,1,36,0,0,0,3,194,0,0,0,1,54,0,0,0,8,194,0,0,0,1,135,0,0,0,1,44,0,0,0,2,0,0,0,0,1,36,0,0,0,1,16,0,0,0,3,0,0,0,0,1,194,0,0,0,8,0,0,0,0,1,59,0,0,0,1,136,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,194,0,0,0,4,0,0,0,0,1,194,0,0,0,9,0,0,0,0,1,194,0,0,0,2,0,0,0,0,1,36,0,0,0,1,16,0,0,0,3,0,0,0,0,1,194,0,0,0,8,0,0,0,0,1,59,0,0,0,1,136,0,0,0,3,0,0,0,0,1,35,0,0,0,3,194,0,0,0,1,54,0,0,0,8,194,0,0,0,1,136,0,0,0,1,49,0,0,0,73,0);

mtep_eye20
:array[0..531] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,95,0,0,0,0,1,40,0,0,0,1,147,0,0,0,1,196,0,0,0,2,252,0,0,0,1,196,0,0,0,1,150,0,0,0,1,43,0,0,0,9,0,0,0,0,1,121,0,0,0,1,247,0,0,0,1,159,0,0,0,1,99,0,0,0,2,43,0,0,0,1,94,0,0,0,1,155,0,0,0,1,247,0,0,0,1,124,0,0,0,7,0,0,0,0,1,145,0,0,0,1,217,0,0,0,1,64,0,0,0,6,0,0,0,0,1,64,0,0,0,1,217,0,0,0,1,159,0,0,0,5,0,0,0,0,1,113,0,0,0,1,241,0,0,0,1,48,0,0,0,1,0,0,0,0,1,35,0,0,0,1,161,0,0,0,1,241,0,0,0,1,242,0,0,0,1,161,0,0,0,1,35,0,0,0,1,0,0,0,0,1,40,0,0,0,1,231,0,0,0,1,129,0,0,0,3,0,0,0,0,1,32,0,0,0,1,252,0,0,0,1,70,0,0,0,2,0,0,0,0,1,207,0,0,0,1,164,0,0,0,2,29,0,0,0,1,155,0,0,0,1,217,0,0,0,1,29,0,0,0,1,0,0,0,0,1,51,0,0,0,1,255,0,0,0,1,40,0,0,0,2,0,0,0,0,1,113,0,0,0,1,206,0,0,0,2,0,0,0,0,1,89,0,0,0,1,206,0,0,0,4,8,0,0,0,1,206,0,0,0,1,99,0,0,0,2,0,0,0,0,1,185,0,0,0,1,129,0,0,0,2,0,0,0,0,1,166,0,0,0,1,94,0,0,0,2,0,0,0,0,1,132,0,0,0,1,147,0,0,0,4,8,0,0,0,1,147,0,0,0,1,140,0,0,0,2,0,0,0,0,1,78,0,0,0,1,171,0,0,0,6,0,0,0,0,1,94,0,0,
0,1,206,0,0,0,4,8,0,0,0,1,202,0,0,0,1,100,0,0,0,10,0,0,0,0,1,29,0,0,0,1,217,0,0,0,1,147,0,0,0,2,29,0,0,0,1,142,0,0,0,1,223,0,0,0,1,29,0,0,0,11,0,0,0,0,1,40,0,0,0,1,171,0,0,0,2,252,0,0,0,1,177,0,0,0,1,43,0,0,0,96,0);

mtep_upone20
:array[0..271] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,0,0,0,58,0,0,0,0,1,212,0,0,0,11,0,0,0,0,1,241,0,0,0,1,255,0,0,0,1,241,0,0,0,9,0,0,0,0,1,241,0,0,0,1,183,0,0,0,1,255,0,0,0,1,199,0,0,0,1,241,0,0,0,7,0,0,0,0,1,241,0,0,0,1,169,0,0,0,1,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,169,0,0,0,1,241,0,0,0,5,0,0,0,0,1,241,0,0,0,1,169,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,169,0,0,0,1,241,0,0,0,3,0,0,0,0,1,212,0,0,0,1,169,0,0,0,3,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,169,0,0,0,1,212,0,0,0,7,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,212,0,0,0,58,0);

mtep_fav20
:array[0..636] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,44,0,0,0,0,1,128,0,0,0,1,126,0,0,0,15,0,0,0,0,1,66,0,0,0,2,230,0,0,0,1,64,0,0,0,14,0,0,0,0,1,186,0,0,0,1,119,0,0,0,1,121,0,0,0,1,184,0,0,0,13,0,0,0,0,1,68,0,0,0,1,240,0,0,0,2,0,0,0,0,1,240,0,0,0,1,63,0,0,0,11,0,0,0,0,1,59,0,0,0,1,200,0,0,0,1,126,0,0,0,2,0,0,0,0,1,129,0,0,0,1,196,0,0,0,1,58,0,0,0,6,0,0,0,0,1,97,0,0,0,1,172,0,0,0,1,212,0,0,0,1,255,0,0,0,1,240,0,0,0,1,173,0,0,0,4,0,0,0,0,1,174,0,0,0,1,240,0,0,0,1,255,0,0,0,1,211,0,0,0,1,171,0,0,0,1,95,0,0,0,2,0,0,0,0,1,249,0,0,0,1,155,0,0,0,1,83,0,0,0,10,0,0,0,0,1,84,0,0,0,1,159,0,0,0,1,246,0,0,0,2,0,0,0,0,1,125,0,0,0,1,238,0,0,0,1,60,0,0,0,10,0,0,0,0,1,61,0,0,0,1,238,0,0,0,1,124,0,0,0,3,0,0,0,0,1,117,0,0,0,1,242,0,0,0,1,60,0,0,0,8,0,0,0,0,1,65,0,0,0,1,242,0,0,0,1,117,0,0,0,5,0,0,0,0,1,113,0,0,0,1,245,0,0,0,1,57,0,0,0,6,0,0,0,0,1,57,0,0,0,1,248,0,0,0,1,111,0,0,0,7,0,0,0,0,1,181,0,0,0,1,111,0,0,0,6,0,0,0,0,1,110,0,0,0,1,182,0,0,0,8,0,0,0,0,1,214,0,0,0,1,75,0,0,0,6,
0,0,0,0,1,74,0,0,0,1,214,0,0,0,8,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,79,0,0,0,1,82,0,0,0,3,0,0,0,0,1,254,0,0,0,7,0,0,0,0,1,59,0,0,0,1,233,0,0,0,1,0,0,0,0,1,71,0,0,0,1,193,0,0,0,2,206,0,0,0,1,193,0,0,0,1,71,0,0,0,1,0,0,0,0,1,234,0,0,0,1,55,0,0,0,6,0,0,0,0,1,92,0,0,0,1,221,0,0,0,1,186,0,0,0,1,215,0,0,0,1,93,0,0,0,2,0,0,0,0,1,97,0,0,0,1,216,0,0,0,1,186,0,0,0,1,221,0,0,0,1,88,0,0,0,7,0,0,0,0,1,185,0,0,0,1,100,0,0,0,6,0,0,0,0,1,104,0,0,0,1,184,0,0,0,40,0);

mtep_schemes20
:array[0..801] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,41,0,0,0,0,1,55,0,0,0,1,135,0,0,0,1,213,0,0,0,2,228,0,0,0,1,165,0,0,0,1,93,0,0,0,1,19,0,0,0,8,0,0,0,0,1,19,0,0,0,1,135,0,0,0,1,197,0,0,0,1,80,0,0,0,1,19,0,0,0,2,0,0,0,0,1,55,0,0,0,1,135,0,0,0,1,213,0,0,0,1,80,0,0,0,7,0,0,0,0,1,165,0,0,0,1,135,0,0,0,1,19,0,0,0,6,0,0,0,0,1,44,0,0,0,1,182,0,0,0,1,135,0,0,0,5,0,0,0,0,1,107,0,0,0,1,151,0,0,0,4,0,0,0,0,1,213,0,0,0,1,93,0,0,0,3,0,0,0,0,1,19,0,0,0,1,182,0,0,0,1,80,0,0,0,3,0,0,0,0,1,32,0,0,0,1,213,0,0,0,1,19,0,0,0,4,0,0,0,0,1,93,0,0,0,1,44,0,0,0,1,0,0,0,0,1,213,0,0,0,1,93,0,0,0,1,0,0,0,0,1,32,0,0,0,1,197,0,0,0,1,19,0,0,0,2,0,0,0,0,1,135,0,0,0,1,107,0,0,0,8,0,0,0,0,1,93,0,0,0,1,44,0,0,0,2,0,0,0,0,1,120,0,0,0,1,93,0,0,0,2,0,0,0,0,1,197,0,0,0,1,32,0,0,0,9,0,0,0,0,1,32,0,0,0,1,165,0,0,0,1,32,0,0,0,1,55,0,0,0,1,165,0,0,0,2,0,0,0,0,1,228,0,0,0,10,0,0,0,0,1,32,0,0,0,1,165,0,0,0,1,32,0,0,0,1,0,0,0,0,1,228,0,0,0,2,0,0,0,0,1,197,0,0,0,1,55,0,0,0,1,0,0,0,0,1,19,0,0,0,1,93,0,0,0,1,
107,0,0,0,1,32,0,0,0,8,0,0,0,0,1,228,0,0,0,2,0,0,0,0,1,44,0,0,0,1,213,0,0,0,1,165,0,0,0,1,213,0,0,0,1,135,0,0,0,1,120,0,0,0,1,197,0,0,0,1,32,0,0,0,3,0,0,0,0,1,32,0,0,0,1,165,0,0,0,1,32,0,0,0,1,0,0,0,0,1,228,0,0,0,3,0,0,0,0,1,19,0,0,0,1,68,0,0,0,1,32,0,0,0,2,0,0,0,0,1,151,0,0,0,1,55,0,0,0,3,0,0,0,0,1,32,0,0,0,1,165,0,0,0,1,32,0,0,0,1,55,0,0,0,1,165,0,0,0,8,0,0,0,0,2,107,0,0,0,1,0,0,0,0,1,32,0,0,0,1,165,0,0,0,1,32,0,0,0,2,0,0,0,0,2,120,0,0,0,8,0,0,0,0,2,107,0,0,0,1,0,0,0,0,1,32,0,0,0,1,165,0,0,0,1,32,0,0,0,1,0,0,0,0,1,19,0,0,0,1,213,0,0,0,1,32,0,0,0,8,0,0,0,0,1,55,0,0,0,1,197,0,0,0,5,0,0,0,0,1,135,0,0,0,1,120,0,0,0,10,0,0,0,0,1,165,0,0,0,1,151,0,0,0,1,32,0,0,0,1,0,0,0,0,1,32,0,0,0,1,151,0,0,0,1,182,0,0,0,11,0,0,0,0,1,19,0,0,0,1,107,0,0,0,1,213,0,0,0,1,228,0,0,0,1,213,0,0,0,1,107,0,0,0,40,0);

mtep_color20
:array[0..481] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,41,0,0,0,0,1,107,0,0,0,6,184,0,0,0,1,107,0,0,0,8,0,0,0,0,1,107,0,0,0,5,204,0,0,0,1,27,0,0,0,1,0,0,0,0,1,27,0,0,0,2,184,0,0,0,1,107,0,0,0,5,0,0,0,0,1,107,0,0,0,6,191,0,0,0,4,0,0,0,0,1,27,0,0,0,1,184,0,0,0,1,107,0,0,0,4,0,0,0,0,7,179,0,0,0,5,0,0,0,0,1,27,0,0,0,1,184,0,0,0,3,0,0,0,0,1,107,0,0,0,7,166,0,0,0,6,0,0,0,0,1,184,0,0,0,1,107,0,0,0,2,0,0,0,0,8,153,0,0,0,6,0,0,0,0,1,27,0,0,0,1,184,0,0,0,2,0,0,0,0,8,140,0,0,0,7,0,0,0,0,1,184,0,0,0,2,0,0,0,0,8,127,0,0,0,1,27,0,0,0,5,0,0,0,0,1,27,0,0,0,1,184,0,0,0,2,0,0,0,0,1,184,0,0,0,1,27,0,0,0,5,0,0,0,0,1,27,0,0,0,8,140,0,0,0,2,0,0,0,0,1,184,0,0,0,7,0,0,0,0,8,153,0,0,0,2,0,0,0,0,1,184,0,0,0,1,27,0,0,0,6,0,0,0,0,8,166,0,0,0,2,0,0,0,0,1,107,0,0,0,1,184,0,0,0,6,0,0,0,0,7,178,0,0,0,1,107,0,0,0,3,0,0,0,0,1,184,0,0,0,1,27,0,0,0,5,0,0,0,0,7,191,0,0,0,4,0,0,0,0,1,107,0,0,0,1,184,0,0,0,1,27,0,0,0,4,0,0,0,0,6,204,0,0,0,1,107,0,0,0,5,0,0,0,0,1,107,0,0,0,2,184,0,0,0,1,27,0,0,0,1,0,0,0,
0,1,27,0,0,0,5,184,0,0,0,1,107,0,0,0,8,0,0,0,0,1,107,0,0,0,6,184,0,0,0,1,107,0,0,0,41,0);

mtep_screen20
:array[0..371] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,37,0,0,0,0,1,78,0,0,0,1,206,0,0,0,12,255,0,0,0,1,206,0,0,0,1,78,0,0,0,2,0,0,0,0,1,207,0,0,0,1,88,0,0,0,12,0,0,0,0,1,88,0,0,0,1,207,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,207,0,0,0,1,88,0,0,0,12,0,0,0,0,1,88,0,0,0,1,207,0,0,0,2,0,0,0,0,1,82,0,0,0,1,207,0,0,0,12,255,0,0,0,1,207,0,0,0,1,90,0,0,0,7,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,10,0,0,0,0,1,213,0,0,0,8,255,0,0,0,1,184,0,0,0,58,0);

mtep_home20
:array[0..606] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,43,0,0,0,0,1,106,0,0,0,2,255,0,0,0,1,106,0,0,0,1,0,0,0,0,2,255,0,0,0,10,0,0,0,0,1,106,0,0,0,1,255,0,0,0,2,106,0,0,0,1,255,0,0,0,1,106,0,0,0,2,255,0,0,0,9,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,2,0,0,0,0,1,106,0,0,0,3,255,0,0,0,8,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,4,0,0,0,0,1,106,0,0,0,2,255,0,0,0,7,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,6,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,5,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,8,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,3,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,10,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,2,0,0,0,0,1,255,0,0,0,1,106,0,0,0,12,0,0,0,0,1,106,0,0,0,1,255,0,0,0,2,0,0,0,0,1,106,0,0,0,14,255,0,0,0,1,106,0,0,0,3,0,0,0,0,1,255,0,0,0,1,106,0,0,0,9,0,0,0,0,1,106,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,106,0,0,0,1,255,
0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,106,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,1,106,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,106,0,0,0,2,0,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,1,255,0,0,0,1,106,0,0,0,2,0,0,0,0,1,106,0,0,0,1,255,0,0,0,5,0,0,0,0,1,106,0,0,0,11,255,0,0,0,1,106,0,0,0,39,0);

mtep_folder20
:array[0..381] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,55,0,0,0,0,1,70,0,0,0,1,204,0,0,0,3,255,0,0,0,1,250,0,0,0,1,168,0,0,0,11,0,0,0,0,1,204,0,0,0,1,84,0,0,0,4,0,0,0,0,1,124,0,0,0,1,214,0,0,0,10,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,222,0,0,0,6,255,0,0,0,1,204,0,0,0,1,76,0,0,0,2,0,0,0,0,6,255,0,0,0,1,225,0,0,0,1,120,0,0,0,6,0,0,0,0,1,88,0,0,0,1,206,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,14,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,204,0,0,0,1,84,0,0,0,12,0,0,0,0,1,84,0,0,0,1,204,0,0,0,2,0,0,0,0,1,76,0,0,0,1,206,0,0,0,12,255,0,0,0,1,206,0,0,0,1,76,0,0,0,55,0);

mtep_startmenu20
:array[0..1271] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,19,0,0,0,20,0,0,0,0,0,0,20,0,0,0,0,1,153,0,0,0,1,184,0,0,0,1,186,0,0,0,1,188,0,0,0,1,190,0,0,0,1,195,0,0,0,1,197,0,0,0,1,199,0,0,0,1,0,0,0,0,1,210,0,0,0,1,212,0,0,0,1,216,0,0,0,2,220,0,0,0,2,223,0,0,0,1,179,0,0,0,2,0,0,0,0,1,184,0,0,0,1,186,0,0,0,1,188,0,0,0,1,190,0,0,0,1,192,0,0,0,1,197,0,0,0,1,199,0,0,0,1,201,0,0,0,1,0,0,0,0,1,212,0,0,0,1,214,0,0,0,1,216,0,0,0,1,220,0,0,0,2,223,0,0,0,1,225,0,0,0,1,227,0,0,0,2,0,0,0,0,1,186,0,0,0,1,188,0,0,0,1,190,0,0,0,1,192,0,0,0,1,195,0,0,0,1,199,0,0,0,1,201,0,0,0,1,203,0,0,0,1,0,0,0,0,1,214,0,0,0,1,216,0,0,0,1,218,0,0,0,1,221,0,0,0,1,223,0,0,0,1,225,0,0,0,1,227,0,0,0,1,229,0,0,0,2,0,0,0,0,1,188,0,0,0,1,190,0,0,0,1,192,0,0,0,2,195,0,0,0,1,201,0,0,0,1,203,0,0,0,1,205,0,0,0,1,0,0,0,0,1,216,0,0,0,1,218,0,0,0,1,220,0,0,0,1,223,0,0,0,1,225,0,0,0,1,227,0,0,0,1,229,0,0,0,1,231,0,0,0,2,0,0,0,0,1,190,0,0,0,1,192,0,0,0,2,195,0,0,0,1,199,0,0,0,1,203,0,0,0,1,205,0,0,0,1,207,0,0,0,1,0,0,0,0,1,218,0,0,0,1,220,
0,0,0,1,221,0,0,0,1,225,0,0,0,1,227,0,0,0,1,229,0,0,0,1,231,0,0,0,1,233,0,0,0,2,0,0,0,0,2,195,0,0,0,1,199,0,0,0,1,201,0,0,0,1,203,0,0,0,1,207,0,0,0,1,208,0,0,0,1,212,0,0,0,1,0,0,0,0,1,221,0,0,0,1,223,0,0,0,1,225,0,0,0,1,229,0,0,0,1,231,0,0,0,1,233,0,0,0,1,235,0,0,0,1,236,0,0,0,2,0,0,0,0,1,195,0,0,0,1,199,0,0,0,1,201,0,0,0,1,203,0,0,0,1,205,0,0,0,1,208,0,0,0,2,212,0,0,0,1,0,0,0,0,1,223,0,0,0,2,225,0,0,0,1,231,0,0,0,1,233,0,0,0,1,235,0,0,0,1,236,0,0,0,1,238,0,0,0,2,0,0,0,0,1,199,0,0,0,1,201,0,0,0,1,203,0,0,0,1,205,0,0,0,1,207,0,0,0,2,212,0,0,0,1,216,0,0,0,1,0,0,0,0,2,225,0,0,0,1,229,0,0,0,1,231,0,0,0,1,235,0,0,0,1,236,0,0,0,1,238,0,0,0,1,240,0,0,0,21,0,0,0,0,1,221,0,0,0,1,223,0,0,0,1,225,0,0,0,1,227,0,0,0,1,229,0,0,0,1,235,0,0,0,1,236,0,0,0,1,238,0,0,0,1,0,0,0,0,1,240,0,0,0,4,244,0,0,0,1,246,0,0,0,2,248,0,0,0,2,0,0,0,0,1,223,0,0,0,1,225,0,0,0,1,227,0,0,0,1,229,0,0,0,1,233,0,0,0,1,236,0,0,0,1,238,0,0,0,1,240,0,0,0,1,0,0,0,0,1,240,0,0,0,3,244,0,0,0,1,246,0,0,0,2,248,0,0,0,1,249,0,
0,0,2,0,0,0,0,1,225,0,0,0,1,227,0,0,0,1,229,0,0,0,1,233,0,0,0,1,235,0,0,0,1,238,0,0,0,1,240,0,0,0,1,242,0,0,0,1,0,0,0,0,1,240,0,0,0,2,244,0,0,0,1,246,0,0,0,2,248,0,0,0,2,249,0,0,0,2,0,0,0,0,1,229,0,0,0,1,233,0,0,0,1,235,0,0,0,1,236,0,0,0,1,238,0,0,0,1,242,0,0,0,1,244,0,0,0,1,248,0,0,0,1,0,0,0,0,1,240,0,0,0,1,244,0,0,0,1,246,0,0,0,1,248,0,0,0,4,249,0,0,0,2,0,0,0,0,1,231,0,0,0,1,235,0,0,0,1,236,0,0,0,1,238,0,0,0,1,240,0,0,0,1,244,0,0,0,1,248,0,0,0,1,249,0,0,0,1,0,0,0,0,1,240,0,0,0,1,246,0,0,0,1,248,0,0,0,4,249,0,0,0,1,253,0,0,0,2,0,0,0,0,1,235,0,0,0,1,236,0,0,0,1,238,0,0,0,1,240,0,0,0,1,242,0,0,0,1,248,0,0,0,1,249,0,0,0,1,251,0,0,0,1,0,0,0,0,1,240,0,0,0,2,248,0,0,0,3,249,0,0,0,2,253,0,0,0,2,0,0,0,0,2,236,0,0,0,1,240,0,0,0,1,242,0,0,0,1,244,0,0,0,1,249,0,0,0,1,251,0,0,0,1,253,0,0,0,1,0,0,0,0,1,240,0,0,0,1,248,0,0,0,3,249,0,0,0,3,253,0,0,0,2,0,0,0,0,1,179,0,0,0,1,240,0,0,0,1,242,0,0,0,1,244,0,0,0,1,248,0,0,0,1,251,0,0,0,1,253,0,0,0,1,255,0,0,0,1,0,0,0,0,1,240,0,0,0,3,249,0,0,0,4,
253,0,0,0,39,0);

mtep_programs20
:array[0..391] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,55,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,207,0,0,0,2,0,0,0,0,4,207,0,0,0,2,0,0,0,0,4,207,0,0,0,38,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,207,0,0,0,2,0,0,0,0,4,207,0,0,0,2,0,0,0,0,4,207,0,0,0,38,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,1,110,0,0,0,2,187,0,0,0,1,110,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,195,0,0,0,2,0,0,0,0,4,207,0,0,0,2,0,0,0,0,4,207,0,0,0,2,0,0,0,0,4,207,0,0,0,73,0);

mtep_desktop20
:array[0..361] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,91,0,0,0,0,1,43,0,0,0,1,134,0,0,0,12,231,0,0,0,1,134,0,0,0,1,43,0,0,0,2,0,0,0,0,1,134,0,0,0,1,147,0,0,0,1,43,0,0,0,10,0,0,0,0,1,43,0,0,0,1,147,0,0,0,1,134,0,0,0,2,0,0,0,0,1,231,0,0,0,1,43,0,0,0,12,0,0,0,0,1,43,0,0,0,1,231,0,0,0,2,0,0,0,0,1,231,0,0,0,14,0,0,0,0,1,231,0,0,0,2,0,0,0,0,1,231,0,0,0,14,0,0,0,0,1,231,0,0,0,2,0,0,0,0,1,231,0,0,0,14,0,0,0,0,1,231,0,0,0,2,0,0,0,0,1,231,0,0,0,14,0,0,0,0,1,231,0,0,0,2,0,0,0,0,1,231,0,0,0,1,43,0,0,0,12,0,0,0,0,1,43,0,0,0,1,231,0,0,0,2,0,0,0,0,16,231,0,0,0,2,0,0,0,0,1,218,0,0,0,1,43,0,0,0,9,0,0,0,0,1,175,0,0,0,1,0,0,0,0,1,175,0,0,0,1,43,0,0,0,1,231,0,0,0,2,0,0,0,0,1,134,0,0,0,1,147,0,0,0,1,43,0,0,0,10,0,0,0,0,1,43,0,0,0,1,147,0,0,0,1,134,0,0,0,3,0,0,0,0,1,134,0,0,0,1,218,0,0,0,11,231,0,0,0,1,134,0,0,0,56,0);

mtep_disk20
:array[0..466] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,84,0,0,0,0,1,65,0,0,0,10,85,0,0,0,1,65,0,0,0,8,0,0,0,0,1,59,0,0,0,10,80,0,0,0,1,59,0,0,0,7,0,0,0,0,1,58,0,0,0,12,75,0,0,0,1,58,0,0,0,5,0,0,0,0,1,58,0,0,0,14,70,0,0,0,1,58,0,0,0,4,0,0,0,0,1,53,0,0,0,14,65,0,0,0,1,53,0,0,0,3,0,0,0,0,1,186,0,0,0,1,187,0,0,0,1,186,0,0,0,3,187,0,0,0,1,186,0,0,0,4,187,0,0,0,1,186,0,0,0,4,187,0,0,0,1,186,0,0,0,1,175,0,0,0,2,0,0,0,0,1,202,0,0,0,1,203,0,0,0,1,202,0,0,0,1,203,0,0,0,1,202,0,0,0,1,203,0,0,0,1,202,0,0,0,3,203,0,0,0,1,202,0,0,0,2,203,0,0,0,1,202,0,0,0,2,203,0,0,0,1,202,0,0,0,1,203,0,0,0,2,0,0,0,0,18,199,0,0,0,2,0,0,0,0,1,189,0,0,0,1,188,0,0,0,1,0,0,0,0,1,71,0,0,0,3,188,0,0,0,5,189,0,0,0,2,188,0,0,0,2,189,0,0,0,1,188,0,0,0,1,189,0,0,0,2,0,0,0,0,2,178,0,0,0,1,68,0,0,0,1,134,0,0,0,2,178,0,0,0,1,177,0,0,0,11,178,0,0,0,2,0,0,0,0,1,173,0,0,0,1,172,0,0,0,2,173,0,0,0,6,172,0,0,0,1,173,0,0,0,1,172,0,0,0,1,173,0,0,0,1,172,0,0,0,1,173,0,0,0,3,172,0,0,0,2,0,0,0,0,10,162,0,0,0,1,161,0,0,
0,7,162,0,0,0,2,0,0,0,0,1,78,0,0,0,10,81,0,0,0,1,80,0,0,0,5,81,0,0,0,1,80,0,0,0,61,0);

mtep_removable20
:array[0..516] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,32,0,0,0,0,1,27,0,0,0,7,132,0,0,0,11,0,0,0,0,1,27,0,0,0,1,132,0,0,0,1,27,0,0,0,16,0,0,0,0,1,27,0,0,0,2,132,0,0,0,11,0,0,0,0,1,65,0,0,0,10,85,0,0,0,1,65,0,0,0,8,0,0,0,0,1,59,0,0,0,10,80,0,0,0,1,59,0,0,0,7,0,0,0,0,1,58,0,0,0,12,75,0,0,0,1,58,0,0,0,5,0,0,0,0,1,58,0,0,0,14,70,0,0,0,1,58,0,0,0,4,0,0,0,0,1,53,0,0,0,14,65,0,0,0,1,53,0,0,0,3,0,0,0,0,1,186,0,0,0,1,187,0,0,0,1,186,0,0,0,3,187,0,0,0,1,186,0,0,0,4,187,0,0,0,1,186,0,0,0,4,187,0,0,0,1,186,0,0,0,1,175,0,0,0,2,0,0,0,0,1,202,0,0,0,1,203,0,0,0,1,202,0,0,0,1,203,0,0,0,1,202,0,0,0,1,203,0,0,0,1,202,0,0,0,3,203,0,0,0,1,202,0,0,0,2,203,0,0,0,1,202,0,0,0,2,203,0,0,0,1,202,0,0,0,1,203,0,0,0,2,0,0,0,0,18,199,0,0,0,2,0,0,0,0,1,189,0,0,0,1,188,0,0,0,1,0,0,0,0,1,71,0,0,0,3,188,0,0,0,5,189,0,0,0,2,188,0,0,0,2,189,0,0,0,1,188,0,0,0,1,189,0,0,0,2,0,0,0,0,2,178,0,0,0,1,68,0,0,0,1,134,0,0,0,2,178,0,0,0,1,177,0,0,0,11,178,0,0,0,2,0,0,0,0,1,173,0,0,0,1,172,0,0,0,2,173,0,0,0,6,172,
0,0,0,1,173,0,0,0,1,172,0,0,0,1,173,0,0,0,1,172,0,0,0,1,173,0,0,0,3,172,0,0,0,2,0,0,0,0,10,162,0,0,0,1,161,0,0,0,7,162,0,0,0,2,0,0,0,0,1,78,0,0,0,10,81,0,0,0,1,80,0,0,0,5,81,0,0,0,1,80,0,0,0,61,0);

mtep_cd20
:array[0..616] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,56,0,0,0,0,1,27,0,0,0,5,168,0,0,0,1,27,0,0,0,8,0,0,0,0,1,27,0,0,0,2,168,0,0,0,1,52,0,0,0,3,64,0,0,0,1,52,0,0,0,2,168,0,0,0,1,27,0,0,0,5,0,0,0,0,1,27,0,0,0,1,168,0,0,0,1,52,0,0,0,7,76,0,0,0,1,52,0,0,0,1,168,0,0,0,1,27,0,0,0,4,0,0,0,0,1,168,0,0,0,1,52,0,0,0,9,89,0,0,0,1,52,0,0,0,1,168,0,0,0,3,0,0,0,0,1,27,0,0,0,1,168,0,0,0,10,102,0,0,0,1,27,0,0,0,1,168,0,0,0,1,27,0,0,0,2,0,0,0,0,1,168,0,0,0,1,52,0,0,0,4,115,0,0,0,1,52,0,0,0,1,168,0,0,0,1,52,0,0,0,3,115,0,0,0,1,181,0,0,0,1,52,0,0,0,1,168,0,0,0,2,0,0,0,0,1,168,0,0,0,4,128,0,0,0,1,52,0,0,0,1,168,0,0,0,1,27,0,0,0,1,168,0,0,0,1,52,0,0,0,4,173,0,0,0,1,168,0,0,0,2,0,0,0,0,1,168,0,0,0,4,140,0,0,0,1,168,0,0,0,1,27,0,0,0,1,0,0,0,0,1,27,0,0,0,1,168,0,0,0,4,165,0,0,0,1,168,0,0,0,2,0,0,0,0,1,168,0,0,0,4,153,0,0,0,1,52,0,0,0,1,168,0,0,0,1,27,0,0,0,1,168,0,0,0,1,52,0,0,0,4,156,0,0,0,1,168,0,0,0,2,0,0,0,0,1,168,0,0,0,1,52,0,0,0,1,166,0,0,0,3,148,0,0,0,1,52,0,0,0,1,168,0,0,0,1,52,
0,0,0,4,148,0,0,0,1,52,0,0,0,1,168,0,0,0,2,0,0,0,0,1,27,0,0,0,1,168,0,0,0,11,140,0,0,0,1,168,0,0,0,1,27,0,0,0,3,0,0,0,0,1,168,0,0,0,1,52,0,0,0,9,132,0,0,0,1,52,0,0,0,1,168,0,0,0,4,0,0,0,0,1,27,0,0,0,1,168,0,0,0,1,52,0,0,0,7,123,0,0,0,1,52,0,0,0,1,168,0,0,0,1,27,0,0,0,5,0,0,0,0,1,27,0,0,0,2,168,0,0,0,1,52,0,0,0,4,115,0,0,0,1,52,0,0,0,1,168,0,0,0,1,27,0,0,0,8,0,0,0,0,1,27,0,0,0,6,168,0,0,0,1,27,0,0,0,38,0);

mtep_frame20
:array[0..511] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,55,0,0,0,0,1,41,0,0,0,14,191,0,0,0,1,41,0,0,0,2,0,0,0,0,1,191,0,0,0,14,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,41,0,0,0,10,191,0,0,0,1,41,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,10,0,0,0,0,1,191,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,1,0,0,0,0,
1,41,0,0,0,10,191,0,0,0,1,41,0,0,0,1,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,191,0,0,0,14,0,0,0,0,1,191,0,0,0,2,0,0,0,0,1,41,0,0,0,14,191,0,0,0,1,41,0,0,0,55,0);

mtep_background20
:array[0..421] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,0,0,0,13,0,0,0,0,5,149,0,0,0,12,0,0,0,0,6,141,0,0,0,12,0,0,0,0,6,133,0,0,0,12,0,0,0,0,6,125,0,0,0,13,0,0,0,0,5,118,0,0,0,14,0,0,0,0,3,111,0,0,0,3,0,0,0,0,1,48,0,0,0,3,191,0,0,0,1,48,0,0,0,12,0,0,0,0,1,48,0,0,0,1,191,0,0,0,3,115,0,0,0,2,191,0,0,0,1,48,0,0,0,9,0,0,0,0,1,48,0,0,0,2,191,0,0,0,5,105,0,0,0,2,191,0,0,0,1,48,0,0,0,7,0,0,0,0,1,191,0,0,0,8,96,0,0,0,3,191,0,0,0,1,48,0,0,0,5,0,0,0,0,1,191,0,0,0,11,87,0,0,0,2,191,0,0,0,1,48,0,0,0,3,0,0,0,0,14,77,0,0,0,3,191,0,0,0,1,48,0,0,0,17,67,0,0,0,1,191,0,0,0,10,58,0,0,0,2,191,0,0,0,6,58,0,0,0,8,48,0,0,0,2,191,0,0,0,1,48,0,0,0,1,191,0,0,0,6,48,0,0,0,6,39,0,0,0,2,191,0,0,0,1,48,0,0,0,2,0,0,0,0,1,48,0,0,0,2,191,0,0,0,4,39,0,0,0,4,29,0,0,0,2,191,0,0,0,1,48,0,0,0,5,0,0,0,0,1,48,0,0,0,2,191,0,0,0,3,29,0,0,0,2,19,0,0,0,2,191,0,0,0,1,48,0,0,0,9,0,0,0,0,1,48,0,0,0,2,191,0,0,0,1,19,0,0,0,2,191,0,0,0,1,48,0,0,0,13,0,0,0,0,1,48,0,0,0,1,191,0,0,0,18,0);

mtep_squircle20
:array[0..331] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,53,0,0,0,0,1,42,0,0,0,11,189,0,0,0,1,42,0,0,0,3,0,0,0,0,1,42,0,0,0,1,189,0,0,0,11,0,0,0,0,1,189,0,0,0,1,42,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,42,0,0,0,1,189,0,0,0,11,0,0,0,0,1,189,0,0,0,1,42,0,0,0,3,0,0,0,0,1,42,0,0,0,11,189,0,0,0,1,42,0,0,0,53,0);

mtep_diamond20
:array[0..451] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,41,0,0,0,0,1,56,0,0,0,1,255,0,0,0,1,56,0,0,0,13,0,0,0,0,1,56,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,56,0,0,0,11,0,0,0,0,1,56,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,56,0,0,0,9,0,0,0,0,1,56,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,56,0,0,0,7,0,0,0,0,1,56,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,1,56,0,0,0,5,0,0,0,0,1,56,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,1,56,0,0,0,3,0,0,0,0,1,56,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,1,56,0,0,0,2,0,0,0,0,1,255,0,0,0,13,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,56,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,1,56,0,0,0,3,0,0,0,0,1,56,0,0,0,1,255,0,0,0,9,0,0,0,0,1,255,0,0,0,1,56,0,0,0,5,0,0,0,0,1,56,0,0,0,1,255,0,0,0,7,0,0,0,0,1,255,0,0,0,1,56,0,0,0,7,0,0,0,0,1,56,0,0,0,1,255,0,0,0,5,0,0,0,0,1,255,0,0,0,1,56,0,0,0,9,0,0,0,0,1,56,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,56,0,0,0,11,0,0,0,0,1,56,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,56,0,0,0,13,0,0,0,0,1,56,0,0,0,1,255,0,0,0,1,
56,0,0,0,58,0);

mtep_circle20
:array[0..471] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,56,0,0,0,0,1,70,0,0,0,5,189,0,0,0,1,70,0,0,0,8,0,0,0,0,1,70,0,0,0,2,189,0,0,0,1,48,0,0,0,3,0,0,0,0,1,48,0,0,0,2,189,0,0,0,1,70,0,0,0,5,0,0,0,0,1,70,0,0,0,1,189,0,0,0,1,48,0,0,0,7,0,0,0,0,1,48,0,0,0,1,189,0,0,0,1,70,0,0,0,4,0,0,0,0,1,189,0,0,0,1,48,0,0,0,9,0,0,0,0,1,48,0,0,0,1,189,0,0,0,3,0,0,0,0,1,70,0,0,0,1,189,0,0,0,11,0,0,0,0,1,189,0,0,0,1,70,0,0,0,2,0,0,0,0,1,189,0,0,0,1,48,0,0,0,11,0,0,0,0,1,48,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,1,48,0,0,0,11,0,0,0,0,1,48,0,0,0,1,189,0,0,0,2,0,0,0,0,1,70,0,0,0,1,189,0,0,0,11,0,0,0,0,1,189,0,0,0,1,70,0,0,0,3,0,0,0,0,1,189,0,0,0,1,48,0,0,0,9,0,0,0,0,1,48,0,0,0,1,189,0,0,0,4,0,0,0,0,1,70,0,0,0,1,189,0,0,0,1,48,0,0,0,7,0,0,0,0,1,48,0,0,0,1,189,0,0,0,1,70,0,0,0,5,0,0,0,0,1,70,0,0,0,2,189,0,0,0,1,48,0,0,0,3,0,0,0,0,1,48,0,0,0,2,189,0,0,0,1,
70,0,0,0,8,0,0,0,0,1,70,0,0,0,5,189,0,0,0,1,70,0,0,0,39,0);

mtep_square20
:array[0..291] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,52,0,0,0,0,15,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,189,0,0,0,13,0,0,0,0,1,189,0,0,0,2,0,0,0,0,15,189,0,0,0,52,0);

mtep_solid20
:array[0..171] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,52,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,52,0);

mtep_transparent20
:array[0..251] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,54,0,0,0,0,13,189,0,0,0,4,0,0,0,0,13,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,4,189,0,0,0,8,0,0,0,0,3,189,0,0,0,2,0,0,0,0,4,189,0,0,0,8,0,0,0,0,3,189,0,0,0,2,0,0,0,0,7,189,0,0,0,2,0,0,0,0,6,189,0,0,0,2,0,0,0,0,7,189,0,0,0,2,0,0,0,0,6,189,0,0,0,2,0,0,0,0,7,189,0,0,0,2,0,0,0,0,6,189,0,0,0,2,0,0,0,0,7,189,0,0,0,2,0,0,0,0,6,189,0,0,0,2,0,0,0,0,7,189,0,0,0,2,0,0,0,0,6,189,0,0,0,2,0,0,0,0,7,189,0,0,0,2,0,0,0,0,6,189,0,0,0,2,0,0,0,0,15,189,0,0,0,2,0,0,0,0,15,189,0,0,0,52,0);

mtep__mid20//11aug2025
:array[0..311] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,78,0,0,0,0,6,255,0,0,0,11,0,0,0,0,6,255,0,0,0,11,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,9,145,0,0,0,1,255,0,0,0,4,145,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,4,145,0,0,0,1,255,0,0,0,4,145,0,0,0,1,255,0,0,0,4,145,0,0,0,1,255,0,0,0,6,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,4,145,0,0,0,1,255,0,0,0,3,145,0,0,0,2,255,0,0,0,3,145,0,0,0,2,255,0,0,0,6,0,0,0,0,1,255,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,4,145,0,0,0,1,255,0,0,0,3,145,0,0,0,2,255,0,0,0,3,145,0,0,0,2,255,0,0,0,4,0,0,0,0,3,255,0,0,0,14,0,0,0,0,2,255,0,0,0,80,0);

mtep__asis20
:array[0..571] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,37,0,0,0,0,1,47,0,0,0,4,189,0,0,0,1,106,0,0,0,11,0,0,0,0,1,189,0,0,0,1,47,0,0,0,2,0,0,0,0,1,47,0,0,0,2,189,0,0,0,1,106,0,0,0,2,0,0,0,0,1,106,0,0,0,1,189,0,0,0,1,47,0,0,0,4,0,0,0,0,1,189,0,0,0,1,47,0,0,0,3,0,0,0,0,1,47,0,0,0,2,189,0,0,0,1,106,0,0,0,2,189,0,0,0,1,47,0,0,0,1,189,0,0,0,4,0,0,0,0,1,106,0,0,0,1,189,0,0,0,5,0,0,0,0,1,47,0,0,0,1,189,0,0,0,1,47,0,0,0,2,0,0,0,0,1,189,0,0,0,5,0,0,0,0,1,189,0,0,0,10,0,0,0,0,1,189,0,0,0,4,0,0,0,0,1,106,0,0,0,1,189,0,0,0,10,0,0,0,0,1,189,0,0,0,3,0,0,0,0,1,106,0,0,0,1,189,0,0,0,1,47,0,0,0,10,0,0,0,0,1,189,0,0,0,2,0,0,0,0,1,106,0,0,0,2,189,0,0,0,11,0,0,0,0,1,189,0,0,0,2,0,0,0,0,2,189,0,0,0,1,47,0,0,0,11,0,0,0,0,1,189,0,0,0,3,0,0,0,0,1,106,0,0,0,1,189,0,0,0,1,47,0,0,0,10,0,0,0,0,1,189,0,0,0,4,0,0,0,0,1,106,0,0,0,2,189,0,0,0,1,47,0,0,0,5,0,0,0,0,2,189,0,0,0,1,47,0,0,0,1,189,0,0,0,6,0,0,0,0,1,106,0,0,0,2,189,0,0,0,4,0,0,0,0,1,189,0,0,0,1,106,0,0,0,1,189,0,0,0,1,47,0,0,0,7,0,0,0,
0,1,189,0,0,0,1,47,0,0,0,3,0,0,0,0,1,47,0,0,0,1,189,0,0,0,1,0,0,0,0,1,47,0,0,0,8,0,0,0,0,1,189,0,0,0,4,0,0,0,0,1,189,0,0,0,1,106,0,0,0,9,0,0,0,0,1,47,0,0,0,1,189,0,0,0,3,0,0,0,0,1,47,0,0,0,1,189,0,0,0,10,0,0,0,0,1,189,0,0,0,2,47,0,0,0,3,189,0,0,0,11,0,0,0,0,1,47,0,0,0,2,189,0,0,0,1,47,0,0,0,25,0);

mtep_menu20
:array[0..211] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,20,0,0,0,0,0,0,121,0,0,0,0,1,137,0,0,0,1,255,0,0,0,1,137,0,0,0,2,0,0,0,0,1,137,0,0,0,1,255,0,0,0,1,137,0,0,0,2,0,0,0,0,1,137,0,0,0,1,255,0,0,0,1,137,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,3,255,0,0,0,2,0,0,0,0,1,137,0,0,0,1,255,0,0,0,1,137,0,0,0,2,0,0,0,0,1,137,0,0,0,1,255,0,0,0,1,137,0,0,0,2,0,0,0,0,1,137,0,0,0,1,255,0,0,0,1,137,0,0,0,121,0);

mtep_tick20
:array[0..611] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,65,0,0,0,0,1,107,0,0,0,2,255,0,0,0,1,107,0,0,0,1,0,0,0,0,1,107,0,0,0,3,255,0,0,0,1,107,0,0,0,6,0,0,0,0,1,255,0,0,0,2,107,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,107,0,0,0,1,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,5,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,6,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,5,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,
255,0,0,0,4,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,4,0,0,0,0,1,255,0,0,0,2,107,0,0,0,1,255,0,0,0,1,0,0,0,0,1,255,0,0,0,1,107,0,0,0,1,0,0,0,0,1,107,0,0,0,1,255,0,0,0,1,107,0,0,0,5,0,0,0,0,1,107,0,0,0,2,255,0,0,0,1,107,0,0,0,1,0,0,0,0,1,107,0,0,0,3,255,0,0,0,1,107,0,0,0,69,0);

mtep_untick20
:array[0..271] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,20,0,0,0,0,0,0,65,0,0,0,0,1,107,0,0,0,2,255,0,0,0,1,107,0,0,0,12,0,0,0,0,1,255,0,0,0,2,107,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,12,0,0,0,0,1,255,0,0,0,2,107,0,0,0,1,255,0,0,0,12,0,0,0,0,1,107,0,0,0,2,255,0,0,0,1,107,0,0,0,75,0);

mtep_help20
:array[0..331] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,20,0,0,0,0,0,0,39,0,0,0,0,1,96,0,0,0,4,255,0,0,0,1,139,0,0,0,4,0,0,0,0,1,38,0,0,0,1,230,0,0,0,1,243,0,0,0,1,68,0,0,0,2,0,0,0,0,1,38,0,0,0,1,230,0,0,0,1,179,0,0,0,3,0,0,0,0,1,38,0,0,0,1,218,0,0,0,1,68,0,0,0,4,0,0,0,0,1,38,0,0,0,1,230,0,0,0,1,96,0,0,0,2,0,0,0,0,1,23,0,0,0,1,193,0,0,0,1,68,0,0,0,5,0,0,0,0,2,179,0,0,0,10,0,0,0,0,1,139,0,0,0,1,179,0,0,0,9,0,0,0,0,1,23,0,0,0,1,205,0,0,0,1,139,0,0,0,8,0,0,0,0,1,23,0,0,0,1,205,0,0,0,1,230,0,0,0,1,38,0,0,0,6,0,0,0,0,1,23,0,0,0,1,205,0,0,0,1,255,0,0,0,1,179,0,0,0,8,0,0,0,0,1,139,0,0,0,1,179,0,0,0,10,0,0,0,0,1,139,0,0,0,1,179,0,0,0,33,0,0,0,0,1,139,0,0,0,2,255,0,0,0,1,205,0,0,0,1,23,0,0,0,7,0,0,0,0,1,96,0,0,0,2,255,0,0,0,1,205,0,0,0,1,23,0,0,0,39,0);

mtep_helphint
:array[0..141] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,12,0,0,0,0,0,0,13,0,0,0,0,3,255,0,0,0,6,0,0,0,0,5,255,0,0,0,5,0,0,0,0,2,255,0,0,0,2,0,0,0,0,2,255,0,0,0,4,0,0,0,0,1,255,0,0,0,3,0,0,0,0,2,255,0,0,0,7,0,0,0,0,3,255,0,0,0,6,0,0,0,0,3,255,0,0,0,7,0,0,0,0,2,255,0,0,0,18,0,0,0,0,2,255,0,0,0,8,0,0,0,0,2,255,0,0,0,14,0);


tep_copy20:array[0..320] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,0,0,46,64,138,213,5,255,0,0,9,64,138,213,1,217,235,255,4,64,138,213,2,255,0,0,8,64,138,213,1,217,235,255,4,64,138,213,1,217,235,255,1,64,138,213,1,255,0,0,7,64,138,213,1,217,235,255,1,64,138,213,2,217,235,255,1,64,138,213,7,255,0,0,3,64,138,213,1,217,235,255,5,64,138,213,1,217,235,255,4,64,138,213,2,255,0,0,2,64,138,213,1,217,235,255,1,64,138,213,5,217,235,255,4,64,138,213,1,217,235,255,1,64,138,213,1,255,0,0,1,64,138,213,1,217,235,255,5,64,138,213,1,217,235,255,1,64,138,213,2,217,235,255,1,64,138,213,5,217,235,255,1,64,138,213,5,217,235,255,7,64,138,213,2,217,235,255,5,64,138,213,1,217,235,255,1,64,138,213,5,217,235,255,1,64,138,213,2,217,235,255,1,64,138,213,5,217,235,255,7,64,138,213,2,217,235,255,5,64,138,213,1,217,235,255,1,64,138,213,5,217,235,255,1,64,138,213,1,255,0,0,1,64,138,213,6,217,235,255,7,64,138,213,1,255,0,0,6,64,138,213,1,217,235,255,1,64,138,213,5,217,235,255,1,64,138,213,1,255,0,0,6,64,138,213,1,217,235,
255,7,64,138,213,1,255,0,0,7,64,138,213,7,255,0,0,31);
tep_selectall20:array[0..216] of byte=(
84,69,65,49,35,11,0,0,0,20,0,0,0,192,192,192,34,64,138,213,7,192,192,192,3,64,138,213,1,217,235,255,6,64,138,213,2,192,192,192,2,64,138,213,1,217,235,255,6,64,138,213,1,217,235,255,1,64,138,213,1,192,192,192,1,64,138,213,1,217,235,255,1,64,138,213,4,217,235,255,2,64,138,213,4,217,235,255,1,64,138,213,5,217,235,255,3,64,138,213,2,217,235,255,1,64,138,213,6,217,235,255,2,64,138,213,2,217,235,255,1,64,138,213,7,217,235,255,1,64,138,213,2,217,235,255,1,64,138,213,7,217,235,255,1,64,138,213,2,217,235,255,1,64,138,213,7,217,235,255,1,64,138,213,2,217,235,255,1,64,138,213,7,217,235,255,1,64,138,213,2,217,235,255,1,64,138,213,7,217,235,255,1,64,138,213,2,217,235,255,9,64,138,213,1,192,192,192,1,64,138,213,9,192,192,192,45);
tep_blank20:array[0..20] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,245,150,0,250,245,150,0,150);
tep_clock20:array[0..280] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,0,255,0,50,0,0,255,5,0,255,0,8,0,0,255,2,253,253,253,5,0,0,255,2,0,255,0,5,0,0,255,1,253,253,253,4,0,0,0,1,253,253,253,4,0,0,255,1,0,255,0,3,0,0,255,1,253,253,253,5,0,0,0,1,253,253,253,5,0,0,255,1,0,255,0,2,0,0,255,1,253,253,253,5,0,0,0,1,253,253,253,5,0,0,255,1,0,255,0,1,0,0,255,1,253,253,253,6,0,0,0,1,253,253,253,6,0,0,255,2,253,253,253,6,0,0,0,1,253,253,253,6,0,0,255,3,253,253,253,4,0,0,0,6,253,253,253,1,0,0,255,3,253,253,253,6,0,0,0,1,253,253,253,6,0,0,255,2,253,253,253,6,0,0,0,1,253,253,253,6,0,0,255,1,0,255,0,1,0,0,255,1,253,253,253,11,0,0,255,1,0,255,0,2,0,0,255,1,253,253,253,11,0,0,255,1,0,255,0,3,0,0,255,1,253,253,253,9,0,0,255,1,0,255,0,5,0,0,255,2,253,253,253,2,0,0,255,1,253,253,253,2,0,0,255,2,0,255,0,8,0,0,255,5,0,255,0,35);
tep_alert20:array[0..296] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,0,255,0,34,128,0,255,2,0,255,0,12,128,0,255,2,0,255,0,11,128,0,255,1,255,255,199,2,128,0,255,1,0,255,0,10,128,0,255,1,255,255,199,2,128,0,255,1,0,255,0,9,128,0,255,1,255,255,199,4,128,0,255,1,0,255,0,8,128,0,255,1,255,255,199,1,255,0,128,2,255,255,199,1,128,0,255,1,0,255,0,7,128,0,255,1,255,255,199,2,255,0,128,2,255,255,199,2,128,0,255,1,0,255,0,6,128,0,255,1,255,255,199,2,255,0,128,2,255,255,199,2,128,0,255,1,0,255,0,5,128,0,255,1,255,255,199,3,255,0,128,2,255,255,199,3,128,0,255,1,0,255,0,4,128,0,255,1,255,255,199,3,255,0,128,2,255,255,199,3,128,0,255,1,0,255,0,3,128,0,255,1,255,255,199,4,255,0,128,2,255,255,199,4,128,0,255,1,0,255,0,2,128,0,255,1,255,255,199,10,128,0,255,1,0,255,0,2,128,0,255,1,255,255,199,4,255,0,128,2,255,255,199,4,128,0,255,1,0,255,0,1,128,0,255,1,255,255,199,5,255,0,128,2,255,255,199,5,128,0,255,2,255,255,199,12,128,0,255,15,0,255,0,28);
tep_left20:array[0..288] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,0,255,128,22,85,0,170,7,0,255,128,12,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,12,85,0,170,7,0,255,128,31);
tep_right20:array[0..288] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,0,255,128,31,85,0,170,7,0,255,128,12,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,11,85,0,170,1,128,0,255,7,85,0,170,1,0,255,128,12,85,0,170,7,0,255,128,22);
tep_top20:array[0..144] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,0,255,128,22,85,0,170,16,0,255,128,3,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,3,85,0,170,16,0,255,128,202);
tep_bottom20:array[0..144] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,0,255,128,202,85,0,170,16,0,255,128,3,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,2,85,0,170,1,128,0,255,16,85,0,170,1,0,255,128,3,85,0,170,16,0,255,128,22);
tep_frame20:array[0..248] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,255,255,38,128,0,255,15,255,255,255,2,128,0,255,15,255,255,255,3,128,0,255,2,255,0,255,13,255,255,255,3,128,0,255,2,255,0,255,12,255,255,255,4,128,0,255,2,255,0,255,2,219,219,0,9,255,255,255,5,128,0,255,2,255,0,255,2,219,219,0,8,255,255,255,6,128,0,255,2,255,0,255,2,219,219,0,2,255,255,255,12,128,0,255,2,255,0,255,2,219,219,0,2,255,255,255,12,128,0,255,2,255,0,255,2,219,219,0,2,255,255,255,12,128,0,255,2,255,0,255,2,219,219,0,2,255,255,255,12,128,0,255,2,255,0,255,2,219,219,0,2,255,255,255,12,128,0,255,2,255,0,255,2,219,219,0,2,255,255,255,12,128,0,255,2,255,0,255,2,219,219,0,2,255,255,255,12,128,0,255,2,255,0,255,2,219,219,0,1,255,255,255,13,128,0,255,2,255,0,255,2,255,255,255,14,128,0,255,2,255,0,255,1,255,255,255,15,128,0,255,1,255,255,255,34);
tep_wine20:array[0..420] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,0,255,255,17,173,168,166,1,186,182,179,4,145,149,146,1,0,255,255,6,146,149,147,1,186,182,179,1,242,233,232,5,186,182,179,1,0,255,255,6,186,182,179,1,242,233,232,4,230,213,214,1,212,192,191,1,163,148,148,1,0,255,255,6,162,165,162,1,220,216,214,1,242,233,232,2,235,219,219,1,217,186,189,1,151,66,78,1,122,39,52,1,0,255,255,7,196,183,183,1,221,201,202,1,222,200,200,1,214,175,179,1,147,50,63,1,132,20,39,1,116,8,26,1,93,19,29,1,0,255,255,6,138,81,89,1,196,150,156,1,175,109,117,1,152,42,57,1,148,18,37,1,137,3,23,1,129,6,25,1,105,13,28,1,0,255,255,6,106,47,56,1,168,108,119,1,160,55,71,1,159,20,37,1,160,3,20,1,155,3,21,1,142,4,24,1,107,10,25,1,0,255,255,7,130,51,66,1,183,95,108,1,173,26,43,1,171,2,18,2,150,3,22,1,110,9,25,1,0,255,255,7,106,31,45,1,168,86,98,1,181,48,62,1,171,2,18,2,152,3,21,1,110,10,25,1,0,255,255,8,128,40,54,1,179,75,88,1,167,14,31,1,160,4,21,1,145,5,24,1,109,13,28,1,0,255,255,8,137,115,116,1,132,37,53,1,151,29,47,1,143,4,24,1,127,8,25,1,100,21,34,1,0,255,
255,9,113,90,93,1,119,33,48,1,132,36,52,1,123,38,51,1,0,255,255,12,151,132,133,1,143,133,132,1,0,255,255,13,141,148,144,1,0,255,255,13,122,131,127,1,0,255,255,13,141,147,143,1,0,255,255,13,169,174,170,1,168,173,168,1,0,255,255,11,184,182,179,1,194,200,194,6,0,255,255,5,160,149,148,1,194,200,194,6,0,255,255,2);
tep_zoom20:array[0..380] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,192,192,192,6,0,0,255,4,192,192,192,14,0,0,255,2,255,255,170,4,0,0,255,2,192,192,192,11,0,0,255,1,255,255,170,2,255,255,255,4,255,255,170,1,215,215,0,1,0,0,255,1,192,192,192,9,0,0,255,1,255,255,170,1,255,255,255,7,255,255,170,2,0,0,255,1,192,192,192,7,0,0,255,1,215,215,0,1,255,255,170,1,255,255,255,8,255,255,170,2,0,0,255,1,192,192,192,6,0,0,255,1,215,215,0,1,255,255,255,10,255,255,170,1,0,0,255,1,192,192,192,5,0,0,255,1,215,215,0,1,255,255,255,12,255,255,170,1,0,0,255,1,192,192,192,4,0,0,255,1,215,215,0,1,255,255,255,12,255,255,170,1,0,0,255,1,192,192,192,4,0,0,255,1,215,215,0,1,255,255,255,12,255,255,170,1,0,0,255,1,192,192,192,5,0,0,255,1,215,215,0,1,255,255,255,10,215,215,0,1,0,0,255,1,192,192,192,6,0,0,255,1,215,215,0,2,255,255,255,8,215,215,0,2,0,0,255,1,192,192,192,7,0,0,255,1,215,215,0,2,255,255,255,6,215,215,0,2,0,0,255,1,192,192,192,9,0,0,255,1,215,215,0,2,255,255,255,4,215,215,0,2,0,0,255,3,192,192,192,9,0,0,255,2,215,215,0,4,0,0,255,6,192,192,192,10,0,
0,255,4,192,192,192,3,0,0,255,4,192,192,192,17,0,0,255,4,192,192,192,17,0,0,255,4,192,192,192,17,0,0,255,4,192,192,192,17,0,0,255,3,192,192,192,18,0,0,255,2);
tep_sizeto20:array[0..208] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,49,64,138,213,14,255,0,0,1,64,138,213,33,255,255,255,14,64,138,213,2,255,255,255,14,64,138,213,2,255,255,255,3,64,138,213,1,255,255,255,10,64,138,213,2,255,255,255,2,64,138,213,3,255,255,255,9,64,138,213,2,255,255,255,1,64,138,213,5,255,255,255,8,64,138,213,2,255,255,255,3,64,138,213,1,255,255,255,5,64,138,213,1,255,255,255,4,64,138,213,2,255,255,255,3,64,138,213,1,255,255,255,5,64,138,213,2,255,255,255,3,64,138,213,2,255,255,255,3,64,138,213,9,255,255,255,2,64,138,213,2,255,255,255,9,64,138,213,2,255,255,255,3,64,138,213,2,255,255,255,9,64,138,213,1,255,255,255,4,64,138,213,2,255,255,255,14,64,138,213,1,255,0,0,1,64,138,213,14,255,0,0,33);
tep_upper20:array[0..172] of byte=(
84,69,65,49,35,13,0,0,0,20,0,0,0,252,252,252,54,107,30,224,6,252,252,252,7,107,30,224,6,252,252,252,9,107,30,224,2,252,252,252,1,107,30,224,2,252,252,252,8,107,30,224,2,252,252,252,1,107,30,224,2,252,252,252,7,107,30,224,3,252,252,252,1,107,30,224,3,252,252,252,6,107,30,224,2,252,252,252,3,107,30,224,2,252,252,252,6,107,30,224,2,252,252,252,3,107,30,224,2,252,252,252,5,107,30,224,4,255,0,128,5,252,252,252,4,255,0,128,9,252,252,252,3,255,0,128,2,252,252,252,7,255,0,128,2,252,252,252,1,255,0,128,5,252,252,252,3,255,0,128,10,252,252,252,3,255,0,128,5,252,252,252,52);
tep_lower20:array[0..120] of byte=(
84,69,65,49,35,11,0,0,0,20,0,0,0,252,252,252,79,0,128,255,7,252,252,252,3,0,128,255,9,252,252,252,9,0,128,255,2,252,252,252,4,0,128,255,7,252,252,252,2,255,128,0,5,0,128,255,4,252,252,252,1,255,128,0,3,252,252,252,5,255,128,0,1,0,128,255,1,252,252,252,1,255,128,0,2,252,252,252,5,255,128,0,3,252,252,252,1,255,128,0,11,252,252,252,1,255,128,0,6,252,252,252,1,255,128,0,3,252,252,252,44);
tep_name20:array[0..300] of byte=(
84,69,65,49,35,19,0,0,0,20,0,0,0,252,252,252,88,255,0,128,2,252,252,252,9,128,0,255,3,252,252,252,5,255,0,128,2,252,252,252,9,128,0,255,3,252,252,252,5,255,0,128,2,252,252,252,8,128,0,255,2,252,252,252,1,128,0,255,2,252,252,252,4,255,0,128,2,252,252,252,8,128,0,255,2,252,252,252,1,128,0,255,2,252,252,252,4,255,0,128,2,252,252,252,1,255,0,128,3,252,252,252,3,128,0,255,3,252,252,252,1,128,0,255,3,252,252,252,3,255,0,128,7,252,252,252,2,128,0,255,2,252,252,252,3,128,0,255,2,252,252,252,3,255,0,128,2,252,252,252,3,255,0,128,2,252,252,252,2,128,0,255,7,252,252,252,3,255,0,128,2,252,252,252,3,255,0,128,2,252,252,252,1,128,0,255,9,252,252,252,2,255,0,128,2,252,252,252,3,255,0,128,2,252,252,252,1,128,0,255,2,252,252,252,5,128,0,255,2,252,252,252,2,255,0,128,2,252,252,252,3,255,0,128,2,128,0,255,3,252,252,252,5,128,0,255,3,252,252,252,1,255,0,128,6,252,252,252,1,128,0,255,2,252,252,252,7,128,0,255,2,252,252,252,1,255,0,128,2,252,252,252,1,255,0,128,3,252,252,252,77);
tep_eye20:array[0..408] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,0,255,64,49,255,155,205,4,0,255,64,10,255,155,205,1,255,0,128,4,255,155,205,1,0,255,64,8,255,155,205,1,255,0,128,1,255,155,205,4,255,0,128,1,255,155,205,1,0,255,64,6,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,1,255,155,205,1,0,255,64,2,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,4,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,1,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,2,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,3,255,155,205,1,255,0,128,1,255,155,205,2,255,0,128,1,255,155,205,1,0,255,64,3,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,3,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,1,255,155,205,1,0,255,64,4,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,3,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,6,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,4,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,4,255,155,205,1,255,0,128,1,255,155,205,1,0,255,64,6,255,155,205,1,255,0,128,1,255,155,205,4,255,0,128,3,255,155,205,1,0,255,
64,6,255,155,205,1,255,0,128,4,255,155,205,1,255,0,128,3,255,155,205,1,0,255,64,6,255,155,205,4,0,255,64,1,255,155,205,1,255,0,128,3,255,155,205,1,0,255,64,11,255,155,205,1,255,0,128,3,255,155,205,1,0,255,64,11,255,155,205,1,255,0,128,2,255,155,205,1,0,255,64,12,255,155,205,2,0,255,64,31);
tep_panel20:array[0..96] of byte=(84,69,65,49,35,14,0,0,0,20,0,0,0,128,255,0,43,0,0,0,12,128,255,0,1,0,0,0,1,128,255,0,12,0,0,0,2,128,255,0,12,0,0,0,2,128,255,0,12,0,0,0,2,128,255,0,12,0,0,0,2,128,255,0,12,0,0,0,2,128,255,0,12,0,0,0,2,128,255,0,12,0,0,0,71,128,255,0,1,0,0,0,12,128,255,0,43);
tep_prev20:array[0..272] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,0,255,0,26,211,173,9,2,0,255,0,15,211,173,9,1,255,209,11,1,211,173,9,1,0,255,0,14,211,173,9,1,255,209,11,2,211,173,9,1,0,255,0,13,211,173,9,1,255,209,11,3,211,173,9,1,0,255,0,12,211,173,9,1,255,209,11,5,211,173,9,7,0,255,0,4,211,173,9,1,255,209,11,12,211,173,9,1,0,255,0,3,211,173,9,1,255,209,11,13,211,173,9,1,0,255,0,2,211,173,9,1,255,209,11,14,211,173,9,1,0,255,0,1,211,173,9,1,255,209,11,15,211,173,9,1,0,255,0,2,211,173,9,1,255,209,11,14,211,173,9,1,0,255,0,3,211,173,9,1,255,209,11,13,211,173,9,1,0,255,0,4,211,173,9,1,255,209,11,12,211,173,9,1,0,255,0,5,211,173,9,1,255,209,11,5,211,173,9,7,0,255,0,6,211,173,9,1,255,209,11,3,211,173,9,1,0,255,0,14,211,173,9,1,255,209,11,2,211,173,9,1,0,255,0,15,211,173,9,1,255,209,11,1,211,173,9,1,0,255,0,16,211,173,9,2,0,255,0,44);
tep_next20:array[0..272] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,0,255,0,26,211,173,9,2,0,255,0,16,211,173,9,1,255,209,11,1,211,173,9,1,0,255,0,15,211,173,9,1,255,209,11,2,211,173,9,1,0,255,0,14,211,173,9,1,255,209,11,3,211,173,9,1,0,255,0,6,211,173,9,7,255,209,11,5,211,173,9,1,0,255,0,5,211,173,9,1,255,209,11,12,211,173,9,1,0,255,0,4,211,173,9,1,255,209,11,13,211,173,9,1,0,255,0,3,211,173,9,1,255,209,11,14,211,173,9,1,0,255,0,2,211,173,9,1,255,209,11,15,211,173,9,1,0,255,0,1,211,173,9,1,255,209,11,14,211,173,9,1,0,255,0,2,211,173,9,1,255,209,11,13,211,173,9,1,0,255,0,3,211,173,9,1,255,209,11,12,211,173,9,1,0,255,0,4,211,173,9,7,255,209,11,5,211,173,9,1,0,255,0,12,211,173,9,1,255,209,11,3,211,173,9,1,0,255,0,13,211,173,9,1,255,209,11,2,211,173,9,1,0,255,0,14,211,173,9,1,255,209,11,1,211,173,9,1,0,255,0,15,211,173,9,2,0,255,0,44);
tep_up20:array[0..144] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,0,255,0,25,255,209,11,1,0,255,0,15,255,209,11,3,0,255,0,13,255,209,11,5,0,255,0,11,255,209,11,7,0,255,0,9,255,209,11,9,0,255,0,7,255,209,11,11,0,255,0,5,255,209,11,13,0,255,0,3,255,209,11,15,0,255,0,1,255,209,11,34,0,255,0,4,255,209,11,9,0,255,0,8,255,209,11,9,0,255,0,8,255,209,11,9,0,255,0,8,255,209,11,9,0,255,0,8,255,209,11,9,0,255,0,8,255,209,11,9,0,255,0,8,255,209,11,9,0,255,0,38);
tep_upone20:array[0..396] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,0,0,23,31,125,19,1,255,0,0,13,31,125,19,3,255,0,0,11,31,125,19,1,80,178,50,3,31,125,19,2,255,0,0,8,31,125,19,1,80,178,50,6,31,125,19,1,255,0,0,4,207,163,23,3,31,125,19,3,80,178,50,3,31,125,19,3,255,0,0,2,207,163,23,1,255,255,152,3,207,163,23,3,31,125,19,1,80,178,50,2,31,125,19,1,255,0,0,4,207,163,23,1,255,255,152,6,31,125,19,1,80,178,50,2,31,125,19,1,255,0,0,4,207,163,23,1,255,255,152,5,207,163,23,1,31,125,19,1,80,178,50,3,207,163,23,2,255,0,0,2,207,163,23,1,255,255,152,2,241,218,115,1,239,198,78,2,255,230,144,1,80,178,50,3,203,198,108,1,255,255,152,1,207,163,23,1,255,0,0,2,207,163,23,1,255,255,152,1,239,198,78,1,255,255,152,4,31,125,19,1,80,178,50,1,31,125,19,1,255,255,152,2,207,163,23,1,255,0,0,2,207,163,23,1,255,226,125,1,255,255,152,1,255,255,175,1,255,255,152,2,241,218,115,1,31,125,19,1,80,178,50,2,255,255,152,1,207,163,23,1,255,0,0,3,207,163,23,1,239,198,78,1,255,255,152,4,80,178,50,1,31,125,19,2,241,218,115,1,207,163,23,1,255,0,0,4,207,163,23,1,239,198,
78,1,255,255,152,4,31,125,19,1,80,178,50,1,207,163,23,2,255,0,0,5,207,163,23,1,241,218,115,1,255,255,152,2,239,198,78,2,207,163,23,2,255,0,0,7,207,163,23,1,255,230,144,1,207,163,23,3,255,0,0,10,207,163,23,2,255,0,0,57);
tep_fav20:array[0..368] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,255,0,0,10,222,179,27,1,255,0,0,18,222,179,27,1,255,241,142,1,222,179,27,1,255,0,0,17,222,179,27,1,255,241,142,1,222,179,27,1,255,0,0,17,222,179,27,1,255,241,142,1,222,179,27,1,255,0,0,17,222,179,27,1,255,241,142,1,222,179,27,2,255,0,0,15,222,179,27,1,255,241,142,3,222,179,27,1,255,0,0,15,222,179,27,1,255,241,142,3,222,179,27,1,255,0,0,7,222,179,27,9,255,241,142,3,222,179,27,9,255,241,142,19,255,0,0,1,222,179,27,2,255,241,142,16,222,179,27,1,255,0,0,4,222,179,27,1,255,241,142,10,222,179,27,3,255,0,0,7,222,179,27,2,255,241,142,8,222,179,27,1,255,0,0,9,222,179,27,2,255,241,142,7,222,179,27,1,255,0,0,10,222,179,27,1,255,241,142,9,255,0,0,10,222,179,27,1,255,241,142,9,222,179,27,1,255,0,0,9,222,179,27,1,255,241,142,3,222,179,27,3,255,241,142,3,222,179,27,1,255,0,0,8,222,179,27,2,255,241,142,2,222,179,27,1,255,0,0,3,222,179,27,1,255,241,142,2,222,179,27,2,255,0,0,7,222,179,27,1,255,241,142,2,222,179,27,1,255,0,0,5,222,179,27,1,255,241,142,2,222,179,27,1,255,0,0,7,222,
179,27,1,255,241,142,1,222,179,27,1,255,0,0,7,222,179,27,1,255,241,142,1,222,179,27,1,255,0,0,7,222,179,27,2,255,0,0,9,222,179,27,2,255,0,0,3);
tep_newfolder20:array[0..260] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,252,252,252,55,255,191,191,2,252,252,252,12,255,191,191,1,255,0,0,2,255,191,191,1,252,252,252,9,255,191,191,3,255,0,0,2,255,191,191,3,252,252,252,1,160,130,35,3,252,252,252,2,255,191,191,1,255,0,0,8,160,130,35,1,255,255,128,3,160,130,35,4,255,191,191,1,255,0,0,4,255,191,191,2,160,130,35,1,255,255,128,7,255,191,191,1,255,0,0,4,255,191,191,1,252,252,252,1,160,130,35,1,255,255,128,6,255,191,191,1,255,0,0,2,255,191,191,2,255,0,0,2,255,191,191,1,160,130,35,1,255,255,128,7,255,191,191,1,255,0,0,1,255,191,191,2,255,0,0,1,255,191,191,1,252,252,252,1,160,130,35,1,255,255,128,8,255,191,191,1,255,255,128,2,160,130,35,1,252,252,252,2,160,130,35,1,255,255,128,11,160,130,35,1,252,252,252,2,160,130,35,1,255,255,128,11,160,130,35,1,252,252,252,2,160,130,35,2,255,255,128,10,160,130,35,1,252,252,252,3,160,130,35,12,252,252,252,62);
tep_add20:array[0..184] of byte=(
84,69,65,49,35,12,0,0,0,20,0,0,0,0,255,0,53,255,144,199,2,0,255,0,9,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,5,255,144,199,4,255,198,255,2,255,144,199,4,0,255,0,1,255,144,199,1,255,198,255,10,255,144,199,2,255,198,255,10,255,144,199,1,0,255,0,1,255,144,199,4,255,198,255,2,255,144,199,4,0,255,0,5,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,9,255,144,199,2,0,255,0,53);
tep_addl20:array[0..120] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,0,255,64,40,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,6,255,209,11,85,0,255,64,6,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,12,255,209,11,5,0,255,64,23);
tep_sub20:array[0..56] of byte=(
84,69,65,49,35,12,0,0,0,20,0,0,0,0,255,0,97,255,144,199,10,0,255,0,1,255,144,199,1,255,198,255,10,255,144,199,2,255,198,255,10,255,144,199,1,0,255,0,1,255,144,199,10,0,255,0,97);
tep_subl20:array[0..24] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,0,255,64,136,255,209,11,85,0,255,64,119);
tep_edit20:array[0..144] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,49,64,138,213,14,255,0,0,1,64,138,213,33,255,255,226,14,64,138,213,2,255,255,222,14,64,138,213,2,255,255,218,14,64,138,213,2,255,255,214,2,64,138,213,10,255,255,214,2,64,138,213,2,255,255,210,14,64,138,213,2,255,255,206,14,64,138,213,2,255,255,202,14,64,138,213,2,255,255,198,2,64,138,213,10,255,255,198,2,64,138,213,2,255,255,194,14,64,138,213,2,255,255,190,14,64,138,213,2,255,255,186,14,64,138,213,1,255,0,0,1,64,138,213,14,255,0,0,33);
tep_favadd20:array[0..184] of byte=(
84,69,65,49,35,12,0,0,0,20,0,0,0,0,255,0,53,255,144,199,2,0,255,0,9,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,5,255,144,199,4,255,198,255,2,255,144,199,4,0,255,0,1,255,144,199,1,255,198,255,10,255,144,199,2,255,198,255,10,255,144,199,1,0,255,0,1,255,144,199,4,255,198,255,2,255,144,199,4,0,255,0,5,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,8,255,144,199,1,255,198,255,2,255,144,199,1,0,255,0,9,255,144,199,2,0,255,0,53);
tep_favedit20:array[0..448] of byte=(
84,69,65,49,35,21,0,0,0,20,0,0,0,255,0,0,10,255,144,199,1,255,0,0,19,255,144,199,1,255,198,255,1,255,144,199,1,255,0,0,18,255,144,199,1,255,198,255,1,255,144,199,1,255,0,0,18,255,144,199,1,255,198,255,1,255,144,199,1,255,0,0,18,255,144,199,8,255,0,0,12,255,144,199,2,255,198,255,7,255,144,199,1,255,0,0,11,255,144,199,2,255,198,255,8,255,144,199,1,255,0,0,2,255,144,199,10,255,198,255,9,255,144,199,1,255,0,0,1,255,144,199,1,255,198,255,8,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,1,255,144,199,2,255,198,255,6,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,4,255,144,199,1,255,198,255,4,255,144,199,1,255,198,255,2,255,144,199,6,255,198,255,2,255,144,199,1,255,0,0,5,255,144,199,2,255,198,255,2,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,5,255,144,199,2,255,198,255,2,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,5,255,144,199,1,255,198,255,3,255,144,199,1,255,198,255,2,255,144,199,6,255,198,255,2,255,144,199,1,255,0,0,5,255,144,199,1,255,198,255,3,255,144,199,1,255,198,255,10,255,
144,199,1,255,0,0,5,255,144,199,1,255,198,255,3,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,4,255,144,199,2,255,198,255,2,255,144,199,2,255,198,255,2,255,144,199,6,255,198,255,2,255,144,199,1,255,0,0,4,255,144,199,1,255,198,255,2,255,144,199,1,255,0,0,1,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,4,255,144,199,1,255,198,255,1,255,144,199,1,255,0,0,2,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,4,255,144,199,2,255,0,0,4,255,144,199,10,255,0,0,1);
tep_undo20:array[0..216] of byte=(
84,69,65,49,35,10,0,0,0,20,0,0,0,255,255,0,25,255,0,255,3,255,255,0,6,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,4,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,8,255,255,0,2,255,0,255,1,255,255,0,1,255,0,255,5,255,255,0,3,255,0,255,1,255,255,0,2,255,0,255,3,255,255,0,4,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,20);
tep_redo20:array[0..216] of byte=(
84,69,65,49,35,10,0,0,0,20,0,0,0,255,255,0,22,255,0,255,3,255,255,0,6,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,4,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,2,255,0,255,8,255,255,0,3,255,0,255,5,255,255,0,1,255,0,255,1,255,255,0,4,255,0,255,3,255,255,0,2,255,0,255,1,255,255,0,5,255,0,255,1,255,255,0,3,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,9,255,0,255,1,255,255,0,29);
tep_stop20:array[0..120] of byte=(
84,69,65,49,35,11,0,0,0,20,0,0,0,255,255,255,45,189,0,99,9,255,255,255,1,189,0,99,1,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,2,239,102,170,9,189,0,99,1,255,255,255,1,189,0,99,9,255,255,255,45);
tep_play20:array[0..176] of byte=(
84,69,65,49,35,9,0,0,0,20,0,0,0,255,255,255,37,43,189,0,3,255,255,255,5,43,189,0,1,136,238,102,3,43,189,0,1,255,255,255,4,43,189,0,1,136,238,102,4,43,189,0,1,255,255,255,3,43,189,0,1,136,238,102,5,43,189,0,1,255,255,255,2,43,189,0,1,136,238,102,6,43,189,0,1,255,255,255,1,43,189,0,1,136,238,102,7,43,189,0,2,136,238,102,7,43,189,0,2,136,238,102,6,43,189,0,1,255,255,255,1,43,189,0,1,136,238,102,5,43,189,0,1,255,255,255,2,43,189,0,1,136,238,102,4,43,189,0,1,255,255,255,3,43,189,0,1,136,238,102,3,43,189,0,1,255,255,255,5,43,189,0,3,255,255,255,41);
tep_rec20:array[0..160] of byte=(
84,69,65,49,35,10,0,0,0,20,0,0,0,255,255,255,44,121,0,0,2,255,255,255,6,121,0,0,2,255,0,0,2,121,0,0,2,255,255,255,3,121,0,0,1,255,0,0,6,121,0,0,1,255,255,255,2,121,0,0,1,255,0,0,6,121,0,0,1,255,255,255,1,121,0,0,1,255,0,0,8,121,0,0,2,255,0,0,8,121,0,0,2,255,0,0,8,121,0,0,1,255,255,255,1,121,0,0,1,255,0,0,6,121,0,0,1,255,255,255,2,121,0,0,1,255,0,0,6,121,0,0,1,255,255,255,3,121,0,0,2,255,0,0,2,121,0,0,2,255,255,255,6,121,0,0,2,255,255,255,54);
tep_rewind20:array[0..272] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,255,255,255,61,194,194,0,3,255,255,255,2,194,194,0,3,255,255,255,5,194,194,0,1,255,255,128,3,194,194,0,2,255,255,128,3,194,194,0,1,255,255,255,3,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,2,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,5,194,194,0,1,255,255,255,1,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,6,194,194,0,2,255,255,128,4,194,194,0,1,255,255,128,7,194,194,0,2,255,255,128,4,194,194,0,1,255,255,128,7,194,194,0,1,255,255,255,1,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,6,194,194,0,1,255,255,255,2,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,5,194,194,0,1,255,255,255,3,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,4,194,194,0,1,255,255,128,3,194,194,0,2,255,255,128,3,194,194,0,1,255,255,255,5,194,194,0,3,255,255,255,2,194,194,0,3,255,255,255,57);
tep_fastforward20:array[0..272] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,255,255,255,57,194,194,0,3,255,255,255,2,194,194,0,3,255,255,255,5,194,194,0,1,255,255,128,3,194,194,0,2,255,255,128,3,194,194,0,1,255,255,255,4,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,3,194,194,0,1,255,255,128,5,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,2,194,194,0,1,255,255,128,6,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,1,194,194,0,1,255,255,128,7,194,194,0,1,255,255,128,4,194,194,0,2,255,255,128,7,194,194,0,1,255,255,128,4,194,194,0,2,255,255,128,6,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,1,194,194,0,1,255,255,128,5,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,2,194,194,0,1,255,255,128,4,194,194,0,1,255,255,128,4,194,194,0,1,255,255,255,3,194,194,0,1,255,255,128,3,194,194,0,2,255,255,128,3,194,194,0,1,255,255,255,5,194,194,0,3,255,255,255,2,194,194,0,3,255,255,255,61);
tep_vol20:array[0..280] of byte=(
84,69,65,49,35,12,0,0,0,20,0,0,0,0,255,0,37,123,123,123,10,0,255,0,1,123,123,123,1,212,212,230,5,123,123,123,1,212,212,230,4,123,123,123,2,212,212,230,5,2,2,2,1,123,123,123,1,212,212,230,3,123,123,123,2,212,212,230,2,123,123,123,7,212,212,230,1,123,123,123,2,212,212,230,4,123,123,123,1,212,212,230,3,123,123,123,1,212,212,230,1,123,123,123,2,212,212,230,2,123,123,123,7,212,212,230,1,123,123,123,2,212,212,230,5,2,2,2,1,123,123,123,1,212,212,230,3,123,123,123,2,212,212,230,2,123,123,123,3,2,2,2,1,123,123,123,2,212,212,230,2,123,123,123,2,212,212,230,5,2,2,2,1,123,123,123,1,212,212,230,3,123,123,123,2,212,212,230,2,123,123,123,3,2,2,2,1,123,123,123,2,212,212,230,2,123,123,123,2,212,212,230,5,2,2,2,1,123,123,123,1,212,212,230,3,123,123,123,2,212,212,230,2,123,123,123,3,2,2,2,1,123,123,123,2,212,212,230,2,123,123,123,2,212,212,230,5,123,123,123,1,212,212,230,4,123,123,123,1,0,255,0,1,123,123,123,10,0,255,0,37);
tep_paste20:array[0..384] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,37,160,130,35,4,255,0,0,8,160,130,35,5,64,138,213,2,160,130,35,5,255,0,0,3,160,130,35,2,255,251,146,2,160,130,35,1,64,138,213,1,160,130,35,2,64,138,213,1,160,130,35,1,255,251,146,2,160,130,35,2,255,0,0,2,160,130,35,1,255,251,146,2,160,130,35,1,255,251,146,6,160,130,35,1,255,251,146,2,160,130,35,1,255,0,0,2,160,130,35,1,255,251,146,2,160,130,35,8,255,251,146,2,160,130,35,1,255,0,0,2,160,130,35,1,255,251,146,12,160,130,35,1,255,0,0,2,160,130,35,1,255,251,146,5,64,138,213,7,160,130,35,1,255,0,0,2,160,130,35,1,255,251,146,5,64,138,213,1,217,235,255,5,64,138,213,2,255,0,0,2,160,130,35,1,255,251,146,5,64,138,213,1,217,235,255,5,64,138,213,1,217,235,255,1,64,138,213,1,255,0,0,1,160,130,35,1,255,251,146,5,64,138,213,1,217,235,255,1,64,138,213,3,217,235,255,1,64,138,213,4,160,130,35,1,255,251,146,5,64,138,213,1,217,235,255,8,64,138,213,1,160,130,35,1,255,251,146,5,64,138,213,1,217,235,255,1,64,138,213,6,217,235,255,1,64,138,213,1,160,130,35,1,255,251,146,5,64,138,
213,1,217,235,255,8,64,138,213,1,160,130,35,2,255,251,146,4,64,138,213,1,217,235,255,1,64,138,213,6,217,235,255,1,64,138,213,1,255,0,0,1,160,130,35,5,64,138,213,1,217,235,255,8,64,138,213,1,255,0,0,7,64,138,213,8,255,0,0,33);
tep_max20:array[0..228] of byte=(84,69,65,49,35,13,0,0,0,20,0,0,0,252,252,252,41,255,144,199,10,252,252,252,2,255,144,199,1,255,198,255,10,255,144,199,1,252,252,252,1,255,144,199,1,255,198,255,10,255,144,199,1,252,252,252,1,255,144,199,1,255,198,255,10,255,144,199,1,252,252,252,1,255,144,199,1,255,198,255,10,255,144,199,1,252,252,252,1,72,138,205,6,255,198,255,5,255,144,199,1,72,138,205,1,170,212,255,6,72,138,205,1,255,198,255,4,255,144,199,1,72,138,205,1,170,212,255,6,72,138,205,1,255,198,255,4,255,144,199,1,72,138,205,1,170,212,255,6,72,138,205,1,255,198,255,4,255,144,199,1,72,138,205,1,170,212,255,6,72,138,205,1,255,198,255,4,255,144,199,1,72,138,205,1,170,212,255,6,72,138,205,1,255,198,255,4,255,144,199,1,72,138,205,1,170,212,255,6,72,138,205,1,255,144,199,4,252,252,252,2,72,138,205,6,252,252,252,58);
tep_ontop20:array[0..240] of byte=(84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,67,255,144,199,10,255,0,0,5,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,4,255,144,199,1,255,198,255,5,72,138,205,6,255,0,0,4,255,144,199,1,255,198,255,4,72,138,205,1,170,212,255,6,72,138,205,1,255,0,0,3,255,144,199,1,255,198,255,4,72,138,205,1,170,212,255,6,72,138,205,1,255,0,0,3,255,144,199,1,255,198,255,4,72,138,205,1,170,212,255,6,72,138,205,1,255,0,0,3,255,144,199,1,255,198,255,4,72,138,205,1,170,212,255,6,72,138,205,1,255,0,0,3,255,144,199,1,255,198,255,4,72,138,205,1,170,212,255,6,72,138,205,1,255,0,0,3,255,144,199,1,255,198,255,4,72,138,205,1,170,212,255,6,72,138,205,1,255,0,0,3,255,144,199,1,255,198,255,5,72,138,205,6,255,0,0,4,255,144,199,1,255,198,255,10,255,144,199,1,255,0,0,5,255,144,199,10,255,0,0,67);
tep_nav20:array[0..224] of byte=(84,69,65,49,35,16,0,0,0,20,0,0,0,128,255,255,50,211,95,153,12,128,255,255,3,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,2,211,95,153,6,255,255,255,7,211,95,153,1,128,255,255,3,211,95,153,12,128,255,255,50);
tep_less20:array[0..160] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,42,255,255,187,6,255,0,0,10,255,255,187,9,255,0,0,8,255,255,187,12,255,0,0,5,255,255,187,13,255,0,0,5,255,255,187,14,255,0,0,3,255,255,187,16,255,0,0,2,255,255,187,16,255,0,0,2,255,255,187,2,68,136,221,12,255,255,187,2,255,0,0,2,255,255,187,2,68,136,221,12,255,255,187,2,255,0,0,2,255,255,187,16,255,0,0,2,255,255,187,16,255,0,0,3,255,255,187,14,255,0,0,5,255,255,187,12,255,0,0,6,255,255,187,12,255,0,0,8,255,255,187,8,255,0,0,11,255,255,187,6,255,0,0,42);
tep_more20:array[0..224] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,42,255,255,187,6,255,0,0,10,255,255,187,9,255,0,0,8,255,255,187,12,255,0,0,5,255,255,187,6,68,136,221,2,255,255,187,5,255,0,0,5,255,255,187,6,68,136,221,2,255,255,187,6,255,0,0,3,255,255,187,7,68,136,221,2,255,255,187,7,255,0,0,2,255,255,187,7,68,136,221,2,255,255,187,7,255,0,0,2,255,255,187,2,68,136,221,12,255,255,187,2,255,0,0,2,255,255,187,2,68,136,221,12,255,255,187,2,255,0,0,2,255,255,187,7,68,136,221,2,255,255,187,7,255,0,0,2,255,255,187,7,68,136,221,2,255,255,187,7,255,0,0,3,255,255,187,6,68,136,221,2,255,255,187,6,255,0,0,5,255,255,187,5,68,136,221,2,255,255,187,5,255,0,0,6,255,255,187,12,255,0,0,8,255,255,187,8,255,0,0,11,255,255,187,6,255,0,0,42);
tep_bw20:array[0..188] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,42,255,255,255,6,255,0,0,10,255,255,255,9,255,0,0,8,255,255,255,11,4,4,4,1,255,0,0,5,255,255,255,11,4,4,4,2,255,0,0,5,255,255,255,10,4,4,4,4,255,0,0,3,255,255,255,10,4,4,4,6,255,0,0,2,255,255,255,9,4,4,4,7,255,0,0,2,255,255,255,8,4,4,4,8,255,0,0,2,255,255,255,7,4,4,4,9,255,0,0,2,255,255,255,6,4,4,4,10,255,0,0,2,255,255,255,5,4,4,4,11,255,0,0,3,255,255,255,3,4,4,4,11,255,0,0,5,255,255,255,1,4,4,4,11,255,0,0,6,4,4,4,12,255,0,0,8,4,4,4,8,255,0,0,11,4,4,4,6,255,0,0,42);
tep_help20:array[0..696] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,0,255,0,6,192,8,107,5,181,8,99,1,117,104,99,1,0,255,0,7,195,20,113,2,248,124,186,1,243,107,181,1,239,107,169,1,233,88,162,2,241,135,152,1,181,18,123,1,117,104,99,1,0,255,0,4,195,20,113,1,243,135,173,1,245,165,184,1,239,107,169,1,248,124,186,1,239,107,169,1,248,124,186,1,243,135,173,2,245,165,184,1,243,135,173,1,203,45,152,1,181,18,123,1,0,255,0,3,245,165,184,2,241,135,152,1,195,20,113,3,248,124,186,1,243,135,173,1,245,165,184,3,233,88,162,1,191,28,152,1,117,104,99,1,0,255,0,1,195,20,113,1,252,197,185,1,181,18,123,1,117,104,99,1,0,255,0,4,239,107,169,1,243,107,181,1,245,165,184,1,252,197,185,1,243,135,173,1,191,28,152,1,181,8,99,1,195,20,113,1,239,107,169,1,252,241,189,1,191,28,152,1,181,18,123,1,195,20,113,1,123,107,107,1,0,255,0,2,203,45,152,1,239,107,169,1,245,165,184,2,243,135,173,1,203,45,152,1,181,18,123,1,192,8,107,1,239,107,169,1,252,197,185,1,252,241,189,1,245,165,184,1,248,124,186,1,181,18,123,1,123,82,99,1,0,255,0,1,195,20,113,1,239,107,169,1,243,135,173,
2,233,88,162,1,191,28,152,1,181,8,99,1,195,20,113,1,239,107,169,1,252,197,185,1,252,241,189,2,248,124,186,1,191,28,152,2,0,255,0,1,233,88,162,2,243,107,181,1,239,107,169,1,233,88,162,1,191,28,152,1,181,18,123,1,0,255,0,1,195,20,113,1,243,135,173,1,252,197,185,1,245,165,184,1,243,107,181,1,181,18,123,1,123,107,107,1,0,255,0,1,239,107,169,2,233,88,162,1,203,45,152,2,181,18,123,1,0,255,0,3,195,20,113,1,239,107,169,1,241,135,152,1,191,28,152,1,181,18,123,1,123,107,107,1,195,20,113,1,243,107,181,2,233,88,162,1,191,28,152,2,123,107,107,1,0,255,0,9,239,107,169,1,243,135,173,1,241,135,152,1,191,28,152,1,181,18,123,1,123,107,107,1,0,255,0,8,148,148,33,1,241,243,47,2,148,140,16,1,237,200,30,1,140,132,16,1,0,255,0,10,148,148,33,1,252,241,189,1,237,200,30,2,140,132,16,1,123,82,99,1,0,255,0,10,241,243,47,1,237,200,30,2,123,82,99,1,0,255,0,12,148,148,33,1,129,121,35,2,123,82,99,1,0,255,0,12,148,148,33,2,148,140,16,1,123,107,107,1,0,255,0,11,148,148,33,1,252,241,189,1,241,243,47,1,148,140,0,1,140,132,16,2,0,255,
0,10,252,241,189,2,241,243,47,2,148,140,0,1,237,200,30,1,123,82,99,1,0,255,0,9,241,243,47,4,140,132,16,1,165,148,8,1,123,82,99,1,0,255,0,9,148,148,33,1,241,243,47,1,252,241,189,1,148,140,0,2,148,140,16,1,0,255,0,5);
tep_helpbanner:array[0..9964] of byte=(
84,69,65,49,35,46,1,0,0,62,0,0,0,255,0,0,2,255,255,255,250,255,255,255,48,255,0,0,3,255,255,255,1,0,0,0,250,0,0,0,48,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,250,0,0,0,50,255,255,255,2,0,0,0,3,255,255,255,250,255,255,255,44,0,0,0,3,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,250,255,0,0,44,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,250,255,0,0,44,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,213,255,255,255,3,255,0,0,78,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,212,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,77,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,212,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,77,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,211,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,77,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,211,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,77,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,87,255,
255,255,3,255,0,0,121,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,34,255,255,255,3,255,0,0,40,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,86,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,120,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,39,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,72,255,255,255,3,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,47,255,255,255,3,255,0,0,55,255,255,255,2,255,0,0,13,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,32,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,39,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,27,255,255,255,7,255,0,0,37,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,46,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,53,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,32,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,39,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,
255,255,1,255,0,0,22,255,255,255,5,0,0,0,7,255,255,255,3,255,0,0,34,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,14,255,255,255,2,255,0,0,30,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,51,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,39,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,19,255,255,255,3,0,0,0,15,255,255,255,1,255,0,0,34,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,30,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,50,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,39,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,16,255,255,255,3,0,0,0,10,255,255,255,3,0,0,0,6,255,255,255,1,255,0,0,34,255,255,255,4,255,0,0,8,255,255,255,1,0,0,0,4,255,255,
255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,4,255,0,0,51,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,39,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,13,255,255,255,3,0,0,0,7,255,255,255,6,255,0,0,3,255,255,255,2,0,0,0,4,255,255,255,1,255,0,0,46,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,86,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,39,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,11,255,255,255,2,0,0,0,9,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,46,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,86,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,3,255,255,255,
1,255,0,0,40,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,9,255,255,255,2,0,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,46,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,86,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,40,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,6,255,255,255,3,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,46,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,87,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,33,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,40,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,4,255,255,255,2,255,0,0,2,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,
255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,25,255,255,255,2,255,0,0,8,255,255,255,3,255,0,0,9,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,32,255,255,255,3,255,0,0,52,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,18,255,255,255,6,255,0,0,9,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,40,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,9,255,255,255,4,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,3,255,0,0,8,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,3,255,0,0,40,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,16,255,255,255,2,0,0,0,6,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,
255,255,1,255,0,0,5,255,255,255,2,255,0,0,2,255,255,255,3,255,0,0,28,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,3,255,0,0,20,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,3,255,0,0,28,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,15,255,255,255,1,0,0,0,9,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,4,255,255,255,1,
255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,19,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,14,255,255,255,1,0,0,0,4,255,255,255,3,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,7,255,255,255,4,255,0,0,24,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,
255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,6,0,0,0,5,255,255,255,1,255,0,0,19,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,26,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,2,255,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,11,255,255,255,3,255,0,0,21,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,4,255,255,255,7,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,0,0,0,10,255,255,255,1,255,0,0,19,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,
5,255,255,255,1,0,0,0,6,255,255,255,1,255,0,0,26,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,4,0,0,0,10,255,255,255,3,255,0,0,18,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,2,0,0,0,12,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,5,0,0,0,14,255,255,255,2,255,0,0,21,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,25,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,
1,255,0,0,4,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,4,0,0,0,6,255,255,255,2,255,0,0,16,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,15,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,3,255,255,255,4,0,0,0,13,255,255,255,6,255,0,0,23,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,25,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,3,255,255,255,2,0,0,0,4,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,3,255,
255,255,3,0,0,0,5,255,255,255,1,255,0,0,15,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,1,255,255,255,3,0,0,0,6,255,255,255,7,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,14,255,255,255,3,255,0,0,29,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,3,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,25,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,1,255,255,255,2,0,0,0,5,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,2,0,0,0,4,255,255,255,1,255,0,0,14,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,
2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,2,0,0,0,7,255,255,255,2,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,6,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,6,255,255,255,4,0,0,0,4,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,25,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,4,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,3,0,0,0,5,255,255,255,2,255,0,0,10,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,10,255,255,255,2,255,0,0,8,255,255,255,1,
0,0,0,4,255,255,255,1,255,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,6,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,3,255,255,255,6,255,0,0,3,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,22,255,255,255,3,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,25,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,2,0,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,9,255,255,255,2,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,9,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,7,255,255,255,3,255,0,0,10,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,
255,1,0,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,17,255,255,255,5,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,25,255,255,255,1,0,0,0,3,255,255,255,11,0,0,0,10,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,7,255,255,255,3,255,0,0,14,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,4,255,255,255,3,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,
255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,12,255,255,255,5,0,0,0,9,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,17,255,255,255,8,0,0,0,4,255,255,255,1,0,0,0,19,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,4,255,255,255,3,255,0,0,10,255,255,255,2,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,14,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,
255,0,0,11,255,255,255,1,0,0,0,13,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,16,255,255,255,1,0,0,0,28,255,255,255,4,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,14,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,6,255,255,255,7,255,0,0,6,255,255,255,1,0,0,0,3,255,
255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,16,255,255,255,1,0,0,0,17,255,255,255,7,0,0,0,4,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,12,255,255,255,6,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,
0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,6,255,255,255,1,0,0,0,3,255,255,255,6,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,9,255,255,255,2,0,0,0,4,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,18,255,255,255,
7,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,2,0,0,0,5,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,3,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,8,255,
255,255,1,0,0,0,4,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,3,0,0,0,6,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,2,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,3,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,6,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,
0,3,255,255,255,1,255,0,0,5,255,255,255,4,0,0,0,3,255,255,255,5,0,0,0,7,255,255,255,2,255,0,0,14,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,16,255,255,255,3,255,0,0,16,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,
1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,2,0,0,0,4,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,3,255,255,255,2,0,0,0,4,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,2,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,12,255,255,255,4,255,0,0,19,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,
255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,5,255,255,255,2,255,0,0,2,255,255,255,2,0,0,0,4,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,5,255,255,255,4,0,0,0,3,255,255,255,5,255,0,0,23,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,4,255,255,255,2,0,0,0,4,255,255,255,2,255,0,0,12,255,255,255,1,0,0,0,7,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,30,255,255,255,1,0,
0,0,4,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,6,255,255,255,2,0,0,0,5,255,255,255,1,255,0,0,9,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,1,255,255,255,3,0,0,0,5,255,255,255,1,255,0,0,14,255,255,255,1,0,0,0,6,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,5,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,6,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,
255,1,0,0,0,11,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,4,255,255,255,2,0,0,0,7,255,255,255,1,255,0,0,16,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,4,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,12,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,31,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,2,255,0,0,8,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,13,255,255,255,1,0,0,0,8,255,255,255,2,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,7,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,0,0,0,7,255,255,255,2,255,0,0,18,255,255,255,4,255,
0,0,12,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,5,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,8,255,255,255,3,255,0,0,14,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,32,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,18,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,24,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,14,255,255,255,8,255,0,0,15,255,255,255,3,255,0,0,8,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,17,255,255,255,1,0,0,0,3,255,255,255,1,0,0,0,5,255,255,255,2,255,0,0,37,255,255,255,2,255,0,0,7,255,255,255,3,255,0,0,27,255,255,255,2,255,0,0,34,255,255,255,3,255,0,0,20,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,23,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,48,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,18,255,255,255,3,255,0,0,1,255,255,255,1,0,0,0,2,255,255,255,2,255,
0,0,138,255,255,255,3,255,0,0,24,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,10,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,48,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,23,255,255,255,2,255,0,0,167,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,11,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,49,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,192,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,12,255,255,255,2,255,0,0,50,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,192,255,255,255,1,0,0,0,4,255,255,255,1,255,0,0,64,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,193,255,255,255,1,0,0,0,2,255,255,255,1,255,0,0,65,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,194,255,255,255,2,
255,0,0,66,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,250,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,250,255,0,0,12,255,255,255,1,0,0,0,3,255,255,255,1,255,0,0,27,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,2,255,255,255,1,255,0,0,250,255,0,0,13,255,255,255,3,255,0,0,28,255,255,255,1,0,0,0,2,255,255,255,2,0,0,0,3,255,255,255,250,255,255,255,44,0,0,0,3,255,255,255,2,0,0,0,250,0,0,0,50,255,255,255,1,255,0,0,1,255,255,255,1,0,0,0,250,0,0,0,48,255,255,255,1,255,0,0,3,255,255,255,250,255,255,255,48,255,0,0,2);
tep_helpdoc20:array[0..216] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,192,192,192,29,132,132,0,12,192,192,192,1,132,132,0,2,255,255,128,10,132,132,0,3,255,255,128,12,132,132,0,2,255,255,128,12,132,132,0,2,255,255,128,6,132,132,0,1,255,255,128,5,132,132,0,2,255,255,128,6,132,132,0,2,255,255,128,4,132,132,0,2,255,255,128,6,132,132,0,3,255,255,128,3,132,132,0,2,255,255,128,2,132,132,0,8,255,255,128,2,132,132,0,2,255,255,128,2,132,132,0,8,255,255,128,2,132,132,0,2,255,255,128,6,132,132,0,3,255,255,128,3,132,132,0,2,255,255,128,6,132,132,0,2,255,255,128,4,132,132,0,2,255,255,128,6,132,132,0,1,255,255,128,5,132,132,0,2,255,255,128,12,132,132,0,2,255,255,128,12,132,132,0,3,255,255,128,10,132,132,0,2,192,192,192,1,132,132,0,12,192,192,192,29);
tep_um20:array[0..392] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,42,180,163,0,2,255,255,255,10,180,163,0,2,255,255,255,2,180,163,0,1,255,255,138,2,180,163,0,1,255,255,255,2,180,163,0,2,255,255,255,4,180,163,0,1,255,255,138,2,180,163,0,2,255,255,138,4,180,163,0,2,255,255,138,2,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,12,180,163,0,1,255,255,255,4,180,163,0,1,255,255,138,10,180,163,0,1,255,255,255,5,180,163,0,1,255,255,138,10,180,163,0,1,255,255,255,3,180,163,0,2,255,255,138,4,180,163,0,3,255,255,138,5,180,163,0,1,255,255,255,1,180,163,0,1,255,255,138,5,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,5,180,163,0,2,255,255,138,5,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,5,180,163,0,1,255,255,255,1,180,163,0,2,255,255,138,3,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,4,180,163,0,1,255,255,255,4,180,163,0,1,255,255,138,3,180,163,0,3,255,255,138,4,180,163,0,1,255,255,255,5,180,163,0,1,255,255,138,10,180,163,0,1,255,255,255,4,180,163,0,1,255,255,138,11,180,163,0,1,255,255,255,4,180,163,0,1,255,255,
138,2,180,163,0,2,255,255,138,4,180,163,0,2,255,255,138,2,180,163,0,1,255,255,255,4,180,163,0,2,255,255,255,2,180,163,0,1,255,255,138,2,180,163,0,1,255,255,255,2,180,163,0,2,255,255,255,9,180,163,0,1,255,255,138,2,180,163,0,1,255,255,255,14,180,163,0,2,255,255,255,24);
tep_about20:array[0..424] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,255,0,0,24,64,138,213,6,255,0,0,10,64,138,213,2,255,255,255,6,64,138,213,2,255,0,0,7,64,138,213,1,255,255,255,2,64,138,213,6,255,255,255,2,64,138,213,1,255,0,0,5,64,138,213,1,255,255,255,1,64,138,213,10,255,255,255,1,64,138,213,1,255,0,0,3,64,138,213,1,255,255,255,1,64,138,213,5,255,255,255,2,64,138,213,5,255,255,255,1,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,1,64,138,213,5,255,255,255,2,64,138,213,5,255,255,255,1,64,138,213,1,255,0,0,1,64,138,213,1,255,255,255,1,64,138,213,14,255,255,255,1,64,138,213,2,255,255,255,1,64,138,213,14,255,255,255,1,64,138,213,2,255,255,255,1,64,138,213,6,255,255,255,2,64,138,213,6,255,255,255,1,64,138,213,2,255,255,255,1,64,138,213,6,255,255,255,2,64,138,213,6,255,255,255,1,64,138,213,2,255,255,255,1,64,138,213,6,255,255,255,2,64,138,213,6,255,255,255,1,64,138,213,2,255,255,255,1,64,138,213,6,255,255,255,2,64,138,213,6,255,255,255,1,64,138,213,1,255,0,0,1,64,138,213,1,255,255,255,1,64,138,213,5,255,255,255,2,64,138,213,5,255,255,
255,1,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,1,64,138,213,5,255,255,255,2,64,138,213,5,255,255,255,1,64,138,213,1,255,0,0,3,64,138,213,1,255,255,255,1,64,138,213,10,255,255,255,1,64,138,213,1,255,0,0,5,64,138,213,1,255,255,255,2,64,138,213,6,255,255,255,2,64,138,213,1,255,0,0,7,64,138,213,2,255,255,255,6,64,138,213,2,255,0,0,10,64,138,213,6,255,0,0,24);
tep_settings20:array[0..392] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,42,180,163,0,2,255,255,255,10,180,163,0,2,255,255,255,2,180,163,0,1,255,255,138,2,180,163,0,1,255,255,255,2,180,163,0,2,255,255,255,4,180,163,0,1,255,255,138,2,180,163,0,2,255,255,138,4,180,163,0,2,255,255,138,2,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,12,180,163,0,1,255,255,255,4,180,163,0,1,255,255,138,10,180,163,0,1,255,255,255,5,180,163,0,1,255,255,138,10,180,163,0,1,255,255,255,3,180,163,0,2,255,255,138,4,180,163,0,3,255,255,138,5,180,163,0,1,255,255,255,1,180,163,0,1,255,255,138,5,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,5,180,163,0,2,255,255,138,5,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,5,180,163,0,1,255,255,255,1,180,163,0,2,255,255,138,3,180,163,0,1,255,255,255,3,180,163,0,1,255,255,138,4,180,163,0,1,255,255,255,4,180,163,0,1,255,255,138,3,180,163,0,3,255,255,138,4,180,163,0,1,255,255,255,5,180,163,0,1,255,255,138,10,180,163,0,1,255,255,255,4,180,163,0,1,255,255,138,11,180,163,0,1,255,255,255,4,180,163,0,1,255,255,
138,2,180,163,0,2,255,255,138,4,180,163,0,2,255,255,138,2,180,163,0,1,255,255,255,4,180,163,0,2,255,255,255,2,180,163,0,1,255,255,138,2,180,163,0,1,255,255,255,2,180,163,0,2,255,255,255,9,180,163,0,1,255,255,138,2,180,163,0,1,255,255,255,14,180,163,0,2,255,255,255,24);
tep_options20:array[0..736] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,41,132,132,0,4,255,255,255,9,132,132,0,2,255,255,255,2,132,132,0,1,255,132,198,1,255,214,239,1,132,132,0,1,255,255,255,2,132,132,0,2,255,255,255,4,132,132,0,1,255,214,239,1,206,57,222,1,132,132,0,2,255,214,239,2,255,132,198,1,255,214,239,1,132,132,0,2,255,156,0,1,255,189,82,1,132,132,0,1,255,255,255,3,132,132,0,1,206,57,222,1,255,214,239,1,206,57,222,1,255,214,239,1,255,132,198,1,206,57,222,1,255,214,239,1,206,57,222,1,255,214,239,1,255,132,198,1,255,189,82,1,255,156,0,1,132,132,0,1,255,255,255,4,132,132,0,1,206,57,222,1,255,214,239,1,206,57,222,1,255,214,239,1,255,132,198,1,206,57,222,1,255,214,239,1,255,132,198,1,255,214,239,1,255,189,82,1,132,132,0,1,255,255,255,5,132,132,0,1,255,214,239,1,255,132,198,1,255,214,239,2,255,132,198,1,255,214,239,1,255,132,198,1,255,189,82,1,255,132,198,1,255,214,239,1,132,132,0,1,255,255,255,2,132,132,0,3,132,181,255,1,132,255,255,1,255,214,239,1,132,255,255,1,132,132,0,3,255,156,0,1,255,132,198,1,255,189,82,1,239,247,
33,1,255,156,0,1,132,132,0,3,132,255,255,1,132,181,255,1,132,255,255,1,132,181,255,1,132,255,255,1,132,132,0,1,255,255,255,3,132,132,0,1,255,156,0,1,239,247,33,1,255,189,82,1,239,247,33,1,255,189,82,1,255,156,0,1,132,132,0,1,132,181,255,1,132,255,255,1,132,181,255,1,132,255,255,1,132,181,255,1,132,132,0,1,255,255,255,3,132,132,0,1,255,156,0,1,255,189,82,1,239,247,33,1,255,189,82,1,255,156,0,1,132,132,0,4,132,255,255,1,132,181,255,1,132,255,255,1,132,132,0,1,255,255,255,3,132,132,0,1,255,156,0,1,239,247,33,1,255,189,82,1,255,156,0,1,132,132,0,2,255,255,255,3,132,132,0,1,132,255,255,1,132,181,255,1,132,255,255,1,132,132,0,3,255,156,0,1,239,247,33,1,255,189,82,1,255,156,0,1,132,132,0,1,255,255,255,5,132,132,0,1,132,181,255,1,132,255,255,1,132,181,255,1,132,255,255,1,132,181,255,1,132,255,255,1,239,247,33,3,255,189,82,1,132,132,0,1,255,255,255,4,132,132,0,1,132,181,255,1,132,255,255,1,132,181,255,1,132,255,255,1,132,181,255,1,132,255,255,1,132,181,255,1,239,247,33,1,255,189,82,2,255,156,0,1,132,132,
0,1,255,255,255,4,132,132,0,1,132,255,255,1,132,181,255,1,132,132,0,2,132,255,255,1,132,181,255,1,132,255,255,1,255,156,0,1,132,132,0,2,255,189,82,1,255,156,0,1,255,255,255,4,132,132,0,3,99,90,90,1,255,255,255,1,132,132,0,1,132,255,255,1,255,156,0,1,132,132,0,1,255,255,255,2,132,132,0,2,255,255,255,9,132,132,0,1,239,247,33,1,132,181,255,1,132,132,0,1,255,255,255,13,132,132,0,4,255,255,255,23);

tep_be20:array[0..1951] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,1,0,1,1,1,1,24,2,2,2,1,151,4,4,4,1,219,9,9,9,1,232,14,14,14,1,232,10,10,10,1,232,7,7,7,1,232,4,4,4,1,232,6,6,6,1,232,9,9,9,1,232,7,7,7,2,232,9,9,9,1,232,8,8,8,1,232,14,14,14,1,232,8,8,8,1,220,10,10,10,1,153,17,17,17,1,25,0,0,0,1,0,5,5,5,1,24,2,2,2,1,225,4,4,4,1,255,2,2,2,1,255,9,9,9,1,255,10,10,10,1,255,6,6,6,1,255,7,7,7,1,255,6,6,6,2,255,4,4,4,1,255,8,8,8,1,255,6,6,6,1,255,7,7,7,1,255,12,12,12,1,255,10,10,10,1,255,7,7,7,1,255,9,9,9,1,255,7,7,7,1,227,11,11,11,1,26,7,7,7,1,151,5,5,5,1,255,6,6,6,1,255,9,9,9,1,255,8,8,8,1,255,5,5,5,1,255,7,7,7,1,255,9,9,9,1,255,7,7,7,1,255,9,9,6,1,255,15,15,8,1,255,21,21,18,1,255,26,26,17,1,255,25,25,18,1,255,19,19,13,1,255,15,15,15,1,255,10,10,10,2,255,9,9,9,1,255,7,7,7,1,155,5,5,5,1,219,8,8,8,1,255,10,10,10,1,255,9,9,9,2,255,12,12,11,1,255,26,26,19,1,255,51,51,33,1,255,74,75,51,1,255,97,98,65,1,255,115,115,75,1,255,129,129,89,1,255,141,141,94,1,255,137,138,91,1,255,121,121,83,1,
255,99,99,68,1,255,50,50,35,1,255,12,12,12,1,255,13,13,13,1,255,14,14,14,1,221,7,7,7,1,230,4,4,4,1,255,5,5,5,1,255,7,7,7,1,255,27,27,17,1,255,75,77,53,1,255,122,122,82,1,255,173,173,116,1,255,199,199,129,1,255,227,227,150,1,255,228,228,149,1,255,243,243,160,1,255,225,225,148,1,255,217,217,137,1,255,217,217,136,1,255,206,206,132,1,255,139,139,93,1,255,48,48,34,1,255,8,8,8,1,255,11,11,11,1,230,8,8,8,1,230,7,7,7,1,255,6,6,6,1,255,39,40,28,1,255,108,108,74,1,255,173,173,110,1,255,228,228,152,1,255,221,221,140,1,255,207,207,130,1,255,206,206,136,1,255,197,197,127,1,255,177,177,117,1,255,140,140,92,1,255,126,126,87,1,255,147,147,98,1,255,209,209,137,1,255,190,190,122,1,255,79,79,55,1,255,11,11,11,1,255,10,10,10,1,230,6,6,6,1,230,6,6,6,1,255,41,41,30,1,255,125,125,84,1,255,180,180,109,1,255,182,182,101,1,255,203,203,134,1,255,160,161,106,1,255,138,138,93,1,255,195,195,123,1,255,209,209,129,1,255,199,199,122,1,255,121,122,84,1,255,53,53,36,1,255,100,101,70,1,255,194,194,125,1,255,196,
197,127,1,255,81,81,55,1,255,9,9,9,1,255,11,11,11,1,230,9,9,9,1,230,9,9,9,1,255,87,88,60,1,255,191,191,120,1,255,207,207,130,1,255,159,159,103,1,255,99,99,68,1,255,90,90,63,1,255,194,194,126,1,255,205,205,124,1,255,192,193,117,1,255,138,138,93,1,255,119,120,82,1,255,144,145,95,1,255,192,192,121,1,255,210,210,130,1,255,157,158,103,1,255,61,62,42,1,255,8,8,8,1,255,6,6,6,2,230,9,9,9,1,255,101,101,69,1,255,195,195,120,1,255,166,166,105,1,255,74,74,50,1,255,32,32,25,1,255,110,111,74,1,255,208,208,130,1,255,192,192,115,1,255,162,162,104,1,255,174,175,111,1,255,192,192,119,1,255,196,196,118,1,255,187,187,114,1,255,149,149,98,1,255,77,77,55,1,255,12,12,10,1,255,7,7,7,1,255,11,11,11,2,230,12,12,11,1,255,95,95,66,1,255,180,180,107,1,255,175,175,110,1,255,125,125,86,1,255,80,80,56,1,255,152,153,97,1,255,185,185,105,1,255,159,159,105,1,255,184,184,105,1,255,177,177,96,1,255,167,167,105,1,255,131,132,90,1,255,92,92,64,1,255,55,55,38,1,255,12,12,10,1,255,10,10,10,1,255,13,13,13,1,255,10,10,
10,2,230,8,8,8,1,255,52,52,37,1,255,134,134,90,1,255,180,180,112,1,255,178,179,115,1,255,129,129,87,1,255,187,187,113,1,255,170,170,102,1,255,102,102,69,1,255,158,158,103,1,255,192,192,114,1,255,191,191,112,1,255,168,168,107,1,255,89,90,60,1,255,21,21,19,1,255,4,4,4,1,255,9,9,9,1,255,10,10,10,1,255,10,10,10,1,230,9,9,9,1,230,10,10,10,2,255,44,44,31,1,255,77,77,55,1,255,95,96,67,1,255,162,162,102,1,255,182,182,106,1,255,125,127,83,1,255,39,39,27,1,255,78,78,53,1,255,148,148,94,1,255,181,181,101,1,255,182,182,103,1,255,152,152,95,1,255,58,58,41,1,255,7,7,7,1,255,8,8,8,1,255,9,9,9,1,255,9,9,9,1,230,6,6,6,1,230,3,3,3,1,255,8,8,8,2,255,23,24,16,1,255,116,117,79,1,255,177,177,101,1,255,163,163,102,1,255,79,79,56,1,255,10,10,10,1,255,12,12,9,1,255,76,76,53,1,255,155,156,96,1,255,166,166,89,1,255,158,158,92,1,255,68,68,47,1,255,8,8,8,2,255,9,9,9,1,255,12,12,12,1,230,10,10,10,1,230,13,13,13,1,255,9,9,9,1,255,6,6,6,1,255,58,58,39,1,255,147,148,91,1,255,167,167,91,1,255,160,160,103,1,255,
132,132,86,1,255,38,38,26,1,255,8,8,8,1,255,30,30,21,1,255,124,125,83,1,255,174,174,94,1,255,161,161,94,1,255,69,69,50,1,255,9,9,9,1,255,11,11,11,1,255,7,7,7,1,255,18,18,18,1,230,11,11,11,1,230,8,8,8,2,255,5,5,5,1,255,86,86,60,1,255,163,163,94,1,255,162,162,90,1,255,165,165,88,1,255,159,159,96,1,255,74,74,50,1,255,46,46,34,1,255,86,86,59,1,255,153,153,97,1,255,171,171,92,1,255,133,134,86,1,255,45,45,33,1,255,8,8,8,1,255,10,10,10,1,255,13,13,13,1,255,11,11,11,1,230,7,7,7,1,230,6,6,6,1,255,9,9,9,1,255,12,12,12,1,255,90,91,63,1,255,166,166,100,1,255,172,173,98,1,255,170,170,102,1,255,163,163,87,1,255,142,142,87,1,255,147,147,93,1,255,162,162,97,1,255,168,168,93,1,255,148,148,93,1,255,75,75,50,1,255,13,13,12,1,255,7,7,7,1,255,8,8,8,1,255,13,13,13,1,255,12,12,12,1,230,9,9,9,1,219,10,10,10,1,255,9,9,9,1,255,4,4,4,1,255,47,47,35,1,255,90,90,62,1,255,92,92,64,1,255,108,109,73,1,255,138,138,85,1,255,143,144,87,1,255,150,151,93,1,255,145,146,90,1,255,120,121,80,1,255,67,67,46,1,255,13,
13,11,1,255,9,9,9,1,255,8,8,8,1,255,11,11,11,1,255,13,13,13,1,255,12,12,12,1,222,11,11,11,1,152,10,10,10,1,255,8,8,8,1,255,9,9,9,1,255,7,7,7,1,255,8,8,8,1,255,6,6,6,1,255,27,27,21,1,255,48,48,32,1,255,54,55,37,1,255,55,55,38,1,255,45,45,32,1,255,28,28,21,1,255,5,5,5,1,255,7,7,7,1,255,9,9,9,1,255,6,6,6,1,255,12,12,12,1,255,9,9,9,1,255,13,13,13,1,156,16,16,16,1,24,10,10,10,1,227,7,7,7,1,255,3,3,3,1,255,8,8,8,1,255,10,10,10,1,255,9,9,9,1,255,5,5,5,1,255,7,7,7,1,255,12,12,12,1,255,13,13,13,1,255,7,7,7,2,255,10,10,10,2,255,8,8,8,1,255,9,9,9,2,255,10,10,10,1,228,15,15,15,1,27,0,0,0,1,0,1,1,1,1,25,3,3,3,1,155,6,6,6,1,220,8,8,8,1,228,11,11,11,1,228,9,9,9,1,228,7,7,7,2,228,8,8,8,1,228,9,9,9,1,228,7,7,7,1,228,11,11,11,1,228,7,7,7,1,228,12,12,12,1,228,14,14,14,1,228,11,11,11,1,221,6,6,6,1,156,15,15,15,1,27,0,0,0,1,0);
{
:array[0..740] of byte=(//orginal aqua icon - 12feb2022
84,69,65,49,35,19,0,0,0,20,0,0,0,255,255,255,22,0,242,253,2,11,231,253,6,55,121,231,1,11,231,253,3,55,121,231,1,255,255,255,5,0,242,253,2,11,231,253,5,22,220,253,3,55,121,231,1,22,220,253,3,255,255,255,4,0,242,253,1,55,121,231,1,255,255,255,4,22,220,253,1,55,121,231,1,33,209,253,2,55,121,231,1,255,255,255,2,22,220,253,2,55,121,231,1,255,255,255,3,55,121,231,1,255,255,255,4,22,220,253,1,55,121,231,1,255,255,255,1,33,209,253,2,55,121,231,1,255,255,255,3,33,209,253,1,22,220,253,1,55,121,231,1,255,255,255,6,33,209,253,2,55,121,231,1,255,255,255,1,44,198,253,2,55,121,231,1,255,255,255,3,44,198,253,2,55,121,231,1,255,255,255,6,33,209,253,1,33,198,253,1,55,121,231,1,255,255,255,1,55,187,253,2,55,121,231,1,255,255,255,2,55,187,253,2,55,121,231,1,255,255,255,5,33,209,253,2,44,198,253,2,55,121,231,1,255,255,255,1,55,187,253,2,55,121,231,1,55,187,253,4,255,255,255,4,33,209,253,2,55,121,231,1,44,198,253,1,44,187,253,1,55,187,253,1,55,121,231,1,255,255,255,1,66,176,253,1,77,165,253,3,55,121,231,1,66,176,253,
3,55,187,253,1,55,121,231,1,255,255,255,1,33,209,253,1,55,121,231,1,255,255,255,2,55,187,253,1,55,176,253,1,55,121,231,1,255,255,255,1,77,165,253,1,77,154,253,3,255,255,255,2,66,165,253,1,66,176,253,2,55,121,231,1,255,255,255,4,55,176,253,1,66,176,253,1,77,165,253,1,55,121,231,1,255,255,255,1,88,154,253,1,88,143,253,1,55,121,231,1,99,143,253,1,255,255,255,2,88,143,253,1,88,154,253,1,77,154,253,1,55,121,231,1,255,255,255,3,55,187,253,1,66,176,253,1,66,165,253,1,77,165,253,1,55,121,231,1,88,143,253,2,55,121,231,1,255,255,255,1,99,132,253,1,99,143,253,3,88,143,253,1,88,154,253,1,55,121,231,1,255,255,255,2,55,187,253,1,66,176,253,1,55,121,231,1,77,165,253,1,88,154,253,1,55,121,231,1,99,143,253,2,55,121,231,1,255,255,255,1,110,132,253,1,55,121,231,2,99,132,253,1,99,143,253,2,55,121,231,1,255,255,255,2,55,121,231,2,255,255,255,1,88,154,253,1,99,143,253,1,99,132,253,1,110,132,253,1,55,121,231,1,255,255,255,2,121,121,253,1,255,255,255,3,110,121,253,1,55,121,231,1,255,255,255,5,88,154,253,1,88,143,253,1,
99,143,253,1,110,132,253,1,110,121,253,2,121,121,253,3,121,110,253,3,121,121,253,1,55,121,231,1,255,255,255,4,77,154,253,1,55,121,231,5,121,121,253,1,121,110,253,1,132,110,253,2,55,121,231,2,255,255,255,6,77,165,253,1,88,154,253,1,255,255,255,5,55,121,231,1,132,110,253,2,55,121,231,1,255,255,255,8,77,154,253,1,88,154,253,1,255,255,255,6,55,121,231,2,255,255,255,9,88,154,253,1,88,143,253,1,255,255,255,17,55,121,231,2,255,255,255,15);
tep_go20:array[0..222] of byte=(
84,69,65,50,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,255,0,0,66,0,0,0,7,255,0,0,6,0,0,0,1,255,255,0,6,0,0,0,1,255,0,0,5,0,0,0,1,255,255,0,5,0,0,0,1,255,0,0,6,0,0,0,1,255,255,0,4,0,0,0,1,255,0,0,7,0,0,0,1,255,255,0,5,0,0,0,1,255,0,0,6,0,0,0,1,255,255,0,2,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,5,0,0,0,1,255,255,0,1,0,0,0,1,255,0,0,1,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,5,0,0,0,1,255,0,0,3,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,9,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,9,0,0,0,1,255,255,0,1,0,0,0,1,255,0,0,11,0,0,0,1,255,0,0,55);
}
{
tep_be20:array[0..680] of byte=(//purple icon from 2019-2021
84,69,65,49,35,19,0,0,0,20,0,0,0,255,0,0,2,227,218,245,7,207,192,238,1,227,218,245,1,83,109,207,1,227,218,245,2,207,192,238,1,83,109,207,1,255,0,0,4,227,218,245,6,207,192,238,2,83,109,207,1,207,192,238,6,83,109,207,1,255,0,0,2,227,218,245,1,83,109,207,1,255,0,0,4,207,192,238,1,83,109,207,1,207,192,238,3,83,109,207,1,255,0,0,2,207,192,238,3,255,0,0,2,83,109,207,1,255,0,0,4,207,192,238,2,255,0,0,1,207,192,238,1,197,172,234,1,207,192,238,1,83,109,207,1,255,0,0,3,207,192,238,2,83,109,207,1,255,0,0,6,207,192,238,2,255,0,0,1,197,172,234,3,83,109,207,1,255,0,0,3,197,172,234,2,83,109,207,1,255,0,0,5,197,172,234,3,255,0,0,1,197,172,234,3,83,109,207,1,255,0,0,2,197,172,234,3,255,0,0,4,207,192,238,1,197,172,234,2,207,192,238,1,197,172,234,1,255,0,0,1,197,172,234,1,138,160,246,1,197,172,234,1,83,109,207,1,197,172,234,1,138,160,246,1,197,172,234,1,138,160,246,1,83,109,207,1,255,0,0,2,207,192,238,2,83,109,207,1,207,192,238,1,197,172,234,1,138,160,246,1,197,172,234,1,255,0,0,1,138,160,246,4,83,109,207,2,138,160,
246,2,197,172,234,2,83,109,207,1,207,192,238,1,83,109,207,1,255,0,0,2,197,172,234,1,138,160,246,2,255,0,0,1,138,160,246,4,83,109,207,1,255,0,0,2,138,160,246,3,83,109,207,2,255,0,0,3,138,160,246,3,255,0,0,1,138,160,246,3,83,109,207,1,138,160,246,6,83,109,207,1,255,0,0,3,197,172,234,1,138,160,246,3,255,0,0,1,138,160,246,1,131,129,251,1,138,160,246,1,83,109,207,2,255,0,0,2,131,129,251,1,138,160,246,2,83,109,207,1,255,0,0,2,138,160,246,5,131,129,251,3,83,109,207,1,255,0,0,1,131,129,251,5,138,160,246,1,83,109,207,1,255,0,0,1,138,160,246,1,83,109,207,1,255,0,0,1,138,160,246,2,83,109,207,1,131,129,251,2,83,109,207,1,255,0,0,2,83,109,207,1,255,0,0,3,131,129,251,2,83,109,207,1,255,0,0,1,83,109,207,1,255,0,0,2,138,160,246,1,131,129,251,3,83,109,207,1,255,0,0,3,83,109,207,1,255,0,0,3,131,129,251,1,83,109,207,1,255,0,0,4,138,160,246,1,131,129,251,8,83,109,207,1,131,129,251,4,83,109,207,1,255,0,0,3,138,160,246,1,83,109,207,5,131,129,251,4,83,109,207,3,255,0,0,5,138,160,246,1,83,109,207,1,255,0,0,5,83,109,207,
2,131,129,251,2,255,0,0,8,138,160,246,1,83,109,207,1,255,0,0,17,138,160,246,1,83,109,207,1,255,0,0,17,83,109,207,1,255,0,0,17);
{}//yyy

//tep_go20:array[0..222] of byte=(
//84,69,65,50,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,20,0,0,0,255,0,0,66,0,0,0,7,255,0,0,6,0,0,0,1,255,255,0,6,0,0,0,1,255,0,0,5,0,0,0,1,255,255,0,5,0,0,0,1,255,0,0,6,0,0,0,1,255,255,0,4,0,0,0,1,255,0,0,7,0,0,0,1,255,255,0,5,0,0,0,1,255,0,0,6,0,0,0,1,255,255,0,2,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,5,0,0,0,1,255,255,0,1,0,0,0,1,255,0,0,1,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,5,0,0,0,1,255,0,0,3,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,9,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,9,0,0,0,1,255,255,0,1,0,0,0,1,255,0,0,11,0,0,0,1,255,0,0,55);
tep_go20:array[0..208] of byte=(
84,69,65,49,35,13,0,0,0,20,0,0,0,255,0,0,57,0,0,0,7,255,0,0,5,0,0,0,1,255,255,0,6,0,0,0,1,255,0,0,6,0,0,0,1,255,255,0,5,0,0,0,1,255,0,0,7,0,0,0,1,255,255,0,4,0,0,0,1,255,0,0,6,0,0,0,1,255,255,0,5,0,0,0,1,255,0,0,5,0,0,0,1,255,255,0,3,0,0,0,1,255,255,0,2,0,0,0,1,255,0,0,4,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,1,0,0,0,1,255,255,0,1,0,0,0,1,255,0,0,3,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,3,0,0,0,1,255,0,0,3,0,0,0,1,255,255,0,3,0,0,0,1,255,0,0,9,0,0,0,1,255,255,0,1,0,0,0,1,255,0,0,11,0,0,0,1,255,0,0,74);
tep_disk20:array[0..168] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,252,252,252,82,159,159,163,12,252,252,252,3,159,159,163,1,192,192,192,12,159,159,163,1,252,252,252,2,159,159,163,1,192,192,192,12,159,159,163,1,252,252,252,1,159,159,163,1,192,192,192,14,159,159,163,1,252,252,252,1,159,159,163,14,252,252,252,1,159,159,163,1,90,90,90,14,159,159,163,2,90,90,90,2,76,255,145,2,90,90,90,2,255,255,128,6,90,90,90,2,159,159,163,2,90,90,90,2,76,255,145,2,90,90,90,10,159,159,163,2,90,90,90,6,255,255,128,6,90,90,90,2,159,159,163,2,90,90,90,14,159,159,163,1,252,252,252,1,159,159,163,14,252,252,252,65);
tep_cd20:array[0..328] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,0,255,0,50,159,159,163,5,0,255,0,8,159,159,163,2,231,226,248,3,208,208,252,2,159,159,163,2,0,255,0,5,159,159,163,1,249,244,253,1,231,226,248,3,208,208,252,5,159,159,163,1,0,255,0,3,159,159,163,1,249,244,253,4,231,226,248,2,208,208,252,5,159,159,163,1,0,255,0,2,159,159,163,1,249,244,253,5,231,226,248,3,208,208,252,3,159,159,163,1,0,255,0,1,159,159,163,1,231,226,248,1,249,244,253,6,231,226,248,3,208,208,252,3,159,159,163,2,231,226,248,2,249,244,253,4,159,159,163,1,249,244,253,1,231,226,248,5,159,159,163,2,231,226,248,4,249,244,253,1,159,159,163,3,249,244,253,1,231,226,248,4,159,159,163,2,231,226,248,4,249,244,253,2,159,159,163,1,249,244,253,5,231,226,248,1,159,159,163,2,208,208,252,3,231,226,248,2,249,244,253,8,159,159,163,1,0,255,0,1,159,159,163,1,208,208,252,2,231,226,248,4,249,244,253,5,159,159,163,1,0,255,0,2,159,159,163,1,208,208,252,4,231,226,248,4,249,244,253,3,159,159,163,1,0,255,0,3,159,159,163,1,208,208,252,5,231,226,248,4,159,159,163,1,0,255,0,5,159,159,
163,2,208,208,252,3,231,226,248,3,159,159,163,1,0,255,0,8,159,159,163,6,0,255,0,34);
tep_removable20:array[0..208] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,252,252,252,13,159,159,163,1,252,252,252,10,159,159,163,5,252,252,252,10,159,159,163,2,252,252,252,14,159,159,163,1,252,252,252,14,159,159,163,2,252,252,252,10,159,159,163,12,252,252,252,3,159,159,163,1,192,192,192,12,159,159,163,1,252,252,252,2,159,159,163,1,192,192,192,12,159,159,163,1,252,252,252,1,159,159,163,1,192,192,192,14,159,159,163,1,252,252,252,1,159,159,163,14,252,252,252,1,159,159,163,1,90,90,90,14,159,159,163,2,90,90,90,2,76,255,145,2,90,90,90,2,255,255,128,6,90,90,90,2,159,159,163,2,90,90,90,2,76,255,145,2,90,90,90,10,159,159,163,2,90,90,90,6,255,255,128,6,90,90,90,2,159,159,163,2,90,90,90,14,159,159,163,1,252,252,252,1,159,159,163,14,252,252,252,65);
tep_menu20:array[0..160] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,255,255,34,0,128,255,12,255,255,255,3,0,128,255,1,128,255,255,12,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,12,0,128,255,1,255,255,255,3,0,128,255,12,255,255,255,36,0,128,255,12,255,255,255,3,0,128,255,1,255,255,0,12,0,128,255,1,255,255,255,2,0,128,255,1,255,255,0,12,0,128,255,1,255,255,255,3,0,128,255,12,255,255,255,36,0,128,255,12,255,255,255,3,0,128,255,1,128,255,255,12,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,12,0,128,255,1,255,255,255,3,0,128,255,12,255,255,255,34);
tep_invert20:array[0..256] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,0,0,37,64,138,213,6,255,0,0,8,64,138,213,1,255,0,255,6,64,138,213,1,255,0,0,7,64,138,213,1,255,0,255,6,64,138,213,1,255,0,0,7,64,138,213,1,255,0,255,6,64,138,213,1,255,0,0,7,64,138,213,1,255,0,255,6,64,138,213,1,255,0,0,7,64,138,213,1,255,0,255,6,64,138,213,1,255,0,0,7,64,138,213,1,255,0,255,6,64,138,213,1,255,0,0,7,64,138,213,1,255,0,255,2,64,138,213,4,255,0,0,4,64,138,213,4,255,255,0,2,64,138,213,1,255,0,0,7,64,138,213,1,255,255,0,6,64,138,213,1,255,0,0,7,64,138,213,1,255,255,0,6,64,138,213,1,255,0,0,7,64,138,213,1,255,255,0,6,64,138,213,1,255,0,0,7,64,138,213,1,255,255,0,6,64,138,213,1,255,0,0,7,64,138,213,1,255,255,0,6,64,138,213,1,255,0,0,7,64,138,213,1,255,255,0,6,64,138,213,1,255,0,0,8,64,138,213,6,255,0,0,37);
tep_tick20:array[0..368] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,66,124,136,207,2,255,0,0,3,124,136,207,3,255,0,0,7,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,3,124,136,207,1,255,0,0,6,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,4,124,136,207,1,255,0,0,5,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,5,124,136,207,1,255,0,0,4,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,6,124,136,207,1,255,0,0,3,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,7,124,136,207,1,255,0,0,2,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,7,124,136,207,1,255,0,0,2,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,6,124,136,207,1,255,0,0,3,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,5,124,136,207,1,255,0,0,4,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,4,124,136,
207,1,255,0,0,5,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,1,124,136,207,1,200,245,255,3,124,136,207,1,255,0,0,7,124,136,207,2,255,0,0,3,124,136,207,3,255,0,0,70);
tep_untick20:array[0..192] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,66,124,136,207,2,255,0,0,13,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,12,124,136,207,1,200,245,255,2,124,136,207,1,255,0,0,13,124,136,207,2,255,0,0,76);
tep_ticktwo20:array[0..80] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,102,0,0,0,4,255,0,0,11,0,0,0,6,255,0,0,9,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,9,0,0,0,6,255,0,0,11,0,0,0,4,255,0,0,102);
tep_unticktwo20:array[0..128] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,102,0,0,0,4,255,0,0,11,0,0,0,1,255,0,0,4,0,0,0,1,255,0,0,9,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,9,0,0,0,1,255,0,0,4,0,0,0,1,255,0,0,11,0,0,0,4,255,0,0,102);
tep_tickthree20:array[0..80] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,100,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,8,0,0,0,8,255,0,0,100);
tep_untickthree20:array[0..128] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,100,0,0,0,8,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,1,255,0,0,6,0,0,0,1,255,0,0,8,0,0,0,8,255,0,0,100);
tep_screen20:array[0..200] of byte=(
84,69,65,49,35,18,0,0,0,20,0,0,0,0,255,0,55,0,0,128,16,0,255,0,1,0,0,128,1,166,166,255,16,0,0,128,2,166,166,255,15,0,0,255,1,0,0,128,2,166,166,255,13,0,0,255,3,0,0,128,2,166,166,255,12,0,0,255,4,0,0,128,2,166,166,255,10,0,0,255,6,0,0,128,2,166,166,255,9,0,0,255,7,0,0,128,2,166,166,255,7,0,0,255,9,0,0,128,2,166,166,255,6,0,0,255,10,0,0,128,2,166,166,255,4,0,0,255,12,0,0,128,2,166,166,255,3,0,0,255,13,0,0,128,2,166,166,255,1,0,0,255,15,0,0,128,1,0,255,0,1,0,0,128,16,0,255,0,8,0,0,128,3,0,255,0,15,0,0,128,3,0,255,0,13,0,0,128,7,0,255,0,11,0,0,128,7,0,255,0,6);
tep_wrap20:array[0..168] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,232,232,232,86,115,115,255,14,232,232,232,3,115,115,255,15,232,232,232,2,255,255,201,13,115,115,255,2,232,232,232,2,255,255,201,13,115,115,255,2,232,232,232,2,255,255,201,13,115,115,255,2,232,232,232,2,255,255,201,3,115,115,255,1,255,255,201,9,115,115,255,2,232,232,232,2,255,255,201,2,115,115,255,2,255,255,201,9,115,115,255,2,232,232,232,2,255,255,201,1,115,115,255,3,255,255,201,9,115,115,255,2,232,232,232,2,115,115,255,15,232,232,232,2,115,115,255,14,232,232,232,4,115,115,255,3,232,232,232,15,115,115,255,2,232,232,232,16,115,115,255,1,232,232,232,46);
//file format teps -------------------------------------------------------------
tep_Quoter20:array[0..400] of byte=(
84,69,65,49,35,19,0,0,0,20,0,0,0,252,252,252,78,50,88,106,5,252,252,252,5,50,88,106,5,252,252,252,4,50,88,106,1,158,189,204,4,50,88,106,1,252,252,252,4,50,88,106,1,158,189,204,4,50,88,106,1,252,252,252,2,50,88,106,1,158,189,204,5,50,88,106,1,252,252,252,3,50,88,106,1,158,189,204,6,50,88,106,1,252,252,252,2,50,88,106,1,158,189,204,5,50,88,106,1,252,252,252,3,50,88,106,1,158,189,204,5,50,88,106,1,252,252,252,3,50,88,106,1,158,189,204,3,50,88,106,1,252,252,252,5,50,88,106,1,158,189,204,4,50,88,106,1,252,252,252,4,50,88,106,1,158,189,204,2,50,88,106,1,252,252,252,6,50,88,106,1,158,189,204,2,50,88,106,1,252,252,252,5,50,88,106,1,158,189,204,2,50,88,106,1,252,252,252,6,50,88,106,1,158,189,204,2,50,88,106,1,252,252,252,5,50,88,106,1,158,189,204,2,50,88,106,1,252,252,252,6,50,88,106,1,158,189,204,2,50,88,106,1,252,252,252,5,50,88,106,1,158,189,204,1,50,88,106,1,252,252,252,7,50,88,106,1,158,189,204,1,50,88,106,1,252,252,252,5,50,88,106,1,158,189,204,1,50,88,106,1,252,252,252,7,50,88,106,1,158,189,204,1,
50,88,106,1,252,252,252,6,50,88,106,2,252,252,252,8,50,88,106,1,158,189,204,1,50,88,106,1,252,252,252,5,50,88,106,2,252,252,252,8,50,88,106,1,158,189,204,1,50,88,106,1,252,252,252,5,50,88,106,2,252,252,252,8,50,88,106,3,252,252,252,5,50,88,106,2,252,252,252,8,50,88,106,2,252,252,252,45);
tep_sfef20:array[0..500] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,255,0,0,9,112,143,116,2,255,0,0,17,106,135,110,1,107,215,0,2,106,135,110,1,255,0,0,15,101,128,104,1,101,204,0,4,101,128,104,1,255,0,0,13,95,120,98,1,96,192,0,6,95,120,98,1,255,0,0,11,89,113,92,1,90,181,0,8,89,113,92,1,255,0,0,9,83,105,86,1,84,170,0,4,119,180,29,1,122,181,31,1,84,170,0,4,83,105,86,1,255,0,0,7,77,98,80,1,78,158,0,4,108,168,23,1,213,213,106,2,108,168,24,1,78,158,0,4,77,98,80,1,255,0,0,5,71,90,73,1,73,146,0,5,119,169,35,1,213,213,106,2,119,169,35,1,73,146,0,5,71,90,73,1,255,0,0,3,65,82,67,1,67,134,0,4,96,152,20,1,120,165,37,1,143,177,54,1,213,213,106,2,138,174,50,1,122,166,39,1,104,156,25,1,67,134,0,4,65,82,67,1,255,0,0,1,59,75,61,1,61,123,0,4,91,142,21,1,213,213,106,8,92,142,21,1,61,123,0,4,59,75,61,1,53,68,55,1,55,112,0,4,86,131,21,1,213,213,106,8,86,131,21,1,55,112,0,4,53,68,55,1,255,0,0,1,47,60,49,1,50,100,0,4,81,119,21,1,101,133,35,1,126,150,50,1,213,213,106,2,121,147,47,1,104,135,36,1,89,125,26,1,50,100,0,4,47,60,49,1,255,0,0,3,41,52,42,1,44,88,
0,5,104,131,39,1,213,213,106,2,104,131,39,1,44,88,0,5,41,52,42,1,255,0,0,5,35,45,37,1,38,77,0,4,83,112,27,1,213,213,106,2,83,112,27,1,38,77,0,4,35,45,37,1,255,0,0,7,29,37,30,1,32,65,0,4,87,110,31,1,92,114,34,1,32,65,0,4,29,37,30,1,255,0,0,9,23,30,24,1,27,54,0,8,23,30,24,1,255,0,0,11,17,22,18,1,21,42,0,6,17,22,18,1,255,0,0,13,11,14,12,1,15,30,0,4,11,14,12,1,255,0,0,15,6,7,6,1,9,19,0,2,6,7,6,1,255,0,0,17,9,19,0,2,255,0,0,9);

mtep_choco20
:array[0..891] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,20,0,0,0,0,0,0,21,0,0,0,0,1,168,0,0,0,19,0,0,0,0,5,168,0,0,0,1,141,0,0,0,10,114,0,0,0,1,141,0,0,0,3,0,0,0,0,1,168,0,0,0,1,194,0,0,0,3,220,0,0,0,1,194,0,0,0,2,168,0,0,0,2,194,0,0,0,1,141,0,0,0,5,114,0,0,0,1,168,0,0,0,3,0,0,0,0,1,168,0,0,0,1,220,0,0,0,1,239,0,0,0,7,220,0,0,0,4,194,0,0,0,2,114,0,0,0,1,168,0,0,0,2,0,0,0,0,1,168,0,0,0,1,194,0,0,0,6,239,0,0,0,3,220,0,0,0,4,239,0,0,0,1,141,0,0,0,1,114,0,0,0,1,168,0,0,0,2,0,0,0,0,1,168,0,0,0,1,194,0,0,0,4,239,0,0,0,1,220,0,0,0,1,168,0,0,0,2,114,0,0,0,1,141,0,0,0,1,220,0,0,0,3,239,0,0,0,1,194,0,0,0,1,114,0,0,0,1,168,0,0,0,3,0,0,0,0,1,168,0,0,0,1,220,0,0,0,2,239,0,0,0,1,220,0,0,0,2,168,0,0,0,2,220,0,0,0,1,141,0,0,0,1,220,0,0,0,1,239,0,0,0,1,220,0,0,0,1,194,0,0,0,1,220,0,0,0,1,114,0,0,0,1,168,0,0,0,3,0,0,0,0,1,168,0,0,0,1,220,0,0,0,2,239,0,0,0,1,194,0,0,0,1,141,0,0,0,1,220,0,0,0,1,239,0,0,0,1,220,0,0,0,1,168,0,0,0,2,239,0,0,0,1,168,0,0,0,1,194,0,0,0,1,220,0,0,0,1,141,0,0,0,1,168,0,0,0,
2,0,0,0,0,1,168,0,0,0,1,194,0,0,0,3,239,0,0,0,1,141,0,0,0,1,168,0,0,0,3,239,0,0,0,2,220,0,0,0,1,239,0,0,0,1,220,0,0,0,1,239,0,0,0,1,220,0,0,0,1,141,0,0,0,1,168,0,0,0,2,0,0,0,0,1,168,0,0,0,1,194,0,0,0,2,239,0,0,0,1,220,0,0,0,1,114,0,0,0,1,141,0,0,0,1,220,0,0,0,1,239,0,0,0,1,220,0,0,0,2,168,0,0,0,1,239,0,0,0,1,168,0,0,0,2,220,0,0,0,2,168,0,0,0,3,0,0,0,0,1,168,0,0,0,1,220,0,0,0,1,239,0,0,0,1,220,0,0,0,1,141,0,0,0,1,114,0,0,0,2,141,0,0,0,1,114,0,0,0,1,141,0,0,0,2,220,0,0,0,1,168,0,0,0,2,220,0,0,0,2,194,0,0,0,3,0,0,0,0,1,168,0,0,0,1,220,0,0,0,2,239,0,0,0,1,194,0,0,0,3,114,0,0,0,1,168,0,0,0,1,220,0,0,0,4,239,0,0,0,1,220,0,0,0,2,194,0,0,0,2,0,0,0,0,1,168,0,0,0,1,194,0,0,0,4,239,0,0,0,1,220,0,0,0,1,194,0,0,0,1,220,0,0,0,7,239,0,0,0,2,194,0,0,0,1,141,0,0,0,1,0,0,0,0,1,168,0,0,0,1,194,0,0,0,14,239,0,0,0,1,194,0,0,0,1,168,0,0,0,1,141,0,0,0,2,0,0,0,0,1,168,0,0,0,1,220,0,0,0,12,239,0,0,0,1,220,0,0,0,1,194,0,0,0,1,168,0,0,0,3,0,0,0,0,1,168,0,0,0,1,194,0,0,0,1,220,0,0,0,12,194,0,0,0,1,168,0,
0,0,1,141,0,0,0,2,0,0,0,0,1,194,0,0,0,1,168,0,0,0,15,141,0,0,0,2,114,0,0,0,2,0,0,0,0,1,168,0,0,0,16,0,0,0,0,2,114,0,0,0,20,0);

tep_choco20:array[0..1361] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,18,0,0,0,194,218,243,1,133,195,218,242,1,109,255,0,0,18,0,223,235,248,1,98,126,180,230,1,126,142,189,233,1,118,148,193,235,1,115,142,190,234,1,115,142,183,222,1,115,150,130,137,1,115,157,82,28,1,115,158,80,16,1,115,156,92,58,1,115,155,97,72,1,115,158,80,19,1,115,158,80,20,2,115,158,80,20,1,114,156,79,20,1,111,143,82,47,1,97,238,231,226,1,57,255,0,0,3,0,151,193,234,1,114,142,189,234,1,173,139,188,233,1,195,124,179,230,1,200,124,179,230,1,201,125,177,226,1,201,135,143,168,1,201,136,139,159,1,201,128,167,209,1,201,128,164,203,1,201,146,89,63,1,201,149,71,3,1,201,149,71,0,1,200,149,72,0,1,199,146,70,4,1,192,135,77,47,1,162,238,231,226,1,90,255,0,0,3,0,133,184,231,1,135,142,189,234,1,203,139,188,233,1,229,124,179,230,1,235,124,179,230,6,236,131,154,186,1,236,139,127,139,1,236,134,145,169,1,236,132,149,175,1,234,145,78,41,1,225,135,77,47,1,188,238,231,226,1,103,255,0,0,2,0,173,205,238,1,104,124,179,230,1,175,142,189,234,1,226,139,
188,233,1,243,124,179,230,1,248,124,179,230,2,249,125,176,225,1,249,129,162,198,1,249,130,158,192,1,249,126,173,219,1,249,124,179,230,1,249,124,179,229,1,249,124,179,230,1,248,124,177,227,1,246,141,101,91,1,236,135,77,47,1,197,238,231,226,1,108,255,0,0,2,0,200,221,243,1,98,124,179,230,1,169,142,189,234,1,226,139,188,233,1,247,124,179,230,1,252,124,179,230,1,253,128,165,205,1,253,143,107,100,1,253,148,78,25,1,253,148,77,27,1,253,145,96,75,1,253,127,169,212,1,253,124,179,230,1,253,124,179,230,1,252,124,180,231,1,250,134,133,151,1,240,134,77,47,1,199,238,231,226,1,109,255,0,0,3,0,146,190,233,1,133,142,189,234,1,212,139,188,233,1,245,124,179,230,1,253,127,169,212,1,254,145,97,81,1,254,143,106,99,1,254,131,156,190,1,254,131,156,189,1,254,147,85,51,1,254,131,156,188,1,254,124,179,230,1,254,131,155,188,1,254,134,144,168,1,251,126,157,193,1,241,134,80,53,1,200,238,231,226,1,110,255,0,0,3,0,135,185,232,1,141,142,189,234,1,215,139,188,233,1,245,124,178,229,1,253,139,127,138,1,255,147,86,
54,1,255,127,169,211,1,255,124,179,231,1,255,128,166,206,1,255,144,99,80,1,255,126,172,217,1,255,125,176,224,1,255,144,102,86,1,254,138,131,146,1,251,123,172,219,1,241,132,90,73,1,201,238,231,226,1,110,255,0,0,2,0,178,208,239,1,104,124,179,230,1,177,142,189,234,1,230,139,188,233,1,248,126,172,217,1,253,146,85,48,1,255,142,111,111,1,255,125,177,227,1,255,124,179,230,1,255,126,171,214,1,255,130,160,194,1,255,131,154,184,1,255,124,178,228,1,255,127,170,214,1,254,125,176,225,1,251,122,175,227,1,241,130,110,117,1,201,238,231,226,1,110,255,0,0,2,0,192,216,242,1,99,124,179,230,1,170,142,189,234,1,227,139,188,233,1,248,128,165,205,1,253,148,75,5,1,255,146,88,58,1,255,129,164,203,1,255,125,175,222,1,255,130,160,196,1,255,142,113,114,1,255,141,113,110,1,255,126,172,218,1,255,140,118,121,1,254,131,155,186,1,251,122,176,227,1,241,126,130,156,1,201,238,230,226,1,110,255,0,0,3,0,142,188,233,1,133,142,189,234,1,212,139,188,233,1,245,127,171,215,1,253,147,83,42,1,255,149,72,4,1,255,147,81,37,
1,255,145,91,62,1,255,148,75,12,1,255,145,96,79,1,255,128,167,208,1,255,129,162,199,1,255,143,104,96,1,254,128,164,204,1,252,122,175,227,1,242,123,147,187,1,202,238,233,230,1,116,255,0,0,3,0,139,187,232,1,141,142,189,234,1,215,139,188,233,1,245,124,178,228,1,253,137,132,148,1,255,149,73,2,1,255,149,71,2,1,255,149,72,0,1,255,143,106,99,1,255,128,166,206,1,255,124,179,230,1,255,124,178,229,1,255,125,176,224,1,254,124,179,230,1,252,122,175,227,1,244,116,155,206,1,212,220,229,241,1,135,255,0,0,2,0,183,211,240,1,104,124,179,230,1,177,142,189,234,1,230,139,188,233,1,248,124,179,230,1,253,125,176,225,1,255,133,150,180,1,255,137,133,151,1,255,133,150,178,1,255,126,174,221,1,255,124,179,230,3,255,124,179,230,1,254,124,179,230,1,253,122,175,227,1,247,111,153,207,1,227,140,184,229,1,168,228,238,249,1,72,255,0,0,1,0,187,213,241,1,99,124,179,230,1,170,142,189,234,1,227,139,188,233,1,248,124,179,230,1,253,124,179,230,8,255,124,179,230,1,254,124,179,230,1,253,122,175,227,1,247,111,153,207,1,
224,122,175,226,1,160,175,206,238,1,67,255,0,0,2,0,140,187,233,1,132,142,189,234,1,205,139,188,233,1,236,124,179,230,1,244,124,179,230,8,246,124,179,230,1,245,124,179,230,1,244,122,175,227,1,236,111,153,207,1,203,126,177,227,1,124,255,0,0,3,0,147,191,234,1,122,142,190,234,1,172,138,187,233,1,191,123,177,229,1,197,123,177,229,9,198,123,177,229,1,196,121,174,226,1,189,110,153,207,1,162,124,176,227,1,100,255,0,0,2,0,218,232,247,1,114,125,180,230,1,130,140,186,231,1,109,125,166,215,1,104,118,159,211,10,104,118,159,211,1,103,117,159,211,1,99,117,157,209,1,88,124,176,227,1,66,153,194,235,1,43,255,0,0,1,0,198,221,243,1,130,211,228,245,1,103,255,0,0,16,0,195,218,242,1,39,222,235,248,1,43);

tep_bmp20:array[0..576] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,234,0,0,49,130,156,208,11,234,0,0,5,130,156,208,1,255,255,255,7,234,234,234,2,130,156,208,1,104,156,208,1,234,0,0,4,130,156,208,1,255,255,255,4,234,234,234,5,52,156,234,2,52,130,208,1,234,0,0,3,130,156,208,1,234,234,234,1,255,255,255,2,234,234,234,6,182,208,234,2,156,156,234,1,104,130,156,1,234,0,0,2,130,156,208,1,234,234,234,1,234,156,104,1,234,104,52,2,234,130,52,3,234,156,78,1,234,182,78,1,208,234,234,3,182,182,234,1,234,0,0,2,130,156,208,1,234,234,234,1,234,130,78,1,182,78,26,1,234,104,52,1,234,130,52,3,234,156,78,1,234,208,130,1,234,182,104,1,234,156,78,1,130,156,182,1,182,182,234,1,234,0,0,2,130,156,208,1,234,234,234,1,182,52,26,1,104,52,26,1,156,52,0,1,182,52,26,3,208,52,26,1,234,78,26,2,208,52,26,1,130,156,182,1,182,182,234,1,234,0,0,2,130,156,208,1,234,234,234,1,208,130,78,1,130,78,26,1,156,78,26,1,234,130,52,4,234,182,78,1,234,130,52,2,130,156,182,1,182,182,234,1,234,0,0,2,130,156,208,1,208,234,234,1,208,156,104,1,182,104,78,1,78,52,26,1,208,130,78,4,234,
208,104,2,208,130,78,1,130,156,208,1,156,182,234,1,234,0,0,2,104,156,182,1,208,208,234,1,182,156,130,1,182,130,104,1,78,52,52,1,182,130,104,3,208,156,104,1,208,182,130,1,234,182,104,1,182,130,104,1,104,156,208,1,156,182,234,1,234,0,0,2,104,130,182,1,208,208,234,1,156,130,156,1,130,104,156,1,104,104,182,1,156,130,130,3,208,182,130,1,234,208,130,1,234,208,104,1,156,130,130,1,104,156,208,1,156,182,234,1,234,0,0,2,104,130,182,1,208,208,234,1,130,130,182,1,130,104,182,1,130,104,156,1,130,130,156,3,156,130,130,1,208,182,130,1,208,182,104,1,156,130,156,1,104,156,208,1,156,182,234,1,234,0,0,2,104,130,182,1,208,208,208,1,208,208,234,1,156,208,234,2,156,182,234,5,130,182,234,2,156,208,234,1,156,182,234,1,234,0,0,2,104,130,156,1,208,208,208,1,208,208,234,1,182,208,234,7,156,208,234,3,156,182,234,1,234,0,0,2,104,104,156,1,156,156,208,1,130,156,208,3,130,156,182,5,130,130,182,4,234,0,0,33);
tep_wma20:array[0..656] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,132,255,255,32,132,173,222,9,132,255,255,6,132,173,222,1,255,255,255,3,247,255,255,3,219,239,252,1,132,173,222,2,93,109,137,1,132,255,255,4,132,173,222,1,255,255,255,1,247,255,255,2,219,239,252,1,247,255,255,1,219,239,252,2,76,131,225,1,107,165,255,1,76,131,225,1,93,109,137,1,132,255,255,3,132,173,222,1,247,255,255,3,219,239,252,5,181,205,249,1,156,181,239,1,76,131,225,1,132,255,255,3,76,131,225,1,93,109,137,5,90,177,103,1,219,239,252,4,198,206,231,1,93,109,137,1,132,255,255,1,198,206,231,1,57,61,61,1,206,189,107,1,206,123,90,1,198,206,231,1,206,189,107,1,90,177,103,2,93,109,137,1,198,206,231,1,219,239,252,2,181,205,249,1,93,109,137,1,198,206,231,1,57,61,61,1,206,123,90,1,206,189,107,1,247,255,255,2,219,239,252,1,198,206,231,1,90,177,103,2,93,109,137,1,198,206,231,1,219,239,252,1,181,205,249,1,68,79,106,1,93,109,137,1,206,123,90,2,247,255,255,1,198,206,231,1,219,239,252,3,156,181,239,1,90,177,103,2,93,109,137,1,219,239,252,1,181,205,249,1,68,79,106,2,206,123,90,2,
219,239,252,1,76,131,225,2,132,173,222,1,198,206,231,1,156,181,239,1,90,177,103,2,68,79,106,1,181,205,249,2,68,79,106,1,57,61,61,1,206,123,90,1,198,206,231,1,156,181,239,1,93,109,137,1,57,61,61,2,68,79,106,1,156,181,239,1,93,109,137,1,90,177,103,1,57,61,61,1,132,173,222,1,181,205,249,1,93,109,137,1,68,79,106,1,76,131,225,1,156,181,239,1,198,206,231,1,57,61,61,1,68,79,106,2,156,181,239,2,93,109,137,1,90,177,103,1,57,61,61,1,132,173,222,1,198,206,231,1,68,79,106,1,93,109,137,1,76,131,225,1,132,173,222,1,219,239,252,1,156,181,239,2,247,255,255,2,156,181,239,1,206,123,90,2,57,61,61,1,132,173,222,1,181,205,249,1,68,79,106,1,198,206,231,1,68,79,106,1,76,131,225,1,198,206,231,1,247,255,255,3,198,206,231,1,206,189,107,2,68,79,106,2,156,181,239,2,68,79,106,1,132,255,255,1,93,109,137,1,107,165,255,3,132,173,222,1,206,189,107,3,206,123,90,1,57,61,61,1,90,177,103,1,198,206,231,1,156,181,239,1,93,109,137,1,132,255,255,2,57,61,61,1,93,109,137,1,76,131,225,2,206,189,107,1,206,123,90,2,57,61,61,1,93,109,137,1,132,
173,222,1,90,177,103,1,132,173,222,1,93,109,137,1,132,255,255,2,181,205,249,1,68,79,106,1,57,61,61,6,68,79,106,2,93,109,137,1,68,79,106,1,132,255,255,31);
tep_r20:array[0..384] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,36,0,128,255,13,255,255,255,3,0,128,255,1,128,255,255,13,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,13,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,6,128,255,255,4,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,7,128,255,255,3,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,2,128,255,255,3,255,0,128,2,128,255,255,3,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,2,128,255,255,3,255,0,128,2,128,255,255,3,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,2,128,255,255,3,255,0,128,2,128,255,255,3,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,6,128,255,255,4,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,7,128,255,255,3,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,2,128,255,255,3,255,0,128,2,128,255,255,3,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,3,255,0,128,2,128,255,255,3,255,0,128,2,128,255,255,3,0,128,255,1,255,255,255,
2,0,128,255,1,128,255,255,3,255,0,128,2,128,255,255,3,255,0,128,2,128,255,255,3,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,13,0,128,255,1,255,255,255,2,0,128,255,1,128,255,255,13,0,128,255,1,255,255,255,3,0,128,255,13,255,255,255,36);
tep_xml20:array[0..408] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,36,106,0,137,13,255,255,255,3,106,0,137,1,241,255,73,13,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,13,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,3,168,40,206,2,241,255,73,3,168,40,206,2,241,255,73,3,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,3,168,40,206,2,241,255,73,3,168,40,206,2,241,255,73,3,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,3,168,40,206,2,241,255,73,3,168,40,206,2,241,255,73,3,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,4,168,40,206,2,241,255,73,1,168,40,206,2,241,255,73,4,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,4,168,40,206,5,241,255,73,4,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,5,168,40,206,3,241,255,73,5,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,4,168,40,206,5,241,255,73,4,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,4,168,40,206,2,241,255,73,1,168,40,206,2,241,255,73,4,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,3,168,40,206,2,241,255,73,3,168,40,206,2,241,255,73,3,106,0,137,
1,255,255,255,2,106,0,137,1,241,255,73,3,168,40,206,2,241,255,73,3,168,40,206,2,241,255,73,3,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,3,168,40,206,2,241,255,73,3,168,40,206,2,241,255,73,3,106,0,137,1,255,255,255,2,106,0,137,1,241,255,73,13,106,0,137,1,255,255,255,3,106,0,137,13,255,255,255,36);
tep_htm20:array[0..400] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,36,0,128,0,13,255,255,255,3,0,128,0,1,0,255,64,13,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,13,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,7,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,7,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,3,255,128,0,2,0,255,64,3,255,128,0,2,0,255,64,3,0,128,
0,1,255,255,255,2,0,128,0,1,0,255,64,13,0,128,0,1,255,255,255,2,0,128,0,1,0,255,64,13,0,128,0,1,255,255,255,3,0,128,0,13,255,255,255,36);
tep_exe20:array[0..344] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,36,95,22,117,13,255,255,255,3,95,22,117,1,228,10,244,13,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,13,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,13,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,2,241,255,73,6,228,10,244,5,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,2,241,255,73,5,228,10,244,6,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,2,241,255,73,4,228,10,244,7,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,2,241,255,73,5,228,10,244,6,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,2,241,255,73,2,228,10,244,1,241,255,73,3,228,10,244,5,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,2,241,255,73,1,228,10,244,3,241,255,73,3,228,10,244,4,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,7,241,255,73,3,228,10,244,3,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,8,241,255,73,3,228,10,244,2,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,9,241,255,73,1,228,10,244,3,95,22,117,1,255,255,255,2,95,22,117,1,228,10,244,13,95,22,117,
1,255,255,255,2,95,22,117,1,228,10,244,13,95,22,117,1,255,255,255,3,95,22,117,13,255,255,255,36);
tep_c2p20:array[0..360] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,36,128,128,0,13,255,255,255,3,128,128,0,1,255,255,128,13,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,13,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,8,255,255,128,3,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,9,255,255,128,2,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,3,255,255,128,4,255,0,128,2,255,255,128,2,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,3,255,255,128,4,255,0,128,2,255,255,128,2,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,3,255,255,128,4,255,0,128,2,255,255,128,2,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,9,255,255,128,2,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,8,255,255,128,3,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,3,255,255,128,8,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,3,255,255,128,8,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,2,255,0,128,3,255,255,128,
8,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,13,128,128,0,1,255,255,255,2,128,128,0,1,255,255,128,13,128,128,0,1,255,255,255,3,128,128,0,13,255,255,255,36);
tep_c2v20:array[0..296] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,255,255,255,31,128,0,255,13,255,255,255,1,128,0,255,1,229,255,255,13,128,0,255,2,229,255,255,13,128,0,255,2,229,255,255,2,128,0,255,2,229,255,255,5,128,0,255,2,229,255,255,2,128,0,255,2,229,255,255,2,128,0,255,2,229,255,255,5,128,0,255,2,229,255,255,2,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,3,128,0,255,2,229,255,255,4,128,0,255,2,229,255,255,1,128,0,255,2,229,255,255,4,128,0,255,2,229,255,255,4,128,0,255,2,229,255,255,1,128,0,255,2,229,255,255,4,128,0,255,2,229,255,255,4,128,0,255,2,229,255,255,1,128,0,255,2,229,255,255,4,128,0,255,2,229,255,255,5,128,0,255,3,229,255,255,5,128,0,255,2,229,255,255,5,128,0,255,3,229,255,255,5,128,0,255,2,229,255,255,13,128,0,255,2,229,255,255,13,128,0,255,1,255,255,255,1,128,0,255,13,255,255,255,31);
tep_zip20:array[0..344] of byte=(
84,69,65,49,35,17,0,0,0,20,0,0,0,255,255,255,36,0,0,128,13,255,255,255,3,0,0,128,1,116,116,185,13,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,13,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,3,0,255,255,7,116,116,185,3,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,3,0,255,255,7,116,116,185,3,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,9,0,255,255,1,116,116,185,3,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,8,0,255,255,2,116,116,185,3,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,7,0,255,255,2,116,116,185,4,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,6,0,255,255,2,116,116,185,5,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,5,0,255,255,2,116,116,185,6,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,4,0,255,255,2,116,116,185,7,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,3,0,255,255,2,116,116,185,8,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,3,0,255,255,7,116,116,185,3,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,3,0,255,255,7,116,116,185,3,0,0,128,1,255,255,255,2,0,0,128,1,116,116,185,13,
0,0,128,1,255,255,255,3,0,0,128,13,255,255,255,36);
tep_txt20:array[0..604] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,255,0,0,44,188,154,77,1,212,191,75,1,144,107,49,1,163,132,60,1,212,191,75,1,147,125,98,2,212,191,75,1,132,110,109,1,157,130,93,1,255,0,0,4,120,120,193,2,144,107,49,1,188,170,145,1,141,121,111,1,185,182,211,2,169,144,111,1,190,180,186,1,157,130,93,1,163,163,163,1,255,0,0,2,120,120,192,1,196,198,226,1,134,105,66,1,233,244,242,1,134,105,66,1,236,246,244,1,134,105,66,2,247,251,250,1,134,105,66,1,255,255,255,1,113,113,113,1,255,0,0,2,120,120,192,1,187,205,208,1,233,244,242,3,236,246,244,1,241,248,247,2,247,251,250,1,252,253,253,1,255,255,255,1,113,113,113,1,255,0,0,2,120,120,192,1,193,207,214,1,233,244,242,3,236,246,244,1,241,248,247,2,247,251,250,1,252,253,253,1,255,255,255,1,113,113,113,1,255,0,0,2,120,120,192,1,191,206,213,1,233,244,242,1,126,127,127,3,187,189,189,2,247,251,250,1,252,253,253,1,255,255,255,1,113,113,113,1,255,0,0,2,120,120,192,1,191,205,213,1,233,244,242,3,236,246,244,1,241,248,247,2,247,251,250,1,252,253,253,1,255,255,255,1,113,113,113,1,255,0,0,2,
120,120,192,1,190,208,209,1,233,244,242,1,126,127,127,5,187,189,189,1,255,255,255,2,113,113,113,1,255,0,0,2,120,120,192,1,190,208,209,1,233,244,242,1,255,255,255,8,113,113,113,1,255,0,0,2,120,120,192,1,190,205,212,1,233,244,242,3,236,246,244,1,241,248,247,2,247,251,250,1,252,253,253,1,255,255,255,1,113,113,113,1,255,0,0,2,120,120,192,1,191,202,216,1,233,244,242,1,126,127,127,5,187,189,189,1,255,255,255,2,113,113,113,1,255,0,0,2,120,120,192,1,193,206,217,1,233,244,242,3,236,246,244,1,241,248,247,2,247,251,250,1,252,253,253,1,255,255,255,1,113,113,113,1,255,0,0,2,120,120,192,1,188,204,212,1,233,244,242,1,126,127,127,1,187,189,189,1,236,246,244,1,241,248,247,2,247,251,250,1,252,253,253,1,255,255,255,1,113,113,113,1,255,0,0,2,120,120,192,1,182,202,206,1,233,244,242,2,235,245,243,1,236,245,244,1,195,201,200,2,188,192,192,1,161,164,163,1,143,144,144,1,148,148,148,1,255,0,0,3,188,191,202,1,155,161,161,1,125,129,129,1,106,108,108,1,104,104,104,1,113,113,113,2,128,128,128,1,141,141,141,1,159,159,159,1,255,
0,0,30);
tep_pas20:array[0..698] of byte=(
84,69,65,50,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,255,0,0,40,0,0,0,10,255,0,0,8,0,0,0,1,255,255,255,8,0,0,0,2,255,0,0,7,0,0,0,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,0,0,0,3,255,0,0,6,0,0,0,1,255,255,255,2,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,0,0,0,4,255,0,0,5,0,0,0,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,0,0,0,1,255,0,0,5,0,0,0,1,255,255,255,2,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,0,0,0,1,255,0,0,5,0,0,0,1,255,255,255,1,0,0,0,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,0,0,0,1,255,0,0,5,0,0,0,2,255,255,255,1,0,0,0,2,192,192,192,1,255,255,255,1,192,192,192,1,255,255,
255,1,192,192,192,1,255,255,255,1,192,192,192,1,0,0,0,1,255,0,0,3,0,0,0,2,255,255,255,2,255,255,0,3,0,0,0,2,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,0,0,0,1,255,0,0,2,0,0,0,1,255,255,255,2,255,255,0,7,0,0,0,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,0,0,0,1,255,0,0,3,0,0,0,1,192,192,192,7,0,0,0,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,0,0,0,1,255,0,0,3,0,0,0,1,255,255,0,1,192,192,192,2,255,255,0,1,192,192,192,2,255,255,0,1,0,0,0,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,0,0,0,1,255,0,0,3,0,0,0,1,255,255,255,1,192,192,192,2,255,255,255,1,192,192,192,2,255,255,255,1,0,0,0,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,0,0,0,1,255,0,0,3,0,0,0,1,255,255,0,1,192,192,192,2,255,255,0,1,192,192,192,2,255,255,0,1,0,0,0,1,192,192,192,1,255,255,255,1,192,192,192,1,255,255,255,1,192,192,192,1,0,0,0,1,255,0,0,2,0,0,0,1,255,255,0,1,255,255,255,1,255,255,0,1,255,
255,255,1,255,255,0,1,255,255,255,1,255,255,0,1,255,255,255,1,255,255,0,1,0,0,0,6,255,0,0,2,0,0,0,11,255,0,0,42);

tep_dpr20//09nov2025
:array[0..424] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,255,0,0,34,128,128,128,14,255,0,0,2,128,128,128,1,0,0,255,9,255,255,255,1,0,0,255,1,255,255,255,1,128,128,128,18,0,0,255,9,255,255,255,1,0,0,255,1,255,255,255,1,128,128,128,1,255,255,255,1,128,128,128,15,255,255,255,1,128,128,128,2,255,255,255,12,128,128,128,1,255,255,255,1,128,128,128,2,255,255,255,4,2,2,2,1,255,255,255,7,128,128,128,1,255,255,255,1,128,128,128,2,255,255,255,2,2,2,2,2,255,255,255,1,2,2,2,2,255,255,255,5,128,128,128,1,255,255,255,1,128,128,128,2,2,2,2,2,255,255,255,2,255,255,0,3,2,2,2,2,255,255,255,3,128,128,128,1,255,255,255,1,128,128,128,1,2,2,2,1,255,255,255,2,255,255,0,7,2,2,2,1,255,255,255,2,128,128,128,1,255,255,255,1,128,128,128,2,2,2,2,1,192,192,192,1,128,128,128,2,192,192,192,1,128,128,128,2,192,192,192,1,2,2,2,1,255,255,255,3,128,128,128,4,2,2,2,1,255,255,0,1,128,128,128,2,255,255,0,1,128,128,128,2,255,255,0,1,2,2,2,1,255,255,255,3,128,128,128,1,255,0,0,2,128,128,128,1,2,2,2,1,255,255,255,1,128,128,128,2,255,255,255,1,128,128,128,2,255,
255,255,1,2,2,2,1,128,128,128,4,255,0,0,3,2,2,2,1,255,255,0,1,128,128,128,2,255,255,0,1,128,128,128,2,255,255,0,1,2,2,2,1,255,0,0,6,2,2,2,1,255,255,0,1,255,255,255,1,255,255,0,1,255,255,255,1,255,255,0,1,255,255,255,1,255,255,0,1,255,255,255,1,255,255,0,1,2,2,2,1,255,0,0,5,2,2,2,11,255,0,0,37);

tep_ref320:array[0..414] of byte=(
84,69,65,50,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,192,192,192,39,0,128,0,10,192,192,192,7,0,128,0,1,255,255,255,10,0,128,0,1,192,192,192,6,0,128,0,1,255,255,255,11,0,128,0,1,192,192,192,5,0,128,0,1,255,255,255,12,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,2,0,128,0,6,255,255,255,4,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,3,0,128,0,1,255,255,255,4,0,128,0,1,255,255,255,3,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,3,0,128,0,1,255,255,255,4,0,128,0,1,255,255,255,3,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,3,0,128,0,1,255,255,255,4,0,128,0,1,255,255,255,3,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,3,0,128,0,5,255,255,255,4,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,3,0,128,0,1,255,255,255,2,0,128,0,1,255,255,255,5,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,3,0,128,0,1,255,255,255,2,0,128,0,1,255,255,255,5,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,3,0,128,0,1,255,255,255,3,0,128,0,1,255,255,255,4,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,
2,0,128,0,3,255,255,255,2,0,128,0,2,255,255,255,3,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,12,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,12,0,128,0,1,192,192,192,4,0,128,0,1,255,255,255,12,0,128,0,1,192,192,192,5,0,128,0,12,192,192,192,21);
tep_c320:array[0..374] of byte=(
84,69,65,50,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,20,0,0,0,192,192,192,39,255,0,128,10,192,192,192,7,255,0,128,1,255,255,255,10,255,0,128,1,192,192,192,6,255,0,128,1,255,255,255,11,255,0,128,1,192,192,192,5,255,0,128,1,255,255,255,12,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,4,255,0,128,4,255,255,255,4,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,3,255,0,128,1,255,255,255,4,255,0,128,1,255,255,255,3,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,2,255,0,128,1,255,255,255,9,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,2,255,0,128,1,255,255,255,9,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,2,255,0,128,1,255,255,255,9,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,2,255,0,128,1,255,255,255,9,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,2,255,0,128,1,255,255,255,9,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,3,255,0,128,1,255,255,255,4,255,0,128,1,255,255,255,3,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,4,255,0,128,4,255,255,255,4,
255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,12,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,12,255,0,128,1,192,192,192,4,255,0,128,1,255,255,255,12,255,0,128,1,192,192,192,5,255,0,128,12,192,192,192,21);
tep_cur20:array[0..328] of byte=(
84,69,65,49,35,12,0,0,0,20,0,0,0,255,0,0,12,0,0,0,1,255,0,0,11,0,0,0,2,255,0,0,10,0,0,0,1,255,255,227,1,0,0,0,1,255,0,0,9,0,0,0,1,255,255,220,2,0,0,0,1,255,0,0,8,0,0,0,1,255,255,213,3,0,0,0,1,255,0,0,7,0,0,0,1,255,255,206,4,0,0,0,1,255,0,0,6,0,0,0,1,255,255,199,5,0,0,0,1,255,0,0,5,0,0,0,1,255,255,192,6,0,0,0,1,255,0,0,4,0,0,0,1,255,255,186,7,0,0,0,1,255,0,0,3,0,0,0,1,255,255,186,8,0,0,0,1,255,0,0,2,0,0,0,1,255,255,192,9,0,0,0,1,255,0,0,1,0,0,0,1,255,255,199,10,0,0,0,2,255,255,206,6,0,0,0,6,255,255,213,3,0,0,0,1,255,255,213,2,0,0,0,1,255,0,0,4,0,0,0,1,255,255,220,2,0,0,0,1,255,0,0,1,0,0,0,1,255,255,220,2,0,0,0,1,255,0,0,3,0,0,0,1,255,255,227,1,0,0,0,1,255,0,0,2,0,0,0,1,255,255,227,2,0,0,0,1,255,0,0,3,0,0,0,2,255,0,0,4,0,0,0,1,255,255,234,2,0,0,0,1,255,0,0,8,0,0,0,1,255,255,241,2,0,0,0,1,255,0,0,9,0,0,0,2,255,0,0,3);
tep_xxx20:array[0..232] of byte=(
84,69,65,49,35,14,0,0,0,20,0,0,0,255,0,0,44,64,138,213,8,255,0,0,5,64,138,213,1,255,255,255,6,64,138,213,3,255,0,0,4,64,138,213,1,255,255,255,6,64,138,213,3,255,0,0,4,64,138,213,1,255,255,255,6,64,138,213,2,255,255,255,1,64,138,213,1,255,0,0,3,64,138,213,1,255,255,255,6,64,138,213,5,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,2,64,138,213,1,255,255,255,10,64,138,213,1,255,0,0,3,64,138,213,10,255,0,0,44);
tep_bwd20:array[0..464] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,241,241,241,80,0,128,255,6,241,241,241,1,0,128,255,6,241,241,241,3,0,128,255,3,241,241,241,2,0,128,255,3,140,197,255,3,241,241,241,1,140,197,255,1,0,128,255,3,140,197,255,2,241,241,241,3,0,128,255,1,140,197,255,2,241,241,241,2,0,128,255,3,241,241,241,4,0,128,255,3,140,197,255,1,241,241,241,4,0,128,255,1,140,197,255,1,241,241,241,3,0,128,255,3,140,197,255,1,241,241,241,4,0,128,255,3,241,241,241,3,0,128,255,1,241,241,241,1,140,197,255,1,241,241,241,4,0,128,255,3,241,241,241,3,0,128,255,4,140,197,255,1,241,241,241,2,0,128,255,1,140,197,255,1,241,241,241,5,0,128,255,3,140,197,255,1,241,241,241,2,0,128,255,4,140,197,255,1,241,241,241,2,0,128,255,1,140,197,255,1,241,241,241,5,0,128,255,3,140,197,255,1,241,241,241,1,0,128,255,1,241,241,241,1,140,197,255,1,0,128,255,3,241,241,241,1,0,128,255,1,241,241,241,1,140,197,255,1,241,241,241,6,0,128,255,3,241,241,241,1,0,128,255,1,140,197,255,1,241,241,241,1,0,128,255,3,140,197,255,1,0,128,255,1,140,197,255,1,241,241,241,7,0,128,
255,3,140,197,255,1,0,128,255,1,140,197,255,1,241,241,241,1,0,128,255,3,140,197,255,1,0,128,255,1,140,197,255,1,241,241,241,8,0,128,255,3,241,241,241,1,140,197,255,1,241,241,241,2,0,128,255,3,241,241,241,1,140,197,255,1,241,241,241,8,0,128,255,3,140,197,255,1,241,241,241,3,0,128,255,3,140,197,255,1,241,241,241,9,0,128,255,3,140,197,255,1,241,241,241,3,0,128,255,3,140,197,255,1,241,241,241,10,0,128,255,1,140,197,255,2,241,241,241,4,0,128,255,1,140,197,255,2,241,241,241,11,140,197,255,1,241,241,241,6,140,197,255,1,241,241,241,45);
tep_bwp20:array[0..464] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,241,241,241,80,255,128,255,6,241,241,241,1,255,128,255,6,241,241,241,3,255,128,255,3,241,241,241,2,255,128,255,3,255,209,255,3,241,241,241,1,255,209,255,1,255,128,255,3,255,209,255,2,241,241,241,3,255,128,255,1,255,209,255,2,241,241,241,2,255,128,255,3,241,241,241,4,255,128,255,3,255,209,255,1,241,241,241,4,255,128,255,1,255,209,255,1,241,241,241,3,255,128,255,3,255,209,255,1,241,241,241,4,255,128,255,3,241,241,241,3,255,128,255,1,241,241,241,1,255,209,255,1,241,241,241,4,255,128,255,3,241,241,241,3,255,128,255,4,255,209,255,1,241,241,241,2,255,128,255,1,255,209,255,1,241,241,241,5,255,128,255,3,255,209,255,1,241,241,241,2,255,128,255,4,255,209,255,1,241,241,241,2,255,128,255,1,255,209,255,1,241,241,241,5,255,128,255,3,255,209,255,1,241,241,241,1,255,128,255,1,241,241,241,1,255,209,255,1,255,128,255,3,241,241,241,1,255,128,255,1,241,241,241,1,255,209,255,1,241,241,241,6,255,128,255,3,241,241,241,1,255,128,255,1,255,209,255,1,241,241,241,1,255,128,255,3,255,209,255,
1,255,128,255,1,255,209,255,1,241,241,241,7,255,128,255,3,255,209,255,1,255,128,255,1,255,209,255,1,241,241,241,1,255,128,255,3,255,209,255,1,255,128,255,1,255,209,255,1,241,241,241,8,255,128,255,3,241,241,241,1,255,209,255,1,241,241,241,2,255,128,255,3,241,241,241,1,255,209,255,1,241,241,241,8,255,128,255,3,255,209,255,1,241,241,241,3,255,128,255,3,255,209,255,1,241,241,241,9,255,128,255,3,255,209,255,1,241,241,241,3,255,128,255,3,255,209,255,1,241,241,241,10,255,128,255,1,255,209,255,2,241,241,241,4,255,128,255,1,255,209,255,2,241,241,241,11,255,209,255,1,241,241,241,6,255,209,255,1,241,241,241,45);
//xxxxxxxxxxxxxxxx RTF requires its OWN image //22jun2022
tep_rtf20:array[0..464] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,241,241,241,80,255,128,255,6,241,241,241,1,255,128,255,6,241,241,241,3,255,128,255,3,241,241,241,2,255,128,255,3,255,209,255,3,241,241,241,1,255,209,255,1,255,128,255,3,255,209,255,2,241,241,241,3,255,128,255,1,255,209,255,2,241,241,241,2,255,128,255,3,241,241,241,4,255,128,255,3,255,209,255,1,241,241,241,4,255,128,255,1,255,209,255,1,241,241,241,3,255,128,255,3,255,209,255,1,241,241,241,4,255,128,255,3,241,241,241,3,255,128,255,1,241,241,241,1,255,209,255,1,241,241,241,4,255,128,255,3,241,241,241,3,255,128,255,4,255,209,255,1,241,241,241,2,255,128,255,1,255,209,255,1,241,241,241,5,255,128,255,3,255,209,255,1,241,241,241,2,255,128,255,4,255,209,255,1,241,241,241,2,255,128,255,1,255,209,255,1,241,241,241,5,255,128,255,3,255,209,255,1,241,241,241,1,255,128,255,1,241,241,241,1,255,209,255,1,255,128,255,3,241,241,241,1,255,128,255,1,241,241,241,1,255,209,255,1,241,241,241,6,255,128,255,3,241,241,241,1,255,128,255,1,255,209,255,1,241,241,241,1,255,128,255,3,255,209,255,
1,255,128,255,1,255,209,255,1,241,241,241,7,255,128,255,3,255,209,255,1,255,128,255,1,255,209,255,1,241,241,241,1,255,128,255,3,255,209,255,1,255,128,255,1,255,209,255,1,241,241,241,8,255,128,255,3,241,241,241,1,255,209,255,1,241,241,241,2,255,128,255,3,241,241,241,1,255,209,255,1,241,241,241,8,255,128,255,3,255,209,255,1,241,241,241,3,255,128,255,3,255,209,255,1,241,241,241,9,255,128,255,3,255,209,255,1,241,241,241,3,255,128,255,3,255,209,255,1,241,241,241,10,255,128,255,1,255,209,255,2,241,241,241,4,255,128,255,1,255,209,255,2,241,241,241,11,255,209,255,1,241,241,241,6,255,209,255,1,241,241,241,45);
tep_mid20:array[0..224] of byte=(
84,69,65,49,35,15,0,0,0,20,0,0,0,0,255,0,69,255,113,184,6,0,255,0,9,255,113,184,6,0,255,0,9,255,113,184,1,0,255,0,4,255,113,184,1,38,105,172,9,255,113,184,1,38,105,172,4,255,113,184,1,0,255,0,4,255,113,184,1,0,255,0,4,255,113,184,1,0,255,0,4,255,113,184,1,38,105,172,4,255,113,184,1,38,105,172,4,255,113,184,1,38,105,172,4,255,113,184,1,0,255,0,4,255,113,184,1,0,255,0,4,255,113,184,1,0,255,0,4,255,113,184,1,38,105,172,4,255,113,184,1,38,105,172,3,255,113,184,2,38,105,172,3,255,113,184,2,0,255,0,4,255,113,184,1,0,255,0,2,255,113,184,3,0,255,0,2,255,113,184,3,38,105,172,4,255,113,184,1,38,105,172,3,255,113,184,2,38,105,172,3,255,113,184,2,0,255,0,2,255,113,184,3,0,255,0,12,255,113,184,2,0,255,0,71);
tep_notes20:array[0..288] of byte=(
84,69,65,49,35,20,0,0,0,20,0,0,0,252,252,252,27,164,93,249,2,252,252,252,18,164,93,249,7,252,252,252,13,164,93,249,10,252,252,252,10,164,93,249,10,252,252,252,10,164,93,249,2,252,252,252,5,164,93,249,3,252,252,252,10,164,93,249,2,252,252,252,6,164,93,249,2,252,252,252,10,164,93,249,2,252,252,252,6,164,93,249,2,252,252,252,10,164,93,249,2,252,252,252,6,164,93,249,2,252,252,252,10,164,93,249,2,252,252,252,6,164,93,249,2,252,252,252,10,164,93,249,2,252,252,252,6,164,93,249,2,252,252,252,6,164,93,249,6,252,252,252,6,164,93,249,2,252,252,252,5,164,93,249,2,255,255,128,1,164,93,249,4,252,252,252,5,164,93,249,3,252,252,252,4,164,93,249,1,255,255,128,1,164,93,249,6,252,252,252,2,164,93,249,6,252,252,252,4,164,93,249,7,252,252,252,1,164,93,249,2,255,255,128,1,164,93,249,5,252,252,252,4,164,93,249,6,252,252,252,2,164,93,249,1,255,255,128,1,164,93,249,6,252,252,252,5,164,93,249,3,252,252,252,4,164,93,249,7,252,252,252,13,164,93,249,6,252,252,252,16,164,93,249,2,252,252,252,27);
tep_bell20:array[0..272] of byte=(
84,69,65,49,35,16,0,0,0,20,0,0,0,0,255,0,38,38,105,172,4,0,255,0,11,38,105,172,2,255,178,216,2,38,105,172,2,0,255,0,10,38,105,172,1,255,178,216,4,38,105,172,1,0,255,0,10,38,105,172,1,255,178,216,4,38,105,172,1,0,255,0,10,38,105,172,1,255,178,216,4,38,105,172,1,0,255,0,9,38,105,172,2,255,178,216,4,38,105,172,2,0,255,0,7,38,105,172,2,255,178,216,6,38,105,172,2,0,255,0,6,38,105,172,1,255,178,216,8,38,105,172,1,0,255,0,6,38,105,172,1,255,178,216,2,38,105,172,4,255,178,216,2,38,105,172,1,0,255,0,5,38,105,172,4,255,178,216,4,38,105,172,4,0,255,0,3,38,105,172,2,255,178,216,4,38,105,172,2,255,178,216,4,38,105,172,2,0,255,0,2,38,105,172,1,255,178,216,4,38,105,172,4,255,178,216,4,38,105,172,1,0,255,0,2,38,105,172,2,255,178,216,4,38,105,172,2,255,178,216,4,38,105,172,2,0,255,0,3,38,105,172,4,255,178,216,4,38,105,172,4,0,255,0,8,38,105,172,4,0,255,0,54);
tep_sonnerie20:array[0..352] of byte=(
84,69,65,49,35,19,0,0,0,20,0,0,0,0,255,0,67,38,105,172,4,0,255,0,14,38,105,172,1,255,178,216,3,38,105,172,2,0,255,0,10,38,105,172,3,255,178,216,5,38,105,172,1,0,255,0,9,38,105,172,1,255,178,216,8,38,105,172,1,0,255,0,5,38,105,172,4,255,178,216,8,38,105,172,1,0,255,0,5,38,105,172,2,255,178,216,2,38,105,172,3,255,178,216,5,38,105,172,1,0,255,0,6,38,105,172,1,255,178,216,6,38,105,172,1,255,178,216,3,38,105,172,1,0,255,0,8,38,105,172,1,255,178,216,2,38,105,172,1,255,178,216,3,38,105,172,1,255,178,216,2,38,105,172,1,0,255,0,3,38,105,172,2,0,255,0,4,38,105,172,1,255,178,216,2,38,105,172,2,255,178,216,1,38,105,172,1,255,178,216,2,38,105,172,1,0,255,0,2,38,105,172,2,0,255,0,5,38,105,172,1,255,178,216,1,38,105,172,3,255,178,216,1,38,105,172,2,255,178,216,1,38,105,172,1,0,255,0,1,38,105,172,3,0,255,0,6,38,105,172,1,255,178,216,1,38,105,172,1,255,178,216,3,38,105,172,2,0,255,0,2,38,105,172,1,0,255,0,2,38,105,172,1,0,255,0,6,38,105,172,1,255,178,216,5,38,105,172,1,0,255,0,6,38,105,172,1,0,255,0,6,38,105,172,
2,255,178,216,3,38,105,172,1,0,255,0,7,38,105,172,1,0,255,0,7,38,105,172,4,0,255,0,65);


//large images (32w x 32h) -----------------------------------------------------
//Note: Each image must be 32w (32 pixels wide) by 32h (32 pixels high) in the TEA image format
tep_info24
:array[0..906] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,9,0,201,201,150,1,8,201,201,150,1,46,201,201,150,1,216,201,201,150,2,255,196,196,0,1,255,196,196,0,1,216,196,196,0,1,19,0,0,0,16,0,201,201,150,1,150,201,201,150,1,255,244,244,0,1,255,255,255,0,3,255,244,244,0,1,255,196,196,0,1,197,196,196,0,1,19,0,0,0,14,0,201,201,150,1,168,201,201,150,1,255,244,244,0,2,255,255,255,0,4,255,244,244,0,1,255,196,196,0,1,212,196,196,0,1,4,0,0,0,12,0,201,201,150,1,20,201,201,150,1,216,201,201,150,1,255,244,244,0,2,255,255,255,0,4,255,244,244,0,1,255,196,196,0,1,250,196,196,0,1,5,0,0,0,12,0,201,201,150,1,130,201,201,150,1,255,244,244,0,3,255,255,255,0,4,255,244,244,0,1,255,196,196,0,1,250,196,196,0,1,5,0,0,0,12,0,201,201,150,1,127,201,201,150,1,255,244,244,0,2,255,255,255,0,5,255,244,244,0,1,255,196,196,0,1,250,196,196,0,1,5,0,0,0,12,0,201,201,150,1,127,201,201,150,1,255,244,244,0,1,255,255,255,0,6,255,244,244,0,1,255,196,196,0,1,212,196,196,0,1,4,0,0,0,12,0,201,201,150,1,127,201,201,
150,1,255,255,255,0,6,255,244,244,0,1,255,196,196,0,1,255,196,196,0,1,45,0,0,0,13,0,201,201,150,1,127,201,201,150,1,255,255,255,0,6,255,244,244,0,1,255,196,196,0,1,255,196,196,0,1,48,0,0,0,13,0,201,201,150,1,127,201,201,150,1,255,255,255,0,6,255,196,196,0,1,255,196,196,0,1,130,0,0,0,14,0,201,201,150,1,130,201,201,150,1,255,255,255,0,6,255,196,196,0,1,255,196,196,0,1,130,0,0,0,14,0,201,201,150,1,20,201,201,150,1,216,255,255,0,5,255,196,196,0,1,255,196,196,0,1,216,196,196,0,1,20,0,0,0,15,0,201,201,150,1,168,201,201,150,1,254,255,255,0,4,255,196,196,0,1,254,196,196,0,1,168,0,0,0,16,0,201,201,150,1,1,201,201,150,1,250,255,255,0,3,255,244,244,0,1,255,196,196,0,1,254,196,196,0,1,1,0,0,0,16,0,201,201,150,1,5,201,201,150,1,246,201,201,150,1,255,255,255,0,1,255,244,244,0,1,255,196,196,0,1,255,196,196,0,1,87,196,196,0,1,1,0,0,0,17,0,201,201,150,1,43,201,201,150,1,235,244,244,0,2,255,196,196,0,1,236,196,196,0,1,39,0,0,0,19,0,201,201,150,1,122,201,201,150,1,255,196,196,0,1,230,196,196,0,
1,56,0,0,0,18,0,201,201,150,1,168,201,201,150,1,206,201,201,150,1,231,244,244,0,1,255,244,244,0,1,246,196,196,0,1,104,0,0,0,17,0,201,201,150,1,125,201,201,150,1,255,255,255,0,1,255,244,244,0,1,255,255,255,0,1,255,244,244,0,1,255,196,196,0,1,255,196,196,0,1,86,196,196,0,1,1,0,0,0,15,0,201,201,150,1,127,244,244,0,2,255,255,255,0,3,255,244,244,0,1,255,196,196,0,1,254,196,196,0,1,5,0,0,0,15,0,201,201,150,1,127,244,244,0,1,255,255,255,0,4,255,244,244,0,1,255,196,196,0,1,250,196,196,0,1,5,0,0,0,15,0,201,201,150,1,128,201,201,150,1,255,255,255,0,4,255,244,244,0,1,255,196,196,0,1,212,196,196,0,1,4,0,0,0,15,0,201,201,150,1,61,201,201,150,1,236,201,201,150,1,255,244,244,0,3,255,196,196,0,1,197,196,196,0,1,19,0,0,0,17,0,201,201,150,1,39,201,201,150,1,88,201,201,150,1,255,196,196,0,1,255,196,196,0,1,216,196,196,0,1,19,0,0,0,10,0);

tep_query24
:array[0..841] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,9,0,0,128,255,1,8,0,128,255,1,50,0,128,255,4,49,0,128,255,1,39,0,0,0,16,0,0,128,255,1,102,0,128,255,1,153,0,255,255,5,255,0,255,255,1,235,0,128,255,1,127,0,128,255,1,20,0,0,0,12,0,0,128,255,1,43,0,128,255,1,209,0,255,255,1,247,0,255,255,8,255,0,128,255,1,212,0,128,255,1,8,0,0,0,10,0,0,128,255,1,43,0,128,255,1,247,0,255,255,11,255,0,128,255,1,212,0,128,255,1,20,0,0,0,8,0,0,128,255,1,61,0,255,255,1,235,0,255,255,3,255,0,255,255,1,235,0,128,255,1,125,0,128,255,1,127,0,128,255,1,153,0,255,255,6,255,0,128,255,1,127,0,0,0,8,0,0,128,255,1,131,0,255,255,3,255,0,128,255,1,251,0,128,255,1,43,0,0,0,2,0,0,128,255,1,7,0,128,255,1,150,0,255,255,5,255,0,255,255,1,235,0,128,255,1,39,0,0,0,6,0,0,128,255,1,48,0,255,255,4,255,0,128,255,1,251,0,128,255,1,43,0,0,0,4,0,0,128,255,1,207,0,255,255,5,255,0,128,255,1,49,0,0,0,6,0,0,128,255,1,49,0,255,255,5,255,0,128,255,1,210,0,0,0,4,0,0,128,255,1,205,0,255,255,5,255,0,128,255,1,50,0,0,
0,6,0,0,128,255,1,48,0,255,255,5,255,0,128,255,1,206,0,0,0,3,0,0,128,255,1,105,0,255,255,1,247,0,255,255,4,255,0,128,255,1,153,0,128,255,1,8,0,0,0,7,0,0,128,255,1,131,0,255,255,3,255,0,128,255,1,255,0,128,255,1,168,0,0,0,2,0,0,128,255,1,86,0,255,255,5,255,0,255,255,1,248,0,128,255,1,102,0,0,0,8,0,0,128,255,1,61,0,128,255,1,236,0,255,255,1,255,0,128,255,1,255,0,128,255,1,150,0,0,0,2,0,0,128,255,1,105,0,255,255,6,255,0,128,255,1,105,0,0,0,10,0,0,128,255,1,39,0,128,255,1,49,0,128,255,1,50,0,128,255,1,8,0,0,0,1,0,0,128,255,1,105,0,255,255,1,248,0,255,255,3,255,0,255,255,1,254,0,128,255,1,254,0,128,255,1,86,0,0,0,14,0,0,128,255,1,1,0,128,255,1,86,0,255,255,5,255,0,128,255,1,169,0,128,255,2,1,0,0,0,14,0,0,128,255,1,5,0,128,255,1,254,0,255,255,4,255,0,128,255,1,150,0,0,0,17,0,0,128,255,1,5,0,128,255,1,246,0,255,255,3,255,0,128,255,1,150,0,128,255,1,7,0,0,0,18,0,0,128,255,1,52,0,255,255,2,255,0,128,255,1,169,0,0,0,20,0,0,128,255,1,149,0,128,255,1,255,0,128,255,1,149,0,0,0,20,0,0,128,
255,1,169,0,255,255,2,255,0,128,255,1,52,0,0,0,18,0,0,128,255,1,8,0,128,255,1,150,0,255,255,3,255,0,128,255,1,247,0,128,255,1,43,0,0,0,17,0,0,128,255,1,50,0,255,255,5,255,0,128,255,1,210,0,0,0,17,0,0,128,255,1,48,0,255,255,5,255,0,128,255,1,202,0,0,0,18,0,0,128,255,1,105,0,255,255,1,248,0,255,255,2,255,0,128,255,1,212,0,128,255,1,8,0,0,0,19,0,0,128,255,1,105,0,255,255,1,255,0,128,255,1,197,0,128,255,1,19,0,0,0,21,0,0,128,255,1,48,0,128,255,1,24,0,0,0,13,0);

mtep_options20
:array[0..511] of byte=(
84,69,65,51,35,0,1,0,0,0,0,0,0,0,0,0,0,0,0,17,0,0,0,20,0,0,0,0,0,0,40,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,11,0,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,11,0,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,11,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,40,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,3,0,0,0,0,1,255,0,0,0,4,0,0,0,0,1,255,0,0,0,2,0,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,
0,0,3,0,0,0,0,1,255,0,0,0,1,107,0,0,0,2,0,0,0,0,1,107,0,0,0,1,255,0,0,0,2,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,3,0,0,0,0,1,107,0,0,0,4,255,0,0,0,1,107,0,0,0,35,0);

tep_error24
:array[0..851] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,77,0,255,0,0,1,1,255,0,0,1,48,255,0,0,1,49,255,0,0,1,48,0,0,0,6,0,255,0,0,1,8,255,0,0,1,50,255,0,0,1,49,255,0,0,1,39,0,0,0,10,0,255,0,0,1,5,255,0,0,3,255,255,0,0,1,105,0,0,0,5,0,255,0,0,1,150,255,0,0,2,255,255,0,0,1,215,0,0,0,10,0,255,0,0,1,1,255,0,0,1,86,255,0,0,2,255,255,0,0,1,248,255,0,0,1,102,0,0,0,3,0,255,0,0,1,168,255,0,0,2,255,255,0,0,1,247,255,0,0,1,43,0,0,0,12,0,255,0,0,1,131,255,0,0,2,255,255,0,0,1,153,255,0,0,1,7,0,0,0,1,0,255,0,0,1,19,255,0,0,1,216,255,0,0,2,255,255,0,0,1,53,0,0,0,13,0,255,0,0,1,61,255,0,0,1,235,255,0,0,2,255,255,0,0,1,150,255,0,0,1,26,255,0,0,1,197,255,0,0,2,255,255,0,0,1,197,255,0,0,1,24,0,0,0,14,0,255,0,0,1,43,255,0,0,1,251,255,0,0,1,255,255,0,0,1,251,255,0,0,1,58,255,0,0,2,255,255,0,0,1,216,255,0,0,1,19,0,0,0,15,0,255,0,0,1,4,255,0,0,1,212,255,0,0,2,255,255,0,0,1,251,255,0,0,1,255,255,0,0,1,254,255,0,0,1,168,0,0,0,17,0,255,0,0,1,46,255,0,0,4,255,255,0,0,1,254,255,0,0,1,1,0,0,0,
17,0,255,0,0,1,8,255,0,0,1,153,255,0,0,3,255,255,0,0,1,87,255,0,0,1,1,0,0,0,17,0,255,0,0,1,7,255,0,0,1,153,255,0,0,3,255,255,0,0,1,87,0,0,0,17,0,255,0,0,1,2,255,0,0,1,150,255,0,0,5,255,255,0,0,1,106,0,0,0,16,0,255,0,0,1,9,255,0,0,1,251,255,0,0,1,255,255,0,0,1,251,255,0,0,1,92,255,0,0,2,255,255,0,0,1,208,0,0,0,16,0,255,0,0,1,202,255,0,0,2,255,255,0,0,1,212,255,0,0,1,43,255,0,0,1,235,255,0,0,2,255,255,0,0,1,124,0,0,0,14,0,255,0,0,1,58,255,0,0,1,231,255,0,0,2,255,255,0,0,1,46,0,0,0,1,0,255,0,0,1,127,255,0,0,2,255,255,0,0,1,194,255,0,0,1,20,0,0,0,12,0,255,0,0,1,39,255,0,0,1,236,255,0,0,2,255,255,0,0,1,150,255,0,0,1,8,0,0,0,1,0,255,0,0,1,20,255,0,0,1,212,255,0,0,2,255,255,0,0,1,212,255,0,0,1,4,0,0,0,11,0,255,0,0,1,87,255,0,0,2,255,255,0,0,1,208,0,0,0,4,0,255,0,0,1,9,255,0,0,1,251,255,0,0,1,255,255,0,0,1,251,255,0,0,1,43,0,0,0,10,0,255,0,0,1,106,255,0,0,3,255,255,0,0,1,106,0,0,0,4,0,255,0,0,1,2,255,0,0,1,150,255,0,0,2,255,255,0,0,1,235,255,0,0,1,61,0,0,0,9,0,255,0,0,1,203,255,0,0,1,
250,255,0,0,1,254,255,0,0,1,86,0,0,0,6,0,255,0,0,1,7,255,0,0,1,150,255,0,0,1,251,255,0,0,1,252,255,0,0,1,126,0,0,0,9,0,255,0,0,1,4,255,0,0,2,5,255,0,0,1,1,0,0,0,7,0,255,0,0,1,2,255,0,0,2,5,255,0,0,1,2,0,0,0,52,0);

tep_color24
:array[0..746] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,7,0,125,125,255,1,24,125,125,255,1,49,125,125,255,1,48,125,125,255,1,152,125,125,255,1,255,255,255,0,1,255,255,255,0,1,152,255,255,0,1,48,255,255,0,1,49,255,255,0,1,24,0,0,0,13,0,125,125,255,1,124,125,125,255,1,194,125,125,255,4,255,255,255,0,4,255,255,255,0,1,194,255,255,0,1,124,0,0,0,9,0,125,125,255,2,1,125,125,255,1,169,125,125,255,6,255,255,255,0,6,255,255,255,0,1,169,255,255,0,2,1,0,0,0,5,0,125,125,255,1,1,125,125,255,1,86,125,125,255,2,254,125,125,255,6,255,255,255,0,6,255,255,255,0,2,254,255,255,0,1,86,255,255,0,1,1,0,0,0,4,0,125,125,255,1,1,125,125,255,1,254,125,125,255,8,255,255,255,0,8,255,255,255,0,1,254,255,255,0,1,1,0,0,0,4,0,125,125,255,1,169,125,125,255,1,254,125,125,255,8,255,255,255,0,8,255,255,255,0,1,254,255,255,0,1,169,0,0,0,3,0,125,125,255,1,124,125,125,255,10,255,255,255,0,10,255,255,255,0,1,124,0,0,0,1,0,125,125,255,1,24,125,125,255,1,194,125,125,255,10,255,255,255,0,10,255,255,255,0,1,194,
255,255,0,1,24,125,125,255,1,49,125,125,255,11,255,255,255,0,11,255,255,255,0,1,49,125,125,255,1,88,125,125,255,11,255,255,255,0,11,255,255,255,0,1,88,125,125,255,12,255,255,255,0,12,255,125,125,255,12,255,255,255,0,12,255,0,255,0,12,255,255,0,255,12,255,0,255,0,12,255,255,0,255,12,255,0,255,0,1,88,0,255,0,11,255,255,0,255,11,255,255,0,255,1,88,0,255,0,1,49,0,255,0,11,255,255,0,255,11,255,255,0,255,1,49,0,255,0,1,24,0,255,0,1,194,0,255,0,10,255,255,0,255,10,255,255,0,255,1,194,255,0,255,1,24,0,0,0,1,0,0,255,0,1,124,0,255,0,10,255,255,0,255,10,255,255,0,255,1,124,0,0,0,3,0,0,255,0,1,169,0,255,0,1,254,0,255,0,8,255,255,0,255,8,255,255,0,255,1,254,255,0,255,1,169,0,0,0,4,0,0,255,0,1,1,0,255,0,1,254,0,255,0,8,255,255,0,255,8,255,255,0,255,1,254,255,0,255,1,1,0,0,0,4,0,0,255,0,1,1,0,255,0,1,86,0,255,0,2,254,0,255,0,6,255,255,0,255,6,255,255,0,255,2,254,255,0,255,1,86,255,0,255,1,1,0,0,0,5,0,0,255,0,2,1,0,255,0,1,169,0,255,0,6,255,255,0,255,6,255,255,0,255,1,169,255,0,255,2,1,0,0,0,
9,0,0,255,0,1,124,0,255,0,1,194,0,255,0,4,255,255,0,255,4,255,255,0,255,1,194,255,0,255,1,124,0,0,0,13,0,0,255,0,1,24,0,255,0,1,49,0,255,0,1,48,0,255,0,1,152,0,255,0,1,255,255,0,255,1,255,255,0,255,1,152,255,0,255,1,48,255,0,255,1,49,255,0,255,1,24,0,0,0,7,0);

tep_folderimage24
:array[0..776] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,62,0,160,130,35,1,4,160,130,35,5,5,160,130,35,1,1,0,0,0,16,0,160,130,35,1,19,160,130,35,1,212,160,130,35,4,250,160,130,35,1,254,160,130,35,1,86,0,0,0,15,0,160,130,35,1,19,160,130,35,1,197,255,0,255,6,255,160,130,35,1,255,160,130,35,1,105,0,0,0,4,0,160,130,35,1,4,160,130,35,3,5,160,130,35,1,4,0,0,0,4,0,160,130,35,1,8,160,130,35,1,212,255,0,255,8,255,160,130,35,1,248,160,130,35,1,105,0,0,0,2,0,160,130,35,1,19,160,130,35,1,212,160,130,35,3,250,160,130,35,1,212,160,130,35,1,20,0,0,0,3,0,160,130,35,1,202,160,130,35,1,255,255,0,255,7,255,252,252,252,1,255,0,255,255,1,255,160,130,35,1,255,160,130,35,1,48,160,130,35,1,24,160,130,35,1,197,160,130,35,1,255,255,255,128,3,255,160,130,35,1,255,160,130,35,1,194,160,130,35,2,127,160,130,35,1,125,160,130,35,1,231,160,130,35,1,255,255,0,255,6,255,252,252,252,1,255,0,255,255,2,255,160,130,35,1,255,160,130,35,2,49,160,130,35,1,255,255,255,128,5,255,160,130,35,6,255,255,0,255,4,255,
252,252,252,1,255,0,255,255,4,255,160,130,35,1,255,160,130,35,2,49,160,130,35,1,255,255,255,128,9,255,160,130,35,2,255,255,0,255,2,255,252,252,252,1,255,0,255,255,6,255,160,130,35,1,255,160,130,35,2,49,160,130,35,1,255,255,255,128,9,255,160,130,35,2,255,252,252,252,2,255,0,255,255,7,255,160,130,35,1,255,160,130,35,2,49,160,130,35,1,255,255,255,128,9,255,160,130,35,2,255,0,255,255,9,255,160,130,35,1,255,160,130,35,1,48,160,130,35,1,49,160,130,35,1,255,255,255,128,10,255,160,130,35,1,255,255,255,128,1,255,0,255,255,7,255,160,130,35,1,248,160,130,35,1,105,0,0,0,1,0,160,130,35,1,49,160,130,35,1,255,255,255,128,11,255,160,130,35,1,255,255,255,128,1,255,0,255,255,5,255,160,130,35,1,255,160,130,35,1,105,0,0,0,2,0,160,130,35,1,49,160,130,35,1,255,255,255,128,12,255,160,130,35,6,255,160,130,35,1,87,0,0,0,3,0,160,130,35,1,49,160,130,35,1,255,255,255,128,17,255,160,130,35,1,255,160,130,35,1,49,0,0,0,3,0,160,130,35,1,49,160,130,35,1,255,255,255,128,17,255,160,130,35,1,255,160,130,35,1,49,
0,0,0,3,0,160,130,35,1,49,160,130,35,1,255,255,255,128,17,255,160,130,35,1,255,160,130,35,1,49,0,0,0,3,0,160,130,35,1,49,160,130,35,2,255,255,255,128,16,255,160,130,35,1,255,160,130,35,1,49,0,0,0,3,0,160,130,35,1,24,160,130,35,1,197,160,130,35,2,255,255,255,128,14,255,160,130,35,2,255,160,130,35,1,50,0,0,0,4,0,160,130,35,1,19,160,130,35,1,212,160,130,35,15,250,160,130,35,1,251,160,130,35,1,150,160,130,35,1,8,0,0,0,5,0,160,130,35,1,4,160,130,35,16,5,160,130,35,1,2,0,0,0,52,0);

tep_newfolder24
:array[0..896] of byte=(
84,69,65,51,35,1,0,0,0,0,0,0,0,0,0,0,0,0,0,24,0,0,0,24,0,0,0,0,0,0,39,0,255,191,191,1,20,255,191,191,1,130,255,191,191,1,127,255,191,191,1,102,0,0,0,19,0,255,191,191,1,8,255,191,191,1,212,255,191,191,2,255,255,191,191,1,248,255,191,191,1,105,0,0,0,17,0,255,191,191,1,20,255,191,191,1,212,255,191,191,1,255,255,0,0,2,255,160,130,35,1,255,255,191,191,1,255,255,191,191,1,86,0,0,0,14,0,255,191,191,1,102,255,191,191,1,127,255,191,191,1,194,255,191,191,2,255,255,0,0,2,255,160,130,35,1,255,255,191,191,2,255,255,191,191,2,130,255,191,191,1,24,0,0,0,2,0,160,130,35,1,4,160,130,35,3,5,160,130,35,1,4,0,0,0,3,0,255,191,191,1,105,255,191,191,1,248,255,191,191,3,255,160,130,35,1,255,255,0,0,3,255,255,191,191,4,255,255,191,191,1,53,0,0,0,1,0,160,130,35,1,19,160,130,35,1,212,160,130,35,3,250,160,130,35,1,212,160,130,35,1,20,0,0,0,1,0,255,191,191,1,47,255,191,191,1,255,160,130,35,1,255,255,0,0,11,255,255,191,191,1,252,160,130,35,1,24,160,130,35,1,197,160,130,35,1,255,255,255,128,3,255,160,130,35,
1,255,160,130,35,1,194,160,130,35,1,127,160,130,35,1,152,255,191,191,3,255,160,130,35,1,255,255,0,0,7,255,255,191,191,2,255,255,191,191,1,152,160,130,35,1,49,160,130,35,1,255,255,255,128,5,255,160,130,35,5,255,255,191,191,2,255,255,0,0,6,255,255,191,191,3,255,255,191,191,1,47,160,130,35,1,49,160,130,35,1,255,255,255,128,11,255,255,191,191,1,255,160,130,35,1,255,255,0,0,5,255,255,191,191,1,255,255,191,191,1,246,255,191,191,1,103,0,0,0,1,0,160,130,35,1,49,160,130,35,1,255,255,255,128,10,255,255,191,191,2,255,255,0,0,2,255,160,130,35,1,255,255,191,191,1,255,255,0,0,3,255,255,191,191,1,230,255,191,191,1,125,255,191,191,1,24,160,130,35,1,49,160,130,35,1,255,255,255,128,9,255,255,191,191,2,255,255,0,0,3,255,255,191,191,3,255,255,0,0,2,255,160,130,35,1,255,255,191,191,1,255,255,191,191,1,48,160,130,35,1,49,160,130,35,1,255,255,255,128,10,255,255,191,191,2,255,255,0,0,1,255,160,130,35,1,255,255,191,191,3,255,255,0,0,1,255,160,130,35,1,255,255,191,191,1,248,255,191,191,1,105,0,0,0,1,0,
160,130,35,1,49,160,130,35,1,255,255,255,128,11,255,255,191,191,7,255,255,191,191,1,152,255,191,191,1,102,0,0,0,2,0,160,130,35,1,49,160,130,35,1,255,255,255,128,12,255,255,191,191,2,255,255,255,128,3,255,160,130,35,1,255,160,130,35,1,48,0,0,0,3,0,160,130,35,1,49,160,130,35,1,255,255,255,128,17,255,160,130,35,1,255,160,130,35,1,49,0,0,0,3,0,160,130,35,1,49,160,130,35,1,255,255,255,128,17,255,160,130,35,1,255,160,130,35,1,49,0,0,0,3,0,160,130,35,1,49,160,130,35,1,255,255,255,128,17,255,160,130,35,1,255,160,130,35,1,49,0,0,0,3,0,160,130,35,1,49,160,130,35,2,255,255,255,128,16,255,160,130,35,1,255,160,130,35,1,49,0,0,0,3,0,160,130,35,1,24,160,130,35,1,197,160,130,35,2,255,255,255,128,14,255,160,130,35,2,255,160,130,35,1,50,0,0,0,4,0,160,130,35,1,19,160,130,35,1,212,160,130,35,15,250,160,130,35,1,251,160,130,35,1,150,160,130,35,1,8,0,0,0,5,0,160,130,35,1,4,160,130,35,16,5,160,130,35,1,2,0,0,0,52,0);


//color schemes ----------------------------------------------------------------
//new built-in colors - 09nov2025, 31mar2025, 09may2021
cols_BurntYellow:array[0..83] of byte=(99,111,108,50,1,0,0,0,2,35,32,3,50,25,23,2,51,0,0,0,52,176,162,14,53,176,162,14,54,190,175,16,55,25,23,2,56,89,82,8,57,25,23,2,58,0,0,0,100,25,23,2,101,0,0,0,102,176,162,14,103,176,162,14,104,190,175,16,105,210,200,92,106,89,82,8,107,53,49,4,108,0,0,0);
cols_BurntRed:array[0..83] of byte=(99,111,108,50,1,0,0,0,2,35,3,3,50,25,2,2,51,0,0,0,52,163,0,11,53,163,0,11,54,232,0,21,55,219,213,28,56,89,8,8,57,25,2,2,58,25,2,2,100,25,2,2,101,0,0,0,102,163,0,11,103,163,0,11,104,232,0,21,105,219,213,28,106,89,8,8,107,25,2,2,108,25,2,2);
cols_BurntPurple:array[0..83] of byte=(99,111,108,50,1,0,0,0,2,26,0,26,50,18,0,20,51,0,0,0,52,63,0,66,53,63,0,66,54,156,0,163,55,27,154,188,56,99,0,104,57,18,0,20,58,0,0,0,100,18,0,20,101,0,0,0,102,63,0,66,103,63,0,66,104,156,0,163,105,27,154,188,106,99,0,104,107,18,0,20,108,0,0,0);
cols_BurntOrange:array[0..83] of byte=(99,111,108,50,1,0,0,0,2,35,14,3,50,25,13,2,51,0,0,0,52,190,98,16,53,190,98,16,54,190,99,16,55,85,42,87,56,89,36,8,57,25,13,2,58,0,0,0,100,25,13,2,101,0,0,0,102,190,98,16,103,190,98,16,104,190,99,16,105,85,42,87,106,89,36,8,107,25,13,2,108,0,0,0);
cols_Eerie:array[0..83] of byte=(99,111,108,50,1,47,17,1,2,61,48,1,50,47,17,1,51,65,38,23,52,148,148,1,53,148,148,1,54,88,120,1,55,148,148,1,56,88,120,1,57,47,17,1,58,65,38,23,100,61,48,1,101,61,48,1,102,32,44,1,103,32,44,1,104,88,120,1,105,148,148,1,106,88,120,1,107,61,48,1,108,61,48,1);
cols_Army:array[0..83] of byte=(99,111,108,50,1,80,84,73,2,205,208,198,50,240,242,235,51,225,227,221,52,184,185,180,53,184,185,180,54,114,117,107,55,255,255,255,56,114,117,107,57,240,242,235,58,240,242,235,100,205,208,198,101,205,208,198,102,112,124,106,103,112,124,106,104,85,88,78,105,235,238,228,106,85,88,78,107,205,208,198,108,205,208,198);

cols_Soft_Green      :array[0..83] of byte=(99,111,108,50,1,113,192,153,2,217,233,217,50,255,255,255,51,217,242,227,52,217,242,227,53,217,242,227,54,100,171,136,55,100,171,136,56,100,171,136,57,255,255,255,58,217,242,227,100,217,233,217,101,217,233,217,102,250,255,255,103,250,255,255,104,75,127,102,105,250,255,255,106,75,127,102,107,217,233,217,108,217,233,217);
cols_Fine_Grey       :array[0..83] of byte=(99,111,108,50,1,41,70,84,2,163,185,196,50,246,246,245,51,246,246,245,52,163,185,196,53,163,185,196,54,89,105,113,55,89,105,113,56,89,105,113,57,246,246,245,58,246,246,245,100,163,185,196,101,163,185,196,102,112,127,135,103,112,127,135,104,43,65,76,105,43,65,76,106,43,65,76,107,163,185,196,108,163,185,196);
cols_Fine_Grey2      :array[0..83] of byte=(99,111,108,50,1,41,70,84,2,163,185,196,50,255,255,255,51,255,255,255,52,209,220,226,53,209,220,226,54,138,149,154,55,104,113,117,56,138,149,154,57,255,255,255,58,255,255,255,100,163,185,196,101,163,185,196,102,112,127,135,103,112,127,135,104,43,65,76,105,43,65,76,106,43,65,76,107,163,185,196,108,163,185,196);
cols_Pale_Yellow     :array[0..83] of byte=(99,111,108,50,1,175,175,141,2,255,255,230,50,249,249,243,51,225,225,208,52,255,255,230,53,255,255,230,54,143,143,97,55,135,135,92,56,135,135,118,57,249,249,243,58,225,225,208,100,255,255,230,101,255,255,230,102,145,145,120,103,145,145,120,104,135,135,110,105,225,225,200,106,135,135,110,107,255,255,230,108,255,255,230);

cols_Marine          :array[0..83] of byte=(99,111,108,50,1,49,84,101,2,196,222,235,50,255,255,255,51,230,252,255,52,194,219,228,53,194,219,228,54,122,144,155,55,107,126,136,56,122,144,155,57,255,255,255,58,230,252,255,100,196,222,235,101,196,222,235,102,152,173,183,103,152,173,183,104,52,78,91,105,232,255,255,106,52,78,91,107,196,222,235,108,196,222,235);

cols_Lilac           :array[0..83] of byte=(99,111,108,50,1,122,122,137,2,252,198,255,50,252,209,255,51,222,179,225,52,142,99,145,53,142,99,145,54,132,89,135,55,222,179,225,56,132,89,135,57,252,209,255,58,222,179,225,100,252,198,255,101,252,198,255,102,142,88,145,103,142,88,145,104,132,78,135,105,222,168,225,106,132,78,135,107,252,198,255,108,252,198,255);

cols_Gold            :array[0..83] of byte=(99,111,108,50,1,158,149,125,2,241,241,174,50,229,228,165,51,199,198,135,52,119,118,55,53,119,118,55,54,109,108,45,55,255,255,195,56,149,148,85,57,229,228,165,58,229,228,165,100,242,242,175,101,212,212,145,102,132,132,65,103,132,132,65,104,122,122,55,105,212,212,145,106,162,162,95,107,242,242,175,108,242,242,175);
cols_Gold2           :array[0..83] of byte=(99,111,108,50,1,158,149,125,2,241,241,174,50,244,244,189,51,199,198,135,52,119,118,55,53,119,118,55,54,109,108,45,55,255,255,195,56,149,148,85,57,244,244,189,58,244,244,189,100,242,242,175,101,212,212,145,102,132,132,65,103,132,132,65,104,122,122,55,105,212,212,145,106,162,162,95,107,242,242,175,108,242,242,175);
cols_Gold3           :array[0..83] of byte=(99,111,108,50,1,152,152,68,2,230,230,166,50,242,242,175,51,242,242,175,52,194,186,112,53,194,186,112,54,122,122,55,55,122,122,55,56,122,122,55,57,242,242,175,58,242,242,175,100,230,230,166,101,230,230,166,102,194,186,112,103,194,186,112,104,122,122,55,105,122,122,55,106,122,122,55,107,230,230,166,108,230,230,166);

cols_Silver_Gold:array[0..83] of byte=(99,111,108,50,1,160,164,152,2,242,242,232,50,255,255,250,51,226,229,218,52,141,141,129,53,141,141,129,54,126,130,107,55,255,255,255,56,126,130,107,57,255,255,250,58,226,229,218,100,242,242,232,101,242,242,232,102,118,121,110,103,118,121,110,104,107,110,99,105,255,255,255,106,107,110,99,107,242,242,232,108,242,242,232);
cols_Grey:array[0..83] of byte=(99,111,108,50,1,69,79,89,2,204,218,233,50,229,239,250,51,217,225,233,52,132,144,157,53,132,144,157,54,99,114,129,55,219,234,249,56,99,114,129,57,229,239,250,58,217,225,233,100,204,218,233,101,204,218,233,102,94,108,123,103,94,108,123,104,47,55,64,105,234,248,255,106,47,55,64,107,204,218,233,108,204,218,233);
cols_Soft_Blue:array[0..83] of byte=(99,111,108,50,1,113,153,192,2,217,233,250,50,255,255,255,51,217,229,243,52,217,229,243,53,217,229,243,54,113,153,192,55,113,153,192,56,113,153,192,57,255,255,255,58,217,229,243,100,217,233,250,101,217,233,250,102,250,255,255,103,250,255,255,104,100,136,170,105,250,255,255,106,100,136,170,107,217,233,250,108,217,233,250);
cols_Emerald:array[0..83] of byte=(99,111,108,50,1,111,161,131,2,141,226,198,50,174,242,226,51,109,205,183,52,21,117,95,53,109,205,183,54,10,106,84,55,109,205,183,56,10,106,84,57,174,242,226,58,109,205,183,100,141,226,198,101,141,226,198,102,20,104,77,103,20,104,77,104,9,94,66,105,174,255,231,106,9,94,66,107,141,226,198,108,141,226,198);
cols_Aqua_Marine:array[0..83] of byte=(99,111,108,50,1,0,144,205,2,126,224,243,50,206,255,255,51,175,242,242,52,115,222,242,53,115,222,242,54,22,105,150,55,22,105,150,56,22,105,150,57,185,255,255,58,185,255,255,100,126,224,243,101,126,224,243,102,0,196,242,103,0,196,242,104,0,84,104,105,127,234,254,106,0,84,104,107,126,224,243,108,126,224,243);
cols_Washed_Crimson:array[0..83] of byte=(99,111,108,50,1,255,177,188,2,254,237,242,50,254,237,242,51,254,237,242,52,255,205,212,53,255,205,212,54,134,117,122,55,134,117,122,56,134,117,122,57,254,237,242,58,254,237,242,100,254,237,242,101,254,237,242,102,255,177,188,103,255,177,188,104,119,109,119,105,119,109,119,106,119,109,119,107,254,237,242,108,254,237,242);
cols_Dusty_Pink:array[0..83] of byte=(99,111,108,50,1,207,173,178,2,246,224,219,50,250,246,246,51,225,216,216,52,236,200,196,53,236,200,196,54,142,126,126,55,142,126,126,56,142,126,126,57,250,246,246,58,225,216,216,100,246,224,219,101,246,224,219,102,163,135,136,103,163,135,136,104,111,92,93,105,249,242,243,106,99,92,93,107,227,212,213,108,227,212,213);
cols_Golden_Sands:array[0..83] of byte=(99,111,108,50,1,157,132,82,2,240,221,192,50,252,244,224,51,221,205,160,52,170,158,125,53,170,158,125,54,154,144,91,55,252,244,224,56,154,144,91,57,252,244,224,58,221,205,160,100,240,221,192,101,240,221,192,102,130,111,82,103,130,111,82,104,120,101,72,105,210,191,162,106,120,101,72,107,240,221,192,108,240,221,192);
cols_Fern:array[0..83] of byte=(99,111,108,50,1,103,72,103,2,188,219,188,50,219,255,219,51,189,225,189,52,170,220,170,53,170,220,170,54,99,135,99,55,104,136,104,56,99,135,99,57,219,255,219,58,189,225,189,100,188,219,188,101,188,219,188,102,199,232,199,103,199,232,199,104,71,90,71,105,71,90,71,106,71,90,71,107,188,219,188,108,188,219,188);
cols_Tangerine:array[0..83] of byte=(99,111,108,50,1,145,54,54,2,255,164,164,50,255,203,203,51,225,173,173,52,255,164,164,53,255,164,164,54,135,83,83,55,135,83,83,56,135,83,83,57,255,203,203,58,255,203,203,100,255,164,164,101,255,164,164,102,209,134,134,103,209,134,134,104,135,44,44,105,135,44,44,106,135,44,44,107,255,164,164,108,255,164,164);

cols_Moon_Blue:array[0..83] of byte=(99,111,108,50,1,63,130,175,2,103,170,215,50,152,201,233,51,149,190,217,52,83,150,195,53,83,150,195,54,23,90,135,55,23,90,135,56,23,90,135,57,152,201,233,58,149,190,217,100,103,170,215,101,103,170,215,102,92,147,184,103,92,147,184,104,23,90,135,105,153,220,255,106,23,90,135,107,103,170,215,108,103,170,215);
cols_Howdy_Brown:array[0..83] of byte=(99,111,108,50,1,131,83,35,2,195,154,113,50,251,213,176,51,251,213,176,52,221,173,125,53,221,173,125,54,141,93,45,55,141,93,45,56,141,93,45,57,251,213,176,58,251,213,176,100,195,154,113,101,195,154,113,102,251,213,176,103,251,213,176,104,133,84,35,105,133,84,35,106,133,84,35,107,195,154,113,108,195,154,113);
cols_Chirpy_Charcoal:array[0..83] of byte=(99,111,108,50,1,38,38,38,2,59,59,59,50,59,59,59,51,51,51,51,52,144,144,144,53,144,144,144,54,162,162,162,55,220,220,220,56,162,162,162,57,59,59,59,58,51,51,51,100,59,59,59,101,59,59,59,102,144,144,144,103,144,144,144,104,162,162,162,105,220,220,220,106,146,146,146,107,58,58,58,108,58,58,58);

cols_DarkRedTint     :array[0..83] of byte=(99,111,108,50,1,4,2,2,2,37,13,13,50,19,0,0,51,19,0,0,52,73,47,47,53,73,47,47,54,162,153,153,55,162,153,153,56,162,153,153,57,19,0,0,58,19,0,0,100,37,13,13,101,37,13,13,102,73,47,47,103,73,47,47,104,162,153,153,105,162,153,153,106,162,153,153,107,36,13,13,108,36,13,13);
cols_DarkRedTint2    :array[0..83] of byte=(99,111,108,50,1,13,5,5,2,37,13,13,50,37,13,13,51,37,13,13,52,73,47,47,53,73,47,47,54,162,153,153,55,162,153,153,56,162,153,153,57,37,13,13,58,37,13,13,100,37,13,13,101,37,13,13,102,73,47,47,103,73,47,47,104,162,153,153,105,162,153,153,106,162,153,153,107,36,13,13,108,36,13,13);

cols_DarkAquaTint    :array[0..83] of byte=(99,111,108,50,1,15,30,30,2,32,42,42,50,16,19,19,51,16,19,19,52,127,162,162,53,127,162,162,54,143,152,152,55,16,19,19,56,112,112,112,57,16,19,19,58,16,19,19,100,32,42,42,101,32,42,42,102,127,162,162,103,127,162,162,104,143,152,152,105,16,19,19,106,143,152,152,107,32,42,42,108,32,42,42);
cols_DarkAquaTint2   :array[0..83] of byte=(99,111,108,50,1,15,30,30,2,32,42,42,50,24,36,36,51,47,55,55,52,127,162,162,53,127,162,162,54,143,152,152,55,62,62,62,56,112,112,112,57,24,36,36,58,47,55,55,100,32,42,42,101,32,42,42,102,127,162,162,103,127,162,162,104,143,152,152,105,62,62,62,106,143,152,152,107,32,42,42,108,32,42,42);

cols_DarkBlueTint    :array[0..83] of byte=(99,111,108,50,1,15,15,30,2,31,31,44,50,16,16,22,51,16,16,22,52,110,112,127,53,110,112,127,54,157,159,169,55,157,159,169,56,157,159,169,57,16,16,22,58,16,16,22,100,31,31,44,101,31,31,44,102,54,57,78,103,54,57,78,104,152,152,152,105,152,152,152,106,152,152,152,107,32,32,42,108,32,32,42);
cols_DarkBlueTint2   :array[0..83] of byte=(99,111,108,50,1,15,15,30,2,31,31,44,50,31,31,44,51,2,2,2,52,110,112,127,53,110,112,127,54,157,159,169,55,2,2,2,56,157,159,169,57,32,32,37,58,2,2,2,100,31,31,44,101,31,31,44,102,54,57,78,103,54,57,78,104,152,152,152,105,62,62,62,106,152,152,152,107,32,32,42,108,32,32,42);

cols_DarkEmerald     :array[0..83] of byte=(99,111,108,50,1,15,30,30,2,2,36,36,50,1,20,20,51,1,20,20,52,132,148,148,53,132,148,148,54,160,170,170,55,1,20,20,56,160,170,170,57,1,20,20,58,1,20,20,100,2,36,36,101,2,36,36,102,132,148,148,103,132,148,148,104,160,170,170,105,1,20,20,106,160,170,170,107,2,36,36,108,2,36,36);
cols_DarkEmerald2    :array[0..83] of byte=(99,111,108,50,1,15,30,30,2,2,36,36,50,2,36,36,51,6,48,48,52,132,148,148,53,132,148,148,54,160,170,170,55,62,62,62,56,112,112,112,57,2,36,36,58,6,48,48,100,2,36,36,101,2,36,36,102,132,148,148,103,132,148,148,104,160,170,170,105,62,62,62,106,160,170,170,107,2,36,36,108,2,36,36);

cols_DarkGreenTint   :array[0..83] of byte=(99,111,108,50,1,15,30,30,2,1,36,13,50,13,19,15,51,13,19,15,52,34,64,47,53,34,64,47,54,146,161,153,55,146,161,153,56,146,161,153,57,13,19,15,58,13,19,15,100,1,36,13,101,1,36,13,102,34,64,47,103,34,64,47,104,146,161,153,105,146,161,153,106,146,161,153,107,1,36,13,108,1,36,13);
cols_DarkGreenTint2  :array[0..83] of byte=(99,111,108,50,1,15,30,30,2,1,36,13,50,1,27,10,51,1,27,10,52,34,64,47,53,34,64,47,54,146,161,153,55,146,161,153,56,146,161,153,57,1,27,10,58,1,27,10,100,1,36,13,101,1,36,13,102,34,64,47,103,34,64,47,104,146,161,153,105,146,161,153,106,146,161,153,107,1,36,13,108,1,36,13);

cols_DarkYellowTint  :array[0..83] of byte=(99,111,108,50,1,2,2,0,2,36,36,0,50,19,19,0,51,19,19,0,52,73,73,47,53,128,128,109,54,162,162,147,55,162,162,147,56,162,162,147,57,19,19,0,58,19,19,0,100,36,36,0,101,36,36,0,102,73,73,47,103,128,128,109,104,162,162,147,105,162,162,147,106,162,162,147,107,36,36,0,108,36,36,0);
cols_DarkYellowTint2 :array[0..83] of byte=(99,111,108,50,1,14,14,0,2,36,36,0,50,32,32,0,51,32,32,0,52,73,73,47,53,128,128,109,54,162,162,147,55,162,162,147,56,162,162,147,57,32,32,0,58,32,32,0,100,36,36,0,101,36,36,0,102,73,73,47,103,128,128,109,104,162,162,147,105,162,162,147,106,162,162,147,107,36,36,0,108,36,36,0);

cols_Dreamy_Cream    :array[0..83] of byte=(99,111,108,50,1,175,175,141,2,255,255,230,50,255,255,236,51,233,232,214,52,206,203,160,53,206,203,160,54,168,166,131,55,255,255,238,56,168,166,131,57,255,255,238,58,225,225,208,100,255,255,230,101,255,255,230,102,145,145,120,103,145,145,120,104,135,135,110,105,135,135,110,106,135,135,110,107,255,255,230,108,255,255,230);
cols_Dreamy_Cream2   :array[0..83] of byte=(99,111,108,50,1,175,175,141,2,242,242,220,50,249,249,231,51,249,249,231,52,212,175,197,53,212,175,197,54,135,135,110,55,135,135,110,56,135,135,110,57,249,249,231,58,249,249,231,100,242,242,220,101,242,242,220,102,212,175,197,103,212,175,197,104,135,135,110,105,135,135,110,106,135,135,110,107,242,242,220,108,242,242,220);

cols_Gentle_Ginger   :array[0..83] of byte=(99,111,108,50,1,160,68,59,2,255,228,228,50,255,228,228,51,255,200,193,52,196,130,123,53,196,130,123,54,163,119,115,55,255,200,193,56,163,119,115,57,255,228,228,58,255,228,228,100,255,228,228,101,255,228,228,102,196,130,123,103,196,130,123,104,163,119,115,105,255,208,202,106,163,119,115,107,255,228,228,108,255,228,228);
cols_Gentle_Ginger2  :array[0..83] of byte=(99,111,108,50,1,160,68,59,2,242,217,217,50,255,228,228,51,255,228,228,52,196,130,123,53,196,130,123,54,163,119,115,55,255,208,202,56,163,119,115,57,255,228,228,58,255,228,228,100,242,217,217,101,242,217,217,102,196,130,123,103,196,130,123,104,163,119,115,105,255,208,202,106,163,119,115,107,242,217,217,108,242,217,217);

cols_Grumpy_Green:array[0..83] of byte=(99,111,108,50,1,16,41,0,2,116,141,81,50,179,192,163,51,164,174,150,52,93,116,64,53,93,116,64,54,0,9,0,55,179,192,163,56,0,9,0,57,179,192,163,58,164,174,150,100,116,141,81,101,70,98,56,102,10,18,10,103,10,18,10,104,0,8,0,105,130,158,116,106,0,8,0,107,116,141,81,108,70,98,56);



cols_Glowing_Grey    :array[0..83] of byte=(99,111,108,50,1,125,125,113,2,253,253,245,50,253,253,245,51,226,226,203,52,125,125,117,53,163,163,146,54,125,125,117,55,255,255,243,56,125,125,117,57,253,253,245,58,226,226,203,100,253,253,245,101,253,253,245,102,255,249,210,103,255,249,210,104,125,125,113,105,125,125,113,106,125,125,113,107,253,253,245,108,253,253,245);
cols_glowing_grey2   :array[0..83] of byte=(99,111,108,50,1,125,125,113,2,253,253,245,50,253,253,245,51,253,253,245,52,125,125,117,53,163,163,146,54,125,125,117,55,125,125,117,56,125,125,117,57,253,253,245,58,253,253,245,100,241,241,233,101,241,241,233,102,217,212,178,103,217,212,178,104,125,125,113,105,125,125,113,106,125,125,113,107,241,241,233,108,241,241,233);


cols_Jovial_Mauve:array[0..83] of byte=(99,111,108,50,1,168,139,175,2,248,219,242,50,248,219,247,51,228,207,227,52,138,109,137,53,188,166,194,54,140,114,139,55,234,228,236,56,140,114,139,57,248,219,247,58,228,207,227,100,248,219,242,101,248,219,242,102,138,109,132,103,138,109,132,104,140,114,139,105,140,114,139,106,140,114,139,107,248,219,242,108,248,219,242);
cols_Luscious_Lilac:array[0..83] of byte=(99,111,108,50,1,214,117,228,2,255,159,255,50,255,221,255,51,255,182,255,52,176,78,188,53,176,78,188,54,162,65,176,55,255,182,255,56,162,65,176,57,255,221,255,58,255,182,255,100,255,159,255,101,255,159,255,102,188,16,153,103,188,16,153,104,133,2,106,105,255,120,255,106,133,2,106,107,255,159,255,108,255,159,255);
cols_Slinky_Pink:array[0..83] of byte=(99,111,108,50,1,158,38,133,2,238,114,195,50,244,170,219,51,244,170,219,52,238,114,195,53,238,114,195,54,122,1,77,55,122,1,77,56,122,1,77,57,244,170,219,58,244,170,219,100,238,114,195,101,238,114,195,102,235,84,182,103,235,84,182,104,122,1,56,105,130,9,65,106,122,1,56,107,238,114,195,108,238,114,195);
cols_Rosebud_Pink:array[0..83] of byte=(99,111,108,50,1,255,89,170,2,255,155,218,50,255,242,242,51,241,214,226,52,255,142,214,53,255,142,214,54,183,101,153,55,255,226,249,56,135,74,100,57,255,237,244,58,241,214,226,100,255,155,218,101,255,155,218,102,255,67,159,103,255,67,159,104,159,60,106,105,159,60,106,106,159,60,106,107,255,155,218,108,255,155,218);
cols_Silky_Sand:array[0..83] of byte=(99,111,108,50,1,212,167,66,2,255,239,136,50,255,240,153,51,224,211,134,52,152,143,0,53,152,143,0,54,124,104,33,55,255,240,153,56,124,104,33,57,255,240,153,58,224,211,134,100,255,239,136,101,255,239,136,102,145,129,26,103,145,129,26,104,135,119,16,105,225,209,106,106,135,119,16,107,255,239,136,108,255,239,136);
cols_Red:array[0..83] of byte=(99,111,108,50,1,178,37,37,2,255,81,81,50,255,220,220,51,244,183,185,52,255,85,85,53,255,85,85,54,222,74,74,55,252,245,245,56,255,85,85,57,255,220,220,58,244,183,185,100,255,81,81,101,255,81,81,102,242,185,184,103,242,185,184,104,242,242,242,105,242,242,242,106,242,242,242,107,255,81,81,108,255,81,81);
cols_Radiant_Yellow:array[0..83] of byte=(99,111,108,50,1,201,201,112,2,255,255,159,50,255,255,220,51,247,247,154,52,255,255,159,53,255,255,159,54,114,122,1,55,114,122,1,56,114,122,1,57,255,255,220,58,247,247,154,100,255,255,159,101,255,255,159,102,123,130,9,103,123,130,9,104,114,122,1,105,195,202,24,106,114,122,1,107,255,255,159,108,255,255,159);
cols_Peach:array[0..83] of byte=(99,111,108,50,1,214,192,174,2,255,226,208,50,255,246,246,51,255,237,226,52,255,225,205,53,255,225,205,54,149,118,101,55,149,118,101,56,149,118,101,57,255,246,246,58,242,242,242,100,255,226,208,101,255,226,208,102,133,114,95,103,133,114,95,104,127,90,67,105,242,242,242,106,127,90,67,107,255,239,231,108,255,239,231);
cols_Tangy_Tangerine:array[0..83] of byte=(99,111,108,50,1,205,60,59,2,255,110,109,50,255,168,142,51,255,168,142,52,255,110,109,53,255,110,109,54,135,25,0,55,135,25,0,56,135,25,0,57,255,168,142,58,255,168,142,100,255,110,109,101,255,110,109,102,205,60,59,103,205,60,59,104,145,10,10,105,145,10,10,106,145,10,10,107,255,110,109,108,255,110,109);
cols_white_and_pale:array[0..83] of byte=(99,111,108,50,1,206,204,176,2,255,255,249,50,253,251,252,51,223,221,222,52,237,239,213,53,237,239,213,54,133,131,132,55,133,131,132,56,133,131,132,57,253,251,252,58,223,221,222,100,255,255,249,101,255,255,249,102,237,239,213,103,237,239,213,104,130,130,118,105,220,220,208,106,130,130,118,107,255,255,249,108,255,255,249);
cols_Wild_Thing:array[0..83] of byte=(99,111,108,50,1,0,106,118,2,70,206,218,50,122,221,122,51,92,191,92,52,12,111,12,53,12,111,12,54,2,101,2,55,152,251,152,56,42,141,42,57,122,221,122,58,122,221,122,100,255,192,0,101,225,162,0,102,145,82,10,103,145,82,10,104,135,72,0,105,225,162,0,106,175,112,0,107,255,192,0,108,255,192,0);
cols_Wild_Thing_Pastel:array[0..83] of byte=(99,111,108,50,1,0,106,118,2,255,230,155,50,187,237,187,51,149,189,149,52,149,189,149,53,149,189,149,54,2,101,2,55,152,251,152,56,2,101,2,57,187,237,187,58,187,237,187,100,255,230,155,101,189,136,0,102,145,82,10,103,145,82,10,104,135,72,0,105,225,162,0,106,175,112,0,107,255,230,155,108,255,230,155);
cols_black:array[0..83] of byte=(99,111,108,50,1,0,0,0,2,27,27,27,50,27,27,27,51,0,0,0,52,157,157,157,53,157,157,157,54,147,147,147,55,57,57,57,56,147,147,147,57,27,27,27,58,0,0,0,100,27,27,27,101,27,27,27,102,157,157,157,103,157,157,157,104,147,147,147,105,57,57,57,106,147,147,147,107,27,27,27,108,27,27,27);
cols_black2:array[0..83] of byte=(99,111,108,50,1,0,0,0,2,27,27,27,50,27,27,27,51,0,0,0,52,51,119,155,53,74,172,224,54,147,147,147,55,147,147,147,56,147,147,147,57,27,27,27,58,0,0,0,100,27,27,27,101,27,27,27,102,74,172,224,103,74,172,224,104,147,147,147,105,147,147,147,106,147,147,147,107,27,27,27,108,27,27,27);//09mar2025: updated with a slightly darker highlight color for use with textbox
cols_black3:array[0..83] of byte=(99,111,108,50,1,1,1,1,2,18,18,18,50,10,10,10,51,1,1,1,52,74,172,224,53,74,172,224,54,211,211,211,55,211,211,211,56,211,211,211,57,1,1,1,58,10,10,10,100,18,18,18,101,18,18,18,102,74,172,224,103,74,172,224,104,211,211,211,105,211,211,211,106,211,211,211,107,18,18,18,108,18,18,18);
cols_black4:array[0..83] of byte=(99,111,108,50,1,1,1,1,2,32,32,32,50,32,32,32,51,1,1,1,52,25,59,73,53,25,59,73,54,176,176,176,55,176,176,176,56,176,176,176,57,32,32,32,58,1,1,1,100,32,32,32,101,32,32,32,102,25,59,73,103,25,59,73,104,176,176,176,105,176,176,176,106,176,176,176,107,32,32,32,108,32,32,32);
cols_black5:array[0..83] of byte=(99,111,108,50,1,9,9,9,2,35,35,35,50,10,10,10,51,1,1,1,52,74,172,224,53,74,172,224,54,211,211,211,55,10,10,10,56,211,211,211,57,1,1,1,58,10,10,10,100,35,35,35,101,35,35,35,102,74,172,224,103,74,172,224,104,211,211,211,105,10,10,10,106,211,211,211,107,35,35,35,108,35,35,35);

cols_blue:array[0..83] of byte=(99,111,108,50,1,26,96,255,2,146,216,255,50,249,255,255,51,249,255,255,52,146,216,255,53,146,216,255,54,69,108,202,55,69,108,202,56,69,108,202,57,249,255,255,58,249,255,255,100,146,216,255,101,146,216,255,102,103,150,236,103,103,150,236,104,2,36,202,105,2,36,202,106,2,36,202,107,146,216,255,108,146,216,255);
cols_royal_blue:array[0..83] of byte=(99,111,108,50,1,0,0,255,2,77,119,255,50,245,245,245,51,245,245,245,52,138,170,255,53,138,170,255,54,0,0,255,55,0,0,255,56,0,0,255,57,245,245,245,58,245,245,245,100,77,119,255,101,77,119,255,102,237,237,237,103,237,237,237,104,0,0,135,105,0,0,135,106,0,0,135,107,77,119,255,108,77,119,255);
cols_pink:array[0..83] of byte=(99,111,108,50,1,209,129,196,2,255,223,252,50,255,223,252,51,255,223,252,52,255,179,243,53,255,179,243,54,122,86,117,55,122,86,117,56,122,86,117,57,255,223,252,58,255,223,252,100,255,223,252,101,255,223,252,102,255,158,240,103,255,158,240,104,122,86,117,105,122,86,117,106,122,86,117,107,255,223,252,108,255,223,252);
cols_wild_mix:array[0..83] of byte=(99,111,108,50,1,175,172,0,2,235,232,25,50,249,136,255,51,219,106,225,52,139,26,145,53,139,26,145,54,129,16,135,55,219,106,225,56,169,56,175,57,249,136,255,58,249,136,255,100,77,233,255,101,47,203,225,102,10,123,145,103,10,123,145,104,0,113,135,105,47,203,225,106,0,153,175,107,77,233,255,108,77,233,255);
cols_white:array[0..83] of byte=(99,111,108,50,1,210,210,210,2,255,255,255,50,255,255,255,51,214,214,214,52,204,232,255,53,204,232,255,54,65,65,65,55,65,65,65,56,65,65,65,57,255,255,255,58,214,214,214,100,255,255,255,101,255,255,255,102,204,232,255,103,204,232,255,104,65,65,65,105,65,65,65,106,65,65,65,107,255,255,255,108,255,255,255);
cols_white2:array[0..83] of byte=(99,111,108,50,1,210,210,210,2,255,255,255,50,255,255,255,51,214,214,214,52,166,165,165,53,166,165,165,54,65,65,65,55,214,214,214,56,65,65,65,57,255,255,255,58,255,255,255,100,255,255,255,101,225,225,225,102,166,165,165,103,166,165,165,104,65,65,65,105,225,225,225,106,65,65,65,107,255,255,255,108,255,255,255);
cols_white3:array[0..83] of byte=(99,111,108,50,1,210,210,210,2,255,255,255,50,255,255,255,51,214,214,214,52,204,232,255,53,204,232,255,54,139,139,139,55,139,139,139,56,139,139,139,57,255,255,255,58,214,214,214,100,255,255,255,101,255,255,255,102,204,232,255,103,204,232,255,104,139,139,139,105,139,139,139,106,139,139,139,107,255,255,255,108,255,255,255);
cols_white4:array[0..83] of byte=(99,111,108,50,1,210,210,210,2,255,255,255,50,255,255,255,51,214,214,214,52,166,165,165,53,166,165,165,54,139,139,139,55,214,214,214,56,139,139,139,57,255,255,255,58,255,255,255,100,255,255,255,101,225,225,225,102,166,165,165,103,166,165,165,104,139,139,139,105,225,225,225,106,139,139,139,107,255,255,255,108,255,255,255);
cols_white5:array[0..83] of byte=(99,111,108,50,1,210,210,210,2,255,255,255,50,249,249,249,51,249,249,249,52,204,232,255,53,204,232,255,54,139,139,139,55,139,139,139,56,139,139,139,57,249,249,249,58,249,249,249,100,255,255,255,101,255,255,255,102,204,232,255,103,204,232,255,104,139,139,139,105,139,139,139,106,139,139,139,107,255,255,255,108,255,255,255);
cols_white6:array[0..83] of byte=(99,111,108,50,1,37,37,37,2,101,101,101,50,249,249,249,51,255,255,255,52,204,232,255,53,204,232,255,54,139,139,139,55,139,139,139,56,139,139,139,57,255,255,255,58,255,255,255,100,101,101,101,101,101,101,101,102,204,232,255,103,204,232,255,104,239,239,239,105,239,239,239,106,239,239,239,107,101,101,101,108,101,101,101);
cols_white7:array[0..83] of byte=(99,111,108,50,1,37,37,37,2,23,23,23,50,249,249,249,51,249,249,249,52,204,232,255,53,204,232,255,54,139,139,139,55,139,139,139,56,139,139,139,57,249,249,249,58,249,249,249,100,23,23,23,101,23,23,23,102,204,232,255,103,204,232,255,104,240,240,240,105,239,239,239,106,239,239,239,107,23,23,23,108,23,23,23);
cols_satinpink:array[0..83] of byte=(99,111,108,50,1,115,83,113,2,251,223,255,50,254,248,255,51,224,218,225,52,255,196,249,53,255,196,249,54,134,128,135,55,143,111,145,56,174,168,175,57,254,248,255,58,254,248,255,100,253,221,255,101,223,191,225,102,239,165,198,103,239,165,198,104,133,101,135,105,143,111,145,106,173,141,175,107,253,221,255,108,253,221,255);
cols_satinpink2:array[0..83] of byte=(99,111,108,50,1,115,83,113,2,251,223,255,50,253,241,254,51,255,255,255,52,255,196,249,53,255,196,249,54,134,128,135,55,143,111,145,56,174,168,175,57,253,241,254,58,253,241,254,100,253,221,255,101,253,221,255,102,239,165,198,103,239,165,198,104,133,101,135,105,143,111,145,106,173,141,175,107,253,221,255,108,253,221,255);
cols_purple:array[0..83] of byte=(99,111,108,50,1,137,106,160,2,214,163,250,50,251,236,255,51,211,179,234,52,201,134,255,53,201,134,255,54,124,83,158,55,255,251,255,56,124,83,158,57,251,236,255,58,211,179,234,100,214,163,250,101,214,163,250,102,207,78,255,103,207,78,255,104,97,65,124,105,255,251,255,106,97,65,124,107,214,163,250,108,214,163,250);
cols_brown:array[0..83] of byte=(99,111,108,50,1,90,43,0,2,192,165,138,50,255,227,187,51,255,227,187,52,147,119,79,53,147,119,79,54,135,107,67,55,255,227,187,56,135,107,67,57,255,227,187,58,255,227,187,100,192,165,138,101,192,165,138,102,126,89,56,103,126,89,56,104,86,59,32,105,86,59,32,106,86,59,32,107,192,165,138,108,192,165,138);
cols_brown2:array[0..83] of byte=(99,111,108,50,1,90,43,0,2,192,165,138,50,255,233,203,51,255,233,203,52,211,188,150,53,211,188,150,54,135,107,67,55,135,107,67,56,135,107,67,57,255,233,203,58,255,233,203,100,192,165,138,101,192,165,138,102,126,89,56,103,126,89,56,104,86,59,32,105,86,59,32,106,86,59,32,107,192,165,138,108,192,165,138);
cols_brown3:array[0..83] of byte=(99,111,108,50,1,140,93,45,2,209,184,159,50,242,230,212,51,242,230,212,52,209,184,159,53,209,184,159,54,130,83,35,55,130,83,35,56,130,83,35,57,242,230,212,58,242,230,212,100,209,184,159,101,209,184,159,102,161,137,108,103,161,137,108,104,130,83,35,105,130,83,35,106,130,83,35,107,209,184,159,108,209,184,159);

cols_deep_purple  :array[0..83] of byte=(99,111,108,50,1,16,0,23,2,34,1,49,50,13,1,18,51,13,1,18,52,143,2,204,53,143,2,204,54,156,92,184,55,13,1,18,56,156,92,184,57,13,1,18,58,13,1,18,100,34,1,49,101,34,1,49,102,143,2,204,103,143,2,204,104,156,92,184,105,13,1,18,106,156,92,184,107,34,1,49,108,34,1,49);
cols_deep_purple2 :array[0..83] of byte=(99,111,108,50,1,11,11,11,2,42,42,42,50,12,12,12,51,1,1,1,52,179,3,255,53,179,3,255,54,156,92,184,55,12,12,12,56,156,92,184,57,1,1,1,58,12,12,12,100,42,42,42,101,42,42,42,102,179,3,255,103,179,3,255,104,156,92,184,105,12,12,12,106,156,92,184,107,42,42,42,108,42,42,42);

cols_deep_pink    :array[0..83] of byte=(99,111,108,50,1,23,4,20,2,51,8,45,50,13,0,9,51,13,0,9,52,205,12,148,53,205,12,148,54,184,94,170,55,13,0,9,56,184,94,170,57,13,0,9,58,13,0,9,100,51,10,41,101,51,10,41,102,205,12,148,103,205,12,148,104,184,94,170,105,13,0,9,106,184,94,170,107,51,10,41,108,51,10,41);
cols_deep_pink2   :array[0..83] of byte=(99,111,108,50,1,1,0,1,2,42,42,42,50,13,0,9,51,13,0,9,52,205,12,148,53,205,12,148,54,184,94,170,55,13,0,9,56,184,94,170,57,13,0,9,58,13,0,9,100,42,42,42,101,42,42,42,102,205,12,148,103,205,12,148,104,184,94,170,105,13,0,9,106,184,94,170,107,42,42,42,108,42,42,42);

cols_deep_candypink :array[0..83] of byte=(99,111,108,50,1,23,0,15,2,51,0,33,50,13,0,8,51,13,0,8,52,253,0,166,53,253,0,166,54,184,13,124,55,13,0,8,56,184,13,124,57,13,0,8,58,13,0,8,100,51,0,33,101,51,0,33,102,253,0,166,103,253,0,166,104,184,13,124,105,13,0,8,106,184,13,124,107,51,0,33,108,51,0,33);
cols_deep_candypink2:array[0..83] of byte=(99,111,108,50,1,0,0,0,2,42,42,42,50,13,0,8,51,13,0,8,52,253,0,166,53,253,0,166,54,184,13,124,55,13,0,8,56,184,13,124,57,13,0,8,58,13,0,8,100,42,42,42,101,42,42,42,102,253,0,166,103,253,0,166,104,184,13,124,105,13,0,8,106,184,13,124,107,42,42,42,108,42,42,42);

cols_deep_red     :array[0..83] of byte=(99,111,108,50,1,26,8,10,2,43,13,17,50,18,0,2,51,18,0,2,52,171,0,24,53,171,0,24,54,209,115,128,55,18,0,2,56,209,115,128,57,18,0,2,58,18,0,2,100,43,13,17,101,43,13,17,102,214,0,30,103,214,0,30,104,209,115,128,105,18,0,2,106,209,115,128,107,43,13,17,108,43,13,17);
cols_deep_red2    :array[0..83] of byte=(99,111,108,50,1,0,0,0,2,42,42,42,50,0,0,0,51,0,0,0,52,171,0,24,53,171,0,24,54,209,115,128,55,0,0,0,56,209,115,128,57,0,0,0,58,0,0,0,100,42,42,42,101,42,42,42,102,214,0,30,103,214,0,30,104,209,115,128,105,0,0,0,106,209,115,128,107,42,42,42,108,42,42,42);

cols_deep_yellow  :array[0..83] of byte=(99,111,108,50,1,12,12,0,2,26,26,0,50,14,14,0,51,14,14,0,52,241,241,0,53,241,241,0,54,194,194,124,55,14,14,0,56,194,194,124,57,14,14,0,58,14,14,0,100,26,26,0,101,26,26,0,102,241,241,0,103,241,241,0,104,194,194,124,105,14,14,0,106,194,194,124,107,48,48,0,108,48,48,0);
cols_deep_yellow2 :array[0..83] of byte=(99,111,108,50,1,11,11,11,2,42,42,42,50,12,12,12,51,1,1,1,52,241,241,0,53,241,241,0,54,194,194,124,55,12,12,12,56,194,194,124,57,1,1,1,58,12,12,12,100,42,42,42,101,42,42,42,102,241,241,0,103,241,241,0,104,194,194,124,105,12,12,12,106,194,194,124,107,42,42,42,108,42,42,42);

cols_deep_orange  :array[0..83] of byte=(99,111,108,50,1,39,24,6,2,46,36,24,50,16,8,0,51,16,8,0,52,252,135,0,53,252,135,0,54,255,234,163,55,16,8,0,56,255,234,163,57,16,8,0,58,16,8,0,100,46,36,24,101,46,36,24,102,252,135,0,103,252,135,0,104,255,234,163,105,16,8,0,106,255,234,163,107,46,36,24,108,46,36,24);
cols_deep_orange2 :array[0..83] of byte=(99,111,108,50,1,11,11,11,2,42,42,42,50,12,12,12,51,1,1,1,52,252,135,0,53,252,135,0,54,255,234,163,55,12,12,12,56,255,234,163,57,1,1,1,58,12,12,12,100,42,42,42,101,42,42,42,102,252,135,0,103,252,135,0,104,255,234,163,105,12,12,12,106,255,234,163,107,42,42,42,108,42,42,42);

cols_deep_royal_blue  :array[0..83] of byte=(99,111,108,50,1,3,1,33,2,5,1,51,50,7,5,18,51,25,23,34,52,25,3,255,53,25,3,255,54,129,125,162,55,7,5,18,56,129,125,162,57,7,5,18,58,7,5,18,100,5,1,51,101,5,1,51,102,25,3,255,103,25,3,255,104,129,125,162,105,7,5,18,106,129,125,162,107,5,1,51,108,5,1,51);
cols_deep_royal_blue2 :array[0..83] of byte=(99,111,108,50,1,0,0,0,2,42,42,42,50,9,7,24,51,9,7,24,52,25,3,255,53,25,3,255,54,129,125,162,55,9,7,24,56,129,125,162,57,1,1,1,58,1,1,1,100,42,42,42,101,42,42,42,102,25,3,255,103,25,3,255,104,129,125,162,105,9,7,24,106,129,125,162,107,42,42,42,108,42,42,42);

cols_deep_blue    :array[0..83] of byte=(99,111,108,50,1,0,10,15,2,0,28,43,50,0,12,19,51,0,12,19,52,0,139,215,53,0,139,215,54,132,193,229,55,0,12,19,56,132,193,229,57,0,12,19,58,0,12,19,100,0,28,43,101,0,28,43,102,0,139,215,103,0,139,215,104,132,193,229,105,0,12,19,106,132,193,229,107,0,28,43,108,0,28,43);
cols_deep_blue2   :array[0..83] of byte=(99,111,108,50,1,0,0,0,2,42,42,42,50,0,12,19,51,0,12,19,52,0,139,215,53,0,139,215,54,132,193,229,55,0,12,19,56,132,193,229,57,0,12,19,58,0,12,19,100,42,42,42,101,42,42,42,102,0,139,215,103,0,139,215,104,132,193,229,105,0,12,19,106,132,193,229,107,42,42,42,108,42,42,42);

cols_deep_green   :array[0..83] of byte=(99,111,108,50,1,14,17,9,2,27,34,18,50,6,11,0,51,6,11,0,52,140,246,0,53,140,246,0,54,185,217,139,55,6,11,0,56,185,217,139,57,6,11,0,58,6,11,0,100,27,34,18,101,27,34,18,102,140,246,0,103,140,246,0,104,185,217,139,105,6,11,0,106,185,217,139,107,27,34,18,108,27,34,18);
cols_deep_green2  :array[0..83] of byte=(99,111,108,50,1,0,0,0,2,42,42,42,50,0,0,0,51,0,0,0,52,140,246,0,53,140,246,0,54,185,217,139,55,0,0,0,56,185,217,139,57,0,0,0,58,0,0,0,100,42,42,42,101,42,42,42,102,140,246,0,103,140,246,0,104,185,217,139,105,0,0,0,106,185,217,139,107,42,42,42,108,42,42,42);

cols_deep_lime    :array[0..83] of byte=(99,111,108,50,1,26,8,10,2,34,44,1,50,8,11,0,51,8,11,0,52,168,219,3,53,168,219,3,54,134,175,2,55,8,11,0,56,134,175,2,57,8,11,0,58,8,11,0,100,34,44,1,101,34,44,1,102,168,219,3,103,168,219,3,104,134,175,2,105,8,11,0,106,134,175,2,107,18,0,2,108,18,0,2);
cols_deep_lime2   :array[0..83] of byte=(99,111,108,50,1,0,0,0,2,42,42,42,50,8,11,0,51,8,11,0,52,168,219,3,53,168,219,3,54,134,175,2,55,8,11,0,56,134,175,2,57,8,11,0,58,8,11,0,100,42,42,42,101,42,42,42,102,168,219,3,103,168,219,3,104,134,175,2,105,8,11,0,106,134,175,2,107,42,42,42,108,42,42,42);

cols_deep_aqua    :array[0..83] of byte=(99,111,108,50,1,0,22,22,2,0,48,50,50,0,19,20,51,0,19,20,52,0,194,202,53,0,194,202,54,0,175,182,55,0,19,20,56,0,175,182,57,0,19,20,58,0,19,20,100,0,48,50,101,0,48,50,102,0,194,202,103,0,194,202,104,0,175,182,105,0,19,20,106,0,175,182,107,0,48,50,108,0,48,50);
cols_deep_aqua2   :array[0..83] of byte=(99,111,108,50,1,0,0,0,2,42,42,42,50,0,19,20,51,0,19,20,52,0,194,202,53,0,194,202,54,0,175,182,55,0,19,20,56,0,175,182,57,0,19,20,58,0,19,20,100,42,42,42,101,42,42,42,102,0,194,202,103,0,194,202,104,0,175,182,105,0,19,20,106,0,175,182,107,42,42,42,108,42,42,42);

cols_light_and_lilac   :array[0..83] of byte=(99,111,108,50,1,197,211,249,2,220,231,245,50,241,241,241,51,241,241,241,52,210,201,255,53,164,147,255,54,134,132,178,55,134,132,178,56,134,132,178,57,241,241,241,58,241,241,241,100,220,231,245,101,241,241,241,102,210,201,255,103,164,147,255,104,134,132,178,105,134,132,178,106,134,132,178,107,241,241,241,108,241,241,241);
cols_light_and_blue    :array[0..83] of byte=(99,111,108,50,1,182,196,234,2,220,231,245,50,241,241,241,51,241,241,241,52,199,223,252,53,199,223,252,54,121,125,145,55,121,125,145,56,121,125,145,57,241,241,241,58,241,241,241,100,220,231,245,101,220,231,245,102,199,223,252,103,199,223,252,104,121,125,145,105,121,125,145,106,121,125,145,107,220,231,245,108,220,231,245);
cols_light_and_pink    :array[0..83] of byte=(99,111,108,50,1,205,175,195,2,241,206,229,50,241,241,241,51,241,241,241,52,255,156,220,53,255,156,220,54,166,122,150,55,166,122,150,56,166,122,150,57,241,241,241,58,241,241,241,100,241,206,229,101,241,206,229,102,255,156,220,103,255,156,220,104,166,122,150,105,166,122,150,106,166,122,150,107,241,206,229,108,241,206,229);
cols_light_and_warm    :array[0..83] of byte=(99,111,108,50,1,166,153,114,2,255,242,203,50,241,241,241,51,241,241,241,52,255,235,175,53,242,224,170,54,153,141,105,55,153,141,105,56,153,141,105,57,241,241,241,58,241,241,241,100,249,236,199,101,249,236,199,102,255,235,175,103,242,224,170,104,153,141,105,105,153,141,105,106,153,141,105,107,249,236,199,108,249,236,199);
cols_light_and_salmon  :array[0..83] of byte=(99,111,108,50,1,204,157,180,2,255,196,225,50,241,241,241,51,241,241,241,52,255,214,234,53,255,214,234,54,163,137,150,55,163,137,150,56,163,137,150,57,241,241,241,58,241,241,241,100,255,196,225,101,255,196,225,102,255,214,234,103,255,214,234,104,147,124,135,105,147,124,135,106,147,124,135,107,255,196,225,108,255,196,225);
cols_light_and_grey    :array[0..83] of byte=(99,111,108,50,1,130,130,130,2,217,217,217,50,241,241,241,51,241,241,241,52,217,217,217,53,217,217,217,54,122,122,122,55,122,122,122,56,122,122,122,57,241,241,241,58,241,241,241,100,217,217,217,101,217,217,217,102,178,178,178,103,178,178,178,104,122,122,122,105,122,122,122,106,122,122,122,107,217,217,217,108,217,217,217);
cols_light_and_aqua    :array[0..83] of byte=(99,111,108,50,1,185,217,216,2,218,255,254,50,242,242,242,51,242,242,242,52,218,255,254,53,73,255,254,54,108,147,146,55,108,147,146,56,108,147,146,57,242,242,242,58,242,242,242,100,218,255,254,101,218,255,254,102,218,255,254,103,73,255,254,104,108,147,146,105,108,147,146,106,108,147,146,107,218,255,254,108,218,255,254);
cols_light_and_orange  :array[0..83] of byte=(99,111,108,50,1,255,228,160,2,255,239,200,50,255,249,235,51,255,249,235,52,255,226,154,53,255,202,71,54,175,137,43,55,175,137,43,56,175,137,43,57,255,249,235,58,255,249,235,100,255,235,184,101,255,235,184,102,255,226,154,103,255,202,71,104,175,137,43,105,175,137,43,106,175,137,43,107,255,235,184,108,255,235,184);
cols_light_and_lime    :array[0..83] of byte=(99,111,108,50,1,196,252,89,2,219,253,156,50,255,249,235,51,255,249,235,52,200,252,102,53,164,250,0,54,107,162,0,55,107,162,0,56,107,162,0,57,255,249,235,58,255,249,235,100,228,253,180,101,228,253,180,102,200,252,102,103,164,250,0,104,107,162,0,105,107,162,0,106,107,162,0,107,228,253,180,108,228,253,180);
cols_light_and_mustard :array[0..83] of byte=(99,111,108,50,1,194,176,51,2,227,220,163,50,255,249,235,51,255,249,235,52,209,196,102,53,206,191,89,54,143,125,0,55,143,125,0,56,143,125,0,57,255,249,235,58,255,249,235,100,227,220,163,101,227,220,163,102,209,196,102,103,206,191,89,104,143,125,0,105,143,125,0,106,143,125,0,107,227,220,163,108,227,220,163);

cols_black_and_pink    :array[0..83] of byte=(99,111,108,50,1,255,35,175,2,64,20,48,50,14,0,4,51,14,0,4,52,255,35,175,53,255,35,175,54,255,79,191,55,14,0,4,56,255,79,191,57,14,0,4,58,14,0,4,100,14,0,4,101,14,0,4,102,255,35,175,103,255,35,175,104,255,79,191,105,14,0,4,106,255,79,191,107,14,0,4,108,14,0,4);
cols_black_and_orange  :array[0..83] of byte=(99,111,108,50,1,238,116,0,2,46,23,0,50,14,0,4,51,14,0,4,52,238,116,0,53,238,116,0,54,242,151,64,55,14,0,4,56,242,151,64,57,14,0,4,58,14,0,4,100,14,0,4,101,14,0,4,102,238,116,0,103,238,116,0,104,242,151,64,105,14,0,4,106,242,151,64,107,14,0,4,108,14,0,4);

cols_black_and_aqua    :array[0..83] of byte=(99,111,108,50,1,31,212,255,2,5,32,38,50,2,11,13,51,2,11,13,52,31,212,255,53,31,212,255,54,65,218,255,55,2,11,13,56,65,218,255,57,11,20,22,58,2,11,13,100,2,11,13,101,2,11,13,102,31,212,255,103,31,212,255,104,65,218,255,105,2,11,13,106,65,218,255,107,2,11,13,108,2,11,13);

//:array[0..83] of byte=(99,111,108,50,1,140,93,45,2,209,184,159,50,242,230,212,51,242,230,212,52,209,184,159,53,209,184,159,54,130,83,35,55,130,83,35,56,130,83,35,57,242,230,212,58,242,230,212,100,209,184,159,101,209,184,159,102,181,153,125,103,181,153,125,104,130,83,35,105,130,83,35,106,130,83,35,107,209,184,159,108,209,184,159);


//embedded fonts ---------------------------------------------------------------
{
sysfont__arial_8:array[0..8326] of byte=(
71,70,35,51,16,0,13,0,10,0,8,6,0,0,10,0,12,6,0,0,10,0,16,6,0,0,10,0,34,6,0,0,10,0,50,6,0,0,10,0,66,6,0,0,10,0,96,6,0,0,10,0,100,6,0,0,10,0,112,6,0,0,10,0,152,6,0,0,10,0,156,6,0,0,10,0,160,6,0,0,10,0,190,6,0,0,10,0,224,6,0,0,10,0,228,6,0,0,10,0,10,7,0,0,10,0,56,7,0,0,10,0,86,7,0,0,10,0,110,7,0,0,10,0,146,7,0,0,10,0,188,7,0,0,10,0,248,7,0,0,10,0,8,8,0,0,10,0,26,8,0,0,10,0,56,8,0,0,10,0,86,8,0,0,10,0,116,8,0,0,10,0,128,8,0,0,10,0,140,8,0,0,10,0,144,8,0,0,10,0,148,8,0,0,10,0,152,8,0,0,4,0,156,8,0,0,3,0,158,8,0,0,5,0,178,8,0,0,8,0,192,8,0,0,7,0,230,8,0,0,12,0,16,9,0,0,9,0,70,9,0,0,2,0,110,9,0,0,4,0,118,9,0,0,4,0,145,9,0,0,5,0,173,9,0,0,8,0,185,9,0,0,4,0,201,9,0,0,4,0,209,9,0,0,4,0,213,9,0,0,4,0,217,9,0,0,7,0,239,9,0,0,7,0,21,10,0,0,7,0,45,10,0,0,7,0,69,10,0,0,7,0,95,10,0,0,7,0,125,10,0,0,7,0,151,10,0,0,7,0,185,10,0,0,7,0,207,10,0,0,7,0,243,10,0,0,4,0,21,11,0,0,4,0,27,11,0,0,8,0,37,11,0,0,8,0,53,11,0,0,8,0,59,11,0,0,7,0,75,11,0,0,13,0,99,11,0,0,9,0,175,11,0,0,9,0,211,11,0,0,9,0,247,11,0,0,9,0,21,12,0,
0,9,0,59,12,0,0,8,0,81,12,0,0,10,0,103,12,0,0,9,0,137,12,0,0,3,0,177,12,0,0,6,0,199,12,0,0,9,0,225,12,0,0,7,0,11,13,0,0,11,0,33,13,0,0,9,0,99,13,0,0,10,0,153,13,0,0,9,0,191,13,0,0,10,0,221,13,0,0,9,0,7,14,0,0,9,0,45,14,0,0,7,0,75,14,0,0,9,0,97,14,0,0,9,0,137,14,0,0,13,0,173,14,0,0,7,0,243,14,0,0,9,0,25,15,0,0,7,0,57,15,0,0,4,0,79,15,0,0,4,0,107,15,0,0,4,0,129,15,0,0,5,0,157,15,0,0,7,0,177,15,0,0,4,0,180,15,0,0,7,0,186,15,0,0,7,0,210,15,0,0,7,0,244,15,0,0,7,0,8,16,0,0,7,0,42,16,0,0,3,0,64,16,0,0,7,0,86,16,0,0,7,0,124,16,0,0,3,0,160,16,0,0,4,0,178,16,0,0,7,0,202,16,0,0,3,0,236,16,0,0,11,0,2,17,0,0,7,0,46,17,0,0,7,0,76,17,0,0,7,0,102,17,0,0,7,0,138,17,0,0,4,0,174,17,0,0,7,0,192,17,0,0,4,0,212,17,0,0,7,0,232,17,0,0,5,0,4,18,0,0,9,0,28,18,0,0,7,0,72,18,0,0,7,0,100,18,0,0,7,0,132,18,0,0,4,0,148,18,0,0,3,0,176,18,0,0,4,0,202,18,0,0,8,0,230,18,0,0,10,0,240,18,0,0,7,0,22,19,0,0,1,0,44,19,0,0,3,0,46,19,0,0,7,0,54,19,0,0,4,0,82,19,0,0,13,0,96,19,0,0,7,0,106,19,0,0,7,0,132,19,0,0,5,0,158,19,0,0,14,0,166,19,
0,0,9,0,236,19,0,0,4,0,16,20,0,0,13,0,30,20,0,0,1,0,72,20,0,0,7,0,74,20,0,0,1,0,102,20,0,0,1,0,104,20,0,0,3,0,106,20,0,0,3,0,114,20,0,0,4,0,122,20,0,0,4,0,136,20,0,0,5,0,150,20,0,0,7,0,158,20,0,0,13,0,162,20,0,0,4,0,166,20,0,0,13,0,174,20,0,0,7,0,208,20,0,0,4,0,234,20,0,0,12,0,248,20,0,0,1,0,28,21,0,0,7,0,30,21,0,0,9,0,52,21,0,0,4,0,88,21,0,0,3,0,90,21,0,0,7,0,110,21,0,0,7,0,152,21,0,0,7,0,178,21,0,0,7,0,204,21,0,0,3,0,236,21,0,0,7,0,2,22,0,0,4,0,40,22,0,0,10,0,46,22,0,0,4,0,90,22,0,0,7,0,100,22,0,0,8,0,126,22,0,0,4,0,136,22,0,0,10,0,140,22,0,0,7,0,188,22,0,0,5,0,192,22,0,0,7,0,206,22,0,0,4,0,224,22,0,0,4,0,236,22,0,0,4,0,250,22,0,0,7,0,0,23,0,0,7,0,34,23,0,0,4,0,80,23,0,0,4,0,84,23,0,0,4,0,91,23,0,0,5,0,103,23,0,0,7,0,117,23,0,0,11,0,143,23,0,0,11,0,187,23,0,0,11,0,231,23,0,0,8,0,23,24,0,0,9,0,47,24,0,0,9,0,87,24,0,0,9,0,127,24,0,0,9,0,169,24,0,0,9,0,213,24,0,0,9,0,253,24,0,0,13,0,39,25,0,0,9,0,77,25,0,0,9,0,113,25,0,0,9,0,139,25,0,0,9,0,165,25,0,0,9,0,193,25,0,0,3,0,219,25,0,0,3,0,244,25,0,0,3,
0,14,26,0,0,3,0,38,26,0,0,9,0,64,26,0,0,9,0,102,26,0,0,10,0,164,26,0,0,10,0,206,26,0,0,10,0,248,26,0,0,10,0,36,27,0,0,10,0,82,27,0,0,8,0,124,27,0,0,10,0,140,27,0,0,9,0,194,27,0,0,9,0,238,27,0,0,9,0,26,28,0,0,9,0,72,28,0,0,9,0,116,28,0,0,9,0,152,28,0,0,9,0,182,28,0,0,7,0,224,28,0,0,7,0,252,28,0,0,7,0,24,29,0,0,7,0,54,29,0,0,7,0,86,29,0,0,7,0,114,29,0,0,12,0,146,29,0,0,7,0,180,29,0,0,7,0,206,29,0,0,7,0,232,29,0,0,7,0,2,30,0,0,7,0,30,30,0,0,3,0,56,30,0,0,3,0,76,30,0,0,3,0,96,30,0,0,3,0,114,30,0,0,7,0,134,30,0,0,7,0,170,30,0,0,7,0,208,30,0,0,7,0,238,30,0,0,7,0,12,31,0,0,7,0,44,31,0,0,7,0,78,31,0,0,7,0,108,31,0,0,7,0,116,31,0,0,7,0,148,31,0,0,7,0,180,31,0,0,7,0,212,31,0,0,7,0,246,31,0,0,7,0,22,32,0,0,7,0,58,32,0,0,7,0,96,32,0,0,0,128,0,159,0,128,0,159,0,69,3,8,0,8,0,8,0,8,0,8,0,8,0,8,0,15,0,12,0,8,0,8,0,8,0,8,0,8,0,8,3,82,0,12,0,8,0,8,0,8,0,8,0,8,0,5,3,85,0,12,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,15,0,69,6,82,0,51,2,5,4,4,4,4,4,5,2,64,0,9,6,2,6,2,6,2,6,2,1,2,1,2,0,4,0,2,0,4,0,2,0,4,0,
2,1,2,1,2,6,2,6,2,6,2,6,2,6,12,0,128,0,159,0,128,0,159,0,32,3,7,1,6,0,0,0,6,0,0,0,5,0,8,0,7,1,6,0,1,0,5,0,1,0,6,1,35,0,40,6,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,6,31,0,128,0,159,0,34,1,4,2,0,0,4,0,1,1,4,2,0,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,1,1,3,1,1,1,3,1,36,0,30,0,0,0,0,0,4,0,0,0,0,0,5,0,0,0,6,0,0,0,5,1,0,1,5,0,0,0,6,0,0,0,5,0,0,0,0,0,4,0,0,0,0,0,43,0,12,0,8,0,8,0,8,0,8,0,8,0,5,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,15,0,25,0,7,1,6,2,5,3,4,4,3,5,4,4,5,3,6,2,7,1,8,0,32,0,12,0,7,2,5,0,0,0,0,0,6,0,8,0,8,0,8,0,8,0,8,0,8,0,6,0,0,0,0,0,5,2,7,0,25,0,21,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,25,0,1,0,5,0,1,0,23,0,21,1,0,0,4,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0,4,0,0,0,0,0,5,1,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,23,0,12,0,8,0,8,0,8,0,8,0,8,0,5,6,82,0,69,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,15,0,12,0,8,0,8,0,8,0,8,0,8,0,5,3,8,0,8,0,8,0,8,0,8,0,8,0,8,0,15,0,22,0,7,2,5,0,0,0,0,0,6,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,25,0,12,0,8,0,8,0,8,0,8,0,8,0,8,3,5,0,8,0,8,0,8,0,8,
0,8,0,8,0,15,0,63,0,9,0,4,5,7,0,7,0,54,0,62,0,7,0,7,5,4,0,9,0,55,0,128,0,159,0,128,0,159,0,128,0,159,0,128,0,159,0,63,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,4,0,9,0,15,0,0,0,1,0,0,0,1,0,0,0,50,0,26,0,1,0,3,0,1,0,2,0,2,0,0,7,1,0,1,0,3,0,1,0,1,7,0,0,1,0,3,0,1,0,3,0,1,0,26,0,22,2,2,0,0,0,0,0,1,0,0,0,3,0,0,0,3,2,5,2,3,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,2,2,4,0,16,0,37,1,3,0,3,0,1,0,1,0,4,0,1,0,1,0,4,0,1,0,0,0,6,1,1,0,9,0,1,1,6,0,0,0,1,0,4,0,1,0,1,0,4,0,1,0,1,0,3,0,3,1,37,0,29,1,5,0,1,0,4,0,1,0,4,0,1,0,5,1,5,1,5,0,1,0,1,0,1,0,2,0,0,0,1,0,2,1,3,2,1,1,26,0,6,0,0,0,0,0,19,0,14,0,1,0,2,0,1,0,2,0,2,0,2,0,2,0,2,0,2,0,3,0,2,0,3,0,0,11,0,3,0,2,0,3,0,2,0,2,0,2,0,2,0,2,0,2,0,1,0,2,0,1,0,2,0,16,0,1,4,1,0,2,0,0,0,45,0,43,0,6,0,6,0,3,6,3,0,6,0,6,0,34,0,49,0,2,0,2,0,4,0,35,2,24,0,48,0,13,0,14,0,2,0,1,0,2,0,2,0,1,0,2,0,2,0,1,0,2,0,14,0,21,3,1,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,1,3,22,0,23,0,4,1,3,0,0,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,23,0,21,3,1,0,3,0,5,0,5,0,5,0,4,0,4,0,4,0,4,0,4,5,21,0,21,3,1,0,3,0,5,
0,5,0,2,2,6,0,5,0,5,0,0,0,3,0,1,3,22,0,24,0,4,1,4,1,3,0,0,0,3,0,0,0,2,0,1,0,2,0,1,0,1,5,4,0,5,0,22,0,21,4,1,0,5,0,4,0,5,4,1,0,3,0,5,0,5,0,0,0,3,0,1,3,22,0,21,3,1,0,3,0,0,0,5,0,5,0,0,2,1,1,2,0,0,0,3,0,0,0,3,0,0,0,3,0,1,3,22,0,20,5,4,0,5,0,4,0,5,0,4,0,5,0,4,0,5,0,5,0,25,0,21,3,1,0,3,0,0,0,3,0,0,0,3,0,1,3,1,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,1,3,22,0,21,3,1,0,3,0,0,0,3,0,0,0,3,0,0,0,2,1,1,2,0,0,5,0,5,0,0,0,2,0,2,2,23,0,24,0,22,0,13,0,24,0,22,0,2,0,2,0,5,0,45,0,4,1,3,1,4,0,7,1,7,1,7,0,32,0,47,6,16,6,48,0,40,0,7,1,7,1,7,0,4,1,3,1,4,0,37,0,22,2,2,0,2,0,1,0,2,0,5,0,4,0,4,0,4,0,5,0,12,0,24,0,42,4,5,1,4,0,3,0,7,0,2,0,1,2,0,0,1,0,0,0,1,0,2,1,1,0,0,0,0,0,4,0,1,0,0,0,0,0,3,0,2,0,0,0,0,0,3,0,1,0,1,0,0,0,2,1,1,0,1,0,1,2,0,2,3,0,8,0,2,0,5,1,4,5,3,0,30,0,6,0,0,0,5,0,0,0,5,0,0,0,4,0,2,0,3,0,2,0,2,6,1,0,4,0,0,0,6,1,6,0,26,0,27,5,2,0,4,0,1,0,4,0,1,0,4,0,1,5,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,5,28,0,29,2,4,0,2,0,2,0,4,0,1,0,7,0,7,0,7,0,7,0,4,0,2,0,2,0,4,2,29,0,27,4,3,0,3,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,
1,0,3,0,2,4,29,0,27,6,1,0,7,0,7,0,7,6,1,0,7,0,7,0,7,0,7,6,27,0,24,5,1,0,6,0,6,0,6,4,2,0,6,0,6,0,6,0,6,0,29,0,32,3,4,0,3,0,2,0,5,0,1,0,8,0,8,0,2,3,1,0,5,0,1,0,5,0,2,0,3,0,4,3,32,0,27,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,6,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,27,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,21,0,4,0,4,0,4,0,4,0,4,0,4,0,0,0,2,0,0,0,2,0,1,2,19,0,27,0,5,0,0,0,4,0,1,0,3,0,2,0,2,0,3,0,1,0,4,0,0,1,4,1,1,0,3,0,3,0,2,0,4,0,1,0,5,0,26,0,21,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,5,20,0,33,0,6,0,1,1,4,1,1,1,4,1,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,2,0,2,0,1,0,2,0,2,0,33,0,27,0,4,0,1,1,3,0,1,0,0,0,2,0,1,0,0,0,2,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,2,0,0,0,1,0,2,0,0,0,1,0,3,1,1,0,4,0,27,0,32,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,32,0,27,5,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,5,2,0,7,0,7,0,7,0,33,0,32,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,2,1,0,0,2,0,3,0,4,3,0,0,30,0,27,5,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,5,2,0,2,0,
3,0,3,0,2,0,3,0,2,0,4,0,27,0,28,4,2,0,4,0,1,0,4,0,1,0,8,2,8,1,8,0,1,0,4,0,1,0,4,0,2,4,28,0,20,6,2,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,23,0,27,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,29,0,26,0,6,1,6,0,0,0,4,0,1,0,4,0,2,0,2,0,3,0,2,0,4,0,0,0,5,0,0,0,6,0,7,0,30,0,38,0,4,0,4,1,3,0,0,0,3,0,0,0,2,0,0,0,2,0,1,0,2,0,0,0,2,0,1,0,2,0,0,0,2,0,2,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,3,0,0,0,2,0,0,0,4,0,4,0,5,0,4,0,41,0,20,0,4,0,0,0,2,0,1,0,2,0,2,0,0,0,4,0,5,0,4,0,0,0,2,0,2,0,1,0,2,0,0,0,4,0,20,0,27,0,4,0,2,0,2,0,3,0,2,0,4,0,0,0,5,0,0,0,6,0,7,0,7,0,7,0,7,0,30,0,21,5,4,0,4,0,5,0,4,0,5,0,4,0,5,0,4,0,4,6,20,0,12,1,1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,1,0,0,11,0,2,0,3,0,2,0,2,0,3,0,2,0,2,0,3,0,2,0,11,0,12,1,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,1,0,0,21,0,2,0,0,0,1,0,0,0,1,0,0,0,0,0,2,0,34,0,104,6,0,12,0,3,0,44,0,43,2,2,0,2,0,5,0,2,3,1,0,2,0,1,0,1,1,2,1,0,0,21,0,21,0,5,0,5,0,5,0,0,1,2,1,1,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,3,22,0,43,2,2,0,2,0,1,0,5,0,5,0,5,0,2,0,2,2,22,0,
25,0,5,0,5,0,2,1,0,0,1,0,1,1,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,3,21,0,43,2,2,0,2,0,1,0,2,0,1,4,1,0,5,0,2,0,2,2,22,0,10,0,0,0,1,0,0,2,0,0,1,0,1,0,1,0,1,0,1,0,9,0,43,1,0,0,1,0,1,1,1,0,2,0,1,0,2,0,1,0,2,0,1,0,1,1,2,1,0,0,5,0,1,0,2,0,2,2,1,0,21,0,5,0,5,0,5,0,0,1,2,1,1,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,21,0,9,0,7,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,13,0,10,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,1,1,0,21,0,5,0,5,0,5,0,2,0,1,0,1,0,2,0,0,0,3,2,3,0,1,0,2,0,1,0,2,0,2,0,21,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,66,0,0,1,1,1,2,1,1,1,1,0,1,0,2,0,2,0,1,0,2,0,2,0,1,0,2,0,2,0,1,0,2,0,2,0,1,0,2,0,2,0,33,0,42,0,0,1,2,1,1,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,21,0,43,2,2,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,2,22,0,42,0,0,1,2,1,1,0,1,0,2,0,1,0,2,0,1,0,2,0,1,1,1,0,1,0,0,1,2,0,5,0,5,0,4,0,43,1,0,0,1,0,1,1,1,0,2,0,1,0,2,0,1,0,2,0,1,0,1,1,2,1,0,0,5,0,5,0,5,0,0,0,24,0,0,0,0,1,1,0,2,0,2,0,2,0,2,0,13,0,43,2,2,0,2,0,1,0,6,2,6,0,1,0,2,0,2,2,22,0,16,0,2,0,1,2,1,0,2,0,2,0,2,0,2,0,2,1,12,0,42,0,2,0,1,0,2,0,1,0,2,0,
1,0,2,0,1,0,2,0,1,0,2,0,2,3,21,0,29,0,2,1,2,0,0,0,0,0,1,0,0,0,1,0,0,0,2,0,3,0,16,0,53,0,2,0,2,1,2,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,2,0,2,0,3,0,2,0,28,0,42,0,2,0,2,0,0,0,3,0,0,0,4,0,4,0,0,0,3,0,0,0,2,0,2,0,21,0,42,0,2,0,1,0,2,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,5,0,5,0,5,0,3,1,3,0,42,4,4,0,5,0,4,0,4,0,5,0,4,4,21,0,13,0,1,0,2,0,2,0,2,0,2,0,1,0,3,0,2,0,2,0,2,0,2,0,3,0,0,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,3,0,12,0,3,0,2,0,2,0,2,0,2,0,3,0,1,0,2,0,2,0,2,0,2,0,1,0,1,0,56,2,1,0,0,0,1,3,56,0,29,2,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,2,36,0,23,3,1,0,4,0,4,6,0,0,4,6,0,0,5,0,6,0,6,3,20,0,15,0,36,0,1,0,1,0,3,0,24,2,3,0,5,0,3,3,3,0,5,0,5,0,5,0,5,0,4,0,5,0,5,0,3,2,3,0,47,0,0,0,0,0,0,0,0,0,0,0,4,0,128,0,156,0,2,0,2,0,41,0,23,0,5,0,5,0,2,6,2,0,5,0,5,0,5,0,5,0,5,0,5,0,5,0,9,0,23,0,5,0,2,6,2,0,5,0,5,0,5,0,5,0,5,0,2,6,2,0,5,0,9,0,16,1,1,0,1,0,54,0,42,1,2,0,6,0,1,0,0,0,7,0,1,0,0,0,7,0,1,0,0,0,8,1,0,0,12,0,0,1,2,1,3,0,0,0,1,0,0,0,1,0,2,0,0,0,1,0,0,0,1,0,2,0,0,
0,1,0,0,0,1,0,1,0,2,1,2,1,42,0,2,0,1,0,5,1,13,4,2,0,4,0,1,0,4,0,1,0,8,2,8,1,8,0,1,0,4,0,1,0,4,0,2,4,28,0,30,0,1,0,1,0,2,0,3,0,3,0,11,0,41,2,0,4,2,0,2,1,5,0,4,0,5,0,4,0,5,0,4,4,1,0,4,0,5,0,4,0,5,0,4,0,6,0,2,1,7,2,0,4,39,0,15,0,1,0,1,0,3,1,9,5,4,0,4,0,5,0,4,0,5,0,4,0,5,0,4,0,4,6,20,0,15,0,15,0,9,0,1,0,1,0,30,0,9,0,1,0,1,0,30,0,11,0,0,0,0,0,0,0,0,0,0,0,40,0,12,0,0,0,0,0,0,0,0,0,0,0,39,0,35,2,1,2,1,2,30,0,62,6,41,0,116,12,77,0,12,0,0,1,0,0,44,0,39,4,0,0,2,0,3,0,2,1,0,1,3,0,2,1,0,1,3,0,2,1,0,1,3,0,2,0,0,0,0,0,104,0,22,0,1,0,3,1,10,2,2,0,2,0,1,0,6,2,6,0,1,0,2,0,2,2,22,0,27,0,3,0,3,0,2,0,1,0,1,0,14,0,73,2,0,3,2,0,2,0,3,0,1,0,2,0,3,0,1,0,2,5,1,0,2,0,6,0,2,0,3,0,2,2,0,3,37,0,15,0,22,0,1,0,3,1,9,4,4,0,5,0,4,0,4,0,5,0,4,4,21,0,11,0,0,0,12,0,4,0,2,0,2,0,3,0,2,0,4,0,0,0,5,0,0,0,6,0,7,0,7,0,7,0,7,0,30,0,63,0,18,0,4,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,0,0,24,0,5,0,5,0,3,2,2,0,0,0,0,0,0,0,1,0,2,0,0,0,3,0,0,0,1,0,0,2,0,0,2,2,3,0,5,0,5,0,4,0,22,2,2,0,2,0,1,0,5,0,4,4,3,0,5,0,4,0,5,2,2,0,2,1,21,0,42,0,0,0,0,0,2,0,0,0,2,0,
2,0,2,0,0,0,2,0,0,0,0,0,35,0,20,0,4,0,0,0,2,0,1,0,2,0,2,0,0,0,3,0,0,0,1,6,2,0,2,6,2,0,5,0,23,0,9,0,1,0,1,0,1,0,1,0,7,0,1,0,1,0,1,0,1,0,3,0,23,1,3,0,1,0,2,0,5,1,3,0,1,1,1,0,2,1,0,1,2,0,1,1,0,1,3,0,6,0,1,0,2,0,2,2,8,0,11,0,0,0,48,0,31,5,2,0,5,0,0,0,1,3,1,1,0,0,3,0,0,1,0,0,5,1,0,0,5,1,0,0,3,0,0,1,1,3,1,0,0,0,5,0,2,5,31,0,12,3,1,0,0,3,1,4,31,0,51,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,21,0,47,6,6,0,6,0,6,0,48,0,35,2,24,0,31,5,2,0,5,0,0,0,1,3,1,1,1,0,2,0,0,1,1,0,2,0,0,1,1,3,1,1,1,0,1,0,1,1,1,0,2,0,0,0,0,0,5,0,2,5,31,0,13,6,90,0,16,1,1,0,1,0,0,0,1,0,1,1,45,0,37,0,5,0,5,0,2,6,2,0,5,0,5,0,2,6,20,0,12,3,1,0,1,0,1,0,1,3,31,0,12,3,1,0,1,0,0,0,1,0,0,2,31,0,13,0,1,0,45,0,42,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,4,1,0,5,0,5,0,4,0,21,9,0,0,0,3,0,0,0,3,0,0,1,2,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,7,0,33,0,28,0,53,0,3,0,0,2,0,13,0,1,1,2,0,2,0,2,0,32,0,15,2,0,0,2,1,2,1,2,0,0,2,40,0,49,0,0,0,4,0,0,0,4,0,0,0,3,0,0,0,2,0,0,0,2,0,0,0,23,0,34,0,4,0,2,1,4,0,3,0,3,0,4,0,2,0,5,0,2,
0,8,0,2,0,4,0,2,1,3,0,2,0,0,0,3,0,2,3,1,0,5,0,33,0,34,0,4,0,2,1,3,0,4,0,3,0,4,0,2,0,5,0,1,0,9,0,1,1,4,0,1,0,1,0,2,0,4,0,3,0,3,0,3,0,3,3,32,0,33,2,3,0,1,0,1,0,3,0,3,0,3,0,2,0,1,0,1,0,4,2,1,0,8,0,2,0,4,0,2,1,3,0,2,0,0,0,3,0,2,3,1,0,5,0,33,0,50,0,14,0,6,0,6,0,5,0,5,0,6,0,3,0,1,0,3,0,2,3,1,0,2,0,8,0,16,0,6,0,0,0,5,0,0,0,5,0,0,0,4,0,2,0,3,0,2,0,2,6,1,0,4,0,0,0,6,1,6,0,26,0,4,0,6,0,16,0,6,0,0,0,5,0,0,0,5,0,0,0,4,0,2,0,3,0,2,0,2,6,1,0,4,0,0,0,6,1,6,0,26,0,3,1,5,0,1,0,14,0,6,0,0,0,5,0,0,0,5,0,0,0,4,0,2,0,3,0,2,0,2,6,1,0,4,0,0,0,6,1,6,0,26,0,3,0,0,0,4,0,0,0,15,0,6,0,0,0,5,0,0,0,5,0,0,0,4,0,2,0,3,0,2,0,2,6,1,0,4,0,0,0,6,1,6,0,26,0,11,0,0,0,15,0,6,0,0,0,5,0,0,0,5,0,0,0,4,0,2,0,3,0,2,0,2,6,1,0,4,0,0,0,6,1,6,0,26,0,11,2,5,0,0,0,5,2,5,0,0,0,5,0,0,0,5,0,0,0,4,0,2,0,3,0,2,0,2,6,1,0,4,0,0,0,6,1,6,0,26,0,42,7,3,0,1,0,8,0,1,0,8,0,1,0,7,0,2,5,2,0,2,0,6,5,6,0,3,0,5,0,4,0,5,0,4,5,39,0,29,2,4,0,2,0,2,0,4,0,1,0,7,0,7,0,7,0,7,0,4,0,2,0,2,0,4,2,6,0,8,0,5,2,2,0,2,0,8,0,13,6,1,0,7,0,7,0,7,6,1,0,7,0,7,0,7,0,7,6,27,0,4,0,6,0,
13,6,1,0,7,0,7,0,7,6,1,0,7,0,7,0,7,0,7,6,27,0,3,1,5,0,1,0,11,6,1,0,7,0,7,0,7,6,1,0,7,0,7,0,7,0,7,6,27,0,11,0,0,0,12,6,1,0,7,0,7,0,7,6,1,0,7,0,7,0,7,0,7,6,27,1,0,2,0,4,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,1,0,0,0,4,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,0,2,5,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,2,0,0,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,27,4,3,0,3,0,2,0,4,0,1,0,4,0,0,4,1,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,3,0,2,4,29,0,3,0,0,0,4,0,0,0,12,0,4,0,1,1,3,0,1,0,0,0,2,0,1,0,0,0,2,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,2,0,0,0,1,0,2,0,0,0,1,0,3,1,1,0,4,0,27,0,3,0,9,0,16,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,32,0,4,0,7,0,17,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,32,0,3,1,6,0,1,0,15,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,32,0,3,0,0,0,5,0,0,0,16,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,32,0,13,0,0,0,15,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,32,0,48,
0,2,0,3,2,5,0,5,2,3,0,2,0,41,0,32,3,0,0,2,0,3,0,2,0,3,0,0,0,1,0,3,0,0,0,1,0,2,0,1,0,1,0,1,0,2,0,1,0,1,0,2,0,1,0,0,0,3,0,2,0,3,0,2,0,0,3,32,0,2,0,8,0,13,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,29,0,4,0,6,0,13,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,29,0,3,1,5,0,1,0,11,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,29,0,11,0,0,0,12,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,29,0,4,0,6,0,13,0,4,0,2,0,2,0,3,0,2,0,4,0,0,0,5,0,0,0,6,0,7,0,7,0,7,0,7,0,30,0,27,0,7,0,7,5,2,0,3,1,1,0,4,0,1,0,4,0,1,0,3,1,1,5,2,0,7,0,33,0,29,2,4,0,2,0,2,0,3,0,2,0,2,0,3,0,2,0,3,0,2,0,3,0,3,0,2,0,4,0,1,0,0,0,2,0,1,0,1,2,28,0,23,0,6,0,10,2,2,0,2,0,5,0,2,3,1,0,2,0,1,0,1,1,2,1,0,0,21,0,24,0,4,0,11,2,2,0,2,0,5,0,2,3,1,0,2,0,1,0,1,1,2,1,0,0,21,0,23,1,3,0,1,0,9,2,2,0,2,0,5,0,2,3,1,0,2,0,1,0,1,1,2,1,0,0,21,0,23,0,0,0,2,0,0,0,10,2,2,0,2,0,5,0,2,3,1,0,2,0,1,0,1,1,2,1,0,0,21,0,29,0,0,0,10,2,2,0,2,0,5,0,2,3,1,0,2,
0,1,0,1,1,2,1,0,0,21,0,15,2,3,0,0,0,3,2,10,2,2,0,2,0,5,0,2,3,1,0,2,0,1,0,1,1,2,1,0,0,21,0,73,3,0,2,2,0,2,1,2,0,3,2,3,0,2,0,1,5,1,0,2,0,6,0,2,1,2,0,2,2,1,2,37,0,43,2,2,0,2,0,1,0,5,0,5,0,5,0,2,0,2,2,4,0,6,0,3,2,1,0,22,0,6,0,11,2,2,0,2,0,1,0,2,0,1,4,1,0,5,0,2,0,2,2,22,0,24,0,4,0,11,2,2,0,2,0,1,0,2,0,1,4,1,0,5,0,2,0,2,2,22,0,23,1,3,0,1,0,9,2,2,0,2,0,1,0,2,0,1,4,1,0,5,0,2,0,2,2,22,0,29,0,0,0,10,2,2,0,2,0,1,0,2,0,1,4,1,0,5,0,2,0,2,2,22,0,8,0,2,0,4,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,10,0,0,0,4,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,9,2,5,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,11,0,0,0,3,0,1,0,1,0,1,0,1,0,1,0,1,0,9,0,22,0,0,0,3,1,3,0,1,0,3,2,2,0,1,1,0,0,3,0,0,0,3,0,0,0,3,0,1,0,1,0,3,1,23,0,23,0,0,0,2,0,0,0,9,0,0,1,2,1,1,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,21,0,22,0,6,0,11,2,2,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,2,22,0,24,0,4,0,11,2,2,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,2,22,0,23,1,3,0,1,0,9,2,2,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,2,22,0,23,0,0,0,2,0,0,0,10,2,2,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,2,22,0,29,
0,0,0,10,2,2,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,2,22,0,44,0,9,6,9,0,37,0,43,1,0,0,1,0,1,0,2,0,1,1,1,0,0,0,0,0,1,1,1,0,2,0,1,0,1,0,0,1,22,0,22,0,6,0,10,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,3,21,0,24,0,4,0,10,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,3,21,0,23,1,3,0,1,0,8,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,3,21,0,29,0,0,0,9,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,1,0,2,0,2,3,21,0,24,0,4,0,10,0,2,0,1,0,2,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,5,0,5,0,5,0,3,1,3,0,21,0,5,0,5,0,5,2,3,0,1,0,2,0,2,0,1,0,2,0,1,0,2,0,1,0,1,0,2,2,3,0,5,0,5,0,4,0,29,0,0,0,9,0,2,0,1,0,2,0,2,0,0,0,3,0,0,0,3,0,0,0,4,0,5,0,5,0,5,0,3,1,3,0,0,0);

{
sysfont__arial_10:array[0..9778] of byte=(
71,70,35,51,19,0,15,0,13,0,8,6,0,0,13,0,12,6,0,0,13,0,16,6,0,0,13,0,34,6,0,0,13,0,50,6,0,0,13,0,66,6,0,0,13,0,96,6,0,0,13,0,100,6,0,0,13,0,112,6,0,0,13,0,152,6,0,0,13,0,156,6,0,0,13,0,160,6,0,0,13,0,190,6,0,0,13,0,232,6,0,0,13,0,236,6,0,0,13,0,18,7,0,0,13,0,64,7,0,0,13,0,94,7,0,0,13,0,118,7,0,0,13,0,154,7,0,0,13,0,196,7,0,0,13,0,0,8,0,0,13,0,16,8,0,0,13,0,34,8,0,0,13,0,64,8,0,0,13,0,94,8,0,0,13,0,124,8,0,0,13,0,136,8,0,0,13,0,148,8,0,0,13,0,152,8,0,0,13,0,156,8,0,0,13,0,160,8,0,0,5,0,164,8,0,0,5,0,166,8,0,0,6,0,190,8,0,0,9,0,208,8,0,0,9,0,254,8,0,0,15,0,56,9,0,0,11,0,130,9,0,0,3,0,180,9,0,0,6,0,190,9,0,0,6,0,222,9,0,0,7,0,254,9,0,0,10,0,14,10,0,0,5,0,30,10,0,0,6,0,38,10,0,0,5,0,42,10,0,0,5,0,46,10,0,0,9,0,72,10,0,0,9,0,118,10,0,0,9,0,148,10,0,0,9,0,178,10,0,0,9,0,212,10,0,0,9,0,250,10,0,0,9,0,26,11,0,0,9,0,70,11,0,0,9,0,96,11,0,0,9,0,140,11,0,0,5,0,184,11,0,0,5,0,190,11,0,0,10,0,200,11,0,0,10,0,220,11,0,0,10,0,226,11,0,0,9,0,246,11,0,0,17,0,20,12,0,0,11,0,116,12,0,0,11,0,160,12,0,0,12,0,204,12,0,
0,12,0,238,12,0,0,11,0,28,13,0,0,10,0,54,13,0,0,12,0,80,13,0,0,11,0,120,13,0,0,5,0,168,13,0,0,9,0,194,13,0,0,11,0,226,13,0,0,9,0,22,14,0,0,13,0,48,14,0,0,11,0,130,14,0,0,12,0,196,14,0,0,11,0,242,14,0,0,12,0,22,15,0,0,11,0,72,15,0,0,11,0,118,15,0,0,9,0,154,15,0,0,11,0,180,15,0,0,11,0,228,15,0,0,17,0,18,16,0,0,11,0,106,16,0,0,11,0,154,16,0,0,9,0,192,16,0,0,5,0,218,16,0,0,5,0,250,16,0,0,5,0,20,17,0,0,7,0,52,17,0,0,9,0,80,17,0,0,6,0,86,17,0,0,9,0,92,17,0,0,9,0,126,17,0,0,9,0,170,17,0,0,9,0,198,17,0,0,9,0,242,17,0,0,5,0,16,18,0,0,9,0,42,18,0,0,9,0,88,18,0,0,4,0,132,18,0,0,4,0,154,18,0,0,8,0,182,18,0,0,3,0,226,18,0,0,13,0,252,18,0,0,9,0,52,19,0,0,9,0,90,19,0,0,9,0,124,19,0,0,9,0,168,19,0,0,6,0,212,19,0,0,8,0,234,19,0,0,4,0,2,20,0,0,9,0,28,20,0,0,7,0,66,20,0,0,11,0,98,20,0,0,7,0,158,20,0,0,9,0,194,20,0,0,8,0,236,20,0,0,6,0,0,21,0,0,5,0,32,21,0,0,6,0,66,21,0,0,10,0,98,21,0,0,13,0,108,21,0,0,9,0,142,21,0,0,1,0,172,21,0,0,4,0,174,21,0,0,9,0,182,21,0,0,6,0,214,21,0,0,17,0,228,21,0,0,9,0,238,21,0,0,9,0,14,22,
0,0,6,0,46,22,0,0,17,0,54,22,0,0,11,0,140,22,0,0,6,0,182,22,0,0,17,0,200,22,0,0,1,0,252,22,0,0,9,0,254,22,0,0,1,0,30,23,0,0,1,0,32,23,0,0,4,0,34,23,0,0,4,0,42,23,0,0,6,0,50,23,0,0,6,0,64,23,0,0,6,0,78,23,0,0,9,0,88,23,0,0,17,0,92,23,0,0,4,0,100,23,0,0,17,0,108,23,0,0,8,0,168,23,0,0,6,0,198,23,0,0,16,0,216,23,0,0,1,0,10,24,0,0,8,0,12,24,0,0,11,0,38,24,0,0,5,0,80,24,0,0,5,0,82,24,0,0,9,0,106,24,0,0,9,0,156,24,0,0,9,0,190,24,0,0,9,0,224,24,0,0,5,0,6,25,0,0,9,0,34,25,0,0,6,0,84,25,0,0,13,0,90,25,0,0,5,0,144,25,0,0,9,0,160,25,0,0,10,0,194,25,0,0,6,0,206,25,0,0,13,0,210,25,0,0,10,0,14,26,0,0,7,0,20,26,0,0,9,0,38,26,0,0,6,0,56,26,0,0,6,0,72,26,0,0,6,0,90,26,0,0,9,0,96,26,0,0,9,0,142,26,0,0,6,0,206,26,0,0,6,0,210,26,0,0,6,0,220,26,0,0,5,0,236,26,0,0,9,0,252,26,0,0,14,0,30,27,0,0,14,0,86,27,0,0,14,0,140,27,0,0,10,0,198,27,0,0,11,0,228,27,0,0,11,0,20,28,0,0,11,0,68,28,0,0,11,0,118,28,0,0,11,0,170,28,0,0,11,0,218,28,0,0,17,0,12,29,0,0,12,0,58,29,0,0,11,0,100,29,0,0,11,0,130,29,0,0,11,0,160,29,0,0,11,0,192,
29,0,0,5,0,222,29,0,0,5,0,252,29,0,0,5,0,26,30,0,0,5,0,58,30,0,0,12,0,88,30,0,0,11,0,134,30,0,0,12,0,208,30,0,0,12,0,2,31,0,0,12,0,52,31,0,0,12,0,104,31,0,0,12,0,158,31,0,0,10,0,208,31,0,0,13,0,232,31,0,0,11,0,38,32,0,0,11,0,90,32,0,0,11,0,142,32,0,0,11,0,196,32,0,0,11,0,248,32,0,0,11,0,34,33,0,0,10,0,72,33,0,0,9,0,122,33,0,0,9,0,160,33,0,0,9,0,198,33,0,0,9,0,238,33,0,0,9,0,24,34,0,0,9,0,62,34,0,0,15,0,104,34,0,0,9,0,150,34,0,0,9,0,186,34,0,0,9,0,220,34,0,0,9,0,254,34,0,0,9,0,34,35,0,0,5,0,68,35,0,0,5,0,92,35,0,0,5,0,116,35,0,0,5,0,142,35,0,0,9,0,166,35,0,0,9,0,210,35,0,0,9,0,0,36,0,0,9,0,38,36,0,0,9,0,76,36,0,0,9,0,116,36,0,0,9,0,158,36,0,0,9,0,196,36,0,0,9,0,204,36,0,0,9,0,248,36,0,0,9,0,34,37,0,0,9,0,76,37,0,0,9,0,120,37,0,0,9,0,162,37,0,0,9,0,208,37,0,0,9,0,2,38,0,0,0,128,0,246,0,128,0,246,0,116,3,11,0,11,0,11,0,11,0,11,0,11,0,11,0,34,0,41,0,11,0,11,0,11,0,11,0,11,0,11,3,122,0,41,0,11,0,11,0,11,0,11,0,11,0,8,3,125,0,41,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,34,0,116,
6,122,0,92,2,8,4,7,4,7,4,8,2,98,0,38,6,5,6,5,6,5,6,5,1,2,1,5,0,4,0,5,0,4,0,5,0,4,0,5,1,2,1,5,6,5,6,5,6,5,6,5,6,31,0,128,0,246,0,128,0,246,0,67,3,10,1,9,0,0,0,9,0,0,0,8,0,11,0,10,1,9,0,1,0,8,0,1,0,9,1,60,0,53,8,3,0,6,0,3,0,6,0,3,0,6,0,3,0,6,0,3,0,6,0,3,0,6,0,3,0,6,0,3,0,6,0,3,0,6,0,3,8,53,0,128,0,246,0,69,1,7,2,0,0,7,0,1,1,7,2,0,0,7,0,2,0,7,0,2,0,7,0,2,0,7,0,1,1,6,1,1,1,6,1,61,0,65,0,0,0,0,0,7,0,0,0,0,0,8,0,0,0,9,0,0,0,8,1,0,1,8,0,0,0,9,0,0,0,8,0,0,0,0,0,7,0,0,0,0,0,71,0,41,0,11,0,11,0,11,0,11,0,11,0,8,6,8,0,11,0,11,0,11,0,11,0,11,0,11,0,34,0,57,0,10,1,9,2,8,3,7,4,6,5,7,4,8,3,9,2,10,1,11,0,57,0,41,0,10,2,8,0,0,0,0,0,9,0,11,0,11,0,11,0,11,0,11,0,11,0,9,0,0,0,0,0,8,2,10,0,47,0,53,0,1,0,8,0,1,0,8,0,1,0,8,0,1,0,8,0,1,0,8,0,1,0,8,0,1,0,8,0,1,0,34,0,1,0,8,0,1,0,45,0,53,1,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,7,0,0,0,0,0,8,1,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,0,0,0,45,0,41,0,11,0,11,0,11,0,11,0,11,0,8,6,122,0,116,6,8,0,11,0,11,0,11,0,11,0,11,0,11,0,34,0,41,0,11,0,11,0,11,0,11,0,11,0,8,3,
11,0,11,0,11,0,11,0,11,0,11,0,11,0,34,0,54,0,10,2,8,0,0,0,0,0,9,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,11,0,47,0,41,0,11,0,11,0,11,0,11,0,11,0,11,3,8,0,11,0,11,0,11,0,11,0,11,0,11,0,34,0,107,0,12,0,7,5,10,0,10,0,85,0,106,0,10,0,10,5,7,0,12,0,86,0,128,0,246,0,128,0,246,0,128,0,246,0,128,0,246,0,94,0,16,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,8,0,21,0,18,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,72,0,30,0,1,0,4,0,1,0,3,0,1,0,4,0,1,0,1,8,2,0,1,0,3,0,1,0,4,0,1,0,2,8,1,0,1,0,3,0,1,0,4,0,1,0,39,0,21,0,6,3,3,0,0,0,0,1,1,0,1,0,1,0,1,0,1,0,4,0,1,0,5,2,7,2,5,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,2,0,0,0,0,0,4,2,6,0,7,0,21,0,46,2,4,0,4,0,2,0,2,0,5,0,2,0,2,0,5,0,2,0,1,0,6,0,2,0,1,0,6,0,2,0,0,0,1,2,3,2,1,0,0,0,2,0,6,0,1,0,2,0,5,0,2,0,2,0,5,0,2,0,2,0,4,0,3,0,2,0,4,0,4,2,61,0,36,2,6,0,2,0,5,0,2,0,5,0,2,0,6,0,0,0,6,2,6,0,1,0,5,0,3,0,1,0,1,0,3,0,0,0,2,0,4,0,4,0,3,1,4,3,1,0,44,0,9,0,1,0,1,0,1,0,36,0,20,0,3,0,4,0,4,0,3,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,4,0,4,0,5,0,7,0,19,0,5,0,4,0,4,0,5,0,4,0,4,0,4,0,4,0,4,0,4,0,3,0,4,0,4,0,3,0,8,0,23,0,3,4,
3,0,4,0,0,0,3,0,0,0,78,0,53,0,8,0,8,0,5,6,5,0,8,0,8,0,74,0,71,0,3,0,3,0,11,0,59,4,48,0,71,0,21,0,18,0,2,0,3,0,3,0,2,0,3,0,3,0,2,0,3,0,3,0,2,0,3,0,23,0,29,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,31,0,6,1,5,0,0,0,4,0,1,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,38,0,29,3,3,0,2,0,2,0,4,0,7,0,7,0,6,0,7,0,6,0,6,0,6,0,6,0,6,6,36,0,29,2,4,0,2,0,2,0,3,0,7,0,6,0,5,2,8,0,8,0,7,0,1,0,4,0,1,1,2,0,4,2,38,0,31,0,6,1,5,0,0,0,5,0,0,0,4,0,1,0,4,0,1,0,3,0,2,0,2,0,3,0,2,7,5,0,7,0,7,0,38,0,28,5,2,0,7,0,6,0,7,4,3,0,3,0,8,0,7,0,7,0,1,0,4,0,2,0,2,0,4,2,38,0,29,2,4,0,2,1,1,0,4,0,1,0,7,0,0,2,3,1,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,27,6,6,0,7,0,6,0,7,0,6,0,7,0,7,0,7,0,6,0,7,0,7,0,40,0,29,2,4,0,2,0,2,0,4,0,1,0,4,0,2,0,2,0,4,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,29,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,1,3,2,0,0,7,0,1,0,4,0,2,0,2,0,3,3,38,0,31,0,38,0,21,0,31,0,38,0,3,0,3,0,11,0,47,0,6,1,5,1,5,1,6,0,9,1,9,1,9,1,9,0,60,0,70,7,31,7,70,0,40,0,9,1,
9,1,9,1,9,0,6,1,5,1,5,1,6,0,67,0,29,2,4,0,2,0,2,0,4,0,1,0,4,0,7,0,6,0,6,0,6,0,7,0,7,0,16,0,39,0,56,6,7,1,6,1,4,0,10,0,2,0,3,2,1,0,1,0,2,0,2,0,2,2,2,0,1,0,1,0,4,0,3,0,0,0,1,0,5,0,3,0,0,0,1,0,5,0,3,0,0,0,1,0,4,0,4,0,0,0,1,0,4,0,3,0,1,0,2,0,2,1,2,0,3,0,2,2,0,3,4,0,12,0,2,0,10,0,4,1,6,1,7,6,3,0,37,0,8,0,0,0,7,0,0,0,6,0,2,0,5,0,2,0,5,0,2,0,4,0,4,0,3,6,2,0,6,0,1,0,6,0,0,0,8,1,8,0,43,0,33,6,3,0,5,0,2,0,6,0,1,0,6,0,1,0,5,0,2,7,2,0,5,0,2,0,6,0,1,0,6,0,1,0,6,0,1,0,5,0,2,6,46,0,39,4,5,0,4,0,3,0,6,0,1,0,10,0,10,0,10,0,10,0,10,0,11,0,6,0,3,0,4,0,5,4,50,0,36,6,4,0,5,0,3,0,6,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,2,0,5,0,3,6,51,0,33,8,1,0,9,0,9,0,9,0,9,7,2,0,9,0,9,0,9,0,9,0,9,8,44,0,30,7,1,0,8,0,8,0,8,0,8,6,2,0,8,0,8,0,8,0,8,0,8,0,47,0,39,3,6,0,3,0,4,0,5,0,2,0,10,0,10,0,10,0,3,4,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,51,0,33,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,8,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,44,0,16,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,33,0,7,0,7,0,7,0,7,0,7,
0,7,0,7,0,1,0,4,0,1,0,4,0,2,0,2,0,3,3,38,0,33,0,6,0,1,0,5,0,2,0,4,0,3,0,3,0,4,0,2,0,5,0,1,1,5,0,0,0,1,0,4,1,3,0,3,0,4,0,3,0,5,0,2,0,5,0,2,0,6,0,44,0,27,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,6,36,0,39,0,8,0,1,1,6,1,1,1,6,1,1,0,0,0,4,0,0,0,1,0,0,0,4,0,0,0,1,0,1,0,2,0,1,0,1,0,1,0,2,0,1,0,1,0,1,0,1,0,2,0,1,0,2,0,0,0,2,0,1,0,2,0,0,0,2,0,1,0,3,0,3,0,1,0,3,0,3,0,52,0,33,0,6,0,1,1,5,0,1,0,0,0,4,0,1,0,0,0,4,0,1,0,1,0,3,0,1,0,2,0,2,0,1,0,2,0,2,0,1,0,3,0,1,0,1,0,4,0,0,0,1,0,4,0,0,0,1,0,5,1,1,0,6,0,44,0,39,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,51,0,33,6,3,0,5,0,2,0,6,0,1,0,6,0,1,0,6,0,1,0,5,0,2,6,3,0,9,0,9,0,9,0,9,0,52,0,39,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,2,1,0,1,3,0,3,1,5,3,0,1,48,0,33,6,3,0,5,0,2,0,6,0,1,0,6,0,1,0,6,0,1,0,5,0,2,6,3,0,3,0,4,0,4,0,3,0,4,0,3,0,5,0,2,0,6,0,44,0,35,4,4,0,4,0,2,0,6,0,1,0,10,0,10,2,10,2,10,0,1,0,6,0,1,0,6,0,2,0,4,0,4,4,46,0,26,8,3,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,39,0,33,0,6,0,1,
0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,2,0,4,0,4,4,46,0,33,0,6,0,1,0,6,0,2,0,4,0,3,0,4,0,3,0,4,0,4,0,2,0,5,0,2,0,5,0,2,0,6,0,0,0,7,0,0,0,8,0,9,0,48,0,50,0,6,0,6,0,0,0,4,0,0,0,4,0,1,0,4,0,0,0,4,0,1,0,4,0,0,0,4,0,2,0,2,0,2,0,2,0,3,0,2,0,2,0,2,0,3,0,2,0,2,0,2,0,4,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,5,0,0,0,4,0,0,0,6,0,6,0,7,0,6,0,71,0,33,0,6,0,2,0,4,0,4,0,2,0,5,0,2,0,6,0,0,0,8,0,8,0,0,0,6,0,2,0,5,0,2,0,4,0,4,0,2,0,6,0,0,0,8,0,43,0,33,0,6,0,2,0,4,0,3,0,4,0,4,0,2,0,6,0,0,0,7,0,0,0,8,0,9,0,9,0,9,0,9,0,9,0,48,0,27,7,6,0,6,0,7,0,6,0,6,0,7,0,6,0,6,0,7,0,6,0,6,8,35,0,15,2,1,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,2,5,0,14,0,4,0,3,0,3,0,4,0,3,0,3,0,4,0,3,0,3,0,4,0,3,0,19,0,15,2,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,1,2,5,0,23,0,4,0,0,0,3,0,0,0,2,0,2,0,1,0,2,0,1,0,2,0,0,0,4,0,62,0,128,0,152,8,8,0,18,0,5,0,86,0,56,3,3,0,3,0,1,0,4,0,5,2,2,2,1,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,27,0,7,0,7,0,7,0,0,2,3,1,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,1,2,0,2,
0,0,2,38,0,56,2,4,0,2,0,2,0,4,0,1,0,7,0,7,0,7,0,4,0,2,0,2,0,4,2,38,0,33,0,7,0,7,0,3,2,0,0,2,0,2,1,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,1,3,2,0,0,36,0,56,2,4,0,2,0,2,0,4,0,1,0,4,0,1,6,1,0,7,0,4,0,2,0,2,0,4,2,38,0,17,1,1,0,3,0,2,3,1,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,56,2,0,0,2,0,2,1,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,1,3,2,0,0,7,0,1,0,3,0,3,3,11,0,27,0,7,0,7,0,7,0,0,3,2,1,3,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,36,0,12,0,10,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,17,0,13,0,10,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,0,1,5,0,24,0,6,0,6,0,6,0,4,0,0,0,3,0,1,0,2,0,2,0,1,0,3,0,0,1,3,1,1,0,2,0,3,0,1,0,3,0,1,0,4,0,31,0,9,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,12,0,78,0,0,2,1,2,2,1,2,1,2,0,1,0,3,0,3,0,1,0,3,0,3,0,1,0,3,0,3,0,1,0,3,0,3,0,1,0,3,0,3,0,1,0,3,0,3,0,1,0,3,0,3,0,52,0,54,0,0,3,2,1,3,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,36,0,56,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,54,0,0,2,3,1,2,0,2,0,4,0,1,0,4,0,1,0,4,0,
1,0,4,0,1,0,4,0,1,1,2,0,2,0,0,2,3,0,7,0,7,0,15,0,56,2,0,0,2,0,2,1,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,1,3,2,0,0,7,0,7,0,7,0,9,0,36,0,0,2,0,1,3,0,4,0,4,0,4,0,4,0,4,0,4,0,27,0,49,3,2,0,3,0,1,0,6,0,7,3,7,0,6,0,1,0,3,0,2,3,33,0,12,0,2,0,2,0,1,3,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,2,15,0,54,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,41,0,4,1,4,0,0,0,2,0,1,0,2,0,1,0,2,0,2,0,0,0,3,0,0,0,4,0,5,0,30,0,65,0,3,0,3,1,3,0,3,0,0,0,1,0,0,0,1,0,1,0,1,0,0,0,1,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,1,0,0,0,2,0,0,0,2,0,4,0,3,0,4,0,45,0,41,0,4,0,0,0,2,0,2,0,0,0,3,0,0,0,4,0,4,0,0,0,3,0,0,0,2,0,2,0,0,0,4,0,27,0,54,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,3,0,2,0,3,0,1,1,4,0,0,0,5,0,0,0,6,0,7,0,6,0,5,1,14,0,47,6,5,0,5,0,6,0,5,0,5,0,6,0,5,0,5,6,32,0,21,1,2,0,4,0,4,0,4,0,4,0,4,0,2,1,5,0,4,0,4,0,4,0,4,0,4,0,5,1,5,0,16,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,1,0,17,1,5,0,4,0,4,0,4,0,4,0,4,0,5,1,2,0,4,0,4,0,4,0,4,0,4,0,2,1,9,0,80,3,2,0,0,0,2,3,91,0,64,2,9,0,0,0,9,0,0,0,9,0,0,0,9,0,
0,0,9,0,0,0,9,0,0,0,9,0,0,0,9,2,74,0,30,2,3,1,2,0,1,0,7,0,6,6,2,0,7,0,6,6,2,0,7,0,8,0,3,0,3,3,37,0,18,0,56,0,2,0,2,0,9,0,31,2,4,0,7,0,5,4,5,0,6,0,7,0,7,0,7,0,7,0,7,0,6,0,7,0,7,0,5,2,14,0,84,0,0,0,2,0,0,0,2,0,0,0,13,0,128,0,239,0,3,0,3,0,71,0,30,0,7,0,7,0,4,6,4,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,7,0,12,0,30,0,7,0,7,0,4,6,4,0,7,0,7,0,7,0,7,0,7,0,7,0,4,6,4,0,7,0,7,0,12,0,19,1,2,0,1,0,84,0,51,2,2,0,8,0,2,0,1,0,8,0,2,0,0,0,9,0,2,0,0,0,9,0,2,0,0,0,10,2,0,0,15,0,0,2,2,2,4,0,0,0,2,0,0,0,2,0,3,0,0,0,2,0,0,0,2,0,2,0,1,0,2,0,0,0,2,0,2,0,1,0,2,0,0,0,2,0,2,0,2,2,2,2,68,0,3,0,1,0,7,1,17,4,4,0,4,0,2,0,6,0,1,0,10,0,10,2,10,2,10,0,1,0,6,0,1,0,6,0,2,0,4,0,4,4,46,0,38,0,3,0,4,0,3,0,4,0,5,0,4,0,5,0,31,0,54,3,1,5,2,1,3,2,7,0,5,1,6,0,7,0,6,0,7,0,6,0,7,5,1,0,7,0,6,0,7,0,6,0,7,0,7,0,5,1,8,0,3,0,0,0,9,3,1,5,68,0,18,0,2,0,1,0,5,1,12,7,6,0,6,0,7,0,6,0,6,0,7,0,6,0,6,0,7,0,6,0,6,8,35,0,18,0,18,0,12,0,2,0,2,0,53,0,12,0,2,0,2,0,53,0,18,0,0,0,2,0,0,0,2,0,0,0,79,0,18,0,0,0,2,0,0,0,2,0,0,0,79,0,43,1,2,3,1,3,2,1,49,0,89,8,71,0,
128,0,169,16,128,0,135,0,12,0,0,1,0,0,56,0,52,4,0,1,2,1,5,0,2,1,2,1,5,0,2,2,0,2,5,0,2,0,0,0,0,0,0,0,5,0,2,0,0,0,0,0,0,0,5,0,2,0,0,0,0,0,0,0,5,0,2,0,1,0,1,0,128,0,154,0,25,0,1,0,4,1,12,3,2,0,3,0,1,0,6,0,7,3,7,0,6,0,1,0,3,0,2,3,33,0,37,0,5,0,4,0,5,0,4,0,3,0,4,0,3,0,32,0,98,2,2,3,4,0,2,0,0,0,3,0,2,0,4,0,5,0,1,0,4,0,5,0,1,0,4,7,1,0,4,0,8,0,4,0,5,0,2,0,2,2,3,0,4,2,2,3,66,0,18,0,25,0,1,0,4,1,10,6,5,0,5,0,6,0,5,0,5,0,6,0,5,0,5,6,32,0,14,0,0,0,15,0,6,0,2,0,4,0,3,0,4,0,4,0,2,0,6,0,0,0,7,0,0,0,8,0,9,0,9,0,9,0,9,0,9,0,48,0,94,0,31,0,8,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,6,0,32,0,7,0,7,0,4,3,3,0,1,2,1,0,2,0,0,0,1,0,1,0,4,0,1,0,4,0,1,0,4,0,0,0,2,0,2,1,1,0,3,3,5,0,6,0,7,0,14,0,28,3,3,1,2,0,2,0,4,0,1,0,7,0,6,4,5,0,7,0,7,0,6,0,6,3,2,0,0,0,2,2,37,0,54,0,0,2,0,0,2,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,2,0,0,2,0,0,54,0,26,0,6,0,0,0,4,0,2,0,2,0,3,0,2,0,4,0,0,0,5,0,0,0,2,8,3,0,3,8,3,0,7,0,7,0,39,0,16,0,3,0,3,0,3,0,3,0,3,0,18,0,3,0,3,0,3,0,3,0,3,0,3,0,1,0,28,3,3,0,3,0,2,0,3,0,2,1,7,1,5,0,1,1,2,0,4,0,1,0,5,0,1,0,4,0,
2,1,1,0,5,1,7,1,1,0,4,0,2,0,3,0,3,3,11,0,19,0,0,0,90,0,41,6,4,0,6,0,2,0,1,4,1,0,0,0,1,0,4,0,1,1,1,0,7,1,1,0,7,1,1,0,7,1,1,0,4,0,1,1,2,4,2,0,0,0,8,0,2,0,6,0,4,6,54,0,15,2,0,0,2,0,1,4,1,1,2,0,0,3,49,0,56,0,1,0,3,0,1,0,4,0,1,0,3,0,1,0,4,0,1,0,5,0,1,0,4,0,1,0,5,0,1,0,46,0,60,7,8,0,8,0,8,0,8,0,80,0,59,4,48,0,41,6,4,0,6,0,2,0,1,4,1,0,0,0,2,0,3,0,1,1,2,0,3,0,1,1,2,4,2,1,2,0,1,0,3,1,2,0,2,0,2,1,2,0,3,0,1,0,0,0,8,0,2,0,6,0,4,6,54,0,9,9,128,0,169,0,22,2,2,0,2,0,1,0,2,0,1,0,2,0,2,2,78,0,48,0,7,0,7,0,4,6,4,0,7,0,7,0,22,6,36,0,18,2,1,0,2,0,4,0,2,1,2,0,3,4,60,0,18,3,0,0,2,0,2,1,5,0,0,0,2,0,1,2,61,0,20,0,3,0,86,0,54,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,1,2,1,1,0,0,2,0,0,1,0,7,0,7,0,15,0,28,6,0,3,1,0,0,4,1,0,0,4,1,0,0,4,1,0,1,3,1,0,2,2,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,0,0,55,0,56,0,91,0,4,1,4,0,2,1,2,0,20,0,3,1,2,0,0,0,4,0,4,0,4,0,61,0,15,2,0,0,2,1,2,1,2,1,2,0,0,2,50,0,55,0,1,0,5,0,1,0,4,0,1,0,5,0,1,0,4,0,1,0,3,0,1,0,4,0,1,0,3,0,1,0,47,0,44,0,6,0,3,1,
5,0,3,0,0,0,4,0,6,0,4,0,6,0,3,0,7,0,2,0,11,0,4,0,6,0,3,1,5,0,3,0,0,0,4,0,3,0,1,0,3,0,4,4,2,0,7,0,56,0,44,0,5,0,4,1,5,0,3,0,0,0,4,0,6,0,3,0,7,0,2,0,8,0,2,0,11,0,2,2,5,0,2,0,2,0,3,0,7,0,3,0,5,1,3,0,5,0,4,0,5,4,55,0,42,3,5,0,1,0,2,0,4,0,5,0,4,0,7,0,2,0,4,0,2,0,2,0,5,2,2,0,11,0,4,0,5,0,4,1,5,0,3,0,0,0,4,0,3,0,1,0,3,0,4,4,1,0,8,0,56,0,63,0,18,0,8,0,8,0,7,0,7,0,7,0,8,0,5,0,1,0,5,0,2,0,3,0,4,3,12,0,3,0,10,0,20,0,8,0,0,0,7,0,0,0,6,0,2,0,5,0,2,0,5,0,2,0,4,0,4,0,3,6,2,0,6,0,1,0,6,0,0,0,8,1,8,0,43,0,5,0,8,0,20,0,8,0,0,0,7,0,0,0,6,0,2,0,5,0,2,0,5,0,2,0,4,0,4,0,3,6,2,0,6,0,1,0,6,0,0,0,8,1,8,0,43,0,4,1,7,0,1,0,18,0,8,0,0,0,7,0,0,0,6,0,2,0,5,0,2,0,5,0,2,0,4,0,4,0,3,6,2,0,6,0,1,0,6,0,0,0,8,1,8,0,43,0,4,0,0,0,6,0,0,0,19,0,8,0,0,0,7,0,0,0,6,0,2,0,5,0,2,0,5,0,2,0,4,0,4,0,3,6,2,0,6,0,1,0,6,0,0,0,8,1,8,0,43,0,14,0,0,0,19,0,8,0,0,0,7,0,0,0,6,0,2,0,5,0,2,0,5,0,2,0,4,0,4,0,3,6,2,0,6,0,1,0,6,0,0,0,8,1,8,0,43,0,14,2,7,0,0,0,7,2,7,0,0,0,7,0,0,0,6,0,2,0,5,0,2,0,5,0,2,0,4,0,4,0,3,6,2,0,6,0,1,0,6,0,0,0,8,1,8,0,43,0,55,10,5,0,
1,0,11,0,2,0,11,0,2,0,10,0,3,0,10,0,3,7,2,0,4,0,9,6,8,0,5,0,8,0,5,0,7,0,6,0,7,0,6,7,68,0,39,4,5,0,4,0,3,0,6,0,1,0,10,0,10,0,10,0,10,0,10,0,11,0,6,0,3,0,4,0,5,4,8,0,10,1,10,0,8,1,4,0,4,0,10,0,15,8,1,0,9,0,9,0,9,0,9,7,2,0,9,0,9,0,9,0,9,0,9,8,44,0,5,0,8,0,16,8,1,0,9,0,9,0,9,0,9,7,2,0,9,0,9,0,9,0,9,0,9,8,44,0,4,1,7,0,1,0,14,8,1,0,9,0,9,0,9,0,9,7,2,0,9,0,9,0,9,0,9,0,9,8,44,0,14,0,0,0,15,8,1,0,9,0,9,0,9,0,9,7,2,0,9,0,9,0,9,0,9,0,9,8,44,0,0,0,4,0,8,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,2,0,2,0,8,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,1,1,1,0,1,0,6,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,5,0,0,0,7,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,36,6,4,0,5,0,3,0,6,0,2,0,7,0,1,0,7,0,0,5,3,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,6,0,2,0,5,0,3,6,51,0,4,0,0,0,6,0,0,0,15,0,6,0,1,1,5,0,1,0,0,0,4,0,1,0,0,0,4,0,1,0,1,0,3,0,1,0,2,0,2,0,1,0,2,0,2,0,1,0,3,0,1,0,1,0,4,0,0,0,1,0,4,0,0,0,1,0,5,1,1,0,6,0,44,0,4,0,11,0,20,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,
5,0,4,0,3,0,6,3,51,0,5,0,9,0,21,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,51,0,4,1,8,0,1,0,19,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,51,0,4,0,0,0,7,0,0,0,20,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,51,0,16,0,0,0,19,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,51,0,60,0,4,0,3,0,2,0,5,2,7,0,7,2,5,0,2,0,3,0,4,0,61,0,42,4,1,0,3,0,4,1,3,0,5,1,2,0,5,0,1,0,1,0,4,0,2,0,1,0,3,0,3,0,1,0,2,0,4,0,1,0,2,0,4,0,1,0,1,0,4,0,3,1,5,0,3,1,4,0,3,0,1,4,55,0,3,0,10,0,16,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,2,0,4,0,4,4,46,0,5,0,8,0,16,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,2,0,4,0,4,4,46,0,4,1,7,0,1,0,14,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,2,0,4,0,4,4,46,0,14,0,0,0,15,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,
6,0,1,0,6,0,1,0,6,0,2,0,4,0,4,4,46,0,5,0,8,0,16,0,6,0,2,0,4,0,3,0,4,0,4,0,2,0,6,0,0,0,7,0,0,0,8,0,9,0,9,0,9,0,9,0,9,0,48,0,33,0,9,0,9,6,3,0,5,0,2,0,6,0,1,0,6,0,1,0,6,0,1,0,6,0,1,0,5,0,2,6,3,0,9,0,52,0,32,2,5,0,2,0,3,0,3,0,3,0,3,0,3,0,2,0,4,0,2,0,4,0,3,0,3,0,4,0,2,0,5,0,1,0,5,0,1,0,1,0,2,0,1,0,2,2,41,0,30,0,8,0,14,3,3,0,3,0,1,0,4,0,5,2,2,2,1,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,31,0,6,0,15,3,3,0,3,0,1,0,4,0,5,2,2,2,1,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,30,1,5,0,1,0,13,3,3,0,3,0,1,0,4,0,5,2,2,2,1,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,30,0,0,0,4,0,0,0,14,3,3,0,3,0,1,0,4,0,5,2,2,2,1,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,38,0,0,0,14,3,3,0,3,0,1,0,4,0,5,2,2,2,1,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,20,2,5,0,0,0,5,2,14,3,3,0,3,0,1,0,4,0,5,2,2,2,1,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,92,3,0,3,4,0,3,1,2,0,2,0,4,0,4,0,5,2,4,0,2,2,1,6,1,0,4,0,7,0,4,0,4,0,1,0,3,2,2,0,3,3,1,3,62,0,56,2,4,0,2,0,2,0,4,0,1,0,7,0,7,0,7,0,4,0,2,0,2,0,4,2,6,0,7,1,7,0,5,1,3,0,30,0,8,0,14,2,4,0,2,0,2,0,4,0,1,0,4,0,1,6,1,0,
7,0,4,0,2,0,2,0,4,2,38,0,31,0,6,0,15,2,4,0,2,0,2,0,4,0,1,0,4,0,1,6,1,0,7,0,4,0,2,0,2,0,4,2,38,0,30,1,5,0,1,0,13,2,4,0,2,0,2,0,4,0,1,0,4,0,1,6,1,0,7,0,4,0,2,0,2,0,4,2,38,0,38,0,0,0,14,2,4,0,2,0,2,0,4,0,1,0,4,0,1,6,1,0,7,0,4,0,2,0,2,0,4,2,38,0,15,0,4,0,8,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,17,0,2,0,8,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,16,1,1,0,1,0,6,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,20,0,0,0,7,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,21,0,29,1,0,0,5,1,4,1,0,1,4,3,3,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,30,0,0,0,4,0,0,0,12,0,0,3,2,1,3,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,36,0,30,0,8,0,14,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,31,0,6,0,15,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,30,1,5,0,1,0,13,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,30,0,0,0,4,0,0,0,14,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,4,2,38,0,38,0,0,0,14,2,4,0,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,
0,1,0,4,0,2,0,2,0,4,2,38,0,57,0,13,6,13,0,75,0,56,2,0,0,2,0,2,0,2,0,3,1,1,0,2,0,0,0,1,0,1,0,1,0,1,0,0,0,2,0,1,1,3,0,2,0,2,0,2,0,0,2,38,0,29,0,8,0,13,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,31,0,6,0,13,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,30,1,5,0,1,0,11,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,38,0,0,0,12,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,3,1,2,3,0,0,36,0,31,0,6,0,13,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,3,0,2,0,3,0,1,1,4,0,0,0,5,0,0,0,6,0,7,0,6,0,5,1,14,0,27,0,7,0,7,0,7,0,0,2,3,1,2,0,2,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,0,4,0,1,1,2,0,2,0,0,2,3,0,7,0,7,0,15,0,38,0,0,0,12,0,4,0,1,0,4,0,1,0,4,0,2,0,2,0,3,0,2,0,3,0,1,1,4,0,0,0,5,0,0,0,6,0,7,0,6,0,5,1,14,0,0,0);

sysfont__arial_12:array[0..11357] of byte=(
71,70,35,51,23,0,19,0,15,0,8,6,0,0,15,0,12,6,0,0,15,0,16,6,0,0,15,0,40,6,0,0,15,0,62,6,0,0,15,0,84,6,0,0,15,0,122,6,0,0,15,0,130,6,0,0,15,0,148,6,0,0,15,0,200,6,0,0,15,0,204,6,0,0,15,0,208,6,0,0,15,0,252,6,0,0,15,0,46,7,0,0,15,0,50,7,0,0,15,0,108,7,0,0,15,0,170,7,0,0,15,0,208,7,0,0,15,0,240,7,0,0,15,0,26,8,0,0,15,0,80,8,0,0,15,0,150,8,0,0,15,0,172,8,0,0,15,0,196,8,0,0,15,0,234,8,0,0,15,0,14,9,0,0,15,0,52,9,0,0,15,0,68,9,0,0,15,0,84,9,0,0,15,0,88,9,0,0,15,0,92,9,0,0,15,0,96,9,0,0,6,0,100,9,0,0,6,0,104,9,0,0,7,0,132,9,0,0,11,0,154,9,0,0,11,0,204,9,0,0,18,0,12,10,0,0,13,0,100,10,0,0,4,0,158,10,0,0,7,0,170,10,0,0,7,0,210,10,0,0,8,0,250,10,0,0,12,0,12,11,0,0,6,0,34,11,0,0,7,0,46,11,0,0,6,0,52,11,0,0,6,0,58,11,0,0,11,0,90,11,0,0,11,0,144,11,0,0,11,0,178,11,0,0,11,0,214,11,0,0,11,0,254,11,0,0,11,0,40,12,0,0,11,0,80,12,0,0,11,0,130,12,0,0,11,0,162,12,0,0,11,0,212,12,0,0,6,0,6,13,0,0,6,0,16,13,0,0,12,0,32,13,0,0,12,0,52,13,0,0,12,0,62,13,0,0,11,0,82,13,0,0,20,0,114,13,0,0,13,0,224,13,0,0,13,0,20,14,0,0,14,
0,70,14,0,0,14,0,114,14,0,0,13,0,168,14,0,0,12,0,200,14,0,0,16,0,232,14,0,0,13,0,26,15,0,0,6,0,84,15,0,0,10,0,116,15,0,0,13,0,154,15,0,0,11,0,212,15,0,0,17,0,244,15,0,0,13,0,88,16,0,0,16,0,164,16,0,0,13,0,218,16,0,0,16,0,4,17,0,0,14,0,64,17,0,0,13,0,118,17,0,0,12,0,160,17,0,0,13,0,190,17,0,0,13,0,248,17,0,0,19,0,46,18,0,0,13,0,152,18,0,0,14,0,208,18,0,0,12,0,252,18,0,0,6,0,28,19,0,0,6,0,68,19,0,0,6,0,100,19,0,0,8,0,140,19,0,0,11,0,166,19,0,0,7,0,171,19,0,0,11,0,179,19,0,0,11,0,213,19,0,0,10,0,7,20,0,0,11,0,39,20,0,0,11,0,89,20,0,0,6,0,119,20,0,0,11,0,149,20,0,0,10,0,201,20,0,0,4,0,253,20,0,0,5,0,25,21,0,0,10,0,61,21,0,0,4,0,111,21,0,0,16,0,143,21,0,0,10,0,211,21,0,0,11,0,255,21,0,0,11,0,37,22,0,0,11,0,87,22,0,0,7,0,137,22,0,0,10,0,163,22,0,0,6,0,191,22,0,0,10,0,221,22,0,0,9,0,9,23,0,0,15,0,47,23,0,0,9,0,115,23,0,0,10,0,155,23,0,0,9,0,201,23,0,0,7,0,223,23,0,0,6,0,7,24,0,0,7,0,47,24,0,0,12,0,87,24,0,0,15,0,101,24,0,0,11,0,151,24,0,0,1,0,187,24,0,0,4,0,189,24,0,0,11,0,201,24,0,0,7,0,241,24,0,0,20,
0,7,25,0,0,11,0,23,25,0,0,11,0,61,25,0,0,7,0,99,25,0,0,21,0,109,25,0,0,13,0,213,25,0,0,7,0,7,26,0,0,20,0,27,26,0,0,1,0,89,26,0,0,12,0,91,26,0,0,1,0,131,26,0,0,1,0,133,26,0,0,4,0,135,26,0,0,4,0,147,26,0,0,7,0,159,26,0,0,7,0,181,26,0,0,7,0,203,26,0,0,11,0,215,26,0,0,20,0,221,26,0,0,7,0,229,26,0,0,20,0,237,26,0,0,10,0,49,27,0,0,7,0,85,27,0,0,19,0,105,27,0,0,1,0,159,27,0,0,9,0,161,27,0,0,13,0,191,27,0,0,6,0,243,27,0,0,6,0,247,27,0,0,11,0,19,28,0,0,11,0,77,28,0,0,11,0,115,28,0,0,11,0,149,28,0,0,6,0,189,28,0,0,11,0,223,28,0,0,7,0,25,29,0,0,15,0,35,29,0,0,7,0,109,29,0,0,11,0,127,29,0,0,12,0,165,29,0,0,7,0,179,29,0,0,15,0,185,29,0,0,12,0,11,30,0,0,8,0,17,30,0,0,11,0,35,30,0,0,7,0,61,30,0,0,7,0,79,30,0,0,7,0,99,30,0,0,11,0,107,30,0,0,11,0,161,30,0,0,7,0,229,30,0,0,7,0,235,30,0,0,7,0,247,30,0,0,7,0,9,31,0,0,11,0,31,31,0,0,17,0,69,31,0,0,17,0,135,31,0,0,17,0,199,31,0,0,12,0,9,32,0,0,13,0,41,32,0,0,13,0,99,32,0,0,13,0,157,32,0,0,13,0,217,32,0,0,13,0,23,33,0,0,13,0,83,33,0,0,20,0,149,33,0,0,14,0,203,33,0,0,13,
0,255,33,0,0,13,0,37,34,0,0,13,0,75,34,0,0,13,0,115,34,0,0,6,0,155,34,0,0,6,0,193,34,0,0,6,0,231,34,0,0,6,0,15,35,0,0,14,0,53,35,0,0,14,0,107,35,0,0,16,0,193,35,0,0,16,0,253,35,0,0,16,0,57,36,0,0,16,0,119,36,0,0,16,0,183,36,0,0,12,0,245,36,0,0,16,0,21,37,0,0,14,0,91,37,0,0,14,0,155,37,0,0,14,0,219,37,0,0,14,0,29,38,0,0,13,0,95,38,0,0,13,0,145,38,0,0,12,0,187,38,0,0,11,0,247,38,0,0,11,0,31,39,0,0,11,0,71,39,0,0,11,0,113,39,0,0,11,0,157,39,0,0,11,0,199,39,0,0,18,0,249,39,0,0,10,0,41,40,0,0,11,0,81,40,0,0,11,0,117,40,0,0,11,0,153,40,0,0,11,0,191,40,0,0,6,0,229,40,0,0,6,0,3,41,0,0,6,0,33,41,0,0,6,0,65,41,0,0,11,0,95,41,0,0,11,0,147,41,0,0,11,0,201,41,0,0,11,0,245,41,0,0,11,0,33,42,0,0,11,0,79,42,0,0,11,0,127,42,0,0,11,0,173,42,0,0,11,0,187,42,0,0,11,0,235,42,0,0,11,0,29,43,0,0,11,0,79,43,0,0,11,0,131,43,0,0,10,0,183,43,0,0,11,0,235,43,0,0,10,0,37,44,0,0,0,128,1,88,0,128,1,88,0,128,0,164,4,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,39,0,48,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,4,128,0,170,0,48,0,
13,0,13,0,13,0,13,0,13,0,13,0,13,0,9,4,128,0,174,0,48,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,39,0,128,0,164,8,128,0,170,0,122,2,10,4,8,6,7,6,7,6,8,4,10,2,128,0,128,0,44,8,5,8,5,8,5,8,5,8,5,2,2,2,5,1,4,1,5,0,6,0,5,0,6,0,5,0,6,0,5,1,4,1,5,2,2,2,5,8,5,8,5,8,5,8,5,8,5,8,35,0,128,1,88,0,128,1,88,0,78,4,12,1,11,0,0,0,11,0,0,0,10,0,1,0,10,0,12,0,13,0,11,2,10,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,10,2,69,0,91,9,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,0,7,0,4,9,62,0,128,1,88,0,65,2,8,2,1,0,8,0,3,0,8,0,3,0,8,0,1,2,8,2,1,0,8,0,3,0,8,0,3,0,8,0,3,0,8,0,3,0,8,0,2,1,7,1,1,2,6,2,1,2,6,2,1,1,7,1,71,0,63,0,13,0,10,0,1,0,1,0,7,0,0,2,0,0,8,0,2,0,9,0,2,0,9,0,2,0,8,1,2,1,8,0,2,0,9,0,2,0,9,0,2,0,8,0,0,2,0,0,7,0,1,0,1,0,10,0,13,0,69,0,48,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,9,8,9,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,39,0,67,0,12,1,11,2,10,3,9,4,8,5,7,6,6,7,7,6,8,5,9,4,10,3,11,2,12,1,13,0,65,0,63,0,12,2,10,0,0,0,0,0,11,0,13,0,13,0,13,
0,13,0,13,0,13,0,13,0,13,0,13,0,11,0,0,0,0,0,10,2,12,0,54,0,62,0,1,0,10,0,1,0,10,0,1,0,10,0,1,0,10,0,1,0,10,0,1,0,10,0,1,0,10,0,1,0,10,0,1,0,10,0,1,0,40,0,1,0,10,0,1,0,10,0,1,0,67,0,62,4,8,0,1,0,0,0,7,0,2,0,0,0,7,0,2,0,0,0,7,0,2,0,0,0,8,0,1,0,0,0,9,2,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,11,0,0,0,66,0,48,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,9,8,128,0,170,0,128,0,164,8,9,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,39,0,48,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,9,4,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,39,0,63,0,12,2,10,0,0,0,0,0,11,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,69,0,48,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,4,9,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,13,0,39,0,128,0,140,0,14,0,7,7,12,0,12,0,128,0,142,0,128,0,137,0,12,0,12,7,7,0,14,0,128,0,145,0,128,1,88,0,128,1,88,0,128,1,88,0,128,1,88,0,128,0,137,0,25,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,15,1,3,1,25,0,28,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,98,0,47,1,1,1,4,1,1,1,4,1,0,2,3,1,1,1,1,21,
2,1,1,1,3,1,1,1,4,1,1,1,2,21,1,1,1,1,3,2,0,1,4,1,1,1,4,1,1,1,47,0,37,0,7,4,4,6,2,2,0,0,0,2,1,1,1,0,1,1,1,1,1,0,5,2,0,0,6,4,7,4,6,0,0,2,5,0,1,1,5,0,1,1,1,1,1,0,1,1,1,2,0,0,0,2,2,6,4,4,7,0,9,0,26,0,74,2,5,1,5,1,0,1,3,1,5,1,2,1,2,1,5,1,2,1,1,1,6,1,2,1,1,1,6,1,2,1,0,1,8,1,0,1,1,1,9,2,1,1,1,2,10,1,0,1,0,1,8,1,0,1,2,1,7,1,0,1,2,1,6,1,1,1,2,1,6,1,1,1,2,1,5,1,3,1,0,1,6,1,4,2,74,0,56,2,8,4,6,1,2,1,5,1,2,1,5,1,2,1,6,0,1,1,7,3,7,3,7,1,1,1,5,1,2,1,1,1,1,1,3,1,0,1,1,1,4,2,2,2,3,2,3,6,0,2,2,4,2,0,52,0,16,1,1,1,1,1,1,1,1,1,56,0,32,0,4,0,4,1,4,0,4,1,4,1,3,1,4,1,4,1,4,1,4,1,4,1,4,1,5,1,4,1,5,0,5,1,5,0,6,0,0,0,28,0,6,0,5,1,5,0,5,1,4,1,5,1,4,1,4,1,4,1,4,1,4,1,4,1,3,1,4,1,4,0,4,1,4,0,4,0,4,0,34,0,6,0,3,6,3,0,5,0,0,0,3,1,0,1,105,0,88,1,9,1,9,1,9,1,5,9,1,9,5,1,9,1,9,1,9,1,76,0,103,1,3,1,4,0,4,0,3,0,8,0,90,5,0,5,56,0,103,1,3,1,25,0,27,1,3,1,2,1,3,1,3,1,3,1,2,1,3,1,3,1,2,1,3,1,3,1,3,1,2,1,3,1,27,0,46,4,4,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,48,1,8,1,7,2,
5,4,5,1,0,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,47,0,46,4,4,6,3,1,3,1,1,1,4,1,8,1,8,1,8,0,8,1,7,1,7,1,7,1,7,1,7,1,7,8,1,8,44,0,46,3,5,5,3,2,1,2,2,1,3,1,8,1,7,2,6,1,8,3,8,2,8,1,8,1,1,1,4,1,1,2,2,2,2,6,4,4,46,0,50,0,8,1,7,2,7,2,6,3,5,1,0,1,4,1,1,1,4,1,1,1,3,1,2,1,2,1,3,1,2,9,0,9,6,1,8,1,8,1,46,0,45,6,3,6,3,1,8,1,7,1,8,1,0,3,3,7,2,1,3,2,8,1,8,1,8,1,1,1,4,1,1,2,2,1,3,6,4,3,47,0,47,3,5,5,3,1,2,2,2,1,3,1,1,1,8,1,0,3,3,7,2,2,2,2,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,5,3,46,0,44,8,1,8,8,0,8,1,7,1,8,1,7,1,8,1,7,1,8,1,8,1,7,1,8,1,8,1,8,1,49,0,46,4,4,6,2,2,2,2,1,1,4,1,1,1,4,1,1,2,2,2,2,6,3,6,2,2,2,2,1,1,4,1,1,1,4,1,1,1,4,1,1,2,2,2,2,6,4,4,46,0,46,3,5,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,2,2,2,2,7,3,3,0,1,8,1,1,1,4,1,1,2,2,1,3,6,4,3,47,0,49,1,3,1,45,1,3,1,25,0,49,1,3,1,45,1,3,1,4,0,4,0,3,0,8,0,93,0,7,3,5,3,4,3,6,1,10,3,10,3,9,3,10,0,84,0,108,9,1,9,25,9,1,9,96,0,84,0,10,3,9,3,10,3,10,1,6,3,4,3,5,3,7,0,93,0,46,4,4,6,2,2,2,2,1,1,4,1,8,1,7,1,7,2,6,2,6,2,7,1,8,1,30,1,8,1,48,0,86,6,10,10,7,3,4,3,
5,2,8,2,3,2,2,2,1,1,0,1,3,1,2,4,0,1,1,1,2,1,1,2,1,2,2,1,1,1,2,1,3,1,2,1,1,1,1,1,4,1,2,1,1,1,1,1,4,1,2,1,1,1,1,1,4,0,2,2,1,1,1,1,3,1,2,1,2,1,1,2,1,2,1,1,4,1,1,9,5,1,2,2,0,3,1,1,3,1,10,1,4,3,6,2,7,10,10,6,5,0,56,2,9,2,8,1,0,1,7,1,0,1,7,1,0,1,6,1,2,1,5,1,2,1,5,1,2,1,4,1,4,1,3,8,2,10,1,1,6,1,1,1,6,1,0,1,8,3,8,1,51,0,53,6,5,7,4,1,3,2,3,1,4,1,3,1,4,1,3,1,3,2,3,7,4,7,4,1,4,1,3,1,5,1,2,1,5,1,2,1,5,1,2,1,4,2,2,8,3,7,54,0,60,3,7,7,4,2,3,2,3,1,5,2,1,2,6,1,1,1,11,1,11,1,11,1,11,1,11,2,6,1,2,1,5,2,2,2,3,2,4,7,7,3,60,0,57,7,5,8,4,1,4,2,3,1,5,1,3,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,5,1,3,1,4,2,3,8,4,7,59,0,53,9,2,9,2,1,10,1,10,1,10,1,10,8,3,8,3,1,10,1,10,1,10,1,10,1,10,9,2,9,52,0,49,8,2,8,2,1,9,1,9,1,9,1,9,7,3,7,3,1,9,1,9,1,9,1,9,1,9,1,9,1,55,0,68,6,7,8,5,2,4,2,3,1,7,2,2,1,8,0,2,1,13,1,13,1,4,6,1,1,4,6,1,1,9,1,2,1,8,1,2,1,8,1,3,2,4,3,4,9,7,5,67,0,52,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,10,1,10,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,52,0,25,1,3,1,3,1,3,1,3,1,3,1,
3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,45,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,2,1,2,1,2,1,2,1,2,2,1,1,3,4,5,2,43,0,53,1,4,2,2,1,3,2,3,1,2,2,4,1,1,2,5,1,1,1,6,1,0,2,6,4,7,5,6,2,0,1,6,1,1,2,5,1,2,2,4,1,3,2,3,1,4,1,3,1,4,2,2,1,5,2,51,0,45,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,7,2,7,44,0,69,2,6,2,3,3,4,3,3,3,4,3,3,3,4,3,3,1,0,1,2,1,0,1,3,1,0,1,2,1,0,1,3,1,0,1,2,1,0,1,3,1,0,1,2,1,0,1,3,1,1,1,0,1,1,1,3,1,1,1,0,1,1,1,3,1,1,1,0,1,1,1,3,1,1,1,0,1,1,1,3,1,2,2,2,1,3,1,2,2,2,1,3,1,2,2,2,1,69,0,52,1,6,1,1,2,5,1,1,3,4,1,1,3,4,1,1,1,0,1,3,1,1,1,0,1,3,1,1,1,1,1,2,1,1,1,1,2,1,1,1,1,2,1,1,1,1,1,3,1,0,1,1,1,3,1,0,1,1,1,4,3,1,1,4,3,1,1,5,2,1,1,6,1,52,0,68,5,8,7,6,2,3,2,4,1,7,1,2,2,7,2,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,2,7,2,2,1,7,1,4,2,3,2,6,7,8,5,68,0,53,7,4,8,3,1,4,2,2,1,5,1,2,1,5,1,2,1,5,1,2,1,4,2,2,8,3,7,4,1,10,1,10,1,10,1,10,1,10,1,60,0,68,5,8,8,5,2,3,3,3,1,7,1,2,2,7,2,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,2,7,1,3,1,3,2,0,1,4,2,3,2,6,9,6,5,0,2,14,0,48,0,57,7,5,8,4,1,4,2,3,1,5,1,3,
1,5,1,3,1,4,2,3,8,4,7,5,1,2,1,6,1,3,1,5,1,3,2,4,1,4,1,4,1,4,2,3,1,5,1,3,1,5,2,56,0,55,5,5,7,3,2,3,2,2,1,5,1,2,1,10,2,10,4,9,4,10,2,11,1,1,1,6,1,1,1,6,1,2,2,3,2,2,8,5,4,55,0,47,23,4,1,9,1,9,1,9,1,9,1,9,1,9,1,9,1,9,1,9,1,9,1,9,1,9,1,52,0,52,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,1,1,6,1,2,1,4,1,3,8,5,4,55,0,51,1,8,3,8,4,6,2,0,1,6,1,1,1,6,1,2,1,4,1,3,1,4,1,3,1,4,1,4,1,2,1,5,1,2,1,6,1,0,1,7,1,0,1,7,1,0,1,8,2,9,2,56,0,75,1,5,2,5,3,5,2,5,3,4,1,0,1,4,1,0,1,3,1,0,1,3,1,1,1,3,1,0,1,3,1,1,1,3,0,2,0,3,1,1,1,2,1,2,1,2,1,1,1,2,1,2,1,2,1,2,1,1,1,2,1,1,1,3,1,0,1,4,1,0,1,3,1,0,1,4,1,0,1,3,1,0,1,4,1,0,1,3,1,0,1,4,1,0,1,4,2,6,2,5,2,6,2,78,0,52,2,4,2,2,2,3,1,4,1,2,1,5,2,0,2,6,1,0,1,8,2,9,2,9,2,8,1,0,1,7,1,0,1,6,1,1,2,4,2,2,2,3,1,4,1,2,1,5,2,0,2,6,2,51,0,55,2,7,2,0,1,7,1,2,1,5,1,3,2,3,2,4,2,1,2,6,1,1,1,8,3,9,3,10,1,11,1,11,1,11,1,11,1,11,1,11,1,61,0,48,9,1,9,8,1,8,1,9,1,8,1,8,1,8,2,8,1,8,1,8,1,9,1,8,1,8,10,0,10,48,0,24,3,1,3,1,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,
3,1,3,1,3,1,3,1,3,3,1,3,0,0,23,1,3,1,4,1,3,1,3,1,3,1,4,1,3,1,3,1,4,1,3,1,3,1,3,1,4,1,3,1,23,0,24,3,1,3,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,1,3,1,3,0,0,34,1,4,3,3,3,3,3,2,1,1,1,1,1,1,1,1,1,1,1,0,1,3,1,87,0,128,0,230,21,0,28,1,5,1,5,0,114,0,90,4,3,7,2,1,3,1,8,1,6,3,3,6,2,3,1,1,2,1,3,1,2,1,2,2,2,7,3,3,1,1,44,0,44,1,8,1,8,1,8,1,8,1,0,3,3,7,2,2,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,2,2,1,2,7,2,1,0,3,46,0,82,3,4,5,3,1,1,2,1,1,3,1,1,1,7,1,7,1,7,1,3,1,2,1,1,2,2,5,4,3,42,0,51,1,8,1,8,1,8,1,3,3,0,1,2,7,2,1,2,2,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,2,2,7,3,3,0,1,44,0,90,4,4,6,3,1,2,1,2,1,4,1,1,8,1,8,1,1,8,1,9,1,3,1,2,6,4,4,46,0,26,2,1,3,1,1,3,1,1,11,1,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,90,3,0,1,2,7,2,1,2,2,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,2,2,7,3,3,0,1,8,1,1,1,3,2,1,7,4,4,2,0,40,1,7,1,7,1,7,1,7,1,0,3,2,7,1,2,2,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,40,0,16,1,1,1,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,16,0,21,1,2,1,12,1,
2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,0,3,0,2,1,0,40,1,7,1,7,1,7,1,7,1,3,2,0,1,2,2,1,1,1,2,2,1,0,2,3,4,4,5,3,1,1,1,3,1,1,2,2,1,2,2,1,1,3,1,1,1,3,2,39,0,16,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,16,0,128,0,128,1,0,3,1,3,2,6,0,5,1,2,2,2,2,1,1,1,3,1,3,1,1,1,3,1,3,1,1,1,3,1,3,1,1,1,3,1,3,1,1,1,3,1,3,1,1,1,3,1,3,1,1,1,3,1,3,1,1,1,3,1,3,1,64,0,80,1,0,3,2,7,1,2,2,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,40,0,90,4,4,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,88,1,0,3,3,7,2,2,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,2,2,1,2,7,2,1,0,3,3,1,8,1,8,1,8,1,7,0,90,3,0,1,2,7,2,1,2,2,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,2,2,7,3,3,0,1,8,1,8,1,8,1,8,1,0,0,56,1,0,2,0,5,0,2,3,1,4,1,4,1,4,1,4,1,4,1,4,1,4,1,31,0,82,3,3,6,2,1,3,1,1,1,7,3,6,5,6,3,7,1,1,1,3,1,2,5,4,3,42,0,30,1,3,1,3,1,2,4,0,4,1,1,3,1,3,1,3,1,3,1,3,1,3,1,3,3,2,2,24,0,80,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,3,1,1,1,2,2,1,7,2,3,0,1,40,0,71,1,4,
3,4,1,0,1,2,1,1,1,2,1,1,1,2,1,2,1,0,1,3,1,0,1,3,1,0,1,4,2,5,2,6,0,39,0,119,1,4,0,4,3,3,2,3,3,3,2,3,1,0,1,2,0,0,0,2,1,1,1,1,1,0,1,1,1,2,1,0,1,0,1,0,1,3,1,0,1,0,1,0,1,3,1,0,0,2,0,0,1,4,2,2,2,5,2,2,2,5,2,2,2,62,0,71,1,4,1,0,1,2,1,2,1,0,1,3,1,0,1,4,2,5,2,5,2,4,1,0,1,3,1,0,1,2,1,2,1,0,1,4,1,35,0,79,1,5,3,5,1,0,1,3,1,1,1,3,1,1,2,2,1,2,1,1,1,3,1,1,1,4,1,0,1,4,3,6,2,6,2,6,1,6,2,4,3,5,2,5,0,72,7,0,7,5,2,4,2,4,2,4,2,4,2,4,2,4,2,5,17,35,0,30,2,2,3,2,1,4,1,4,1,4,1,4,1,3,2,2,2,3,2,4,1,5,1,4,1,4,1,4,1,4,1,4,1,4,3,3,2,0,0,25,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,1,0,28,2,3,3,4,1,4,1,4,1,4,1,4,1,4,2,4,2,3,2,2,2,3,1,4,1,4,1,4,1,4,1,4,1,2,3,2,2,2,0,121,2,7,5,2,0,1,0,2,5,7,2,109,0,74,4,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,0,2,0,9,4,84,0,48,3,4,6,3,1,3,0,2,1,8,1,7,1,7,8,2,1,7,8,2,1,9,1,8,1,8,2,3,0,3,6,5,3,45,0,22,0,68,1,1,1,2,0,2,0,1,0,5,0,50,2,6,3,6,1,7,1,6,5,4,5,6,1,8,1,7,2,7,1,8,1,8,1,8,1,8,1,7,1,8,1,8,1,6,3,5,3,6,0,119,1,0,1,1,1,0,
1,2,0,1,0,2,0,1,0,1,0,1,0,8,0,128,1,85,1,4,1,4,1,3,1,4,1,4,1,81,0,48,1,8,1,8,1,8,1,4,9,0,9,4,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,14,0,48,1,8,1,8,1,8,1,4,9,0,9,4,1,8,1,8,1,8,1,8,1,8,1,4,9,0,9,4,1,8,1,8,1,8,1,14,0,30,1,3,3,1,1,1,1,111,0,84,3,3,1,9,1,1,1,1,1,10,1,1,1,1,1,10,1,1,1,1,1,10,1,1,1,0,1,11,1,1,1,0,1,12,3,0,1,18,1,18,1,0,3,2,3,5,1,0,1,1,1,0,1,1,1,4,1,0,1,1,1,0,1,1,1,3,1,1,1,1,1,0,1,1,1,3,1,1,1,1,1,0,1,1,1,3,1,1,1,1,1,0,1,1,1,2,1,3,3,2,3,84,0,3,1,1,1,7,3,9,1,21,5,5,7,3,2,3,2,2,1,5,1,2,1,10,2,10,4,9,4,10,2,11,1,1,1,6,1,1,1,6,1,2,2,3,2,2,8,5,4,55,0,66,1,3,1,3,1,4,1,3,1,5,1,4,1,5,1,5,1,35,0,83,4,1,7,3,6,0,7,2,2,3,3,8,1,5,2,7,1,7,1,7,1,7,1,7,1,7,6,2,1,7,6,2,1,7,1,7,1,7,1,7,1,7,1,8,1,5,2,8,2,3,3,9,6,0,7,4,4,1,7,80,0,22,0,2,1,1,1,6,3,8,1,17,9,1,9,8,1,8,1,9,1,8,1,8,1,8,2,8,1,8,1,8,1,9,1,8,1,8,10,0,10,48,0,22,0,22,0,17,0,1,0,2,0,2,1,1,1,56,0,16,1,1,1,2,0,2,0,1,0,57,0,29,0,1,0,1,0,1,0,2,0,1,0,2,1,0,1,1,1,0,1,98,0,28,1,0,1,1,1,0,1,2,0,1,0,2,0,1,0,1,0,1,0,99,0,64,2,2,4,1,4,1,4,2,2,64,0,128,0,
142,21,87,0,128,1,3,39,128,0,159,0,28,2,0,10,0,2,112,0,81,6,0,1,2,1,7,0,3,1,2,1,7,0,3,1,2,1,7,0,3,0,0,0,0,0,0,0,7,0,3,0,0,0,0,0,0,0,7,0,3,0,0,0,0,0,0,0,7,0,3,0,1,0,1,0,7,0,3,0,1,0,1,0,128,0,222,0,41,1,1,1,4,3,6,1,16,3,3,6,2,1,3,1,1,1,7,3,6,5,6,3,7,1,1,1,3,1,2,5,4,3,42,0,63,1,5,1,5,1,4,1,5,1,3,1,4,1,3,1,3,1,38,0,128,0,154,3,3,3,5,5,1,6,3,1,2,3,3,1,2,1,4,1,5,1,1,1,4,9,1,1,4,9,1,1,4,1,9,1,4,1,10,1,2,3,3,2,2,5,1,6,4,3,3,4,78,0,22,0,37,1,1,1,3,3,5,1,12,7,0,7,5,2,4,2,4,2,4,2,4,2,4,2,4,2,5,17,35,0,16,1,1,1,6,1,1,1,15,2,7,1,0,1,7,1,1,1,5,1,2,2,3,2,3,2,1,2,5,1,1,1,7,3,8,3,9,1,10,1,10,1,10,1,10,1,10,1,10,1,56,0,128,0,137,0,49,1,3,1,15,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,1,0,50,0,9,0,9,0,9,0,6,2,5,6,3,1,1,2,2,1,2,0,0,1,1,1,1,0,5,1,1,0,5,1,1,0,5,1,0,0,2,1,2,2,1,2,2,6,5,3,5,0,9,0,9,0,9,0,6,0,47,3,5,5,3,2,1,2,2,1,3,1,2,1,8,1,8,1,6,7,2,7,5,1,8,1,7,1,7,4,4,9,0,0,4,2,45,0,88,0,0,3,0,0,2,7,3,1,1,1,3,1,3,1,2,1,3,1,3,1,1,1,3,7,2,0,0,3,0,0,78,0,43,1,7,0,0,1,5,1,0,1,5,1,1,1,3,1,3,1,1,1,4,1,1,1,5,3,2,21,4,1,8,1,
3,21,4,1,8,1,47,0,25,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,21,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,1,0,46,3,5,6,3,1,2,1,3,1,9,1,7,3,5,1,1,2,3,1,2,2,2,1,3,2,1,2,3,1,2,2,2,1,4,1,0,1,6,2,8,1,9,1,2,1,3,1,2,2,2,1,3,5,5,3,3,0,28,1,1,1,0,1,1,1,118,0,64,4,7,1,4,1,4,0,8,0,2,0,2,4,2,0,1,0,1,0,4,0,1,0,0,0,1,0,9,1,1,0,9,1,1,0,9,1,1,0,9,1,1,0,5,0,2,0,0,0,1,0,3,0,2,0,1,0,2,3,3,0,2,0,8,0,4,1,4,1,7,4,64,0,28,4,0,1,2,1,4,1,0,7,2,3,1,2,0,5,83,0,102,1,1,1,3,1,1,1,3,1,1,1,4,1,1,1,3,1,1,1,5,1,1,1,4,1,1,1,5,1,1,1,5,1,1,1,55,0,108,9,1,9,9,1,9,1,9,1,9,1,96,0,90,5,0,5,56,0,64,4,7,1,4,1,4,0,8,0,2,0,1,4,3,0,1,0,1,0,3,0,2,0,0,0,2,0,3,0,3,1,2,0,3,0,3,1,2,4,4,1,2,0,1,0,5,1,2,0,2,0,4,0,0,0,1,0,3,0,2,0,1,0,1,0,4,0,1,0,2,0,8,0,4,1,4,1,7,4,64,0,23,23,128,0,227,0,33,2,3,0,2,0,2,0,2,0,2,0,2,0,3,2,114,0,81,1,8,1,8,1,8,1,4,9,0,9,4,1,8,1,8,1,8,1,4,9,0,9,43,0,28,3,1,1,1,1,4,1,3,1,3,1,3,1,3,5,84,0,28,3,1,1,1,1,4,1,2,1,6,1,0,1,1,1,1,3,85,0,30,1,3,1,4,0,115,0,88,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,2,2,2,1,8,1,1,0,2,0,1,1,1,8,
1,8,1,8,1,7,0,45,8,0,15,1,1,0,5,1,1,0,5,1,1,0,5,1,1,1,4,1,1,2,3,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,11,0,78,1,4,1,72,0,128,0,135,0,5,1,5,1,1,3,1,0,30,1,3,2,2,3,2,0,0,1,4,1,4,1,4,1,85,0,29,2,2,0,2,0,0,1,2,3,2,3,2,1,0,1,1,0,2,2,85,0,99,1,1,1,5,1,1,1,5,1,1,1,4,1,1,1,5,1,1,1,3,1,1,1,4,1,1,1,3,1,1,1,3,1,1,1,58,0,71,1,6,1,4,2,5,1,4,3,4,1,5,0,0,1,3,1,8,1,3,1,8,1,2,1,9,1,1,1,14,1,13,1,4,1,6,1,4,2,5,1,4,0,0,1,5,1,3,1,0,1,4,1,4,5,2,1,8,1,2,1,9,1,68,0,70,1,7,1,3,2,6,1,3,3,5,1,4,0,0,1,5,1,6,1,4,1,7,1,3,1,8,1,2,2,13,1,13,1,2,3,6,1,2,0,2,1,5,1,6,1,4,1,6,1,4,1,6,1,4,1,6,0,6,1,5,5,67,0,68,3,7,1,1,1,1,1,5,1,6,1,5,1,4,1,6,1,7,1,3,1,4,1,1,1,2,1,6,3,3,1,13,1,13,1,4,1,7,1,3,2,6,1,3,3,5,1,3,1,0,1,4,1,4,5,3,1,7,1,3,1,8,1,68,0,101,1,9,1,33,1,9,1,8,2,7,2,7,2,8,1,8,1,9,1,3,1,3,2,1,2,4,5,6,3,3,0,4,1,11,1,11,0,22,2,9,2,8,1,0,1,7,1,0,1,7,1,0,1,6,1,2,1,5,1,2,1,5,1,2,1,4,1,4,1,3,8,2,10,1,1,6,1,1,1,6,1,0,1,8,3,8,1,51,0,5,1,9,1,10,0,24,2,9,2,8,1,0,1,7,1,0,1,7,1,0,1,6,1,2,1,5,1,2,1,
5,1,2,1,4,1,4,1,3,8,2,10,1,1,6,1,1,1,6,1,0,1,8,3,8,1,51,0,5,1,9,3,7,1,1,1,20,2,9,2,8,1,0,1,7,1,0,1,7,1,0,1,6,1,2,1,5,1,2,1,5,1,2,1,4,1,4,1,3,8,2,10,1,1,6,1,1,1,6,1,0,1,8,3,8,1,51,0,3,2,0,1,5,6,5,1,0,2,21,2,9,2,8,1,0,1,7,1,0,1,7,1,0,1,6,1,2,1,5,1,2,1,5,1,2,1,4,1,4,1,3,8,2,10,1,1,6,1,1,1,6,1,0,1,8,3,8,1,51,0,16,1,1,1,6,1,1,1,20,2,9,2,8,1,0,1,7,1,0,1,7,1,0,1,6,1,2,1,5,1,2,1,5,1,2,1,4,1,4,1,3,8,2,10,1,1,6,1,1,1,6,1,0,1,8,3,8,1,51,0,4,2,8,0,2,0,7,0,2,0,7,0,2,0,8,2,9,2,8,1,0,1,7,1,0,1,7,1,0,1,6,1,2,1,5,1,2,1,5,1,2,1,4,1,4,1,3,8,2,10,1,1,6,1,1,1,6,1,0,1,8,3,8,1,51,0,86,11,6,12,6,1,1,1,12,1,2,1,12,1,2,1,11,1,3,1,11,1,3,7,4,1,4,7,4,1,4,1,9,9,9,9,8,1,6,1,8,1,6,1,7,1,7,8,0,1,7,8,80,0,60,3,7,7,4,2,3,2,3,1,5,2,1,2,6,1,1,1,11,1,11,1,11,1,11,1,11,2,6,1,2,1,5,2,2,2,3,2,4,7,7,3,10,0,12,1,12,1,8,3,5,0,4,1,11,1,11,0,19,9,2,9,2,1,10,1,10,1,10,1,10,8,3,8,3,1,10,1,10,1,10,1,10,1,10,9,2,9,52,0,6,1,9,1,10,0,20,9,2,9,2,1,10,1,10,1,10,1,10,8,3,8,3,1,10,1,10,1,10,1,10,1,10,9,2,9,52,0,5,1,9,3,7,1,1,1,17,9,2,9,2,1,10,1,10,1,
10,1,10,8,3,8,3,1,10,1,10,1,10,1,10,1,10,9,2,9,52,0,16,1,1,1,6,1,1,1,17,9,2,9,2,1,10,1,10,1,10,1,10,8,3,8,3,1,10,1,10,1,10,1,10,1,10,9,2,9,52,0,0,1,4,1,4,0,9,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,2,1,2,1,3,0,10,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,1,1,2,3,0,1,1,1,7,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,5,1,1,3,1,1,7,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,57,7,5,8,4,1,4,2,3,1,5,1,3,1,6,1,2,1,6,1,0,6,3,1,0,6,3,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,5,1,3,1,4,2,3,8,4,7,59,0,3,2,0,1,6,6,6,1,0,2,19,1,6,1,2,2,5,1,2,3,4,1,2,3,4,1,2,1,0,1,3,1,2,1,0,1,3,1,2,1,1,1,2,1,2,1,1,2,1,1,2,1,2,1,1,1,2,1,3,1,0,1,2,1,3,1,0,1,2,1,4,3,2,1,4,3,2,1,5,2,2,1,6,1,57,0,5,1,14,1,14,0,27,5,8,7,6,2,3,2,4,1,7,1,2,2,7,2,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,2,7,2,2,1,7,1,4,2,3,2,6,7,8,5,68,0,7,1,12,1,13,0,28,5,8,7,6,2,3,2,4,1,7,1,2,2,7,2,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,2,7,2,2,1,7,1,4,2,3,2,6,7,8,5,68,0,6,1,12,3,10,1,1,1,25,
5,8,7,6,2,3,2,4,1,7,1,2,2,7,2,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,2,7,2,2,1,7,1,4,2,3,2,6,7,8,5,68,0,5,2,0,1,8,6,8,1,0,2,25,5,8,7,6,2,3,2,4,1,7,1,2,2,7,2,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,2,7,2,2,1,7,1,4,2,3,2,6,7,8,5,68,0,20,1,1,1,9,1,1,1,25,5,8,7,6,2,3,2,4,1,7,1,2,2,7,2,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,1,9,1,1,2,7,2,2,1,7,1,4,2,3,2,6,7,8,5,68,0,84,1,4,1,2,2,2,2,3,2,0,2,5,4,7,2,7,4,5,2,0,2,3,2,2,2,2,1,4,1,85,0,68,5,8,7,0,1,3,2,3,3,3,1,6,2,3,1,5,3,2,1,5,1,1,1,1,1,4,1,2,1,1,1,3,1,3,1,1,1,3,1,3,1,1,1,2,1,4,1,1,2,0,1,4,2,2,3,5,1,3,3,3,3,3,10,3,1,1,5,68,0,3,1,12,1,12,0,21,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,3,1,4,1,4,8,6,4,60,0,5,1,10,1,11,0,22,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,3,1,4,1,4,8,6,4,60,0,5,1,10,3,8,1,1,1,18,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,3,1,4,1,4,8,6,4,60,0,17,1,1,1,7,1,1,1,18,1,6,1,2,1,6,1,2,1,
6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,2,1,6,1,3,1,4,1,4,8,6,4,60,0,6,1,9,1,10,0,18,2,7,1,0,1,7,1,1,1,5,1,2,2,3,2,3,2,1,2,5,1,1,1,7,3,8,3,9,1,10,1,10,1,10,1,10,1,10,1,10,1,56,0,53,1,10,1,10,1,10,7,4,8,3,1,4,2,2,1,5,1,2,1,5,1,2,1,5,1,2,1,4,2,2,8,3,7,4,1,10,1,10,1,60,0,51,3,6,5,4,2,2,1,3,1,3,1,3,1,3,1,3,1,2,1,4,1,1,1,5,1,1,1,5,1,2,2,3,1,3,2,2,1,5,1,1,1,5,1,1,1,0,1,2,1,1,1,1,4,2,1,2,2,49,0,46,1,9,1,9,0,18,4,3,7,2,1,3,1,8,1,6,3,3,6,2,3,1,1,2,1,3,1,2,1,2,2,2,7,3,3,1,1,44,0,48,1,7,1,8,0,19,4,3,7,2,1,3,1,8,1,6,3,3,6,2,3,1,1,2,1,3,1,2,1,2,2,2,7,3,3,1,1,44,0,47,1,7,3,5,1,1,1,16,4,3,7,2,1,3,1,8,1,6,3,3,6,2,3,1,1,2,1,3,1,2,1,2,2,2,7,3,3,1,1,44,0,46,2,0,1,3,6,3,1,0,2,16,4,3,7,2,1,3,1,8,1,6,3,3,6,2,3,1,1,2,1,3,1,2,1,2,2,2,7,3,3,1,1,44,0,56,1,1,1,4,1,1,1,16,4,3,7,2,1,3,1,8,1,6,3,3,6,2,3,1,1,2,1,3,1,2,1,2,2,2,7,3,3,1,1,44,0,25,2,6,0,2,0,5,0,2,0,5,0,2,0,6,2,17,4,3,7,2,1,3,1,8,1,6,3,3,6,2,3,1,1,2,1,3,1,2,1,2,2,2,7,3,3,1,1,44,0,128,0,146,4,1,4,4,13,2,1,3,2,3,1,6,3,5,1,2,14,1,4,0,9,1,1,
3,1,9,1,3,1,9,1,2,3,3,2,2,5,0,6,4,3,2,4,74,0,82,3,4,5,3,1,1,2,1,1,3,1,1,1,7,1,7,1,7,1,3,1,2,1,1,2,2,5,4,3,6,0,8,1,8,1,4,3,3,0,47,1,9,1,9,0,17,4,4,6,3,1,2,1,2,1,4,1,1,8,1,8,1,1,8,1,9,1,3,1,2,6,4,4,46,0,49,1,7,1,8,0,18,4,4,6,3,1,2,1,2,1,4,1,1,8,1,8,1,1,8,1,9,1,3,1,2,6,4,4,46,0,48,1,7,3,5,1,1,1,15,4,4,6,3,1,2,1,2,1,4,1,1,8,1,8,1,1,8,1,9,1,3,1,2,6,4,4,46,0,57,1,1,1,4,1,1,1,15,4,4,6,3,1,2,1,2,1,4,1,1,8,1,8,1,1,8,1,9,1,3,1,2,6,4,4,46,0,24,1,4,1,4,0,9,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,26,1,2,1,3,0,10,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,25,1,2,3,0,1,1,1,7,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,29,1,1,3,1,1,7,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,3,1,25,0,47,1,0,0,7,2,6,2,6,0,1,1,5,2,0,1,3,6,3,1,2,2,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,46,2,0,1,3,6,3,1,0,2,14,1,0,3,3,7,2,2,2,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,45,0,47,1,9,1,9,0,17,4,4,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,49,1,7,1,8,0,18,
4,4,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,48,1,7,3,5,1,1,1,15,4,4,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,46,2,0,1,3,6,3,1,0,2,16,4,4,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,57,1,1,1,4,1,1,1,15,4,4,6,3,1,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,2,1,2,1,3,6,4,4,46,0,92,1,8,1,15,9,0,9,15,1,8,1,80,0,83,1,4,5,3,5,3,2,0,2,3,1,1,3,2,1,0,1,0,1,2,1,0,1,0,1,2,3,1,1,2,3,1,1,3,1,1,2,3,5,3,1,0,2,4,0,41,0,46,1,9,1,9,0,16,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,2,2,2,7,3,3,0,1,45,0,48,1,7,1,8,0,17,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,2,2,2,7,3,3,0,1,45,0,47,1,7,3,5,1,1,1,14,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,2,2,2,7,3,3,0,1,45,0,56,1,1,1,4,1,1,1,14,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,2,2,2,7,3,3,0,1,45,0,44,1,6,1,7,0,14,1,5,3,5,1,0,1,3,1,1,1,3,1,1,2,2,1,2,1,1,1,3,1,1,1,4,1,0,1,4,3,6,2,6,2,6,1,6,2,4,
3,5,2,5,0,44,1,8,1,8,1,8,1,8,1,0,3,3,7,2,2,2,1,2,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,4,1,1,2,2,1,2,7,2,1,0,3,3,1,8,1,8,1,8,1,7,0,51,1,1,1,3,1,1,1,11,1,5,3,5,1,0,1,3,1,1,1,3,1,1,2,2,1,2,1,1,1,3,1,1,1,4,1,0,1,4,3,6,2,6,2,6,1,6,2,4,3,5,2,5,0,0,0);

sysfont__courier_new_10:array[0..9055] of byte=(
71,70,35,51,20,0,15,0,10,0,8,6,0,0,10,0,12,6,0,0,10,0,16,6,0,0,10,0,34,6,0,0,10,0,54,6,0,0,10,0,74,6,0,0,10,0,108,6,0,0,10,0,112,6,0,0,10,0,128,6,0,0,10,0,176,6,0,0,10,0,180,6,0,0,10,0,184,6,0,0,10,0,224,6,0,0,10,0,10,7,0,0,10,0,14,7,0,0,10,0,62,7,0,0,10,0,112,7,0,0,10,0,146,7,0,0,10,0,174,7,0,0,10,0,212,7,0,0,10,0,2,8,0,0,10,0,60,8,0,0,10,0,80,8,0,0,10,0,98,8,0,0,10,0,132,8,0,0,10,0,166,8,0,0,10,0,200,8,0,0,10,0,212,8,0,0,10,0,224,8,0,0,10,0,228,8,0,0,10,0,232,8,0,0,10,0,236,8,0,0,10,0,240,8,0,0,10,0,244,8,0,0,10,0,8,9,0,0,10,0,30,9,0,0,10,0,76,9,0,0,10,0,108,9,0,0,10,0,140,9,0,0,10,0,170,9,0,0,10,0,182,9,0,0,10,0,210,9,0,0,10,0,238,9,0,0,10,0,4,10,0,0,10,0,24,10,0,0,10,0,36,10,0,0,10,0,40,10,0,0,10,0,48,10,0,0,10,0,76,10,0,0,10,0,118,10,0,0,10,0,144,10,0,0,10,0,174,10,0,0,10,0,202,10,0,0,10,0,238,10,0,0,10,0,8,11,0,0,10,0,44,11,0,0,10,0,70,11,0,0,10,0,110,11,0,0,10,0,146,11,0,0,10,0,156,11,0,0,10,0,170,11,0,0,10,0,190,11,0,0,10,0,196,11,0,0,10,0,216,11,0,0,10,0,240,11,0,0,10,0,36,12,0,0,10,0,72,
12,0,0,10,0,108,12,0,0,10,0,138,12,0,0,10,0,176,12,0,0,10,0,212,12,0,0,10,0,242,12,0,0,10,0,20,13,0,0,10,0,60,13,0,0,10,0,82,13,0,0,10,0,112,13,0,0,10,0,152,13,0,0,10,0,180,13,0,0,10,0,238,13,0,0,10,0,36,14,0,0,10,0,74,14,0,0,10,0,104,14,0,0,10,0,152,14,0,0,10,0,190,14,0,0,10,0,224,14,0,0,10,0,2,15,0,0,10,0,42,15,0,0,10,0,80,15,0,0,10,0,144,15,0,0,10,0,182,15,0,0,10,0,214,15,0,0,10,0,248,15,0,0,10,0,20,16,0,0,10,0,48,16,0,0,10,0,76,16,0,0,10,0,94,16,0,0,10,0,99,16,0,0,10,0,109,16,0,0,10,0,137,16,0,0,10,0,177,16,0,0,10,0,201,16,0,0,10,0,241,16,0,0,10,0,9,17,0,0,10,0,33,17,0,0,10,0,73,17,0,0,10,0,113,17,0,0,10,0,135,17,0,0,10,0,163,17,0,0,10,0,201,17,0,0,10,0,225,17,0,0,10,0,19,18,0,0,10,0,53,18,0,0,10,0,83,18,0,0,10,0,123,18,0,0,10,0,163,18,0,0,10,0,185,18,0,0,10,0,209,18,0,0,10,0,233,18,0,0,10,0,11,19,0,0,10,0,41,19,0,0,10,0,91,19,0,0,10,0,121,19,0,0,10,0,159,19,0,0,10,0,181,19,0,0,10,0,209,19,0,0,10,0,237,19,0,0,10,0,9,20,0,0,10,0,21,20,0,0,10,0,71,20,0,0,1,0,101,20,0,0,10,0,103,20,0,0,10,0,117,
20,0,0,10,0,143,20,0,0,10,0,163,20,0,0,10,0,179,20,0,0,10,0,203,20,0,0,10,0,227,20,0,0,10,0,241,20,0,0,10,0,29,21,0,0,10,0,73,21,0,0,10,0,91,21,0,0,1,0,139,21,0,0,10,0,141,21,0,0,1,0,185,21,0,0,1,0,187,21,0,0,10,0,189,21,0,0,10,0,201,21,0,0,10,0,213,21,0,0,10,0,231,21,0,0,10,0,249,21,0,0,10,0,3,22,0,0,10,0,7,22,0,0,7,0,11,22,0,0,10,0,21,22,0,0,10,0,51,22,0,0,10,0,85,22,0,0,10,0,103,22,0,0,1,0,141,22,0,0,10,0,143,22,0,0,10,0,175,22,0,0,10,0,211,22,0,0,10,0,215,22,0,0,10,0,235,22,0,0,10,0,5,23,0,0,10,0,31,23,0,0,10,0,61,23,0,0,10,0,93,23,0,0,10,0,115,23,0,0,10,0,153,23,0,0,10,0,161,23,0,0,10,0,207,23,0,0,10,0,221,23,0,0,10,0,251,23,0,0,10,0,7,24,0,0,10,0,11,24,0,0,10,0,59,24,0,0,10,0,65,24,0,0,10,0,83,24,0,0,10,0,105,24,0,0,10,0,121,24,0,0,10,0,139,24,0,0,10,0,149,24,0,0,10,0,189,24,0,0,10,0,245,24,0,0,10,0,251,24,0,0,10,0,7,25,0,0,10,0,21,25,0,0,10,0,39,25,0,0,10,0,69,25,0,0,10,0,107,25,0,0,10,0,145,25,0,0,10,0,185,25,0,0,10,0,209,25,0,0,10,0,251,25,0,0,10,0,37,26,0,0,10,0,83,26,0,0,10,0,127,26,0,
0,10,0,167,26,0,0,10,0,215,26,0,0,10,0,9,27,0,0,10,0,47,27,0,0,10,0,89,27,0,0,10,0,131,27,0,0,10,0,177,27,0,0,10,0,217,27,0,0,10,0,245,27,0,0,10,0,17,28,0,0,10,0,49,28,0,0,10,0,75,28,0,0,10,0,113,28,0,0,10,0,175,28,0,0,10,0,219,28,0,0,10,0,7,29,0,0,10,0,55,29,0,0,10,0,101,29,0,0,10,0,143,29,0,0,10,0,165,29,0,0,10,0,219,29,0,0,10,0,9,30,0,0,10,0,55,30,0,0,10,0,105,30,0,0,10,0,149,30,0,0,10,0,187,30,0,0,10,0,217,30,0,0,10,0,9,31,0,0,10,0,43,31,0,0,10,0,77,31,0,0,10,0,115,31,0,0,10,0,151,31,0,0,10,0,183,31,0,0,10,0,223,31,0,0,10,0,255,31,0,0,10,0,31,32,0,0,10,0,61,32,0,0,10,0,91,32,0,0,10,0,125,32,0,0,10,0,153,32,0,0,10,0,177,32,0,0,10,0,201,32,0,0,10,0,229,32,0,0,10,0,251,32,0,0,10,0,35,33,0,0,10,0,77,33,0,0,10,0,113,33,0,0,10,0,149,33,0,0,10,0,189,33,0,0,10,0,227,33,0,0,10,0,5,34,0,0,10,0,13,34,0,0,10,0,55,34,0,0,10,0,95,34,0,0,10,0,135,34,0,0,10,0,179,34,0,0,10,0,217,34,0,0,10,0,5,35,0,0,10,0,51,35,0,0,0,128,0,199,0,128,0,199,0,99,4,8,0,8,0,8,0,8,0,8,0,8,0,8,0,24,0,23,0,8,0,8,0,8,0,8,0,8,0,8,0,8,
0,8,3,91,0,23,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,4,4,94,0,23,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,24,0,99,7,91,0,62,1,6,3,4,5,3,5,3,5,4,3,6,1,74,0,19,7,1,7,1,7,1,7,1,2,1,2,1,1,3,1,1,0,5,0,1,0,5,0,1,0,5,0,1,1,3,1,1,2,1,2,1,7,1,7,1,7,1,7,1,7,21,0,128,0,199,0,128,0,199,0,42,4,6,0,0,0,6,0,0,0,5,0,1,0,5,0,1,0,4,0,8,0,7,2,5,0,2,0,4,0,2,0,4,0,2,0,5,2,44,0,40,7,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,7,50,0,128,0,199,0,35,1,4,2,0,0,4,0,2,0,4,0,1,1,4,2,0,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,1,1,4,0,0,2,3,1,0,1,3,2,6,1,46,0,33,0,8,0,5,0,0,2,0,0,3,0,2,0,4,0,2,0,4,0,2,0,3,1,2,1,3,0,2,0,4,0,2,0,4,0,2,0,3,0,0,2,0,0,5,0,8,0,44,0,23,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,4,7,5,0,8,0,8,0,8,0,8,0,8,0,8,0,24,0,46,0,7,1,6,2,5,3,4,4,3,5,2,6,3,5,4,4,5,3,6,2,7,1,8,0,31,0,33,0,7,2,5,0,0,0,0,0,6,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,6,0,0,0,0,0,5,2,7,0,34,0,41,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,1,0,25,0,1,0,5,0,1,0,33,0,42,4,3,0,1,0,0,0,2,0,2,0,0,0,2,0,2,0,0,0,
2,0,2,0,0,0,3,0,1,0,0,0,4,2,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,41,0,23,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,4,7,91,0,99,7,5,0,8,0,8,0,8,0,8,0,8,0,8,0,24,0,23,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,4,4,8,0,8,0,8,0,8,0,8,0,8,0,8,0,24,0,33,0,7,2,5,0,0,0,0,0,6,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,34,0,23,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,3,5,0,8,0,8,0,8,0,8,0,8,0,8,0,24,0,84,0,9,0,3,6,7,0,7,0,73,0,82,0,7,0,7,6,3,0,9,0,75,0,128,0,199,0,128,0,199,0,128,0,199,0,128,0,199,0,128,0,199,0,44,0,8,0,8,0,8,0,8,0,8,0,8,0,27,2,6,2,52,0,42,1,0,1,4,1,0,1,4,0,1,0,5,0,1,0,5,0,1,0,112,0,43,0,1,0,5,0,1,0,4,0,1,0,5,0,1,0,3,7,3,0,1,0,5,0,1,0,3,7,3,0,1,0,5,0,1,0,4,0,1,0,5,0,1,0,43,0,44,0,6,4,3,0,3,0,3,0,8,0,9,3,9,0,8,0,3,0,3,0,3,4,7,0,8,0,8,0,33,0,42,1,6,0,1,0,5,0,1,0,6,1,10,1,5,1,5,1,10,1,6,0,1,0,5,0,1,0,6,1,52,0,63,2,5,0,8,0,9,0,7,1,6,0,1,0,0,0,3,0,2,0,4,0,2,0,5,2,0,1,50,0,43,2,6,2,7,0,8,0,8,0,113,0,46,0,7,0,8,0,8,0,7,0,8,0,8,0,8,0,8,0,9,0,8,0,8,0,9,0,31,0,41,0,9,0,8,0,8,0,9,0,8,0,8,0,8,0,8,0,7,0,8,0,8,0,7,0,36,0,44,0,8,0,
5,6,5,0,7,0,0,0,6,0,0,0,5,0,2,0,91,0,54,0,8,0,8,0,8,0,4,8,4,0,8,0,8,0,8,0,63,0,123,1,7,0,7,1,7,0,8,0,35,0,100,6,91,0,128,0,133,2,6,2,52,0,36,0,8,0,7,0,8,0,7,0,8,0,7,0,8,0,7,0,8,0,7,0,8,0,7,0,47,0,42,3,4,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,4,3,52,0,43,1,5,1,0,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,41,4,3,0,4,0,2,0,4,0,8,0,7,0,7,0,7,0,7,0,7,0,7,0,4,0,2,6,51,0,42,3,3,1,3,0,8,0,8,0,7,0,6,1,9,0,9,0,8,0,2,0,4,0,3,4,52,0,45,1,6,0,0,0,5,0,1,0,5,0,1,0,4,0,2,0,4,0,2,0,3,0,3,0,3,6,7,0,8,0,6,3,50,0,41,4,4,0,8,0,8,0,8,4,9,0,8,0,8,0,8,0,2,0,4,0,3,4,52,0,44,3,4,0,7,0,7,0,8,0,0,3,3,1,3,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,4,51,0,41,5,3,0,3,0,8,0,7,0,8,0,8,0,8,0,7,0,8,0,8,0,8,0,53,0,42,3,4,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,4,3,4,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,4,3,52,0,42,3,4,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,1,4,2,0,0,8,0,7,0,7,0,5,2,54,0,73,1,7,1,47,1,7,1,53,0,73,1,7,1,37,1,7,0,7,1,7,0,45,0,67,0,6,1,6,0,6,1,5,1,9,1,9,0,9,1,9,0,50,0,80,7,21,7,80,0,60,0,9,1,9,0,9,1,9,1,5,1,6,0,6,
1,6,0,57,0,52,3,4,0,3,0,3,0,3,0,8,0,7,0,7,0,8,0,17,1,7,1,53,0,33,3,4,0,3,0,2,0,4,0,2,0,4,0,2,0,2,2,2,0,1,0,1,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,2,2,2,0,8,0,9,0,2,0,5,2,42,0,50,4,7,1,6,0,1,0,5,0,1,0,5,0,1,0,4,0,3,0,3,5,3,0,3,0,2,0,5,0,0,2,3,2,49,0,50,5,4,0,3,0,3,0,3,0,3,0,3,0,3,4,4,0,3,0,3,0,4,0,2,0,4,0,2,0,4,0,1,6,51,0,52,3,0,0,2,0,3,1,1,0,5,0,1,0,8,0,8,0,8,0,8,0,9,0,4,0,3,4,51,0,50,5,4,0,3,0,3,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,3,0,2,5,52,0,50,7,2,0,4,0,2,0,4,0,2,0,1,0,5,3,5,0,1,0,5,0,4,0,2,0,4,0,2,0,4,0,1,7,50,0,50,7,2,0,4,0,2,0,4,0,2,0,1,0,5,3,5,0,1,0,5,0,8,0,8,0,7,4,53,0,52,3,0,0,2,0,3,1,1,0,8,0,8,0,8,0,2,4,0,0,5,0,1,0,5,0,2,0,4,0,3,4,51,0,50,2,2,2,1,0,4,0,2,0,4,0,2,0,4,0,2,6,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,1,2,2,2,49,0,51,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,52,5,6,0,8,0,8,0,8,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,4,3,53,0,50,2,1,2,2,0,3,0,3,0,2,0,4,0,1,0,5,0,0,0,6,3,5,0,2,0,4,0,2,0,4,0,3,0,2,2,2,1,50,0,50,4,6,0,8,0,8,0,8,0,8,0,8,0,3,0,3,0,3,0,3,0,3,0,1,7,50,0,49,2,3,2,0,1,3,1,1,
0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,1,1,1,0,1,0,1,1,1,0,1,0,5,0,1,0,5,0,0,2,3,2,49,0,50,2,2,2,1,1,3,0,2,0,0,0,2,0,2,0,0,0,2,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,2,0,0,0,2,0,2,0,0,0,2,0,3,1,1,2,2,1,50,0,53,2,5,0,2,0,3,0,4,0,1,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,1,0,4,0,3,0,2,0,5,2,52,0,51,5,4,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,4,4,0,8,0,8,0,7,4,52,0,53,2,5,0,2,0,3,0,4,0,1,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,1,0,4,0,3,0,2,0,5,2,6,0,8,2,1,0,2,0,2,1,20,0,50,5,4,0,3,1,2,0,4,0,2,0,4,0,2,0,3,0,3,4,4,0,2,0,4,0,3,0,3,0,4,0,1,2,3,1,49,0,52,2,0,0,3,0,2,1,3,0,3,0,3,0,9,3,9,0,8,0,3,0,3,0,3,1,2,0,3,0,0,2,52,0,50,8,0,0,2,0,2,0,0,0,2,0,2,0,0,0,2,0,2,0,4,0,8,0,8,0,8,0,8,0,6,4,51,0,50,2,2,2,1,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,0,5,2,52,0,49,2,3,2,0,0,5,0,2,0,3,0,3,0,3,0,3,0,3,0,4,0,1,0,5,0,1,0,5,0,1,0,6,1,7,1,53,0,50,3,0,3,1,0,4,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3,0,2,0,51,0,49,2,2,2,1,0,4,0,3,0,2,0,5,0,0,0,7,0,8,0,7,0,0,0,5,0,2,
0,3,0,4,0,1,2,2,2,50,0,50,2,2,2,1,0,4,0,3,0,2,0,5,0,0,0,6,0,0,0,7,0,8,0,8,0,8,0,6,4,51,0,50,6,2,0,4,0,2,0,3,0,3,0,2,0,7,0,8,0,7,0,2,0,3,0,3,0,2,0,4,0,2,6,51,0,44,2,6,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,2,31,0,30,0,9,0,8,0,8,0,9,0,8,0,9,0,8,0,9,0,8,0,9,0,8,0,9,0,41,0,42,2,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,6,2,33,0,44,0,8,0,7,0,0,0,5,0,2,0,3,0,4,0,110,0,128,0,189,9,0,43,0,9,0,9,0,128,0,132,0,72,3,4,0,3,0,8,0,3,5,2,0,4,0,2,0,4,0,2,0,3,1,3,3,0,1,50,0,40,1,8,0,8,0,8,0,0,2,4,1,2,0,3,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,1,2,0,2,1,0,2,52,0,72,3,0,0,2,0,3,1,1,0,8,0,8,0,8,0,9,0,4,0,3,4,51,0,45,1,8,0,8,0,4,2,0,0,3,0,2,1,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,1,4,2,0,1,50,0,72,3,4,0,3,0,2,0,5,0,1,7,1,0,8,0,9,0,4,0,3,4,51,0,44,3,4,0,8,0,6,5,5,0,8,0,8,0,8,0,8,0,8,0,6,5,51,0,72,2,0,1,2,0,2,1,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,1,4,2,0,0,8,0,7,1,3,3,23,0,40,1,8,0,8,0,8,0,0,2,4,1,2,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,2,1,2,50,0,34,0,8,0,26,2,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,34,0,8,0,25,4,8,
0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,4,3,23,0,40,1,8,0,8,0,8,0,1,3,2,0,2,0,4,0,1,0,5,0,0,0,6,2,6,0,1,0,5,0,2,0,3,1,1,3,50,0,42,2,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,69,1,0,0,0,1,3,1,0,1,0,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,1,0,1,0,1,2,0,1,0,1,50,0,70,1,0,2,4,1,2,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,2,1,2,50,0,72,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,52,0,70,1,0,2,4,1,2,0,3,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,1,2,0,3,0,0,2,4,0,8,0,7,2,25,0,72,2,0,1,2,0,2,1,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,1,4,2,0,0,8,0,8,0,7,2,20,0,71,1,1,1,4,2,1,0,3,0,8,0,8,0,8,0,8,0,7,5,51,0,71,3,0,0,2,0,3,1,2,0,9,4,9,0,8,0,2,0,4,0,2,5,52,0,52,0,8,0,6,6,4,0,8,0,8,0,8,0,8,0,8,0,3,0,4,3,51,0,70,1,2,1,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,1,4,2,0,1,50,0,70,2,1,2,2,0,3,0,3,0,3,0,4,0,1,0,5,0,1,0,5,0,1,0,6,1,7,1,53,0,69,2,4,1,0,0,6,0,0,0,2,0,2,0,1,0,1,0,1,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3,0,2,0,51,0,70,2,1,2,2,0,3,0,4,0,1,0,6,1,7,1,6,0,1,0,4,0,3,0,2,2,1,2,50,0,
69,3,2,2,1,0,4,0,2,0,4,0,3,0,2,0,4,0,2,0,5,0,0,0,6,0,0,0,7,0,8,0,7,0,5,4,23,0,71,5,3,0,3,0,7,0,7,0,7,0,7,0,7,0,3,0,3,5,51,0,44,0,7,0,8,0,8,0,8,0,8,0,7,0,9,0,8,0,8,0,8,0,8,0,9,0,33,0,44,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,33,0,43,0,9,0,8,0,8,0,8,0,8,0,9,0,7,0,8,0,8,0,8,0,8,0,7,0,34,0,91,1,6,0,1,0,1,0,6,1,82,0,29,4,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,4,44,0,52,3,0,0,2,0,3,1,1,0,5,0,0,6,3,0,7,6,3,0,8,0,9,0,4,0,3,4,51,0,19,0,128,0,133,1,7,0,7,1,7,0,8,0,25,0,55,3,4,1,7,0,8,0,6,4,6,0,8,0,8,0,8,0,8,0,7,1,4,3,34,0,128,0,132,1,0,1,4,0,1,0,4,1,0,1,4,0,1,0,33,0,128,0,129,1,0,1,0,1,1,1,0,1,0,1,51,0,44,0,8,0,8,0,5,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,53,0,44,0,8,0,8,0,5,6,5,0,8,0,8,0,5,6,5,0,8,0,8,0,53,0,33,0,7,0,0,0,5,0,2,0,128,0,142,0,40,0,7,0,0,0,6,0,0,0,7,0,3,1,5,2,4,1,18,0,2,0,3,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,3,0,2,0,51,0,11,0,2,0,5,0,0,0,7,0,17,2,0,0,3,0,2,1,3,0,3,0,3,0,9,3,9,0,8,0,3,0,3,0,3,1,2,0,3,0,0,2,52,0,73,0,7,0,7,0,7,0,8,0,9,0,9,0,9,0,
54,0,52,6,1,0,1,0,2,0,0,0,2,0,2,1,3,0,0,0,0,1,3,2,1,0,3,0,0,0,1,0,3,0,4,0,2,0,2,0,1,0,1,0,2,0,2,6,49,0,19,0,11,0,2,0,5,0,0,0,7,0,15,6,2,0,4,0,2,0,3,0,3,0,2,0,7,0,8,0,7,0,2,0,3,0,3,0,2,0,4,0,2,6,51,0,19,0,19,0,44,1,8,0,8,0,9,0,8,0,111,0,42,1,7,0,7,1,7,0,8,0,116,0,41,1,0,1,5,0,1,0,5,1,0,1,5,0,1,0,121,0,42,1,0,1,4,0,1,0,4,1,0,1,4,0,1,0,123,0,73,1,6,3,5,3,6,1,93,0,90,7,100,0,89,9,99,0,37,1,0,0,1,0,0,1,91,0,49,6,0,2,0,0,0,2,0,1,1,0,1,0,0,0,0,0,1,0,1,0,2,0,0,5,0,1,99,0,31,0,2,0,5,0,0,0,7,0,16,3,0,0,2,0,3,1,2,0,9,4,9,0,8,0,2,0,4,0,2,5,52,0,74,0,9,0,9,0,9,0,8,0,7,0,7,0,7,0,53,0,71,1,2,1,1,0,1,0,0,0,1,1,3,0,2,1,3,5,3,0,3,0,3,0,4,0,1,0,0,0,1,0,1,1,2,1,50,0,19,0,32,0,2,0,5,0,0,0,7,0,15,5,3,0,3,0,7,0,7,0,7,0,7,0,7,0,3,0,3,5,51,0,32,0,2,0,12,2,2,2,1,0,4,0,3,0,2,0,5,0,0,0,6,0,0,0,7,0,8,0,8,0,8,0,6,4,51,0,128,0,199,0,73,2,6,2,27,0,8,0,8,0,8,0,8,0,8,0,8,0,23,0,54,0,8,0,7,3,4,0,2,0,3,0,8,0,9,0,2,0,5,2,7,0,8,0,53,0,52,2,5,0,2,0,4,0,8,0,7,4,6,0,8,0,8,0,7,0,4,0,1,7,50,0,71,0,0,1,0,0,4,0,1,0,4,0,3,0,3,0,3,0,4,0,1,0,
4,0,0,1,0,0,71,0,50,2,2,2,1,0,4,0,3,0,2,0,5,0,0,0,6,0,0,0,4,6,5,0,5,6,5,0,6,4,51,0,44,0,8,0,8,0,8,0,8,0,38,0,8,0,8,0,8,0,8,0,33,0,52,4,3,0,3,0,3,0,3,0,2,3,5,0,1,2,3,1,3,1,3,2,1,0,5,3,2,0,3,0,3,0,3,0,3,4,42,0,41,0,2,0,128,0,152,0,52,3,4,0,3,0,2,0,1,2,0,0,0,0,1,0,1,0,1,1,1,0,4,1,1,0,4,1,1,0,4,0,0,0,1,2,0,0,2,0,3,0,4,3,52,0,42,2,8,0,5,3,5,0,1,0,5,4,112,0,83,1,1,1,2,1,1,1,2,1,1,1,2,1,1,1,4,1,1,1,4,1,1,1,4,1,1,1,49,0,89,8,8,0,8,0,8,0,8,0,60,0,100,6,91,0,52,3,4,0,3,0,2,0,0,3,0,0,0,0,2,0,0,0,1,1,2,1,2,1,2,1,2,1,2,0,0,0,1,0,0,0,0,2,0,1,2,0,3,0,4,3,52,0,29,9,128,0,159,0,33,2,5,0,2,0,4,0,2,0,4,0,2,0,5,2,122,0,54,0,8,0,8,0,8,0,4,8,4,0,8,0,8,0,8,0,4,8,49,0,43,1,6,0,1,0,8,0,7,0,7,0,7,3,102,0,43,2,5,0,1,0,6,1,9,0,5,0,1,0,6,1,103,0,45,0,7,0,7,0,128,0,134,0,70,1,2,1,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,1,3,3,0,1,2,0,8,0,8,0,26,0,42,5,1,1,1,0,0,0,2,0,2,0,0,0,2,0,2,0,0,0,2,1,1,0,0,0,4,2,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,4,2,0,1,40,0,85,1,7,1,101,0,128,0,154,0,8,1,8,0,6,2,12,0,44,0,6,2,8,0,8,0,8,
0,6,4,101,0,42,2,5,0,2,0,4,0,2,0,4,0,2,0,5,2,113,0,79,1,2,0,4,1,1,1,4,1,1,1,4,1,1,1,2,1,1,1,2,1,1,1,2,1,1,1,53,0,41,0,6,2,8,0,8,0,4,1,1,0,3,0,1,4,0,0,6,1,0,1,3,0,1,0,0,0,2,0,1,4,7,0,7,2,49,0,41,0,6,2,8,0,5,0,1,0,4,0,2,0,2,1,1,5,0,1,3,1,0,0,1,0,1,0,5,0,7,0,7,0,7,3,49,0,39,3,8,0,7,0,5,0,2,0,3,0,3,0,2,0,1,2,1,1,6,0,1,1,3,0,1,0,0,0,1,1,1,4,7,0,7,2,49,0,73,1,7,1,27,0,8,0,6,1,7,0,8,0,3,0,3,0,3,0,4,3,22,0,12,0,9,0,9,0,14,4,7,1,6,0,1,0,5,0,1,0,5,0,1,0,4,0,3,0,3,5,3,0,3,0,2,0,5,0,0,2,3,2,49,0,15,0,7,0,7,0,15,4,7,1,6,0,1,0,5,0,1,0,5,0,1,0,4,0,3,0,3,5,3,0,3,0,2,0,5,0,0,2,3,2,49,0,13,0,7,0,0,0,5,0,2,0,13,4,7,1,6,0,1,0,5,0,1,0,5,0,1,0,4,0,3,0,3,5,3,0,3,0,2,0,5,0,0,2,3,2,49,0,22,1,0,0,4,0,0,1,14,4,7,1,6,0,1,0,5,0,1,0,5,0,1,0,4,0,3,0,3,5,3,0,3,0,2,0,5,0,0,2,3,2,49,0,30,0,2,0,14,4,7,1,6,0,1,0,5,0,1,0,5,0,1,0,4,0,3,0,3,5,3,0,3,0,2,0,5,0,0,2,3,2,49,0,3,1,6,0,1,0,5,0,1,0,6,1,14,4,7,1,6,0,1,0,5,0,1,0,5,0,1,0,4,0,3,0,3,5,3,0,3,0,2,0,5,0,0,2,3,2,49,0,51,6,3,0,0,0,1,0,3,0,0,0,1,0,2,0,1,0,0,0,3,0,1,2,3,0,1,0,0,0,3,3,4,
0,2,0,1,0,1,0,2,0,1,0,0,2,0,4,50,0,52,3,0,0,2,0,3,1,1,0,5,0,1,0,8,0,8,0,8,0,8,0,9,0,4,0,3,4,6,0,8,1,8,0,6,2,12,0,12,0,9,0,9,0,14,7,2,0,4,0,2,0,4,0,2,0,1,0,5,3,5,0,1,0,5,0,4,0,2,0,4,0,2,0,4,0,1,7,50,0,15,0,7,0,7,0,15,7,2,0,4,0,2,0,4,0,2,0,1,0,5,3,5,0,1,0,5,0,4,0,2,0,4,0,2,0,4,0,1,7,50,0,14,0,7,0,0,0,5,0,2,0,12,7,2,0,4,0,2,0,4,0,2,0,1,0,5,3,5,0,1,0,5,0,4,0,2,0,4,0,2,0,4,0,1,7,50,0,31,0,2,0,13,7,2,0,4,0,2,0,4,0,2,0,1,0,5,3,5,0,1,0,5,0,4,0,2,0,4,0,2,0,4,0,1,7,50,0,13,0,9,0,9,0,14,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,16,0,7,0,7,0,15,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,14,0,7,0,0,0,5,0,2,0,13,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,32,0,2,0,13,6,5,0,8,0,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,50,5,4,0,3,0,3,0,4,0,2,0,4,0,1,4,1,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,3,0,2,5,52,0,23,1,0,0,4,0,0,1,13,2,2,2,1,1,3,0,2,0,0,0,2,0,2,0,0,0,2,0,2,0,1,0,1,0,2,0,1,0,1,0,2,0,2,0,0,0,2,0,2,0,0,0,2,0,3,1,1,2,2,1,50,0,13,0,9,0,9,0,16,2,5,0,2,0,3,0,4,0,1,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,1,0,4,0,3,0,2,0,5,2,52,0,15,0,7,0,
7,0,18,2,5,0,2,0,3,0,4,0,1,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,1,0,4,0,3,0,2,0,5,2,52,0,14,0,7,0,0,0,5,0,2,0,15,2,5,0,2,0,3,0,4,0,1,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,1,0,4,0,3,0,2,0,5,2,52,0,23,1,0,0,4,0,0,1,16,2,5,0,2,0,3,0,4,0,1,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,1,0,4,0,3,0,2,0,5,2,52,0,32,0,2,0,15,2,5,0,2,0,3,0,4,0,1,0,6,0,0,0,6,0,0,0,6,0,0,0,6,0,1,0,4,0,3,0,2,0,5,2,52,0,71,0,3,0,4,0,1,0,6,1,7,1,6,0,1,0,4,0,3,0,71,0,53,3,0,0,2,0,3,0,2,0,3,0,0,0,0,0,3,0,1,0,0,0,2,0,2,0,0,0,1,0,3,0,0,0,1,0,3,0,0,0,0,0,3,0,2,0,3,0,2,0,0,3,52,0,13,0,9,0,9,0,13,2,2,2,1,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,0,5,2,52,0,15,0,7,0,7,0,15,2,2,2,1,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,0,5,2,52,0,14,0,7,0,0,0,5,0,2,0,12,2,2,2,1,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,0,5,2,52,0,32,0,2,0,12,2,2,2,1,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,3,0,2,0,5,2,52,0,15,0,7,0,7,0,15,2,2,2,1,0,4,0,3,0,2,0,5,0,0,0,6,0,0,0,7,0,8,0,8,0,8,0,6,4,51,0,51,4,5,0,8,3,5,0,2,0,4,0,3,0,
3,0,3,0,3,0,2,0,4,3,5,0,7,4,52,0,42,2,5,0,2,0,4,0,2,0,4,0,2,0,4,0,1,0,5,0,2,0,4,0,3,0,3,0,3,0,3,0,1,0,0,0,3,0,1,0,0,0,2,2,1,0,52,0,33,0,9,0,9,0,15,3,4,0,3,0,8,0,3,5,2,0,4,0,2,0,4,0,2,0,3,1,3,3,0,1,50,0,35,0,7,0,7,0,17,3,4,0,3,0,8,0,3,5,2,0,4,0,2,0,4,0,2,0,3,1,3,3,0,1,50,0,34,0,7,0,0,0,5,0,2,0,14,3,4,0,3,0,8,0,3,5,2,0,4,0,2,0,4,0,2,0,3,1,3,3,0,1,50,0,43,1,0,0,4,0,0,1,15,3,4,0,3,0,8,0,3,5,2,0,4,0,2,0,4,0,2,0,3,1,3,3,0,1,50,0,51,0,2,0,15,3,4,0,3,0,8,0,3,5,2,0,4,0,2,0,4,0,2,0,3,1,3,3,0,1,50,0,23,1,6,0,1,0,5,0,1,0,6,1,16,3,4,0,3,0,8,0,3,5,2,0,4,0,2,0,4,0,2,0,3,1,3,3,0,1,50,0,70,2,1,1,5,1,0,0,5,0,2,0,1,7,0,0,2,0,4,0,2,0,4,0,2,1,1,0,1,6,51,0,72,3,0,0,2,0,3,1,1,0,8,0,8,0,8,0,9,0,4,0,3,4,6,0,8,1,8,0,6,2,12,0,32,0,9,0,9,0,16,3,4,0,3,0,2,0,5,0,1,7,1,0,8,0,9,0,4,0,3,4,51,0,35,0,7,0,7,0,17,3,4,0,3,0,2,0,5,0,1,7,1,0,8,0,9,0,4,0,3,4,51,0,34,0,7,0,0,0,5,0,2,0,14,3,4,0,3,0,2,0,5,0,1,7,1,0,8,0,9,0,4,0,3,4,51,0,51,0,2,0,15,3,4,0,3,0,2,0,5,0,1,7,1,0,8,0,9,0,4,0,3,4,51,0,32,0,9,0,9,0,16,2,8,0,8,0,8,0,8,0,8,0,8,0,5,6,
50,0,35,0,7,0,7,0,17,2,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,33,0,7,0,0,0,5,0,2,0,15,2,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,51,0,2,0,15,2,8,0,8,0,8,0,8,0,8,0,8,0,5,6,50,0,42,1,0,1,5,2,4,1,2,0,4,4,3,0,3,1,1,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,52,0,43,1,0,0,4,0,0,1,13,1,0,2,4,1,2,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,2,1,2,50,0,32,0,9,0,9,0,16,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,52,0,35,0,7,0,7,0,17,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,52,0,34,0,7,0,0,0,5,0,2,0,14,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,52,0,43,1,0,0,4,0,0,1,15,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,52,0,51,0,2,0,15,3,4,0,3,0,2,0,5,0,1,0,5,0,1,0,5,0,1,0,5,0,2,0,3,0,4,3,52,0,63,0,25,6,25,0,74,0,72,3,0,0,2,0,3,0,2,0,3,0,0,0,1,0,2,0,1,0,1,0,1,0,2,0,1,0,0,0,3,0,2,0,3,0,2,0,0,3,52,0,32,0,9,0,9,0,14,1,2,1,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,1,4,2,0,1,50,0,35,0,7,0,7,0,15,1,2,1,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,1,4,2,0,1,50,0,33,0,7,0,0,0,5,0,2,0,13,
1,2,1,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,1,4,2,0,1,50,0,51,0,2,0,13,1,2,1,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,0,2,1,4,2,0,1,50,0,36,0,7,0,7,0,13,3,2,2,1,0,4,0,2,0,4,0,3,0,2,0,4,0,2,0,5,0,0,0,6,0,0,0,7,0,8,0,7,0,5,4,23,0,40,1,8,0,8,0,8,0,0,2,4,1,2,0,3,0,4,0,2,0,4,0,2,0,4,0,2,0,4,0,2,1,2,0,3,0,0,2,4,0,8,0,7,2,25,0,52,0,2,0,11,3,2,2,1,0,4,0,2,0,4,0,3,0,2,0,4,0,2,0,5,0,0,0,6,0,0,0,7,0,8,0,7,0,5,4,23,0,0,0);

sysfont__courier_new_12:array[0..10339] of byte=(
71,70,35,51,22,0,17,0,12,0,8,6,0,0,12,0,12,6,0,0,12,0,16,6,0,0,12,0,40,6,0,0,12,0,60,6,0,0,12,0,80,6,0,0,12,0,118,6,0,0,12,0,124,6,0,0,12,0,140,6,0,0,12,0,192,6,0,0,12,0,196,6,0,0,12,0,200,6,0,0,12,0,244,6,0,0,12,0,38,7,0,0,12,0,42,7,0,0,12,0,100,7,0,0,12,0,162,7,0,0,12,0,200,7,0,0,12,0,232,7,0,0,12,0,18,8,0,0,12,0,72,8,0,0,12,0,142,8,0,0,12,0,162,8,0,0,12,0,186,8,0,0,12,0,224,8,0,0,12,0,4,9,0,0,12,0,42,9,0,0,12,0,54,9,0,0,12,0,66,9,0,0,12,0,70,9,0,0,12,0,74,9,0,0,12,0,78,9,0,0,12,0,82,9,0,0,12,0,86,9,0,0,12,0,108,9,0,0,12,0,132,9,0,0,12,0,186,9,0,0,12,0,224,9,0,0,12,0,8,10,0,0,12,0,48,10,0,0,12,0,64,10,0,0,12,0,98,10,0,0,12,0,132,10,0,0,12,0,154,10,0,0,12,0,178,10,0,0,12,0,194,10,0,0,12,0,200,10,0,0,12,0,210,10,0,0,12,0,242,10,0,0,12,0,36,11,0,0,12,0,66,11,0,0,12,0,100,11,0,0,12,0,132,11,0,0,12,0,172,11,0,0,12,0,208,11,0,0,12,0,252,11,0,0,12,0,26,12,0,0,12,0,74,12,0,0,12,0,116,12,0,0,12,0,130,12,0,0,12,0,148,12,0,0,12,0,172,12,0,0,12,0,178,12,0,0,12,0,202,12,0,0,12,0,228,12,0,0,12,0,30,13,0,0,12,
0,74,13,0,0,12,0,118,13,0,0,12,0,154,13,0,0,12,0,200,13,0,0,12,0,244,13,0,0,12,0,26,14,0,0,12,0,68,14,0,0,12,0,116,14,0,0,12,0,142,14,0,0,12,0,178,14,0,0,12,0,226,14,0,0,12,0,4,15,0,0,12,0,76,15,0,0,12,0,142,15,0,0,12,0,188,15,0,0,12,0,224,15,0,0,12,0,24,16,0,0,12,0,70,16,0,0,12,0,108,16,0,0,12,0,146,16,0,0,12,0,194,16,0,0,12,0,238,16,0,0,12,0,58,17,0,0,12,0,106,17,0,0,12,0,144,17,0,0,12,0,182,17,0,0,12,0,216,17,0,0,12,0,248,17,0,0,12,0,26,18,0,0,12,0,48,18,0,0,12,0,53,18,0,0,12,0,63,18,0,0,12,0,93,18,0,0,12,0,143,18,0,0,12,0,173,18,0,0,12,0,219,18,0,0,12,0,247,18,0,0,12,0,19,19,0,0,12,0,65,19,0,0,12,0,111,19,0,0,12,0,135,19,0,0,12,0,167,19,0,0,12,0,211,19,0,0,12,0,239,19,0,0,12,0,39,20,0,0,12,0,77,20,0,0,12,0,111,20,0,0,12,0,161,20,0,0,12,0,209,20,0,0,12,0,235,20,0,0,12,0,11,21,0,0,12,0,39,21,0,0,12,0,77,21,0,0,12,0,111,21,0,0,12,0,167,21,0,0,12,0,203,21,0,0,12,0,245,21,0,0,12,0,13,22,0,0,12,0,45,22,0,0,12,0,77,22,0,0,12,0,109,22,0,0,12,0,121,22,0,0,12,0,163,22,0,0,1,0,199,22,0,0,12,0,201,22,0,
0,12,0,217,22,0,0,12,0,247,22,0,0,12,0,15,23,0,0,12,0,31,23,0,0,12,0,61,23,0,0,12,0,91,23,0,0,12,0,105,23,0,0,12,0,151,23,0,0,12,0,199,23,0,0,12,0,219,23,0,0,1,0,19,24,0,0,12,0,21,24,0,0,1,0,69,24,0,0,1,0,71,24,0,0,12,0,73,24,0,0,12,0,89,24,0,0,12,0,105,24,0,0,12,0,129,24,0,0,12,0,153,24,0,0,12,0,165,24,0,0,12,0,171,24,0,0,9,0,177,24,0,0,12,0,189,24,0,0,12,0,231,24,0,0,12,0,17,25,0,0,12,0,37,25,0,0,1,0,87,25,0,0,12,0,89,25,0,0,12,0,123,25,0,0,12,0,169,25,0,0,12,0,173,25,0,0,12,0,195,25,0,0,12,0,225,25,0,0,12,0,1,26,0,0,12,0,35,26,0,0,12,0,73,26,0,0,12,0,99,26,0,0,12,0,145,26,0,0,12,0,157,26,0,0,12,0,215,26,0,0,12,0,237,26,0,0,12,0,19,27,0,0,12,0,33,27,0,0,12,0,39,27,0,0,12,0,101,27,0,0,12,0,107,27,0,0,12,0,127,27,0,0,12,0,153,27,0,0,12,0,173,27,0,0,12,0,195,27,0,0,12,0,205,27,0,0,12,0,251,27,0,0,12,0,61,28,0,0,12,0,69,28,0,0,12,0,81,28,0,0,12,0,99,28,0,0,12,0,123,28,0,0,12,0,161,28,0,0,12,0,207,28,0,0,12,0,253,28,0,0,12,0,47,29,0,0,12,0,73,29,0,0,12,0,123,29,0,0,12,0,173,29,0,0,12,0,227,29,0,0,12,
0,23,30,0,0,12,0,75,30,0,0,12,0,131,30,0,0,12,0,191,30,0,0,12,0,235,30,0,0,12,0,29,31,0,0,12,0,79,31,0,0,12,0,133,31,0,0,12,0,185,31,0,0,12,0,217,31,0,0,12,0,249,31,0,0,12,0,29,32,0,0,12,0,63,32,0,0,12,0,109,32,0,0,12,0,183,32,0,0,12,0,235,32,0,0,12,0,31,33,0,0,12,0,87,33,0,0,12,0,141,33,0,0,12,0,195,33,0,0,12,0,217,33,0,0,12,0,25,34,0,0,12,0,79,34,0,0,12,0,133,34,0,0,12,0,191,34,0,0,12,0,247,34,0,0,12,0,35,35,0,0,12,0,69,35,0,0,12,0,125,35,0,0,12,0,161,35,0,0,12,0,197,35,0,0,12,0,237,35,0,0,12,0,19,36,0,0,12,0,57,36,0,0,12,0,99,36,0,0,12,0,139,36,0,0,12,0,177,36,0,0,12,0,211,36,0,0,12,0,245,36,0,0,12,0,27,37,0,0,12,0,63,37,0,0,12,0,89,37,0,0,12,0,115,37,0,0,12,0,145,37,0,0,12,0,173,37,0,0,12,0,221,37,0,0,12,0,11,38,0,0,12,0,51,38,0,0,12,0,91,38,0,0,12,0,135,38,0,0,12,0,177,38,0,0,12,0,219,38,0,0,12,0,231,38,0,0,12,0,19,39,0,0,12,0,63,39,0,0,12,0,107,39,0,0,12,0,155,39,0,0,12,0,201,39,0,0,12,0,249,39,0,0,12,0,47,40,0,0,0,128,1,7,0,128,1,7,0,128,0,131,4,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,
0,18,0,39,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,4,122,0,39,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,4,126,0,39,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,18,0,128,0,131,8,122,0,98,2,7,4,5,6,4,6,4,6,5,4,7,2,89,0,35,8,2,8,2,8,2,8,2,8,2,2,2,2,2,1,4,1,2,0,6,0,2,0,6,0,2,0,6,0,2,1,4,1,2,2,2,2,2,8,2,8,2,8,2,8,2,8,2,8,14,0,128,1,7,0,128,1,7,0,63,4,9,1,8,0,0,0,8,0,0,0,7,0,1,0,7,0,9,0,10,0,8,2,7,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,7,2,42,0,48,9,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,9,60,0,128,1,7,0,53,2,5,2,1,0,5,0,3,0,5,0,3,0,5,0,1,2,5,2,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,2,1,4,1,1,2,3,2,1,2,3,2,1,1,4,1,44,0,51,0,10,0,7,0,1,0,1,0,4,0,0,2,0,0,5,0,2,0,6,0,2,0,6,0,2,0,5,1,2,1,5,0,2,0,6,0,2,0,6,0,2,0,5,0,0,2,0,0,4,0,1,0,1,0,7,0,10,0,42,0,39,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,6,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,18,0,55,0,9,1,8,2,7,3,6,4,5,5,4,6,3,7,4,6,5,5,6,4,7,3,8,2,9,1,10,0,38,0,51,0,9,2,7,0,0,0,0,0,
8,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,8,0,0,0,0,0,7,2,9,0,30,0,50,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,31,0,1,0,7,0,1,0,7,0,1,0,40,0,50,4,5,0,1,0,0,0,4,0,2,0,0,0,4,0,2,0,0,0,4,0,2,0,0,0,5,0,1,0,0,0,6,2,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,39,0,39,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,122,0,128,0,131,8,6,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,18,0,39,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,4,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,18,0,51,0,9,2,7,0,0,0,0,0,8,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,42,0,39,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,4,6,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,18,0,113,0,11,0,4,7,9,0,9,0,100,0,110,0,9,0,9,7,4,0,11,0,103,0,128,1,7,0,128,1,7,0,128,1,7,0,128,1,7,0,128,1,7,0,53,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,45,2,8,2,63,0,49,2,1,2,3,2,1,2,4,0,3,0,5,0,3,0,5,0,3,0,128,0,158,0,52,0,1,0,7,0,1,0,7,0,1,0,6,0,1,0,7,0,1,0,5,7,5,0,1,0,7,0,1,0,5,7,5,0,1,0,7,0,1,0,6,0,
1,0,7,0,1,0,7,0,1,0,52,0,52,0,9,4,5,0,3,0,4,0,10,0,10,0,11,3,11,1,10,0,4,0,4,0,4,0,3,1,4,5,8,0,10,0,10,0,41,0,50,2,7,0,2,0,6,0,2,0,6,0,2,0,7,2,12,1,6,2,6,1,12,2,7,0,2,0,6,0,2,0,6,0,2,0,7,2,63,0,75,3,6,0,10,0,10,0,11,0,9,0,0,0,1,0,4,0,1,0,0,0,5,0,2,1,5,0,3,0,5,1,1,1,6,2,1,1,61,0,51,2,8,2,8,2,9,0,10,0,10,0,128,0,149,0,55,0,10,0,9,0,10,0,9,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,11,0,10,0,11,0,10,0,26,0,50,0,10,0,11,0,10,0,11,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,9,0,10,0,9,0,10,0,31,0,52,0,10,0,10,0,7,6,7,0,10,1,8,0,0,0,7,0,2,0,123,0,76,0,10,0,10,0,10,0,10,0,6,8,6,0,10,0,10,0,10,0,10,0,65,0,128,0,171,2,8,1,9,1,8,1,9,1,9,0,31,0,128,0,133,7,121,0,128,0,171,2,8,2,8,2,64,0,56,0,9,0,10,0,9,0,10,0,9,0,10,0,9,0,10,0,9,0,10,0,9,0,10,0,9,0,10,0,44,0,51,3,6,0,3,0,5,0,3,0,4,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,0,5,0,3,0,6,3,63,0,52,1,6,2,0,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,7,6,61,0,51,3,6,0,3,0,4,0,5,0,10,0,10,0,9,0,9,0,9,0,9,0,9,0,9,0,9,0,5,0,3,7,61,0,51,3,5,1,3,0,11,0,10,
0,9,0,7,2,11,0,11,0,10,0,10,0,10,0,3,0,4,0,5,4,63,0,54,0,9,1,9,1,8,0,0,0,7,0,1,0,7,0,1,0,6,0,2,0,6,0,2,0,5,0,3,0,5,6,9,0,10,0,8,3,62,0,50,5,5,0,10,0,10,0,10,0,10,0,0,2,6,1,2,0,11,0,10,0,10,0,3,0,5,0,4,0,3,0,6,3,63,0,54,3,5,1,8,0,9,0,9,0,10,0,1,3,4,0,0,0,3,0,3,1,5,0,2,0,6,0,2,0,6,0,3,0,5,0,4,0,3,0,6,3,62,0,49,7,3,0,5,0,10,0,9,0,10,0,10,0,9,0,10,0,10,0,9,0,10,0,10,0,10,0,64,0,51,2,7,0,2,0,5,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,7,3,6,0,2,0,5,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,7,2,64,0,51,2,7,0,2,1,4,0,4,0,4,0,5,0,3,0,5,0,3,0,5,0,4,0,3,1,5,3,0,0,10,0,9,0,10,0,9,0,5,4,64,0,99,2,8,2,8,2,44,2,8,2,8,2,64,0,99,2,8,2,8,2,32,2,8,1,8,1,9,1,9,0,55,0,80,0,9,0,8,1,7,1,8,0,8,1,11,0,11,1,11,1,11,0,11,0,61,0,108,9,25,9,108,0,73,0,11,0,11,1,11,1,11,0,11,1,8,0,8,1,7,1,8,0,9,0,68,0,63,3,6,0,3,0,5,0,4,0,10,0,10,0,8,1,8,0,10,0,33,2,8,2,63,0,51,3,6,1,2,0,4,0,5,0,3,0,5,0,3,0,3,2,3,0,2,0,1,0,3,0,1,0,2,0,3,0,1,0,2,0,3,0,1,0,2,0,3,0,2,3,3,0,10,0,11,0,3,0,6,3,51,0,61,4,9,1,8,0,1,0,7,0,1,0,7,0,1,0,6,0,3,0,5,0,3,0,4,7,3,0,5,0,3,0,5,0,2,0,
7,0,0,3,3,3,59,0,60,7,5,0,4,0,4,0,4,0,4,0,4,0,4,0,3,0,5,5,5,0,4,0,4,0,5,0,3,0,5,0,3,0,5,0,3,0,4,0,2,7,62,0,63,3,1,0,3,0,3,2,2,0,6,0,1,0,10,0,10,0,10,0,10,0,10,0,11,0,6,0,3,0,4,0,5,4,62,0,61,6,5,0,4,0,4,0,4,0,4,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,0,4,0,4,0,3,6,62,0,60,9,3,0,5,0,3,0,5,0,3,0,2,0,6,0,2,0,6,4,6,0,2,0,6,0,2,0,6,0,5,0,3,0,5,0,3,0,5,0,1,9,60,0,60,9,3,0,5,0,3,0,5,0,3,0,2,0,6,0,2,0,6,4,6,0,2,0,6,0,2,0,6,0,10,0,10,0,8,5,64,0,63,3,0,0,4,0,3,1,3,0,5,0,2,0,10,0,10,0,10,0,3,4,1,0,6,0,2,0,6,0,3,0,5,0,4,0,4,0,5,4,62,0,59,4,1,4,1,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,7,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,1,4,1,4,59,0,61,6,7,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,7,6,62,0,63,6,8,0,10,0,10,0,10,0,10,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,7,2,64,0,60,3,1,4,2,0,4,0,4,0,3,0,5,0,2,0,6,0,1,0,7,0,0,0,8,3,7,0,2,0,6,0,3,0,5,0,3,0,5,0,4,0,2,3,3,2,59,0,61,4,8,0,10,0,10,0,10,0,10,0,10,0,10,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,2,8,60,0,59,2,4,2,1,1,4,1,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,
2,0,0,0,2,0,1,0,0,0,1,0,2,0,1,0,0,0,1,0,2,0,2,0,2,0,2,0,6,0,2,0,6,0,2,0,6,0,1,2,4,2,60,0,59,3,3,2,2,1,4,0,3,0,0,0,3,0,3,0,0,0,3,0,3,0,1,0,2,0,3,0,1,0,2,0,3,0,2,0,1,0,3,0,2,0,1,0,3,0,3,0,0,0,3,0,3,0,0,0,3,0,4,1,2,2,3,1,61,0,63,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,63,0,60,6,6,0,3,0,5,0,4,0,4,0,4,0,4,0,4,0,4,0,3,0,5,4,6,0,10,0,10,0,10,0,8,5,64,0,63,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,8,0,9,3,1,0,3,1,2,1,25,0,60,6,6,0,3,0,5,0,4,0,4,0,4,0,4,0,4,0,4,0,3,0,5,4,6,0,3,0,5,0,4,0,4,0,4,0,4,0,5,0,1,3,4,1,59,0,63,3,0,0,4,0,3,1,3,0,5,0,3,0,10,1,11,3,11,0,11,0,10,0,3,0,5,0,3,1,3,0,4,0,0,3,63,0,60,8,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,6,0,10,0,10,0,10,0,10,0,10,0,10,0,8,4,63,0,60,2,3,2,2,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,4,0,3,0,6,3,63,0,59,3,3,3,1,0,5,0,3,0,5,0,4,0,3,0,5,0,3,0,5,0,3,0,6,0,1,0,7,0,1,0,7,0,1,0,8,1,9,1,9,1,64,0,59,3,2,4,0,0,6,0,2,0,6,0,2,0,2,0,2,0,2,0,2,0,2,0,3,0,
1,0,1,0,4,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,5,0,2,0,63,0,59,3,2,3,2,0,4,0,5,0,2,0,6,0,2,0,7,0,0,0,9,0,9,0,0,0,7,0,2,0,6,0,3,0,4,0,4,0,3,0,6,0,1,3,2,3,60,0,60,3,2,3,1,0,6,0,3,0,4,0,5,0,2,0,7,0,0,0,8,0,0,0,9,0,10,0,10,0,10,0,10,0,8,4,62,0,61,7,3,0,5,0,3,0,4,0,4,0,3,0,10,0,9,0,9,0,9,0,10,0,3,0,4,0,4,0,3,0,5,0,3,7,61,0,52,3,7,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,3,26,0,49,0,11,0,10,0,10,0,11,0,10,0,11,0,10,0,11,0,10,0,11,0,10,0,11,0,10,0,11,0,37,0,49,3,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,7,3,29,0,64,1,8,0,1,0,7,0,1,0,6,0,3,0,4,0,5,0,128,0,145,0,128,0,251,11,0,51,0,11,0,11,0,128,0,184,0,99,4,5,0,4,0,10,0,10,0,5,5,4,0,4,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,48,1,10,0,10,0,10,0,10,0,1,3,4,0,0,0,3,0,3,1,5,0,2,0,6,0,2,0,6,0,2,0,6,0,2,1,5,0,2,0,0,0,3,0,2,1,1,3,62,0,99,4,0,0,3,0,4,1,2,0,6,0,2,0,10,0,10,0,10,0,6,0,3,0,4,0,5,4,62,0,55,1,10,0,10,0,10,0,4,3,1,0,3,0,3,2,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,
3,0,3,2,4,3,1,1,60,0,99,3,6,0,3,0,4,0,5,0,3,0,5,0,3,7,3,0,10,0,11,0,4,0,5,4,62,0,52,5,4,0,10,0,10,0,8,6,6,0,10,0,10,0,10,0,10,0,10,0,10,0,8,6,62,0,99,2,0,1,4,0,2,1,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,5,0,2,1,6,2,0,0,10,0,10,0,9,0,6,3,16,0,49,1,10,0,10,0,10,0,10,0,0,2,6,1,2,0,5,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,3,2,2,2,60,0,52,0,10,0,31,3,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,61,0,53,0,10,0,30,5,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,5,4,16,0,49,1,10,0,10,0,10,0,10,0,2,3,3,0,3,0,5,0,1,1,6,0,0,0,8,2,8,0,1,0,7,0,2,0,6,0,3,0,4,1,2,3,60,0,50,3,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,60,0,96,1,0,1,1,1,3,1,1,1,1,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,2,1,1,1,1,59,0,97,1,0,2,6,1,2,0,5,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,3,2,2,2,60,0,99,4,5,0,4,0,3,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,3,0,4,0,5,4,62,0,96,1,1,3,4,0,0,0,3,0,3,1,5,0,2,0,6,0,2,0,6,0,2,0,6,0,2,1,5,0,2,0,0,0,3,0,3,0,1,3,4,0,10,0,10,0,9,2,19,0,98,
3,1,1,2,0,3,0,0,0,2,0,5,1,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,3,0,3,2,4,3,1,0,10,0,10,0,10,0,9,2,12,0,98,1,1,2,5,0,0,0,2,0,4,1,9,0,10,0,10,0,10,0,10,0,9,5,62,0,98,4,0,0,3,0,4,1,3,0,5,0,4,4,11,0,11,0,3,0,5,0,3,1,3,0,4,0,0,3,63,0,63,0,10,0,10,0,8,7,5,0,10,0,10,0,10,0,10,0,10,0,10,0,3,1,5,3,62,0,96,1,4,1,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,95,3,3,3,1,0,5,0,4,0,3,0,5,0,3,0,5,0,3,0,6,0,1,0,7,0,1,0,8,1,9,1,64,0,95,2,4,3,0,0,6,0,2,0,2,0,2,0,2,0,2,0,2,0,3,0,1,0,1,0,4,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,5,0,2,0,63,0,96,3,1,3,2,0,5,0,4,0,3,0,6,0,1,0,8,1,8,0,1,0,6,0,3,0,4,0,5,0,2,3,1,3,60,0,95,3,3,3,1,0,5,0,3,0,4,0,5,0,3,0,5,0,3,0,6,0,1,0,7,0,1,0,8,1,9,1,9,0,10,0,9,0,7,4,17,0,97,7,3,0,4,0,9,0,9,0,9,0,9,0,9,0,9,0,5,0,3,7,61,0,66,1,8,0,10,0,10,0,10,0,10,0,10,0,8,1,11,0,10,0,10,0,10,0,10,0,10,0,11,1,26,0,52,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,41,0,62,1,11,0,10,0,10,0,10,0,10,0,10,0,11,1,8,0,10,0,10,0,10,0,10,0,10,0,8,1,30,0,122,1,8,0,1,
1,1,0,8,1,110,0,59,3,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,3,79,0,63,4,0,0,3,0,4,1,2,0,6,0,1,0,9,7,4,0,9,7,4,0,10,0,11,0,6,0,3,0,4,0,5,4,62,0,21,0,128,0,171,2,8,1,9,1,8,1,9,1,9,0,31,0,66,3,6,1,9,0,10,0,7,6,7,0,10,0,10,0,10,0,10,0,10,0,10,0,9,1,6,3,41,0,128,0,171,1,2,1,3,1,2,1,4,0,3,0,4,1,2,1,4,0,3,0,39,0,128,0,180,1,1,1,1,1,1,1,1,1,1,1,60,0,52,0,10,0,10,0,10,0,7,6,7,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,53,0,52,0,10,0,10,0,10,0,7,6,7,0,10,0,10,0,10,0,7,6,7,0,10,0,10,0,10,0,53,0,52,0,9,0,0,0,7,0,2,0,128,0,183,0,49,1,8,0,1,0,7,0,1,0,8,1,4,1,6,3,5,2,6,1,34,1,3,1,2,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,2,1,3,1,60,0,15,0,2,0,7,0,0,0,9,0,20,3,0,0,4,0,3,1,3,0,5,0,3,0,10,1,11,3,11,0,11,0,10,0,3,0,5,0,3,1,3,0,4,0,0,3,63,0,100,0,9,0,9,0,9,1,8,1,10,1,10,0,11,0,11,0,65,0,62,8,1,0,2,0,3,0,0,0,3,0,3,1,4,0,3,1,4,0,1,0,1,0,4,3,1,0,4,0,1,0,1,0,4,0,4,0,4,0,5,0,3,0,3,0,1,0,2,0,3,0,2,8,59,0,21,0,14,0,2,0,7,0,0,0,9,0,19,7,3,0,5,0,3,0,4,0,4,0,3,0,10,0,9,0,9,0,9,0,10,0,3,0,4,0,4,0,3,0,5,
0,3,7,61,0,21,0,21,0,52,2,9,1,9,1,10,1,9,1,10,0,128,0,146,0,51,2,8,1,9,1,8,1,9,1,9,0,128,0,151,0,48,1,2,1,5,1,2,1,5,0,3,0,5,1,2,1,5,0,3,0,128,0,157,0,51,1,2,1,3,1,2,1,4,0,3,0,4,1,2,1,4,0,3,0,128,0,159,0,99,2,7,4,6,4,6,4,7,2,112,0,128,0,132,8,121,0,128,0,131,11,119,0,48,1,1,0,2,0,1,1,128,0,135,0,59,4,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,2,0,2,0,2,0,1,2,0,2,0,2,128,0,143,0,50,0,2,0,7,0,0,0,9,0,20,4,0,0,3,0,4,1,3,0,5,0,4,4,11,0,11,0,3,0,5,0,3,1,3,0,4,0,0,3,63,0,101,0,11,0,11,0,10,1,10,1,8,1,9,0,9,0,9,0,64,0,98,1,2,1,3,0,1,0,0,0,1,0,1,0,3,0,3,0,0,0,3,0,3,0,0,0,3,5,0,0,3,0,5,0,3,0,6,0,1,0,0,0,2,0,2,1,2,2,60,0,21,0,51,0,2,0,7,0,0,0,9,0,18,7,3,0,4,0,9,0,9,0,9,0,9,0,9,0,9,0,5,0,3,7,61,0,27,1,1,1,5,1,1,1,14,3,2,3,1,0,6,0,3,0,4,0,5,0,2,0,7,0,0,0,8,0,0,0,9,0,10,0,10,0,10,0,10,0,8,4,62,0,128,1,7,0,100,2,8,2,45,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,16,0,65,0,10,0,10,0,8,4,5,0,3,0,4,0,10,0,10,0,11,0,3,0,6,3,9,0,10,0,64,0,62,2,7,1,1,0,6,0,2,0,6,0,10,0,11,0,8,5,7,0,10,0,10,0,9,0,4,0,3,7,62,0,86,0,0,2,
0,0,5,0,2,0,5,0,4,0,4,0,4,0,4,0,4,0,5,0,2,0,5,0,0,2,0,0,97,0,60,2,4,2,1,0,6,0,3,0,4,0,5,0,2,0,7,0,0,0,8,0,0,0,6,6,7,0,7,6,7,0,10,0,8,4,62,0,52,0,10,0,10,0,10,0,10,0,10,0,46,0,10,0,10,0,10,0,10,0,10,0,41,0,63,5,4,0,4,0,4,0,4,0,3,3,6,0,2,2,4,0,4,1,4,1,4,0,4,2,3,0,5,1,2,0,7,2,3,0,4,0,4,0,4,0,4,5,51,0,50,1,1,1,5,1,1,1,128,0,194,0,63,3,5,1,3,1,2,0,1,3,1,0,1,0,0,1,1,0,1,0,0,0,1,0,6,1,1,0,6,1,1,0,6,1,1,1,1,0,2,0,0,0,1,2,2,0,1,0,7,0,2,1,3,1,5,3,63,0,51,2,11,0,7,3,6,0,2,0,6,0,1,1,7,1,0,1,128,0,146,0,100,0,3,0,4,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,5,1,2,1,5,1,2,1,5,1,2,1,5,0,3,0,60,0,128,0,131,10,10,0,10,0,10,0,10,0,72,0,128,0,133,7,121,0,63,3,5,1,3,1,2,0,0,4,1,0,1,0,1,0,2,0,0,0,0,0,2,0,2,0,1,1,2,3,2,1,2,0,1,0,2,1,2,0,2,0,1,0,0,0,0,2,1,2,1,0,7,0,2,1,3,1,5,3,63,0,35,11,128,0,215,0,27,2,7,0,2,0,6,0,2,0,6,0,2,0,7,2,128,0,184,0,64,0,10,0,10,0,10,0,10,0,6,8,6,0,10,0,10,0,10,0,10,0,6,8,61,0,51,2,7,0,2,0,10,0,9,0,9,0,9,0,9,4,128,0,135,0,51,2,7,0,2,0,8,1,11,0,10,0,6,0,2,0,7,2,128,0,136,0,53,0,9,0,9,0,128,0,186,0,97,1,2,
1,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,2,1,5,3,0,1,4,0,10,0,10,0,10,0,19,0,51,7,2,0,1,0,1,0,3,0,2,0,1,0,3,0,2,0,1,0,3,0,2,0,1,0,4,0,1,0,1,0,5,2,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,4,3,1,2,47,0,114,1,9,1,128,0,134,0,128,0,209,0,10,1,10,0,8,2,15,0,53,0,8,2,10,0,10,0,10,0,10,0,8,4,128,0,134,0,51,3,6,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,6,3,128,0,147,0,96,0,3,0,5,1,2,1,5,1,2,1,5,1,2,1,5,1,2,1,3,1,2,1,3,1,2,1,3,1,2,1,4,0,3,0,64,0,49,0,8,2,10,0,10,0,7,0,1,0,6,0,2,0,4,1,1,4,1,0,8,1,1,1,4,0,2,0,0,0,2,1,2,0,1,0,7,4,9,0,9,2,59,0,49,0,8,2,10,0,10,0,6,1,1,0,5,0,3,0,3,1,2,4,0,0,0,2,4,1,0,0,2,0,2,0,6,0,1,0,6,0,9,0,9,0,9,4,59,0,48,2,7,0,2,0,10,0,8,1,6,0,3,0,3,1,0,0,2,0,2,0,3,2,2,0,8,1,1,1,4,0,2,0,0,0,2,1,2,0,1,0,7,4,9,0,9,2,59,0,99,2,8,2,45,0,10,0,8,1,8,0,10,0,10,0,4,0,5,0,3,0,6,3,15,0,15,0,11,0,11,0,18,4,9,1,8,0,1,0,7,0,1,0,7,0,1,0,6,0,3,0,5,0,3,0,4,7,3,0,5,0,3,0,5,0,2,0,7,0,0,3,3,3,59,0,18,0,9,0,9,0,19,4,9,1,8,0,1,0,7,0,1,0,7,0,1,0,6,0,3,0,5,0,3,0,4,7,3,0,5,0,3,0,5,0,2,0,7,0,0,3,3,3,59,
0,16,0,9,0,0,0,7,0,2,0,17,4,9,1,8,0,1,0,7,0,1,0,7,0,1,0,6,0,3,0,5,0,3,0,4,7,3,0,5,0,3,0,5,0,2,0,7,0,0,3,3,3,59,0,26,1,1,0,5,0,1,1,18,4,9,1,8,0,1,0,7,0,1,0,7,0,1,0,6,0,3,0,5,0,3,0,4,7,3,0,5,0,3,0,5,0,2,0,7,0,0,3,3,3,59,0,25,1,1,1,5,1,1,1,17,4,9,1,8,0,1,0,7,0,1,0,7,0,1,0,6,0,3,0,5,0,3,0,4,7,3,0,5,0,3,0,5,0,2,0,7,0,0,3,3,3,59,0,3,1,8,0,1,0,7,0,1,0,8,1,19,4,9,1,8,0,1,0,7,0,1,0,7,0,1,0,6,0,3,0,5,0,3,0,4,7,3,0,5,0,3,0,5,0,2,0,7,0,0,3,3,3,59,0,62,7,4,0,0,0,2,0,4,0,0,0,2,0,3,0,1,0,2,0,3,0,1,0,0,0,5,0,1,2,4,0,2,0,0,0,4,4,6,0,2,0,5,0,3,0,2,0,1,0,3,0,2,0,0,2,0,6,60,0,63,3,1,0,3,0,3,2,2,0,6,0,1,0,10,0,10,0,10,0,10,0,10,0,11,0,6,0,3,0,4,0,5,4,8,0,10,1,10,0,8,2,15,0,15,0,11,0,11,0,17,9,3,0,5,0,3,0,5,0,3,0,2,0,6,0,2,0,6,4,6,0,2,0,6,0,2,0,6,0,5,0,3,0,5,0,3,0,5,0,1,9,60,0,18,0,9,0,9,0,18,9,3,0,5,0,3,0,5,0,3,0,2,0,6,0,2,0,6,4,6,0,2,0,6,0,2,0,6,0,5,0,3,0,5,0,3,0,5,0,1,9,60,0,17,0,9,0,0,0,7,0,2,0,15,9,3,0,5,0,3,0,5,0,3,0,2,0,6,0,2,0,6,4,6,0,2,0,6,0,2,0,6,0,5,0,3,0,5,0,3,0,5,0,1,9,60,0,27,1,1,1,5,1,1,1,14,9,3,0,5,0,
3,0,5,0,3,0,2,0,6,0,2,0,6,4,6,0,2,0,6,0,2,0,6,0,5,0,3,0,5,0,3,0,5,0,1,9,60,0,15,0,11,0,11,0,18,6,7,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,7,6,62,0,18,0,9,0,9,0,19,6,7,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,7,6,62,0,16,0,9,0,0,0,7,0,2,0,17,6,7,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,7,6,62,0,26,1,1,1,5,1,1,1,16,6,7,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,10,0,7,6,62,0,61,6,5,0,4,0,4,0,4,0,4,0,5,0,3,0,5,0,2,4,2,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,0,4,0,4,0,3,6,62,0,27,1,1,0,5,0,1,1,15,3,3,2,2,1,4,0,3,0,0,0,3,0,3,0,0,0,3,0,3,0,1,0,2,0,3,0,1,0,2,0,3,0,2,0,1,0,3,0,2,0,1,0,3,0,3,0,0,0,3,0,3,0,0,0,3,0,4,1,2,2,3,1,61,0,15,0,11,0,11,0,20,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,63,0,18,0,9,0,9,0,21,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,63,0,17,0,9,0,0,0,7,0,2,0,18,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,63,0,27,1,1,0,5,0,1,1,19,3,6,0,3,0,4,0,5,0,2,
0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,63,0,26,1,1,1,5,1,1,1,18,3,6,0,3,0,4,0,5,0,2,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,1,0,7,0,2,0,5,0,4,0,3,0,6,3,63,0,98,0,3,0,6,0,1,0,8,1,9,1,8,0,1,0,6,0,3,0,98,0,63,3,1,0,3,0,3,1,3,0,4,1,2,1,4,0,0,0,1,0,4,0,1,0,1,0,3,0,2,0,1,0,2,0,3,0,1,0,2,0,3,0,1,0,1,0,3,1,2,1,4,0,3,1,3,0,3,0,1,3,4,0,57,0,15,0,11,0,11,0,17,2,3,2,2,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,4,0,3,0,6,3,63,0,18,0,9,0,9,0,18,2,3,2,2,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,4,0,3,0,6,3,63,0,17,0,9,0,0,0,7,0,2,0,15,2,3,2,2,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,4,0,3,0,6,3,63,0,26,1,1,1,5,1,1,1,15,2,3,2,2,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,4,0,3,0,6,3,63,0,18,0,9,0,9,0,18,3,2,3,1,0,6,0,3,0,4,0,5,0,2,0,7,0,0,0,8,0,0,0,9,0,10,0,10,0,10,0,10,0,8,4,62,0,60,5,7,0,10,0,10,5,5,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,5,5,0,10,0,8,5,64,0,51,2,7,0,2,0,6,0,2,0,6,0,2,
0,6,0,2,0,6,0,1,0,7,0,2,1,5,0,4,0,4,0,4,0,4,0,4,0,4,0,1,0,1,0,4,0,1,0,1,0,3,2,1,1,62,0,52,0,11,0,11,0,19,4,5,0,4,0,10,0,10,0,5,5,4,0,4,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,54,0,9,0,9,0,21,4,5,0,4,0,10,0,10,0,5,5,4,0,4,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,53,0,9,0,0,0,7,0,2,0,18,4,5,0,4,0,10,0,10,0,5,5,4,0,4,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,64,1,1,0,5,0,1,1,18,4,5,0,4,0,10,0,10,0,5,5,4,0,4,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,62,1,1,1,5,1,1,1,18,4,5,0,4,0,10,0,10,0,5,5,4,0,4,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,41,1,8,0,1,0,7,0,1,0,8,1,19,4,5,0,4,0,10,0,10,0,5,5,4,0,4,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,97,1,2,1,6,0,0,0,1,0,6,0,3,0,5,0,3,0,1,9,0,0,3,0,5,0,3,0,5,0,3,1,2,0,1,4,0,2,61,0,99,4,0,0,3,0,4,1,2,0,6,0,2,0,10,0,10,0,10,0,6,0,3,0,4,0,5,4,8,0,10,1,10,0,8,2,15,0,51,0,11,0,11,0,20,3,6,0,3,0,4,0,5,0,3,0,5,0,3,7,3,0,10,0,11,0,4,0,5,4,62,0,54,0,9,0,9,0,21,3,6,0,3,0,4,0,5,0,3,0,5,0,3,7,3,0,10,0,11,0,4,0,5,4,62,0,53,0,9,0,0,0,7,0,2,0,18,3,6,0,3,0,4,0,5,0,3,0,5,0,3,7,3,0,10,0,11,0,4,0,5,4,62,0,62,1,1,1,5,1,1,1,18,3,6,0,3,0,4,0,5,0,
3,0,5,0,3,7,3,0,10,0,11,0,4,0,5,4,62,0,50,0,11,0,11,0,19,3,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,61,0,52,0,9,0,9,0,21,3,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,61,0,51,0,9,0,0,0,7,0,2,0,18,3,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,61,0,61,1,1,1,5,1,1,1,17,3,10,0,10,0,10,0,10,0,10,0,10,0,10,0,6,8,61,0,51,1,0,1,7,2,6,1,1,0,11,0,5,3,1,0,3,0,3,2,2,0,5,1,2,0,6,0,2,0,6,0,2,0,6,0,2,0,5,0,4,0,4,0,5,4,63,0,64,1,1,0,5,0,1,1,16,1,0,2,6,1,2,0,5,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,4,0,3,2,2,2,60,0,52,0,11,0,11,0,19,4,5,0,4,0,3,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,3,0,4,0,5,4,62,0,54,0,9,0,9,0,21,4,5,0,4,0,3,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,3,0,4,0,5,4,62,0,53,0,9,0,0,0,7,0,2,0,18,4,5,0,4,0,3,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,3,0,4,0,5,4,62,0,64,1,1,0,5,0,1,1,18,4,5,0,4,0,3,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,3,0,4,0,5,4,62,0,63,1,1,1,5,1,1,1,17,4,5,0,4,0,3,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,2,0,6,0,3,0,4,0,5,4,62,0,88,1,9,1,30,7,30,1,9,1,76,0,99,3,1,0,2,1,3,1,2,1,4,1,2,0,4,0,1,0,1,0,2,1,2,0,1,0,1,
0,4,0,2,1,4,1,2,1,3,1,2,0,1,3,63,0,51,0,11,0,11,0,17,1,4,1,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,54,0,9,0,9,0,18,1,4,1,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,52,0,9,0,0,0,7,0,2,0,16,1,4,1,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,62,1,1,1,5,1,1,1,15,1,4,1,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,5,0,3,0,4,1,4,4,0,1,60,0,54,0,9,0,9,0,17,3,3,3,1,0,5,0,3,0,4,0,5,0,3,0,5,0,3,0,6,0,1,0,7,0,1,0,8,1,9,1,9,0,10,0,9,0,7,4,17,0,48,1,10,0,10,0,10,0,10,0,1,3,4,2,2,1,3,1,4,1,2,0,6,0,2,0,6,0,2,0,6,0,2,1,4,1,2,2,2,1,3,0,1,3,4,0,10,0,10,0,9,2,19,0,62,1,1,1,5,1,1,1,14,3,3,3,1,0,5,0,3,0,4,0,5,0,3,0,5,0,3,0,6,0,1,0,7,0,1,0,8,1,9,1,9,0,10,0,9,0,7,4,17,0,0,0);
}
//embedded fonts - end ---------------------------------------------------------


//background images ------------------------------------------------------------
back_none:array[0..0] of byte=(0);


back_plaster:array[0..21602] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,16,11,12,14,12,10,16,14,13,14,18,17,16,19,24,40,26,24,22,22,24,49,35,37,29,40,58,51,61,60,57,51,56,55,64,72,92,78,64,68,87,69,55,56,80,109,81,87,95,98,103,104,103,62,77,113,121,112,100,120,92,101,103,99,255,219,0,67,1,17,18,18,24,21,24,47,26,26,47,99,66,56,66,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,99,255,192,0,17,8,1,38,1,38,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,
153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,220,184,140,222,44,113,219,
24,132,100,239,115,130,25,120,235,143,207,173,96,221,92,79,167,94,22,141,140,114,12,171,49,31,124,19,159,226,29,122,127,156,214,167,218,109,108,85,227,137,26,87,124,23,32,149,224,103,29,125,63,66,106,164,48,46,177,125,39,159,185,31,1,134,209,133,0,112,125,242,114,59,246,169,99,70,130,220,91,27,72,37,146,234,8,229,142,52,44,207,32,200,202,142,167,60,231,159,206,171,234,23,197,45,113,15,154,141,32,85,12,73,24,234,73,238,58,99,158,249,227,165,102,93,143,177,79,44,51,131,42,39,62,96,202,176,200,28,237,239,192,253,106,116,31,107,210,246,203,33,135,231,34,32,228,146,20,38,237,160,103,191,249,237,72,13,141,62,4,142,206,55,148,49,154,85,5,164,147,230,36,144,51,207,249,233,89,111,166,207,117,44,207,111,36,106,177,179,13,206,252,179,6,231,60,112,122,246,244,250,212,49,193,119,53,236,87,80,207,190,85,25,218,236,126,98,50,219,72,207,176,227,138,233,109,35,100,72,216,195,18,153,62,105,61,67,30,125,243,201,52,214,160,97,234,112,65,3,65,111,110,251,165,66,237,243,156,231,56,234,64,199,65,210,
153,167,42,253,166,49,36,177,198,193,131,238,45,195,99,57,207,233,143,199,154,173,127,49,123,169,39,129,25,84,183,0,19,156,115,207,62,167,7,241,166,218,204,22,126,80,239,63,46,115,131,158,132,126,35,140,82,3,126,43,161,113,105,34,203,118,138,36,109,160,128,1,193,199,249,239,92,241,181,149,46,201,140,170,163,179,24,208,183,221,25,56,25,61,63,250,255,0,90,208,183,201,186,219,50,168,140,38,252,183,3,24,224,231,7,169,165,158,100,89,4,207,31,203,128,118,237,219,131,142,120,232,51,215,28,208,4,182,218,68,241,106,11,115,12,234,45,203,238,56,57,249,125,6,125,106,189,245,138,219,221,72,145,101,99,101,12,197,137,193,61,240,121,56,255,0,235,213,155,125,68,171,43,136,246,145,247,213,78,21,134,63,201,206,63,74,109,228,194,251,107,103,106,145,144,163,159,215,252,254,185,163,160,21,222,8,27,203,140,202,202,200,195,12,156,50,31,114,122,227,142,152,173,216,222,57,0,84,153,92,174,55,21,53,142,145,47,240,160,98,48,114,127,81,205,87,153,221,97,104,237,228,81,12,159,43,160,95,152,243,208,142,221,
249,247,239,66,208,11,247,186,181,177,133,146,41,93,203,110,27,144,12,116,234,15,245,168,237,175,45,152,43,226,79,48,140,49,99,184,3,235,156,231,61,63,207,21,153,21,176,141,2,237,231,239,5,36,103,191,165,60,40,149,192,92,51,159,188,6,104,187,3,165,85,142,71,44,164,57,92,140,14,199,167,248,254,180,139,28,152,117,152,6,89,50,27,11,131,233,207,175,20,219,24,188,168,149,217,220,229,112,20,30,0,250,127,159,231,78,189,154,72,109,218,116,228,5,200,94,185,57,255,0,61,251,85,8,134,214,17,96,151,44,92,178,12,18,165,49,211,61,9,235,212,126,53,51,182,39,3,168,25,200,239,158,63,250,255,0,165,83,91,248,220,37,172,247,8,243,72,229,2,174,28,16,88,128,78,56,232,7,30,253,42,120,33,242,84,249,160,22,3,36,131,215,215,250,210,25,52,162,45,164,73,30,65,234,7,95,211,154,100,79,40,117,204,44,163,31,194,217,192,30,160,244,252,51,78,142,72,230,151,9,150,41,215,3,63,175,67,77,155,83,179,183,251,243,142,78,62,64,91,7,223,29,40,2,85,62,108,76,37,135,129,194,131,130,79,3,252,72,252,42,59,91,118,182,93,134,
70,96,216,218,172,112,19,233,233,199,110,156,113,85,222,241,80,201,63,152,210,91,8,193,17,133,193,39,156,156,254,67,252,230,151,74,188,146,246,38,145,182,170,2,84,3,156,231,131,249,115,69,192,98,218,180,154,200,158,72,216,136,144,237,144,112,1,57,233,142,190,159,78,188,242,109,197,10,44,113,174,75,237,227,115,114,79,185,254,85,29,212,146,91,93,91,186,172,178,9,15,150,118,227,104,36,140,19,248,247,250,213,27,15,48,94,93,202,24,149,105,29,118,242,64,96,126,246,61,0,20,1,117,230,221,8,120,25,88,176,59,113,200,39,156,126,184,172,11,143,181,253,172,172,178,52,146,46,57,67,140,31,229,198,69,111,8,146,20,142,43,120,149,19,35,0,231,229,254,124,214,94,172,179,70,209,186,192,128,202,229,2,161,203,73,192,11,159,203,167,108,123,210,96,141,139,37,205,148,107,51,101,198,6,88,99,220,99,215,140,127,156,211,216,16,74,132,60,245,57,199,212,214,85,132,18,94,89,202,146,79,114,141,3,249,103,231,28,17,140,129,131,159,233,200,199,122,211,139,121,133,119,202,100,200,207,152,192,6,250,96,0,63,151,227,
205,49,18,22,218,197,120,25,56,245,62,184,170,26,173,164,50,236,142,234,232,69,19,17,133,207,60,117,35,219,156,147,206,0,236,51,155,251,80,149,103,25,32,16,167,174,61,127,144,170,19,90,91,234,119,83,136,238,75,60,97,85,215,5,130,28,228,122,100,253,225,248,154,0,117,197,160,16,180,151,132,25,48,54,135,124,0,221,118,128,48,15,127,115,84,237,35,141,238,7,154,4,72,220,176,45,247,142,120,228,253,106,85,150,206,226,120,252,133,103,135,229,98,87,118,64,80,112,78,225,211,7,167,255,0,170,150,238,33,230,18,185,10,192,48,44,121,231,145,144,65,238,167,175,233,64,22,50,151,5,74,91,17,212,40,192,61,56,201,231,223,243,161,172,154,53,15,203,30,167,35,167,29,58,230,169,68,241,199,34,79,25,49,186,183,166,71,185,235,220,19,158,159,133,106,163,172,193,33,156,33,222,187,149,0,108,17,142,255,0,225,64,11,108,177,91,195,184,73,149,118,44,11,113,214,138,138,242,123,87,30,84,146,132,85,57,4,28,103,142,49,142,162,138,96,102,190,201,165,134,210,246,38,87,24,77,200,220,182,113,140,246,233,223,39,233,233,
163,105,103,20,115,9,97,12,23,110,20,239,200,57,207,80,58,246,253,42,27,77,90,214,85,86,157,86,55,192,254,13,197,155,190,49,159,238,143,243,205,106,176,203,16,72,30,158,166,128,50,228,142,73,38,187,251,77,180,77,22,84,69,144,27,43,140,158,220,114,1,231,53,29,173,140,81,44,139,44,11,34,200,228,141,170,0,79,111,243,233,87,111,86,66,241,37,180,175,28,155,247,48,218,14,87,32,16,7,226,63,173,81,212,181,79,177,50,44,112,179,182,3,16,221,49,147,192,255,0,19,211,222,165,141,18,88,91,136,46,220,231,56,5,83,11,128,1,32,243,234,70,63,83,75,170,221,76,34,123,117,218,91,157,231,5,112,51,192,247,227,243,252,107,38,45,118,229,238,139,148,142,52,86,218,35,61,24,246,36,251,30,152,169,29,214,119,37,149,99,50,101,179,156,128,73,246,250,208,159,64,43,164,44,217,45,26,141,167,229,244,254,85,44,80,162,62,66,103,4,28,156,242,115,216,84,141,11,68,185,220,74,227,131,207,35,215,57,166,110,39,8,167,99,99,43,143,173,32,44,93,77,112,81,21,78,216,250,144,63,139,216,255,0,135,74,130,229,21,97,5,8,108,42,131,
128,1,4,231,63,92,99,175,189,72,165,151,110,55,16,123,159,206,137,147,207,101,40,131,105,108,31,155,39,31,135,214,152,16,71,230,18,1,36,38,58,3,244,237,249,84,219,157,6,89,72,94,129,179,140,241,255,0,214,171,81,217,236,88,242,140,219,211,27,152,16,20,14,228,142,57,230,160,84,87,201,66,1,28,0,221,122,127,245,241,138,0,141,157,210,37,85,99,181,122,158,231,158,41,161,78,29,216,161,56,249,114,50,79,115,199,245,169,222,44,163,40,145,48,160,13,163,169,29,255,0,151,95,106,83,10,168,220,249,222,173,247,73,237,215,60,208,5,116,204,159,116,140,30,72,94,114,126,164,127,250,170,104,225,82,223,48,60,243,216,83,177,31,152,66,228,21,234,172,112,122,244,167,51,12,39,149,201,10,119,14,184,254,180,196,78,151,187,93,16,48,68,12,1,124,243,143,198,155,60,55,44,237,110,136,172,91,4,183,114,51,199,242,254,117,72,149,123,168,132,196,42,23,27,247,113,197,106,217,105,173,105,35,186,78,197,72,198,210,123,224,114,127,95,206,128,50,167,179,185,138,231,114,101,100,71,220,178,247,56,227,161,237,90,208,249,
205,104,167,205,5,216,159,153,186,129,254,61,113,255,0,214,171,13,0,0,249,99,140,159,151,154,168,26,43,103,144,152,217,35,43,230,25,81,75,33,207,82,113,207,76,127,145,70,195,35,84,150,218,121,93,50,177,144,24,0,192,110,32,116,36,253,106,89,146,59,168,132,138,2,185,92,166,236,119,236,106,55,154,38,223,52,130,217,173,78,10,191,150,72,97,223,36,247,234,7,167,161,168,111,147,205,1,109,193,134,13,193,203,161,35,113,237,140,118,239,159,110,216,205,43,128,235,157,56,73,110,176,249,204,131,182,209,215,142,71,184,169,173,161,146,198,218,8,99,85,112,135,247,141,206,88,115,156,15,92,227,138,203,55,87,130,233,153,155,108,131,56,207,203,140,242,61,185,252,171,99,76,148,203,166,218,179,51,202,242,71,184,151,231,36,30,121,199,228,59,246,207,90,73,220,111,66,157,208,159,80,102,141,27,203,108,227,113,4,108,25,237,238,112,58,122,83,236,180,193,29,151,217,203,43,50,62,242,73,200,98,112,123,250,12,127,156,154,184,139,42,137,36,140,47,220,4,64,141,193,56,245,199,215,156,127,42,200,184,188,186,153,
68,82,62,206,242,52,103,13,215,238,241,208,126,188,81,234,35,69,39,222,178,187,21,84,70,219,184,250,247,252,121,252,115,81,5,150,127,40,249,3,59,176,36,80,1,143,13,198,51,159,79,204,116,230,136,112,52,200,227,155,229,64,55,187,168,35,129,200,31,151,7,131,237,86,226,242,157,114,132,178,174,2,96,238,7,233,131,199,255,0,170,152,18,70,240,137,89,80,162,179,54,93,118,140,183,29,120,252,57,252,40,201,243,36,220,129,16,14,29,136,193,255,0,14,255,0,227,215,13,150,96,177,155,136,195,201,133,217,229,170,253,230,221,143,243,237,158,181,28,76,111,45,24,220,35,42,202,72,49,114,54,128,72,235,128,121,226,152,134,189,224,137,131,52,145,36,76,126,83,230,12,18,14,15,127,90,108,58,125,177,134,117,12,92,93,55,152,206,188,142,185,24,61,59,228,126,53,156,250,116,144,198,29,36,18,60,114,249,153,67,220,123,127,123,32,117,173,105,174,82,4,30,116,136,174,160,22,81,156,158,123,15,192,255,0,94,148,33,152,118,239,41,184,68,135,96,101,36,151,136,49,45,215,183,115,215,208,212,203,110,247,11,26,163,9,29,207,
202,224,240,72,29,115,253,61,190,149,61,166,157,182,233,150,230,41,139,42,111,24,198,210,115,200,4,126,88,250,246,197,35,68,177,92,249,33,200,84,125,202,219,57,249,87,119,210,144,8,144,188,114,184,104,129,116,198,241,193,29,56,246,25,230,156,166,104,225,19,72,134,68,220,87,50,157,217,63,143,61,170,120,175,236,252,167,80,210,58,144,71,239,8,37,142,114,8,4,251,231,36,127,74,170,215,86,113,137,79,145,251,226,152,84,39,134,57,228,244,24,228,14,71,183,74,98,42,92,203,25,153,182,224,130,115,153,62,98,79,94,123,103,158,180,84,83,96,0,166,49,199,166,104,164,48,65,177,36,149,14,113,141,184,249,64,35,208,255,0,158,181,169,123,172,181,193,54,246,48,202,229,177,146,188,54,220,2,113,239,212,126,21,143,23,206,167,4,224,3,215,28,143,203,173,62,53,184,182,188,12,153,73,20,129,181,148,99,63,79,113,64,29,68,81,236,184,50,187,1,180,97,115,143,148,1,207,36,103,191,175,111,174,105,106,247,54,150,170,139,123,32,65,42,16,120,39,7,215,28,145,250,254,180,145,78,250,157,155,237,85,28,38,72,56,231,32,176,
3,208,125,121,231,143,92,239,16,105,229,236,22,234,92,172,203,41,82,65,59,72,232,14,57,231,1,121,235,235,210,155,216,21,174,58,61,52,153,218,63,52,41,57,216,113,156,128,70,79,234,63,58,109,226,11,123,133,69,144,22,85,27,179,140,6,62,153,237,76,211,53,85,146,40,132,208,47,153,2,133,89,122,238,231,7,28,112,118,254,125,241,79,189,47,44,139,32,220,84,240,1,94,64,207,78,158,213,35,106,206,196,169,33,112,170,29,72,85,192,13,254,125,250,211,216,160,10,51,201,56,234,122,250,138,175,1,116,39,43,180,240,184,207,66,77,78,85,92,18,160,156,28,158,41,161,7,200,177,182,115,193,0,3,223,214,151,33,20,182,87,39,24,3,175,62,255,0,149,86,55,27,36,229,177,131,131,145,156,10,149,88,99,60,30,120,4,242,127,194,128,30,192,239,27,24,51,47,204,14,8,42,125,191,78,105,155,49,243,47,94,234,79,74,119,24,228,28,231,191,24,20,167,114,140,110,24,35,167,67,64,14,80,229,179,144,24,231,191,56,7,174,63,17,65,94,118,140,12,12,158,121,61,250,123,212,64,48,148,96,130,21,134,9,239,210,164,243,2,50,224,134,228,252,163,
28,99,7,30,244,0,217,28,166,236,18,56,228,245,197,64,210,43,12,41,32,0,113,134,239,254,125,234,220,174,210,158,54,144,122,143,203,181,80,110,101,96,16,103,39,130,189,79,60,31,74,24,9,50,135,86,108,133,57,199,35,233,86,180,217,231,89,96,141,101,109,190,96,12,138,188,243,158,72,238,58,243,233,244,21,81,154,82,9,25,40,228,131,187,216,115,252,243,249,82,68,31,8,223,58,54,120,37,143,95,80,115,244,160,14,158,107,168,227,149,45,153,183,72,235,234,58,115,146,125,58,26,161,127,106,154,164,171,27,121,143,10,130,187,208,253,195,199,76,247,199,225,249,26,165,5,156,147,74,37,102,37,221,185,102,57,35,143,95,165,107,90,90,45,148,111,26,76,197,25,183,29,199,56,56,199,3,165,48,51,244,181,251,84,51,164,209,70,214,81,72,4,42,135,229,24,39,35,61,91,168,57,61,106,221,227,220,90,218,74,182,240,153,51,242,168,219,144,57,239,142,189,127,65,193,230,173,71,28,113,22,40,171,185,201,102,40,160,100,241,201,255,0,62,148,177,72,90,5,243,134,11,96,50,129,145,158,156,123,80,6,100,90,115,206,131,123,225,89,122,
182,75,103,167,92,214,133,172,34,27,120,160,121,4,134,52,3,39,3,3,232,58,15,240,169,110,54,45,187,23,37,21,70,78,211,143,127,243,205,100,71,170,92,33,70,16,161,140,100,50,2,115,142,220,254,95,94,180,180,65,185,174,21,35,144,20,69,86,192,92,123,14,131,245,253,106,138,105,209,27,150,152,51,72,78,236,29,220,46,73,227,223,169,166,217,234,45,115,114,33,158,5,59,139,96,169,206,209,216,48,252,249,246,30,181,163,187,44,202,62,81,235,192,31,74,55,13,138,210,217,196,175,24,103,93,229,190,64,196,2,113,207,21,99,3,251,255,0,55,215,4,211,34,129,45,213,100,192,220,223,43,227,220,142,121,61,185,245,62,158,242,150,14,9,35,113,207,4,255,0,158,59,211,73,32,184,215,33,114,135,32,55,92,226,146,40,246,28,225,114,195,146,57,200,231,25,63,137,167,55,57,5,122,247,254,148,155,89,91,3,140,115,235,138,4,53,209,54,254,237,0,25,59,184,244,254,89,172,233,180,185,175,47,132,142,232,145,168,1,118,157,205,129,239,235,214,181,9,82,55,12,140,250,175,231,76,19,71,231,198,129,134,100,7,104,232,73,29,64,252,61,232,
2,174,161,45,202,169,48,12,200,120,93,145,29,234,48,51,207,212,122,122,122,86,89,182,185,156,139,183,77,229,129,5,206,6,48,58,241,208,117,231,218,186,60,183,32,17,207,42,115,214,178,53,75,213,142,53,182,182,10,171,141,174,138,1,192,227,0,127,44,123,226,129,153,206,142,227,105,230,64,71,115,145,142,63,17,254,52,139,17,137,247,18,185,63,49,92,156,243,87,180,253,53,110,24,51,187,50,38,73,28,245,232,57,250,115,254,21,60,250,107,27,70,216,3,76,170,118,175,102,57,247,252,58,154,86,3,33,152,51,176,119,198,56,0,30,71,235,210,138,173,20,200,67,43,33,4,30,140,48,127,30,13,20,5,142,143,73,179,54,241,238,13,17,102,35,230,65,233,213,79,227,159,243,197,75,117,96,183,23,134,89,156,121,97,20,4,198,50,65,39,39,243,197,73,27,157,128,188,88,98,79,3,156,115,199,165,72,204,71,115,205,80,134,90,89,195,104,93,163,27,76,132,150,193,227,169,60,14,131,169,170,215,90,157,188,23,34,218,64,146,198,65,222,152,220,79,79,94,6,61,205,76,204,217,124,130,74,240,57,252,106,59,107,8,4,91,222,32,174,121,98,122,138,
64,80,178,209,86,57,46,76,142,72,47,251,174,153,32,28,146,64,239,254,113,82,73,48,70,107,116,59,130,12,124,160,12,103,175,245,53,171,141,184,0,142,157,123,154,207,188,181,193,105,91,118,222,75,109,235,129,207,227,250,80,198,103,22,1,182,133,231,174,65,247,255,0,63,157,73,19,17,187,242,235,75,20,30,99,177,65,242,131,200,200,60,245,253,106,195,91,70,136,178,0,6,6,118,224,131,207,244,164,5,27,132,40,252,245,110,7,31,231,252,253,42,88,128,25,44,9,29,120,62,223,231,243,169,88,13,204,0,36,175,3,35,57,247,160,42,228,5,220,1,94,184,239,64,3,49,18,109,8,81,148,122,103,61,176,42,88,173,166,156,29,187,70,63,137,143,57,237,254,126,181,12,131,100,121,92,0,58,227,214,155,14,160,17,134,224,79,25,83,187,215,29,5,48,38,158,39,135,111,152,206,249,7,5,120,193,233,143,126,222,149,45,194,217,110,43,26,72,160,16,67,227,142,113,201,231,63,202,170,220,93,139,137,28,128,21,119,1,128,114,126,188,241,68,215,98,69,8,65,5,91,39,60,126,98,141,0,158,91,120,97,153,210,54,204,106,187,128,102,237,215,191,191,
227,79,91,56,166,18,59,40,140,179,124,140,6,65,247,231,161,206,106,91,55,179,12,34,243,17,157,206,23,35,142,159,151,235,207,21,124,68,170,161,122,129,217,70,40,176,28,237,189,135,159,28,179,9,100,92,201,132,86,81,146,58,115,254,123,26,182,109,33,182,135,204,117,44,19,0,133,28,158,223,143,165,92,155,228,150,73,29,219,108,104,112,170,7,83,250,230,171,106,23,101,108,209,213,18,112,91,33,128,249,72,201,198,121,255,0,36,118,233,72,9,154,34,96,196,28,54,65,82,125,65,7,156,82,193,185,118,242,50,204,91,3,59,84,116,10,56,244,31,158,126,149,66,215,85,154,238,104,173,133,184,71,35,45,34,140,0,184,200,56,231,29,191,201,171,91,229,5,150,28,151,81,229,135,57,235,215,161,60,241,142,126,180,1,108,186,54,226,58,246,230,156,9,32,255,0,15,184,3,53,21,185,118,132,51,160,87,238,49,138,113,249,195,97,184,166,33,46,96,134,64,169,42,150,92,238,0,103,239,122,241,245,166,174,157,110,114,60,190,167,60,243,252,207,20,146,44,204,234,145,204,84,19,150,232,72,29,241,82,187,157,165,35,125,141,216,145,156,126,
127,90,67,28,2,164,91,101,11,183,56,1,73,199,39,3,241,60,82,198,152,82,118,21,36,228,134,57,63,94,51,215,138,174,94,88,161,220,243,6,43,201,59,70,49,143,111,167,235,77,68,104,196,197,7,204,126,108,22,39,156,147,192,247,39,241,166,5,178,25,152,131,130,8,164,121,35,141,7,153,156,103,128,107,157,75,249,172,45,46,160,243,144,78,172,26,16,80,100,130,121,206,50,9,199,175,169,244,173,77,46,120,239,52,232,214,121,226,154,64,55,72,21,185,82,73,199,29,71,255,0,90,139,136,208,71,71,67,176,143,161,52,216,118,74,60,197,85,108,41,1,192,206,65,199,127,78,148,216,246,228,170,198,81,16,224,57,63,120,245,63,135,79,202,149,54,199,16,72,182,42,39,76,112,61,105,128,215,146,24,75,249,178,34,176,0,157,196,110,3,56,207,211,38,165,65,16,117,43,247,179,158,181,9,85,144,239,69,234,51,184,14,163,235,81,176,145,27,131,242,130,125,56,164,50,232,117,146,49,34,227,7,154,204,158,11,111,54,22,253,228,115,54,199,29,182,156,142,123,140,244,7,25,171,59,4,156,72,50,127,47,243,218,134,128,4,80,163,104,4,145,245,254,
159,133,23,17,57,148,21,83,200,98,56,44,7,28,119,31,149,49,132,201,28,184,145,93,183,100,6,31,40,31,221,252,184,207,62,188,244,170,214,183,2,230,34,200,49,177,177,133,96,121,28,227,142,135,166,65,230,164,242,212,169,78,118,55,24,207,98,58,81,112,33,184,185,146,36,2,221,32,114,73,221,133,32,238,4,130,79,62,223,161,162,172,110,219,128,172,65,236,7,165,20,174,4,73,40,123,233,97,3,110,192,54,156,231,61,61,184,165,154,52,151,106,202,196,174,224,219,114,113,193,200,250,242,5,74,160,19,200,28,243,159,74,113,10,249,59,79,61,73,167,96,33,221,182,7,27,201,44,79,204,59,122,126,66,167,145,136,206,227,207,78,58,138,129,66,249,188,56,206,6,229,31,143,52,199,187,141,25,218,95,221,42,240,11,113,191,232,59,255,0,250,168,2,73,103,9,3,204,171,189,149,78,121,199,215,7,177,166,91,74,237,10,203,46,23,36,237,3,60,142,221,127,201,235,223,20,232,115,50,201,20,139,180,31,186,73,31,50,158,248,234,63,250,226,165,8,165,16,49,201,78,159,203,250,208,4,55,16,165,194,13,164,171,129,242,156,127,63,111,111,106,
175,110,241,3,182,73,19,205,4,231,140,126,21,114,120,85,147,247,152,0,156,115,199,53,90,55,141,247,49,24,36,0,95,167,210,129,144,93,21,85,206,54,128,7,24,233,85,252,193,202,231,24,231,158,127,207,231,90,55,144,179,91,152,204,229,91,0,150,10,112,121,246,250,244,170,22,209,44,171,33,220,193,83,228,203,12,96,255,0,158,59,210,1,198,65,36,120,233,187,158,15,63,143,227,84,202,156,224,0,160,119,110,255,0,136,235,218,173,11,103,154,231,10,22,49,215,145,142,131,63,231,138,208,125,58,221,87,14,238,170,118,169,233,146,78,0,237,239,69,155,3,19,111,151,34,18,21,73,244,31,123,241,167,180,139,146,193,215,4,130,50,115,159,241,168,53,31,58,203,80,100,149,50,172,119,41,24,33,134,79,63,94,105,146,227,230,50,43,164,139,192,13,199,225,245,235,64,23,109,100,142,41,33,243,88,132,73,51,187,96,207,28,227,159,203,252,138,184,53,23,190,212,18,56,35,113,18,22,98,20,242,216,28,19,232,51,142,190,181,148,25,25,80,33,124,145,131,158,64,56,255,0,38,155,20,146,90,93,121,145,170,111,92,140,58,142,15,126,152,199,
95,175,106,96,116,77,8,158,44,137,51,230,128,121,3,211,183,235,235,215,233,77,179,128,219,3,7,202,241,169,221,30,224,119,14,73,57,231,158,216,224,83,149,197,253,186,74,185,88,247,134,218,120,44,7,98,49,235,159,175,173,72,164,200,128,49,229,186,41,60,15,79,243,245,160,8,162,130,53,119,112,177,9,92,183,239,21,64,207,60,130,122,231,142,125,234,66,202,37,203,17,140,126,63,159,227,78,145,198,238,65,27,189,63,206,41,216,86,92,168,31,92,115,64,134,7,82,248,195,2,48,121,238,62,180,214,66,95,3,121,94,184,4,140,251,82,203,251,181,82,172,23,28,156,116,35,189,32,114,248,43,146,7,67,216,210,99,3,111,1,36,148,70,39,142,126,110,135,167,230,41,197,176,72,234,75,102,163,102,153,96,7,106,130,9,24,7,61,248,165,101,84,102,124,145,158,155,135,2,128,27,44,106,74,180,152,38,60,149,39,183,227,78,242,196,152,12,84,129,201,24,227,218,135,249,221,162,12,187,148,141,224,156,237,4,113,254,77,63,113,137,50,228,96,119,61,168,2,133,198,156,146,94,164,230,48,209,128,67,46,6,79,24,28,231,182,122,142,127,74,123,
105,150,242,66,97,242,209,85,95,35,3,57,198,72,13,158,160,103,215,191,106,188,1,56,244,239,81,170,249,108,238,164,225,219,113,199,61,177,211,159,65,69,128,146,49,133,194,182,66,156,115,201,227,212,254,6,154,251,9,85,43,157,217,33,113,144,70,58,31,78,181,5,186,165,185,144,32,218,174,251,182,133,199,56,193,169,150,85,45,128,126,92,124,217,227,174,105,220,9,119,22,7,32,54,58,85,72,162,43,12,17,249,143,188,29,227,158,72,7,56,57,246,192,252,106,80,251,25,159,121,3,30,189,249,200,199,249,253,40,46,120,61,113,156,53,0,54,226,217,37,144,74,205,183,96,7,29,1,193,200,253,70,113,236,42,24,110,149,141,209,129,49,176,255,0,171,43,215,57,59,134,7,114,127,74,5,236,82,200,171,30,247,147,110,74,129,247,115,129,158,126,181,94,19,36,49,201,116,85,160,9,203,174,114,74,1,147,237,238,62,166,144,20,69,246,165,10,152,149,17,94,110,17,222,46,65,36,242,7,3,191,124,214,196,168,200,165,34,219,185,254,102,39,175,190,57,235,233,158,195,25,226,161,139,83,183,107,54,190,6,79,47,118,29,72,251,167,140,126,191,
207,219,133,211,175,86,246,23,18,178,182,27,110,1,221,184,16,8,200,3,182,224,15,184,167,96,184,182,162,234,66,197,228,222,132,12,50,156,109,60,228,16,7,94,70,114,40,169,173,158,25,163,121,161,84,1,156,174,241,198,236,28,125,123,99,240,162,139,1,51,51,146,171,26,224,177,31,120,246,239,250,102,158,185,198,210,184,56,170,207,4,45,122,147,200,65,96,165,81,89,65,199,32,228,28,112,121,199,255,0,170,155,115,124,182,215,40,110,25,35,183,110,3,18,114,92,145,142,157,23,131,146,120,233,248,177,19,177,220,192,36,138,8,127,155,0,18,59,227,219,183,231,74,167,141,219,176,91,159,155,168,167,51,162,74,34,99,146,122,3,207,28,15,243,154,70,27,152,41,11,158,167,223,175,229,218,152,14,137,0,145,164,80,9,112,1,43,140,156,116,207,231,74,229,216,178,198,193,78,49,243,2,121,252,198,71,181,44,125,9,32,237,237,239,78,36,103,36,244,238,123,210,2,181,204,119,13,27,121,51,34,147,193,227,35,31,254,170,173,10,92,219,126,237,81,92,1,185,152,231,159,111,229,90,0,131,247,136,244,166,200,54,38,236,225,7,82,120,
192,164,4,63,126,6,242,229,95,151,44,36,192,224,250,30,48,56,53,151,185,211,80,72,136,88,212,158,2,46,51,223,25,252,63,74,187,115,4,126,115,76,37,149,50,48,241,198,70,24,250,145,131,207,57,252,170,141,176,134,107,214,243,201,147,100,159,35,4,194,156,1,140,251,231,255,0,65,247,164,51,109,25,85,54,236,218,6,78,59,14,167,52,55,153,189,54,76,0,81,243,41,80,65,57,4,31,200,31,207,218,155,113,19,121,76,34,114,141,140,6,3,56,252,233,236,118,175,204,73,245,36,213,8,100,165,29,200,220,138,227,12,114,1,56,29,121,250,19,249,213,25,224,146,27,86,134,22,5,238,36,37,165,147,0,100,156,156,143,160,199,0,116,207,122,189,140,2,64,31,133,12,189,213,182,140,251,80,2,88,194,109,32,88,207,150,92,103,46,7,94,78,63,78,42,8,237,35,55,18,202,237,189,203,157,156,231,96,35,175,63,90,176,251,182,241,215,211,61,106,52,73,195,149,4,109,32,109,193,192,24,246,199,90,0,117,188,112,219,199,229,196,187,87,36,159,152,158,122,117,63,65,72,225,38,220,142,161,145,178,165,79,235,159,202,150,48,237,131,36,187,136,29,16,
96,96,140,242,50,121,166,58,124,233,229,185,202,159,187,221,187,28,230,144,18,54,61,112,122,118,228,210,161,196,103,3,24,237,214,163,152,144,172,50,119,1,250,154,124,97,65,224,147,239,235,66,1,192,146,78,71,124,14,221,169,78,14,63,199,173,70,91,5,136,250,144,70,63,207,255,0,170,144,98,64,254,231,248,120,52,92,9,80,6,118,28,156,0,120,52,56,12,27,32,97,179,187,223,183,255,0,90,161,81,38,65,12,91,7,161,235,138,150,51,177,6,3,112,49,142,226,139,128,50,252,204,1,219,158,73,3,169,224,127,65,80,149,251,100,76,145,204,25,73,42,89,112,79,94,71,167,29,63,250,245,35,146,79,221,39,184,57,170,246,178,43,44,169,2,121,108,142,114,54,129,206,114,127,63,235,69,198,92,80,64,193,227,21,17,118,44,16,33,247,56,227,31,95,243,212,83,99,154,78,67,160,232,114,160,244,30,217,20,237,207,198,210,185,36,117,31,231,222,139,133,133,40,161,118,227,35,28,247,168,221,11,141,200,72,200,245,199,255,0,170,148,169,125,145,169,193,225,131,55,57,246,31,173,62,37,100,202,73,243,55,97,143,74,0,100,81,36,48,164,49,160,
17,170,237,81,158,212,230,28,176,44,164,118,33,133,33,102,68,80,17,89,179,142,79,3,241,2,158,99,71,92,3,129,158,121,199,210,128,24,136,129,72,201,99,208,243,214,134,69,9,32,124,108,113,180,134,198,15,108,115,235,156,83,30,222,69,251,146,129,199,117,200,207,231,207,255,0,94,148,249,145,162,131,130,135,128,192,116,247,255,0,36,208,3,99,181,130,60,170,5,64,196,151,65,200,111,168,244,250,99,165,52,88,218,65,41,186,72,146,39,85,33,140,121,28,123,129,86,23,231,79,157,118,183,25,3,214,171,249,51,121,132,153,10,199,147,242,12,16,114,0,244,200,233,218,128,36,142,80,73,17,128,216,227,35,24,235,207,228,120,231,210,138,138,35,28,68,121,124,110,4,146,123,100,228,245,231,169,162,129,19,136,213,148,52,127,41,29,50,184,198,70,113,80,106,54,31,108,68,82,204,184,202,156,30,128,250,102,175,36,129,135,77,188,231,138,175,119,123,29,164,45,44,185,10,27,0,119,61,187,247,234,126,130,157,128,91,91,113,10,162,2,118,160,249,50,7,203,212,14,126,135,30,188,123,242,249,21,176,234,24,130,120,220,7,79,113,66,
204,20,237,108,28,16,114,62,148,43,46,78,114,57,252,251,82,1,214,238,37,200,249,183,70,219,114,71,83,128,115,250,211,134,11,101,128,7,158,131,27,185,226,158,191,116,224,227,235,85,161,18,25,14,88,4,25,202,128,57,39,252,254,180,192,156,145,211,219,158,56,165,39,35,235,215,189,70,196,110,56,57,80,113,142,180,184,206,104,0,219,135,7,211,219,173,69,29,180,81,200,210,46,65,39,39,234,106,64,200,236,81,88,101,78,27,219,190,51,235,78,206,238,141,201,227,29,253,40,1,137,34,149,242,227,98,140,84,124,189,25,65,206,56,252,63,74,80,120,32,144,216,28,224,126,116,49,59,129,29,198,9,39,28,96,227,183,210,152,114,119,6,229,135,70,198,63,149,0,41,112,10,19,144,55,17,208,241,215,211,167,122,82,50,114,184,200,228,18,59,209,184,6,97,140,96,231,159,215,250,210,110,70,25,65,158,78,112,113,156,30,104,0,102,193,37,136,3,190,77,61,24,20,86,67,187,184,199,122,97,4,48,198,78,239,202,158,132,183,221,32,224,224,224,208,5,101,212,161,75,191,178,62,240,224,133,203,168,228,227,61,191,195,189,89,37,27,4,48,200,
238,69,53,162,93,232,238,129,158,60,225,138,228,168,61,113,233,66,145,36,128,115,158,160,227,165,32,43,187,135,112,80,238,193,219,140,224,100,30,226,166,140,127,14,72,3,235,197,75,54,60,182,198,50,59,231,21,10,130,84,108,202,46,56,7,175,175,126,148,0,125,159,18,22,228,96,30,51,193,165,10,1,35,128,199,211,131,82,2,127,186,51,254,127,250,245,23,207,189,92,51,109,206,112,112,63,157,22,67,6,194,176,145,78,80,140,100,19,142,113,206,59,246,231,255,0,175,85,99,249,46,165,104,158,79,222,178,185,243,14,228,60,115,183,7,32,253,125,5,77,112,136,168,210,176,118,242,198,236,100,228,240,122,82,146,175,112,17,87,44,87,115,96,231,3,183,211,156,254,95,146,212,5,102,112,28,238,56,238,91,183,210,171,73,114,96,124,158,172,3,28,142,127,63,194,173,136,176,193,131,96,145,207,82,127,14,120,57,250,244,166,94,121,76,234,9,10,192,1,243,54,1,7,249,156,138,86,11,146,91,76,36,0,21,10,221,49,156,154,115,98,55,198,70,72,202,131,215,3,175,244,166,66,184,141,8,228,129,142,65,205,57,184,249,142,8,201,227,31,225,
214,168,64,142,160,96,14,71,29,121,161,70,230,201,32,168,60,17,201,255,0,235,83,163,140,129,156,112,121,230,156,120,201,85,7,3,61,122,159,173,48,35,206,75,15,155,10,64,30,141,210,159,141,171,187,5,189,135,122,9,32,41,32,114,64,63,157,43,129,192,12,70,72,232,104,1,160,16,189,6,105,17,136,102,28,99,31,119,28,10,55,6,220,65,193,30,255,0,133,51,59,20,177,108,96,114,88,241,72,5,121,54,1,195,146,71,69,238,121,252,42,15,61,151,59,85,85,243,211,56,235,235,254,77,78,197,157,11,66,192,150,25,66,121,81,215,7,252,154,108,113,42,129,211,230,201,60,96,19,253,40,1,179,180,81,40,55,14,145,130,120,224,255,0,159,90,41,30,230,52,153,146,50,36,153,126,242,169,251,163,175,245,162,139,1,32,82,35,109,206,195,107,101,185,199,78,160,123,119,239,233,85,164,189,181,105,148,19,129,25,200,60,142,112,71,78,252,26,184,251,112,133,148,49,83,145,200,30,223,203,53,11,91,197,28,136,35,129,87,57,99,133,251,184,227,250,210,119,232,53,110,160,183,139,42,44,97,10,135,83,198,15,28,118,199,255,0,90,159,28,137,34,252,
131,4,30,148,165,64,94,0,59,57,59,179,245,226,162,71,205,216,72,208,28,242,228,15,186,49,193,63,143,245,244,167,168,104,89,147,204,123,102,242,156,44,140,56,108,14,61,240,105,224,114,8,80,6,115,207,63,231,154,104,1,91,140,226,157,206,0,28,30,158,148,196,51,202,3,42,16,2,121,37,122,255,0,141,60,174,64,206,119,14,115,215,20,110,10,74,241,159,67,222,142,173,207,110,8,61,233,129,90,214,201,173,238,166,148,176,111,55,25,61,243,207,249,252,106,157,228,51,197,103,113,229,79,43,202,197,217,64,98,8,206,120,7,182,43,92,96,140,103,160,199,29,41,143,18,58,252,216,56,63,149,43,1,151,103,118,110,52,104,174,167,144,171,156,238,100,5,134,65,219,207,215,191,214,174,71,40,146,197,94,227,41,189,1,57,110,128,143,94,63,58,87,180,141,161,22,234,129,96,238,171,129,142,115,211,211,57,247,167,5,242,17,18,8,128,82,192,149,3,133,231,159,167,25,252,126,180,1,25,135,148,1,153,182,174,220,183,37,177,208,159,215,243,168,34,41,107,107,49,184,145,99,133,88,178,156,114,1,201,36,251,228,159,211,57,171,174,251,
8,59,73,3,60,40,201,53,4,49,188,246,11,246,200,208,72,65,220,129,126,83,201,199,175,108,113,64,19,134,82,168,99,42,81,190,233,94,65,29,115,77,105,4,33,155,36,130,114,48,7,211,252,40,129,2,68,170,160,97,84,3,142,0,62,222,148,231,65,181,183,124,192,240,112,63,74,0,142,27,129,115,46,17,72,65,159,159,119,83,142,152,239,212,212,168,174,178,190,247,93,135,1,19,28,140,14,127,31,240,170,118,144,249,12,76,33,0,39,35,60,146,113,140,19,159,255,0,85,94,46,185,99,144,72,235,66,27,35,153,140,77,150,77,209,145,131,205,44,141,157,172,170,74,158,249,253,121,255,0,60,213,120,221,154,242,84,114,66,228,97,123,99,31,206,172,49,216,120,192,0,244,52,132,53,179,189,79,112,121,250,82,201,146,163,104,29,70,51,77,69,144,22,99,131,159,202,157,147,236,63,94,148,12,29,73,24,83,130,49,158,157,63,194,170,67,102,171,168,75,120,179,72,75,252,190,88,63,40,224,14,125,127,250,245,49,63,235,28,114,114,6,15,177,167,43,57,102,98,54,41,199,222,28,251,231,154,64,63,13,215,104,39,35,32,241,183,212,231,6,169,72,145,77,
118,55,52,184,63,46,192,118,134,228,142,123,144,42,225,136,200,170,194,70,81,212,156,122,143,122,134,230,20,147,12,142,203,34,16,85,205,12,17,98,38,68,38,31,49,75,42,103,110,239,155,111,76,227,175,227,76,96,201,34,225,152,227,130,49,140,244,231,215,255,0,214,106,137,178,23,55,138,110,229,34,72,70,228,84,147,133,228,224,145,215,211,159,110,181,124,174,19,203,60,130,115,144,199,39,191,225,78,224,58,73,99,142,50,102,150,56,148,156,101,206,220,241,235,78,136,58,162,171,182,247,80,20,182,49,147,235,255,0,234,170,147,39,152,201,231,50,152,87,157,140,51,187,252,255,0,90,178,178,44,152,42,217,4,241,237,69,197,98,1,18,164,17,197,4,107,28,96,141,170,56,29,114,120,253,106,195,13,160,156,224,103,173,48,19,144,163,113,35,36,18,71,31,231,52,159,44,207,157,236,202,126,82,164,113,159,167,231,76,6,101,238,23,247,82,5,92,149,46,57,35,168,227,182,115,142,185,232,71,210,68,137,84,238,63,188,124,99,113,3,63,225,79,69,1,64,0,15,76,118,164,228,156,227,159,173,0,41,32,129,129,202,244,226,171,72,72,147,
204,198,80,46,8,207,166,121,253,79,229,86,148,177,63,117,148,30,59,96,211,70,230,153,211,40,84,39,205,147,201,36,224,126,28,26,26,2,40,212,44,142,62,82,100,34,78,79,7,128,191,166,0,162,156,168,35,144,186,142,72,198,123,226,138,67,42,64,98,75,167,182,130,210,112,120,63,49,1,7,211,159,126,195,177,246,205,184,224,41,112,101,202,134,43,183,185,45,140,99,233,206,120,197,103,29,89,99,146,68,84,121,91,143,153,128,64,56,193,247,3,142,254,245,17,212,36,19,164,247,81,47,149,27,150,140,34,29,195,32,130,50,78,9,249,179,211,183,78,120,90,1,171,44,34,118,81,190,69,42,193,136,86,192,111,169,239,223,243,167,6,65,144,131,107,49,35,118,222,1,199,25,199,183,175,166,56,60,85,104,237,93,175,89,222,238,102,128,40,49,42,28,46,14,120,200,198,113,215,215,167,38,164,150,206,57,124,209,113,153,35,153,129,40,199,35,129,198,7,235,199,95,210,168,69,141,133,70,215,201,42,72,228,83,207,76,100,1,159,192,83,35,77,144,164,120,3,98,42,140,103,176,192,165,117,38,34,170,118,54,62,82,49,199,231,145,64,10,141,243,152,
195,43,96,114,51,200,255,0,235,83,206,74,14,231,235,80,198,130,36,8,171,140,117,239,207,245,167,6,25,207,211,142,148,0,245,192,57,239,72,164,96,140,96,231,154,110,115,215,25,3,177,167,124,161,190,238,226,57,160,1,137,92,28,28,159,198,145,157,209,64,10,73,200,239,211,159,229,70,226,70,113,232,121,165,39,4,125,253,192,113,129,154,96,68,146,187,207,34,60,101,85,113,181,136,227,255,0,175,254,21,18,203,57,190,120,188,164,8,137,146,219,206,121,206,56,252,59,251,243,86,87,140,183,225,158,153,170,182,49,56,179,201,143,202,150,86,221,32,46,95,158,6,114,79,112,7,210,144,22,100,112,135,107,103,147,128,113,211,140,243,233,211,249,84,78,21,65,121,10,172,96,99,43,206,7,249,197,65,97,122,247,190,100,141,7,146,168,112,27,126,224,231,190,56,30,223,157,77,117,111,231,198,71,152,84,176,60,142,199,214,128,20,71,36,113,71,181,247,97,6,125,50,7,81,254,77,59,51,137,148,156,21,254,32,121,237,255,0,234,253,125,115,79,206,88,228,169,24,30,255,0,79,243,237,81,57,84,148,52,162,53,6,77,145,146,227,146,71,
243,206,120,231,167,126,200,7,24,207,155,184,227,144,7,29,141,41,12,201,128,219,142,49,200,201,207,225,82,100,23,42,7,81,222,162,154,60,144,121,7,25,207,127,113,76,8,210,41,55,28,149,67,242,240,6,115,79,17,146,197,195,150,199,28,243,131,207,235,154,124,89,104,198,211,130,114,65,3,183,249,52,201,124,226,85,119,16,73,224,147,74,192,68,202,224,186,70,50,72,225,143,78,190,149,41,51,196,124,210,55,38,223,186,188,146,127,207,79,169,168,204,102,100,140,75,115,34,177,147,40,165,194,238,192,200,24,0,100,112,78,57,233,205,58,23,95,50,81,188,149,87,62,98,48,201,86,192,231,175,0,128,14,61,232,176,14,142,101,146,224,140,76,164,130,114,79,202,123,99,175,191,165,43,196,89,55,16,25,200,29,248,172,253,34,25,98,185,188,77,142,144,137,49,24,200,0,114,79,3,176,228,116,173,70,229,118,146,48,121,198,120,255,0,57,160,101,91,105,138,192,100,104,128,145,126,66,21,14,88,103,128,56,233,207,94,159,173,27,46,164,150,51,35,164,65,55,111,68,228,73,198,7,36,124,190,188,102,167,222,1,39,13,140,114,64,206,125,
105,76,157,20,252,163,5,183,31,187,143,175,79,242,105,136,140,68,118,51,182,14,15,4,142,113,235,199,249,226,132,80,168,20,49,247,25,239,74,20,34,8,212,156,114,114,199,60,147,158,255,0,94,148,209,27,199,191,103,39,57,59,155,128,41,1,34,32,18,115,156,170,227,113,31,231,210,149,157,84,5,7,4,231,140,245,247,166,6,4,177,4,238,192,39,31,141,47,154,162,69,70,202,130,113,220,255,0,46,157,169,129,32,206,121,108,231,244,255,0,57,168,126,126,9,60,99,159,90,151,36,168,35,183,39,20,207,56,51,20,92,146,6,73,199,7,156,80,1,36,75,36,91,93,67,43,129,158,220,103,215,212,122,250,211,147,43,184,103,35,128,1,63,215,189,52,72,190,86,21,241,215,25,234,15,249,237,65,147,230,24,67,207,3,20,0,147,46,226,54,161,101,237,138,42,188,247,254,73,36,133,94,64,195,122,209,72,101,35,40,129,221,60,190,128,21,98,128,156,251,122,227,175,95,233,84,157,4,182,166,87,101,59,164,192,228,150,207,95,235,250,213,233,188,217,12,145,189,202,174,84,150,30,81,3,140,116,228,117,193,239,218,168,164,59,3,182,19,159,152,97,179,219,
223,24,169,25,165,165,201,116,101,16,73,41,42,34,243,23,205,82,197,151,39,144,217,245,97,215,61,48,59,226,91,43,73,108,203,92,93,79,41,194,159,149,230,98,128,112,115,130,120,232,127,58,198,104,119,0,70,17,79,95,152,244,7,35,31,136,31,149,116,58,124,13,111,105,19,188,127,190,144,135,155,179,100,250,231,174,56,31,133,52,38,73,106,242,201,10,60,165,119,186,130,64,66,184,252,15,61,49,214,165,222,166,77,158,96,222,70,237,160,252,216,245,250,113,80,92,253,169,227,149,32,217,19,30,21,152,31,243,254,123,231,21,30,159,111,53,176,153,238,37,89,38,144,130,238,15,80,7,31,215,252,138,171,136,182,0,32,238,199,94,180,221,152,94,244,0,55,179,6,201,7,130,6,49,78,42,71,25,250,156,208,3,0,11,211,129,74,170,121,231,219,233,70,224,75,1,180,144,7,3,158,244,243,192,250,247,160,6,225,72,40,223,50,176,193,4,103,52,184,33,137,25,7,29,187,243,65,24,92,156,231,29,233,0,82,0,7,140,117,197,0,59,24,24,231,143,78,48,40,42,112,85,79,78,57,53,17,56,6,65,243,176,4,41,232,113,215,25,199,31,253,97,82,228,14,185,
92,246,166,4,72,187,23,148,0,103,160,29,207,39,63,141,61,159,161,193,35,30,135,249,83,130,247,32,99,222,154,251,176,67,116,164,4,78,217,73,100,84,102,8,14,20,241,156,127,156,85,95,180,125,166,19,11,91,239,118,83,134,151,110,195,223,25,31,211,211,241,169,84,19,114,142,15,200,160,128,48,115,147,212,31,211,241,167,196,224,78,222,94,214,94,248,24,30,255,0,86,200,63,214,144,197,130,22,183,134,24,119,151,218,54,231,29,169,202,10,227,115,100,128,112,88,228,227,52,215,97,128,48,118,129,146,59,98,133,35,205,98,217,206,104,16,75,35,71,111,36,138,20,50,130,64,207,7,30,245,149,164,77,117,59,92,181,194,205,203,134,12,73,33,57,229,121,60,117,29,63,30,213,172,177,70,94,38,104,247,60,96,132,99,131,179,61,126,148,246,37,126,93,160,12,28,1,200,35,63,206,134,49,241,40,8,160,31,151,160,31,210,152,202,177,128,168,21,85,70,6,208,0,80,7,255,0,170,164,200,199,25,198,120,199,24,168,228,80,203,252,88,4,119,35,56,166,34,154,93,125,150,245,214,234,95,154,103,253,220,64,19,145,156,115,129,199,0,123,100,159,
194,192,157,28,149,98,68,138,153,96,170,196,47,110,184,231,219,214,161,182,129,67,37,193,119,141,192,96,235,156,6,228,243,140,158,185,200,231,140,138,182,27,118,121,56,250,244,160,10,26,125,140,90,85,175,145,230,202,177,187,100,25,152,18,172,192,13,188,113,215,245,171,155,209,74,172,140,139,184,224,6,96,50,123,1,250,82,153,17,203,160,195,17,144,221,61,51,253,71,233,78,193,228,12,16,48,64,34,128,27,32,7,32,231,119,177,255,0,10,67,130,132,101,134,236,243,156,26,101,199,157,36,82,42,20,141,155,133,114,165,177,248,127,245,255,0,194,157,189,207,152,114,51,156,0,120,205,32,18,35,191,123,42,182,63,131,61,15,225,248,126,57,167,132,10,254,103,59,200,234,123,103,255,0,213,72,165,33,133,99,11,132,3,104,86,239,219,20,146,203,229,169,119,207,202,51,128,165,137,252,7,52,0,167,168,93,199,167,95,255,0,93,67,41,117,196,139,150,10,51,141,223,120,119,227,31,254,186,32,157,101,70,97,184,5,56,44,87,27,142,7,78,122,100,227,240,34,166,3,39,112,108,146,7,67,212,83,184,21,224,200,221,186,54,119,254,241,
96,75,122,227,160,31,79,95,204,200,145,177,112,222,82,71,147,201,61,91,169,224,131,254,121,169,186,54,236,119,199,95,231,76,142,226,35,57,143,204,79,61,134,226,171,249,122,243,255,0,234,160,8,165,132,40,228,129,147,147,207,25,231,235,69,73,52,30,102,55,12,122,237,124,115,250,81,72,12,121,238,102,23,19,109,117,117,124,40,227,219,215,233,252,254,184,75,102,144,2,178,72,238,192,99,106,147,254,64,199,111,124,213,86,82,174,8,39,146,72,86,228,115,237,254,123,84,147,56,101,41,177,85,114,51,212,14,216,255,0,63,253,124,201,66,144,151,23,75,10,33,104,228,109,160,161,206,6,121,61,243,129,159,167,233,93,28,174,51,187,119,76,134,29,121,224,254,31,79,122,230,6,67,35,249,222,64,102,0,202,135,238,231,140,245,28,115,252,235,166,137,193,183,83,30,217,19,24,87,87,221,145,235,154,104,76,115,140,100,12,140,119,0,255,0,42,54,43,132,61,15,182,56,170,26,150,147,29,249,71,13,176,169,193,96,57,110,121,7,250,85,200,34,91,123,120,163,71,102,88,211,104,44,114,79,227,253,42,132,56,198,132,16,65,35,56,11,248,
84,17,218,91,194,230,84,142,52,224,43,4,0,3,142,157,59,142,159,137,169,100,148,171,170,237,46,206,73,24,35,128,58,147,159,168,233,89,215,90,194,89,220,73,2,192,90,52,203,51,33,234,72,207,64,57,57,235,223,173,32,52,0,4,229,120,62,135,140,159,113,248,84,129,151,142,58,246,61,171,59,72,184,158,84,146,73,152,176,4,4,36,1,245,233,212,116,171,153,218,50,71,11,220,242,69,48,36,105,54,228,28,54,79,3,129,142,159,214,156,28,48,198,118,145,248,99,243,166,148,193,200,193,28,228,19,193,206,49,254,125,233,119,4,12,210,109,69,25,57,39,160,3,174,123,119,160,7,116,225,88,224,140,147,138,141,119,16,165,193,86,224,158,248,246,165,133,80,64,159,55,153,25,193,86,206,236,142,199,63,214,158,84,130,167,29,125,233,128,221,229,88,112,79,184,28,82,23,44,204,29,70,51,128,51,219,29,255,0,201,167,1,192,228,156,14,184,166,74,7,4,131,159,99,72,8,182,73,246,163,39,152,165,2,144,168,19,156,241,201,62,216,244,239,79,65,128,161,242,112,51,199,0,126,20,216,164,219,230,9,65,40,91,42,64,36,129,199,245,205,61,144,224,
128,231,118,56,56,28,82,1,15,223,3,173,55,106,130,72,24,193,193,31,92,255,0,141,72,1,7,42,51,207,97,80,44,211,61,209,38,34,150,229,14,11,14,75,103,167,94,152,230,134,4,196,96,228,228,99,145,131,215,252,105,193,129,56,39,57,24,226,161,220,9,198,121,244,234,113,72,135,112,115,153,54,18,84,110,0,116,224,145,223,31,254,177,238,0,217,229,158,57,20,194,90,78,113,229,100,0,120,39,147,130,115,211,29,7,53,62,72,81,243,21,32,242,65,224,140,244,38,169,88,153,3,56,153,165,99,36,204,202,9,36,70,185,227,57,232,56,224,15,81,239,89,215,119,242,199,117,37,164,50,140,229,139,200,27,61,114,112,57,56,192,35,167,113,219,165,23,25,208,41,35,63,231,154,69,4,177,193,57,61,57,172,237,26,121,174,36,185,19,200,94,88,48,161,177,142,189,114,6,1,229,120,252,107,69,192,12,50,72,231,0,126,20,92,65,193,4,128,79,25,227,154,73,19,17,178,137,54,110,24,86,24,224,227,182,120,164,70,253,239,13,192,234,56,231,250,211,201,3,223,60,138,96,48,13,192,115,192,255,0,57,161,135,201,180,112,8,235,211,20,144,198,97,82,128,150,
37,153,142,112,79,36,183,255,0,90,161,184,251,100,142,137,24,72,148,50,179,62,119,111,93,199,43,143,92,1,249,226,128,38,40,12,65,57,32,96,115,147,254,77,84,146,51,45,188,176,38,239,184,216,92,245,206,112,57,250,143,200,85,135,100,217,146,220,14,73,97,252,233,176,177,59,50,88,52,128,112,87,39,166,121,199,25,254,180,134,54,11,103,58,124,16,72,118,109,93,174,171,140,183,7,35,61,185,61,69,88,72,85,2,5,108,0,65,200,29,112,41,251,131,103,56,198,61,51,154,82,85,164,238,72,200,246,25,255,0,245,127,156,211,16,19,140,12,116,224,30,128,254,21,77,236,32,146,237,110,89,63,122,135,39,211,61,142,61,71,106,146,205,94,41,46,60,215,67,19,62,99,59,201,35,60,17,207,191,191,126,149,101,137,46,7,118,235,198,120,230,128,43,205,52,80,101,164,42,128,145,247,207,90,42,29,85,145,35,140,185,199,39,154,42,91,29,138,146,90,46,208,209,172,142,49,149,27,65,227,212,159,233,215,20,178,216,59,66,29,182,167,124,109,192,31,227,219,173,73,102,60,199,117,42,100,36,18,92,129,244,3,245,239,218,173,161,19,69,243,136,
216,50,224,108,108,142,135,128,125,185,160,14,126,65,19,114,36,223,142,6,58,30,191,137,252,125,42,237,164,205,100,172,137,18,98,70,12,95,7,42,120,7,142,227,3,214,159,229,189,188,131,205,17,136,184,218,87,7,112,231,215,235,215,173,89,109,61,155,230,137,211,29,23,158,190,252,82,183,97,220,153,174,237,99,67,47,157,247,176,51,146,72,63,78,213,29,182,161,98,234,236,46,35,141,195,178,176,118,1,152,142,50,50,121,7,3,7,211,222,169,201,97,113,230,109,41,184,183,76,31,214,170,222,91,253,143,14,197,75,125,237,170,70,71,215,252,247,167,118,35,78,234,205,111,150,57,224,148,28,22,10,75,238,28,140,113,140,250,99,21,135,43,8,164,145,17,129,10,219,50,1,198,127,195,53,53,206,166,46,22,53,82,203,20,73,141,155,242,62,189,129,61,63,201,170,246,211,217,178,74,247,126,98,144,184,81,18,128,88,231,223,129,254,127,20,208,205,189,23,120,179,101,4,52,106,228,40,192,200,39,4,243,233,205,104,70,87,145,242,238,199,35,211,222,155,108,99,107,40,101,183,64,168,232,25,84,13,160,103,158,221,42,95,152,50,224,128,
0,231,35,183,61,234,145,33,129,180,149,200,255,0,26,169,169,197,115,117,104,109,225,144,38,227,243,243,140,142,114,56,245,192,171,99,27,216,227,230,60,83,177,242,237,63,116,123,211,2,149,140,98,202,202,40,57,40,185,27,207,93,197,189,189,201,171,138,155,21,66,96,40,24,0,30,149,4,214,137,115,181,29,152,162,156,178,103,135,61,179,235,235,233,86,65,39,159,195,158,40,0,60,18,192,143,169,170,237,34,238,112,14,20,117,164,123,150,88,37,144,219,186,136,206,0,115,141,195,142,127,157,32,157,86,204,206,160,176,43,184,41,227,60,126,148,48,34,89,148,179,109,101,200,56,3,119,94,159,151,81,235,218,160,179,190,154,234,115,28,150,207,8,251,234,248,225,148,99,140,145,215,39,183,108,211,173,158,41,227,31,186,9,34,201,191,105,195,97,135,112,106,219,137,65,92,97,64,35,183,94,121,164,50,59,75,212,157,37,49,41,242,227,125,129,179,146,199,190,61,185,224,253,122,84,238,219,179,242,158,125,191,90,130,22,150,87,144,186,44,96,16,20,2,75,28,100,18,115,219,166,42,103,108,28,243,199,165,2,40,205,111,42,223,
193,50,34,178,43,228,241,208,30,15,227,215,244,171,113,75,4,208,59,66,234,66,177,141,143,161,94,8,35,252,250,247,167,182,197,4,28,174,227,233,212,241,143,233,72,35,85,77,187,87,146,73,1,112,13,3,40,88,60,232,146,91,34,156,198,153,73,100,13,243,22,39,4,130,114,114,65,39,167,36,215,63,28,205,48,50,58,9,55,179,17,176,146,78,57,57,255,0,235,250,26,235,146,88,164,119,129,89,90,85,234,189,199,76,255,0,49,249,143,90,134,214,194,11,121,146,91,66,81,23,228,101,83,185,88,115,234,122,231,28,251,80,213,194,228,58,101,171,90,70,37,118,218,247,1,119,6,125,164,30,120,198,58,242,6,61,115,87,73,114,164,128,34,227,112,45,206,61,73,244,239,208,212,51,93,195,246,152,35,147,114,180,135,229,12,48,185,35,60,158,153,227,167,175,231,81,106,19,222,148,205,156,82,43,163,16,73,3,4,1,249,156,251,80,4,207,119,10,134,4,135,104,241,230,109,193,40,49,156,183,60,12,126,63,90,129,174,175,159,81,196,49,68,246,188,102,80,71,67,142,115,158,112,115,248,102,174,130,205,16,102,76,49,0,178,231,56,39,168,207,122,14,228,
42,161,134,61,49,146,70,15,31,203,154,4,66,211,72,151,233,16,183,59,10,150,105,122,1,236,61,106,82,228,140,42,117,233,142,191,143,165,86,17,92,137,99,64,229,160,85,0,179,114,79,94,255,0,151,90,181,156,245,27,129,199,255,0,174,129,145,76,93,101,141,55,198,50,9,96,203,150,218,0,228,115,216,145,159,173,58,222,85,119,125,140,14,220,169,10,126,233,29,71,181,59,229,11,200,29,57,35,142,255,0,253,122,169,118,184,177,153,97,65,186,64,114,115,128,119,12,103,159,95,243,138,0,188,136,223,54,252,40,207,203,207,111,94,63,207,243,170,247,151,208,88,4,55,14,16,72,78,223,148,158,152,207,64,113,212,86,60,250,165,199,246,76,112,180,162,59,133,147,202,149,131,243,128,49,158,78,70,115,212,119,7,158,213,169,37,140,119,150,208,188,236,175,40,140,98,72,219,135,207,191,161,224,254,52,8,125,173,172,169,116,110,100,157,37,222,50,167,103,221,28,125,211,158,7,28,250,224,26,146,25,68,247,19,0,175,229,130,2,185,251,175,193,201,30,223,158,105,200,177,164,75,26,113,18,130,2,250,156,245,62,253,127,58,152,58,237,
59,112,56,206,115,64,25,122,132,203,37,215,146,66,42,162,231,50,12,134,39,208,81,86,110,98,124,130,165,243,254,192,36,255,0,158,40,164,198,71,45,191,157,181,153,150,7,4,25,25,15,222,199,108,241,159,90,111,218,163,180,62,93,206,200,242,216,67,143,149,143,92,123,99,61,234,200,115,180,6,108,103,156,14,166,163,51,54,113,133,98,122,18,71,7,158,159,227,69,192,200,212,158,38,42,80,132,194,147,199,32,115,211,61,171,86,223,237,144,219,5,112,100,113,243,21,45,207,7,166,122,115,88,247,55,55,17,234,204,163,202,89,165,216,138,219,9,12,122,118,57,239,250,14,181,190,20,92,90,174,233,74,255,0,121,162,124,114,14,49,159,173,11,80,122,19,162,8,213,75,149,235,203,98,156,232,178,99,40,172,1,220,9,25,228,127,250,186,211,36,85,104,152,57,218,54,145,156,242,163,185,207,106,130,43,167,107,55,150,234,68,1,65,37,144,113,140,14,120,252,125,62,149,66,40,77,165,74,250,148,151,49,76,33,207,204,54,14,67,99,147,252,255,0,51,74,52,75,102,114,211,51,76,205,146,119,113,146,112,114,2,227,222,180,38,101,242,156,184,
222,19,230,235,158,70,8,63,135,90,173,165,93,61,213,148,82,204,9,114,188,177,35,146,14,14,49,238,13,33,142,178,180,75,8,218,56,151,203,66,219,241,187,60,226,172,171,29,135,0,7,28,14,77,33,201,7,25,247,255,0,57,164,0,96,100,243,64,135,197,177,134,242,168,160,46,220,109,198,23,210,158,227,230,220,91,27,121,60,240,56,239,81,46,17,213,242,7,80,69,76,78,87,168,235,128,41,128,129,213,128,101,28,2,71,32,142,149,20,215,41,12,38,86,202,70,62,251,0,114,59,116,199,60,227,249,209,110,241,76,137,36,46,146,7,24,14,164,16,216,207,113,233,147,81,222,68,38,143,236,224,72,18,64,75,16,66,128,56,227,57,207,62,212,1,70,215,89,91,233,76,45,11,70,220,237,203,103,60,30,191,225,205,105,32,143,37,140,96,100,0,72,31,159,63,141,98,255,0,103,182,159,117,20,150,129,228,142,108,174,54,244,24,7,7,245,235,138,216,158,82,144,101,20,177,39,176,206,121,205,33,138,234,161,119,162,132,97,234,7,244,168,138,72,20,200,101,192,36,18,9,198,56,192,29,113,249,83,45,110,140,192,163,197,177,212,227,31,231,167,210,167,124,
143,44,239,194,231,140,31,189,245,164,2,42,237,27,139,179,240,58,159,78,254,212,201,167,16,38,72,89,31,60,40,234,123,12,14,73,228,129,68,197,188,189,216,59,184,200,25,25,57,252,234,41,174,119,193,116,177,71,43,152,215,1,151,24,99,142,220,245,28,80,3,238,47,32,134,208,206,242,7,77,187,134,209,156,158,71,78,189,125,122,99,218,164,179,184,142,242,217,102,136,182,217,7,70,25,193,244,62,253,107,31,69,211,35,120,228,146,115,189,137,40,98,97,134,28,127,23,124,224,231,233,131,206,106,77,98,250,75,88,163,178,181,249,85,84,101,195,96,168,0,96,15,203,159,243,130,224,93,190,97,108,139,44,206,234,234,248,80,29,145,88,147,198,224,58,129,254,122,212,139,106,254,89,142,226,121,29,119,13,160,14,168,49,195,113,130,78,57,39,174,79,76,154,230,83,104,222,218,132,178,199,2,168,0,130,74,229,176,64,80,51,129,140,28,14,152,25,173,237,62,206,45,59,237,51,151,3,112,4,179,12,5,85,207,36,254,39,242,167,125,66,197,211,12,127,186,92,32,141,6,21,2,12,12,116,250,17,143,212,209,5,220,119,67,229,32,58,15,222,70,
174,24,198,222,135,159,92,143,192,212,87,65,227,183,105,119,57,194,150,218,131,230,110,59,3,222,162,210,225,183,91,69,150,53,144,27,129,230,102,83,243,182,121,231,25,250,254,52,1,105,37,134,224,176,133,247,5,37,27,29,155,210,154,145,56,97,153,78,206,152,60,228,253,42,70,12,37,70,82,118,99,27,122,224,245,201,57,246,199,227,73,34,111,70,94,70,79,64,72,255,0,235,209,96,24,128,62,89,27,119,57,7,39,31,81,78,198,98,96,91,13,147,200,61,15,227,70,237,202,9,66,164,255,0,15,0,175,183,21,24,118,18,28,46,229,60,228,158,159,207,252,138,64,1,73,147,115,119,3,174,113,223,252,104,66,206,210,51,2,145,131,128,219,184,35,215,219,184,162,39,18,199,184,171,161,7,5,27,168,199,208,154,149,72,254,232,231,129,145,201,160,12,150,209,225,105,166,105,87,10,227,133,85,192,83,142,199,183,229,254,21,122,59,53,86,130,72,192,141,99,70,85,84,224,28,145,156,250,244,252,249,237,86,84,174,92,6,207,32,103,61,255,0,206,42,187,74,162,38,134,117,220,142,164,116,39,62,212,108,5,149,80,98,1,209,71,77,221,233,134,84,87,
42,167,46,184,44,8,233,147,255,0,214,170,208,73,13,156,74,129,220,129,145,131,147,211,142,227,142,59,85,144,193,142,8,56,247,239,78,224,50,9,9,182,82,173,185,149,138,147,39,83,239,199,92,140,31,199,240,5,70,37,255,0,91,184,109,196,132,12,119,24,200,56,252,79,229,69,23,1,22,205,161,125,193,119,115,156,19,201,207,166,127,250,213,99,98,178,145,156,28,231,35,241,168,98,183,242,68,131,237,14,207,33,24,66,220,12,231,160,237,158,127,200,172,168,239,226,138,250,82,204,94,205,211,62,89,203,6,61,70,1,224,126,157,15,94,13,45,16,26,50,41,154,227,202,146,72,149,130,252,172,24,23,235,158,61,56,3,252,226,174,196,60,181,35,33,65,36,252,163,0,103,154,171,103,45,181,220,178,8,225,93,145,170,133,60,140,131,215,3,28,96,168,29,250,118,169,154,35,178,70,121,23,43,211,215,3,223,174,122,211,1,154,180,101,236,36,82,62,233,7,30,188,138,195,181,83,45,220,5,64,66,92,16,92,113,193,201,245,4,255,0,136,174,128,198,102,133,227,46,74,186,145,211,4,255,0,147,92,252,150,242,67,32,73,147,231,192,227,130,113,73,
247,26,55,154,23,124,13,200,35,220,14,0,228,174,220,96,251,228,147,248,15,124,168,179,129,34,49,44,67,203,114,73,64,163,7,61,106,11,6,189,146,200,78,174,178,49,124,40,144,128,187,65,228,140,12,228,242,57,238,51,236,103,86,189,55,104,100,133,22,7,82,27,203,155,37,79,175,42,51,233,254,52,196,49,227,84,151,204,80,75,17,141,216,250,127,133,74,140,8,44,9,231,212,99,218,164,97,243,97,129,231,175,32,1,66,197,243,238,10,55,99,169,39,39,146,121,246,228,253,41,136,66,114,57,4,243,219,214,155,111,20,145,91,136,230,156,204,249,36,187,12,103,39,56,169,37,10,225,149,193,56,94,70,56,35,211,222,145,28,72,55,40,109,167,24,108,17,248,224,208,1,4,81,66,133,45,227,69,81,200,8,0,31,165,73,32,44,0,238,61,169,168,121,249,152,28,31,167,20,230,193,201,3,241,160,12,233,222,242,222,236,176,87,150,213,163,198,216,213,119,70,249,28,243,142,49,245,171,72,193,162,46,128,150,57,59,95,177,250,118,252,42,108,116,193,3,222,130,191,46,14,122,113,154,0,137,250,156,46,208,15,94,184,63,74,97,111,144,111,57,101,199,
7,249,210,187,73,230,168,24,219,206,70,121,0,119,255,0,62,181,26,103,108,193,182,171,22,32,54,61,186,144,125,243,248,98,147,25,44,138,51,128,56,61,143,113,77,251,68,65,130,7,4,147,140,14,127,47,165,69,15,157,12,120,184,148,239,46,10,171,237,25,200,3,111,191,60,250,243,138,200,212,117,8,96,146,223,236,241,199,32,141,252,198,192,32,147,140,122,123,245,164,6,165,202,59,188,77,105,28,108,37,31,188,147,113,86,101,199,28,129,158,255,0,135,242,202,215,196,183,23,49,199,111,36,82,56,5,29,99,33,136,57,232,113,211,241,171,186,206,219,155,69,111,56,67,132,108,115,254,177,78,56,234,56,233,219,208,250,212,58,36,49,220,164,119,171,42,185,66,201,32,94,8,235,201,63,66,15,249,52,1,14,167,96,255,0,102,178,177,138,32,100,140,9,28,39,56,110,153,250,100,158,184,237,91,151,86,241,220,217,203,107,35,184,14,152,37,120,36,30,252,126,53,4,98,71,212,167,145,161,217,20,113,44,106,237,193,98,9,206,61,189,79,126,49,210,172,199,42,50,160,86,13,194,159,148,238,200,36,128,120,237,199,83,239,232,105,129,157,98,
110,77,212,194,235,49,163,46,97,129,23,33,20,255,0,120,168,218,62,232,199,61,207,94,43,65,93,212,176,218,72,28,12,119,231,166,63,42,81,144,193,148,130,8,225,178,59,212,63,98,69,186,44,187,68,100,22,218,59,182,224,193,179,234,14,127,58,0,159,123,49,28,228,99,63,116,140,31,173,49,75,7,59,136,57,35,3,147,245,162,237,229,142,6,104,134,233,122,40,199,4,246,31,253,122,86,70,251,64,117,145,188,189,152,11,129,180,159,175,95,255,0,88,160,7,2,54,133,206,58,241,239,81,79,182,56,218,71,201,8,55,31,82,7,165,49,85,146,234,75,131,43,20,35,110,210,248,85,31,143,126,63,206,106,188,247,108,218,113,145,49,42,185,198,215,7,32,127,116,243,156,255,0,250,233,1,113,93,94,37,101,86,1,251,17,130,51,235,75,27,100,18,54,237,199,99,88,150,58,133,195,201,29,164,80,32,249,135,32,125,212,244,3,56,24,29,62,152,193,53,165,114,210,164,97,161,224,1,203,179,100,100,246,25,254,188,80,5,144,192,54,210,114,61,49,205,42,191,153,185,76,100,0,1,15,158,15,176,250,127,159,106,80,173,204,237,251,216,252,128,146,54,238,113,
184,231,142,61,0,247,236,58,212,215,151,81,219,201,111,22,230,6,102,194,190,55,40,250,253,115,142,248,160,9,72,72,226,11,203,0,57,29,73,252,123,212,49,194,45,230,93,139,242,176,103,85,45,200,228,103,3,249,251,253,104,190,150,40,45,3,77,27,185,60,97,64,221,252,234,182,251,107,107,187,73,98,17,237,153,76,33,147,168,251,184,207,211,0,96,244,205,0,73,155,77,67,114,13,165,227,108,16,72,252,254,156,138,41,83,77,128,59,60,46,200,172,78,118,240,65,28,99,62,156,30,63,194,138,57,87,80,185,124,192,143,25,19,68,132,186,225,198,223,211,233,205,85,147,75,180,149,155,116,49,150,198,14,70,127,159,176,166,255,0,105,36,83,77,25,70,34,21,222,228,48,200,60,112,23,169,28,245,254,85,111,30,116,123,142,65,29,64,199,28,116,53,66,34,130,217,109,100,101,141,118,198,234,55,12,224,3,158,160,99,190,121,62,194,164,153,26,72,202,41,196,139,181,183,21,200,198,115,142,195,182,63,42,69,216,0,12,173,147,193,4,0,23,0,113,197,65,117,37,202,72,134,8,35,42,170,126,102,66,112,121,227,131,158,131,211,191,189,0,79,111,
117,28,179,24,138,60,110,50,202,29,49,184,3,140,254,120,253,43,46,250,51,113,172,52,42,248,47,142,88,112,62,92,254,60,10,211,142,221,101,185,23,82,171,25,84,97,126,108,170,113,206,62,185,253,5,73,38,216,211,118,61,73,220,112,49,142,230,134,50,43,8,100,179,179,138,22,33,217,115,158,49,201,57,199,235,143,122,75,141,78,218,210,81,28,204,85,155,145,133,102,7,223,32,123,86,78,139,168,207,113,34,91,220,168,153,21,75,44,184,249,134,56,201,252,241,158,188,243,90,15,96,146,222,25,164,103,24,24,1,88,129,158,196,30,221,233,8,190,146,199,34,238,87,82,58,101,72,35,244,165,98,54,144,122,142,131,138,141,72,29,62,92,142,152,198,105,4,196,204,34,2,64,118,147,187,7,29,113,140,158,254,212,192,149,93,153,21,136,198,224,14,210,57,30,213,27,176,218,224,169,101,110,160,142,212,160,157,197,177,250,211,102,33,84,174,230,80,231,4,175,81,158,50,61,232,0,121,227,137,55,74,235,26,142,165,248,199,249,56,169,67,131,26,186,109,100,97,144,84,240,65,239,81,75,20,109,11,197,32,38,57,1,12,9,56,193,237,235,220,254,
84,91,181,195,203,63,156,168,168,49,179,97,201,35,158,77,0,60,128,64,80,10,30,159,40,231,31,90,93,165,78,14,54,145,129,215,61,251,254,84,195,242,182,65,192,62,180,168,217,80,223,119,253,159,79,202,128,25,32,32,135,236,56,252,15,255,0,94,171,173,244,15,16,80,73,28,156,30,127,58,125,212,208,36,82,60,210,133,69,4,237,82,62,108,14,159,173,99,91,79,21,229,228,40,172,209,219,110,43,180,117,44,221,251,245,63,90,67,44,92,109,185,116,243,37,192,144,227,223,61,176,58,14,213,155,169,219,200,136,247,12,10,39,156,99,216,192,130,70,56,63,74,210,212,82,120,219,22,236,89,118,40,64,157,64,245,227,191,83,248,212,58,235,36,240,194,205,58,25,148,20,120,215,13,183,212,241,156,28,224,117,164,6,125,187,200,255,0,36,174,206,145,127,171,203,22,219,142,56,207,24,224,113,210,186,40,33,123,155,88,190,215,19,55,33,159,119,202,75,2,72,200,28,16,56,235,248,128,69,87,210,45,226,75,8,238,97,50,59,132,59,215,25,220,192,231,161,29,65,199,76,116,239,85,63,182,175,96,187,243,46,34,140,13,161,94,60,48,32,117,238,
112,15,127,202,128,55,0,111,146,76,110,28,143,148,141,184,236,122,250,119,172,253,90,51,10,127,105,69,49,134,113,31,150,72,80,119,14,184,199,214,163,211,46,110,229,89,93,154,223,200,243,51,51,75,159,78,71,167,0,119,245,164,212,236,164,50,94,172,82,98,25,99,18,74,174,249,218,65,227,24,201,232,189,49,142,61,169,244,3,86,198,102,188,180,134,121,85,81,165,92,149,7,35,240,246,255,0,26,124,114,9,33,73,83,37,24,110,66,71,168,247,233,92,237,158,173,115,111,27,89,221,31,62,6,249,18,116,59,93,87,24,200,227,158,199,177,250,246,158,210,85,181,209,68,171,155,147,4,184,42,79,202,125,7,208,103,35,60,231,29,56,162,225,99,85,103,41,114,182,243,9,55,73,147,27,148,194,231,4,224,99,56,192,29,241,156,113,154,83,35,197,112,251,224,96,174,225,85,148,117,27,73,203,123,103,35,241,28,86,118,151,171,93,92,93,44,50,217,198,33,114,76,70,32,87,96,7,190,120,61,135,24,252,115,90,209,73,29,212,32,109,253,220,128,129,146,84,245,199,30,157,15,52,8,173,53,184,156,146,11,239,97,180,28,244,25,4,240,126,159,165,54,
218,219,236,109,42,110,47,28,135,118,211,201,207,67,211,168,60,126,85,45,236,38,226,206,75,96,192,177,28,17,144,50,15,30,189,197,12,232,46,119,187,170,252,194,20,12,220,146,64,56,3,61,240,56,198,120,247,160,99,210,53,73,12,142,23,121,80,4,152,249,143,98,15,31,67,248,244,226,160,157,163,137,153,230,222,144,132,249,157,122,22,201,227,142,125,120,233,215,175,102,220,234,66,25,99,69,130,73,119,201,229,111,69,27,84,228,117,63,231,161,29,141,93,86,200,86,4,143,106,98,41,125,165,109,160,70,145,77,156,79,30,16,176,203,171,30,113,180,100,123,227,240,169,110,226,71,146,55,120,247,141,195,105,110,189,122,244,237,197,88,194,73,141,234,167,105,200,200,238,41,146,160,5,92,241,128,87,233,156,127,133,32,29,36,112,188,59,101,64,197,115,199,222,224,214,117,206,151,24,49,11,73,133,189,192,112,82,70,249,143,67,192,4,242,113,207,224,106,240,150,61,229,78,23,161,193,234,50,120,207,161,52,203,136,34,188,183,88,216,182,194,3,35,131,208,142,65,227,243,160,11,18,28,0,163,3,28,142,40,164,108,170,174,226,
24,129,140,158,62,180,83,184,21,109,226,196,146,78,139,178,70,56,108,119,244,205,19,121,236,23,108,219,48,192,131,176,49,244,227,57,197,77,129,25,201,4,22,29,7,35,138,173,125,124,150,236,84,130,79,4,110,249,71,80,123,255,0,65,245,197,72,199,198,2,194,35,87,147,24,218,78,237,196,118,207,215,32,208,32,104,224,16,192,161,118,131,180,49,39,147,216,243,211,175,255,0,90,164,79,42,230,1,34,12,249,168,1,216,216,96,57,227,131,193,25,169,21,126,79,44,18,112,54,243,146,79,212,158,115,76,65,17,120,162,40,8,44,7,0,12,40,61,186,116,20,66,179,186,134,153,148,112,115,26,244,252,250,231,252,127,26,39,144,65,107,36,132,41,42,133,176,123,224,86,19,235,23,77,49,158,2,7,202,84,70,217,219,248,251,251,251,81,123,12,218,138,33,26,17,25,218,29,203,177,60,228,247,254,85,48,60,103,39,7,214,162,182,153,110,33,19,8,228,143,119,11,230,40,203,15,195,181,78,87,112,4,100,103,175,20,196,55,232,160,158,8,7,140,210,231,40,8,239,142,184,62,180,130,60,31,152,18,61,249,164,146,50,192,148,219,230,42,144,165,250,103,
240,237,159,229,64,10,112,87,229,92,243,158,56,200,168,100,133,92,229,126,87,233,230,40,27,177,198,122,143,69,3,240,20,105,255,0,106,54,231,237,145,162,74,14,114,135,130,15,63,167,79,194,167,192,108,100,0,77,0,84,186,55,107,121,110,35,141,102,181,36,137,0,200,101,227,25,206,112,122,244,198,120,252,162,211,111,100,185,186,186,138,104,60,145,16,85,1,88,48,39,44,15,60,123,113,237,90,65,84,123,31,231,64,192,96,48,184,237,197,0,48,146,50,73,42,49,201,198,104,220,3,18,15,83,216,210,227,24,0,101,84,224,238,25,227,29,51,249,84,119,49,151,129,163,70,48,177,31,124,127,8,239,64,25,250,173,146,152,101,149,35,47,33,82,3,114,199,211,167,57,235,81,89,216,203,13,131,192,224,70,167,115,75,185,75,28,144,48,23,3,166,49,200,36,117,244,171,247,70,117,138,40,173,56,195,109,59,118,252,171,130,51,131,232,72,56,246,170,50,73,119,13,148,41,54,21,8,254,17,192,0,96,14,167,235,72,101,119,146,52,102,95,48,228,96,22,139,229,31,65,232,6,0,226,157,5,197,133,178,179,170,171,75,32,196,158,105,108,191,126,249,231,
53,81,162,242,128,44,23,110,121,102,193,30,188,250,159,106,71,141,29,65,78,15,66,72,234,125,5,43,129,210,137,161,242,147,204,116,27,128,192,221,144,120,207,203,234,0,170,3,91,178,150,73,67,204,4,40,138,192,186,17,185,178,115,219,183,203,89,119,87,178,201,102,109,202,171,50,124,173,33,124,200,121,61,61,176,72,207,190,56,166,216,68,178,235,17,4,84,242,203,147,128,185,3,142,157,61,186,254,61,104,184,88,234,22,49,17,63,41,228,130,72,238,112,7,242,20,199,196,151,40,197,9,11,243,111,61,1,232,63,66,213,94,217,26,213,74,188,146,72,204,251,64,235,131,158,188,40,199,57,246,31,205,209,183,148,222,89,221,48,145,216,187,52,156,167,82,56,244,206,56,227,31,157,80,140,166,150,200,91,78,255,0,35,77,230,148,49,151,218,89,60,206,23,29,71,0,30,153,226,180,52,243,111,117,101,181,97,196,42,66,152,95,230,3,161,60,242,79,95,210,170,46,156,151,23,225,165,180,242,32,137,112,21,24,16,192,19,129,140,112,63,207,4,230,175,54,159,8,187,138,242,32,34,17,130,72,218,7,111,210,146,24,215,132,92,164,13,27,61,164,
201,184,194,165,66,225,142,125,71,79,148,156,119,28,212,182,144,27,59,72,162,105,26,70,238,70,0,4,146,127,174,63,10,115,160,121,214,86,147,126,192,118,168,220,6,123,28,103,25,198,71,78,244,150,151,77,119,109,36,162,35,144,236,145,140,224,56,28,3,237,233,143,110,148,1,44,82,69,44,107,36,5,89,1,32,149,24,201,207,63,227,239,215,189,100,107,40,30,209,161,158,78,74,75,34,21,96,160,48,232,188,245,225,136,252,255,0,13,152,87,106,153,74,36,110,195,46,20,228,103,30,189,234,41,24,22,218,241,43,50,176,232,55,99,220,228,251,143,206,134,9,216,207,208,224,186,183,211,160,73,242,184,86,5,127,136,115,242,142,59,15,155,175,57,61,177,90,64,30,118,245,39,36,133,235,254,71,31,133,34,20,133,12,146,40,65,140,146,125,187,159,65,223,255,0,175,80,219,93,155,200,26,120,211,104,12,65,25,201,28,126,189,104,216,55,44,44,155,142,220,103,57,0,226,171,106,12,82,37,149,103,147,10,202,197,99,0,151,228,97,113,215,147,129,75,44,201,246,119,101,98,84,231,7,61,13,103,54,167,44,58,148,242,200,30,88,204,33,85,35,3,
150,7,57,36,243,142,79,79,240,165,112,177,100,220,110,121,68,240,197,9,94,174,92,54,224,164,158,127,14,71,214,172,121,170,110,128,49,16,158,94,65,192,192,59,134,64,199,60,231,63,231,152,109,239,108,239,100,17,50,27,121,15,32,57,3,113,238,20,231,147,207,249,230,173,61,145,42,171,191,190,230,56,228,140,99,25,31,81,249,81,168,104,23,16,6,142,48,55,96,127,117,138,31,210,138,144,48,144,38,24,50,149,220,114,57,252,187,116,162,157,152,25,183,201,111,111,121,13,244,254,106,220,4,96,173,146,241,228,140,99,215,156,240,56,28,31,198,176,212,237,110,44,204,151,12,68,184,96,99,80,64,56,224,1,215,182,63,90,179,62,147,230,222,181,197,213,212,141,10,242,168,91,27,14,114,78,125,63,199,174,6,43,6,117,183,118,95,36,180,113,187,112,24,114,163,61,255,0,35,244,164,193,29,29,155,199,60,49,189,164,132,34,56,255,0,88,114,64,4,100,31,124,86,130,73,148,27,148,1,199,0,231,143,243,218,178,244,164,134,206,201,97,39,203,119,108,225,143,46,25,128,86,199,167,42,57,244,247,205,94,220,35,33,122,100,247,61,15,255,
0,94,152,15,149,144,91,177,149,23,96,83,158,50,48,7,160,254,85,139,99,165,249,193,193,112,54,54,208,216,206,239,165,108,94,66,242,219,205,20,111,181,156,99,145,144,63,194,177,237,181,137,173,241,246,147,230,198,50,6,212,0,142,56,3,160,199,214,135,230,8,223,80,177,34,170,1,181,64,1,64,233,233,73,184,178,169,195,41,61,152,224,228,125,15,183,74,120,12,84,243,243,3,142,127,250,213,28,69,68,142,54,108,119,203,30,58,246,206,122,103,0,123,211,16,239,52,231,238,147,156,227,2,154,9,39,113,36,171,48,43,146,56,28,112,49,244,207,62,181,28,215,9,10,177,125,200,136,11,59,227,229,0,12,159,175,30,131,214,171,223,223,193,99,110,229,154,54,145,2,226,45,251,79,95,79,78,15,110,212,1,160,188,231,168,231,189,103,94,234,107,5,245,189,132,5,90,226,86,203,6,60,34,14,73,250,145,211,252,230,227,111,107,124,133,62,96,94,136,122,28,118,206,51,248,214,117,142,147,111,99,32,156,180,173,116,203,243,187,156,115,130,73,56,233,159,114,123,80,5,251,121,124,229,112,84,238,78,55,99,1,190,131,57,237,223,175,106,152,
49,56,235,215,39,167,63,231,250,86,70,159,5,237,142,160,241,159,222,218,206,236,252,177,204,108,73,61,249,60,15,243,142,116,137,32,42,16,199,39,25,7,160,247,254,95,141,0,33,186,86,37,98,42,100,12,55,35,112,216,221,130,113,244,206,42,66,125,118,134,166,56,34,76,239,56,254,239,245,162,54,243,35,86,218,200,113,192,97,205,0,85,101,151,251,72,72,100,49,219,44,68,109,7,25,110,229,189,70,63,80,43,54,236,73,29,209,19,76,25,151,1,78,56,193,250,99,29,179,91,44,233,229,23,109,193,99,60,177,39,183,127,126,213,145,168,35,92,106,15,137,17,163,220,177,168,47,142,125,6,127,17,140,245,35,214,147,25,27,32,185,155,231,37,128,3,157,220,231,20,255,0,33,118,156,43,225,70,114,205,194,224,115,82,173,178,194,222,92,142,119,183,70,140,100,12,100,126,157,42,197,184,129,157,130,178,186,21,36,144,255,0,134,8,237,158,127,42,64,98,71,106,110,175,20,0,89,67,38,253,170,78,1,61,235,119,247,86,25,48,194,70,252,109,219,207,229,255,0,214,171,11,99,24,12,99,2,51,192,44,190,131,56,254,180,178,91,133,195,12,151,7,25,
39,52,172,199,161,145,169,92,171,216,59,121,83,36,238,84,3,131,243,28,227,35,4,227,144,120,250,122,214,149,194,4,102,18,5,17,228,16,122,96,213,11,155,119,158,225,2,151,85,13,188,5,39,229,99,206,65,255,0,56,171,254,101,180,147,125,149,137,243,223,44,19,105,218,216,28,242,56,200,224,245,238,40,223,64,32,51,128,127,209,228,0,134,201,70,108,31,95,229,82,139,134,32,157,192,142,56,94,199,142,255,0,231,189,44,214,124,6,140,111,203,116,192,192,20,201,94,59,59,86,121,131,50,132,14,66,227,45,158,195,145,211,191,214,146,82,13,3,236,170,232,88,146,194,79,152,146,7,57,255,0,235,12,126,2,170,155,117,186,51,219,198,74,152,138,135,7,35,32,140,131,248,224,254,94,245,102,254,56,230,211,102,137,3,135,88,132,158,80,63,63,168,4,96,145,205,115,250,86,145,168,189,193,154,100,48,16,1,67,188,135,201,236,48,114,6,51,156,243,250,208,214,163,91,26,141,12,150,86,233,12,140,37,140,72,60,180,63,194,199,128,49,211,31,133,77,48,184,77,70,57,17,152,70,138,187,192,0,6,228,228,123,241,159,167,168,167,199,10,71,
12,72,68,129,211,108,123,149,113,159,124,224,126,127,133,79,12,241,75,3,200,102,27,98,98,25,249,249,118,158,120,252,41,164,38,89,98,128,54,253,204,156,16,78,49,248,99,159,255,0,93,102,67,246,155,57,156,90,162,53,187,16,223,63,12,59,28,122,116,29,127,74,190,21,90,52,6,61,170,114,217,217,150,25,246,61,15,76,231,222,169,73,21,219,93,68,33,153,45,212,28,184,9,185,27,13,199,94,153,29,135,79,94,134,168,69,147,58,75,105,230,198,164,44,129,176,202,50,122,224,17,145,215,143,113,89,210,218,79,114,193,226,104,145,184,18,54,73,35,56,60,12,15,113,201,236,42,199,149,58,207,52,86,228,54,242,101,63,40,5,115,198,57,255,0,119,31,159,78,215,109,96,132,219,194,0,221,180,150,86,115,185,179,156,158,125,115,154,91,129,31,217,32,138,88,230,35,27,51,140,30,253,63,250,213,36,115,67,129,26,130,161,48,160,99,24,29,49,239,85,110,181,31,42,55,72,49,44,168,112,21,84,190,57,231,32,125,15,191,74,91,171,201,44,244,226,210,132,55,25,220,176,238,220,70,73,192,63,134,70,122,112,113,76,9,165,130,67,132,182,144,71,
24,201,39,60,238,201,207,175,28,254,24,162,159,101,113,29,212,11,44,97,153,6,84,174,70,84,241,193,247,162,152,21,84,92,217,190,247,47,114,172,14,255,0,159,133,247,231,191,30,212,219,139,11,107,187,87,16,17,1,152,103,118,6,71,32,242,7,211,249,213,187,169,25,172,216,162,7,56,35,118,224,87,0,224,253,127,198,171,233,42,39,178,113,33,98,155,182,249,103,145,140,115,249,146,127,207,84,4,214,123,86,218,32,165,71,202,48,84,96,176,245,198,7,81,237,68,168,242,36,145,137,54,23,4,2,49,144,121,233,74,202,193,76,49,7,136,42,0,146,12,31,81,142,71,96,57,207,173,58,109,254,67,121,96,7,232,14,50,87,61,241,198,64,160,67,228,149,133,179,206,8,114,129,178,87,166,65,57,31,161,21,205,77,56,157,229,153,243,243,158,220,99,39,233,235,222,181,237,175,126,213,26,69,42,7,103,82,146,21,39,0,168,235,140,103,144,65,231,214,178,175,108,228,181,144,162,41,149,15,241,184,56,239,199,183,2,147,212,104,223,181,190,130,237,246,162,176,117,25,42,222,158,188,100,30,221,234,217,28,12,146,0,230,185,237,34,234,218,206,102,
18,179,33,108,168,56,1,70,78,78,127,16,63,51,93,8,109,200,93,72,111,77,188,230,169,59,137,149,47,5,196,146,71,12,114,36,33,155,27,136,14,254,167,27,191,46,51,214,163,212,109,229,158,49,28,108,170,229,192,217,187,110,254,229,73,28,253,220,255,0,158,150,229,5,176,81,21,200,59,114,120,32,103,7,159,233,237,77,131,50,66,174,87,18,33,32,174,122,28,227,63,136,231,232,104,0,137,85,33,242,16,22,120,163,81,243,140,118,227,39,30,213,86,59,123,84,191,89,226,139,205,103,222,12,219,183,8,206,114,87,29,191,139,241,250,213,224,192,97,202,149,56,201,83,140,143,106,65,178,85,249,58,114,56,24,160,8,110,182,27,103,221,56,132,56,41,188,224,108,63,95,211,235,82,39,200,193,11,111,43,212,240,15,61,200,20,173,108,141,23,151,50,249,128,1,247,135,95,127,173,11,20,65,64,140,96,32,227,7,0,14,159,133,0,53,196,130,80,6,10,158,73,39,144,49,199,212,231,233,78,142,69,98,219,67,97,88,169,200,35,156,125,57,235,66,7,37,204,202,129,67,97,48,73,36,123,254,167,241,168,218,234,37,185,88,6,25,176,73,198,62,76,17,215,
243,160,10,26,155,220,44,74,177,169,47,230,146,133,70,123,116,62,252,212,145,160,183,211,163,123,196,121,25,95,204,56,234,8,228,19,147,201,28,14,166,180,54,129,33,60,130,14,6,70,121,168,174,162,91,132,242,201,216,164,115,140,243,234,5,0,102,11,232,175,139,143,154,38,71,218,8,36,101,120,238,43,70,222,40,214,215,100,76,228,103,118,72,201,39,223,140,87,57,120,214,240,220,203,228,179,130,175,183,12,59,142,58,231,165,110,91,207,4,54,171,36,210,133,82,64,14,78,55,113,82,134,101,234,54,215,178,76,9,183,103,9,242,174,192,196,17,207,161,35,53,56,23,16,218,195,35,205,58,178,147,148,223,149,29,48,62,152,29,15,248,214,200,144,201,14,228,33,131,15,148,19,140,254,61,185,172,109,110,231,125,200,128,58,249,105,243,62,87,31,54,15,244,254,116,62,224,92,187,189,242,161,34,95,146,232,38,84,108,56,250,119,25,237,214,169,105,154,67,164,239,52,173,42,100,28,171,30,185,57,255,0,10,207,91,151,158,225,103,197,196,203,110,194,71,228,103,104,57,234,199,147,237,239,91,111,118,35,129,46,109,81,238,35,119,
231,230,35,3,4,101,65,250,116,239,250,209,190,172,12,139,171,187,136,149,131,188,136,199,4,7,114,49,244,230,182,52,203,153,102,136,73,54,64,63,42,247,200,207,94,153,246,255,0,128,231,189,90,158,214,11,149,49,206,135,0,229,88,140,31,192,254,148,34,41,137,60,130,165,112,10,109,232,70,61,187,82,73,161,220,198,214,46,36,182,242,161,181,219,20,65,88,199,176,149,96,221,14,8,232,57,232,61,123,85,55,212,158,120,108,224,156,180,128,73,251,210,24,174,245,221,211,150,193,56,238,113,219,220,215,66,246,240,77,242,202,129,135,222,193,25,233,76,154,198,23,120,115,229,170,196,217,218,16,12,143,79,243,218,141,64,144,50,92,42,202,185,42,227,35,35,110,65,250,210,36,59,11,50,162,130,199,39,220,240,51,250,126,149,38,81,78,196,0,108,81,242,40,192,81,208,126,28,82,143,66,251,78,115,145,223,252,243,78,218,136,142,212,121,22,254,67,76,36,117,27,153,183,118,36,156,251,14,191,149,73,16,145,17,68,170,158,102,63,132,156,126,103,249,154,147,169,31,42,228,240,72,224,227,159,254,189,67,121,44,118,168,101,151,
229,141,122,224,18,122,251,123,211,17,40,32,43,147,133,78,172,199,129,142,245,135,169,107,70,98,177,233,197,138,131,243,72,192,140,244,198,57,235,156,231,62,149,45,198,164,143,20,109,36,106,209,28,230,221,159,57,25,224,177,198,59,30,57,234,13,81,183,134,54,140,6,114,20,14,135,130,78,63,250,212,152,198,9,111,68,139,33,158,86,80,49,203,31,167,3,215,173,104,233,87,66,87,41,112,128,201,185,74,179,114,192,250,103,234,127,157,80,31,44,159,34,253,11,15,97,192,0,116,171,182,46,182,251,231,109,199,229,192,81,198,238,153,205,0,3,75,23,44,205,109,114,82,7,98,254,83,112,20,231,25,0,122,224,254,20,85,155,120,83,103,218,33,157,227,86,194,144,203,158,121,244,234,61,232,170,176,139,211,178,90,47,154,23,175,4,3,199,111,240,170,49,223,199,119,49,133,124,192,35,111,48,51,1,198,8,200,252,121,31,141,20,80,4,78,134,239,83,140,200,204,68,103,122,161,39,104,199,78,61,65,25,247,253,43,69,152,170,176,236,48,127,50,69,20,84,161,145,253,167,204,91,134,198,223,36,252,216,238,7,38,168,234,119,9,42,201,111,
177,188,200,142,67,110,192,193,231,241,244,246,162,138,108,12,248,2,204,164,177,101,146,1,230,54,57,86,81,142,128,244,60,212,90,117,203,179,129,28,243,199,111,184,22,64,121,57,233,207,225,233,233,69,20,128,235,221,194,109,78,73,60,2,121,252,235,10,210,229,213,229,66,205,34,111,105,14,73,82,9,200,192,193,198,59,253,121,250,20,85,48,44,91,106,78,64,134,118,243,24,176,93,251,0,60,156,116,233,255,0,214,162,13,68,42,8,188,178,140,185,25,86,45,192,62,167,154,40,164,246,17,86,15,244,123,166,184,73,167,249,184,41,230,28,19,201,25,206,114,61,250,243,91,138,124,221,178,70,204,160,243,207,126,104,162,132,3,152,24,227,235,187,158,50,113,89,183,22,182,112,202,147,125,159,50,59,110,206,242,70,79,57,193,239,69,20,192,132,67,51,204,94,121,73,27,182,198,3,31,148,246,53,107,100,209,136,156,204,197,20,143,147,60,17,205,20,82,2,56,146,222,242,83,114,109,208,56,0,177,60,231,168,254,84,213,211,66,88,139,105,152,72,195,238,201,140,16,58,254,29,0,162,138,6,54,198,193,172,165,2,57,55,44,131,4,30,57,245,
255,0,62,180,147,105,102,234,89,36,105,153,36,44,115,142,70,59,15,202,138,41,32,35,77,56,233,235,43,25,140,144,200,134,60,116,35,113,3,222,175,88,39,218,44,163,98,193,183,6,27,138,5,224,19,142,7,30,148,81,78,192,61,46,0,145,96,69,57,251,163,61,58,102,164,154,64,155,131,3,242,46,227,142,227,6,138,41,8,107,206,130,64,133,114,88,19,237,193,170,210,106,17,71,156,163,16,164,131,211,214,138,40,25,106,54,89,45,214,109,163,145,145,237,197,38,255,0,221,121,138,56,198,113,211,181,20,85,8,122,177,11,156,13,216,6,179,181,9,22,123,54,75,148,46,170,84,54,214,198,73,57,255,0,217,104,162,165,140,168,45,149,255,0,210,20,109,140,133,42,128,159,149,66,19,239,206,23,243,168,213,248,105,2,133,27,119,0,57,35,243,250,81,69,0,77,27,5,140,14,112,164,131,254,127,10,145,101,50,32,82,73,82,113,201,237,69,20,196,104,37,215,154,24,197,148,10,118,145,142,253,104,162,138,96,127,255,217);

back_stone:array[0..15706] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,23,16,17,20,17,14,23,20,18,20,26,24,23,27,34,57,37,34,31,31,34,70,50,53,41,57,82,72,87,85,81,72,80,78,91,102,131,111,91,97,124,98,78,80,114,155,115,124,135,139,146,148,146,88,109,160,172,159,142,170,131,143,146,141,255,219,0,67,1,24,26,26,34,30,34,67,37,37,67,141,94,80,94,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,255,192,0,17,8,1,61,1,89,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,
122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,
250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,176,195,43,237,222,157,63,148,177,110,71,93,221,6,15,90,141,90,67,144,85,112,8,201,207,106,126,224,132,0,170,20,242,113,92,201,51,87,98,56,220,220,68,195,238,183,245,167,238,40,2,185,201,35,32,117,38,156,54,144,85,127,12,83,34,18,46,71,83,250,138,161,3,179,196,119,4,44,222,131,173,44,133,207,65,248,209,188,183,202,1,66,189,186,211,7,152,210,252,178,236,247,198,115,76,8,140,170,229,215,42,172,188,96,158,188,117,169,227,66,145,2,164,31,80,56,168,158,209,224,103,145,20,190,238,15,122,124,88,81,128,195,24,200,231,138,76,7,43,239,113,142,220,98,156,208,202,115,144,8,39,241,20,216,216,11,143,152,229,136,224,118,205,88,93,254,96,7,166,58,82,2,36,141,82,64,15,111,106,73,209,28,124,227,35,173,73,112,193,10,228,31,74,137,228,94,6,15,39,29,41,59,220,106,197,114,89,50,138,255,0,33,227,167,74,146,59,117,85,82,132,134,207,36,113,154,129,220,9,182,63,25,239,87,99,145,20,236,39,145,237,138,122,139,65,74,182,42,52,82,25,139,247,232,58,210,249,231,206,242,
193,4,1,146,113,210,134,147,4,100,129,158,149,72,66,109,193,227,57,197,67,46,252,128,23,57,239,138,183,24,71,234,70,125,250,138,135,32,177,249,186,103,173,0,10,50,57,28,103,154,141,148,187,101,78,84,100,102,146,41,3,49,198,118,158,245,34,243,194,246,237,73,177,162,120,95,106,40,33,155,215,3,53,94,246,124,143,45,84,198,228,253,227,197,56,43,62,87,36,125,42,69,10,242,134,56,38,63,187,206,126,180,151,152,16,219,18,99,30,100,156,243,145,255,0,215,164,119,141,37,27,78,65,31,149,89,145,90,67,185,118,238,28,99,189,71,26,27,133,63,187,193,247,226,168,68,106,196,227,105,224,122,246,53,50,202,78,73,92,115,201,6,171,60,115,71,54,220,48,24,251,198,164,86,219,195,31,254,189,38,134,19,162,228,186,252,164,142,72,21,30,247,84,27,121,247,2,160,188,212,4,44,17,6,246,61,135,97,83,65,46,252,58,29,202,122,17,222,157,172,3,162,49,221,229,88,43,99,131,197,76,209,8,226,62,87,202,0,224,118,168,67,249,115,28,112,91,158,149,51,144,202,87,37,65,227,52,8,34,143,118,50,192,156,122,210,178,0,159,188,201,21,
17,64,136,10,156,1,239,83,43,174,210,3,96,145,222,128,50,110,45,47,30,229,90,28,249,57,206,51,211,240,239,87,99,83,27,135,108,144,7,78,188,212,171,254,179,27,135,76,224,113,83,164,125,65,92,134,239,64,0,144,56,12,58,83,138,159,225,235,138,132,20,66,201,156,21,167,135,39,129,158,105,88,99,30,21,127,190,1,0,228,102,144,227,118,64,233,197,60,150,57,39,165,55,203,11,157,188,115,76,64,102,216,225,3,41,98,51,239,82,2,37,143,114,231,142,181,94,40,202,114,64,221,220,142,166,155,44,173,110,48,132,109,99,147,64,15,55,10,185,70,86,221,234,7,31,157,49,247,18,72,224,31,106,148,109,16,171,16,119,55,52,9,10,146,54,252,135,189,0,68,161,130,128,35,64,79,115,159,241,169,54,159,238,210,72,160,13,199,119,30,212,187,143,168,252,233,52,49,100,57,66,84,28,116,36,14,213,18,43,46,208,196,242,120,200,167,169,112,50,185,31,74,92,114,67,202,24,168,200,201,230,141,128,122,252,185,32,80,114,114,15,0,251,211,12,160,96,140,144,125,168,36,151,7,63,90,77,130,24,192,170,225,79,63,210,161,27,204,138,51,192,231,
39,189,78,228,179,20,3,57,20,197,77,144,227,110,85,122,123,85,32,37,89,102,82,161,88,96,245,246,168,46,128,144,230,93,235,158,241,146,51,245,169,20,110,92,198,20,49,224,110,60,154,85,102,19,0,227,182,8,244,160,67,226,145,33,137,34,229,142,56,245,62,244,169,112,20,96,224,28,245,168,164,17,179,176,137,129,200,227,219,218,163,9,10,228,60,108,204,122,114,105,88,101,214,96,80,243,158,245,86,54,118,80,204,152,231,215,181,44,31,55,200,8,95,169,169,100,136,134,200,32,175,64,69,8,25,20,241,137,74,190,220,182,123,84,210,68,30,100,57,32,175,95,122,68,144,169,17,149,200,57,195,14,180,228,73,3,150,221,184,30,199,173,49,12,49,173,187,182,6,224,254,252,208,54,129,247,129,247,169,22,32,121,35,11,156,224,211,37,66,192,108,235,237,74,250,140,106,128,209,187,17,140,28,115,252,233,163,107,33,86,3,61,79,248,212,200,124,200,240,120,62,194,171,72,49,158,115,66,96,17,168,84,192,29,243,79,206,79,90,141,73,192,200,167,41,205,0,58,69,44,140,65,60,142,212,200,16,170,157,163,7,175,39,173,76,191,48,192,56,
160,40,137,185,110,131,60,208,4,23,15,242,168,109,202,195,145,142,227,210,172,219,204,35,194,177,207,28,28,84,19,57,206,192,56,61,143,74,97,80,200,23,113,36,123,208,128,210,145,209,151,174,107,46,233,75,166,244,227,3,62,153,166,92,171,20,85,220,56,29,51,82,66,3,70,22,76,231,167,52,1,152,29,164,189,147,128,160,252,167,61,51,83,91,91,203,5,200,141,100,223,27,29,220,127,9,171,235,4,97,79,46,119,118,6,150,59,88,84,130,169,142,244,92,7,36,109,231,57,192,192,199,39,189,60,238,113,146,55,47,67,197,73,19,34,166,223,67,192,163,204,2,66,23,230,67,247,168,2,33,25,243,132,128,130,42,80,165,152,171,116,245,199,56,250,210,103,247,128,71,187,24,206,71,79,165,42,182,7,28,54,123,208,129,140,141,66,184,233,220,242,115,83,75,38,196,224,100,158,128,84,2,63,153,159,61,122,250,254,20,168,172,36,44,100,220,49,192,61,168,96,53,54,146,197,186,154,78,60,204,43,145,129,247,65,160,38,9,56,237,211,53,42,166,228,243,7,64,122,250,208,3,179,193,24,57,165,31,59,240,126,111,74,68,100,44,138,196,6,94,160,85,176,
99,4,129,180,30,189,40,184,88,129,162,219,207,115,233,80,54,201,24,252,249,42,121,2,172,179,133,96,168,220,103,156,156,154,134,105,162,81,140,50,0,123,80,128,144,198,95,33,71,203,211,38,144,194,184,108,231,154,142,19,40,144,179,49,193,232,49,199,214,172,103,154,0,135,203,80,189,9,199,115,77,222,63,201,169,92,241,192,250,213,108,31,79,214,129,8,173,32,27,78,61,141,44,104,67,18,15,94,13,53,1,124,14,130,156,238,35,113,25,94,88,124,164,80,198,62,69,10,132,227,167,53,94,36,149,142,231,33,87,208,119,169,218,49,42,108,115,131,158,113,77,98,138,126,76,251,241,69,128,69,137,92,178,150,193,83,145,138,148,58,70,160,48,227,190,69,64,75,43,252,170,8,60,156,84,200,51,24,46,164,131,205,0,49,226,98,251,131,237,94,192,28,84,97,25,174,129,145,200,85,198,51,235,158,149,96,54,230,195,12,14,212,143,25,4,54,14,9,255,0,38,139,133,135,236,183,4,252,170,15,99,142,255,0,90,137,195,20,61,201,234,105,72,228,145,199,181,48,177,9,142,167,218,128,43,156,6,4,241,248,212,161,128,233,156,125,105,185,141,223,24,
32,142,198,156,238,168,164,132,206,41,136,144,62,229,83,140,31,229,83,43,1,199,173,68,168,211,70,29,97,199,31,149,40,4,99,6,149,135,114,102,35,4,10,133,102,82,229,84,231,29,72,233,67,2,200,66,156,99,131,72,170,17,118,128,0,237,78,194,3,145,157,162,162,114,234,64,42,25,125,71,81,82,158,164,122,12,212,80,72,101,139,115,40,92,244,193,205,33,139,41,49,40,44,54,169,233,66,114,155,243,158,58,98,157,229,7,32,62,10,131,78,200,70,7,110,238,220,80,3,25,151,122,140,144,231,176,237,72,21,158,92,56,44,49,215,52,226,155,159,60,99,61,59,211,246,40,101,35,131,158,198,152,17,186,133,113,184,99,183,90,82,136,1,32,131,234,49,83,49,101,227,212,114,121,235,77,141,37,156,18,19,215,158,131,255,0,175,72,69,23,143,205,202,32,57,207,94,212,232,97,112,227,158,9,193,62,181,110,75,57,226,93,209,4,227,175,114,41,145,157,138,20,144,114,115,159,90,96,43,15,47,143,81,193,197,49,36,207,96,51,77,102,148,3,24,93,233,208,19,78,64,23,10,72,30,185,164,134,18,118,101,29,123,211,162,112,231,157,200,64,234,14,69,50,76,
114,170,118,147,208,245,205,75,14,253,164,186,227,29,232,176,92,153,136,138,44,129,183,140,116,235,80,146,220,41,199,212,245,168,102,150,77,224,100,149,199,7,20,59,19,243,28,156,142,212,208,152,249,203,46,208,132,49,205,72,9,108,17,198,121,170,166,103,138,229,64,80,85,134,15,181,78,126,112,1,28,10,0,120,117,137,137,216,78,125,77,73,230,41,32,228,128,120,166,0,31,228,117,227,212,117,21,30,93,78,56,249,71,4,247,164,50,97,18,175,42,75,14,188,154,115,99,0,149,206,58,10,171,36,133,194,124,187,8,234,85,186,211,188,210,58,243,198,126,180,172,4,174,202,91,126,54,149,227,34,162,147,121,96,56,57,227,38,148,130,196,145,158,189,168,39,100,36,48,7,232,40,216,100,177,178,42,42,179,128,71,3,38,145,156,231,25,252,69,69,228,237,234,72,3,242,53,40,220,234,6,14,62,180,196,43,92,110,67,229,198,125,203,113,85,247,191,183,229,86,130,20,140,255,0,83,80,111,30,130,132,1,43,42,108,32,18,164,227,142,212,196,114,146,2,196,48,82,121,39,165,61,84,150,222,161,254,94,54,142,244,58,16,73,249,73,110,64,244,160,
8,65,115,24,145,70,228,39,174,122,213,142,29,207,108,210,74,187,109,225,92,133,35,31,202,152,175,184,97,27,57,232,84,228,26,107,81,49,193,2,156,3,206,115,82,163,113,181,177,129,235,80,153,21,49,184,129,142,164,212,45,51,73,48,41,243,71,130,63,28,82,176,203,51,72,16,18,160,96,117,57,167,194,203,36,101,186,143,82,106,56,103,141,34,231,229,110,164,17,76,102,204,132,46,227,184,114,61,169,1,59,99,140,116,168,100,144,36,123,152,157,160,250,84,139,247,70,58,84,119,74,190,65,81,158,72,233,215,173,48,1,134,10,232,9,244,226,156,144,188,243,239,56,192,235,218,148,32,80,3,183,78,50,59,212,138,225,91,105,124,100,113,138,119,17,49,116,142,45,170,122,100,115,214,171,135,68,192,108,100,241,214,148,21,36,4,32,145,212,85,107,180,243,24,5,62,217,2,132,5,162,57,198,9,21,19,184,25,33,11,31,106,70,38,36,10,1,44,170,7,34,146,55,153,212,47,149,184,183,67,219,20,0,239,48,121,125,8,108,103,4,82,91,196,18,49,242,227,60,144,58,19,72,249,46,71,204,10,245,90,121,80,88,113,156,30,134,144,199,54,49,185,126,
82,42,24,18,73,62,98,164,103,160,254,181,33,71,36,143,187,234,106,104,159,12,80,99,24,226,128,33,104,129,143,14,50,231,169,167,136,149,0,61,112,42,73,27,140,84,59,216,144,85,50,7,82,122,10,58,8,89,164,1,15,202,205,236,189,105,208,50,170,137,20,228,149,199,39,173,66,0,185,155,102,74,129,216,127,58,181,111,26,8,135,200,20,228,245,28,129,64,197,251,67,134,201,32,41,232,59,213,73,148,100,203,34,129,232,42,227,150,137,93,151,18,1,208,99,165,65,38,31,35,0,30,199,214,128,35,15,132,1,87,36,142,57,197,73,17,8,54,50,3,159,189,222,163,104,210,100,57,206,71,66,13,10,19,40,84,21,66,58,115,147,72,9,145,83,113,96,0,31,78,148,13,228,140,224,47,113,80,181,214,233,74,58,236,219,200,0,245,169,140,128,168,97,145,158,180,192,137,193,25,10,1,237,130,105,8,199,78,105,74,103,230,222,66,156,96,10,121,141,17,126,81,141,199,36,129,74,225,98,23,85,105,126,230,113,212,251,84,145,128,121,94,135,156,122,83,217,85,83,230,28,250,212,112,15,222,131,219,60,175,74,96,79,229,158,167,30,245,4,234,170,155,162,86,118,
237,87,152,98,170,72,73,144,140,1,245,160,10,69,223,121,89,19,146,50,0,167,150,109,160,224,51,14,222,213,43,4,222,64,193,61,233,193,81,49,180,96,122,10,4,69,12,161,1,89,50,1,62,157,42,127,151,32,171,15,206,152,247,77,144,22,13,217,239,197,39,152,129,151,125,191,95,78,104,106,227,185,41,114,176,50,144,50,79,36,84,81,184,110,81,151,104,245,56,230,163,184,141,102,204,113,134,64,223,129,166,199,2,164,101,20,22,96,48,51,218,132,128,183,230,151,76,21,218,125,170,47,42,58,14,228,81,188,134,32,14,130,147,204,255,0,98,129,11,35,157,161,79,92,228,1,197,53,230,8,141,179,59,219,177,52,226,202,201,176,231,220,231,21,12,223,34,238,64,25,137,206,49,212,123,83,2,73,215,237,88,69,44,163,28,158,134,163,67,13,172,138,136,24,224,96,159,74,116,87,4,163,38,113,34,253,241,142,130,159,36,232,136,21,72,4,240,71,181,37,113,177,29,214,67,183,185,233,154,91,120,34,144,190,25,148,129,134,231,189,86,153,153,16,50,158,55,113,142,213,36,82,76,90,55,136,15,155,239,18,58,211,17,108,36,80,0,204,249,231,171,81,
42,35,48,104,158,48,122,28,122,85,89,183,187,249,140,193,130,143,184,6,42,91,118,43,51,159,188,155,65,227,181,0,49,218,69,108,32,82,189,216,183,2,164,65,35,41,40,160,142,199,56,205,36,167,204,125,235,128,163,160,61,233,202,219,83,61,170,91,26,17,67,150,201,63,40,224,140,84,246,137,24,46,202,62,98,112,115,80,171,171,169,227,138,108,152,141,23,202,59,15,114,123,211,76,25,45,215,149,231,166,120,35,169,28,83,35,89,14,114,224,143,225,219,253,106,34,85,136,231,44,71,52,174,210,65,130,72,218,71,99,64,22,127,118,28,137,6,72,35,38,166,19,70,62,80,220,10,204,73,101,18,6,141,114,189,242,121,169,21,156,176,44,155,51,192,231,56,247,160,9,174,84,40,45,26,179,190,106,178,74,235,48,18,141,188,110,24,237,86,179,187,3,35,62,226,153,40,134,38,204,135,25,247,161,48,177,50,149,144,124,167,52,113,24,222,231,254,2,42,186,180,114,178,172,32,185,239,140,113,245,167,20,97,54,73,206,193,141,167,165,0,30,102,233,119,41,228,158,57,171,41,130,133,64,28,245,170,241,193,18,110,117,28,183,36,158,181,26,134,140,
57,141,155,4,140,81,184,19,174,216,223,5,128,110,159,90,176,160,14,9,170,99,153,22,70,43,233,134,236,106,91,139,163,20,67,0,14,128,147,70,224,62,236,59,32,0,225,71,39,29,77,83,93,251,142,65,13,219,35,181,63,126,78,90,93,223,65,70,237,135,25,24,231,28,116,166,32,242,144,174,220,150,233,158,105,234,232,54,163,48,82,56,25,168,144,57,132,110,0,54,58,226,152,177,20,37,157,132,164,254,20,182,220,100,175,18,51,49,15,25,90,55,42,62,6,226,113,208,85,152,98,10,128,48,252,40,88,86,32,193,71,122,47,112,41,253,165,211,119,153,23,201,233,222,166,89,124,212,204,127,119,215,60,210,73,130,197,70,61,234,168,140,199,43,60,99,142,152,207,90,73,32,108,151,205,84,32,146,197,122,28,140,243,86,14,215,76,175,94,245,65,152,237,63,46,95,161,239,244,169,227,5,16,239,126,212,192,157,100,116,225,137,34,160,203,188,234,170,112,51,147,223,34,144,92,13,251,87,145,223,61,170,76,149,145,10,186,140,30,114,40,216,4,185,83,20,91,155,27,179,192,205,71,110,254,100,4,134,203,110,198,49,78,158,116,118,62,105,93,163,175,
173,64,147,24,7,220,198,114,64,11,71,64,45,60,78,223,56,35,212,131,253,42,52,2,53,12,174,85,79,82,71,106,103,152,242,204,128,202,81,58,176,2,172,205,182,68,242,85,67,1,142,72,205,49,13,119,41,41,112,67,169,0,12,246,167,38,228,70,36,127,245,234,161,138,75,78,91,231,71,112,54,129,147,86,255,0,116,114,155,138,51,116,7,250,82,24,200,255,0,122,166,78,1,7,24,207,74,118,15,249,2,145,173,182,33,193,228,211,54,183,168,164,2,19,181,156,2,59,96,154,148,35,60,96,231,115,100,140,3,142,41,194,52,218,10,241,248,82,12,47,205,142,188,115,76,8,141,178,166,8,143,13,208,156,84,119,8,35,116,218,6,72,199,90,186,242,175,148,85,72,36,240,79,165,71,16,76,144,57,101,224,146,40,184,172,87,134,215,124,164,72,27,106,140,243,210,172,58,1,242,157,163,29,49,79,119,40,133,212,100,142,160,241,154,103,218,35,108,177,92,17,235,75,113,148,229,243,144,149,103,10,113,201,199,244,161,92,52,74,177,19,242,158,163,233,82,202,82,73,114,203,207,99,78,138,221,94,85,200,224,115,84,34,40,229,103,98,29,118,224,227,173,74,84,
170,12,54,84,245,21,96,90,198,161,182,18,185,29,206,106,158,55,39,223,201,233,129,64,22,80,2,6,222,61,169,151,68,20,95,108,210,135,242,192,10,185,252,105,179,144,193,113,207,6,146,25,90,54,42,249,28,142,212,233,9,150,77,172,66,167,83,207,52,224,131,1,136,235,83,71,0,198,64,198,14,64,166,33,91,106,70,68,64,100,80,161,202,18,220,144,62,239,74,112,136,17,146,71,212,83,8,13,144,173,200,164,49,85,136,108,237,228,119,246,168,239,35,141,149,102,156,22,41,209,123,115,235,79,12,89,240,20,238,199,39,60,82,48,70,34,46,172,70,72,161,43,6,226,91,78,88,42,3,131,252,169,242,79,182,82,165,78,123,154,106,68,11,231,5,79,74,124,139,187,168,0,14,166,128,34,19,169,45,150,207,168,7,175,210,156,243,193,130,128,114,188,253,227,81,189,170,72,235,180,168,108,247,52,153,120,228,16,152,203,17,233,78,194,184,134,224,249,202,22,49,130,70,119,30,149,52,233,44,128,18,163,30,199,154,106,152,90,102,86,92,21,228,241,156,125,42,120,164,29,137,32,242,51,218,147,118,30,228,130,37,69,249,71,231,222,163,127,153,185,
92,158,220,83,89,230,32,148,127,168,53,20,47,33,102,243,112,49,198,1,161,3,30,24,162,101,163,200,254,239,92,81,42,200,165,65,92,231,158,191,165,49,183,228,2,228,2,125,115,82,137,136,36,174,61,233,1,97,37,56,249,145,135,167,25,164,83,32,102,98,126,241,232,122,84,38,94,132,176,227,170,138,107,184,102,86,92,2,58,18,57,20,32,7,103,118,117,10,168,15,39,29,105,164,50,100,255,0,15,173,62,57,83,118,39,96,167,177,29,233,236,185,206,57,30,160,211,64,82,138,92,204,58,115,193,207,122,176,202,210,14,24,3,238,42,25,33,15,48,195,116,25,197,61,136,73,19,4,15,165,49,14,242,194,224,2,21,143,64,59,213,75,167,125,248,236,122,30,213,52,195,247,172,249,4,158,56,237,70,209,180,6,60,117,193,52,154,184,239,98,180,16,200,237,156,140,147,220,85,244,216,0,36,131,129,130,72,205,68,36,69,192,64,75,126,117,60,191,112,24,128,95,90,44,4,114,237,243,0,10,114,222,135,21,50,58,198,58,53,85,56,50,151,249,139,17,215,53,109,83,114,130,188,140,116,61,77,12,6,188,137,40,62,171,206,106,7,196,203,229,156,227,60,12,83,
228,8,196,108,24,246,160,225,127,189,215,242,166,149,132,73,16,104,193,89,73,35,177,205,46,19,219,245,166,201,38,224,63,157,55,241,165,97,143,85,40,167,141,196,212,47,49,117,216,200,201,158,228,84,190,103,204,1,198,123,251,84,18,220,199,149,92,156,142,126,180,0,248,23,108,69,73,221,159,155,39,138,150,53,27,75,110,39,113,192,0,83,14,25,62,94,184,227,52,242,75,69,242,48,14,123,250,81,112,35,157,75,168,220,204,48,122,14,148,229,133,85,126,108,125,115,78,220,89,8,101,32,143,94,134,160,196,243,70,197,74,170,131,192,63,211,52,0,187,67,157,167,138,150,217,86,41,10,238,201,30,244,216,160,151,57,114,165,127,90,14,87,4,113,219,214,139,244,1,243,202,115,181,71,212,250,84,74,169,176,10,20,21,136,135,109,196,158,189,51,68,113,51,28,40,206,57,160,6,252,184,31,56,60,144,113,79,203,75,194,42,168,31,222,230,157,229,42,43,101,70,122,211,130,129,198,127,42,76,17,28,160,44,120,80,14,41,60,221,138,170,15,24,206,5,12,68,111,176,246,28,100,245,166,73,58,101,142,50,0,206,236,112,42,144,15,102,114,131,
147,248,82,124,249,92,99,208,138,88,131,17,189,115,180,138,88,201,19,243,142,120,164,4,104,133,174,10,150,199,57,192,110,113,86,86,21,142,93,234,10,228,228,226,148,197,10,183,153,181,119,255,0,127,28,213,119,121,94,76,198,223,47,113,64,19,130,55,30,148,147,72,198,51,179,233,205,64,200,229,179,188,168,238,170,58,212,201,17,100,220,100,193,236,61,40,2,1,110,242,202,36,36,168,3,149,207,6,172,42,174,126,78,15,76,247,52,210,95,206,192,4,40,28,224,119,245,163,113,110,1,198,63,90,77,177,160,145,24,56,8,58,127,17,25,168,220,146,75,33,0,255,0,119,214,158,147,21,111,222,28,175,126,41,51,27,72,70,14,15,29,41,110,27,17,196,93,99,195,17,215,211,21,38,252,39,24,247,247,167,136,80,50,129,199,227,73,52,1,6,244,31,239,14,244,196,68,216,249,119,144,65,224,28,125,223,165,36,113,136,254,225,99,156,245,239,79,151,230,139,25,25,207,6,164,140,38,57,108,227,189,8,10,211,2,211,0,6,72,92,211,215,56,195,30,157,192,167,201,25,14,36,198,127,10,102,252,178,227,133,250,85,8,138,89,118,92,199,144,197,185,0,
1,197,88,73,62,93,192,168,207,67,214,171,94,186,159,149,50,24,250,15,206,164,143,238,42,182,72,7,156,208,3,237,239,162,30,99,59,130,49,248,159,97,83,2,172,158,106,68,87,61,65,234,69,86,107,104,218,64,241,71,140,158,160,116,57,169,228,113,12,99,229,39,177,35,181,72,199,41,249,9,34,162,218,8,5,134,49,201,207,74,89,15,154,187,114,0,36,17,207,74,123,0,188,49,45,142,217,167,96,184,182,177,13,165,136,206,122,84,55,162,85,128,249,43,243,118,205,88,105,60,146,131,36,161,24,0,1,67,201,230,17,133,32,246,4,81,212,8,45,226,127,37,119,144,91,215,165,61,151,3,106,158,71,25,7,20,187,138,241,140,10,49,33,57,69,249,79,94,113,76,68,40,84,171,147,146,84,224,231,249,210,177,243,92,42,157,160,31,155,214,163,72,36,73,114,14,70,122,213,167,6,64,6,208,74,244,97,64,17,4,86,206,56,231,243,165,242,135,247,205,53,149,247,12,28,114,112,49,78,203,255,0,117,105,88,99,194,130,120,224,210,52,81,146,20,224,96,113,142,244,144,1,142,164,156,244,53,36,106,100,98,49,130,7,67,76,65,26,8,215,46,50,216,238,42,28,133,
145,138,156,41,57,32,84,183,16,73,44,46,48,23,177,193,193,166,34,101,187,5,160,5,82,193,199,7,30,221,170,73,100,12,20,239,35,215,138,138,41,0,145,163,39,230,251,192,123,81,42,225,73,11,144,59,84,117,177,68,158,110,192,2,144,212,130,117,108,172,128,7,29,133,50,32,133,200,251,167,29,41,204,164,119,231,212,85,8,135,153,25,68,99,129,207,204,56,171,144,108,136,177,61,78,58,85,83,192,1,123,119,165,23,1,71,168,246,164,5,137,151,205,36,141,164,31,126,149,28,112,111,147,40,219,113,215,189,34,76,28,101,84,63,61,142,41,222,90,173,194,204,173,179,35,145,158,180,0,146,217,186,49,117,33,142,49,244,170,119,39,236,251,119,144,160,214,163,58,72,161,50,64,237,205,71,42,68,99,104,216,111,7,144,122,211,64,66,84,24,240,141,129,140,241,76,4,130,1,92,103,161,245,169,143,24,203,28,116,24,25,166,24,228,103,4,46,66,159,206,128,28,196,200,14,49,129,215,53,10,200,174,135,10,193,143,32,226,146,222,87,133,136,148,99,147,205,89,89,99,145,65,86,28,247,197,22,1,185,1,1,199,255,0,90,164,142,37,10,10,224,28,244,
52,27,102,56,37,240,58,154,171,114,118,56,93,220,158,105,216,69,171,153,68,113,134,92,19,156,28,85,57,75,18,24,125,209,212,80,184,50,168,45,147,158,148,231,86,192,86,4,19,206,7,74,67,16,178,186,46,233,50,125,49,78,84,100,227,112,217,212,14,245,26,237,68,109,163,145,201,167,35,41,63,49,36,19,193,20,88,9,163,108,30,64,198,122,212,210,50,162,238,251,192,142,149,78,73,140,78,84,16,64,28,84,192,147,16,37,87,223,52,88,2,24,210,87,96,8,207,166,41,90,51,11,128,23,229,61,199,175,189,66,82,57,6,252,150,113,253,211,142,126,181,34,13,235,230,62,114,191,194,205,156,125,13,0,43,46,231,27,178,64,167,173,184,50,111,35,143,65,81,171,224,96,144,49,206,106,117,155,104,31,41,252,169,136,174,209,197,20,199,118,91,36,12,10,95,179,219,151,37,67,168,60,96,211,207,151,43,229,251,118,28,84,115,72,128,241,198,58,14,230,128,17,96,217,39,202,193,151,211,56,167,186,225,75,96,1,216,19,222,160,68,119,0,145,219,185,169,164,140,38,211,34,157,203,220,115,72,100,40,133,67,4,56,32,244,53,52,108,126,241,27,72,236,
106,51,58,146,81,84,183,174,69,74,178,161,254,19,211,24,52,174,22,12,249,237,144,225,24,28,12,142,180,18,251,143,64,65,193,239,72,54,185,5,67,96,122,140,82,109,231,4,145,245,161,177,162,94,60,196,86,32,230,164,200,124,170,246,170,232,34,4,146,223,55,235,77,140,186,200,74,71,140,156,100,210,1,242,23,204,74,163,4,158,126,148,147,31,46,76,118,30,148,246,143,108,129,139,32,110,153,199,106,104,153,38,125,152,33,187,229,78,77,80,136,247,157,192,238,7,60,99,210,159,149,244,52,215,137,163,57,235,232,61,5,51,127,251,35,242,161,129,56,133,89,3,3,130,70,72,244,53,28,115,171,49,220,223,50,156,17,244,165,80,219,134,222,24,138,88,18,59,114,88,12,135,231,45,212,83,216,68,178,200,36,147,167,0,99,53,18,144,197,130,181,75,114,227,148,232,27,142,42,9,34,149,33,34,29,161,251,110,233,72,98,172,8,210,121,142,217,199,76,28,83,3,56,98,24,124,185,32,19,220,82,179,236,87,39,219,165,34,146,109,247,72,114,15,78,58,209,96,184,142,187,36,86,61,65,231,233,82,110,206,112,65,250,211,34,28,245,56,198,64,207,122,
144,128,232,51,215,190,5,38,8,137,212,188,124,147,64,145,68,101,66,240,189,241,73,44,161,23,4,19,159,65,79,139,105,136,228,19,129,206,104,64,200,212,4,201,80,85,79,37,115,82,71,4,110,235,33,39,216,230,130,160,178,149,206,15,95,106,118,242,24,110,198,222,184,239,154,96,48,92,49,109,188,18,91,28,85,166,221,183,42,170,0,233,235,85,224,88,163,243,10,40,98,199,35,60,226,172,152,252,200,114,204,84,17,211,210,134,4,49,202,174,193,134,56,237,82,2,64,12,24,1,187,161,255,0,235,83,31,100,42,219,72,221,215,166,42,36,101,218,36,110,80,54,61,126,148,0,93,134,23,68,99,40,71,65,218,163,65,186,64,8,35,111,241,84,207,34,203,146,164,228,28,3,235,76,11,135,223,38,118,159,74,4,94,51,32,139,45,158,7,165,81,104,188,233,247,22,45,208,227,24,192,244,169,194,110,59,184,233,192,166,172,168,46,9,35,15,198,252,126,148,238,0,150,163,204,98,35,92,14,120,234,105,165,20,157,202,27,39,140,250,85,135,108,62,3,99,140,212,74,165,164,192,39,7,175,53,55,212,171,17,121,88,193,86,228,250,142,105,229,67,166,210,0,110,
216,164,186,105,45,218,36,141,67,110,59,65,61,170,73,138,197,140,158,77,50,74,205,16,19,43,28,100,159,173,89,117,1,15,167,165,86,144,200,167,112,28,15,79,235,83,174,74,96,240,15,189,23,25,2,170,169,0,141,160,118,52,74,249,108,169,24,233,83,73,184,0,20,103,53,92,249,108,229,21,57,29,72,61,232,64,88,183,101,4,150,197,30,118,225,128,114,1,36,243,80,197,18,137,14,249,24,131,209,105,98,138,72,231,144,159,153,113,198,7,90,0,153,54,231,140,100,251,211,252,176,121,199,90,165,118,110,81,3,64,138,16,12,176,239,80,33,146,68,227,119,169,227,30,212,210,21,205,5,17,140,237,32,227,223,56,165,148,174,126,115,187,60,140,212,16,171,33,82,120,29,133,88,96,178,1,201,27,123,14,244,152,209,10,48,108,160,224,246,4,117,160,196,224,252,197,131,145,192,244,171,80,133,64,174,195,146,112,185,237,79,125,172,219,176,114,163,175,99,75,96,43,108,49,69,212,151,236,79,122,121,7,141,196,99,212,211,100,124,229,136,35,7,211,181,50,82,37,78,51,148,228,0,105,117,25,34,145,147,133,193,207,122,114,149,14,119,30,77,85,
130,103,35,230,224,119,31,225,79,17,49,152,179,19,207,108,213,232,73,43,140,183,56,199,127,106,129,164,66,60,165,12,206,120,4,28,31,206,172,96,145,129,193,61,199,106,118,216,0,1,200,207,169,60,230,150,195,33,134,47,179,218,145,32,125,249,36,147,201,52,221,205,233,250,83,126,215,33,156,198,163,114,31,186,212,239,222,123,126,102,128,34,201,55,38,69,103,85,11,141,167,165,88,4,147,146,50,61,248,168,91,4,99,144,61,169,35,223,35,114,221,23,52,247,17,105,182,225,121,232,65,230,155,118,231,229,85,238,51,154,175,209,178,205,187,142,121,232,105,87,18,108,4,244,224,115,218,147,67,184,187,7,150,202,114,115,201,205,73,176,148,69,7,118,6,48,105,88,136,208,237,0,159,122,140,177,63,92,122,208,33,37,204,114,5,227,110,59,118,52,226,88,143,148,149,35,169,20,210,138,132,191,39,183,29,115,79,201,29,70,20,247,166,193,14,138,64,169,150,113,187,190,122,211,93,134,226,232,65,39,130,13,53,21,28,110,147,238,169,235,220,209,63,206,184,143,0,119,200,237,82,80,168,227,39,107,100,30,249,168,100,44,103,0,158,
49,144,41,200,165,0,12,163,29,207,76,210,186,131,56,207,43,140,117,170,68,145,121,50,28,176,102,30,156,212,241,79,42,143,45,193,117,35,174,112,71,227,82,171,48,4,28,31,74,102,220,146,121,3,52,0,141,33,121,57,251,163,248,79,122,45,211,112,100,80,0,13,156,103,218,141,131,60,10,122,225,115,129,130,105,33,141,120,16,19,140,101,123,14,6,77,57,75,4,11,44,76,0,232,71,52,197,200,221,183,130,78,115,72,38,149,9,223,55,63,238,230,157,132,78,178,70,170,62,240,244,200,168,76,208,25,25,119,110,147,29,0,230,158,36,157,162,33,182,31,112,123,83,17,68,67,126,208,25,186,241,72,100,138,93,198,8,80,0,192,36,243,77,86,222,74,252,200,71,113,73,203,157,192,131,237,79,84,245,110,79,175,52,172,0,112,217,32,182,245,25,27,143,165,54,102,13,114,132,131,183,177,164,114,23,174,113,237,82,198,155,226,59,169,136,120,101,101,56,200,25,170,172,118,162,198,119,100,255,0,158,181,56,249,91,229,7,11,216,211,217,4,167,43,199,114,113,210,129,140,136,50,176,201,224,122,211,165,96,200,72,7,241,166,177,3,229,198,121,224,
212,201,24,198,24,100,84,177,162,150,1,117,206,220,253,121,167,146,197,213,115,255,0,235,167,205,12,86,192,60,73,130,236,20,129,222,154,202,122,182,225,154,164,38,63,205,40,219,159,239,30,230,157,44,203,42,156,0,15,67,81,51,7,114,7,106,104,93,207,193,193,31,173,49,16,179,4,108,48,37,207,64,123,212,168,93,72,202,228,31,210,149,163,124,177,80,27,61,115,80,177,144,58,110,56,57,61,59,14,212,1,112,204,16,0,249,24,233,145,199,214,137,27,204,92,3,180,10,128,51,121,133,114,100,192,235,216,26,112,97,184,43,18,79,231,82,198,68,178,16,252,168,61,142,59,84,168,195,39,145,207,65,75,42,132,137,156,244,235,210,160,141,193,81,242,252,231,182,122,81,96,29,16,99,181,216,96,41,36,123,212,195,120,3,127,39,215,21,93,230,43,34,142,119,99,144,7,122,177,19,55,27,183,99,189,48,35,150,231,203,251,171,187,215,156,85,121,110,67,41,9,24,235,243,26,125,210,225,129,69,227,181,68,170,11,18,253,249,199,169,167,160,133,130,80,207,181,215,232,69,79,182,31,249,230,223,149,11,16,217,191,33,113,248,82,249,171,234,
148,0,248,145,28,115,156,30,51,76,194,0,219,14,8,224,15,90,177,27,130,219,89,8,219,211,35,173,53,99,195,3,144,115,156,82,67,33,49,151,32,242,5,11,16,221,181,129,45,216,131,83,72,25,14,88,16,167,166,42,50,153,112,201,156,230,157,196,35,71,177,203,1,239,78,27,122,150,227,174,5,53,153,178,6,72,20,232,227,105,23,12,227,4,224,102,128,24,132,73,33,0,237,227,57,3,154,138,103,110,50,73,222,50,62,149,98,101,48,175,152,238,49,236,122,212,42,241,207,32,201,96,87,166,79,90,67,35,89,2,196,193,250,40,167,195,55,152,170,10,242,105,210,206,85,209,54,175,76,144,221,69,6,53,103,95,152,14,114,15,76,80,129,150,101,98,33,57,29,184,166,0,68,107,184,117,21,43,91,75,32,194,200,48,48,65,61,233,179,36,145,160,47,130,163,210,157,132,32,4,140,226,164,249,72,53,26,31,151,218,151,35,61,40,1,93,64,206,42,32,178,249,132,229,89,125,59,211,164,4,163,109,235,72,92,66,160,187,133,36,116,205,0,33,32,100,158,8,235,237,80,200,68,152,35,56,254,117,63,57,200,249,143,82,122,83,55,102,67,181,8,110,248,165,113,139,0,85,
227,34,156,229,119,236,99,212,113,233,81,249,106,141,242,191,12,121,20,146,70,167,14,24,141,163,39,240,165,96,44,131,16,37,66,170,224,103,129,214,159,24,220,153,3,57,233,85,19,118,245,56,44,175,198,127,198,172,171,108,194,115,199,0,83,16,58,174,214,24,200,2,171,194,228,199,184,100,213,169,49,177,129,24,39,142,106,18,66,34,170,0,73,61,186,80,49,4,146,28,99,140,117,24,228,211,146,99,17,42,84,130,78,122,209,53,196,16,171,51,96,49,227,56,253,41,133,160,151,107,225,125,65,160,64,24,151,99,248,140,243,75,37,196,163,24,63,149,28,17,72,23,0,228,231,218,129,136,24,76,193,39,118,11,156,240,121,252,234,219,183,31,39,204,61,8,205,103,0,179,202,9,95,154,54,56,31,135,95,214,172,238,32,128,71,29,40,96,0,30,156,12,123,211,81,150,55,204,128,5,61,233,92,178,182,51,214,160,186,125,176,252,249,250,45,8,11,164,43,127,171,96,192,251,224,213,121,80,2,187,137,60,244,199,52,137,40,56,200,198,64,63,74,145,131,200,161,129,27,191,132,246,160,9,54,241,180,41,28,113,80,60,47,181,153,72,39,29,125,234,196,106,
64,39,118,125,205,69,12,77,229,156,72,199,4,147,145,66,6,82,17,149,153,67,6,99,215,158,149,48,138,47,190,196,143,108,83,225,64,205,35,200,9,231,10,61,5,77,44,40,97,207,35,30,253,104,2,178,180,59,183,70,88,156,99,37,112,42,202,200,159,42,228,177,39,141,162,152,162,6,76,20,98,65,192,63,253,106,106,97,114,171,128,58,208,3,103,249,203,113,194,246,39,173,85,97,35,31,220,199,128,189,73,60,159,165,89,145,179,34,236,42,72,57,53,105,112,96,86,32,103,28,224,115,77,49,20,98,85,145,137,12,80,142,161,191,165,59,98,250,143,206,172,121,7,37,178,57,246,163,96,255,0,102,139,128,230,152,68,152,126,121,231,34,145,221,120,219,199,166,42,54,249,135,31,56,29,121,166,9,240,229,74,224,244,4,84,140,146,121,26,120,252,165,37,121,4,158,157,41,228,121,113,140,51,28,241,76,17,121,140,20,185,194,242,112,112,106,199,151,30,1,29,125,105,129,71,44,28,239,228,118,246,171,49,237,192,59,184,162,125,177,169,33,75,54,223,206,162,101,101,137,93,147,147,130,87,63,118,128,37,36,18,64,4,226,163,242,67,75,187,112,200,
224,125,41,222,126,8,24,95,152,117,31,214,162,125,163,14,129,157,189,67,109,205,8,5,144,121,56,218,83,230,61,169,226,217,102,5,165,109,173,220,10,77,136,160,54,119,110,238,122,212,145,193,31,147,151,218,231,215,184,167,97,15,46,109,109,201,140,52,187,59,49,234,62,180,217,47,4,150,228,132,42,122,157,220,254,84,159,35,239,77,205,133,56,60,226,149,160,143,134,243,153,72,232,56,197,12,10,232,161,201,144,117,97,128,125,170,100,140,175,32,147,237,67,229,50,0,228,117,52,200,131,238,5,137,3,60,123,208,4,202,164,246,57,244,166,179,150,83,28,241,166,1,233,158,126,180,226,74,158,181,20,210,23,125,184,227,0,3,158,126,148,0,177,236,16,140,13,252,246,244,166,4,56,101,64,202,122,175,106,149,85,219,0,58,143,69,199,74,137,230,242,164,218,87,56,234,115,73,140,149,86,61,185,43,151,29,218,145,213,212,6,92,96,244,164,44,187,3,22,31,55,60,241,79,105,70,205,138,195,118,56,197,0,49,25,203,50,72,152,200,206,87,222,166,46,21,56,235,239,81,44,171,18,23,145,128,66,70,13,61,216,48,198,63,58,0,83,26,200,48,
199,167,56,239,76,59,98,229,6,63,173,48,50,173,192,1,88,150,24,206,122,83,241,19,146,142,192,30,192,241,154,76,4,153,226,153,2,58,110,92,231,230,28,10,104,72,74,149,85,10,125,69,1,81,135,221,56,7,24,198,105,146,68,50,54,146,3,16,54,246,166,3,154,222,72,220,109,155,62,205,205,33,119,92,141,187,137,239,79,72,246,19,158,113,220,210,130,204,229,84,47,3,60,26,0,122,90,42,13,232,199,113,235,158,244,139,193,32,156,226,166,86,202,158,112,123,243,210,170,188,205,20,129,66,6,7,161,20,183,24,146,41,221,242,144,77,70,174,146,63,151,142,64,207,214,158,196,21,249,114,67,122,142,244,171,101,129,185,100,10,122,230,152,130,44,160,198,220,158,190,180,232,223,157,161,135,30,180,173,25,69,228,134,99,192,34,152,224,196,3,114,79,64,5,36,134,90,86,92,109,96,57,253,106,88,162,68,4,167,70,231,147,84,161,184,108,144,233,143,238,156,210,151,114,65,121,113,237,138,100,142,149,83,14,139,133,35,160,239,77,134,66,70,201,28,15,173,68,208,194,238,28,150,206,122,150,233,83,249,106,87,29,61,49,73,187,21,184,199,
104,96,83,180,51,147,223,214,171,28,201,135,28,2,121,83,129,79,117,5,190,110,2,247,61,51,82,36,56,81,158,157,169,183,160,145,16,70,194,187,58,253,0,226,164,50,178,176,25,192,244,29,42,64,0,24,237,233,81,188,18,74,231,143,148,247,52,147,6,135,9,24,130,195,149,61,112,105,223,55,247,27,254,250,166,152,146,53,249,122,98,147,112,254,241,167,184,17,201,34,199,200,207,212,138,149,91,25,37,122,247,167,58,171,40,56,234,42,49,20,252,24,192,9,211,29,232,220,54,22,18,24,176,56,7,61,125,106,80,206,78,192,164,143,239,122,83,124,165,222,187,243,199,56,169,100,149,88,224,113,183,165,0,69,112,238,0,25,239,197,64,103,145,134,211,201,252,170,121,225,37,65,99,147,199,231,81,32,34,83,187,145,138,0,96,1,87,60,182,58,17,64,42,172,75,113,129,210,165,49,177,194,162,140,31,90,140,137,14,241,54,14,56,3,24,166,34,34,231,121,0,140,118,165,40,27,230,39,230,250,211,29,23,126,213,82,131,28,17,86,33,182,62,73,12,228,72,122,49,28,80,0,140,134,50,7,222,29,65,233,83,64,143,44,103,206,97,215,141,190,149,86,223,113,
10,140,152,124,144,217,239,86,163,125,171,183,128,23,128,171,64,15,6,37,118,198,226,71,229,77,105,212,169,234,15,111,122,158,221,85,183,54,62,108,243,76,149,98,19,70,167,170,245,161,129,82,33,38,8,59,79,185,60,129,81,9,7,218,2,225,134,115,206,120,255,0,60,213,198,80,31,110,225,234,6,106,9,85,24,121,123,193,108,118,29,41,45,70,52,185,11,243,110,28,240,84,254,181,32,102,44,132,71,149,199,56,20,177,191,148,138,135,3,35,3,222,164,47,181,134,113,200,251,185,160,8,255,0,214,72,78,192,202,7,92,116,166,137,18,69,89,34,80,91,56,57,28,129,82,130,135,128,219,123,237,233,79,49,153,84,48,27,79,169,160,6,70,173,179,27,11,96,245,60,210,34,186,228,252,196,18,73,207,106,69,118,137,164,201,109,167,158,41,18,79,52,150,83,199,114,123,208,3,140,75,25,125,164,236,97,247,91,177,168,76,43,44,138,210,255,0,15,27,72,25,171,27,85,185,32,230,144,196,10,224,156,1,223,189,23,0,64,33,35,97,108,127,180,122,83,153,137,5,149,55,123,10,138,84,35,230,102,45,245,169,32,12,35,228,243,249,210,96,130,53,80,164,179,
30,123,122,82,129,18,177,101,95,155,212,138,116,252,196,192,117,97,138,106,66,99,132,17,147,129,201,61,104,90,234,1,44,130,62,113,147,142,64,168,242,210,0,66,145,244,230,171,221,70,46,36,70,13,149,140,228,168,171,150,204,60,161,131,145,138,111,64,33,96,85,120,92,145,235,197,11,116,124,163,231,34,142,195,230,171,45,134,207,3,53,86,225,9,3,104,59,179,199,52,45,64,99,75,34,108,145,143,238,199,76,114,8,250,212,239,43,56,10,23,112,168,109,225,154,221,112,10,20,234,87,57,171,17,195,148,44,6,7,64,13,26,0,214,43,192,56,56,164,76,200,126,78,65,234,105,226,212,31,152,184,201,60,129,200,169,119,24,136,80,56,199,106,46,5,102,133,195,245,249,127,74,122,51,96,110,32,110,252,197,62,89,151,128,115,207,165,85,118,221,198,56,238,7,20,183,30,193,56,220,184,201,60,227,0,102,166,132,200,138,21,163,37,59,17,81,130,171,181,212,231,60,98,166,14,112,51,192,62,244,216,144,225,181,155,7,34,149,92,3,181,142,8,237,73,24,18,2,193,113,142,205,80,6,223,59,110,92,255,0,74,86,1,36,42,242,99,126,70,127,42,147,
247,126,181,87,6,25,73,28,14,199,210,166,223,239,79,96,39,33,119,109,28,100,122,209,9,111,52,160,37,128,245,237,81,60,106,87,113,82,88,84,209,146,23,49,158,220,80,192,91,134,216,203,144,77,49,101,66,195,114,144,71,79,243,222,152,249,15,230,177,37,128,207,38,154,174,206,65,66,84,15,95,90,86,2,82,94,84,201,86,30,153,21,16,95,155,0,100,83,222,119,216,3,31,99,205,40,42,203,215,131,232,105,128,177,46,254,72,42,217,228,119,21,20,209,24,137,249,142,198,35,147,78,86,151,112,0,246,234,69,18,202,164,152,178,204,196,100,159,74,53,1,185,93,216,57,20,34,199,184,179,72,113,216,10,73,35,37,83,14,51,232,104,194,237,60,228,142,122,98,155,17,42,174,7,29,79,82,127,74,20,101,121,3,38,149,36,79,40,187,56,244,201,168,150,73,54,228,40,32,158,51,197,39,126,131,67,148,109,113,201,81,140,29,167,173,41,198,236,128,79,169,52,177,169,102,99,34,140,131,193,3,181,57,185,66,5,43,142,196,91,81,220,187,228,28,118,167,195,28,77,156,32,86,29,251,154,122,71,180,228,154,143,205,199,42,69,49,14,146,37,84,87,200,44,
167,130,123,26,113,138,38,219,35,57,56,224,138,106,129,34,252,199,0,244,164,32,199,133,4,129,211,61,115,64,18,24,3,97,163,32,129,232,105,165,220,157,167,60,123,82,54,98,82,99,25,238,113,214,161,158,105,74,5,140,225,152,117,244,161,0,233,166,42,248,141,1,111,226,25,237,235,74,155,149,121,218,87,61,134,41,45,209,154,48,100,249,219,185,199,83,78,72,100,49,184,32,142,127,10,26,1,200,75,124,203,156,26,89,31,13,180,114,106,84,64,16,14,132,116,246,168,229,64,178,110,35,57,239,73,52,216,88,143,112,147,41,144,8,160,63,146,8,207,62,244,197,85,220,66,225,73,234,106,95,36,48,207,82,190,244,192,141,93,164,144,57,96,0,29,49,79,155,114,219,16,178,97,143,66,105,153,17,28,17,187,222,129,47,153,181,99,32,1,207,52,0,216,148,14,138,119,55,99,198,105,26,55,71,222,84,124,220,242,41,225,219,206,10,92,59,246,3,31,40,167,103,63,235,51,156,240,77,23,1,173,33,85,202,141,199,210,164,222,172,153,126,56,201,237,138,137,228,69,145,145,187,114,56,206,104,12,23,44,65,60,244,244,160,6,170,159,40,204,138,10,145,
129,207,81,235,86,161,118,88,192,100,96,190,181,92,205,208,170,133,169,188,214,117,229,130,231,159,173,38,4,136,185,151,35,229,29,243,81,220,201,251,192,177,144,204,58,226,163,105,65,35,1,130,247,34,172,67,34,170,0,78,61,105,12,173,242,187,225,212,134,236,87,158,41,10,69,19,5,102,38,70,233,197,76,25,12,185,0,227,25,201,239,79,43,28,195,249,30,226,128,33,202,1,140,3,199,167,74,20,134,56,0,103,166,5,40,86,50,178,72,120,236,106,52,65,20,228,153,74,143,246,142,115,239,85,228,34,81,28,144,229,218,69,193,60,40,29,42,23,116,86,57,194,147,223,214,164,81,176,177,220,29,79,32,131,197,53,148,51,111,97,156,30,158,148,92,8,36,142,73,120,254,12,245,169,62,204,61,79,253,244,106,83,38,229,28,28,209,243,122,208,3,27,231,59,15,32,158,158,180,204,5,114,170,0,80,122,47,74,100,204,241,146,17,9,36,100,54,41,182,179,177,86,15,247,179,233,66,2,227,48,98,160,142,41,146,178,143,152,12,14,189,41,6,209,146,79,235,83,121,100,158,79,30,253,105,117,25,94,41,55,146,74,145,254,240,235,74,25,85,198,121,94,224,
10,177,229,249,81,231,59,136,254,247,165,68,25,12,172,131,27,184,227,218,152,134,139,132,154,50,158,102,209,211,36,84,81,91,152,228,223,27,238,39,129,220,84,205,16,112,126,66,15,173,58,36,8,2,227,167,90,119,16,198,86,99,201,193,7,181,33,28,130,135,156,126,116,231,117,145,72,139,10,67,99,56,235,78,141,130,0,88,100,227,28,122,210,220,4,137,64,25,206,88,30,61,170,101,147,118,84,213,84,202,202,223,41,218,220,146,58,102,159,247,23,129,159,111,74,151,123,148,135,25,2,185,200,200,237,239,83,101,120,219,210,170,14,164,16,196,55,33,135,106,176,167,0,22,235,78,194,184,247,98,171,198,9,61,141,86,91,69,71,46,164,134,99,157,185,224,85,130,114,56,166,56,36,229,143,215,20,92,44,32,32,131,130,15,181,10,8,110,164,253,105,24,130,51,130,24,126,181,17,103,7,120,110,27,129,237,77,1,100,198,73,39,56,226,160,219,243,18,228,143,76,82,196,219,151,150,102,36,244,38,156,145,102,82,88,1,145,215,61,105,92,44,58,218,45,146,22,36,21,235,244,169,158,66,37,219,180,128,58,55,106,142,72,134,194,80,237,108,113,
233,80,171,57,5,24,134,126,248,28,83,189,192,182,217,3,56,252,170,188,178,70,65,138,67,141,220,12,142,181,36,110,219,188,183,93,184,28,100,245,165,145,81,228,140,117,101,57,233,82,150,163,232,85,137,149,227,222,188,169,252,49,79,94,6,115,248,82,202,145,249,142,177,130,15,241,14,199,222,147,37,73,42,73,62,152,199,53,86,17,27,54,95,126,210,113,193,3,181,16,91,71,230,22,0,224,246,52,161,95,123,16,228,110,198,84,142,42,93,133,113,180,231,62,180,0,60,98,8,215,202,25,97,192,30,130,163,150,82,34,44,20,51,103,238,250,210,203,30,247,201,99,211,29,106,8,100,219,48,200,59,71,175,95,173,0,78,184,7,10,131,142,140,86,147,24,99,187,44,61,42,70,153,119,227,183,168,160,12,142,159,46,125,57,162,224,15,20,55,17,54,214,104,200,29,143,56,166,180,200,51,147,208,100,156,82,249,127,48,63,46,59,130,121,53,35,157,241,249,126,88,96,120,198,41,136,169,182,225,238,75,70,85,33,42,50,172,51,147,253,42,82,6,0,231,53,50,129,229,249,57,229,123,147,205,67,44,82,149,43,11,133,57,28,145,154,6,8,204,232,6,211,199,
31,141,77,23,43,247,113,233,205,68,16,194,48,172,199,212,19,79,12,112,163,28,129,131,73,130,28,64,234,105,133,115,147,140,210,239,24,231,169,164,50,42,144,61,105,136,80,12,96,175,24,62,149,89,203,199,41,36,240,122,84,230,64,84,212,82,70,236,78,236,159,76,80,2,25,81,101,3,121,109,253,8,21,46,87,212,84,16,0,204,203,129,242,146,1,3,160,226,167,216,63,231,165,72,201,84,163,12,108,198,58,28,84,13,24,140,179,32,4,147,222,149,183,42,231,56,29,64,166,129,33,114,49,129,239,76,2,88,129,28,17,200,226,167,142,84,206,72,193,52,213,4,103,32,26,134,115,182,62,62,247,96,105,1,100,54,244,245,244,163,144,71,1,129,170,240,185,84,7,61,57,57,237,86,21,146,65,149,57,20,222,128,70,55,172,108,203,150,94,78,15,92,122,81,20,198,70,203,169,78,58,28,80,206,195,229,13,145,158,190,212,193,30,231,44,78,59,115,222,128,24,232,166,96,2,175,35,33,65,198,106,72,80,180,121,1,134,14,48,105,55,178,21,7,5,123,28,114,42,93,219,0,27,185,60,226,152,134,148,109,188,156,103,183,173,8,93,88,46,222,162,151,120,5,157,186,14,
114,106,93,202,84,21,56,6,147,25,95,108,144,199,129,32,96,59,48,168,139,185,4,201,200,235,145,218,174,51,70,195,25,201,199,66,41,140,170,241,237,35,131,210,128,43,67,43,9,129,13,185,58,31,173,79,60,189,66,130,13,55,27,79,56,4,116,56,168,201,203,7,98,122,228,140,81,96,26,173,32,35,124,128,103,218,152,242,180,139,176,158,42,91,144,207,27,48,12,91,57,233,208,119,166,45,184,192,103,125,190,185,255,0,26,76,98,66,198,53,86,7,167,90,180,178,169,228,145,249,212,56,31,117,16,15,67,159,189,73,36,166,32,177,149,27,143,83,64,137,195,100,135,32,145,142,70,123,212,144,202,155,248,56,39,146,15,21,86,57,6,242,25,135,176,29,169,206,160,160,224,22,207,28,83,17,118,105,17,87,115,227,211,7,189,81,130,225,60,233,2,140,56,61,7,74,145,64,194,169,231,29,205,68,145,167,156,204,27,4,243,205,27,12,123,239,7,114,96,250,228,208,146,200,87,105,140,19,234,79,24,169,2,146,184,239,64,24,29,56,161,0,214,36,176,198,238,58,129,82,179,169,33,123,251,210,32,18,2,193,113,142,205,80,171,230,118,220,63,250,212,1,36,
128,15,199,167,189,49,213,183,32,24,198,121,221,222,165,89,21,142,220,100,129,159,194,135,43,129,156,113,215,52,128,71,116,46,184,94,51,130,113,210,159,128,9,95,65,81,18,85,118,49,194,47,82,41,162,76,129,142,253,137,239,233,66,2,66,1,201,228,159,231,82,44,201,111,22,227,195,55,97,233,72,187,72,249,135,35,218,137,98,45,180,100,1,234,71,20,92,1,152,92,96,169,216,221,71,189,86,11,44,121,83,39,126,123,154,146,35,251,208,23,156,131,143,108,82,0,219,79,152,6,115,206,41,136,122,64,35,25,12,207,184,231,154,115,12,30,122,250,84,43,59,6,0,238,10,167,24,29,42,66,93,159,39,29,125,105,49,138,202,190,75,30,51,211,138,173,176,134,4,244,29,234,193,125,199,133,3,181,52,33,10,66,147,184,127,123,173,52,194,194,8,88,191,65,199,175,106,25,100,97,242,182,1,235,237,74,210,48,59,66,49,207,113,65,116,64,55,241,159,108,211,17,97,162,143,202,3,104,4,12,113,80,121,99,253,154,83,112,196,99,202,59,79,70,245,166,121,163,251,173,249,26,86,24,169,229,200,128,73,201,245,164,125,177,48,59,190,94,152,52,200,151,
123,12,28,53,88,146,5,49,140,227,35,169,28,82,186,1,84,171,28,41,168,167,65,144,206,56,232,41,169,25,18,16,27,42,7,92,244,164,121,68,195,98,190,236,117,255,0,245,208,2,56,5,78,88,31,80,104,86,204,101,208,18,58,100,119,167,8,67,1,183,129,158,121,205,24,116,112,176,201,148,108,150,221,206,41,128,170,129,81,139,18,73,60,127,133,53,88,62,84,140,17,212,26,146,61,204,92,49,24,207,21,12,204,85,193,3,129,220,83,16,178,142,128,100,96,231,34,151,230,219,242,119,29,122,212,72,235,33,206,241,142,231,210,165,128,177,222,99,59,148,17,212,226,150,163,34,64,209,192,22,71,59,152,156,6,171,9,55,150,163,237,12,160,129,146,77,54,71,12,174,29,85,131,113,138,138,70,243,83,107,198,27,253,225,145,69,128,152,111,71,105,21,212,163,28,129,142,149,42,180,108,153,137,193,62,157,42,184,220,177,144,70,220,113,140,116,166,90,202,26,53,80,8,228,227,119,83,64,22,89,2,156,185,56,235,131,205,71,24,97,206,1,220,50,188,116,166,79,114,35,80,11,140,116,218,5,78,103,138,121,2,39,204,202,50,74,244,20,108,5,19,230,164,
139,243,110,57,252,7,225,82,72,141,48,43,129,140,228,228,19,255,0,234,171,13,30,233,55,17,219,173,40,149,148,21,126,158,180,196,84,4,163,97,65,61,184,234,41,210,192,146,128,100,36,118,231,174,106,97,134,39,24,60,228,83,120,121,176,65,235,192,20,152,200,96,180,137,91,107,184,220,121,7,174,5,91,120,216,29,170,199,24,234,69,41,72,192,44,87,154,141,94,70,28,56,30,184,25,205,23,11,15,41,176,1,247,184,234,123,211,20,109,149,71,56,231,140,84,167,44,55,16,65,61,105,99,7,147,158,163,31,74,0,97,108,19,142,79,165,63,5,187,115,76,69,138,71,18,131,147,247,71,29,234,50,30,57,246,140,122,231,61,5,22,2,81,28,145,101,218,69,32,158,20,14,149,11,178,2,115,133,39,245,169,99,138,79,155,230,3,63,165,43,66,185,92,252,196,126,180,196,68,57,193,41,193,238,106,77,165,155,97,4,143,81,77,101,3,32,113,71,156,207,149,0,35,103,134,20,0,58,18,57,32,1,248,230,153,230,73,149,11,26,252,188,100,211,183,237,83,213,177,197,71,34,207,32,38,60,15,161,230,147,184,208,209,112,35,188,16,185,193,43,184,122,125,42,207,156,
89,64,81,149,63,231,53,11,164,101,7,159,8,50,1,140,241,78,142,57,2,224,13,169,216,103,165,0,75,111,34,40,35,56,108,238,165,46,138,48,25,112,123,103,154,65,47,150,165,92,255,0,245,253,170,162,48,223,202,178,131,208,211,17,57,120,144,18,195,44,78,66,250,83,146,65,150,201,32,118,221,80,44,10,70,252,29,199,160,63,206,165,89,10,201,254,175,114,176,249,179,205,22,11,138,183,48,59,237,142,79,155,160,0,113,77,115,49,222,168,204,27,177,97,198,105,211,74,2,13,202,20,41,4,16,57,165,89,85,128,46,164,174,114,14,57,31,157,22,1,54,201,38,222,2,149,251,192,142,79,208,211,68,69,6,99,63,55,251,92,84,177,69,25,152,110,148,182,122,101,186,211,230,33,148,128,165,8,60,103,140,208,4,102,228,36,91,64,249,189,61,42,174,100,255,0,158,134,159,34,74,29,78,83,158,217,60,212,153,111,246,104,2,8,78,192,48,122,112,121,171,45,114,157,6,70,227,212,241,85,163,218,151,46,8,36,1,216,119,171,68,162,219,159,57,193,96,63,42,155,20,58,23,8,74,103,147,207,53,20,168,155,203,132,3,60,28,119,167,178,23,100,96,216,192,239,
74,202,79,86,200,28,211,212,67,82,60,149,96,8,32,144,126,152,164,134,39,218,119,0,57,227,20,165,131,43,34,157,198,164,134,66,173,177,215,110,58,100,245,160,8,222,57,20,1,212,19,146,71,90,133,237,229,86,93,164,16,120,220,127,135,53,162,121,92,173,71,215,25,7,6,132,192,169,228,44,114,13,192,2,57,192,254,116,143,60,81,57,45,242,238,227,235,86,165,68,116,249,143,204,189,42,23,141,54,5,98,49,156,18,122,138,104,64,143,27,199,157,161,134,122,154,112,249,228,69,0,0,15,240,211,98,128,43,100,231,96,60,15,90,145,64,92,177,42,0,245,237,72,99,220,12,29,194,171,21,10,249,81,205,78,164,16,25,78,243,253,226,114,5,65,116,242,71,25,112,155,185,236,105,0,210,177,58,48,149,50,196,231,244,164,129,85,73,0,99,216,84,105,26,238,223,32,4,212,145,49,44,70,64,199,66,125,42,132,90,243,85,147,29,7,210,152,10,231,4,128,125,15,122,105,42,114,169,72,195,106,28,128,196,119,239,64,17,21,88,156,48,63,123,142,91,185,169,163,81,201,224,115,85,216,43,186,16,85,128,63,197,158,13,93,34,43,136,48,65,13,199,205,211,154,
0,105,37,156,46,65,3,245,167,145,136,201,3,4,244,168,130,172,100,48,206,79,92,246,167,146,60,188,131,210,165,140,137,139,142,14,238,123,212,190,112,84,193,27,152,241,138,143,57,60,158,125,41,194,60,169,98,1,35,158,123,85,8,140,43,171,130,64,217,183,63,67,82,17,223,191,173,10,174,91,45,208,251,209,38,236,16,140,1,247,20,144,201,21,249,197,53,164,140,252,221,79,56,199,106,175,35,72,139,140,166,238,6,123,243,76,143,121,108,49,25,247,166,34,193,66,83,43,233,206,77,34,253,221,160,228,122,10,39,117,142,17,156,14,48,48,106,85,100,86,192,63,149,13,216,17,27,43,109,249,137,11,76,243,10,182,35,232,78,15,173,58,96,72,219,187,169,233,81,36,78,199,41,147,234,79,74,74,236,101,178,21,152,49,193,97,212,26,73,114,112,1,198,42,47,41,183,41,45,207,110,42,70,154,62,84,129,191,189,2,43,203,31,239,23,150,108,142,153,239,79,142,33,180,137,27,175,67,65,88,118,225,242,129,207,4,100,102,145,164,8,73,98,54,175,175,122,67,21,151,104,3,119,204,63,35,64,10,220,133,97,184,212,65,150,96,210,43,14,189,5,58,59,
130,120,60,26,96,90,216,10,116,199,243,168,207,33,163,206,14,59,213,137,24,8,193,218,121,233,85,83,239,19,131,146,123,250,82,87,1,143,19,0,188,231,190,224,49,79,201,198,88,22,35,214,172,22,227,165,53,215,215,156,213,8,175,60,67,122,149,27,72,4,109,94,149,87,236,255,0,237,85,221,173,187,160,198,59,82,108,111,74,78,227,30,138,35,145,157,23,12,120,39,29,105,120,98,115,205,73,128,7,92,212,81,17,186,85,32,13,167,60,122,26,98,28,83,130,122,250,211,130,141,167,61,127,157,39,36,30,153,164,98,113,158,185,160,7,110,11,247,70,7,124,83,103,87,153,80,68,0,96,126,108,244,2,144,182,0,35,7,52,215,144,194,60,237,219,115,133,38,128,18,88,101,93,164,145,128,57,193,34,128,37,82,219,152,168,24,57,28,254,21,35,72,172,129,153,195,84,123,203,140,178,252,160,240,41,12,103,152,207,47,64,0,245,169,14,90,77,164,99,60,131,81,201,128,187,246,143,67,72,147,175,153,229,150,192,3,130,105,161,22,154,25,62,232,10,61,13,85,85,49,69,206,74,169,207,57,53,105,165,13,18,160,228,122,154,100,242,237,133,74,13,217,60,
159,74,67,35,108,172,25,83,140,140,170,227,128,125,42,54,102,56,141,250,238,192,20,224,234,224,109,110,70,48,61,106,187,35,188,234,193,138,178,54,236,227,138,73,1,112,67,187,10,202,6,56,224,117,168,230,143,203,101,24,193,60,10,158,59,130,209,178,58,242,71,81,80,77,194,12,147,147,192,252,105,129,16,102,36,96,113,221,169,99,220,174,87,113,39,174,13,77,110,176,160,195,28,26,107,71,155,130,84,62,49,142,27,138,119,16,232,237,195,242,70,9,25,235,210,148,43,70,231,4,227,28,3,78,249,198,67,156,231,24,7,210,147,36,169,221,146,59,12,210,184,199,121,98,81,156,237,20,201,23,201,25,82,118,103,156,213,130,200,177,224,16,8,28,84,100,146,23,107,2,163,177,92,147,64,21,102,34,72,207,150,221,61,233,44,101,32,21,108,237,206,114,105,28,157,229,0,1,115,201,169,124,160,20,18,204,71,185,206,41,216,46,75,56,232,209,184,221,144,49,154,108,101,153,176,216,6,160,108,25,6,210,185,29,50,105,124,214,105,114,9,28,246,60,81,97,11,58,152,238,23,123,35,110,228,103,250,82,24,136,203,3,203,30,158,148,240,18,73,149,
165,43,184,14,1,52,219,183,113,179,202,0,70,140,25,187,102,149,198,48,196,251,136,198,73,232,8,226,167,140,152,192,89,35,92,119,34,165,224,144,195,154,108,163,60,118,239,83,113,216,142,85,47,243,196,219,128,225,129,28,212,207,62,204,34,199,243,99,238,231,20,203,173,191,103,38,25,20,63,240,243,222,163,84,117,133,9,37,159,110,73,61,79,173,81,35,221,164,145,55,0,170,222,155,184,164,15,25,140,163,231,118,63,35,79,103,87,143,10,112,195,167,24,21,11,70,219,150,66,203,215,5,87,156,208,2,205,34,184,207,205,145,216,14,42,188,240,137,84,73,146,88,175,32,26,181,228,130,197,134,91,61,84,158,212,145,172,100,149,195,40,29,1,161,140,169,104,174,167,104,56,200,206,13,89,117,134,47,222,182,29,199,79,173,47,144,1,5,78,57,228,158,184,169,167,9,28,120,9,201,61,187,80,129,145,44,172,81,121,98,189,50,70,42,97,192,192,228,102,152,138,206,140,1,28,12,84,137,14,209,64,0,228,123,83,137,7,131,210,171,249,195,204,100,195,13,189,200,226,165,35,32,144,121,166,33,199,7,62,130,140,55,173,68,3,25,7,60,122,84,
217,247,20,0,211,215,29,169,133,130,103,140,230,154,228,174,58,212,81,59,60,158,91,116,198,104,0,120,100,147,132,147,106,245,220,58,209,115,30,229,76,49,87,79,78,51,82,227,17,18,62,148,141,26,144,25,185,32,102,128,8,137,113,140,17,233,205,16,57,89,24,59,121,138,14,49,142,148,197,143,42,65,60,3,145,142,41,251,124,160,0,228,1,72,98,201,36,70,66,137,144,113,156,142,148,216,164,202,16,195,113,94,192,117,166,55,201,140,119,245,167,8,1,147,112,98,15,181,49,10,71,154,64,76,140,243,237,64,141,35,184,14,83,113,238,72,226,156,80,70,55,130,73,247,52,233,163,71,136,135,25,227,61,105,12,176,100,202,141,128,103,218,170,144,74,186,182,208,58,96,85,120,71,149,149,82,121,239,222,165,95,221,157,189,115,64,16,195,24,86,80,167,169,60,227,165,88,1,8,221,25,24,21,28,106,169,25,33,70,125,106,68,85,144,41,81,183,39,6,134,8,105,42,160,124,196,177,206,57,233,72,9,145,151,122,147,254,208,237,138,146,84,196,101,65,227,57,233,81,132,219,192,61,40,64,35,101,65,39,36,15,65,78,70,148,142,112,87,60,26,141,36,
99,233,143,74,147,207,114,193,120,0,240,104,176,92,116,83,44,178,237,102,60,14,8,232,106,82,169,143,149,215,39,156,102,161,216,2,228,15,187,210,162,206,27,235,78,194,37,146,77,164,100,245,226,150,50,48,62,115,235,245,161,162,243,64,201,198,71,97,81,199,24,71,41,215,222,144,199,185,80,14,49,147,218,153,12,170,199,99,17,145,200,237,82,136,130,16,217,38,154,204,36,144,41,24,247,20,0,230,33,209,176,160,142,156,211,99,64,70,210,0,197,57,112,153,192,227,29,40,198,98,47,211,184,2,128,4,217,28,197,248,193,227,142,213,53,195,164,144,157,163,32,117,21,72,109,102,42,202,56,165,96,70,88,28,115,140,83,16,235,119,192,0,156,130,113,154,176,78,122,145,182,179,228,194,198,14,51,185,185,21,100,28,199,143,235,82,215,81,220,147,112,66,48,170,20,242,113,81,200,141,36,65,35,108,109,60,115,206,40,67,146,22,157,184,197,200,193,170,16,232,224,17,160,7,45,245,230,154,241,146,167,103,201,238,5,59,205,96,152,31,175,52,213,144,147,180,143,122,0,104,5,19,118,246,220,57,201,239,74,92,202,3,1,159,113,86,21,
0,3,60,210,5,92,224,40,3,210,149,199,98,15,49,80,254,244,144,167,140,212,210,72,12,103,110,25,192,227,142,106,165,209,198,56,254,42,177,16,9,242,129,239,76,67,163,147,203,95,153,72,167,25,149,182,142,133,186,3,222,157,183,112,62,220,85,73,99,32,168,14,113,156,114,41,1,59,219,153,15,3,31,214,170,238,96,74,97,148,167,7,165,92,142,70,220,80,146,113,206,106,172,204,86,121,59,243,222,139,92,119,37,139,44,161,139,122,241,79,220,191,222,253,106,180,110,88,129,192,227,60,84,248,247,52,90,192,127,255,217);

back_swell:array[0..4891] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,20,14,15,18,15,13,20,18,16,18,23,21,20,24,30,50,33,30,28,28,30,61,44,46,36,50,73,64,76,75,71,64,70,69,80,90,115,98,80,85,109,86,69,70,100,136,101,109,119,123,129,130,129,78,96,141,151,140,125,150,115,126,129,124,255,219,0,67,1,21,23,23,30,26,30,59,33,33,59,124,83,70,83,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,124,255,192,0,17,8,0,200,0,200,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,
122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,
250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,202,154,64,234,35,65,178,36,232,5,102,206,249,111,97,210,172,93,74,7,200,191,141,81,117,45,64,12,102,207,176,166,138,147,203,3,171,80,8,31,116,100,208,3,66,129,203,126,21,52,80,52,167,39,167,165,62,11,114,205,150,230,180,82,48,131,3,173,0,102,201,9,133,213,135,74,177,23,250,249,36,35,59,6,7,214,157,124,62,67,235,76,182,204,137,50,142,167,4,126,84,1,93,164,146,73,88,169,193,39,181,72,177,75,17,202,160,111,124,212,42,161,156,171,112,192,212,251,229,132,117,222,148,0,198,4,29,210,224,158,194,171,202,236,237,205,93,93,147,12,131,74,45,71,122,0,207,84,102,60,10,181,13,161,60,181,91,17,199,16,201,197,67,45,215,100,252,232,2,70,104,224,94,49,154,172,168,102,115,36,135,8,41,99,136,184,243,37,36,40,237,235,86,35,79,52,238,111,150,52,237,235,64,4,81,239,218,204,49,24,251,171,235,90,214,145,133,67,35,112,5,82,182,67,113,48,236,130,147,86,189,242,215,200,136,224,119,52,0,205,67,82,46,76,80,28,14,237,89,44,254,159,157,46,70,49,154,76,46,120,4,208,3,
64,44,106,120,32,105,155,106,142,59,154,150,222,209,165,57,111,149,106,227,17,12,123,99,94,7,235,64,2,36,86,203,198,51,234,106,41,46,114,195,28,138,171,49,145,219,38,163,82,202,104,3,114,59,152,37,131,202,145,14,211,214,138,165,3,171,174,15,90,40,2,129,115,247,155,169,164,8,207,201,226,164,138,63,54,76,246,21,117,97,0,80,5,21,183,39,173,78,145,5,53,59,40,90,133,228,0,208,5,152,176,42,92,224,102,169,71,46,77,90,28,138,0,175,115,243,100,85,88,101,48,201,145,156,142,8,246,171,237,30,234,130,91,77,220,226,128,9,161,91,129,230,194,126,126,226,160,89,136,27,28,114,41,66,75,11,101,79,227,82,137,226,151,137,227,59,189,87,173,0,85,221,229,190,229,232,106,127,181,229,122,211,132,112,55,73,64,246,110,41,124,171,120,249,105,23,232,40,2,190,231,148,241,147,83,164,9,8,15,49,201,61,23,214,159,230,128,191,232,232,127,223,110,130,155,26,180,206,118,146,79,241,57,254,148,0,229,86,184,147,7,0,14,184,254,31,97,239,82,183,239,25,97,136,124,163,142,41,237,182,36,17,198,42,213,172,34,8,252,198,31,59,
125,218,0,148,168,179,180,32,125,226,49,154,198,104,26,119,39,174,107,86,98,28,0,79,2,160,103,10,48,188,10,0,170,154,120,31,120,226,166,75,120,163,231,239,17,237,75,187,39,173,54,121,197,184,3,25,115,219,210,128,38,61,57,33,69,52,66,178,240,178,12,214,91,201,36,173,150,99,244,20,229,47,9,14,9,35,191,181,0,88,186,178,146,49,158,107,60,179,43,96,215,73,3,139,155,86,13,201,3,138,192,187,76,92,16,61,104,0,87,32,110,20,83,55,140,227,181,20,1,163,105,14,212,21,97,184,20,170,54,168,21,13,196,155,84,208,5,123,153,118,247,170,120,103,57,167,115,52,132,246,171,41,30,5,0,84,66,81,198,122,86,180,31,50,102,168,79,31,25,29,170,205,140,187,147,233,64,22,148,124,216,171,107,108,28,102,169,51,108,122,210,182,125,203,159,106,0,175,37,151,6,169,75,104,185,32,138,216,243,57,193,168,110,34,200,200,160,12,115,104,195,238,191,224,121,166,121,19,47,69,143,235,138,182,204,80,154,95,56,119,197,0,86,91,87,115,251,214,200,244,29,42,207,203,10,97,64,166,180,252,113,76,140,25,92,14,180,1,98,214,15,49,247,
191,221,28,154,124,178,239,114,71,3,160,21,44,223,185,136,70,189,79,38,170,181,0,35,190,6,77,83,105,154,73,54,173,58,233,240,187,115,76,181,140,158,123,147,138,0,177,188,65,17,145,187,112,61,205,103,157,243,72,73,57,39,173,75,123,54,249,54,39,221,78,7,185,168,194,159,184,159,240,35,64,14,87,138,62,15,38,172,40,73,99,56,238,42,33,110,161,121,166,199,155,121,70,126,227,113,64,26,26,51,16,207,25,60,142,43,62,251,139,183,227,166,106,229,179,8,111,209,187,63,90,175,170,166,203,215,247,20,1,94,56,119,71,154,42,213,160,221,29,20,1,108,184,2,179,174,165,46,219,65,167,75,114,49,128,106,176,4,146,199,169,160,9,227,194,45,73,231,47,173,86,218,237,210,151,236,242,227,56,160,11,91,149,197,69,19,121,19,243,247,90,160,5,227,63,54,106,82,68,201,239,64,26,19,140,160,97,86,116,249,179,242,154,163,103,47,153,25,141,254,240,224,211,225,38,25,253,168,3,74,124,171,230,164,137,131,174,211,72,195,205,136,48,235,138,138,50,85,168,2,27,184,112,107,57,242,13,111,74,130,68,207,231,89,147,65,205,0,83,92,
147,90,118,16,129,243,30,213,90,56,126,106,213,137,49,14,7,122,0,171,32,46,197,143,122,129,198,42,75,171,133,67,181,106,53,145,100,94,163,52,1,82,120,139,183,2,158,0,134,6,115,252,43,199,214,166,42,7,36,128,62,181,86,246,85,242,130,35,3,207,52,1,69,9,220,88,255,0,8,207,227,86,97,194,47,39,147,80,136,200,182,221,140,229,169,233,4,146,140,147,129,218,128,45,6,87,24,205,71,34,100,21,110,134,161,104,100,139,149,108,251,102,165,138,97,32,218,220,48,245,160,4,70,102,140,169,255,0,89,25,200,247,169,245,31,223,219,67,114,188,224,97,170,7,5,24,56,234,191,168,171,54,204,174,30,221,143,238,230,25,79,102,160,10,214,46,1,219,233,69,64,3,91,206,85,184,42,112,104,160,4,142,9,101,63,187,140,159,115,86,69,151,147,134,186,148,39,251,61,77,91,146,239,172,118,106,17,71,5,234,131,143,49,201,27,164,110,231,52,1,55,159,109,31,10,172,222,231,138,112,187,128,156,21,101,30,181,81,161,199,88,255,0,241,234,102,196,245,100,62,252,138,0,209,104,162,157,126,66,27,249,213,23,141,173,219,61,86,144,121,144,16,
202,120,245,29,13,91,142,100,187,93,146,0,31,249,208,4,32,149,97,52,125,186,143,90,186,118,205,26,186,245,197,80,193,183,147,99,125,211,210,167,130,79,34,77,164,254,237,186,123,80,6,181,156,191,46,211,83,60,92,228,85,20,59,24,48,232,107,66,41,84,168,6,128,29,30,71,90,100,177,2,106,96,84,244,160,154,0,170,144,225,179,138,154,115,229,192,72,244,169,14,20,84,51,126,246,38,29,197,0,115,119,51,177,147,2,152,179,200,190,223,141,18,169,89,155,214,153,28,45,33,201,233,64,14,107,137,31,130,228,251,10,124,118,210,73,243,21,32,123,154,102,245,67,182,21,201,254,241,171,113,71,41,25,102,57,52,0,205,236,176,149,145,64,10,120,171,22,231,122,83,69,128,115,243,49,169,226,141,32,27,119,102,128,33,153,13,83,116,59,178,56,35,189,106,176,87,251,166,170,201,15,52,1,20,114,121,163,107,112,227,245,164,92,171,109,7,7,59,144,250,31,74,70,136,131,149,225,135,74,118,124,212,61,156,117,246,52,1,45,236,95,106,132,93,70,191,56,249,101,95,122,40,182,159,203,125,236,62,70,249,101,95,235,69,0,66,127,121,242,40,
196,107,233,222,158,93,97,78,112,61,189,42,24,93,217,68,113,14,64,228,158,213,28,209,149,144,111,36,142,230,128,26,242,151,110,88,129,78,88,209,250,72,115,74,210,170,16,170,128,210,110,221,247,162,4,123,80,2,249,114,66,114,167,35,191,189,55,229,115,242,124,143,233,216,253,41,234,216,56,70,63,238,189,12,171,33,198,54,63,161,160,9,82,69,186,79,42,94,36,232,15,173,53,121,6,25,58,142,134,161,32,147,134,225,135,122,152,31,180,12,30,38,94,255,0,222,160,11,22,179,30,98,127,188,58,123,213,165,144,169,172,146,228,16,253,25,106,252,111,230,198,8,244,160,11,66,225,135,122,154,59,191,239,10,205,114,69,53,101,32,245,160,13,228,113,34,241,80,185,104,164,207,106,163,5,201,83,193,173,20,145,46,19,13,214,128,50,245,27,34,248,158,46,125,170,172,101,94,6,69,225,251,131,91,233,24,69,108,159,151,210,176,231,10,215,174,20,1,133,61,40,1,150,176,42,156,245,106,183,210,171,105,238,2,59,63,240,211,39,189,57,196,107,248,208,5,167,155,203,28,158,106,140,179,177,53,22,246,99,243,26,120,76,208,2,45,195,41,
171,144,221,135,225,255,0,58,168,208,212,69,25,15,20,1,176,99,12,55,41,200,170,211,68,84,249,137,213,122,143,81,80,218,221,20,96,27,165,92,158,65,229,249,139,211,249,80,5,66,235,184,56,251,142,48,194,138,133,193,32,249,99,42,221,135,99,69,0,79,20,191,191,192,3,7,169,3,138,181,61,184,113,200,20,230,116,134,60,170,128,107,62,75,182,44,72,38,128,25,52,13,31,108,142,199,210,150,39,236,221,106,104,110,195,252,178,142,189,233,183,22,219,126,120,249,94,188,118,160,7,20,87,28,138,137,212,160,195,13,233,250,138,106,74,87,134,252,234,95,48,17,214,128,33,110,128,231,35,179,127,141,57,70,229,220,185,12,61,59,83,73,242,219,43,200,61,71,173,42,159,41,195,175,220,111,210,128,37,101,243,148,186,143,222,168,203,47,247,135,168,166,90,205,229,190,211,247,79,74,149,134,198,89,16,224,117,200,236,104,150,220,76,173,44,35,14,57,116,31,250,16,160,11,133,67,142,42,180,145,16,106,59,91,172,124,175,249,213,224,67,15,90,0,166,164,131,86,224,152,169,164,49,3,200,166,136,200,160,11,173,113,149,172,153,68,
137,113,230,42,238,245,21,112,16,189,77,71,45,228,105,194,242,125,5,0,69,13,196,80,171,171,70,65,110,153,171,75,12,51,218,121,200,160,17,212,86,92,206,242,182,231,24,30,149,119,79,115,29,132,225,191,10,0,207,112,204,228,47,65,66,57,67,134,252,234,213,162,43,33,207,83,80,220,66,209,156,129,145,64,22,17,131,10,86,140,48,170,41,33,78,157,63,149,89,73,129,29,104,2,57,34,199,74,158,206,108,29,143,200,60,17,72,204,8,168,79,202,217,20,1,102,88,77,179,22,136,252,141,250,81,83,65,40,146,60,30,125,69,20,1,78,105,140,167,3,165,49,97,221,76,82,1,197,95,182,1,177,64,17,197,100,79,53,105,99,88,215,110,224,106,173,196,238,242,121,81,112,7,83,85,216,132,108,110,118,111,80,104,2,196,214,160,146,200,112,79,235,85,26,38,66,114,15,225,82,37,195,161,228,146,61,13,92,137,210,97,199,94,226,128,51,48,79,241,99,235,82,70,62,66,164,130,13,104,181,186,176,233,85,101,179,29,86,128,25,111,38,65,137,187,116,169,99,102,142,69,218,118,176,251,135,250,85,101,132,169,244,62,181,96,126,245,8,111,188,58,255,0,141,
0,73,53,170,221,163,77,110,54,202,63,214,71,254,21,86,43,135,136,224,231,142,221,234,196,82,56,109,200,113,50,117,255,0,104,85,150,138,13,73,119,46,35,152,117,20,1,28,119,72,226,158,211,46,58,214,124,246,147,91,177,14,135,234,42,29,231,161,114,62,162,128,44,207,57,118,218,167,173,42,4,137,114,122,213,100,32,30,14,77,88,138,217,164,59,159,59,71,90,0,108,104,215,18,231,31,40,171,55,76,32,183,49,15,188,221,105,30,230,56,23,100,95,51,122,138,163,36,133,219,115,156,158,194,128,36,138,93,143,138,188,49,42,115,89,35,37,179,90,22,239,197,0,67,53,185,70,202,212,24,193,244,53,164,238,58,26,174,241,171,244,160,10,219,156,122,26,4,135,184,197,43,196,202,120,166,140,158,24,102,128,38,138,99,19,131,216,245,162,162,198,14,211,223,165,20,0,133,72,27,179,205,104,89,182,80,159,106,167,56,196,152,21,102,212,226,221,201,236,180,1,26,54,196,150,78,228,224,84,246,182,217,143,115,117,60,212,8,155,196,40,59,252,198,180,134,17,113,237,64,21,229,182,86,94,149,76,135,182,144,16,126,153,173,45,224,154,138,
120,150,68,198,40,1,68,134,72,124,200,207,35,168,166,71,56,115,134,235,80,90,200,98,148,198,253,9,230,139,149,48,203,149,232,77,0,89,104,193,237,80,74,133,49,42,14,71,95,113,83,192,254,98,115,214,156,87,182,40,2,171,130,192,73,17,230,149,127,123,251,200,91,100,131,173,34,126,230,83,27,125,195,247,105,36,70,141,183,198,112,123,143,90,0,182,154,139,5,217,117,30,224,59,226,135,155,77,126,90,62,79,161,170,171,114,140,49,40,193,247,20,23,183,3,35,31,149,0,61,238,45,208,126,226,219,159,86,170,210,79,60,252,18,72,244,3,2,156,92,200,127,119,31,226,212,215,12,163,230,114,62,156,80,0,144,113,251,199,10,61,5,56,165,186,143,189,154,170,75,30,132,226,159,18,111,60,243,64,19,4,141,143,200,106,104,215,109,87,42,98,145,113,198,77,92,144,236,139,52,1,78,105,112,216,20,145,205,134,230,146,52,222,75,122,154,124,144,241,64,22,20,44,131,222,154,97,30,149,4,18,20,125,173,87,134,8,6,128,42,77,23,201,145,212,81,86,202,130,8,199,90,40,3,62,115,153,143,210,173,5,43,105,183,187,144,162,170,70,166,89,71,
124,154,185,38,89,214,53,254,31,148,125,123,208,4,150,137,150,121,59,116,31,133,44,210,229,176,41,210,17,12,75,26,246,21,28,49,52,173,156,80,3,163,4,154,159,105,199,53,106,27,60,47,56,21,41,131,142,198,128,48,111,35,218,225,199,30,181,44,191,191,181,87,254,32,57,169,239,225,194,145,237,85,108,91,229,100,61,40,0,180,36,54,42,211,26,69,137,87,145,76,145,177,222,128,34,185,77,233,149,251,203,200,162,55,243,99,207,122,97,155,158,181,28,46,18,86,81,208,243,64,18,50,43,31,152,80,176,198,15,2,166,41,158,69,1,66,242,104,1,24,42,47,76,85,50,76,178,96,116,20,251,137,115,192,239,79,129,54,173,0,49,227,8,148,182,137,198,227,69,195,100,133,29,205,74,0,142,32,63,58,0,99,143,50,225,20,118,228,210,222,182,230,88,215,241,162,31,145,90,103,239,210,163,76,187,25,27,189,0,77,26,133,90,115,16,120,170,239,56,28,10,143,207,57,160,7,204,152,228,117,21,61,180,187,147,6,171,121,155,184,52,212,111,46,79,99,64,26,59,168,170,109,49,20,80,4,144,41,134,63,48,143,157,184,81,83,219,46,197,51,55,166,23,252,106,
53,6,226,92,12,133,199,79,69,255,0,235,212,207,153,92,69,24,224,113,64,13,142,54,185,151,129,90,209,198,182,201,140,101,191,149,50,8,214,218,48,6,55,145,207,181,36,146,224,80,3,102,149,201,235,69,188,206,27,174,106,180,146,123,212,214,108,185,203,16,5,0,65,169,92,174,242,164,114,71,74,202,95,49,14,64,35,233,91,183,86,86,247,50,121,155,200,110,156,26,106,89,2,187,115,146,40,3,32,93,72,6,14,63,30,41,143,43,63,82,162,180,103,178,193,57,21,73,237,64,237,64,16,172,91,250,54,77,34,146,146,12,211,226,5,38,0,83,102,230,78,59,80,5,180,148,5,235,76,150,94,58,213,81,33,28,26,25,137,20,0,168,119,190,77,89,50,5,90,166,175,182,156,9,115,207,74,0,158,5,243,36,222,122,84,178,126,246,65,26,244,254,35,237,81,137,54,168,84,25,99,82,17,228,166,192,115,44,157,79,165,0,50,102,243,91,203,95,184,181,20,143,252,41,79,144,136,148,34,242,198,165,134,36,183,79,50,110,92,244,20,0,200,108,139,13,210,28,10,152,219,219,40,193,122,133,231,150,115,133,224,123,80,182,110,220,154,0,147,236,176,191,17,202,51,232,
105,146,89,184,30,163,212,83,254,196,127,188,127,26,4,83,64,119,46,118,247,199,248,80,5,70,141,212,96,140,138,42,224,157,88,102,85,5,127,188,148,80,4,241,161,142,60,117,145,250,213,184,99,91,88,247,183,50,55,79,106,116,17,117,149,250,84,23,46,119,22,111,255,0,85,0,57,166,247,170,210,220,0,58,213,121,103,39,56,233,235,85,90,66,79,28,251,208,4,239,43,57,235,129,239,79,143,230,63,126,170,0,123,154,122,156,30,13,0,105,40,97,222,165,73,89,15,90,161,29,214,222,26,172,137,81,215,42,69,0,106,35,165,194,97,184,111,231,89,215,65,80,176,244,171,22,67,205,7,21,153,114,25,238,164,70,99,181,125,59,208,4,10,112,90,83,211,160,165,72,240,133,155,169,161,74,200,251,155,132,94,0,166,207,55,152,118,160,160,8,27,27,143,165,61,35,121,62,232,53,52,112,44,96,60,199,232,41,94,239,3,8,48,40,1,5,147,127,17,166,155,96,191,196,41,141,112,199,214,164,136,51,156,158,148,1,44,106,144,41,110,167,249,210,110,216,173,35,253,243,211,218,154,88,51,255,0,176,159,169,165,92,49,243,164,251,131,238,175,247,141,0,44,
106,33,95,62,110,88,253,213,165,142,9,46,223,115,231,7,181,79,109,105,37,204,190,100,159,151,165,107,162,71,110,160,1,150,160,10,246,250,120,69,5,176,42,200,133,7,3,20,199,115,214,71,17,143,74,129,175,237,163,56,220,91,222,128,37,158,220,133,200,170,13,41,141,176,221,42,244,90,148,50,29,189,141,45,197,164,115,174,228,35,158,148,1,155,44,34,79,222,195,195,119,30,180,84,203,111,36,13,130,56,162,128,44,218,220,121,176,249,178,13,177,15,187,158,245,159,123,112,101,36,253,212,236,61,104,162,128,51,216,238,57,60,10,97,112,56,90,40,160,6,228,158,166,156,163,111,45,69,20,1,34,129,33,192,167,249,44,142,17,9,44,221,168,162,128,52,180,169,132,11,50,202,121,83,138,166,92,75,118,204,57,4,115,69,20,1,90,88,194,19,201,228,244,169,16,45,178,238,108,25,15,111,74,40,160,8,30,86,145,137,38,163,52,81,64,19,65,3,57,228,85,153,200,134,61,139,247,141,20,80,4,113,70,54,238,147,33,7,167,86,62,149,114,222,221,166,144,60,131,24,251,170,59,10,40,160,13,133,65,18,96,96,28,114,125,43,58,235,82,72,73,88,62,
119,238,198,138,40,3,42,107,135,149,137,145,201,246,21,16,42,115,192,162,138,0,150,214,54,105,50,160,226,182,4,133,33,8,79,52,81,64,18,155,143,46,213,158,97,144,58,26,40,162,128,63,255,217);

back_metal:array[0..5206] of byte=(
137,80,78,71,13,10,26,10,0,0,0,13,73,72,68,82,0,0,0,190,0,0,0,124,8,3,0,0,0,224,138,250,16,0,0,0,23,116,69,88,116,83,111,102,116,119,97,114,101,0,68,97,110,105,32,118,49,46,48,48,46,50,54,48,20,195,73,175,0,0,0,30,116,69,88,116,98,101,46,112,110,103,46,115,101,116,116,105,110,103,115,0,53,51,54,56,55,48,57,49,49,46,45,49,46,53,41,132,140,74,0,0,0,18,80,76,84,69,250,250,250,240,240,240,0,0,0,245,245,245,230,230,230,235,235,235,211,28,204,211,0,0,0,6,116,82,78,83,0,255,255,255,255,255,122,121,224,254,0,0,19,161,73,68,65,84,120,1,213,92,135,118,99,199,14,115,211,255,255,242,3,64,130,4,101,57,229,36,121,217,104,55,186,83,72,16,44,83,36,123,243,246,166,215,251,199,123,53,220,253,236,238,231,199,215,215,199,76,126,126,60,62,60,243,246,246,25,109,244,22,32,52,122,240,253,227,227,107,231,67,244,128,36,60,53,190,198,192,231,80,16,202,19,221,3,242,246,254,62,106,111,111,239,143,143,247,117,45,103,14,227,68,120,124,124,60,150,107,181,114,236,71,183,1,18,166,222,63,30,219,195,204,118,210,
24,224,17,141,8,200,231,70,27,115,96,31,84,30,33,119,188,76,74,67,245,19,145,104,228,25,35,88,10,131,87,248,250,25,237,55,240,95,211,200,70,216,78,198,137,70,249,244,19,244,15,198,250,2,66,219,25,8,224,194,106,169,176,22,166,218,30,138,67,51,24,113,90,203,92,157,170,56,166,47,171,19,130,112,11,120,137,13,246,65,18,150,150,113,90,26,21,48,142,56,163,240,182,0,216,158,149,51,10,226,159,160,199,66,134,46,85,160,181,245,242,130,189,135,78,104,50,207,168,156,53,26,200,12,178,211,133,225,199,99,231,30,147,150,167,24,1,202,42,111,16,178,109,22,238,24,193,224,34,145,253,240,191,195,234,121,40,9,31,245,0,62,43,231,172,155,79,17,169,119,25,204,250,37,31,13,226,237,41,72,51,190,206,28,86,165,86,28,143,187,227,98,33,216,11,201,103,167,10,57,97,170,13,253,181,221,10,169,23,179,99,138,154,153,151,19,166,233,8,54,161,168,143,164,109,126,0,243,121,4,126,236,156,104,109,16,9,64,50,245,250,116,103,26,28,15,129,108,103,54,135,178,112,158,73,4,0,104,188,189,71,31,162,209,203,42,188,144,103,75,72,
252,104,255,110,243,15,66,50,200,21,15,121,31,176,136,69,204,160,23,171,134,9,205,201,244,235,76,165,82,180,163,121,128,115,60,219,127,208,218,193,90,175,212,138,67,14,253,3,152,150,78,60,122,66,73,27,33,28,87,39,18,210,232,188,190,84,144,185,72,252,32,145,215,33,130,238,236,82,156,220,23,234,239,32,32,248,238,31,184,236,152,12,53,103,156,199,85,102,14,38,176,54,13,46,177,212,107,6,163,206,254,118,0,124,98,129,189,237,53,255,227,165,214,155,65,252,180,161,121,206,4,24,135,145,220,152,74,54,183,22,238,24,233,203,196,168,97,245,48,178,158,103,241,31,154,171,114,151,72,225,23,178,161,86,182,45,4,99,128,46,13,90,112,175,68,85,1,30,250,12,6,176,106,87,46,188,141,74,201,29,137,60,41,72,224,253,72,252,216,49,3,226,192,242,118,183,92,138,80,35,212,138,103,39,121,34,23,195,21,190,44,202,150,107,214,143,108,133,16,224,84,155,26,146,161,67,133,166,6,254,84,94,147,234,201,16,218,219,140,75,85,216,216,153,199,80,128,242,102,20,6,182,25,53,175,240,236,204,113,178,92,110,50,52,116,120,101,160,
148,245,65,193,134,191,81,160,78,247,176,234,205,39,211,200,138,223,72,64,222,14,175,60,211,18,144,231,68,249,185,198,74,103,245,204,67,68,145,241,157,9,251,12,236,70,65,236,203,116,144,132,196,232,42,222,171,128,83,102,124,241,82,14,16,5,113,37,208,61,53,150,215,145,172,177,9,173,27,97,176,33,76,8,73,119,176,250,179,138,194,176,177,132,197,97,216,217,79,180,152,45,157,142,98,223,56,217,155,61,137,17,60,161,139,226,51,211,122,154,29,123,60,113,156,98,116,97,240,225,114,224,29,25,37,34,105,88,47,41,200,7,123,152,112,17,49,90,18,197,99,12,196,238,74,45,239,79,180,82,198,121,199,44,8,248,66,228,195,197,242,148,157,12,84,8,122,72,31,144,170,77,9,96,225,63,69,144,246,28,27,219,147,72,174,195,33,74,199,187,115,47,209,131,13,48,75,236,197,158,139,90,190,148,213,112,87,183,127,219,39,72,209,126,128,224,64,170,186,39,126,45,129,105,186,81,168,18,101,119,116,206,71,203,25,165,121,119,186,208,220,157,231,74,196,197,190,104,42,96,228,149,177,101,102,70,25,83,160,142,11,243,108,26,79,210,
185,35,115,213,45,227,173,134,131,31,97,72,171,79,176,85,82,164,113,132,2,147,52,7,11,113,152,246,213,64,64,63,222,246,50,242,4,152,241,131,169,197,88,16,126,147,48,5,176,195,79,196,158,152,6,105,101,177,129,99,248,90,75,19,105,3,237,7,238,251,27,13,242,167,173,126,5,51,84,242,206,148,33,244,169,63,43,56,144,239,135,158,66,131,146,17,164,95,29,174,33,34,179,151,252,225,151,89,96,124,219,151,32,162,55,82,223,26,9,151,69,87,227,122,159,253,158,153,26,7,209,49,211,0,141,82,12,233,218,255,3,178,53,190,27,12,168,31,154,199,232,101,63,27,219,228,129,194,107,4,228,71,251,51,216,239,40,14,173,149,216,136,22,68,205,212,168,218,147,86,82,77,42,236,114,236,251,235,72,185,67,89,192,214,182,140,0,47,227,3,187,187,23,182,168,73,132,182,171,78,48,64,98,135,221,111,211,108,136,124,8,222,253,222,50,237,87,80,78,133,227,196,11,25,202,14,27,248,157,31,22,226,106,177,78,105,127,109,32,86,246,134,145,39,234,108,114,171,64,80,179,128,192,246,152,11,83,245,83,130,35,110,181,23,3,26,194,27,25,231,2,
153,91,215,64,3,4,36,11,226,80,132,34,52,99,81,132,107,60,158,198,122,43,163,191,245,197,78,249,210,76,202,128,117,240,156,129,75,16,19,237,108,61,114,118,84,228,151,177,38,170,220,138,76,107,105,151,27,20,134,155,118,116,116,68,228,224,26,182,178,190,92,66,8,34,81,19,39,190,12,183,235,245,9,59,114,24,205,189,65,204,78,68,244,5,141,246,214,63,248,79,86,3,44,154,93,86,205,122,195,81,238,45,253,240,132,110,205,29,141,114,7,110,179,188,195,92,170,93,7,88,24,83,220,143,252,218,226,221,41,97,249,27,4,139,115,100,22,238,55,12,130,88,49,47,94,213,145,115,145,23,101,117,250,198,197,0,246,192,30,230,122,176,196,134,158,190,58,109,123,7,147,193,16,122,143,242,142,4,16,112,209,105,77,138,107,7,3,98,166,97,190,73,224,243,141,68,74,182,102,2,19,19,77,147,43,109,194,134,193,97,207,106,119,76,46,177,89,153,132,61,150,103,245,35,252,1,52,160,220,221,60,49,131,0,137,32,16,147,188,63,240,238,149,202,49,140,76,162,51,222,100,105,154,84,145,172,228,231,224,94,255,200,54,126,146,69,49,252,180,203,
254,196,222,155,23,150,0,69,153,155,190,232,217,216,56,37,195,60,40,229,66,28,141,177,32,232,237,208,28,184,246,218,19,155,137,136,13,154,67,182,77,195,161,201,18,218,93,183,39,141,164,98,162,8,226,54,71,145,193,157,24,118,212,147,48,24,199,116,196,59,54,100,202,207,46,192,220,150,77,0,219,34,155,205,111,19,136,161,9,198,52,161,220,131,218,237,130,220,20,24,106,102,21,89,64,75,80,206,12,40,220,141,188,162,115,4,39,48,0,128,25,115,246,176,105,40,102,30,100,13,176,234,58,144,30,150,33,119,172,200,27,93,112,243,176,84,239,162,178,166,96,250,194,220,99,65,89,161,240,240,250,152,195,155,237,176,118,109,113,197,59,43,25,145,85,24,54,104,68,156,71,224,14,79,25,80,141,23,102,213,95,9,15,146,166,48,214,24,3,5,141,117,68,129,233,55,175,30,94,144,70,2,5,140,192,227,92,48,46,146,59,139,213,26,137,114,224,215,54,91,134,160,184,152,115,12,212,209,169,63,71,87,52,33,38,173,160,28,205,158,148,121,15,227,57,5,128,146,197,106,0,75,84,186,151,5,90,33,58,204,131,155,167,201,178,220,22,139,24,238,
241,161,141,41,9,126,23,17,254,89,57,229,79,141,175,252,46,57,123,204,58,224,230,141,119,44,128,217,106,168,110,174,91,40,0,242,242,216,105,241,143,189,186,124,145,229,161,107,255,8,185,108,78,251,174,102,169,235,141,129,172,30,87,114,151,119,96,232,252,64,232,145,128,189,144,166,25,110,63,205,122,83,70,68,251,167,195,110,58,1,29,241,47,6,204,68,168,165,40,175,64,37,116,86,22,195,90,195,240,195,9,186,122,12,175,196,224,222,64,76,104,56,8,85,99,184,197,249,17,14,211,163,39,5,177,181,103,88,161,48,229,30,231,163,173,57,27,25,96,140,118,192,203,143,86,224,67,77,161,33,40,117,250,107,184,198,45,32,185,141,193,156,4,152,31,167,194,52,9,8,128,13,188,130,50,164,24,193,46,46,8,133,156,134,187,15,99,174,145,149,89,63,122,76,25,128,40,149,200,190,15,122,109,58,157,245,53,16,172,215,110,174,148,132,151,129,226,114,40,151,166,39,218,158,156,124,141,148,53,226,5,32,178,130,32,26,104,107,128,191,10,212,191,148,83,176,37,209,145,162,9,151,255,234,163,228,25,202,162,163,29,128,114,124,117,46,
213,12,95,212,148,0,222,30,241,171,68,17,239,189,67,65,186,161,41,61,133,234,244,21,193,202,37,143,44,254,7,65,196,171,102,104,39,98,138,125,137,35,122,45,46,136,218,197,141,32,93,249,90,233,118,16,142,50,23,234,177,90,167,68,88,82,150,94,71,104,124,232,47,182,91,158,100,248,62,191,200,237,241,241,165,78,49,44,221,133,219,214,15,192,121,108,192,72,231,165,174,93,196,197,178,229,247,25,74,24,38,39,28,9,12,18,19,14,19,212,121,90,177,211,14,211,158,18,146,47,136,213,117,135,23,31,235,120,146,55,234,62,127,209,154,27,186,197,160,60,99,128,146,176,64,153,108,10,33,222,80,3,241,143,202,191,162,143,223,94,145,115,180,47,63,28,251,98,35,0,105,87,107,12,51,121,91,3,230,192,79,71,2,224,99,92,42,85,85,93,111,22,46,47,206,88,119,27,28,133,196,20,7,102,240,59,54,164,135,93,144,86,29,119,4,9,30,201,53,185,135,15,171,232,232,197,178,237,230,24,96,76,236,94,151,30,101,231,82,64,163,166,63,177,132,182,247,222,34,32,120,11,162,51,240,180,216,162,92,41,181,154,69,174,105,170,141,232,211,49,253,
121,124,125,77,219,30,139,52,20,26,201,235,147,60,135,19,67,105,255,16,39,98,105,126,4,232,136,0,48,213,105,162,252,120,95,198,168,196,81,134,149,47,23,47,241,100,76,36,217,249,250,82,252,53,193,207,186,240,25,191,247,84,139,150,254,211,95,89,100,135,77,127,250,24,63,72,217,177,167,161,42,73,102,164,91,12,88,209,16,21,245,132,166,148,116,107,36,46,152,220,47,187,253,163,180,170,116,17,165,101,96,0,65,68,43,242,140,88,217,102,75,123,145,216,177,128,17,69,151,145,35,211,194,197,175,55,40,252,36,138,178,212,182,9,98,227,47,126,12,210,161,193,100,225,209,8,151,94,33,76,164,217,109,27,42,25,226,81,84,71,129,136,161,91,105,17,46,39,233,8,179,195,100,211,37,189,250,129,1,51,194,240,204,50,221,14,126,151,3,81,167,92,104,65,1,66,3,174,243,87,218,38,113,108,54,239,61,53,100,188,45,55,5,50,128,232,16,217,89,81,45,92,198,10,127,204,158,238,220,23,142,49,143,5,251,114,10,210,42,173,210,90,50,196,3,138,144,43,74,100,98,24,56,26,153,229,114,195,139,73,105,195,107,6,191,193,235,193,158,43,208,
226,95,200,218,121,120,214,194,192,152,24,83,27,181,136,253,16,128,46,29,47,189,173,44,26,225,75,227,6,29,200,174,15,140,83,87,230,33,123,156,183,44,225,133,68,176,110,72,79,231,47,139,6,223,192,160,192,113,62,126,41,90,37,131,137,106,32,169,91,159,6,64,196,251,84,65,0,48,200,48,112,167,152,121,168,84,91,4,187,57,85,77,183,8,42,53,173,13,218,82,68,217,192,107,204,51,185,205,127,225,169,247,133,179,156,165,254,133,31,205,169,108,183,70,8,208,169,14,239,171,30,56,135,65,104,155,43,71,248,58,243,179,214,167,38,192,40,18,249,82,61,46,91,59,111,165,133,47,99,16,70,12,48,43,227,255,221,183,63,95,60,155,231,95,161,120,88,85,255,221,165,203,149,160,37,198,109,31,127,158,94,191,250,198,9,238,88,87,222,248,189,36,237,198,223,127,108,113,9,255,221,199,22,163,174,69,94,241,231,7,24,109,88,255,228,165,129,31,135,58,213,177,195,189,190,52,240,174,200,136,146,94,9,179,197,63,136,55,227,63,247,18,245,123,151,195,48,55,100,111,254,245,121,187,76,206,134,172,157,244,223,187,178,241,212,214,159,
127,236,194,60,59,62,204,204,133,33,14,138,191,118,97,230,206,195,248,179,38,121,94,48,228,44,158,57,123,244,173,110,47,6,78,58,252,62,16,153,111,143,254,223,63,174,232,178,33,2,255,206,135,69,230,198,23,155,9,206,52,24,42,148,111,197,7,97,101,210,158,63,44,42,187,29,119,223,127,123,133,116,168,9,241,61,254,54,236,229,68,97,154,208,83,249,196,218,4,32,151,86,13,58,75,208,236,140,17,227,5,251,25,131,158,132,165,47,63,68,148,235,87,31,213,97,15,165,50,238,177,130,36,154,223,80,28,95,204,229,9,184,182,17,79,42,80,127,203,23,37,220,160,204,8,228,42,60,8,152,246,34,71,165,24,147,81,220,156,118,63,227,202,232,232,35,192,211,66,96,188,247,121,165,104,14,43,148,79,69,182,194,129,8,213,12,13,121,91,70,115,146,205,225,193,13,115,27,122,198,48,239,255,150,198,179,254,10,121,203,36,211,6,167,39,8,142,48,196,231,103,53,82,21,32,161,170,30,234,223,11,254,249,47,9,25,88,87,217,70,176,96,59,136,65,153,165,195,191,50,190,142,144,156,62,99,126,71,42,101,9,172,83,138,1,109,96,22,70,137,70,55,58,
26,117,100,180,227,101,9,2,99,85,202,61,188,241,206,152,209,26,4,74,230,80,142,111,155,41,132,215,224,163,233,143,67,36,229,74,225,104,215,35,152,98,180,21,248,80,211,71,36,248,195,17,13,215,184,5,36,87,186,52,24,126,172,153,48,77,25,1,176,129,215,165,44,11,59,157,213,129,15,60,67,218,25,130,126,88,70,230,122,226,234,113,80,98,140,149,140,234,205,25,144,90,143,47,26,152,109,144,194,52,199,131,32,157,113,183,195,147,211,219,238,59,91,153,183,134,248,215,90,132,39,155,138,48,161,250,231,149,3,102,114,57,141,8,215,122,179,255,75,63,28,2,160,216,14,48,200,69,219,161,125,118,96,207,215,8,24,252,107,23,17,80,176,102,88,249,116,68,119,30,137,113,48,96,108,179,227,65,145,216,172,5,161,38,135,17,34,48,246,175,227,111,91,161,26,205,33,26,222,98,122,22,8,79,21,132,30,177,87,67,222,163,101,4,63,57,126,40,79,167,37,138,226,248,10,233,10,118,211,150,19,30,146,17,189,193,163,255,196,143,165,125,222,22,233,200,98,238,40,235,188,86,214,70,168,253,237,72,177,231,37,129,102,28,91,37,183,69,178,
10,137,181,5,213,49,134,26,230,99,120,224,169,134,173,65,191,142,84,224,204,139,111,12,156,92,87,22,140,88,92,171,101,52,72,172,131,178,40,68,94,119,240,215,56,67,148,134,220,113,139,7,53,160,151,137,5,48,114,35,18,19,248,165,128,116,141,220,12,0,19,187,114,2,129,242,179,156,105,188,224,118,251,161,162,191,146,102,237,215,60,134,134,242,170,143,31,50,134,55,91,143,216,141,52,231,146,32,13,41,18,235,208,218,160,232,24,68,29,140,12,26,14,153,90,61,195,173,166,141,163,57,237,30,66,26,134,219,108,68,128,25,88,181,214,198,234,231,71,188,34,220,144,56,186,72,133,71,216,232,65,96,239,170,19,58,142,70,46,28,81,226,176,254,234,5,86,134,65,243,159,248,101,48,92,236,109,65,129,35,143,114,161,41,224,49,177,225,144,29,163,83,195,14,131,3,35,191,90,249,150,168,83,161,73,40,111,127,10,67,31,5,90,57,64,185,2,77,116,45,169,26,22,132,129,3,61,190,171,217,48,218,46,106,80,19,77,148,178,19,116,52,134,127,212,12,68,102,181,156,32,176,12,109,248,239,254,69,72,146,204,138,231,37,103,217,5,81,58,59,
185,219,38,50,234,235,27,194,54,52,159,127,56,212,209,129,91,6,193,146,156,235,212,194,165,145,108,67,194,27,130,160,114,153,207,170,242,76,215,51,217,78,204,217,182,233,211,220,216,242,154,32,8,101,218,77,6,223,109,94,33,74,34,243,243,26,183,77,119,200,206,6,4,136,13,121,120,34,104,175,229,66,205,217,137,254,113,107,42,155,43,193,244,214,28,0,154,61,50,229,162,30,29,88,204,8,109,221,54,193,118,13,143,48,126,232,135,138,232,15,32,20,88,231,14,29,39,103,221,101,42,118,165,213,210,41,148,162,189,110,228,178,226,94,208,182,18,40,86,127,197,87,12,104,246,21,71,3,244,51,220,115,58,249,140,52,193,212,84,119,66,238,105,162,168,54,16,171,106,107,4,151,183,85,94,133,132,129,192,242,100,216,146,198,144,13,154,51,134,134,101,53,230,14,101,1,164,80,149,47,155,11,203,64,100,255,241,7,235,223,75,132,223,192,120,121,2,36,35,254,42,246,8,212,48,238,164,21,213,48,244,68,83,92,251,237,184,149,42,94,156,20,48,183,106,219,23,140,142,118,252,27,27,238,182,126,197,48,63,235,245,112,165,161,164,106,
84,237,77,26,228,146,10,187,70,252,205,103,42,69,174,27,76,179,179,211,192,176,221,82,178,94,88,224,157,172,237,133,116,101,164,76,253,182,193,31,184,214,133,217,147,182,192,254,218,187,237,54,70,158,19,36,232,173,117,239,92,6,229,19,179,198,150,96,117,152,86,122,197,222,234,179,237,236,220,118,73,26,87,23,102,111,101,109,196,115,132,88,140,172,130,53,164,143,82,102,181,195,151,138,0,131,219,105,242,3,89,89,140,97,232,15,40,34,151,97,76,41,70,239,87,252,39,151,32,188,59,40,162,184,190,36,123,110,100,248,117,164,95,226,31,188,78,136,65,85,219,213,171,146,162,91,83,28,72,17,255,193,235,205,180,202,121,54,53,22,208,63,246,207,141,185,171,58,174,187,134,116,82,128,0,75,23,63,242,201,194,161,91,163,17,180,13,66,207,120,74,133,139,92,91,190,193,245,87,6,146,94,123,253,91,25,21,21,186,91,45,32,245,9,132,199,24,152,32,119,140,187,240,99,99,158,239,37,80,39,116,240,112,249,121,155,177,81,60,211,99,116,24,138,158,69,110,188,64,59,46,42,70,134,165,37,64,100,13,194,153,139,22,179,165,83,
181,108,167,217,219,248,194,232,222,0,1,47,180,54,243,237,97,134,156,112,220,36,116,32,144,153,73,31,141,149,249,250,249,71,65,62,173,186,67,63,62,139,251,4,14,16,26,6,252,122,95,161,43,88,68,112,115,72,201,30,238,102,243,168,65,162,204,252,1,196,141,113,38,196,189,123,25,255,128,34,201,229,131,9,115,91,249,9,129,76,227,231,155,206,35,250,97,250,80,162,159,52,44,227,106,98,122,121,49,10,229,8,223,195,149,86,243,92,8,129,230,232,151,130,186,174,22,118,2,20,69,152,44,141,39,161,129,73,133,203,130,63,160,132,88,199,169,12,117,167,160,126,236,44,184,248,108,119,163,92,129,50,182,36,216,169,225,130,215,130,106,210,113,153,224,200,34,254,200,129,188,21,185,149,165,98,134,220,214,101,227,0,105,164,135,35,49,81,243,181,121,93,108,21,130,135,98,13,28,175,22,26,45,27,149,146,59,146,8,171,169,17,165,198,40,64,207,90,126,182,244,208,24,1,52,114,139,206,138,47,29,47,85,246,16,167,41,53,34,47,92,227,151,80,13,203,244,202,96,234,208,12,13,172,39,35,97,84,201,112,255,240,207,78,183,203,136,213,
121,246,197,186,160,9,208,223,89,160,166,94,83,72,88,207,147,199,115,221,239,46,221,138,126,248,147,69,245,143,151,79,216,75,206,60,168,51,66,249,9,77,96,140,69,135,226,165,2,132,78,73,12,18,181,15,17,116,99,213,11,220,111,71,233,73,235,236,186,9,152,74,209,142,102,248,117,154,235,238,55,142,63,90,187,0,212,115,129,160,13,155,209,251,57,30,103,119,78,162,209,254,221,230,97,143,3,54,130,26,186,36,181,185,198,217,229,26,100,204,177,1,229,41,255,60,123,68,163,227,59,10,33,0,82,143,231,246,172,183,105,252,134,48,214,221,146,188,20,195,238,183,248,242,194,156,243,14,73,81,250,17,39,183,150,35,148,71,123,79,228,124,38,215,166,232,84,110,76,57,174,130,216,184,36,148,210,194,140,61,15,130,186,135,184,199,73,155,111,30,100,59,163,69,121,142,241,117,191,206,214,112,80,70,214,86,50,180,78,54,211,204,220,80,53,152,51,65,103,32,155,1,250,30,122,2,94,103,120,177,149,120,145,182,188,110,111,246,24,230,242,127,39,10,46,123,87,72,42,128,178,202,253,104,24,65,34,167,245,189,136,218,254,24,175,
225,20,11,4,230,56,56,191,228,207,219,204,110,204,249,61,15,19,182,55,163,164,146,64,79,22,126,92,207,32,58,164,19,139,14,228,71,244,187,37,164,165,227,216,64,0,116,130,204,227,107,142,171,90,46,109,115,196,105,109,221,101,103,115,122,77,95,86,39,23,0,29,95,56,113,49,2,48,190,77,67,253,231,162,79,66,19,127,28,95,62,174,102,140,241,73,225,179,188,240,249,149,243,253,66,28,220,148,151,201,241,48,62,128,183,254,80,0,145,141,100,252,35,194,161,218,4,114,44,217,63,131,108,172,184,84,182,7,47,183,115,233,194,194,73,26,187,246,244,23,255,159,120,255,15,83,53,80,185,133,165,249,168,0,0,0,0,73,69,78,68,174,66,96,130);

back_ivy:array[0..4997] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,27,18,20,23,20,17,27,23,22,23,30,28,27,32,40,66,43,40,37,37,40,81,58,61,48,66,96,85,101,100,95,85,93,91,106,120,153,129,106,113,144,115,91,93,133,181,134,144,158,163,171,173,171,103,128,188,201,186,166,199,153,168,171,164,255,219,0,67,1,28,30,30,40,35,40,78,43,43,78,164,110,93,110,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,255,192,0,17,8,0,189,0,189,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,
119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,
247,248,249,250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,205,5,163,108,243,131,239,82,133,105,15,202,115,158,244,174,80,39,32,176,244,199,53,23,79,154,50,126,153,174,113,11,44,82,70,191,119,7,220,210,110,0,114,71,224,41,201,57,42,124,211,145,158,42,120,237,22,97,195,0,61,115,70,163,31,167,175,155,38,68,64,160,234,90,175,176,10,50,163,240,197,65,9,22,224,196,128,17,245,169,60,207,148,150,97,143,64,40,24,252,141,157,179,89,119,19,48,151,229,98,59,245,169,158,241,242,84,32,197,86,141,124,219,145,215,29,77,38,34,237,170,178,195,186,70,37,159,158,77,60,181,4,147,77,40,79,222,32,47,214,179,220,101,107,155,141,131,247,108,65,245,6,160,180,184,38,98,210,177,100,232,119,28,213,242,240,99,11,16,152,142,202,185,253,106,156,151,128,229,82,202,33,245,90,213,45,4,104,121,81,127,20,72,234,122,54,208,104,123,40,72,226,52,252,133,65,167,36,177,199,137,221,118,30,66,103,145,86,89,213,70,23,63,74,157,134,81,146,0,140,228,40,81,198,48,42,12,60,127,62,246,193,233,201,171,243,47,200,122,253,42,9,80,52,
91,64,228,80,152,153,12,18,59,204,3,49,32,251,213,207,186,196,230,168,5,43,219,6,165,87,158,78,198,173,136,176,167,57,207,122,88,216,3,201,20,136,187,62,247,83,76,221,179,62,212,128,179,50,134,78,188,246,170,102,82,62,82,72,166,189,222,214,198,72,168,228,148,55,78,180,198,14,191,197,147,205,40,85,32,113,67,115,24,4,28,253,105,66,140,117,52,150,130,52,2,170,163,54,209,129,234,42,140,200,3,124,160,12,244,173,11,129,181,66,126,53,78,64,73,247,20,152,202,230,29,195,107,46,125,234,204,10,200,187,85,112,62,180,21,97,130,196,40,61,201,169,209,64,64,119,19,248,84,54,194,193,183,31,49,198,105,79,78,121,163,240,165,61,13,0,103,203,35,52,140,51,210,166,179,92,2,222,189,41,162,212,239,99,158,15,36,212,143,50,193,31,64,72,28,10,111,178,1,243,72,98,77,195,174,125,42,172,197,165,144,96,147,248,241,82,90,72,102,71,19,2,192,212,222,82,4,253,222,113,66,247,116,2,188,106,200,155,55,156,30,217,171,49,65,24,229,220,125,5,50,8,137,147,12,64,110,194,166,32,47,83,199,210,134,198,56,152,251,48,252,141,
70,204,160,241,38,63,224,38,163,154,226,40,184,44,73,244,2,163,243,55,253,220,140,250,210,212,9,12,139,255,0,61,14,127,221,52,198,117,101,217,20,170,174,127,188,49,249,84,79,39,27,87,241,53,28,139,251,176,203,140,253,41,164,23,37,141,217,70,217,10,126,53,60,45,187,229,136,238,245,192,226,178,193,53,177,167,152,227,131,104,201,115,203,113,86,196,14,73,109,184,228,85,123,129,243,117,169,167,12,187,228,206,6,254,149,21,195,41,147,130,49,64,20,164,80,132,188,157,206,20,127,90,146,211,110,94,86,0,172,99,32,122,158,212,249,150,57,39,222,192,149,3,10,190,213,60,76,138,191,42,5,31,74,111,96,185,28,17,151,1,138,158,57,60,85,209,26,16,8,64,62,162,156,165,72,24,235,78,49,55,115,64,12,149,178,236,127,10,170,229,148,252,157,79,181,58,105,4,106,92,246,168,237,110,4,191,120,0,227,242,172,221,222,160,77,20,33,126,121,14,247,247,61,42,94,77,68,242,42,12,177,250,10,154,221,94,72,247,176,0,30,131,218,164,97,138,70,244,167,183,21,27,54,209,156,100,211,16,230,226,50,113,218,177,229,14,231,28,238,
36,102,173,181,204,209,187,28,131,158,160,142,42,120,166,137,190,102,77,167,233,154,181,116,4,104,134,24,192,57,205,59,126,212,227,62,162,172,59,66,227,27,215,241,53,82,72,194,156,19,145,219,154,128,16,200,132,130,236,85,151,144,194,155,45,212,147,46,197,78,189,91,29,105,158,88,13,210,165,137,194,141,216,28,118,197,61,16,21,210,2,175,243,245,29,169,206,248,24,29,63,157,58,83,133,220,79,36,244,239,81,170,52,172,6,63,12,85,45,64,116,75,189,75,99,145,218,157,34,109,85,12,127,135,250,212,177,219,249,100,29,199,61,199,106,101,223,1,127,26,98,42,186,17,206,42,120,228,35,14,167,6,155,141,192,45,55,6,51,208,145,77,129,106,75,207,220,237,219,243,147,207,28,85,94,248,200,205,75,31,144,195,230,114,167,215,20,201,34,216,251,128,45,248,210,186,24,1,147,208,154,154,59,89,164,1,182,128,190,230,171,143,48,184,85,24,207,181,109,65,16,130,16,187,137,39,146,73,166,9,17,67,11,70,6,72,171,25,61,243,76,111,189,144,115,138,73,27,167,74,16,25,142,146,78,187,112,125,125,41,166,38,182,96,164,2,125,115,
83,18,80,179,19,211,167,21,11,51,63,83,154,139,246,1,164,147,203,18,73,173,184,128,91,100,227,141,162,177,25,195,62,7,97,90,214,211,111,176,30,171,242,211,176,34,57,152,133,37,84,177,244,2,178,36,146,227,146,206,195,219,53,117,239,68,119,123,51,129,235,239,87,110,21,102,135,121,81,211,147,138,168,160,50,99,86,216,12,140,73,110,153,61,170,110,7,122,142,70,249,212,122,116,167,15,74,77,136,115,5,56,29,207,20,231,249,120,200,207,244,166,70,63,126,78,71,202,58,85,105,174,9,99,180,254,52,173,125,6,88,46,163,3,61,58,210,163,141,216,197,103,137,14,236,213,184,177,247,179,67,141,128,179,247,152,13,163,235,83,164,64,146,17,249,244,170,193,136,249,128,207,167,52,206,91,146,72,3,160,6,164,11,143,4,163,163,103,241,170,211,43,228,41,207,183,53,126,223,121,143,247,141,159,78,41,178,194,25,243,222,169,32,42,121,50,46,62,80,63,42,108,145,78,191,56,198,207,76,213,209,147,198,114,125,113,76,184,198,237,157,128,230,155,3,50,68,7,185,230,157,20,204,178,236,104,201,94,213,46,192,199,230,237,74,21,
35,251,207,183,53,60,221,4,92,83,16,78,20,100,142,77,58,48,89,126,110,49,234,106,188,115,218,167,37,217,182,245,192,162,93,82,31,224,137,155,253,227,129,77,92,100,151,12,206,155,35,7,30,162,169,254,240,118,106,191,4,173,60,42,204,160,110,236,7,20,174,177,174,50,5,0,81,156,243,180,125,77,64,242,236,109,162,173,195,23,152,187,213,114,72,200,205,81,184,134,72,203,49,82,125,105,65,106,4,66,77,178,131,249,214,157,172,187,97,145,115,199,6,177,170,213,188,251,96,242,201,229,155,175,181,105,40,246,2,118,117,154,54,77,160,186,243,210,157,5,225,88,154,38,207,76,3,85,46,9,138,96,202,113,145,81,172,129,189,115,66,90,1,111,118,92,113,68,211,8,147,35,239,30,149,22,253,163,53,17,87,149,186,28,154,73,119,16,69,113,182,41,84,228,180,152,231,52,202,211,130,40,35,133,60,203,101,102,60,103,60,85,184,150,38,56,88,35,31,128,161,205,21,99,11,30,198,172,91,56,11,134,63,78,43,116,5,3,144,139,142,216,170,147,249,42,75,42,2,15,81,138,78,119,208,44,84,119,227,3,189,77,111,24,65,239,222,165,141,151,56,137,
7,160,111,240,169,35,141,80,101,170,68,61,9,199,160,20,187,139,48,25,226,162,146,234,24,248,102,201,244,94,106,91,103,75,132,46,160,140,28,98,168,9,66,170,243,84,229,231,44,123,213,169,142,212,35,61,106,177,59,169,73,131,43,183,7,119,173,81,145,152,78,249,195,41,60,140,214,148,168,118,213,25,96,50,58,109,251,205,198,41,67,125,68,42,39,76,100,238,255,0,34,173,11,40,149,119,74,72,39,176,52,249,100,130,200,96,176,105,7,64,43,58,91,137,110,15,67,142,192,85,217,129,179,8,85,140,5,7,0,113,81,72,196,191,20,203,121,63,112,131,60,129,200,168,222,85,83,243,28,102,179,99,41,153,165,59,4,110,80,34,142,115,142,213,42,106,63,39,239,219,205,110,195,111,245,170,102,25,56,220,184,4,100,103,210,154,99,97,216,17,237,91,217,1,52,151,48,201,146,208,149,99,221,77,84,201,61,205,41,250,83,226,136,200,122,224,14,166,171,68,4,131,46,138,101,228,40,249,71,173,39,208,81,36,170,91,106,244,245,168,203,30,221,42,82,98,30,73,63,133,88,129,243,24,28,113,85,50,88,245,167,193,187,126,225,255,0,235,161,173,0,214,
139,12,170,27,160,232,41,162,119,73,54,228,243,198,7,28,82,219,140,198,125,115,79,141,82,81,33,61,115,128,115,208,10,192,162,85,112,223,43,30,15,67,81,72,54,39,206,64,221,220,250,82,110,57,35,130,216,202,231,185,170,35,123,22,46,78,121,235,235,66,64,89,243,200,143,116,43,187,182,105,178,73,44,136,55,63,94,163,56,197,67,111,49,136,176,234,135,168,245,171,127,103,134,97,152,156,19,220,103,154,187,8,162,209,185,126,49,129,239,87,236,39,75,116,96,236,121,60,109,21,11,218,178,247,253,41,22,35,223,63,149,13,177,23,164,185,73,126,233,35,234,43,58,242,70,50,133,82,126,94,152,245,169,252,146,57,44,71,225,82,71,111,25,93,206,27,216,147,192,247,165,109,110,49,145,222,169,1,39,56,110,155,177,197,71,116,128,46,236,156,3,144,65,168,39,135,203,144,130,15,183,52,176,185,199,150,223,112,250,246,167,110,162,35,221,207,202,7,215,20,255,0,184,155,156,159,97,154,20,5,57,99,210,160,149,204,141,147,211,176,167,107,129,118,213,255,0,209,242,72,234,106,156,242,25,36,44,51,142,130,158,239,178,0,138,70,
79,38,160,167,24,235,112,53,55,121,150,104,164,3,177,71,229,138,165,34,21,57,82,113,90,65,2,244,192,30,149,90,72,246,190,59,118,164,5,35,207,223,90,73,1,101,11,31,220,29,187,213,192,128,142,130,144,192,152,206,245,31,141,62,96,51,169,71,214,173,73,7,153,247,6,227,235,140,83,215,79,59,126,103,57,244,2,175,157,88,10,209,166,121,199,21,106,222,60,146,113,210,156,44,230,232,20,113,219,53,161,107,108,22,205,150,64,162,66,220,115,210,179,114,184,210,42,44,158,92,114,115,207,111,173,32,100,28,49,198,20,115,68,241,168,125,190,106,159,247,65,168,228,242,114,73,14,199,62,184,21,40,8,157,222,70,220,73,246,171,27,178,2,186,179,183,77,202,50,71,248,209,29,200,81,182,56,34,200,238,195,113,253,105,100,187,191,96,4,110,202,15,93,160,45,13,92,99,30,206,100,249,149,119,143,97,207,229,85,130,188,77,252,74,223,149,73,24,159,206,249,139,110,61,201,171,241,198,204,187,101,118,97,232,77,59,180,34,43,91,150,144,21,147,4,143,226,169,183,14,213,32,182,136,116,65,82,172,41,215,109,43,129,12,80,238,249,
219,167,97,86,36,25,133,190,149,42,198,190,180,72,169,180,140,156,125,42,174,51,63,203,18,166,214,25,254,149,81,160,104,217,148,143,198,175,169,129,15,14,231,240,169,209,86,95,233,66,17,136,220,117,28,30,181,27,38,57,7,32,247,173,107,155,32,114,84,98,179,217,94,6,60,112,120,35,20,208,21,200,166,212,185,10,249,192,97,232,106,244,73,109,50,103,96,4,117,4,83,184,139,43,111,199,223,63,149,72,182,160,168,227,62,245,96,160,85,13,199,189,32,108,156,10,201,92,100,95,97,76,115,142,106,183,216,118,62,236,168,31,90,190,72,3,154,207,186,226,98,123,26,176,100,173,2,231,32,134,62,198,149,23,156,14,181,20,18,123,212,240,13,206,126,134,161,234,0,137,153,0,171,59,74,131,180,253,69,64,143,229,194,210,240,118,169,52,144,95,199,114,55,12,43,142,160,250,83,178,176,204,235,134,87,185,44,1,192,235,145,80,67,19,202,126,81,245,53,126,101,142,73,139,129,215,173,57,84,241,180,99,240,169,230,182,194,34,75,117,143,182,79,169,169,130,231,174,105,91,32,128,105,222,195,189,75,96,61,112,176,244,29,122,226,131,
145,200,228,122,211,231,93,144,168,247,230,136,8,60,96,83,242,0,141,129,198,105,242,48,83,145,67,68,87,145,210,162,145,86,69,42,220,131,214,152,201,35,117,111,226,7,219,52,172,249,249,120,172,87,142,75,57,193,86,59,79,67,86,162,188,254,250,19,244,53,162,242,17,27,157,172,121,226,165,251,82,219,198,25,179,236,7,122,130,76,179,150,32,129,216,85,75,178,25,192,36,241,210,146,220,69,239,237,133,206,12,109,131,239,76,146,236,200,228,42,43,15,66,42,149,170,9,110,21,72,235,159,229,91,41,107,10,42,182,223,156,241,156,211,147,75,65,149,86,217,101,25,242,213,15,251,36,212,137,105,229,140,43,31,94,149,103,1,79,221,197,72,0,35,35,21,157,192,82,126,92,86,101,204,151,86,211,3,230,18,135,167,28,125,43,93,162,13,202,156,26,173,60,65,148,164,139,193,163,84,50,184,188,89,7,204,72,53,28,210,137,152,149,60,142,180,193,14,220,169,39,114,255,0,145,76,141,118,179,85,183,160,135,59,24,226,224,242,120,171,90,124,153,11,147,236,121,170,51,182,91,28,113,82,89,177,231,131,129,83,230,34,220,205,178,206,127,
117,34,169,68,18,37,94,79,78,106,197,203,143,33,134,113,146,59,85,38,125,237,156,209,186,176,203,145,221,67,254,208,247,197,89,129,196,145,239,10,64,247,172,171,116,50,75,179,212,214,191,10,2,168,192,28,10,153,36,128,70,0,156,211,161,92,190,105,184,205,75,16,164,183,24,183,71,40,191,90,142,60,131,145,82,92,127,171,252,106,37,109,136,205,199,3,52,222,224,92,18,41,92,100,3,233,154,70,136,56,227,131,235,88,83,18,84,200,27,57,56,200,53,37,166,165,60,109,177,152,56,236,27,252,107,75,104,43,151,174,32,220,165,28,117,232,125,234,27,113,135,229,64,61,248,167,13,98,7,249,102,137,151,220,115,78,6,25,190,120,36,86,246,207,63,149,36,172,50,181,230,4,172,73,233,89,110,219,142,226,127,10,191,168,182,73,80,112,79,95,165,82,145,131,42,224,243,223,138,184,136,146,195,254,63,35,31,95,229,91,147,174,193,24,172,27,25,68,87,145,200,122,12,255,0,42,220,158,85,151,99,41,227,21,53,23,80,36,85,18,47,61,105,10,109,56,32,254,116,144,54,211,237,87,0,24,245,168,90,140,199,182,213,89,78,217,148,48,63,196,
56,53,127,237,182,146,252,173,32,83,232,195,21,206,183,90,73,27,123,126,149,165,133,115,118,120,70,55,169,12,61,65,205,103,147,130,198,171,91,51,35,224,59,40,61,121,169,102,4,100,100,114,122,212,181,109,0,136,156,154,116,110,203,247,73,250,83,113,238,42,68,12,159,48,83,245,197,12,9,167,96,35,27,212,159,65,85,151,146,91,3,242,169,90,72,246,13,196,156,119,52,200,143,152,50,7,83,197,37,176,22,108,83,27,156,253,5,90,36,1,185,136,0,117,53,28,96,71,31,36,0,58,154,169,115,57,152,97,9,217,252,234,109,204,198,44,151,102,103,216,167,106,127,58,213,180,33,225,24,61,56,53,129,16,231,53,171,167,74,82,77,172,120,110,159,90,209,165,176,175,169,114,227,136,136,252,107,62,250,66,150,111,142,248,21,163,113,247,13,100,234,45,136,85,61,78,106,62,210,25,70,57,14,221,153,227,174,40,201,83,144,42,52,226,78,79,90,151,110,79,36,226,183,100,141,0,183,98,77,73,110,194,41,209,155,32,3,206,58,211,144,127,10,128,7,249,235,67,38,211,199,79,92,84,222,227,36,186,184,243,87,99,40,39,170,183,67,138,168,200,195,
168,53,110,24,140,135,166,118,243,131,222,156,240,238,249,147,35,219,52,45,0,161,238,5,92,179,187,199,202,217,226,162,117,101,251,203,249,138,140,175,57,82,1,244,63,227,77,218,74,204,70,234,76,190,81,113,131,138,168,111,46,20,255,0,172,35,62,213,83,204,145,45,216,12,140,226,129,43,52,106,172,185,219,220,138,133,27,12,181,45,152,35,42,41,144,233,236,78,79,62,213,162,122,32,199,81,253,106,81,44,49,226,22,112,174,70,229,161,92,10,50,90,0,184,80,21,190,149,95,149,30,84,234,113,217,177,210,174,220,76,4,225,88,123,102,145,241,77,1,155,44,79,22,14,67,41,232,194,157,28,164,246,230,172,59,172,99,110,1,231,32,122,85,118,136,164,220,3,142,180,154,16,201,66,191,39,191,90,154,204,172,112,185,110,221,253,170,172,160,164,159,40,37,91,183,189,77,34,254,232,70,167,191,60,247,161,173,44,49,46,167,50,5,94,66,231,129,80,171,21,239,197,44,138,93,128,64,73,6,158,109,164,28,145,77,89,32,21,118,227,114,145,207,106,137,174,36,138,114,85,143,7,165,56,2,14,42,172,135,46,79,189,84,86,162,58,101,184,91,155,
65,42,247,234,61,13,99,106,18,3,113,183,57,192,2,165,210,37,249,37,136,158,188,129,80,184,221,59,149,28,231,174,106,45,105,12,135,203,199,45,249,84,136,55,48,205,63,202,39,144,15,29,105,120,81,210,170,247,17,50,67,150,192,232,42,89,98,204,93,58,98,146,208,254,239,53,62,224,35,25,21,32,68,138,35,101,199,167,53,36,137,183,231,3,234,49,72,195,129,83,68,62,92,125,234,0,172,83,204,231,0,26,143,236,94,103,108,84,239,251,167,233,199,106,100,147,54,198,49,28,55,106,6,70,44,37,140,245,226,166,242,1,234,41,177,25,118,230,89,89,143,166,106,94,79,82,127,58,150,192,153,219,229,141,129,233,154,165,168,33,154,252,109,56,218,130,158,147,49,65,158,199,138,35,96,215,142,72,231,167,233,84,134,67,32,249,55,23,98,203,192,230,162,243,37,60,150,205,44,174,90,67,192,20,139,205,8,145,158,91,188,187,183,28,246,171,209,2,235,243,145,159,106,168,120,28,85,155,69,231,173,54,3,254,195,188,103,28,83,101,182,141,93,118,158,71,81,87,199,220,197,86,42,55,147,81,39,160,200,227,140,32,194,40,169,27,56,228,10,144,
40,226,154,224,18,43,48,42,205,106,27,230,83,138,206,158,223,203,108,103,154,219,0,30,42,165,196,42,236,73,206,71,122,210,50,104,12,235,103,104,46,21,142,113,208,253,41,183,74,82,230,64,9,235,235,82,184,218,196,117,166,48,4,242,51,90,167,173,197,113,45,114,215,8,55,28,103,158,123,85,185,87,230,227,161,233,80,219,32,12,196,117,197,93,142,53,124,3,74,79,80,25,4,171,16,42,221,234,67,48,124,5,6,137,32,85,124,117,21,97,34,69,35,10,7,20,152,17,182,66,14,123,243,82,68,88,114,167,240,166,144,62,97,218,136,88,239,219,218,144,13,145,132,163,110,14,126,149,18,46,195,243,3,138,177,42,5,147,142,244,56,30,88,56,235,64,200,247,0,50,122,14,77,16,75,189,50,112,57,170,243,177,219,142,196,211,33,98,1,0,212,88,71,255,217);

back_pitted:array[0..2660] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,27,18,20,23,20,17,27,23,22,23,30,28,27,32,40,66,43,40,37,37,40,81,58,61,48,66,96,85,101,100,95,85,93,91,106,120,153,129,106,113,144,115,91,93,133,181,134,144,158,163,171,173,171,103,128,188,201,186,166,199,153,168,171,164,255,219,0,67,1,28,30,30,40,35,40,78,43,43,78,164,110,93,110,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,255,192,0,17,8,0,96,0,96,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,
120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,
248,249,250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,153,181,155,120,74,219,233,241,180,188,224,176,21,74,206,217,30,234,105,47,88,151,12,75,22,29,5,88,72,159,77,157,33,181,182,73,37,35,115,49,25,2,139,107,105,111,117,73,222,235,229,203,109,216,189,56,226,128,33,181,156,220,68,254,82,16,133,185,200,235,77,189,140,75,113,106,183,44,118,146,70,16,116,171,183,223,100,211,237,4,81,200,197,203,140,34,156,18,51,76,154,246,87,183,17,193,107,137,192,249,11,114,70,104,2,173,172,101,239,37,149,1,127,155,106,247,192,28,85,207,33,163,183,123,167,183,82,224,128,187,143,92,211,34,181,185,178,178,83,17,9,59,156,182,211,146,106,179,219,222,93,77,139,201,221,199,4,32,60,15,202,128,23,82,51,172,246,203,41,70,149,193,33,73,225,71,99,252,233,208,105,246,246,203,27,221,48,142,70,127,148,245,205,93,54,86,179,202,175,12,139,189,19,105,220,252,154,156,216,64,174,146,59,229,212,30,1,200,20,1,157,169,69,100,28,201,11,198,236,64,83,158,185,162,223,77,187,154,68,100,154,85,65,219,118,0,167,220,71,111,100,162,
226,230,37,118,115,242,162,245,99,90,41,116,211,91,171,8,204,11,143,186,77,0,103,106,242,133,43,101,151,102,124,101,151,210,163,86,176,121,98,180,65,51,249,71,37,251,10,179,36,214,79,112,129,230,93,227,251,167,60,85,105,94,43,185,166,142,205,67,70,118,174,65,198,125,104,2,87,77,70,57,227,75,87,216,15,36,109,7,31,157,93,185,146,226,210,202,109,161,76,251,75,22,3,189,81,176,213,110,238,174,217,96,135,48,231,27,177,205,88,212,102,16,217,202,239,147,145,142,188,156,208,6,85,172,17,243,127,168,202,237,140,99,29,73,236,5,104,197,60,87,242,121,112,131,111,188,229,183,142,72,172,235,52,115,104,55,195,242,168,220,55,86,157,140,150,171,31,152,242,41,145,184,85,199,74,0,101,196,118,86,237,60,81,220,150,187,116,194,100,158,14,61,105,182,90,101,197,172,96,41,253,236,131,147,156,212,90,125,164,183,26,172,243,102,38,80,248,231,146,5,91,212,53,36,176,145,64,86,102,114,112,20,227,138,0,161,34,157,50,225,96,137,76,147,159,153,216,247,21,161,105,117,246,128,115,25,66,189,123,138,107,222,90,194,
171,115,113,17,44,195,1,113,243,26,206,154,250,75,169,74,64,223,101,181,24,56,232,91,235,64,19,219,218,198,47,158,230,242,226,53,33,201,82,242,0,0,236,49,73,168,221,190,175,118,182,150,108,124,165,36,49,28,3,81,91,233,246,211,147,42,202,155,20,124,222,103,4,159,199,173,79,167,195,178,83,42,67,177,73,249,119,80,4,218,125,174,152,146,108,255,0,89,42,12,54,6,71,231,79,58,101,176,69,88,128,80,9,99,158,245,58,201,105,99,106,216,8,131,163,49,53,80,107,22,69,194,137,79,215,105,197,0,38,157,122,144,147,5,173,177,85,206,9,39,154,135,89,136,121,209,77,41,38,49,242,132,31,222,171,182,182,119,127,111,149,196,139,28,71,156,99,154,131,82,185,154,59,168,224,130,21,155,39,113,44,50,40,2,73,36,187,187,211,196,112,196,34,228,12,145,212,83,46,222,43,89,97,183,120,188,217,130,103,9,192,90,185,29,216,184,1,50,129,147,239,42,244,6,149,99,139,205,243,26,48,205,140,102,128,42,218,73,101,167,91,22,154,84,243,31,182,57,170,114,94,75,115,122,166,222,8,158,56,249,14,224,156,212,210,89,27,171,233,154,100,
141,32,29,25,143,65,77,73,22,107,136,163,211,103,43,20,99,44,64,198,79,227,64,6,165,44,178,75,10,136,7,152,123,129,194,212,214,250,75,202,168,242,176,8,163,4,176,197,36,247,155,153,226,137,90,73,87,229,50,96,112,105,53,19,20,86,31,191,185,151,14,195,106,147,146,125,104,2,91,219,27,105,68,72,178,172,86,241,157,206,229,135,39,235,82,25,160,185,77,150,183,2,77,131,104,111,74,200,155,204,190,88,237,173,160,145,32,28,150,110,173,87,173,164,181,181,152,218,197,19,60,195,134,101,28,45,0,50,238,29,61,194,89,53,195,52,187,195,49,29,5,91,93,46,212,55,14,187,2,243,199,53,66,226,8,33,191,243,217,137,18,158,21,71,122,155,237,243,249,241,196,182,135,12,51,156,246,160,9,46,53,91,56,145,153,110,4,172,58,99,57,99,84,159,83,156,217,179,73,0,87,147,136,241,214,172,220,90,69,2,249,166,56,128,206,23,166,77,73,5,188,161,94,234,104,16,164,113,18,128,158,253,104,0,211,154,222,27,109,166,19,28,132,124,206,78,69,85,158,246,230,242,100,143,78,206,208,126,102,197,77,13,164,215,214,190,91,186,40,108,51,178,
140,113,233,78,180,242,45,109,230,54,119,41,44,170,8,68,95,90,0,67,111,109,53,242,197,121,112,12,170,152,100,29,42,187,67,5,197,239,217,33,183,41,111,11,242,221,216,211,109,101,54,82,97,173,214,107,167,249,153,153,186,26,120,154,238,91,73,101,186,136,197,18,28,159,44,96,158,113,138,0,183,230,233,214,115,152,190,103,114,114,21,122,26,138,230,227,79,186,212,35,142,117,125,232,115,128,56,30,212,195,121,20,54,235,60,22,108,27,162,151,237,239,86,44,172,146,24,229,191,145,68,142,192,184,7,171,55,255,0,174,128,27,173,95,71,13,155,65,109,32,137,198,48,7,222,34,170,168,63,98,9,27,148,18,16,25,187,156,245,230,163,178,179,185,186,185,107,153,225,220,242,28,144,71,2,173,1,52,254,108,112,198,71,148,196,6,110,156,122,80,5,89,118,195,45,186,68,28,170,100,158,245,96,65,112,215,38,238,121,252,164,60,35,22,218,21,125,41,246,240,194,136,211,94,206,85,63,188,127,144,2,172,221,219,216,222,249,25,111,221,167,221,255,0,106,128,33,185,210,196,151,72,100,152,125,154,4,201,220,120,30,181,86,234,242,77,
69,69,181,138,180,118,170,112,91,187,254,30,148,237,110,89,142,219,88,198,18,65,150,99,245,233,81,196,222,84,49,197,28,173,9,110,55,99,175,210,128,37,180,150,236,25,45,193,204,0,109,96,87,7,29,249,168,45,36,104,225,100,178,182,17,179,116,150,67,147,143,165,91,46,32,17,66,239,45,207,205,243,145,254,61,234,107,235,243,110,145,13,62,213,25,156,227,44,185,197,0,84,75,41,44,161,73,110,28,153,37,124,103,169,164,190,123,233,161,88,18,82,98,102,228,96,3,75,117,109,119,113,124,183,23,242,8,227,10,8,25,249,86,162,158,73,217,20,196,193,85,143,202,71,92,80,5,201,110,103,183,138,8,154,221,103,96,123,241,197,95,243,218,117,12,201,179,28,109,244,172,216,218,72,165,137,231,144,20,199,221,99,201,169,46,36,190,185,212,18,43,52,17,219,170,131,156,117,160,7,223,174,161,113,36,49,90,76,209,167,241,21,56,52,151,122,121,221,24,186,189,9,10,47,207,147,140,159,122,139,83,190,158,214,117,182,129,21,230,35,36,246,20,227,105,115,125,103,31,218,194,169,14,27,216,208,4,176,218,233,82,66,68,7,206,1,179,248,
213,8,172,87,81,187,50,51,199,144,112,35,15,247,64,173,113,4,22,176,51,179,166,64,254,30,128,85,29,6,24,36,105,26,20,66,3,31,153,186,208,5,217,34,73,64,18,46,64,57,170,154,140,169,4,209,121,113,227,35,106,140,103,30,245,76,53,254,163,118,4,91,224,141,113,192,173,13,69,190,203,106,202,210,33,152,47,5,189,104,1,182,54,241,201,20,158,99,231,156,231,190,115,86,230,150,214,209,20,134,88,212,31,188,221,205,80,211,110,140,118,229,37,42,196,140,177,11,210,155,169,89,139,183,134,79,49,118,46,126,82,113,156,208,5,171,181,139,81,136,7,147,120,251,195,7,173,81,99,13,189,202,9,85,131,109,249,99,140,114,7,173,61,109,109,108,103,73,46,164,43,33,31,44,73,201,197,62,121,45,75,25,83,105,185,101,194,238,63,206,128,31,117,125,109,4,177,132,181,146,226,93,187,128,111,151,21,94,202,222,230,234,73,174,231,185,104,11,114,66,182,208,162,173,88,91,121,50,27,139,128,23,35,46,238,122,154,169,173,95,91,201,108,150,112,50,174,247,27,202,243,199,191,227,252,168,2,221,165,132,111,125,36,209,78,178,167,25,125,
217,237,76,212,124,217,53,37,105,46,188,187,117,24,69,29,234,57,69,189,141,136,130,11,136,214,225,240,70,15,65,73,6,137,117,37,194,75,52,251,211,111,82,115,143,165,0,87,189,154,125,69,150,214,218,55,242,183,124,204,71,45,91,118,246,209,216,218,172,74,6,242,57,246,168,99,211,163,137,64,142,227,103,60,176,56,56,170,78,215,22,207,45,212,179,52,136,205,182,52,206,119,80,7,255,217);

back_vain:array[0..1219] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,27,18,20,23,20,17,27,23,22,23,30,28,27,32,40,66,43,40,37,37,40,81,58,61,48,66,96,85,101,100,95,85,93,91,106,120,153,129,106,113,144,115,91,93,133,181,134,144,158,163,171,173,171,103,128,188,201,186,166,199,153,168,171,164,255,219,0,67,1,28,30,30,40,35,40,78,43,43,78,164,110,93,110,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,164,255,192,0,17,8,0,96,0,96,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,
120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,
248,249,250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,163,9,225,169,55,115,73,9,249,26,153,159,152,208,98,74,199,138,98,158,13,57,187,83,84,112,104,2,57,15,6,157,17,249,71,210,146,81,193,167,64,50,163,233,64,250,15,29,233,92,124,162,151,28,212,142,191,32,160,87,35,183,31,185,63,90,86,31,48,167,68,49,8,250,210,55,90,9,25,41,249,69,59,63,185,31,74,142,95,187,78,110,35,95,165,3,25,15,220,52,192,127,121,138,150,33,133,52,196,92,204,104,24,243,156,129,237,70,48,135,235,82,109,204,128,123,82,48,194,159,173,2,185,4,163,229,52,235,81,148,31,74,124,203,242,26,91,49,152,232,27,122,15,81,243,26,123,15,148,83,87,253,97,30,212,249,56,81,65,61,70,47,250,177,245,166,185,230,148,125,202,141,250,254,20,2,35,144,229,69,57,207,200,62,148,215,31,40,167,48,249,5,5,18,32,249,105,176,12,200,223,90,150,49,199,225,75,108,191,51,159,122,9,108,69,95,244,156,123,82,78,62,83,245,169,145,127,124,79,181,54,85,200,252,105,9,50,41,215,247,102,146,196,102,51,82,220,12,70,104,177,24,134,152,239,160,160,98,67,68,221,
5,57,70,102,63,74,39,29,40,23,82,17,247,113,81,191,90,149,6,65,250,211,28,114,40,26,35,144,124,163,235,78,35,43,74,227,129,78,35,17,138,7,114,84,28,126,20,235,117,193,111,173,34,30,77,62,35,140,208,67,21,87,247,134,152,227,63,157,61,91,146,106,54,110,127,26,4,133,156,101,8,162,208,1,21,50,102,224,209,3,254,238,130,173,161,47,73,51,76,156,242,41,187,254,106,100,173,210,128,72,16,240,126,180,142,121,20,212,60,26,24,242,40,24,173,208,125,41,236,63,118,41,140,120,169,79,220,20,0,136,121,53,34,156,3,81,71,247,141,59,183,227,64,135,131,214,162,99,201,250,211,199,67,81,117,207,214,129,160,157,184,52,216,79,238,233,39,232,105,33,255,0,86,62,148,21,208,92,252,212,217,137,165,238,105,178,243,138,0,34,36,161,62,244,140,78,225,75,15,250,179,245,164,35,230,20,0,230,36,10,152,19,176,84,82,14,5,77,143,221,138,4,194,30,172,105,196,243,76,132,240,212,132,243,64,137,73,249,106,53,60,26,24,240,106,53,60,26,1,9,49,235,68,103,228,31,74,100,167,131,75,25,249,71,210,130,135,122,210,75,142,41,115,214,
146,78,130,128,22,220,126,232,253,105,8,249,197,22,249,242,143,214,156,126,248,160,66,200,62,81,82,143,245,98,162,147,238,10,144,31,221,138,4,127,255,217);

back_fuzz:array[0..5054] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,40,28,30,35,30,25,40,35,33,35,45,43,40,48,60,100,65,60,55,55,60,123,88,93,73,100,145,128,153,150,143,128,140,138,160,180,230,195,160,170,218,173,138,140,200,255,203,218,238,245,255,255,255,155,193,255,255,255,250,255,230,253,255,248,255,219,0,67,1,43,45,45,60,53,60,118,65,65,118,248,165,140,165,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,248,255,192,0,17,8,0,168,0,207,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,
116,117,118,119,120,121,122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,
244,245,246,247,248,249,250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,159,113,117,249,83,36,142,148,192,238,28,6,141,134,104,70,149,27,248,42,85,105,230,234,17,49,250,214,101,149,154,102,137,206,248,228,192,238,163,34,154,46,225,13,251,207,49,126,162,172,203,230,199,142,21,179,248,84,44,242,131,147,8,97,236,212,0,71,115,230,147,229,46,240,58,243,138,144,59,243,251,167,253,42,31,57,135,221,129,177,74,183,71,63,52,110,7,210,128,37,75,132,232,255,0,33,244,106,123,207,16,3,50,47,53,3,92,68,120,102,31,138,210,172,177,103,112,11,245,219,64,4,146,68,184,96,227,110,125,106,103,242,222,28,134,92,122,230,152,26,208,174,79,151,159,165,52,199,102,227,63,38,61,141,49,2,93,68,123,211,132,145,55,33,135,62,245,83,54,202,220,4,5,78,65,7,173,63,116,47,200,242,242,62,148,134,89,89,35,111,227,20,225,183,36,84,63,187,101,200,84,56,164,242,162,39,37,22,128,31,36,49,43,238,35,25,247,166,237,85,59,211,32,212,235,21,187,198,50,139,77,107,24,10,231,27,126,148,88,46,64,100,101,63,123,175,181,2,86,206,120,197,
76,150,80,133,33,135,62,230,160,146,210,101,147,17,40,100,247,52,88,46,44,151,56,108,4,114,125,169,18,228,146,85,81,131,30,204,49,81,136,46,153,255,0,213,0,126,180,246,51,163,149,40,153,160,9,188,217,207,30,82,253,119,80,198,93,188,196,63,58,137,38,153,127,129,127,58,95,58,112,115,184,55,177,20,0,255,0,222,42,252,234,63,3,77,19,162,19,230,124,163,177,52,23,124,101,200,35,233,210,160,146,88,219,31,48,52,92,44,91,23,182,236,126,241,250,226,151,237,17,183,220,203,255,0,186,57,21,12,51,197,204,99,230,29,169,234,241,140,149,192,245,160,5,104,120,6,39,218,125,206,69,10,110,208,99,247,78,63,17,65,134,80,127,119,40,219,254,208,163,109,194,255,0,28,109,255,0,1,166,4,114,93,204,3,35,66,164,251,53,71,230,206,59,33,162,100,155,126,252,3,254,237,70,124,239,249,228,212,1,58,25,100,76,237,92,122,103,145,81,188,232,173,182,78,24,117,226,155,19,202,146,103,99,128,120,228,84,175,115,19,156,62,115,208,228,82,0,19,196,71,222,90,127,218,70,220,4,103,227,248,70,105,187,45,164,231,106,147,82,36,182,
176,240,172,139,158,49,64,12,89,209,71,221,108,127,186,106,54,146,223,121,200,31,136,171,63,105,133,134,55,175,231,66,186,48,206,225,245,160,101,96,240,231,230,10,71,184,167,170,91,49,219,136,233,242,60,76,188,178,254,116,69,178,69,254,22,20,0,208,150,195,251,152,250,211,132,54,237,145,133,165,216,133,186,45,72,168,174,187,0,227,218,128,24,35,216,63,116,251,70,122,117,167,15,52,168,95,52,123,225,105,173,106,189,21,153,79,177,161,45,119,231,207,114,222,131,210,129,18,40,157,73,249,195,123,17,78,67,114,228,252,168,49,239,80,155,52,94,85,156,30,223,53,74,129,163,31,35,147,199,70,166,3,255,0,126,203,202,170,159,92,230,171,206,178,238,249,218,49,142,249,60,211,204,183,71,238,136,255,0,90,71,142,91,136,254,112,138,195,161,6,129,16,177,40,191,125,27,61,189,42,52,146,71,255,0,150,68,254,52,243,99,63,103,143,242,169,32,182,158,47,159,122,55,31,119,20,88,119,19,247,145,166,101,65,131,221,57,166,49,183,118,206,213,30,196,85,165,121,49,254,168,252,189,112,115,77,152,150,140,48,143,140,119,
235,72,8,23,203,66,89,2,140,119,2,165,12,142,185,1,78,122,243,85,188,237,191,54,214,31,240,19,82,219,205,27,157,132,2,115,145,129,64,14,11,47,79,63,143,247,5,77,228,73,142,101,31,247,205,85,95,56,182,3,253,119,47,74,181,137,87,111,33,200,252,40,2,39,119,136,237,104,154,69,254,240,165,89,153,198,68,15,255,0,124,212,205,44,129,127,212,231,232,212,197,157,255,0,231,147,175,235,76,5,87,119,200,72,155,241,226,134,44,191,242,205,189,248,205,61,175,113,214,9,143,209,106,63,183,198,24,137,18,69,24,254,36,162,194,26,207,18,242,84,3,254,237,52,220,66,59,255,0,227,180,173,115,14,62,246,71,210,163,243,227,57,195,82,24,239,54,6,251,133,79,225,77,243,173,143,63,187,169,19,99,14,25,69,47,150,171,38,90,48,212,12,139,205,183,32,227,203,205,61,99,141,211,56,21,52,112,192,73,38,37,252,69,35,218,140,230,57,29,62,157,41,216,87,35,88,98,39,30,82,254,34,157,246,120,10,156,32,31,78,41,141,109,50,156,253,164,227,253,218,88,97,144,110,12,236,196,244,61,40,1,143,100,152,200,105,20,255,0,189,78,142,38,140,
29,178,57,207,247,185,169,28,73,180,109,147,254,250,90,137,205,194,29,219,81,151,208,117,52,1,46,233,78,1,43,255,0,124,210,254,245,70,66,7,250,85,97,120,75,96,219,201,159,165,75,21,203,51,16,34,144,113,252,92,80,3,188,249,59,66,255,0,149,32,187,193,56,67,158,224,241,79,243,165,63,242,197,191,239,161,85,167,103,96,27,200,110,61,41,1,99,237,188,115,27,82,125,169,92,244,104,253,205,83,251,67,14,26,57,7,225,72,211,127,211,57,63,42,53,3,75,237,86,184,207,152,56,166,198,202,231,146,70,59,48,172,248,247,200,193,18,50,164,247,110,213,101,161,149,65,56,14,79,80,180,192,188,205,30,113,185,127,58,173,42,69,28,129,134,213,7,184,245,170,94,83,103,6,220,213,232,188,132,136,6,69,82,122,131,64,136,222,226,88,78,217,97,86,247,86,160,94,160,80,90,54,95,199,53,44,182,206,241,237,18,12,250,237,170,109,101,114,185,194,43,113,235,64,22,126,223,16,254,9,63,5,166,137,188,230,253,210,48,245,220,49,85,214,43,148,255,0,150,100,251,230,172,238,184,234,34,83,244,106,6,72,146,200,19,13,23,235,74,210,49,95,
245,77,249,138,135,205,156,117,183,35,234,194,156,146,191,59,162,43,248,208,2,25,89,122,195,39,233,78,73,15,252,242,111,90,26,116,79,188,24,127,192,77,53,110,35,45,242,191,90,64,72,241,70,231,44,129,191,10,65,20,95,119,110,41,133,99,199,92,123,102,161,120,131,157,222,115,168,244,221,76,7,188,113,3,180,146,49,219,117,70,18,16,113,188,143,248,29,57,18,46,238,36,247,99,147,83,68,176,244,216,135,240,164,3,163,142,55,79,144,146,191,90,144,180,191,194,202,71,161,20,223,43,229,253,211,109,95,65,76,62,114,231,107,228,227,163,45,48,36,119,144,31,224,228,84,27,101,50,112,51,255,0,2,169,17,167,49,252,201,30,105,12,211,171,46,109,212,227,208,208,4,77,49,80,67,35,131,219,43,74,178,79,140,152,215,254,250,167,205,52,143,202,69,131,223,113,166,43,207,159,245,67,254,250,164,3,139,205,142,34,252,218,155,230,202,20,254,231,245,165,243,101,94,176,191,225,205,57,101,200,63,187,113,255,0,1,160,6,178,74,232,15,149,255,0,143,116,168,152,84,175,150,3,230,100,5,189,41,166,221,6,55,52,114,47,228,104,29,
198,33,34,69,199,92,213,229,145,113,247,129,168,34,129,21,240,21,87,156,131,79,49,15,72,201,252,40,17,39,152,165,186,243,72,103,135,118,55,131,248,244,168,150,24,212,157,193,65,61,49,65,10,70,220,46,58,211,184,13,65,54,0,73,206,127,218,25,165,89,174,84,114,99,127,210,161,89,38,70,228,2,61,169,37,146,70,111,221,0,1,234,26,149,194,197,159,180,191,79,40,31,248,21,30,115,15,249,96,255,0,133,66,169,57,64,70,195,250,84,144,188,169,144,241,241,236,212,1,32,109,252,121,110,191,90,54,41,255,0,150,171,159,173,47,158,49,141,178,126,85,27,205,27,15,184,223,138,211,2,104,215,12,114,195,21,82,105,87,45,19,197,35,12,227,238,228,26,102,251,124,231,202,231,253,202,156,76,161,56,12,49,254,205,0,85,242,45,216,125,201,71,224,105,159,103,128,117,148,254,45,87,214,116,111,156,48,230,165,12,31,251,167,52,1,73,13,169,92,126,239,244,166,230,16,196,33,65,220,98,173,24,212,56,200,24,254,180,214,130,50,79,203,145,232,105,1,89,90,79,225,184,106,146,23,153,247,127,164,3,142,197,69,72,35,88,65,100,85,199,126,
42,28,32,147,120,92,30,180,14,197,145,230,128,62,235,126,148,201,36,149,78,60,191,161,13,64,153,136,218,132,41,252,233,140,46,24,141,204,128,122,142,180,8,119,153,38,220,152,191,35,76,55,88,31,234,164,252,169,66,206,14,4,139,248,173,49,190,213,158,124,175,214,128,36,251,90,145,247,95,63,238,211,150,229,122,252,195,240,168,80,78,122,136,255,0,58,158,9,140,74,86,96,0,237,142,104,1,237,58,58,227,229,52,27,72,36,140,96,46,105,173,246,119,57,30,89,252,5,52,199,10,252,228,113,223,29,189,233,128,137,20,104,74,140,123,243,71,146,128,100,32,161,173,224,151,12,7,226,166,162,251,60,113,156,57,108,30,159,53,32,36,42,184,233,214,144,160,28,174,71,252,10,154,201,31,105,74,123,102,153,229,74,91,2,124,142,220,80,49,210,196,251,254,89,8,90,4,47,142,37,231,221,105,74,79,218,84,63,85,165,62,114,15,186,36,207,247,58,138,0,114,25,97,201,96,29,63,233,159,90,85,187,94,166,41,64,247,74,135,237,108,135,230,142,69,250,138,113,188,76,240,31,62,152,166,34,99,123,110,235,141,192,31,122,104,153,8,60,159,202,
171,153,85,155,238,48,255,0,128,212,176,190,58,171,109,63,236,154,64,59,207,136,127,203,64,42,196,114,172,137,144,69,63,247,109,195,109,53,86,72,34,119,63,187,63,240,19,76,69,130,170,195,230,140,31,168,167,164,81,50,227,203,95,202,170,45,170,43,99,50,127,223,70,165,48,109,254,246,63,222,52,1,43,218,196,202,112,54,31,81,218,171,253,137,193,255,0,143,151,63,133,75,18,168,63,121,191,239,170,123,108,95,249,106,255,0,74,96,67,228,75,140,25,207,253,241,81,189,145,221,242,202,255,0,165,88,242,136,79,190,231,219,53,27,6,219,133,149,193,29,233,12,172,214,205,159,245,191,166,13,47,217,228,11,255,0,31,18,125,48,41,205,111,43,229,150,102,24,235,199,90,4,19,237,207,159,207,161,90,64,1,101,219,143,48,126,34,144,139,156,255,0,3,81,137,148,227,42,79,229,79,70,151,31,113,127,239,170,6,34,67,115,156,148,140,126,52,231,116,85,249,210,69,255,0,128,213,145,44,99,146,224,123,26,95,50,55,31,121,79,227,78,196,220,162,101,181,255,0,99,119,210,151,124,73,207,150,87,234,152,167,74,241,7,42,235,200,255,
0,102,143,54,34,58,254,98,144,200,92,65,33,226,95,47,217,78,51,78,88,35,67,204,174,222,161,143,21,54,232,157,113,149,168,204,81,176,225,152,125,26,128,25,36,54,251,131,108,252,42,101,129,21,79,150,10,154,99,89,100,113,112,255,0,141,32,134,233,78,22,117,35,182,69,0,63,247,170,216,218,164,122,131,64,147,13,202,184,255,0,128,231,249,84,110,103,254,226,159,248,21,9,36,161,198,232,241,238,13,3,36,145,247,160,228,241,211,229,53,19,204,21,190,98,195,30,170,106,218,31,48,97,77,41,109,167,14,8,160,69,53,186,139,119,15,207,210,180,35,113,34,171,47,166,69,51,49,228,99,4,26,25,34,110,170,62,180,196,72,240,71,33,203,32,38,171,155,72,84,227,230,25,255,0,104,211,252,181,86,4,51,129,254,245,61,161,89,23,27,155,62,185,166,4,13,17,81,132,145,215,241,205,62,63,51,202,255,0,90,204,217,246,166,189,172,160,124,179,49,255,0,120,84,72,179,36,156,56,199,168,20,134,76,168,238,115,254,77,35,69,114,24,48,218,125,136,233,79,253,238,51,230,174,61,214,133,105,193,251,200,127,10,4,70,26,228,174,55,71,187,177,
230,149,162,148,70,55,182,31,191,28,84,187,50,57,219,154,137,165,149,23,97,64,223,141,3,32,75,137,99,202,18,132,3,233,72,215,79,159,245,108,113,220,82,78,197,159,114,219,156,227,4,3,80,238,96,216,218,192,250,98,144,18,181,234,157,187,149,135,252,6,167,91,200,246,255,0,31,78,187,106,174,252,112,198,158,140,59,26,6,44,183,54,147,12,57,31,145,166,109,182,216,51,27,15,112,15,53,55,152,171,247,135,228,41,62,209,14,56,113,69,196,49,39,183,65,180,57,252,65,169,5,204,7,248,255,0,48,105,22,120,155,141,235,249,212,153,66,58,138,0,102,45,221,185,216,213,47,217,45,248,59,113,233,201,166,121,49,55,84,95,202,144,164,128,97,37,42,163,182,40,2,87,132,129,148,114,160,118,197,48,249,185,5,100,227,220,83,210,57,176,51,48,63,240,26,71,138,85,226,44,50,159,83,200,166,3,200,79,81,64,68,35,165,42,219,195,183,62,88,164,54,225,87,108,44,83,245,162,193,113,26,21,39,35,131,237,78,88,1,92,18,114,59,228,212,27,46,195,224,202,128,118,59,105,195,206,35,108,152,35,251,202,112,104,2,83,16,4,6,231,29,57,164,120,
151,110,84,184,35,168,205,55,5,113,251,215,31,141,41,222,23,11,33,252,64,160,6,188,100,244,149,199,227,77,217,40,251,147,145,255,0,1,164,253,230,71,239,14,63,10,147,203,124,113,41,252,133,32,16,125,168,40,196,234,127,224,52,41,148,114,200,140,125,65,197,71,254,146,185,199,150,227,223,138,55,220,41,230,52,252,233,129,46,36,43,183,203,94,79,247,233,128,76,142,197,99,206,58,141,221,105,209,187,147,243,199,143,161,165,123,168,98,97,187,120,255,0,128,154,0,132,223,96,156,193,32,199,90,69,189,142,98,20,35,111,236,42,79,181,192,121,220,219,125,212,213,129,18,112,216,25,245,197,2,42,155,152,137,231,229,246,61,169,99,149,21,247,43,140,213,210,1,236,63,42,106,249,110,118,148,25,29,104,176,92,60,251,113,214,69,252,106,57,146,214,126,241,150,29,57,167,202,129,248,10,8,250,85,118,142,60,115,26,241,237,64,33,18,40,148,238,79,231,79,43,198,106,6,183,133,135,76,125,13,52,90,160,31,41,127,251,232,210,25,51,34,191,85,31,136,166,136,34,255,0,158,107,249,84,98,32,27,151,147,254,250,169,60,174,127,
214,73,255,0,125,80,48,251,60,93,134,62,134,145,160,227,137,100,31,240,42,112,86,207,250,198,253,41,15,153,206,28,31,168,160,65,19,188,99,4,249,153,245,237,79,243,156,56,95,40,228,140,228,28,138,131,206,69,56,110,13,40,157,50,14,225,144,40,1,232,179,30,178,249,103,182,222,69,42,139,129,38,12,224,174,63,187,77,217,48,28,72,167,216,140,81,182,224,114,4,103,30,244,1,43,9,136,219,185,48,123,133,230,144,164,216,255,0,90,63,239,138,110,251,141,163,228,143,243,52,162,73,177,204,107,255,0,125,80,2,44,35,146,88,179,159,226,244,164,103,184,67,180,42,31,122,12,174,132,238,137,185,254,239,52,211,114,55,115,27,143,170,208,3,246,205,179,118,35,207,166,105,232,100,69,249,147,63,238,154,100,55,11,35,99,230,31,133,91,72,213,198,115,159,165,48,42,53,203,40,207,145,46,15,181,58,222,79,62,77,165,25,56,254,33,87,118,46,205,184,226,162,242,193,25,78,180,236,43,145,50,58,184,21,34,110,198,31,167,189,53,162,102,201,222,195,254,5,80,58,74,152,253,251,237,61,169,12,185,140,118,168,140,59,190,236,178,47,
208,213,86,121,251,76,217,250,10,116,77,62,112,215,24,255,0,128,10,46,133,98,83,20,168,127,227,225,255,0,33,77,242,149,199,239,126,102,238,104,34,98,126,105,119,46,59,46,41,165,37,227,108,220,123,173,3,35,251,60,106,123,143,198,145,237,208,247,113,244,106,149,163,153,191,229,170,255,0,223,53,25,75,133,60,60,109,245,90,64,2,212,2,49,44,163,254,5,82,32,149,87,106,186,241,253,229,230,153,251,241,255,0,60,143,231,82,198,37,147,248,99,31,240,35,64,15,88,36,111,188,209,227,29,118,255,0,245,233,90,217,199,70,67,248,83,132,141,20,96,72,141,245,65,154,95,181,197,192,33,135,252,6,170,194,185,17,134,109,153,253,223,21,30,210,58,142,125,170,216,184,141,215,228,59,143,165,66,207,15,89,131,41,245,193,164,208,38,55,25,227,109,68,251,146,65,136,183,41,31,173,44,203,19,0,98,184,97,142,193,186,210,71,22,223,152,200,205,199,122,67,21,154,80,255,0,113,113,245,165,45,56,60,42,227,208,154,111,158,49,150,86,3,215,105,165,75,128,122,171,227,215,109,0,47,154,227,172,77,248,17,71,159,142,177,201,255,0,
124,210,45,196,95,222,253,41,226,104,207,27,197,0,48,221,196,62,241,43,245,20,199,154,41,23,229,113,83,171,41,25,86,4,83,93,84,158,220,208,50,171,54,41,203,41,94,81,202,159,106,87,182,143,127,11,193,164,251,42,118,46,15,214,128,47,91,185,147,36,72,230,167,49,231,248,136,39,184,172,248,99,242,250,74,252,212,230,55,24,197,211,254,52,211,36,112,73,89,136,103,57,3,251,162,131,12,165,112,100,82,191,238,211,132,78,24,55,154,205,143,110,180,227,62,63,229,156,159,247,205,48,40,60,119,9,207,148,8,255,0,126,155,190,81,200,139,255,0,30,21,118,75,168,83,135,56,250,138,96,17,191,220,57,250,84,216,119,34,251,102,21,127,118,251,186,48,11,79,121,211,111,250,169,20,250,109,167,168,28,231,173,70,239,177,177,181,136,245,20,0,208,243,119,64,87,216,243,74,100,245,141,233,124,229,238,24,125,86,147,206,65,220,227,233,64,12,251,66,14,187,135,213,106,68,152,43,127,23,30,212,211,52,93,119,138,158,41,148,174,84,134,199,161,160,9,76,188,101,81,136,166,11,134,126,22,25,9,247,226,172,35,110,76,208,120,230,
168,66,47,42,13,35,252,202,69,53,131,159,184,64,252,42,6,121,208,244,67,69,192,71,64,234,85,199,214,163,88,182,12,7,99,159,90,121,105,92,244,8,127,60,210,101,134,65,92,251,138,145,139,191,103,200,192,149,245,164,12,157,135,90,40,160,5,13,206,71,229,75,242,250,10,40,160,100,111,12,76,114,99,20,162,40,192,225,113,244,162,138,0,110,215,29,10,145,239,82,5,108,118,162,138,4,50,64,83,4,2,217,234,7,106,69,185,88,219,18,68,227,234,40,162,128,46,69,58,73,25,43,208,84,47,112,21,176,199,20,81,78,226,23,237,17,147,215,52,233,99,129,200,243,2,231,222,138,40,2,25,32,139,27,163,102,30,202,230,146,52,85,232,204,115,234,217,162,138,6,57,169,148,81,72,96,87,218,135,85,28,50,103,20,81,72,3,100,102,63,148,178,99,251,173,81,226,93,227,23,18,17,158,134,138,40,184,88,151,204,156,17,153,113,143,246,105,206,174,227,153,14,254,196,81,69,49,17,108,156,31,245,192,253,86,156,169,48,234,234,223,134,40,162,128,63,255,217);


back_clouds:array[0..21191] of byte=(
255,216,255,224,0,16,74,70,73,70,0,1,1,0,0,1,0,1,0,0,255,219,0,67,0,23,16,17,20,17,14,23,20,18,20,26,24,23,27,34,57,37,34,31,31,34,70,50,53,41,57,82,72,87,85,81,72,80,78,91,102,131,111,91,97,124,98,78,80,114,155,115,124,135,139,146,148,146,88,109,160,172,159,142,170,131,143,146,141,255,219,0,67,1,24,26,26,34,30,34,67,37,37,67,141,94,80,94,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,141,255,192,0,17,8,2,28,4,204,3,1,34,0,2,17,1,3,17,1,255,196,0,31,0,0,1,5,1,1,1,1,1,1,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,16,0,2,1,3,3,2,4,3,5,5,4,4,0,0,1,125,1,2,3,0,4,17,5,18,33,49,65,6,19,81,97,7,34,113,20,50,129,145,161,8,35,66,177,193,21,82,209,240,36,51,98,114,130,9,10,22,23,24,25,26,37,38,39,40,41,42,52,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,
122,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,225,226,227,228,229,230,231,232,233,234,241,242,243,244,245,246,247,248,249,250,255,196,0,31,1,0,3,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,11,255,196,0,181,17,0,2,1,2,4,4,3,4,7,5,4,4,0,1,2,119,0,1,2,3,17,4,5,33,49,6,18,65,81,7,97,113,19,34,50,129,8,20,66,145,161,177,193,9,35,51,82,240,21,98,114,209,10,22,36,52,225,37,241,23,24,25,26,38,39,40,41,42,53,54,55,56,57,58,67,68,69,70,71,72,73,74,83,84,85,86,87,88,89,90,99,100,101,102,103,104,105,106,115,116,117,118,119,120,121,122,130,131,132,133,134,135,136,137,138,146,147,148,149,150,151,152,153,154,162,163,164,165,166,167,168,169,170,178,179,180,181,182,183,184,185,186,194,195,196,197,198,199,200,201,202,210,211,212,213,214,215,216,217,218,226,227,228,229,230,231,232,233,234,242,243,244,245,246,247,248,249,
250,255,218,0,12,3,1,0,2,17,3,17,0,63,0,218,160,140,210,209,84,72,220,81,140,211,168,160,4,193,165,199,122,49,75,64,9,69,45,24,160,4,162,150,138,0,74,40,162,128,12,102,138,5,45,0,33,165,0,98,128,51,70,40,1,8,162,151,165,20,0,148,82,145,70,50,61,232,0,2,151,28,210,129,197,38,40,0,233,65,20,98,148,10,0,79,173,45,24,163,20,0,148,99,189,58,129,211,154,0,104,20,184,205,20,180,0,220,82,227,142,40,165,160,99,105,64,165,163,181,32,26,69,24,165,197,45,0,37,20,180,80,2,81,75,73,143,206,128,27,75,154,92,81,138,96,32,20,184,163,20,184,52,128,74,41,113,71,90,0,74,49,74,5,37,0,24,164,165,197,4,83,16,157,185,164,60,83,177,73,208,80,0,105,8,165,52,10,0,109,24,52,236,10,76,118,160,4,166,147,205,56,211,79,38,128,23,52,180,128,83,133,0,4,81,138,92,100,115,75,64,13,197,24,244,165,197,20,0,128,80,56,167,98,143,165,0,54,131,74,69,20,0,220,82,26,113,164,197,0,46,40,164,165,197,0,38,41,41,199,244,164,230,129,9,64,233,65,235,237,64,207,165,48,22,140,81,138,90,67,19,20,99,20,236,82,241,64,12,165,250,211,
177,70,13,0,70,199,20,155,169,228,82,109,197,0,34,156,142,148,162,148,45,46,41,12,76,102,138,118,41,8,160,8,200,38,141,188,96,212,152,163,20,1,30,218,77,166,165,192,206,104,199,181,0,71,182,148,10,126,40,197,0,52,10,49,78,197,46,63,58,0,102,218,54,211,192,162,128,24,5,46,41,216,164,160,4,232,104,197,46,40,197,0,54,129,78,199,20,98,128,19,20,98,151,20,118,160,4,164,205,59,28,81,138,0,109,40,165,197,45,0,55,20,99,20,234,49,64,13,197,33,25,167,210,99,210,128,35,42,73,160,10,146,148,15,106,0,140,45,24,201,169,49,237,65,228,116,160,8,194,81,180,83,200,163,20,1,30,202,54,138,146,140,80,3,54,210,237,200,167,227,52,99,154,0,102,59,80,23,156,211,241,70,40,1,180,117,167,96,81,143,74,0,111,52,109,226,156,58,209,244,160,4,233,69,45,24,160,4,52,152,165,199,52,184,205,0,32,167,117,20,152,163,20,0,210,163,52,155,78,106,78,212,157,232,1,180,134,156,122,83,14,105,128,211,69,45,40,90,4,55,20,155,78,51,82,96,118,163,20,1,17,6,146,166,219,158,180,133,69,0,71,140,211,113,82,133,246,163,110,59,80,
34,44,113,70,211,82,237,165,219,64,200,241,205,56,10,126,218,49,64,13,197,46,41,72,162,128,15,165,45,6,138,98,10,40,165,160,98,81,75,69,0,32,163,20,180,80,2,98,151,214,138,40,1,49,70,41,104,160,4,197,46,57,162,150,128,18,138,90,41,0,157,105,64,226,150,140,80,1,138,76,96,210,210,226,128,27,138,92,82,226,150,128,19,20,82,210,26,0,40,162,138,0,41,13,47,122,40,1,49,138,41,104,160,4,163,167,122,90,49,64,7,106,41,123,80,104,1,180,83,169,13,0,39,78,104,165,226,138,0,58,138,67,214,157,244,164,160,4,52,99,138,82,40,160,4,162,157,69,0,37,37,41,162,128,18,146,157,249,81,245,160,4,20,10,41,113,64,9,138,76,83,187,209,245,160,6,154,41,105,41,128,148,184,164,163,52,8,66,185,164,34,157,75,64,13,165,197,20,184,205,0,20,180,148,180,12,74,49,205,45,20,0,156,80,104,162,129,7,74,67,69,33,160,46,33,52,128,208,105,64,52,201,184,117,20,102,156,5,24,164,49,184,163,25,252,41,224,82,129,64,200,246,210,237,167,226,151,20,0,204,82,237,167,98,140,122,82,24,159,74,41,216,163,20,0,218,41,216,163,20,0,195,138,
92,83,177,69,0,55,20,162,151,20,80,3,104,167,81,64,13,197,24,167,81,64,9,138,49,75,75,252,232,24,220,81,138,90,92,113,64,134,98,150,151,20,180,12,105,164,197,56,209,64,13,197,24,226,157,138,49,197,0,54,140,100,82,247,162,128,18,138,92,115,70,40,16,148,98,150,140,115,64,9,218,140,102,151,233,69,0,38,40,197,58,138,0,111,67,69,59,20,99,154,6,54,140,83,177,70,40,1,184,165,199,20,180,98,128,18,142,220,82,209,64,13,199,20,1,78,163,28,208,3,113,75,75,64,247,160,4,163,222,150,138,0,76,81,218,151,20,80,2,98,147,20,234,78,244,0,152,230,140,83,168,197,0,38,40,197,45,24,160,4,197,24,167,117,162,128,27,69,46,5,47,20,0,220,81,138,118,40,197,0,48,210,17,79,199,181,33,20,8,143,28,209,138,117,24,230,128,19,28,81,75,138,94,244,0,157,168,218,51,78,199,52,1,197,0,55,111,52,98,157,138,49,64,13,219,197,46,41,216,245,163,20,0,204,115,73,138,121,164,160,6,98,140,122,211,187,210,80,2,81,69,20,196,47,122,41,40,160,5,162,147,181,20,0,180,81,69,0,20,119,162,150,129,133,20,148,80,2,209,73,69,0,47,74,51,69,
20,0,10,90,74,90,64,20,162,146,138,0,117,20,128,209,64,5,20,81,64,5,20,148,80,2,210,81,69,0,45,20,125,40,160,2,150,146,138,0,90,13,20,159,90,0,40,162,148,123,208,2,82,210,102,138,0,40,162,138,0,58,26,57,52,119,162,128,22,147,165,20,80,1,218,138,40,160,5,164,162,150,128,16,208,58,82,209,64,9,72,69,46,57,230,140,83,0,164,34,151,20,180,0,222,244,98,150,138,4,55,24,163,24,165,160,138,0,74,51,69,20,0,102,150,146,150,128,23,189,29,233,40,160,3,189,20,180,80,3,72,52,132,83,169,49,235,64,13,198,105,221,5,24,163,154,4,20,82,208,40,24,82,138,41,113,64,194,138,41,69,32,19,189,29,169,104,160,2,138,40,160,0,209,138,40,237,64,9,75,154,40,160,2,144,210,210,80,2,226,138,41,40,0,52,82,210,102,128,22,138,74,90,0,49,154,40,162,129,133,20,82,80,32,239,69,20,80,1,69,31,202,138,0,40,61,41,62,148,80,1,69,20,115,64,11,70,105,40,239,64,11,69,20,80,1,222,142,104,163,181,0,0,81,69,20,0,123,209,69,20,0,180,153,162,138,6,45,20,148,80,32,162,138,40,0,205,20,81,64,11,142,40,205,37,20,12,94,180,148,81,218,129,
7,122,40,162,128,10,51,69,29,232,24,180,10,63,149,25,160,5,164,254,84,81,64,5,2,150,146,128,22,146,150,146,128,16,210,17,78,164,160,66,82,115,75,73,64,11,210,129,235,69,20,0,82,208,41,104,1,49,71,122,40,226,128,10,41,40,237,64,5,33,165,164,52,0,148,148,180,148,192,67,73,69,20,8,94,244,81,73,64,11,252,168,162,138,0,90,74,41,104,0,162,146,150,128,10,40,163,181,3,10,40,165,239,64,5,20,148,180,0,81,208,81,75,64,0,162,138,41,0,180,80,40,160,4,162,138,40,0,163,60,209,69,0,20,81,69,0,20,81,69,0,46,104,52,148,80,2,209,69,20,0,81,69,20,0,81,69,20,0,157,105,104,20,80,1,69,39,106,40,1,104,237,69,20,0,80,122,81,75,64,5,20,81,64,5,29,168,160,80,1,71,106,40,160,3,181,20,1,69,0,20,134,150,131,64,9,218,140,98,150,138,0,78,180,157,41,104,166,33,180,184,165,197,46,5,1,97,180,10,82,40,197,0,24,163,20,162,138,67,19,20,98,148,209,64,9,70,41,212,157,40,1,40,197,45,20,192,40,162,142,212,128,40,233,69,20,0,82,210,82,230,128,14,148,116,162,138,0,74,13,20,180,0,82,81,69,0,20,96,209,69,0,20,102,138,40,
0,165,52,148,80,1,69,20,189,168,0,235,71,106,40,160,97,69,20,118,160,66,26,40,164,160,3,52,119,160,209,64,6,104,162,138,0,5,46,105,40,160,2,138,41,104,0,164,162,150,128,18,148,26,40,160,2,138,40,160,3,52,82,102,150,128,10,40,164,160,5,162,143,165,20,0,80,41,41,104,0,2,142,40,162,128,10,40,163,189,0,2,143,165,20,180,12,74,90,40,160,3,20,123,209,69,0,20,98,138,40,0,20,82,209,64,5,20,81,197,0,37,20,180,80,2,82,82,209,142,104,1,184,163,20,250,76,80,33,49,64,20,224,51,70,61,40,1,49,69,45,52,208,48,164,52,180,134,129,9,222,150,146,150,128,15,106,67,75,77,52,0,26,109,45,37,49,9,71,243,162,138,0,59,227,189,45,37,20,0,180,80,40,160,2,142,148,81,64,11,71,90,74,90,0,40,162,138,0,40,162,138,6,45,29,105,41,104,0,165,164,165,160,3,52,180,148,82,1,104,164,205,20,0,103,181,20,81,64,6,105,61,233,105,40,1,104,162,146,128,22,131,69,20,0,81,69,45,0,20,117,162,140,80,1,69,20,80,1,159,202,138,40,160,2,138,41,40,1,122,81,69,20,0,81,138,40,237,197,0,24,165,162,138,0,40,162,138,0,40,205,20,80,1,222,131,
73,71,90,0,90,74,13,20,0,26,41,51,74,49,76,5,205,39,90,40,160,5,206,58,210,26,41,122,244,164,2,82,209,64,160,2,138,90,40,1,13,20,180,148,0,82,210,81,64,11,154,74,41,13,0,45,20,218,80,105,128,189,104,164,205,25,160,5,162,154,104,205,2,29,70,105,185,52,102,128,29,69,52,26,117,3,12,81,74,40,164,2,81,129,75,69,0,37,20,81,64,5,20,81,64,5,20,81,64,11,73,69,20,0,82,230,147,235,69,0,45,25,164,162,128,15,106,74,94,212,148,0,82,119,165,164,62,212,0,180,157,105,104,52,0,81,69,20,0,81,197,20,80,1,211,138,62,180,81,64,11,73,69,20,0,180,116,162,146,128,22,146,138,40,0,162,138,40,0,162,150,138,0,74,40,162,128,22,142,180,148,80,2,210,210,82,208,48,163,20,82,208,2,80,5,20,26,0,41,105,41,104,0,205,37,20,180,0,81,69,20,0,81,70,121,162,128,10,40,164,160,5,30,212,81,218,138,0,40,239,75,73,64,6,113,73,159,74,41,40,1,115,73,239,69,20,8,76,243,73,214,150,131,210,128,18,143,173,45,37,0,45,33,162,144,208,2,82,115,65,164,166,33,105,41,104,160,4,165,162,138,0,40,162,138,0,95,74,74,40,160,2,148,117,164,165,
160,2,138,58,81,158,40,0,162,138,90,6,20,10,40,160,3,173,20,81,244,160,2,142,212,81,64,5,31,90,5,45,0,37,45,20,82,0,38,138,40,160,2,138,40,252,40,1,104,237,73,74,104,1,13,45,29,232,160,3,181,20,118,162,128,14,180,184,164,233,210,138,0,49,69,20,80,1,138,61,233,104,160,4,20,81,222,138,0,7,90,81,73,75,64,5,20,81,64,5,20,113,222,142,212,0,117,164,237,75,69,0,37,24,165,162,128,18,138,48,104,193,197,48,19,20,118,165,162,128,19,189,33,62,180,236,82,227,154,4,52,116,167,40,245,165,2,150,144,195,2,140,82,209,64,196,197,24,199,74,90,40,1,166,147,165,63,28,211,79,181,2,18,138,40,160,4,247,162,131,72,105,136,90,74,58,209,205,0,6,146,157,70,40,1,185,165,162,148,12,208,22,19,181,33,167,237,167,133,20,92,44,68,6,41,69,63,104,244,163,109,43,142,195,104,167,98,147,20,0,81,69,20,0,26,78,180,180,80,2,103,173,20,82,138,0,74,58,81,69,0,20,81,69,0,20,81,73,64,5,45,37,47,106,0,74,40,239,75,64,9,69,45,20,0,130,150,138,40,0,164,165,239,69,0,32,165,163,181,20,0,148,82,210,80,1,69,20,80,1,218,138,40,160,
2,138,40,160,3,20,180,81,64,5,20,81,64,5,20,81,64,9,75,69,20,0,180,116,20,153,165,160,97,69,20,80,1,71,90,40,160,2,138,59,209,64,5,25,162,146,128,29,73,69,20,0,188,210,82,102,138,0,90,40,163,52,0,119,165,205,39,106,74,0,118,105,58,81,73,64,5,20,153,163,52,8,90,41,59,210,230,128,19,189,45,20,80,2,80,105,104,160,4,20,211,205,63,181,52,208,3,77,37,56,211,77,49,5,20,98,140,80,1,69,20,180,0,148,82,209,64,9,69,45,20,0,148,82,209,138,0,40,165,162,129,137,75,138,41,104,1,40,165,162,144,9,69,46,105,41,128,10,59,82,210,126,52,0,82,209,69,32,10,41,104,160,4,162,150,140,80,1,138,40,165,199,231,64,9,69,45,37,0,20,99,154,90,40,1,5,47,122,41,104,1,40,199,173,46,41,49,64,7,106,41,113,69,0,37,20,98,150,128,18,138,40,160,2,131,75,73,64,10,40,162,138,0,74,74,117,38,40,0,162,150,143,194,128,18,151,241,162,150,128,19,20,184,160,81,64,196,34,147,20,255,0,173,33,160,67,113,138,95,122,40,160,2,150,147,30,244,234,6,20,10,41,104,0,165,164,237,69,32,2,51,73,138,81,75,64,17,149,164,197,73,72,105,136,143,
189,33,165,239,65,193,166,33,41,69,37,45,0,29,169,105,49,205,56,14,40,24,1,78,3,20,188,98,146,144,194,151,181,37,40,247,20,0,81,64,165,164,2,26,74,90,74,0,74,41,104,166,3,113,70,41,113,205,6,128,16,210,30,41,212,148,0,98,142,148,180,98,128,18,146,157,138,76,80,2,81,75,75,138,0,109,24,233,78,197,20,0,158,148,119,165,197,24,160,4,163,20,180,80,3,122,82,209,69,0,29,104,239,69,20,0,81,75,218,140,80,3,104,167,98,144,131,235,64,9,138,40,163,20,8,78,148,82,209,138,0,65,75,69,20,0,81,69,31,141,0,30,217,163,173,20,80,1,142,104,162,138,0,58,81,69,20,0,82,210,82,208,48,164,163,241,165,160,4,165,164,250,208,122,80,1,75,73,75,64,5,37,30,244,148,8,90,41,40,205,0,45,20,148,3,64,11,154,41,7,90,40,1,115,69,54,150,128,23,52,135,173,20,148,0,82,230,146,138,0,5,45,37,20,0,185,163,60,82,81,64,11,154,90,76,138,51,64,5,20,82,80,2,26,76,82,154,79,198,152,128,209,142,41,104,160,98,82,226,138,40,1,41,104,162,128,10,41,104,164,1,73,75,70,40,1,49,69,45,20,0,81,210,138,40,0,162,142,212,80,0,104,197,20,80,
1,69,29,168,160,2,148,31,90,5,20,0,81,138,41,104,1,58,82,245,165,162,128,19,181,20,234,76,80,2,98,142,148,190,212,80,2,81,75,75,138,0,74,90,40,160,97,138,49,75,69,0,38,41,8,165,162,128,19,28,81,138,117,20,0,223,231,69,46,40,160,4,162,131,197,20,8,81,205,37,45,24,56,226,129,137,73,74,122,81,64,130,148,83,105,69,0,58,138,74,51,138,6,45,7,165,39,74,9,160,0,154,76,209,72,104,16,102,151,173,37,45,0,40,207,106,41,5,40,52,12,90,41,59,210,208,1,75,69,45,32,1,64,228,82,82,253,40,0,164,162,138,0,110,220,210,17,138,125,4,100,83,17,15,126,41,115,74,234,106,50,27,56,197,49,15,205,56,123,83,85,9,235,79,198,41,49,161,104,205,54,140,208,49,217,162,155,75,64,11,64,164,20,80,2,246,162,140,226,138,0,5,45,37,45,32,14,244,132,82,154,13,0,54,140,82,209,76,3,181,29,233,51,69,0,46,115,73,222,131,69,0,7,173,3,189,20,80,1,158,105,105,40,160,5,20,126,52,10,13,32,12,81,70,41,113,64,13,163,20,180,83,1,40,163,189,20,0,82,230,146,138,0,40,235,75,69,0,38,41,63,10,117,4,80,3,104,165,34,129,64,13,165,197,46,41,
49,64,5,24,165,164,233,64,6,56,164,237,78,164,160,4,162,150,138,4,37,7,166,41,123,209,64,9,69,20,80,1,75,73,75,64,196,165,29,51,69,45,0,38,104,162,147,52,0,82,102,151,52,222,134,129,10,13,37,25,164,160,5,205,20,153,162,152,11,70,105,41,105,0,102,138,40,160,2,147,222,151,156,81,64,6,120,164,162,138,0,95,122,51,73,70,104,0,165,20,157,232,166,2,230,138,74,83,72,3,173,20,10,40,1,40,162,142,180,0,82,209,69,0,20,148,180,80,1,210,138,63,10,40,0,235,75,69,20,0,157,233,122,81,69,0,20,81,69,0,37,24,165,197,20,0,130,151,28,209,75,64,9,210,138,90,74,0,40,197,20,180,0,157,233,105,15,52,180,0,148,162,138,81,214,128,10,90,74,90,6,47,181,39,74,94,212,80,2,81,71,74,74,0,81,69,39,74,90,0,51,69,20,180,0,130,150,144,82,208,1,69,46,41,58,210,0,163,52,113,154,74,96,46,104,164,235,69,0,20,26,59,81,64,9,75,73,245,160,26,0,94,212,148,117,160,208,1,138,58,81,69,0,20,191,90,74,40,0,61,40,205,20,80,1,65,245,162,138,0,78,244,81,69,2,22,142,180,81,218,128,20,82,210,10,90,6,40,162,146,150,144,11,73,138,41,
104,1,40,165,164,160,2,156,105,56,163,181,2,19,28,211,72,167,154,67,64,198,210,19,75,73,76,3,52,148,125,104,160,65,138,90,74,90,6,47,122,50,105,59,81,64,11,154,90,74,90,0,5,45,37,20,128,90,40,38,147,173,0,37,20,26,74,96,45,20,148,80,2,230,144,241,75,73,64,5,45,20,80,1,74,41,41,69,0,40,163,20,10,41,0,81,75,73,64,5,20,81,64,5,37,45,20,0,98,147,20,189,168,160,4,2,138,90,59,80,1,73,75,222,138,0,76,102,140,82,208,104,1,180,119,165,52,80,2,81,154,90,41,128,148,98,138,40,0,164,2,150,148,10,0,74,74,119,122,74,0,76,81,75,73,64,0,233,71,106,41,123,208,1,138,13,20,134,128,27,70,105,105,8,160,66,102,138,82,41,48,104,1,40,237,75,73,197,48,18,151,241,164,165,160,3,233,69,37,25,160,5,162,138,40,0,162,138,74,0,90,59,81,73,237,64,11,69,37,20,0,190,244,82,82,208,1,218,129,69,37,0,45,45,54,150,128,10,49,75,69,32,18,138,90,74,0,90,90,65,69,0,20,180,148,180,0,148,180,119,162,128,10,40,165,239,64,9,69,45,20,0,81,71,214,138,0,40,160,209,64,5,37,45,20,0,81,69,20,0,10,40,162,128,10,90,74,40,1,113,74,
58,82,102,148,26,6,45,20,148,82,1,72,164,197,4,209,154,96,33,163,62,212,26,74,0,118,120,160,210,103,154,9,160,5,239,74,41,160,208,104,1,217,226,144,154,74,5,0,20,180,158,185,162,128,14,148,116,164,206,40,235,64,11,154,92,211,69,20,8,13,38,105,104,253,104,0,162,138,40,0,165,20,81,64,5,20,148,180,12,40,165,198,120,163,20,0,3,71,106,83,192,233,73,64,8,69,20,166,144,244,160,2,138,40,205,0,47,74,51,73,69,0,41,52,189,233,180,102,128,29,75,77,20,185,160,5,61,104,164,205,4,210,0,205,25,164,164,6,152,14,39,52,102,146,147,183,90,0,117,54,138,40,1,40,165,197,20,8,74,41,104,160,97,214,138,74,90,0,41,77,37,20,0,180,180,131,165,45,0,4,210,103,138,15,52,153,160,0,145,70,104,164,160,2,150,147,189,20,0,180,180,148,180,0,148,180,81,222,128,10,81,69,20,0,162,138,40,164,1,75,214,129,69,0,37,47,106,41,40,0,245,162,138,40,0,162,138,40,0,162,138,74,0,51,75,218,146,150,128,12,209,214,138,74,0,90,74,41,115,197,0,39,189,20,81,64,7,20,157,169,105,41,128,82,209,69,32,10,59,209,69,0,29,233,49,69,20,192,40,
162,138,0,90,74,41,13,0,24,165,198,41,40,160,0,138,105,165,237,73,64,132,164,197,46,49,197,24,160,4,162,138,74,96,20,81,73,64,133,165,237,214,146,138,0,51,69,20,80,48,162,138,40,16,82,118,165,162,128,14,244,81,154,40,0,162,151,181,37,3,10,90,74,40,1,69,20,82,210,1,40,162,138,0,90,41,51,75,64,5,45,37,20,0,180,81,218,140,208,1,69,20,80,1,75,73,75,64,5,20,81,64,5,20,81,64,5,20,81,218,128,10,40,162,128,10,40,232,40,250,208,1,71,106,40,160,2,150,146,150,128,10,40,163,138,6,47,90,76,81,69,0,29,169,41,104,239,64,132,20,180,148,80,1,75,222,146,138,0,41,105,62,180,80,48,165,237,72,56,162,129,5,20,81,64,5,37,47,74,40,1,40,20,189,40,160,0,81,69,45,0,20,148,184,205,6,129,133,29,168,52,180,0,162,150,154,41,126,148,128,83,73,75,73,64,8,77,33,52,26,74,98,10,40,239,69,0,45,39,122,41,113,64,196,165,20,82,80,3,168,163,52,80,0,77,37,6,146,128,22,138,74,90,0,41,71,2,147,138,51,64,5,20,81,64,5,20,148,180,0,81,69,29,232,1,40,239,75,69,0,25,162,146,138,0,117,25,164,205,33,160,7,83,77,46,104,20,0,148,
180,148,118,160,66,208,41,41,69,0,20,180,81,64,195,189,25,162,142,212,0,82,210,126,52,119,160,5,162,138,41,0,180,118,164,20,118,52,0,185,160,82,26,81,64,5,20,81,64,5,20,81,64,5,37,45,37,0,20,81,69,0,20,81,70,104,0,162,138,76,208,2,209,70,104,160,0,81,69,20,0,81,69,29,169,128,123,81,73,70,104,0,163,181,45,37,0,20,81,69,0,38,105,41,105,9,230,129,5,25,164,233,70,121,246,160,5,164,237,154,50,113,69,0,29,232,164,226,131,64,7,122,79,106,90,74,0,109,20,234,74,98,10,5,20,80,1,69,29,168,160,2,138,41,59,208,2,210,81,154,40,0,165,20,148,160,208,2,209,69,20,12,74,40,162,128,10,90,74,40,1,104,162,138,0,40,162,138,0,90,40,162,144,5,20,81,64,11,69,20,80,1,64,162,150,128,18,150,138,40,0,162,138,40,0,163,181,20,80,1,69,20,80,1,69,20,102,128,10,40,165,160,4,162,138,90,6,20,82,138,49,205,0,37,24,245,165,163,30,148,0,211,69,41,164,52,0,81,69,20,8,40,162,138,0,40,162,138,0,40,165,164,160,0,210,82,226,138,0,67,69,45,20,0,81,138,40,160,2,148,82,81,64,10,40,163,235,73,64,11,69,37,45,3,12,210,131,73,
64,160,7,100,82,102,147,235,73,64,11,158,105,40,162,129,9,74,41,113,233,75,64,13,165,165,164,160,97,69,6,129,197,0,40,233,69,37,6,128,18,138,90,74,4,37,45,20,80,1,75,72,40,160,98,209,138,40,160,4,252,40,162,138,0,41,115,73,70,104,0,165,164,165,160,0,210,81,69,0,46,41,40,162,129,5,31,74,74,40,1,104,162,138,0,41,69,37,46,104,0,165,164,165,160,97,69,20,80,1,69,20,80,1,154,40,162,128,22,129,210,138,74,0,41,105,40,160,7,10,41,1,165,207,20,128,51,73,75,214,146,128,10,58,209,248,209,64,5,20,102,138,0,40,20,81,64,5,6,138,78,105,128,180,148,102,138,0,40,163,181,20,0,81,73,69,0,45,37,25,226,142,212,0,189,168,164,164,233,64,5,25,230,138,40,16,103,154,74,40,160,2,146,138,40,1,105,40,205,33,160,5,164,162,138,96,29,232,164,165,160,2,146,138,40,16,98,138,90,79,122,6,37,25,165,52,157,40,16,102,147,52,102,129,154,0,41,115,239,73,72,40,16,250,40,20,126,52,12,83,210,146,138,40,24,81,75,69,0,37,20,180,98,128,14,212,81,69,0,20,81,69,0,20,81,69,0,20,180,157,168,164,2,247,162,138,51,64,11,69,37,20,
0,162,150,146,138,0,90,41,41,104,0,162,138,40,0,162,138,40,0,162,140,81,64,5,20,81,64,5,40,25,164,165,20,12,90,90,5,20,128,40,162,131,64,8,113,72,104,162,152,9,210,138,90,74,4,20,82,80,104,1,104,164,165,160,2,138,74,40,1,104,164,165,160,2,129,71,90,40,0,160,82,82,138,0,40,250,81,69,0,6,138,40,160,2,142,212,82,80,1,75,73,70,104,1,104,164,52,80,2,209,198,41,40,205,0,59,165,45,51,52,180,0,238,148,83,69,45,3,10,40,163,60,80,1,69,37,20,0,118,164,165,233,69,2,18,148,82,81,64,11,69,20,80,2,210,26,90,74,6,20,81,248,81,245,160,0,210,82,210,80,33,104,239,69,20,0,81,69,20,0,82,31,173,45,33,160,4,163,52,119,162,128,22,138,5,45,0,20,81,138,90,0,51,75,154,79,173,0,241,64,197,162,147,189,20,0,180,82,118,165,160,2,138,40,7,29,104,1,105,40,162,144,5,28,209,69,48,10,40,162,128,20,116,165,164,163,235,72,0,209,75,72,77,0,20,81,73,76,5,164,162,138,0,40,230,138,76,243,64,11,70,105,40,160,5,164,162,146,128,23,189,25,164,205,20,8,90,74,51,73,158,212,0,180,81,73,64,11,73,75,154,105,60,208,2,230,146,140,
210,19,64,1,162,147,52,83,16,102,150,146,140,208,1,223,138,51,73,154,59,80,2,230,147,52,153,163,52,0,180,82,102,138,0,90,83,77,20,180,0,148,82,119,165,160,4,239,71,110,40,162,129,11,75,138,65,65,52,12,92,210,211,115,64,60,208,3,168,164,205,45,0,6,138,51,69,0,45,20,82,254,52,134,37,20,82,83,16,180,81,69,3,10,74,40,239,64,11,69,20,80,1,218,129,69,29,169,0,180,82,82,208,1,75,154,65,69,0,47,210,138,59,209,210,128,10,81,73,69,0,45,20,82,226,128,10,49,205,2,150,129,137,73,78,235,73,138,0,74,90,40,197,0,45,25,164,233,69,0,46,105,164,208,105,40,16,185,52,82,3,131,75,64,5,24,163,20,80,1,73,78,20,134,128,18,138,90,74,0,40,162,143,210,128,12,226,143,173,20,80,1,69,31,74,40,0,162,151,235,72,125,168,0,162,138,40,0,165,164,162,128,10,40,235,73,64,11,239,73,214,151,173,37,0,20,81,73,154,0,90,41,51,69,0,46,105,65,166,208,13,0,59,52,180,208,105,115,138,0,92,209,154,74,40,0,205,45,37,25,160,2,131,69,25,160,2,138,74,90,0,90,41,40,160,5,205,20,153,162,128,23,52,81,69,0,37,20,81,64,5,45,2,146,128,
10,90,40,160,5,164,197,20,126,52,12,49,77,206,41,212,98,129,13,167,117,164,165,160,5,163,214,146,150,129,129,163,210,131,71,74,0,41,40,162,128,10,94,180,148,80,2,209,73,154,90,0,90,40,162,128,3,69,20,80,0,40,197,29,168,237,64,11,75,73,154,41,0,180,134,142,253,104,197,0,37,20,81,154,96,37,20,81,64,5,20,81,64,6,104,247,162,138,0,78,212,81,73,64,130,138,41,61,232,1,123,81,69,38,104,1,79,235,73,154,41,9,160,5,38,144,154,66,105,9,166,33,115,197,38,105,9,164,160,7,102,140,211,115,70,104,16,185,162,147,52,132,208,3,179,197,38,105,40,205,0,46,127,58,74,76,208,13,48,28,105,69,32,167,82,0,197,4,209,156,82,103,138,6,30,244,132,243,72,78,40,28,208,33,115,73,75,138,109,0,59,52,153,230,154,79,20,3,76,67,179,70,123,211,115,205,45,3,28,13,46,105,153,160,28,82,11,146,102,140,230,152,13,56,26,6,58,150,144,82,208,2,81,154,40,250,208,1,69,25,162,128,10,40,162,129,139,69,37,45,0,20,81,69,0,28,209,69,20,128,90,40,162,128,10,90,74,90,0,40,162,150,128,10,81,73,210,138,0,117,20,153,230,138,6,47,210,138,
41,51,64,10,105,40,237,70,104,0,235,69,45,4,112,104,1,180,153,165,164,197,2,12,81,69,20,0,103,20,10,41,127,10,0,41,104,2,138,6,33,164,34,148,154,74,4,39,74,41,105,15,210,128,1,75,210,146,150,128,10,40,165,239,64,5,39,122,90,74,0,40,162,138,0,40,160,115,73,64,11,205,37,20,99,154,0,40,162,146,128,23,235,73,138,90,76,208,2,82,209,158,104,237,197,48,10,74,40,160,5,2,150,146,138,64,45,20,81,64,7,90,41,51,64,226,128,22,142,148,148,98,128,22,129,73,75,64,11,69,39,189,45,0,20,81,69,0,20,81,69,0,20,80,40,160,5,162,146,150,128,10,40,163,60,80,0,40,162,138,6,20,81,73,64,11,69,37,20,8,90,40,235,69,3,20,210,81,154,61,104,0,162,138,40,0,163,233,69,20,8,41,123,210,80,104,24,238,104,164,205,25,160,5,164,165,163,61,168,0,162,138,40,0,163,52,82,99,154,0,94,180,180,218,90,0,9,164,163,52,148,0,102,150,147,181,40,160,0,81,70,104,52,0,82,82,154,67,64,5,33,163,52,132,138,4,45,20,153,163,60,80,1,154,76,208,105,164,211,16,185,164,205,38,105,185,160,46,59,52,153,164,205,39,122,98,22,138,78,244,102,129,
11,154,76,209,71,122,0,51,205,25,164,163,189,0,46,104,252,105,40,160,0,125,105,64,164,6,151,190,40,1,220,98,151,117,55,56,164,205,33,143,199,122,105,56,165,7,2,154,78,123,80,0,78,105,65,226,153,64,52,196,73,156,83,79,74,51,70,105,12,109,32,250,211,136,166,246,166,32,232,105,114,105,41,123,80,1,154,94,180,148,99,154,0,112,167,1,77,20,241,72,98,138,90,5,20,12,92,82,17,79,197,33,160,99,41,69,46,51,73,138,4,20,180,148,80,1,71,106,5,29,232,0,250,210,210,82,208,48,165,164,233,71,106,64,20,180,148,118,160,5,162,138,51,64,11,64,162,138,0,41,104,20,80,1,154,92,210,10,90,6,25,164,52,189,105,40,0,165,162,138,0,90,13,20,80,2,81,75,138,59,80,3,123,209,218,148,250,210,26,0,41,104,233,69,0,40,164,162,130,104,1,40,164,165,20,8,40,197,20,238,180,12,102,40,197,41,226,146,129,11,69,20,80,1,65,163,165,20,0,148,82,210,80,1,69,46,41,49,64,5,37,46,41,15,106,0,41,41,113,205,33,20,0,180,130,148,15,90,92,80,3,113,70,41,248,164,197,0,54,146,158,70,105,49,64,9,73,78,197,52,208,2,131,64,164,20,164,211,0,
162,146,151,20,0,31,90,5,20,148,0,82,210,81,210,128,29,75,77,165,205,32,22,138,76,209,64,11,69,37,29,232,1,104,164,6,140,208,2,209,77,60,209,154,0,119,106,41,58,209,197,0,45,20,153,163,60,80,2,209,73,154,1,160,5,165,237,77,205,45,0,20,180,148,117,160,5,162,146,140,243,64,5,31,74,63,10,74,0,90,51,73,75,64,5,45,37,20,0,185,165,164,163,61,168,24,185,205,20,81,64,5,20,102,140,208,2,209,73,212,209,64,5,6,142,244,157,168,0,162,138,40,16,82,138,74,40,1,104,162,144,241,64,195,38,155,147,70,113,69,2,10,74,74,90,96,25,164,207,20,134,138,4,25,166,147,70,105,164,208,33,115,77,205,20,220,211,16,236,243,70,105,185,163,181,2,29,73,154,74,94,212,12,90,59,82,103,138,74,0,90,40,239,71,108,208,1,244,162,146,138,0,118,120,163,52,218,119,106,0,51,73,248,209,222,148,10,0,76,241,71,210,151,20,163,210,128,25,69,41,160,10,0,92,82,138,58,10,66,104,0,38,147,30,148,26,40,0,163,240,162,138,0,61,40,164,163,52,0,245,250,83,197,70,13,60,116,164,52,60,82,227,52,130,157,65,64,13,47,90,74,81,72,6,247,163,20,226,
41,167,138,0,41,41,104,52,192,74,40,162,129,7,122,59,209,72,104,1,115,70,105,185,197,25,160,7,81,77,205,40,230,128,29,75,73,69,33,139,64,164,165,20,0,189,169,105,5,45,0,20,80,104,160,0,82,210,81,154,6,45,2,147,52,162,128,10,90,74,40,1,104,162,129,64,5,33,230,157,138,76,80,2,14,148,184,165,162,128,26,113,73,78,52,222,40,0,160,244,165,52,80,1,69,46,41,58,208,2,245,20,211,237,78,52,218,0,57,162,138,59,80,1,69,46,105,51,64,5,20,81,222,129,5,47,74,5,20,12,74,76,83,179,73,64,132,162,150,146,128,10,90,41,69,0,37,45,37,20,12,90,67,75,244,164,160,4,52,222,134,156,105,166,129,8,122,209,75,138,67,76,65,75,154,74,90,6,37,20,189,169,15,52,8,74,51,73,237,75,64,6,105,105,180,160,208,2,230,140,210,102,144,154,0,118,104,166,230,148,80,2,230,140,211,115,69,0,59,52,102,155,73,154,0,118,105,115,77,205,20,0,236,209,154,110,69,20,0,236,209,154,109,40,52,0,236,209,154,111,90,90,6,46,105,115,77,162,144,14,205,20,148,117,160,5,164,20,82,247,160,2,150,138,78,148,0,180,82,81,222,128,22,150,146,138,0,90,
40,20,80,48,163,189,20,80,2,209,73,71,74,0,41,123,82,81,64,5,37,45,37,2,22,146,142,244,80,2,230,144,158,180,26,74,0,9,166,154,83,214,144,154,96,38,121,165,28,210,82,138,4,24,165,35,138,13,27,169,12,110,5,68,70,13,74,125,233,164,102,153,44,135,52,83,218,54,2,163,53,68,139,70,120,164,163,52,0,185,226,140,210,116,162,128,20,82,211,115,138,94,123,208,2,209,73,69,0,56,82,113,154,1,197,25,164,49,104,205,39,122,51,205,0,58,129,73,158,40,160,9,0,226,155,180,211,199,65,74,105,12,140,169,165,237,79,198,69,1,123,154,2,196,125,232,219,154,148,45,40,74,7,98,47,46,154,84,140,241,86,49,72,71,181,23,11,21,168,6,165,41,147,81,176,42,105,147,97,57,52,82,131,158,41,8,231,20,0,162,158,41,161,106,69,90,6,135,10,90,5,46,106,74,10,90,74,90,0,90,49,145,64,165,20,0,221,180,220,83,251,209,64,12,197,6,157,72,86,128,18,144,210,145,72,105,136,105,20,134,156,70,69,55,218,129,9,154,112,52,218,40,1,224,210,230,163,20,236,208,59,142,205,25,166,19,131,75,154,0,144,26,90,140,26,120,60,82,24,180,80,58,81,64,5,20,
81,64,11,71,106,110,121,165,205,0,58,138,78,244,119,160,98,210,230,155,154,81,211,20,0,180,180,218,92,210,1,77,33,162,138,0,66,105,40,162,152,11,69,37,45,0,25,160,154,74,8,160,3,52,82,81,218,129,11,69,37,45,3,3,73,75,73,64,130,148,82,81,154,0,90,41,41,104,1,105,41,1,162,128,22,138,78,212,80,1,222,150,147,173,20,0,180,116,164,162,128,22,138,62,148,80,49,13,37,45,54,129,5,37,20,26,0,41,105,40,38,128,22,138,74,41,128,98,138,40,160,4,52,82,154,5,2,19,20,148,234,67,64,9,211,173,28,209,69,0,33,235,70,104,197,39,122,4,47,106,51,64,6,140,80,2,102,151,57,163,110,41,189,40,1,212,180,220,211,168,24,81,205,33,60,83,133,0,20,180,153,165,160,3,235,75,199,90,41,69,33,137,138,90,41,104,1,180,189,168,164,110,40,0,205,29,169,1,165,197,0,25,165,205,38,40,160,5,7,138,90,74,40,1,104,160,81,64,5,20,81,218,128,10,40,160,208,1,69,37,20,0,180,148,123,82,102,128,29,73,154,41,51,64,11,73,73,70,104,0,63,173,32,160,210,26,98,2,121,165,13,77,39,142,148,3,64,135,230,144,209,69,3,0,63,42,118,5,55,161,165,160,
3,142,245,3,41,21,49,52,195,239,66,19,33,197,39,122,123,15,74,143,189,81,34,230,138,78,244,80,33,65,165,205,52,26,90,0,92,209,154,76,209,64,11,70,105,164,243,70,104,24,236,209,73,71,122,0,117,40,166,117,230,156,13,0,74,15,20,103,173,51,56,164,206,105,14,228,160,211,197,66,26,156,27,154,67,76,152,83,170,53,52,241,72,161,104,197,20,80,49,164,83,24,102,164,205,33,20,8,128,174,13,53,170,114,185,168,217,41,220,155,13,64,115,237,83,14,149,24,76,84,139,210,134,52,58,138,40,164,48,165,205,55,181,45,0,46,105,115,77,163,233,64,14,162,154,13,58,128,10,40,205,20,0,132,115,77,167,26,76,80,2,96,82,50,210,208,40,2,50,49,77,53,41,92,211,88,83,38,195,41,65,164,162,152,135,17,72,56,162,130,121,164,49,65,230,156,41,128,243,78,20,0,250,90,110,120,163,52,138,22,150,144,26,40,0,165,205,54,150,128,23,52,180,193,78,6,128,29,71,106,64,120,160,123,80,3,191,149,39,227,73,154,40,1,212,157,232,165,160,98,81,69,38,104,16,180,180,218,90,0,41,40,205,28,80,2,210,81,69,0,20,102,138,79,231,64,6,105,122,244,166,
154,112,160,3,173,20,81,64,7,214,138,40,160,2,138,41,104,1,40,165,52,134,128,10,13,33,163,60,208,2,247,230,138,78,180,189,168,0,165,166,230,151,233,64,5,33,165,52,148,0,148,148,180,211,76,65,70,105,40,38,128,23,52,102,146,146,128,29,156,209,154,65,69,0,45,3,154,7,20,116,160,5,254,116,81,65,160,4,162,138,40,1,49,197,40,20,82,158,180,0,152,230,150,142,148,148,0,135,20,148,239,106,76,80,3,104,230,157,138,48,40,16,220,211,133,4,82,227,20,12,65,75,218,140,224,82,100,80,3,129,167,10,101,45,33,142,38,147,62,244,134,155,186,128,31,154,56,52,220,230,150,128,20,80,5,2,148,116,160,2,140,82,245,52,80,2,81,69,20,0,180,113,248,209,154,74,0,41,105,180,122,208,3,168,166,230,140,208,2,230,138,51,73,154,0,90,41,51,71,74,0,41,13,20,135,142,41,128,119,162,147,189,20,8,41,13,20,211,214,129,5,20,148,125,41,136,120,60,82,230,153,154,55,82,29,199,103,154,112,233,81,110,244,167,135,160,19,28,105,166,151,60,83,24,208,49,13,68,220,26,113,126,212,194,114,106,145,12,76,138,59,210,82,102,152,135,82,211,115,
70,113,64,14,250,210,115,73,154,51,205,32,23,52,82,82,230,152,11,69,39,106,41,0,180,160,243,72,57,226,142,212,0,185,165,205,37,29,232,24,234,80,73,52,208,120,197,42,241,131,64,19,173,60,84,64,224,83,131,10,146,209,45,20,208,105,73,164,48,205,6,154,91,20,210,244,0,254,41,41,55,82,22,166,33,220,81,77,221,75,154,0,117,20,128,210,210,24,102,150,147,52,80,2,209,73,159,210,138,0,81,74,41,188,210,131,64,14,163,181,38,104,221,197,0,45,37,25,162,128,10,49,71,74,40,1,59,83,72,167,154,105,20,1,30,14,105,13,72,71,20,198,20,201,27,71,90,8,163,20,196,2,156,13,48,208,40,2,64,105,115,76,206,5,0,210,29,199,230,138,74,80,40,24,3,75,73,69,0,46,104,205,52,154,55,10,0,125,20,221,212,185,164,49,217,165,166,211,187,80,2,209,197,37,20,0,19,69,20,80,1,69,20,80,1,69,20,148,0,180,10,74,90,0,41,62,180,180,26,0,110,57,165,20,81,64,11,69,20,3,64,5,20,81,64,5,45,54,151,181,0,45,37,20,148,0,30,180,159,206,130,125,41,59,208,2,230,142,212,159,90,15,181,0,40,250,80,13,38,104,52,0,185,160,154,110,234,9,166,33,105,
166,141,222,148,221,212,0,185,162,155,154,76,208,33,226,138,65,205,47,65,64,10,40,166,131,75,154,0,95,165,46,105,51,73,154,6,46,104,164,164,205,0,58,151,233,77,163,173,0,59,52,83,104,206,104,1,212,102,146,131,239,64,11,69,55,52,19,64,11,70,105,51,205,38,104,16,236,209,77,206,40,250,80,2,154,74,90,49,64,0,165,221,73,72,121,160,5,221,154,74,78,244,191,74,0,92,226,140,210,118,164,160,7,230,156,13,67,154,112,108,80,23,36,201,165,207,189,71,186,141,212,14,227,243,70,105,153,163,57,160,46,63,52,3,76,38,151,52,5,199,103,154,90,109,25,160,7,102,138,76,209,154,67,22,146,131,72,77,49,11,73,158,105,13,25,160,5,207,20,148,148,102,128,3,70,113,73,154,76,243,138,4,45,52,211,179,235,73,214,128,27,158,212,102,151,20,98,152,134,147,197,38,105,91,138,143,60,211,16,226,105,119,113,138,102,115,205,39,214,128,185,48,126,58,210,22,168,119,99,165,38,250,44,23,30,105,164,211,119,251,80,91,190,41,136,51,70,105,185,164,239,64,135,231,181,25,166,231,214,147,52,0,252,209,77,205,46,121,160,7,102,140,211,
104,6,129,143,205,20,218,90,0,81,75,154,109,25,237,64,15,163,233,77,207,20,160,210,1,195,52,185,166,210,230,129,142,221,138,112,106,143,60,210,231,181,1,114,93,254,244,187,253,234,28,210,19,233,74,195,185,33,122,97,144,231,138,97,38,155,154,118,21,201,195,250,210,110,201,234,42,44,210,131,197,22,11,147,6,167,131,80,3,129,79,13,72,105,147,131,78,168,148,212,148,138,16,26,90,104,233,75,218,128,22,138,74,90,0,40,162,138,0,51,197,20,134,140,208,2,230,148,53,51,52,80,4,128,142,244,185,168,193,226,151,60,10,67,31,218,138,104,52,102,128,20,245,166,145,65,60,83,75,83,16,134,144,208,79,52,210,105,136,13,37,40,25,163,28,102,129,6,120,167,10,101,56,80,3,133,45,38,120,162,144,199,10,40,6,140,208,49,173,237,76,201,169,77,70,195,6,129,48,167,41,166,211,133,0,60,28,154,112,52,193,74,41,20,62,147,154,1,226,140,208,2,209,69,37,0,45,20,81,154,0,40,162,138,0,40,163,165,20,0,28,209,69,2,128,10,76,83,169,40,0,162,138,74,0,90,40,239,73,64,11,222,138,76,209,64,11,218,154,77,20,148,0,180,148,103,154,
76,208,33,73,164,39,210,144,158,105,164,226,152,14,205,25,226,153,145,72,90,129,92,9,160,183,189,33,166,19,138,98,31,147,70,234,102,104,207,52,10,227,243,69,51,52,185,205,3,36,6,140,212,97,187,82,238,160,46,59,52,160,211,51,205,40,52,0,234,41,1,205,25,160,5,165,166,230,148,82,24,191,90,51,77,207,165,25,160,7,102,142,180,204,210,231,20,192,126,120,164,207,165,55,52,153,164,3,179,70,105,185,163,52,196,40,52,103,138,110,104,205,0,59,52,225,81,131,78,83,64,34,64,105,105,5,47,122,69,13,34,147,20,250,49,222,128,26,23,60,210,129,78,2,151,20,5,136,216,83,72,169,182,210,98,128,177,22,41,113,82,109,20,98,128,177,30,218,49,82,98,140,80,22,35,197,24,167,226,147,20,0,218,90,92,115,75,143,122,0,109,46,105,72,197,37,0,46,105,51,69,24,230,128,2,105,51,154,13,37,0,25,163,52,82,80,33,115,73,154,74,41,128,180,148,184,165,199,20,128,109,25,165,52,218,98,28,13,31,74,109,46,104,2,55,52,194,42,82,1,164,219,214,152,136,169,13,72,86,154,69,2,35,38,154,115,79,43,233,77,34,152,134,209,154,49,72,104,16,
185,164,207,52,157,232,247,160,7,102,147,57,164,162,128,29,154,92,211,40,207,20,0,252,210,131,76,13,197,40,52,12,144,80,122,83,51,75,154,0,80,105,105,160,243,78,160,3,52,102,151,28,82,98,128,23,52,185,166,227,138,59,208,49,249,165,205,50,148,82,1,217,164,167,116,166,154,0,67,76,61,105,254,244,210,51,76,4,205,40,106,103,181,20,8,151,52,229,53,8,36,26,145,121,164,52,88,83,82,3,197,66,166,164,169,45,10,41,217,168,193,167,3,64,199,81,73,154,61,232,1,105,51,64,160,208,1,73,65,52,148,8,90,41,40,160,7,82,102,144,209,154,0,120,52,132,211,115,70,104,1,73,166,158,148,81,154,0,74,81,239,72,77,0,211,16,252,82,118,164,205,25,164,48,226,154,104,99,73,154,98,28,13,40,53,30,105,119,80,23,37,205,27,170,48,212,185,164,59,146,103,52,214,25,164,221,75,186,128,19,233,74,188,210,19,73,64,15,207,60,83,129,168,179,74,26,128,185,46,105,65,244,168,193,167,131,72,98,230,151,52,220,241,75,64,197,207,20,180,220,209,64,14,162,155,154,81,64,11,65,164,205,20,0,180,82,102,140,208,2,209,222,147,181,46,104,0,160,
82,103,20,80,2,210,81,154,79,198,128,10,74,9,164,38,128,20,154,105,52,19,77,38,152,133,39,191,122,51,77,38,154,79,20,10,227,201,166,30,123,211,75,96,209,154,98,184,162,147,52,155,169,187,168,16,226,105,189,104,205,2,152,5,20,180,162,129,9,138,41,216,164,160,98,3,75,154,67,214,147,60,80,3,169,115,76,163,62,148,1,32,106,42,60,210,238,226,128,184,252,209,154,102,104,205,1,113,224,208,77,48,26,51,154,64,59,52,102,155,154,51,76,7,103,210,140,211,115,216,81,154,0,118,104,205,55,52,153,160,7,103,222,147,52,157,105,87,158,180,0,115,218,165,94,41,130,156,41,13,18,102,151,53,24,235,78,164,49,192,210,142,157,105,185,165,6,129,143,20,189,169,128,210,131,72,99,184,205,39,20,153,226,152,90,128,36,205,37,48,53,46,115,76,67,189,232,166,230,151,52,128,90,41,51,70,113,64,11,69,38,105,55,113,64,14,226,142,41,187,168,220,41,128,188,82,119,164,207,90,110,104,1,244,148,128,227,165,55,52,8,125,28,83,51,235,70,234,0,117,39,20,210,105,55,83,2,76,209,159,90,143,117,27,168,11,138,199,154,110,113,70,234,
110,104,16,250,51,76,205,46,104,16,236,210,230,153,154,51,64,199,83,72,163,119,20,19,64,132,34,152,86,164,164,224,241,76,8,138,241,76,43,86,113,145,76,42,41,220,86,32,218,115,237,65,28,244,169,118,246,165,9,64,172,68,23,138,76,123,85,141,148,133,59,209,113,216,175,142,105,49,205,79,229,208,99,192,162,226,177,6,40,29,106,93,148,194,49,64,7,90,51,64,20,119,160,5,20,225,77,165,20,0,241,159,194,131,64,165,246,160,99,104,167,82,129,156,80,2,0,105,227,138,0,197,6,144,192,243,76,38,134,226,154,91,189,2,12,210,19,147,73,154,110,238,105,136,83,138,67,73,154,1,160,7,10,122,212,99,165,72,162,129,162,101,169,71,74,132,84,128,241,82,82,20,83,169,162,157,72,96,41,105,41,104,0,207,173,28,81,69,0,33,164,165,235,205,33,239,76,3,249,81,158,105,41,40,16,180,102,146,146,128,28,77,38,105,185,164,205,2,184,236,251,211,115,205,52,154,67,76,87,31,187,154,3,84,121,163,117,1,114,93,222,244,22,168,139,82,110,162,193,114,82,105,51,81,23,226,141,212,5,201,55,82,231,214,162,221,75,186,128,185,38,123,208,91,
142,181,22,250,55,80,23,37,15,75,191,158,106,16,212,22,162,193,114,125,212,133,170,29,244,155,243,69,130,228,193,184,167,131,85,183,251,83,132,156,81,96,185,100,31,122,112,106,168,36,226,158,175,74,197,92,179,184,83,183,85,95,50,143,50,139,14,229,173,212,102,160,87,226,157,187,138,86,11,146,230,151,119,21,9,122,110,242,104,176,92,177,186,147,119,189,65,190,144,181,22,11,150,55,123,209,190,171,111,165,222,104,176,115,22,55,10,55,10,175,186,151,125,22,11,147,238,20,6,170,229,241,70,250,44,23,44,110,163,112,170,225,248,160,201,222,139,5,203,25,30,180,210,106,15,50,131,37,59,5,201,73,230,154,77,51,126,105,11,113,69,133,113,219,168,45,81,51,82,111,52,236,77,199,177,226,153,186,130,120,166,19,131,197,48,37,28,211,115,66,154,70,61,232,0,206,41,67,83,73,201,166,231,173,2,37,13,78,223,80,3,75,186,129,220,159,112,52,185,168,3,211,131,251,82,11,142,99,205,55,117,33,110,41,9,166,3,183,102,140,251,211,51,197,4,230,129,15,6,140,156,83,3,82,238,245,160,7,230,140,211,115,218,140,208,49,217,163,
52,192,212,110,160,67,243,70,105,155,168,207,173,0,60,26,50,105,187,168,205,3,29,154,119,29,234,61,220,82,110,52,128,121,60,241,78,86,0,117,168,179,218,147,117,1,114,98,222,148,224,213,0,106,112,108,10,44,23,39,205,46,225,222,161,13,75,186,149,135,114,93,212,110,247,168,183,82,111,162,193,114,109,244,187,184,170,251,233,67,154,44,23,39,221,77,45,205,71,190,147,117,22,11,147,134,165,6,160,13,75,187,138,44,59,147,110,163,117,67,190,147,127,20,88,46,76,95,29,232,223,233,80,110,163,117,22,11,147,23,247,166,239,168,139,82,22,167,97,92,156,55,20,187,184,226,171,239,163,125,22,11,147,239,20,155,248,168,11,231,154,77,198,139,5,203,59,169,55,113,80,7,52,133,141,22,11,147,111,165,221,80,238,164,221,69,133,114,109,212,155,170,61,212,155,168,11,147,110,166,22,230,153,187,20,22,160,46,63,117,25,166,102,140,208,4,153,163,53,30,104,205,0,75,154,92,212,97,169,67,80,50,64,105,13,55,52,155,168,1,212,3,77,206,105,104,1,217,244,164,60,245,164,205,25,205,0,25,231,218,164,4,117,168,79,92,210,238,226,
128,36,205,0,231,165,70,14,106,69,110,49,64,11,138,13,38,105,105,0,220,83,74,131,82,237,163,111,20,238,22,43,149,231,165,27,125,170,109,180,132,12,81,112,177,24,74,93,164,31,106,147,24,164,60,80,22,26,5,59,111,20,153,167,14,69,0,52,169,165,81,138,113,94,40,2,128,176,161,77,46,223,106,84,56,167,99,173,73,86,43,56,230,152,84,226,174,121,99,173,52,167,20,238,43,20,79,90,76,243,86,26,49,76,217,138,171,147,98,34,41,56,21,33,20,195,64,128,84,139,76,81,222,165,11,64,208,245,169,65,168,215,138,125,73,67,133,45,51,60,82,231,138,0,125,25,166,102,151,52,135,113,217,164,205,52,154,51,76,67,168,164,164,205,0,45,20,3,65,160,4,193,163,20,162,138,0,105,20,194,42,92,102,144,47,52,92,86,33,32,210,28,212,229,115,77,41,205,59,133,136,57,164,230,166,49,230,154,82,153,54,34,61,122,209,154,144,167,29,105,4,126,148,5,136,232,205,73,229,210,249,99,20,5,136,168,250,84,158,95,52,239,46,128,177,13,21,55,151,72,99,162,225,98,42,42,95,46,141,152,160,44,69,138,49,158,181,33,78,105,187,104,1,159,74,41,197,40,
197,0,54,128,105,113,65,20,0,100,210,238,226,155,140,82,226,128,30,31,20,190,103,189,71,138,7,52,5,199,239,247,165,15,81,226,138,0,147,117,27,169,157,232,205,0,63,52,110,166,103,245,163,52,0,240,212,110,166,102,140,231,173,0,63,52,110,231,173,51,52,155,168,1,251,253,233,55,243,81,150,166,150,239,64,92,147,117,33,122,140,154,9,166,43,146,111,247,165,15,80,231,60,81,186,128,185,41,106,77,213,30,115,70,234,0,144,181,27,189,106,61,217,164,221,64,18,238,165,220,5,65,186,130,216,160,46,74,91,222,147,62,245,30,123,82,102,128,37,221,70,239,122,140,26,51,64,18,238,163,119,189,69,187,181,25,160,9,119,209,188,84,59,168,205,0,76,90,147,117,71,154,3,80,4,187,189,40,221,197,71,187,38,141,217,160,9,119,81,186,163,221,75,186,128,31,154,51,81,238,165,221,64,15,200,163,53,30,234,81,72,9,65,162,152,13,46,234,6,63,62,244,132,211,73,164,221,64,135,230,147,62,180,208,212,153,160,7,238,197,27,184,197,71,186,140,241,64,18,110,25,163,117,71,154,51,154,0,147,117,27,234,60,226,147,60,80,4,155,169,67,84,
89,52,102,128,36,223,239,75,187,222,162,205,27,168,2,77,244,224,245,14,234,51,64,19,121,148,111,226,162,205,25,231,52,14,228,155,168,221,239,81,147,70,104,17,38,239,122,77,244,202,76,208,4,155,189,40,221,81,230,141,220,208,4,153,163,53,30,236,26,51,64,18,238,164,207,21,30,105,119,80,3,243,70,125,234,61,220,81,154,6,73,187,154,55,10,143,117,27,179,64,137,51,70,234,143,61,104,206,104,2,76,209,154,143,52,102,128,37,221,239,70,106,60,209,154,0,151,52,110,168,183,82,238,160,100,187,189,232,205,71,79,30,244,0,225,210,150,144,82,102,129,143,205,20,202,55,98,128,31,73,154,110,104,207,20,0,236,243,74,15,165,51,173,38,121,160,68,193,169,193,170,0,220,211,183,82,29,201,247,12,208,88,26,132,100,211,192,230,129,220,117,52,154,118,61,41,226,48,71,189,33,141,3,154,118,222,49,78,3,28,210,133,207,52,14,196,94,87,181,42,161,21,54,56,160,1,74,225,97,49,237,77,43,233,79,197,24,227,52,12,140,2,41,217,165,34,155,138,4,56,82,154,104,235,78,237,64,198,50,241,210,171,176,35,181,90,61,49,80,200,41,161,
52,86,39,181,33,25,25,28,83,202,0,114,122,208,0,231,138,162,6,199,141,220,212,194,160,200,13,138,153,90,147,4,72,5,62,152,14,105,65,164,80,204,210,231,138,96,52,180,196,59,52,185,166,118,165,52,0,236,209,158,41,153,163,119,20,5,199,131,75,154,98,156,212,138,41,0,153,165,165,197,52,208,49,217,163,52,222,212,160,208,3,135,74,41,185,163,52,0,234,74,64,104,205,0,45,33,20,185,226,147,154,0,76,81,138,51,70,123,80,2,80,104,162,129,5,47,20,148,80,1,197,20,148,10,0,94,244,83,88,246,164,207,122,96,59,20,17,77,221,75,154,0,54,210,109,165,205,46,69,0,51,102,104,219,79,160,138,2,196,123,115,70,61,169,228,113,77,239,64,134,237,164,197,60,210,17,205,48,25,138,49,78,237,65,20,8,110,41,49,78,34,147,20,0,152,163,20,245,28,82,237,160,8,176,105,8,197,78,23,52,210,128,154,2,196,57,166,231,154,151,104,164,40,58,208,34,58,105,169,182,10,60,176,104,11,16,226,147,181,78,99,20,194,184,166,22,33,239,73,154,147,103,52,210,153,233,64,134,230,151,52,187,113,73,138,0,74,41,66,230,159,229,230,129,145,159,173,
2,158,83,214,147,20,0,152,226,131,78,164,197,2,27,65,52,253,190,148,220,80,49,185,160,211,136,197,33,28,80,33,51,70,104,61,105,40,1,115,205,25,164,163,52,0,185,247,163,52,157,105,59,80,3,195,82,238,226,163,206,40,205,0,73,186,140,212,121,165,205,0,63,52,187,184,168,179,222,151,52,1,38,239,122,11,123,212,121,163,117,0,75,187,140,210,110,247,168,242,104,201,197,0,73,186,141,213,30,104,13,64,18,102,140,211,51,70,104,1,249,163,52,194,77,25,160,7,19,239,74,14,72,20,204,209,187,28,247,160,101,189,153,94,48,42,22,70,86,57,169,97,144,176,171,30,90,183,36,82,189,138,181,202,24,52,96,213,169,35,0,224,12,84,44,164,112,104,184,172,71,75,142,41,66,31,173,72,23,140,96,208,34,49,210,148,26,70,5,105,23,173,48,20,156,26,51,79,88,203,115,74,137,206,8,164,59,17,119,165,227,60,84,146,198,1,200,165,138,44,227,52,5,134,8,201,230,154,99,97,218,175,8,148,14,148,201,20,102,149,199,202,82,239,69,43,112,196,81,180,227,53,68,141,52,103,138,40,197,0,39,214,148,82,208,58,80,2,82,209,138,90,0,74,49,78,24,205,
25,20,0,152,163,6,156,49,154,90,0,102,41,64,205,59,140,81,144,40,0,219,237,78,11,72,27,52,185,164,49,69,25,164,221,73,158,104,1,244,98,144,12,211,197,0,46,0,30,244,152,239,78,35,36,82,149,192,235,72,118,35,197,41,2,156,49,138,8,160,6,128,51,210,145,135,122,112,198,105,229,120,160,44,86,207,62,212,245,60,210,136,131,30,105,222,86,41,138,195,215,165,56,123,84,106,49,197,74,189,105,20,56,122,83,212,80,5,40,21,37,11,74,41,41,194,129,133,6,138,40,24,157,232,205,46,51,69,33,5,52,245,167,82,83,0,2,148,244,162,147,61,168,1,166,163,108,154,144,243,77,61,40,17,93,134,41,134,64,163,154,150,65,158,69,64,84,16,115,84,75,24,88,19,145,210,164,86,166,109,24,197,42,154,100,147,169,165,205,70,13,59,52,138,5,167,129,198,106,53,169,1,226,128,12,123,81,75,154,76,208,3,77,39,52,227,214,146,129,0,205,72,135,154,101,40,56,160,100,148,99,52,221,212,110,164,49,113,70,40,205,27,168,1,15,20,153,205,4,138,97,235,76,67,243,70,105,153,62,180,3,235,64,18,102,140,211,115,70,104,1,221,232,166,230,151,52,128,13,
38,105,77,54,152,6,121,165,38,147,2,154,120,160,67,183,10,93,195,21,29,38,104,11,143,39,34,154,79,173,20,99,38,128,19,60,210,238,164,34,154,105,136,121,106,3,115,214,153,154,40,2,80,105,192,212,64,154,112,60,82,24,226,104,29,105,51,73,154,0,117,33,164,205,45,0,0,82,129,73,154,51,64,11,138,54,138,79,198,140,208,2,209,154,76,210,100,208,3,169,9,20,205,198,147,117,0,7,173,33,62,148,166,154,105,136,55,82,230,163,207,52,160,226,128,36,7,52,135,154,102,236,83,129,231,138,0,54,209,143,106,51,75,158,40,1,152,231,154,48,51,78,164,197,0,32,3,52,225,138,74,57,160,7,117,166,237,20,102,140,208,2,20,6,144,10,127,106,74,0,76,115,77,43,207,2,157,73,205,0,38,61,169,165,105,244,96,208,34,34,156,210,108,57,169,182,208,87,20,192,131,109,27,106,109,148,109,160,8,118,19,70,207,106,159,109,5,104,11,16,108,164,216,106,198,202,80,188,80,22,43,249,103,29,41,68,71,210,172,5,167,0,61,41,92,44,86,242,91,210,144,196,125,42,230,6,104,0,122,81,113,216,162,99,62,148,121,109,233,87,252,181,244,160,66,15,74,46,
22,40,121,103,184,167,108,56,233,87,254,204,189,232,54,227,20,92,57,89,67,97,163,203,62,149,113,163,80,58,82,4,24,162,225,98,168,136,154,95,40,213,157,184,237,64,92,253,40,184,88,171,229,154,60,179,86,188,186,107,46,13,23,11,21,182,28,80,35,99,208,85,216,225,86,251,213,42,66,131,181,23,5,18,8,16,175,24,171,56,227,165,56,32,29,40,199,21,55,45,43,12,96,49,239,81,121,101,219,39,165,73,130,205,199,21,42,165,1,107,145,249,88,28,10,10,226,166,52,194,185,165,113,216,175,36,5,189,170,31,179,178,183,90,191,138,66,128,211,184,185,70,36,123,84,3,205,52,166,26,167,198,5,49,243,154,7,98,61,153,167,34,96,80,26,156,13,2,30,7,20,210,153,167,14,180,225,235,72,162,171,219,179,114,160,84,77,110,253,133,94,38,147,34,157,201,113,70,92,144,58,158,148,205,166,180,37,198,13,84,60,28,85,38,67,68,123,77,46,195,138,118,104,45,76,68,101,72,163,4,83,243,158,105,51,64,12,193,205,47,61,233,73,81,220,15,198,154,101,65,252,67,243,160,5,230,147,39,189,52,207,24,234,115,244,52,195,58,31,255,0,93,0,75,186,141,245,
92,206,130,155,246,148,237,252,232,2,200,122,112,98,78,5,85,19,171,84,209,78,155,241,145,154,0,176,35,108,102,128,164,158,41,235,34,244,197,55,205,10,216,164,59,18,40,60,10,118,115,198,42,31,59,61,5,58,25,55,56,7,138,6,77,180,208,77,72,122,84,67,59,169,12,93,167,20,167,154,81,218,148,1,140,208,3,2,156,211,251,82,226,140,98,144,192,80,195,138,81,74,71,20,1,30,41,202,184,235,78,85,167,5,160,44,40,197,60,82,1,78,164,80,98,138,40,164,48,199,52,184,162,140,224,208,1,142,40,165,237,73,138,0,74,65,197,59,20,148,0,157,169,15,90,118,41,184,166,33,14,41,191,90,113,20,210,40,2,38,57,226,162,219,142,115,154,155,203,205,49,148,242,42,136,100,45,142,198,155,140,12,210,149,52,140,15,74,100,138,167,29,234,65,210,162,0,211,198,113,214,129,146,224,80,77,33,52,194,105,0,253,216,163,53,30,104,205,49,15,205,56,84,96,158,148,236,241,64,199,102,140,211,115,71,106,64,59,52,185,168,243,79,90,0,90,51,78,227,210,148,99,210,129,141,231,25,166,147,82,28,99,24,166,16,40,1,180,132,211,177,205,27,104,16,128,
210,230,130,164,82,5,52,0,185,165,28,210,168,245,167,128,59,80,49,152,164,61,106,66,5,33,25,164,3,49,233,75,140,210,226,148,10,0,97,20,1,78,34,144,83,1,15,20,139,214,159,128,122,210,132,6,128,176,198,231,181,70,84,154,177,179,218,147,103,25,197,23,11,21,240,69,32,28,213,131,21,2,49,158,104,184,172,65,222,150,167,242,133,11,16,235,69,199,98,17,154,80,13,88,8,190,148,187,87,174,41,92,44,87,218,104,218,213,99,106,209,129,69,199,98,190,211,72,126,149,103,104,34,154,98,25,162,225,98,10,42,95,43,6,151,202,24,167,113,88,135,20,132,123,85,129,23,173,47,148,13,43,133,138,165,78,51,64,92,213,179,16,199,74,111,148,51,210,139,135,41,85,144,142,217,166,237,56,171,190,88,35,165,33,132,99,165,59,135,41,71,105,237,70,195,138,184,96,25,226,143,36,81,113,114,148,182,154,93,167,160,171,130,1,215,20,24,7,165,23,14,82,158,15,67,75,222,172,249,34,144,195,232,40,184,88,174,41,70,42,111,39,20,121,62,212,92,44,70,49,70,41,254,89,7,161,160,35,30,198,128,35,43,75,182,165,17,31,122,120,135,61,141,23,11,
21,246,123,82,21,171,70,19,218,144,192,122,209,113,216,171,182,156,18,165,242,155,251,180,108,35,177,162,226,177,30,223,106,118,218,118,211,233,79,84,39,181,23,29,136,194,15,74,112,74,126,194,59,82,236,62,148,174,59,17,249,99,190,40,242,197,75,180,227,165,38,211,233,69,194,196,126,80,62,148,121,67,173,73,180,138,57,160,44,69,228,253,41,60,147,218,166,6,150,139,133,136,60,163,71,150,77,88,24,244,167,5,2,139,133,138,190,89,29,168,218,125,42,214,7,165,38,7,165,23,11,21,130,147,83,160,192,2,151,98,131,197,56,45,23,26,67,72,166,114,58,212,216,24,163,104,164,22,42,58,177,165,72,153,189,170,214,197,165,10,59,10,119,14,81,158,82,227,165,30,80,169,113,69,77,199,98,19,22,71,74,67,8,61,133,78,105,180,238,22,35,216,0,165,197,63,20,96,80,22,24,78,41,0,221,79,101,205,10,184,160,4,9,142,212,234,117,33,20,134,38,41,49,78,164,160,4,197,4,123,83,168,160,8,205,49,185,169,136,21,19,21,94,9,230,152,136,201,197,51,118,57,230,145,229,25,192,90,133,174,72,200,216,42,136,108,178,38,199,92,211,204,163,
28,86,75,222,200,27,2,53,52,229,184,157,185,0,1,244,162,193,204,105,135,207,173,59,32,85,24,167,115,128,79,233,79,105,27,105,230,149,135,113,110,46,146,54,193,4,253,43,62,125,65,67,124,177,147,248,210,206,198,70,170,69,9,126,153,171,72,134,201,190,217,41,228,41,20,198,158,224,229,129,53,98,40,129,3,129,154,37,131,174,9,20,8,160,215,82,231,151,63,157,48,207,33,39,230,99,248,210,188,68,177,36,99,214,147,203,101,110,57,31,74,98,212,111,154,199,169,166,238,62,181,43,196,65,233,248,211,4,102,152,15,71,57,25,169,192,61,106,16,132,17,235,86,210,38,242,242,69,33,149,102,37,73,226,163,83,147,87,37,131,114,244,61,42,180,113,18,252,10,4,56,167,238,233,99,66,24,26,190,150,219,163,229,77,34,192,51,211,20,92,98,35,144,51,154,14,73,201,169,76,120,82,66,240,59,98,163,64,75,242,56,164,50,72,213,136,233,248,213,168,163,192,4,245,166,32,224,0,42,194,140,47,53,45,141,33,172,204,20,144,122,84,63,107,0,97,144,138,152,46,225,143,90,137,160,27,185,4,138,1,150,18,88,206,62,110,190,162,167,11,145,237,
89,196,97,184,171,145,74,70,21,143,30,180,154,41,50,109,148,21,165,206,71,181,38,105,20,46,218,93,180,153,167,3,64,9,182,148,10,117,20,128,64,41,105,105,40,24,82,209,69,0,20,119,163,241,163,138,0,40,162,138,0,58,82,99,242,165,235,71,106,0,111,106,8,239,78,164,160,6,247,246,160,10,117,40,20,0,129,71,165,33,80,123,83,168,237,64,16,180,96,118,166,50,15,74,157,186,84,77,76,150,136,89,41,48,41,230,153,84,73,25,166,154,155,203,61,232,242,104,21,136,41,70,106,113,15,173,2,37,167,113,88,137,65,52,237,167,181,76,34,2,141,131,52,174,59,16,237,52,96,142,181,56,65,72,84,30,49,69,194,196,20,225,197,43,38,58,82,109,56,166,33,219,168,221,81,158,59,209,147,64,92,152,26,56,168,129,167,103,222,144,238,63,28,210,138,102,113,64,52,12,127,20,112,41,185,163,52,0,226,69,38,234,76,210,26,0,120,34,157,81,102,151,117,43,5,201,14,41,48,61,105,187,168,6,129,220,127,20,187,69,70,90,149,91,154,0,120,95,76,83,130,208,166,134,227,154,67,29,142,104,2,163,222,115,214,141,230,128,185,33,166,156,83,55,209,187,214,
128,184,252,210,102,154,90,144,154,98,185,39,90,13,68,31,6,157,186,139,5,199,113,75,197,68,91,154,79,51,158,180,88,46,77,184,98,141,235,235,80,23,247,166,134,162,193,204,90,46,190,180,117,233,85,131,123,212,202,220,10,44,52,238,63,52,160,211,71,52,252,82,24,102,138,80,41,8,197,33,137,72,78,104,126,57,20,192,121,166,33,217,160,26,67,197,38,104,16,252,210,22,166,110,164,221,78,193,114,76,210,100,26,102,105,55,80,43,143,207,189,25,20,204,250,210,110,247,160,46,73,145,70,225,81,238,164,205,22,21,201,132,139,142,105,124,229,170,197,189,233,165,168,176,115,23,68,138,71,90,112,113,138,161,188,142,132,210,137,88,119,163,148,124,197,226,234,15,56,20,110,83,200,197,80,50,147,212,211,132,196,119,163,148,57,139,163,111,181,25,227,138,170,146,147,222,166,15,197,43,20,153,33,193,233,70,105,161,168,205,32,28,56,164,205,52,190,41,190,96,199,90,118,11,143,44,42,7,108,26,26,64,123,212,108,244,210,37,177,219,233,67,212,5,185,167,43,83,177,55,38,15,235,75,230,10,136,154,6,77,22,29,201,131,131,210,
157,222,163,85,252,234,96,41,50,144,160,123,211,133,32,233,74,42,74,10,74,90,76,208,1,222,156,41,5,45,0,45,55,52,180,218,0,90,74,92,211,123,154,0,112,163,191,52,82,224,80,2,98,140,83,169,40,0,237,72,105,105,15,52,0,148,180,148,10,0,92,116,163,6,150,138,0,141,137,232,42,61,190,213,54,41,54,113,76,69,102,78,56,21,4,176,29,166,175,20,230,144,198,13,59,138,198,73,128,168,206,51,74,138,73,28,28,122,86,161,129,8,233,77,88,0,63,116,81,204,46,82,21,141,66,240,162,153,229,177,36,227,138,188,35,80,58,82,249,107,233,74,227,229,49,230,132,171,103,24,168,226,128,185,201,28,86,172,209,171,113,183,53,18,196,1,192,20,249,133,202,64,177,237,232,41,207,9,35,56,169,66,157,216,237,83,237,4,99,20,92,44,101,253,152,51,100,129,239,74,214,232,58,0,42,251,68,185,56,233,80,201,22,79,4,209,204,46,83,56,197,146,69,57,45,199,4,129,86,12,36,116,205,79,20,60,116,230,159,48,185,74,70,1,191,56,25,169,2,99,0,244,244,171,158,64,193,200,230,163,48,146,212,92,44,85,104,203,100,14,63,173,73,5,147,110,7,104,235,87,
34,181,29,91,57,171,42,129,122,10,27,26,137,16,128,12,113,197,63,202,80,62,232,169,6,104,34,166,229,216,132,196,10,144,5,64,45,2,156,145,87,7,2,145,142,69,23,21,145,88,160,90,104,52,249,57,52,221,160,15,122,98,29,30,0,167,48,24,61,233,138,8,60,83,246,147,64,21,157,78,9,164,66,113,205,88,104,243,193,166,249,120,61,13,59,138,195,18,86,83,198,126,149,58,200,27,216,212,98,48,15,74,93,164,114,41,12,152,30,212,241,140,212,81,146,126,240,197,76,23,189,34,144,180,185,162,146,144,199,102,143,195,154,74,7,90,0,94,212,82,210,26,0,40,160,210,80,0,104,20,81,64,11,154,59,210,80,122,208,2,210,102,147,52,134,128,29,158,40,205,55,60,82,19,64,15,39,154,9,166,110,52,114,104,16,226,69,68,230,159,131,76,101,38,152,50,38,168,205,74,80,211,124,179,232,106,136,39,60,82,102,154,90,144,181,33,142,45,154,76,250,83,115,71,61,169,138,227,179,235,77,45,205,24,38,154,192,230,129,14,221,72,90,163,201,167,40,38,152,174,59,52,102,147,6,138,67,14,166,154,69,56,80,72,166,4,103,173,0,226,149,135,113,76,193,160,67,
179,75,154,103,56,160,19,64,15,6,151,52,202,94,104,1,217,163,117,55,52,3,64,11,158,104,205,24,207,74,124,104,9,230,128,17,84,147,210,158,195,109,76,170,0,233,80,205,157,213,59,151,107,33,133,197,57,92,84,120,52,116,166,77,203,1,198,41,25,234,0,220,245,165,45,69,135,113,251,187,210,22,166,111,247,164,206,104,21,199,238,165,221,234,105,155,88,158,5,52,150,206,49,76,9,11,251,211,75,212,109,184,30,105,62,99,219,52,88,87,36,45,71,153,81,252,222,244,153,166,43,146,249,156,83,75,3,76,163,181,1,114,64,194,151,60,84,98,157,154,0,120,53,52,103,229,197,86,205,79,1,205,75,42,47,82,194,138,112,160,116,165,21,6,162,138,13,20,26,0,141,234,62,135,154,145,206,42,187,191,207,210,154,37,146,22,197,55,52,96,158,156,210,133,227,165,49,12,99,205,55,118,42,115,26,227,154,137,226,57,227,56,167,113,52,196,221,199,90,55,83,88,21,250,82,41,207,113,64,135,19,73,154,126,208,105,165,40,11,13,205,5,170,68,143,117,61,161,80,51,69,194,204,171,156,244,163,161,165,218,67,224,83,194,10,98,177,30,105,185,230,158,
209,158,212,205,188,208,38,57,65,61,41,226,38,35,138,84,3,167,165,88,84,205,38,202,72,100,104,64,233,82,129,140,113,74,5,41,21,55,52,72,110,57,163,154,118,40,2,128,35,97,235,81,182,7,108,85,130,56,233,81,74,190,212,33,52,86,35,52,152,61,234,102,76,14,148,128,3,201,170,185,22,35,219,73,140,30,42,66,48,106,51,156,211,1,64,36,212,177,169,3,20,197,60,84,241,245,164,198,135,109,56,167,10,119,20,99,154,146,197,31,74,40,20,180,134,37,38,41,221,168,160,4,239,70,77,45,33,160,4,52,156,211,169,13,0,33,165,80,113,69,40,52,0,83,133,37,20,0,191,133,20,81,138,0,41,167,165,47,62,180,210,222,244,0,159,141,0,226,144,184,20,128,231,173,2,31,158,105,212,213,233,78,205,3,12,81,64,57,20,98,128,19,169,163,109,59,28,209,237,64,5,38,61,41,123,81,64,8,61,232,34,150,144,208,3,8,166,21,197,77,138,105,25,237,64,17,5,0,116,165,167,98,144,138,4,48,130,71,2,148,71,211,138,120,6,157,138,0,140,198,15,80,41,219,58,113,79,197,40,20,12,140,161,161,19,3,145,205,73,138,90,0,64,41,113,69,20,0,82,30,105,105,40,1,13,
68,224,156,226,165,52,210,6,104,2,0,167,28,142,105,54,122,212,228,117,166,149,205,50,108,49,82,165,3,218,148,1,75,64,236,55,30,212,148,239,106,78,148,128,110,51,73,140,83,240,40,197,48,24,70,7,20,43,144,125,169,113,76,97,142,148,1,48,112,79,20,234,172,172,119,123,212,202,254,180,5,199,210,230,155,154,92,241,72,98,209,73,154,51,64,11,73,70,104,205,0,24,162,147,181,25,160,5,162,155,186,141,212,0,234,8,166,238,163,121,160,67,182,209,178,152,101,34,154,101,57,166,23,68,187,70,40,24,21,15,154,212,158,105,61,232,176,93,19,241,72,72,168,195,209,191,222,139,5,199,16,13,38,61,41,187,168,223,64,136,3,82,158,122,83,6,239,74,120,7,210,168,129,64,24,167,3,233,205,51,154,124,64,150,230,129,161,121,61,177,74,19,34,165,10,61,41,113,142,149,55,42,196,34,46,244,240,184,21,38,56,164,56,162,227,177,11,12,84,44,72,106,176,252,212,76,132,211,68,200,143,52,19,75,177,135,106,66,141,84,64,132,210,82,236,97,218,141,141,233,64,8,113,64,198,40,216,212,121,109,64,7,20,188,26,4,76,125,105,194,22,160,6,244,
233,74,42,65,15,185,165,17,96,245,165,113,217,145,212,145,100,183,29,169,226,17,79,72,194,244,165,114,146,20,103,20,201,23,140,212,180,210,50,41,20,202,217,166,183,74,152,197,207,90,107,68,123,100,213,92,134,153,93,169,181,63,146,199,168,167,44,24,63,48,167,114,108,202,216,169,146,48,123,243,83,136,20,158,148,245,137,84,112,42,91,41,68,21,70,49,72,98,4,230,159,140,14,40,164,93,136,124,157,205,147,210,151,200,24,249,106,80,49,74,40,184,89,21,154,34,51,85,101,30,89,203,28,15,122,211,34,168,222,197,27,129,230,103,3,223,20,211,38,81,40,77,121,12,127,197,184,250,47,53,92,234,77,159,150,49,143,115,85,38,93,146,144,57,231,138,122,218,202,232,25,16,145,244,173,12,139,41,169,31,227,143,241,6,164,254,209,135,25,195,103,211,21,154,232,241,182,25,72,250,211,115,235,76,70,228,82,249,168,25,84,213,235,114,51,211,21,143,167,220,128,187,27,21,177,22,7,34,179,145,164,75,52,189,233,163,165,56,116,168,53,20,254,84,30,148,189,69,38,5,0,70,192,211,54,119,169,200,20,210,49,210,129,88,140,12,30,41,
224,82,226,151,20,12,111,90,66,185,52,240,56,160,208,5,118,136,16,70,42,56,237,2,243,154,183,138,0,167,113,88,139,203,2,129,31,53,41,233,73,140,80,22,17,70,56,165,97,145,64,20,224,61,105,12,128,69,207,52,227,23,21,54,5,24,167,113,88,168,209,145,197,48,70,89,170,217,28,208,168,7,74,46,46,82,53,136,45,72,7,24,167,109,163,28,82,29,132,160,226,148,82,99,241,160,98,12,145,79,2,133,226,150,128,16,138,99,12,158,105,244,211,64,16,237,38,144,38,5,72,6,40,197,50,108,68,192,115,85,216,243,86,89,121,168,132,89,108,154,164,75,64,131,138,153,70,40,84,24,233,154,126,61,5,38,198,144,229,57,20,234,96,233,78,169,44,92,210,245,166,226,148,116,160,5,164,205,41,246,164,160,2,138,41,69,0,52,210,102,156,105,148,0,110,165,205,38,61,41,104,1,244,80,40,207,52,0,81,69,7,173,0,50,67,197,66,121,239,82,189,69,140,243,64,133,200,2,156,164,122,211,113,145,74,6,13,0,72,166,159,81,14,41,249,205,3,22,157,73,74,40,0,162,138,40,24,163,173,20,148,80,1,248,82,83,169,13,0,52,245,163,181,41,163,52,8,101,24,165,163,52,
0,160,81,212,208,57,165,226,128,0,41,104,20,80,2,210,81,69,0,20,81,65,52,0,82,119,162,138,0,67,77,237,78,205,52,208,3,78,104,90,40,160,67,168,164,29,41,192,122,208,49,49,205,32,6,157,218,138,0,111,122,13,46,57,163,189,0,49,169,135,3,173,72,106,55,25,20,196,52,16,77,61,77,70,6,58,83,198,120,160,67,193,2,157,186,152,40,160,100,128,209,192,230,163,221,75,187,60,80,3,243,154,105,106,105,106,105,110,104,11,143,7,158,180,187,133,69,186,141,212,10,228,153,30,180,160,212,99,173,63,181,3,23,35,110,106,38,117,7,173,41,63,41,170,206,79,74,104,77,142,123,152,243,212,212,127,106,76,116,53,4,136,114,113,80,140,150,197,81,23,46,125,169,125,26,156,39,7,248,127,90,134,40,195,30,69,90,16,168,3,138,64,174,39,158,160,82,137,179,208,84,77,17,207,29,41,140,254,81,198,51,64,22,119,81,184,213,101,185,140,156,22,10,125,234,112,73,28,12,138,2,230,108,90,164,145,168,86,64,248,238,79,53,102,61,94,35,254,177,25,125,199,53,90,222,195,205,102,18,110,4,116,171,50,105,145,121,31,46,67,40,234,59,213,59,9,115,
22,35,212,45,228,32,43,28,251,173,91,136,135,27,135,74,205,178,178,88,254,111,188,79,168,173,72,212,42,128,6,42,29,139,141,250,143,165,197,20,84,150,33,224,83,72,38,159,218,140,80,4,68,28,83,79,21,49,90,66,128,142,105,138,196,4,241,72,13,77,229,131,72,209,128,56,20,92,86,33,12,11,21,29,106,189,210,201,28,14,254,102,15,80,6,106,224,64,59,82,60,75,32,33,198,69,59,138,198,37,172,115,79,185,153,219,25,235,154,176,37,150,199,37,219,204,140,159,83,145,87,154,53,138,22,8,58,244,21,145,116,146,49,59,183,99,60,10,171,220,134,172,105,219,222,195,58,229,88,131,220,17,83,27,152,148,128,91,244,53,206,44,78,91,1,9,231,210,173,193,6,8,222,164,115,223,189,22,67,77,154,178,95,64,159,121,206,125,0,53,44,51,172,184,42,14,15,173,86,138,214,22,80,74,2,106,220,48,170,116,21,46,197,43,146,143,106,119,122,65,75,82,88,99,189,38,51,75,69,0,55,20,133,246,14,123,211,156,100,16,14,42,32,155,71,115,207,83,64,134,77,36,172,167,203,10,61,205,22,190,105,4,204,65,61,177,82,227,138,112,24,166,22,23,218,151,52,
148,148,134,45,29,40,200,20,153,197,0,41,28,80,41,51,197,20,0,189,106,11,136,124,194,42,106,8,160,12,171,187,16,228,48,198,239,165,75,99,22,216,200,35,161,233,87,88,12,114,42,60,128,223,45,85,201,182,166,110,163,107,185,119,22,199,53,146,209,97,182,142,107,165,184,229,48,6,107,22,240,162,63,202,0,106,168,178,36,136,32,7,126,5,111,218,12,40,205,99,89,197,230,73,146,14,49,91,113,13,170,49,158,41,72,34,90,20,225,81,169,205,60,116,168,53,29,69,20,80,0,41,58,209,218,138,0,58,82,230,146,146,128,29,218,144,138,5,20,0,152,197,46,49,75,71,122,0,65,72,70,105,212,148,0,1,138,90,40,160,2,142,212,81,64,8,121,160,12,82,154,74,0,58,81,70,113,71,122,0,65,210,150,146,151,189,0,29,41,105,57,165,160,4,166,154,113,166,145,64,13,200,205,46,65,164,163,20,0,215,56,166,239,246,21,38,220,211,118,226,129,0,39,20,185,163,20,160,1,64,10,180,234,110,105,212,12,59,209,222,138,40,0,163,173,20,10,0,40,165,163,165,0,53,169,180,252,83,72,160,2,129,69,40,226,128,22,142,162,140,209,138,0,92,247,163,181,37,53,137,
31,90,0,82,41,140,41,166,67,222,131,37,0,40,20,236,129,80,249,190,166,148,54,122,208,34,66,105,84,212,96,142,42,65,210,129,143,29,41,114,105,160,241,75,64,11,154,92,241,73,218,138,0,94,244,10,51,71,210,129,133,20,159,206,142,104,16,83,73,165,38,152,192,208,0,13,35,84,97,142,236,84,139,147,64,15,94,5,58,155,74,40,1,212,82,81,64,5,40,164,165,160,2,131,69,33,52,0,18,41,9,164,38,152,205,197,0,59,117,33,53,8,147,154,126,234,0,126,105,132,156,240,41,11,82,169,205,2,28,14,13,56,30,41,166,147,52,12,126,121,163,189,52,154,76,208,3,251,226,148,245,164,162,128,16,250,211,14,41,198,154,104,1,189,233,113,249,82,237,245,160,12,80,33,212,218,118,105,164,211,1,9,166,231,154,13,39,57,246,160,66,211,75,1,65,233,214,161,115,207,20,1,32,52,19,205,55,160,164,4,231,165,2,177,42,158,245,38,73,21,1,98,13,74,167,34,129,136,221,42,38,35,56,167,49,98,120,20,42,30,249,160,44,66,224,145,182,162,91,102,221,198,49,87,149,1,28,138,147,104,3,165,59,138,196,81,199,140,84,196,98,133,24,166,51,115,72,162,57,65,
35,173,82,159,165,92,115,154,165,63,67,84,136,101,41,8,205,49,103,145,6,21,136,30,198,164,117,199,52,139,110,238,187,148,28,26,179,59,29,8,78,115,79,11,129,64,167,86,38,227,74,227,165,56,112,41,41,104,24,180,180,153,226,140,208,2,210,211,115,69,0,45,29,168,164,52,0,102,144,154,13,52,208,0,198,147,57,20,215,165,83,242,208,32,96,58,154,169,116,200,71,43,248,226,173,17,185,113,81,180,33,134,58,208,5,123,88,212,242,9,197,79,228,41,111,90,124,113,132,80,0,169,0,231,145,76,6,199,24,94,149,40,226,144,82,247,164,49,69,47,122,109,25,160,7,81,154,110,105,104,1,105,164,82,230,138,0,65,70,104,38,147,52,0,82,138,65,131,65,160,0,154,64,69,70,228,246,52,129,177,223,243,160,68,216,165,168,196,158,180,162,65,142,162,129,146,1,138,41,161,179,72,91,29,104,0,112,42,33,128,115,77,121,246,18,88,128,42,140,247,161,101,25,35,105,160,69,139,171,149,139,28,18,79,65,85,222,196,92,201,230,57,235,216,85,59,119,121,111,12,143,150,28,224,26,218,143,158,212,211,19,68,49,91,121,107,182,172,170,113,138,112,199,
165,56,125,40,184,210,0,49,78,6,155,156,82,230,144,199,82,211,65,165,6,128,23,52,81,218,146,128,10,5,33,52,10,0,112,235,69,32,205,25,160,5,237,71,181,38,104,253,40,1,104,235,73,75,64,5,25,230,138,40,0,165,164,163,52,0,81,69,25,160,2,138,78,212,102,128,10,40,160,80,1,69,20,19,64,11,73,214,138,13,0,37,20,19,77,52,0,224,40,35,20,128,208,122,208,2,19,64,52,126,20,148,0,236,247,165,164,165,28,117,160,5,160,115,73,154,57,237,64,11,69,38,105,104,1,104,164,163,138,0,15,20,26,41,13,0,37,45,37,25,160,7,122,81,154,76,251,211,119,80,3,179,76,115,129,75,154,107,17,64,16,150,238,105,164,130,120,205,72,113,232,42,22,56,57,6,129,13,118,195,243,197,57,36,166,59,100,210,41,239,64,22,65,200,226,158,172,106,20,36,243,83,3,64,15,6,158,41,139,78,160,99,168,205,55,189,25,160,7,103,210,140,243,76,205,46,104,1,217,165,164,205,20,0,180,214,20,234,78,212,1,17,79,155,52,234,118,40,197,0,3,165,47,106,74,90,0,90,41,40,160,5,164,205,25,164,160,5,38,152,205,77,103,247,170,237,42,131,243,30,104,2,208,57,166,
55,74,136,77,199,90,134,73,206,14,13,2,18,89,54,103,142,5,9,56,98,49,154,172,101,102,110,115,131,83,66,169,193,7,38,128,45,2,8,20,244,192,168,148,129,192,230,158,9,160,9,9,164,220,58,82,100,154,76,123,208,3,243,158,40,199,57,160,116,167,80,48,7,154,82,105,162,138,0,59,243,69,39,57,165,197,2,18,140,208,105,164,208,1,154,110,115,210,161,150,93,157,233,169,33,61,232,2,193,52,132,230,163,223,244,52,224,217,20,0,23,200,192,168,137,231,29,234,76,128,115,77,60,231,29,104,1,11,0,57,205,34,182,70,69,59,1,135,52,121,96,46,0,160,4,200,21,34,14,156,211,85,121,228,84,170,184,160,5,43,78,3,138,112,198,41,24,140,80,2,103,154,55,210,126,20,211,64,15,221,154,141,232,220,64,166,151,205,0,35,176,21,16,140,51,110,62,181,38,6,115,78,207,106,98,3,10,184,193,3,31,74,149,80,42,128,0,226,149,71,25,167,80,59,11,78,237,77,20,180,134,45,25,197,37,33,160,5,205,40,52,209,75,154,0,117,20,128,210,208,0,77,0,210,119,165,233,64,5,4,102,140,208,14,104,1,172,158,244,152,192,167,19,233,71,214,128,26,41,113,71,57,
226,150,128,12,10,90,74,5,0,45,33,165,162,128,18,138,90,5,0,20,26,51,205,39,90,0,92,209,154,78,148,80,1,72,104,52,152,160,5,207,20,135,165,20,160,80,4,69,50,121,226,151,103,106,151,20,99,138,0,129,151,6,161,145,152,30,149,112,168,164,216,15,106,0,175,24,112,193,135,32,246,169,243,210,156,20,10,49,147,64,17,77,16,116,195,116,172,139,205,56,158,141,192,252,197,110,17,197,49,163,13,212,80,6,77,133,178,199,213,139,17,223,21,168,163,229,164,75,117,95,186,49,83,5,197,0,34,211,168,164,160,3,233,73,210,157,70,40,1,41,65,227,20,98,138,0,90,5,20,80,2,117,165,164,162,128,23,52,19,73,69,0,40,165,205,54,138,0,112,52,102,144,81,214,129,139,156,209,154,74,40,16,102,151,52,148,153,160,5,205,30,180,153,164,205,0,58,140,211,115,75,64,11,210,128,105,51,70,104,1,115,71,122,67,64,160,5,162,146,138,0,51,73,70,105,40,0,205,59,181,55,189,45,0,20,118,163,52,80,1,154,90,111,126,41,69,0,45,40,164,160,80,2,230,138,64,104,160,5,205,33,52,116,160,208,1,154,51,77,205,33,230,128,20,181,46,105,6,59,209,64,9,
158,104,206,40,53,19,48,6,128,28,210,84,76,231,52,164,131,210,147,30,212,128,137,201,165,197,72,69,38,13,0,70,83,119,52,4,60,84,225,122,82,237,226,128,26,188,10,119,61,168,0,210,142,59,208,3,215,129,79,205,66,88,244,20,229,7,3,39,154,0,147,52,157,232,163,147,76,5,2,148,82,10,90,0,90,51,73,70,104,24,236,241,69,37,25,160,5,160,210,102,138,0,90,67,69,29,233,0,82,82,230,146,152,132,247,166,153,2,245,164,114,123,84,50,103,20,128,138,89,254,98,0,170,236,197,206,74,244,169,194,113,239,72,84,1,199,90,0,141,165,249,48,1,205,48,149,100,247,61,169,25,88,183,181,63,203,226,128,34,94,14,5,89,68,7,29,141,71,229,17,86,20,112,40,1,203,31,21,39,65,197,55,56,233,70,252,241,64,14,39,138,1,163,140,82,98,152,15,83,198,105,249,166,40,167,1,64,14,197,24,165,164,160,3,28,81,70,105,104,1,135,173,70,216,230,165,34,161,96,121,160,10,178,174,243,140,247,164,8,71,124,212,225,50,221,41,251,71,76,82,2,20,92,113,222,164,3,156,83,246,129,78,3,138,96,66,203,201,161,71,106,148,175,20,5,246,160,6,133,199,52,153,
201,169,74,251,83,118,96,208,2,83,151,168,52,99,154,112,24,20,0,180,134,148,211,40,1,122,83,72,244,167,98,146,128,27,130,79,94,41,140,57,226,158,78,41,8,226,128,26,0,227,214,165,0,83,64,167,129,64,135,10,92,82,10,81,64,199,82,210,10,15,74,0,41,15,90,51,72,104,1,104,164,20,225,214,128,1,75,65,226,138,0,40,160,245,162,128,10,40,20,80,1,70,40,60,82,14,104,1,122,82,80,104,233,138,0,7,94,105,212,152,201,163,20,0,164,210,117,164,234,105,69,0,45,20,98,129,64,5,3,154,90,40,1,8,164,198,41,199,173,7,173,0,54,154,122,211,233,13,0,32,25,20,160,98,149,105,123,80,2,81,138,92,80,40,1,58,208,120,165,20,26,0,74,49,69,56,28,208,2,17,73,142,41,212,80,49,184,162,157,73,64,132,20,17,69,45,0,38,51,64,24,162,151,189,3,12,82,98,148,244,165,197,32,26,104,165,162,128,19,20,80,41,123,83,1,166,138,90,94,244,0,148,80,57,164,60,80,2,210,126,52,3,210,150,129,9,69,20,135,168,160,5,226,146,148,117,163,20,0,222,180,184,52,119,167,118,160,6,98,151,165,45,40,20,0,222,212,14,148,180,160,115,64,13,233,75,64,160,245,
160,4,207,173,25,20,81,214,128,23,138,67,64,20,98,128,18,151,173,2,138,0,40,20,118,160,80,1,75,69,20,0,148,162,138,65,197,0,59,20,148,160,228,80,105,12,76,209,65,235,72,104,16,132,102,128,180,180,162,129,137,138,49,75,67,14,104,2,54,56,168,89,119,28,212,206,41,8,197,0,70,171,237,79,11,154,94,212,3,64,6,202,77,188,211,169,104,1,161,105,118,211,232,199,52,0,204,96,82,21,167,250,82,129,214,128,35,8,59,211,212,98,148,117,165,239,64,9,72,41,212,152,230,128,10,92,113,71,106,40,1,41,105,123,210,103,154,0,66,105,50,105,212,152,205,0,0,241,75,154,78,148,238,212,0,148,180,148,80,0,105,41,71,74,70,52,1,25,198,105,0,231,20,227,235,66,129,131,64,12,43,205,70,201,154,159,25,162,128,42,249,92,244,167,136,248,206,42,96,6,104,35,20,1,1,83,154,112,83,82,118,160,80,3,2,250,82,98,166,192,6,138,0,104,94,41,66,211,133,40,235,64,8,22,156,5,46,41,104,1,188,209,75,218,140,80,3,113,75,138,94,212,80,2,98,155,180,26,146,144,117,160,8,196,120,165,217,197,74,7,52,17,64,16,237,197,0,100,116,167,208,40,1,187,
41,219,120,167,116,164,160,6,227,20,211,78,166,147,205,0,4,113,239,73,245,165,205,39,122,4,29,232,52,103,52,148,192,66,41,13,47,106,105,233,64,7,29,104,56,163,20,30,212,0,189,105,64,161,121,167,1,64,10,5,60,10,104,165,205,0,127,255,217);

//.tj32 (transparent jpeg)
back_balls:array[0..42385] of byte=(
120,1,236,189,5,84,92,203,182,46,220,4,39,72,72,128,224,110,129,224,144,160,1,146,224,193,161,129,198,130,75,227,238,26,32,184,5,72,112,247,166,3,161,9,174,193,131,187,59,4,215,198,229,239,220,243,246,187,251,220,251,238,62,103,159,189,239,59,247,31,239,172,49,170,151,85,23,61,87,213,154,115,214,55,191,89,56,89,242,112,11,10,226,162,0,0,183,247,0,0,36,192,95,54,3,11,0,224,110,242,110,17,240,64,86,82,70,18,128,132,184,142,244,243,230,221,12,224,21,0,3,13,13,29,13,21,3,29,29,29,19,19,3,11,155,0,7,251,254,125,108,146,135,143,240,8,40,72,169,40,41,72,201,201,169,233,217,153,168,105,159,210,145,147,51,63,127,242,148,147,139,151,151,151,138,73,64,132,159,91,152,157,135,151,251,103,35,72,152,152,152,216,247,177,137,113,112,136,185,105,200,105,184,127,247,118,215,12,192,199,184,119,139,130,139,140,68,11,184,135,143,132,140,143,116,247,13,64,133,248,157,168,72,255,182,253,47,73,0,72,247,144,81,80,209,208,49,48,177,238,35,42,192,30,0,238,33,33,35,223,67,65,70,69,69,65,8,141,228,141,184,
15,64,193,71,125,72,195,37,142,246,72,217,0,157,214,158,128,219,63,54,11,131,238,101,121,11,161,202,208,1,61,143,161,67,0,38,22,209,99,98,18,82,6,70,38,230,39,44,188,124,207,158,243,11,8,190,122,45,33,41,37,45,35,171,170,166,14,212,208,212,2,25,25,155,152,154,153,91,88,58,58,57,187,184,186,185,123,4,190,11,10,14,121,31,26,22,23,255,33,33,49,233,227,167,228,236,156,220,188,252,130,194,162,226,138,47,149,176,170,175,213,53,181,173,109,223,218,59,58,187,186,123,134,71,70,199,198,39,38,167,166,151,150,87,86,215,214,55,126,108,110,29,30,29,159,192,79,207,206,47,46,127,202,133,4,64,254,139,88,136,207,191,72,246,31,228,194,71,200,117,15,5,5,25,5,253,167,92,72,247,92,127,10,142,143,130,74,195,133,246,80,92,25,221,192,254,17,45,183,63,6,193,203,216,172,242,22,76,58,30,149,3,66,67,135,33,44,34,122,222,37,134,195,159,162,253,155,100,127,159,96,1,255,144,100,255,91,176,127,151,107,26,128,141,140,132,232,60,100,124,128,40,0,94,203,156,93,79,55,138,197,156,237,247,175,242,175,103,240,175,49,
240,123,199,0,148,247,48,58,66,79,128,18,131,254,219,43,63,130,155,125,71,49,138,217,203,245,20,43,45,227,90,249,182,138,227,140,206,188,103,11,122,35,54,118,68,107,234,209,102,43,84,209,178,7,100,145,122,151,155,189,172,207,158,176,193,82,102,100,144,76,109,26,43,53,241,114,205,161,162,7,182,225,175,183,18,143,63,115,149,55,119,95,133,76,108,110,235,249,139,161,18,40,255,241,66,40,5,172,78,156,238,170,212,121,232,178,81,125,9,212,139,44,156,235,115,172,120,217,15,105,193,246,240,28,68,151,144,32,80,66,250,31,90,208,188,199,161,168,165,203,116,137,162,237,129,195,80,41,218,94,210,90,78,19,131,24,9,199,218,224,104,123,182,139,4,13,135,186,135,207,110,60,47,129,187,185,84,166,48,233,208,110,10,69,75,64,122,24,115,230,189,95,21,236,93,23,201,240,215,181,206,244,15,210,26,179,27,125,198,10,60,211,228,19,162,73,160,153,240,194,136,75,190,81,163,90,179,130,172,62,175,27,200,12,44,63,183,95,109,133,151,154,239,100,87,240,217,123,59,22,10,13,69,137,136,152,39,188,55,234,15,57,49,11,97,
34,202,186,24,232,16,106,22,243,199,80,235,162,210,183,233,176,19,162,72,174,234,97,54,99,43,227,124,254,211,149,75,141,129,116,242,10,79,136,140,190,69,135,163,254,75,11,162,93,112,158,118,235,10,118,73,156,8,183,227,141,101,250,162,110,118,216,19,128,178,4,193,31,42,221,134,50,57,92,93,117,31,224,132,20,13,169,68,223,42,101,2,220,250,61,213,78,254,64,15,74,240,125,3,110,97,151,17,80,126,42,66,194,206,250,16,128,209,69,215,0,96,251,51,6,222,239,109,195,125,63,252,154,188,162,68,209,166,230,253,173,185,55,222,215,6,15,66,2,164,227,200,137,16,14,235,217,119,170,209,150,222,209,193,182,236,38,250,92,10,34,219,11,123,188,117,100,249,115,124,149,86,83,244,49,156,138,19,20,22,131,22,85,192,201,35,72,14,10,121,128,164,180,168,170,194,14,174,84,235,60,110,212,56,65,186,1,76,81,162,147,93,52,179,108,249,79,120,254,127,176,255,144,122,183,15,103,249,78,213,158,205,2,114,79,54,167,97,39,154,171,81,157,15,141,141,87,141,61,113,125,18,188,135,116,12,70,57,79,232,120,183,0,204,217,97,191,
81,202,133,37,160,140,225,214,45,148,142,216,17,81,0,120,38,78,40,67,20,225,220,211,176,240,84,147,40,84,13,210,180,208,15,29,236,203,179,104,62,103,84,25,178,135,108,70,29,143,53,92,217,123,118,190,43,50,86,60,210,111,146,66,249,98,24,142,116,226,240,217,4,59,151,144,142,58,42,56,177,62,186,245,150,47,89,0,248,204,43,112,140,248,0,60,6,177,49,170,251,170,181,76,159,131,203,205,37,246,232,15,138,252,135,134,251,63,243,111,107,68,92,191,26,53,246,126,233,140,23,91,237,39,245,6,23,213,147,207,45,227,27,171,140,170,210,199,207,2,184,138,212,199,251,125,24,184,96,217,242,71,105,125,221,124,95,236,115,51,223,165,101,87,56,121,142,133,35,69,97,64,122,35,21,120,112,185,5,149,154,215,102,97,65,91,21,169,0,240,180,48,106,17,108,46,229,101,39,157,205,225,142,7,213,230,133,70,152,110,121,125,61,86,160,240,68,185,151,80,69,220,60,154,11,185,187,27,211,150,164,104,108,126,243,222,143,236,48,49,2,101,9,192,239,43,106,124,108,134,3,178,98,54,198,45,194,65,122,10,34,230,247,110,232,184,179,19,
13,9,197,186,233,23,145,244,244,151,57,66,105,140,220,32,61,29,239,222,6,9,48,29,66,5,106,15,215,70,35,90,180,62,123,111,229,96,202,25,211,253,120,118,72,20,23,130,227,225,119,131,119,174,118,90,11,11,218,9,16,242,252,224,74,71,237,192,115,49,209,251,152,146,161,41,241,101,171,228,245,214,92,82,248,190,117,18,234,204,49,132,146,210,165,90,151,74,13,13,155,27,131,142,127,57,177,209,109,232,150,186,63,190,200,157,68,122,15,151,75,175,36,235,252,104,248,2,159,93,26,219,109,62,99,212,199,91,148,165,71,217,126,214,204,68,130,155,36,167,58,200,36,180,173,163,141,38,196,195,155,250,143,250,29,79,22,44,185,52,139,247,81,190,56,1,70,19,93,99,231,219,27,95,112,181,160,195,204,182,65,198,73,65,198,225,232,200,216,232,250,208,6,249,220,205,93,19,124,110,239,227,102,146,31,204,200,178,191,178,16,191,182,22,255,45,199,53,25,132,110,214,206,230,148,110,73,78,153,94,221,55,251,246,251,187,11,23,39,163,74,232,253,130,233,129,174,22,118,29,244,252,3,6,90,249,100,103,214,65,160,198,232,234,193,
147,153,236,14,57,245,89,41,245,174,206,165,225,194,59,64,43,69,30,218,92,149,206,141,212,185,106,53,165,254,18,7,150,188,171,93,196,208,90,237,241,160,103,134,229,169,238,139,14,145,23,67,111,195,233,113,101,68,250,136,60,156,33,1,203,243,212,5,196,79,21,100,74,212,252,126,91,145,252,159,148,76,5,124,87,221,41,146,107,99,22,37,228,29,250,196,196,245,149,18,154,70,120,189,74,50,91,93,219,35,67,43,175,190,155,161,221,125,189,71,101,110,141,203,71,26,106,142,209,16,142,112,175,87,236,89,174,180,251,108,113,14,50,219,58,223,57,31,91,37,111,230,201,104,39,191,180,162,88,175,182,170,123,164,194,144,37,34,97,46,110,145,106,15,226,210,50,35,87,151,173,5,209,104,126,35,210,113,202,135,37,193,156,186,13,58,101,193,147,240,229,138,211,29,23,1,169,42,99,1,80,185,89,177,206,100,23,86,221,91,96,229,184,230,174,214,87,162,84,74,86,243,177,136,147,152,82,15,170,119,215,158,188,142,180,159,164,5,72,80,14,22,148,245,70,242,183,240,45,93,192,246,143,1,7,109,131,151,26,93,135,66,211,58,172,69,116,
104,13,209,205,148,236,248,9,50,184,107,6,176,9,209,194,51,170,21,205,177,188,222,226,73,243,83,172,39,132,9,163,220,159,77,232,168,3,99,36,216,12,57,179,195,152,1,255,47,20,40,209,249,39,104,23,251,122,36,21,245,195,240,192,14,244,60,79,138,217,59,128,233,151,100,175,194,201,160,224,189,79,157,132,199,207,35,161,194,55,226,73,34,91,155,157,201,50,24,235,106,149,199,68,54,50,16,176,156,215,74,88,150,25,165,244,114,45,25,179,99,216,124,253,110,54,74,56,176,170,166,147,16,138,154,40,37,171,205,138,184,189,0,171,236,34,215,160,254,254,173,252,52,95,198,200,127,184,246,93,249,74,158,20,95,34,186,44,96,185,204,170,60,157,149,104,111,134,100,185,46,188,78,199,44,108,3,106,125,121,40,217,108,159,100,103,36,172,242,227,242,67,178,247,150,193,123,18,200,253,201,242,228,150,52,23,89,140,29,112,85,188,106,52,43,195,15,111,174,69,121,163,221,75,247,160,40,151,200,237,29,161,232,227,125,93,103,119,244,214,186,78,158,151,153,233,226,42,34,146,162,221,80,253,178,103,165,59,74,127,150,149,80,
39,155,51,108,83,124,202,110,67,168,131,189,75,158,220,119,248,60,148,102,200,90,11,40,126,26,192,51,179,74,121,7,88,210,187,191,204,241,120,118,110,78,154,46,54,74,134,126,3,162,246,118,117,231,157,71,85,205,33,11,171,14,164,72,13,249,60,10,83,116,184,218,251,213,178,247,236,76,210,238,67,66,163,158,189,149,35,168,64,156,103,120,126,111,13,47,91,9,37,108,176,80,194,235,141,134,96,193,33,124,201,134,164,73,176,193,232,144,116,111,238,12,83,151,140,184,167,28,157,176,253,38,44,121,220,88,245,212,233,163,110,122,67,254,181,74,117,108,34,99,117,23,252,45,230,117,159,7,123,252,114,10,142,44,253,28,75,251,19,242,0,31,21,239,232,243,91,216,81,99,55,141,117,143,52,45,172,114,1,127,110,74,58,179,166,153,239,97,214,56,93,13,252,215,214,125,160,69,239,89,148,154,166,169,253,90,121,47,185,113,81,167,242,165,70,94,9,107,161,9,205,135,136,0,92,113,194,126,46,243,223,116,54,16,58,162,24,148,94,100,155,167,237,62,242,85,143,208,177,251,14,176,173,145,182,221,68,0,164,232,182,2,210,68,216,119,
95,35,52,212,59,232,103,202,52,250,242,214,186,188,88,101,15,132,23,98,172,239,86,32,251,57,38,55,126,191,83,149,18,227,250,88,143,176,248,90,166,190,142,236,205,240,139,23,123,235,76,132,221,243,110,81,167,63,142,233,144,224,144,156,144,212,80,7,233,179,62,141,101,221,84,124,206,42,36,109,97,33,78,38,42,69,208,90,238,121,131,93,169,216,39,251,219,229,59,64,144,219,104,146,99,239,89,174,209,249,168,112,58,172,222,46,124,151,219,187,192,104,90,116,201,78,231,14,48,96,114,7,104,2,223,18,248,182,46,214,220,1,210,183,239,0,62,19,215,172,237,135,146,44,141,69,184,203,167,209,229,39,104,241,135,202,38,49,100,137,90,143,178,116,80,111,36,156,199,41,159,15,67,185,26,34,94,167,215,204,2,110,125,243,188,242,43,186,50,156,223,151,140,95,246,173,213,144,153,240,83,194,83,63,71,239,148,23,135,23,193,231,32,112,216,17,143,246,155,10,212,197,21,152,38,244,227,73,6,229,28,136,219,38,214,95,53,198,113,184,110,142,108,57,53,74,153,254,35,63,69,46,201,192,40,252,6,156,174,182,70,49,100,81,80,190,
125,2,100,76,90,78,19,82,21,15,69,81,240,228,90,57,190,3,144,3,231,196,90,255,100,187,131,157,241,112,227,234,222,166,127,199,32,230,217,122,227,219,195,251,73,99,198,221,251,250,74,110,49,60,110,62,59,247,94,252,24,160,112,39,60,186,3,188,207,49,30,51,166,119,133,28,220,1,136,63,38,202,242,151,37,182,11,106,240,24,183,133,109,90,81,229,201,219,190,199,31,153,204,92,225,27,214,146,196,32,236,211,236,226,47,139,235,81,2,148,74,90,75,96,176,14,103,213,188,3,88,74,151,1,244,96,56,223,22,3,197,136,53,202,163,192,41,77,226,125,78,73,21,184,238,101,150,23,45,125,0,199,231,205,142,58,107,139,109,26,82,94,109,140,53,189,109,137,151,19,64,42,123,158,161,91,98,217,1,87,148,183,43,220,204,232,35,201,103,197,7,190,65,131,156,141,85,86,246,235,5,199,80,183,82,22,175,55,8,115,91,68,252,71,223,95,160,212,123,190,234,74,207,199,214,139,10,26,204,24,155,251,32,248,210,194,195,122,177,35,221,239,161,79,140,187,213,68,119,78,243,19,230,98,200,11,194,234,229,249,224,163,97,244,76,244,171,27,241,
58,223,148,42,35,107,106,24,147,253,250,158,152,110,240,65,192,182,169,246,186,81,163,57,198,10,43,212,149,155,237,230,18,70,233,99,30,211,35,252,203,176,204,10,132,114,163,47,126,166,30,193,247,185,107,83,185,33,244,164,12,98,229,182,169,44,99,212,41,155,242,153,127,170,244,242,80,43,137,168,186,172,127,125,0,112,168,57,1,156,28,32,132,8,66,184,120,77,54,65,169,211,206,195,49,223,176,39,234,221,200,218,237,117,102,32,149,71,94,144,51,25,97,154,59,0,178,30,146,51,218,176,244,182,118,58,254,56,101,63,92,57,213,63,3,52,94,74,144,36,136,226,45,33,97,106,14,242,27,117,234,90,237,177,85,134,5,28,70,43,8,249,144,251,178,140,148,41,7,253,87,83,42,71,74,186,67,239,170,72,242,114,26,52,19,226,167,210,173,25,91,150,208,8,97,13,162,36,228,87,216,165,241,52,23,159,180,145,55,219,221,208,223,11,75,60,203,18,2,108,216,88,110,142,56,186,188,180,233,152,8,173,183,183,247,102,13,74,248,152,254,252,81,28,56,56,121,89,107,246,75,57,253,136,128,81,156,69,207,39,168,36,65,142,188,185,241,76,76,243,
147,37,145,98,227,224,2,77,239,226,212,97,210,80,165,215,242,194,175,52,128,120,150,49,175,180,106,243,52,251,143,188,127,28,129,165,186,115,186,243,118,165,140,56,191,89,228,243,128,76,241,44,35,51,79,139,213,81,141,120,33,44,210,135,169,37,248,192,116,42,203,160,28,90,136,12,183,142,39,89,50,71,24,187,149,169,238,48,69,206,124,67,73,107,211,3,154,100,140,204,26,235,31,104,72,183,12,39,148,43,215,87,26,253,65,246,26,79,249,158,236,152,2,53,168,145,53,213,219,138,192,248,69,218,146,222,129,214,142,20,115,181,138,152,12,228,118,210,69,224,111,215,84,135,104,106,247,209,147,1,134,152,64,18,148,59,64,134,236,169,16,217,15,231,251,106,201,143,85,107,196,77,208,25,20,179,202,136,146,93,76,131,146,153,179,99,254,20,48,5,209,1,15,244,196,216,173,214,223,109,108,168,240,3,238,0,130,23,77,157,30,22,85,141,46,147,226,40,171,248,93,208,188,237,94,31,250,115,47,1,247,145,245,99,36,95,59,207,177,151,58,21,111,240,30,126,137,71,193,250,97,149,223,33,80,102,169,57,63,190,150,224,79,204,151,
103,97,63,146,252,3,114,191,36,139,14,86,81,189,217,103,51,163,187,136,11,126,15,171,235,16,128,184,113,184,145,79,80,247,119,115,184,109,43,247,122,198,142,215,172,53,53,111,191,137,187,154,247,227,152,155,67,78,7,103,52,84,147,31,203,57,122,166,30,107,78,104,104,13,240,50,216,177,204,247,34,78,172,176,39,144,164,28,129,101,123,130,199,192,235,231,249,13,183,153,33,228,166,117,212,13,169,2,159,56,84,199,111,137,55,173,73,162,20,8,50,231,29,55,71,46,17,138,50,97,43,33,104,73,94,232,74,84,70,167,16,237,13,126,75,63,250,155,241,93,7,17,217,63,234,144,255,252,62,51,248,57,237,136,76,117,76,196,26,86,148,253,168,97,163,201,161,245,138,142,165,66,93,5,18,52,91,216,130,85,98,105,10,43,142,123,145,220,149,152,239,152,177,132,38,73,37,38,3,52,131,11,21,10,221,97,75,213,162,11,251,241,52,179,159,191,52,156,129,92,67,206,48,141,63,15,164,241,54,82,142,213,202,191,221,102,70,107,21,151,37,45,194,40,138,53,247,203,187,7,252,165,146,64,109,74,65,181,71,83,111,41,89,243,228,236,191,230,169,
215,250,1,220,50,113,185,247,38,0,135,58,55,187,141,60,237,46,174,229,184,224,148,70,241,62,128,253,89,172,115,233,251,213,103,103,150,189,157,124,131,11,28,140,53,51,177,161,220,34,224,138,192,218,47,12,25,226,94,220,163,216,7,188,111,86,112,40,237,60,99,124,155,147,79,4,15,23,130,30,10,233,136,161,225,233,97,158,242,237,168,247,140,165,133,33,68,251,207,35,201,193,135,253,208,74,80,164,62,70,156,250,184,60,216,206,103,255,243,217,173,126,207,68,184,243,74,142,197,70,47,141,177,179,232,51,119,228,153,107,223,174,139,222,111,233,52,41,74,53,206,184,46,235,101,105,207,159,27,51,238,80,210,30,18,212,70,182,1,58,109,192,169,45,70,241,227,254,137,2,34,150,110,43,125,30,202,97,249,165,17,183,108,154,161,68,150,61,175,118,85,164,8,65,81,44,61,206,247,165,67,105,78,139,134,73,63,199,140,189,11,153,174,201,83,114,97,121,47,82,44,142,14,211,213,20,41,86,70,53,94,239,48,115,39,32,230,135,136,126,185,82,33,230,223,148,75,243,255,48,232,169,38,143,3,230,165,28,187,223,166,86,204,89,30,115,
112,165,238,26,92,69,73,101,9,161,215,27,171,180,196,234,224,141,85,195,254,8,209,162,45,142,107,223,213,85,74,235,54,15,30,95,151,147,9,204,193,15,212,171,91,212,39,175,199,125,63,144,186,200,253,168,13,239,240,12,74,233,220,46,111,228,202,144,214,90,91,78,204,91,162,162,78,56,190,90,208,179,227,29,98,225,142,122,114,159,23,151,68,186,95,40,186,176,104,187,183,145,210,173,220,248,117,128,133,168,203,57,202,163,214,140,125,223,232,59,0,168,65,178,126,28,146,85,248,71,245,253,47,223,87,23,145,147,15,84,171,52,103,36,22,109,61,95,83,188,216,213,96,206,196,75,187,182,88,210,178,182,161,55,192,7,170,118,181,219,133,237,35,239,190,149,100,221,218,181,125,21,168,245,149,229,92,75,93,26,216,137,62,121,229,27,233,86,16,46,140,35,82,250,253,53,131,118,153,224,161,246,112,137,173,139,54,102,78,68,192,190,127,159,121,187,103,20,60,68,36,114,44,37,166,107,214,83,13,236,212,219,178,56,30,151,157,87,42,225,88,244,248,218,57,215,115,79,112,130,159,35,146,78,47,126,254,203,101,29,69,95,40,84,
100,155,123,121,31,202,167,214,75,223,137,129,9,97,19,106,59,115,29,46,83,90,188,2,134,165,90,108,211,232,173,9,177,62,129,145,249,21,231,6,32,112,128,251,139,173,97,21,93,117,202,62,199,70,39,8,167,178,39,190,149,18,217,188,181,103,19,38,37,52,105,127,238,145,12,103,166,145,115,123,72,60,166,174,244,22,149,152,48,72,54,117,191,203,66,211,195,175,152,192,12,96,20,159,12,98,46,237,248,47,81,1,149,135,0,250,84,164,209,228,238,248,111,68,155,118,70,248,95,216,237,235,248,7,150,196,72,79,84,149,199,213,52,94,37,24,196,88,140,254,61,136,12,82,223,249,234,163,165,78,128,111,175,248,117,164,87,119,97,9,99,14,163,111,131,190,6,56,49,212,61,103,86,114,78,93,174,232,12,249,14,48,46,74,122,17,223,14,236,192,145,63,168,38,129,28,236,13,127,254,132,19,143,203,154,255,217,39,161,107,74,38,66,67,194,228,25,87,159,188,137,197,61,33,214,199,155,125,78,46,14,0,84,251,42,13,226,78,190,58,107,23,52,129,82,73,103,11,254,251,227,197,115,178,24,124,169,95,235,157,11,153,234,187,182,17,250,181,122,189,
38,229,148,124,28,50,215,239,216,231,56,241,5,190,238,199,101,27,13,218,176,113,143,167,204,175,178,53,217,214,252,145,15,110,87,226,233,115,81,2,106,48,164,183,29,228,97,187,62,224,177,123,97,16,191,151,223,16,86,127,181,148,159,177,6,114,159,68,54,52,42,16,16,189,205,209,11,212,129,204,205,102,254,71,244,85,205,241,123,226,160,240,48,57,45,118,114,92,245,2,213,118,198,84,173,235,84,51,178,199,62,83,147,79,250,7,164,245,5,252,122,160,173,13,189,152,253,36,179,64,243,9,148,217,80,183,151,18,238,169,209,0,158,153,112,112,236,83,149,232,134,202,70,190,144,190,248,36,115,204,117,152,111,121,162,60,106,151,167,23,38,152,28,207,70,51,36,165,65,23,62,253,62,103,83,35,59,172,186,128,59,88,10,7,36,237,93,108,190,124,90,98,223,182,171,229,175,69,125,90,244,154,114,204,25,177,27,199,179,4,244,95,137,194,104,190,158,66,20,233,166,99,90,118,197,72,112,80,197,14,60,129,189,45,234,171,1,126,92,244,33,211,197,221,120,48,107,25,60,152,106,34,135,165,197,36,182,150,97,177,67,251,120,149,73,52,
68,57,81,212,114,62,245,219,119,11,163,226,210,106,136,86,78,241,195,124,28,151,86,13,90,217,245,179,119,48,211,138,38,137,167,98,140,141,137,7,235,69,148,121,121,109,193,148,86,150,132,33,133,20,56,94,177,4,193,36,9,157,70,122,83,7,43,237,134,212,229,53,179,17,207,106,55,224,148,203,53,246,188,59,23,49,139,39,229,59,78,202,18,14,137,255,229,16,251,157,160,20,33,104,175,117,252,194,101,182,185,194,51,29,111,157,165,143,0,169,109,91,20,207,122,111,44,178,28,184,120,13,109,185,190,186,77,216,56,91,192,46,115,229,129,84,182,72,9,28,245,3,160,110,217,201,241,218,72,199,198,25,120,123,200,246,201,117,70,7,203,203,46,205,145,169,240,214,34,38,194,19,62,66,133,210,5,101,205,35,93,214,37,207,34,201,184,7,153,103,49,43,84,202,19,39,101,27,111,14,130,51,12,136,143,31,72,159,255,224,87,190,81,188,88,174,37,101,33,171,238,200,126,106,95,76,221,90,8,192,19,87,248,27,243,28,73,165,31,234,193,226,196,180,53,27,7,219,41,205,45,45,111,110,110,63,94,179,102,103,251,209,5,208,160,60,33,61,81,142,
134,200,252,157,248,253,132,68,220,179,200,14,117,127,20,143,64,61,252,195,71,98,230,123,235,92,57,214,146,212,15,5,58,45,207,146,219,14,159,5,39,183,7,26,72,165,145,166,98,155,217,157,192,47,125,225,155,237,83,115,72,71,245,111,12,62,148,216,135,77,85,34,28,2,205,195,103,254,108,145,189,130,52,51,201,45,1,139,89,45,139,19,58,113,37,100,217,46,66,172,218,245,70,201,19,1,103,254,125,246,74,186,43,228,227,17,26,147,20,224,56,37,243,28,168,246,173,224,168,195,130,243,122,77,139,111,39,200,42,105,138,194,82,108,184,166,161,223,189,84,187,46,117,35,57,216,243,251,70,114,111,77,237,118,31,24,203,230,13,59,247,158,215,122,165,48,71,126,195,122,230,187,34,58,190,20,19,19,246,44,135,226,98,233,62,79,95,191,122,218,216,236,94,238,7,97,220,157,163,119,0,87,209,13,56,164,88,230,165,112,161,92,205,204,185,173,162,54,14,35,199,135,144,88,113,27,79,151,27,129,107,176,94,172,26,75,144,210,61,127,63,116,113,57,157,156,255,232,59,60,72,43,150,233,7,12,32,243,45,250,62,132,239,87,206,246,228,68,
118,102,10,180,123,234,53,57,158,202,227,110,41,181,104,219,12,237,167,231,28,245,121,213,45,215,141,215,140,174,162,28,224,128,37,201,71,164,63,9,209,161,239,115,241,25,18,244,137,5,50,150,181,54,176,14,165,84,208,50,127,193,82,63,87,41,105,77,99,125,73,176,169,67,72,111,30,186,20,205,151,133,173,203,66,252,40,207,188,141,194,49,34,142,184,120,71,233,74,25,219,155,229,68,25,79,22,96,248,74,181,148,114,204,148,223,113,186,52,151,114,20,233,85,215,105,174,185,72,137,154,248,174,188,185,72,33,50,201,98,241,240,171,93,109,149,87,234,12,225,211,126,92,12,33,16,165,100,150,217,100,150,129,100,65,192,183,100,150,44,94,111,176,169,219,229,184,83,183,188,16,39,55,163,2,44,131,219,25,226,30,15,49,251,158,48,37,251,250,11,91,7,142,211,139,135,163,242,233,217,126,85,72,124,65,204,45,185,85,49,237,14,81,184,156,224,124,251,141,192,215,86,123,222,142,75,115,226,206,56,148,68,40,182,145,47,57,41,231,240,214,110,192,192,250,179,165,196,76,179,74,243,104,154,28,156,17,126,186,75,71,189,32,61,
229,63,205,36,254,98,26,255,155,246,72,221,110,95,91,171,46,131,82,6,176,45,75,209,251,253,221,232,70,61,60,239,0,169,231,46,95,151,88,195,101,72,134,112,89,55,183,250,198,120,133,68,128,220